# --
# Copyright (C) 2001-2021 OTRS AG, https://otrs.com/
# Copyright (C) 2021 Znuny GmbH, https://znuny.org/
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see https://www.gnu.org/licenses/gpl-3.0.txt.
# --

use strict;
use warnings;
use utf8;

use vars (qw($Self));

# get selenium object
my $Selenium = $Kernel::OM->Get('Kernel::System::UnitTest::Selenium');

$Selenium->RunTest(
    sub {

        my $HelperObject    = $Kernel::OM->Get('Kernel::System::UnitTest::Helper');
        my $SysConfigObject = $Kernel::OM->Get('Kernel::System::SysConfig');
        my $ConfigObject    = $Kernel::OM->Get('Kernel::Config');

        # create test user and login
        my $TestUserLogin = $HelperObject->TestUserCreate(
            Groups => ['admin'],
        ) || die "Did not get test user";

        # get script alias
        my $ScriptAlias = $ConfigObject->Get('ScriptAlias');

        $Selenium->Login(
            Type     => 'Agent',
            User     => $TestUserLogin,
            Password => $TestUserLogin,
        );

        # navigate to AdminSystemConfiguration screen
        $Selenium->VerifiedGet(
            "${ScriptAlias}index.pl?Action=AdminSystemConfiguration"
        );

        # Search for Frontend::RichText::Settings###FontSizes (setting with : and # to test encoding).
        $Selenium->find_element( '#SysConfigSearch', 'css' )->send_keys('Frontend::RichText::Settings###FontSizes');
        $Selenium->WaitFor(
            JavaScript => 'return $("ul.ui-autocomplete a:visible").length',
        );

        # Select autocomplete value.
        $Selenium->find_element( 'a.ui-menu-item-wrapper', 'css' )->VerifiedClick();

        # Check if bread crumb link is working.
        $Selenium->find_element( 'ul.BreadCrumb li:nth-child(5) a', 'css' )->VerifiedClick();

        # Check settings count.
        my $SettingCount = $Selenium->execute_script(
            'return $(".SettingsList li").length'
        );
        $Self->Is(
            $SettingCount,
            1,
            'Make sure there is just 1 setting listed',
        );

        my $SettingName = $Selenium->execute_script(
            'return $(".SettingEdit").data("name");'
        );
        $Self->Is(
            $SettingName,
            'Frontend::RichText::Settings###FontSizes',
            'Check if correct setting is listed.'
        );
    }
);

1;
