# --
# initial_insert.sql - provides initial system data
# Copyright (C) 2001,2002 Martin Edenhofer <martin+code@otrs.org>
# --
# $Id: initial_insert.sql,v 1.8 2002/04/08 14:17:40 martin Exp $
# 
# $Log: initial_insert.sql,v $
# Revision 1.8  2002/04/08 14:17:40  martin
# bin/PostMaster.pl
#
# Revision 1.7  2002/02/03 22:48:20  martin
# typo in welcome ticket.
#
# Revision 1.6  2002/02/03 17:58:45  martin
# added welcome ticket.
#
# Revision 1.5  2002/01/30 16:45:09  martin
# changed otrs@otrs.org to otrs@localhost
#
# Revision 1.4  2002/01/20 22:23:55  martin
# no note-normal anymore.
#
# Revision 1.3  2002/01/10 20:14:00  martin
# added cvs log.
#
#
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --

# table valid
INSERT INTO valid
    (name, create_by, change_by, change_time)
    VALUES
    ('valid', 1, 1, current_timestamp);
INSERT INTO valid
    (name, create_by, change_by, change_time)
    VALUES
    ('invalid', 1, 1, current_timestamp);
INSERT INTO valid
    (name, create_by, change_by, change_time)
    VALUES
    ('invalid-temporarily', 1, 1, current_timestamp);
 
# ticket_priority
INSERT INTO ticket_priority
        (name, create_by, change_by, change_time)
        VALUES
        ('very low', 1, 1, current_timestamp);
INSERT INTO ticket_priority
        (name, create_by, change_by, change_time)
        VALUES
        ('low', 1, 1, current_timestamp);
INSERT INTO ticket_priority
        (name, create_by, change_by, change_time)
        VALUES
        ('normal', 1, 1, current_timestamp);
INSERT INTO ticket_priority
        (name, create_by, change_by, change_time)
        VALUES
        ('high', 1, 1, current_timestamp);
INSERT INTO ticket_priority
        (name, create_by, change_by, change_time)
        VALUES
        ('very high', 1, 1, current_timestamp);

# ticket_lock_type
INSERT INTO ticket_lock_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('unlock', 1, 1, 1, current_timestamp);
INSERT INTO ticket_lock_type
    (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('lock', 1, 1, 1, current_timestamp);
INSERT INTO ticket_lock_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('tmp_lock', 1, 1, 1, current_timestamp);

# user 
INSERT INTO user
    (first_name, last_name, login, pw, comment, language_id, charset_id, theme_id, valid_id, create_by, change_by, change_time)
    VALUES
    ('Admin', 'OpenTRS', 'root@localhost', 'roK20XGbWEsSM', 'OpenTRS Admin', 1, 1, 1, 1, 1, 1, current_timestamp);
# only temp. FIXME!
##INSERT INTO user
##    (first_name, last_name, login, pw, comment, language_id, charset_id, theme_id, valid_id, create_by, change_by, change_time)
##    VALUES
##    ('Martin', 'Edenhofer', 'martin@edenhofer.de', 'maVqIYkzcYC2.', 'Lalli', 1, 1, 1, 1, 1, 1, current_timestamp);

# groups
INSERT INTO groups
    (name, valid_id, create_by, change_by, change_time)
    VALUES
    ('users',  1, 1, 1, current_timestamp);
INSERT INTO groups
    (name, valid_id, create_by, change_by, change_time)
    VALUES
    ('admin',  1, 1, 1, current_timestamp);

# group_user
INSERT INTO group_user
    (user_id, group_id, create_by, change_by, change_time)
    VALUES
    (1, 1, 1, 1, current_timestamp);
INSERT INTO group_user
    (user_id, group_id, create_by, change_by, change_time)
    VALUES
    (1, 2, 1, 1, current_timestamp);

# FIXME!!! only tmp.
##INSERT INTO group_user
##        (user_id, group_id, create_by, change_by, change_time)
##        VALUES
##        (2, 1, 1, 1, current_timestamp);
##INSERT INTO group_user
##        (user_id, group_id, create_by, change_by, change_time)
##        VALUES
##        (2, 2, 1, 1, current_timestamp);

# personal_queues
INSERT INTO personal_queues
    (user_id, queue_id, create_by, change_by, change_time)
    VALUES
    (2, 1, 1, 1, current_timestamp);

# language
INSERT INTO language
    (language, valid_id, create_by, change_by, change_time)
    VALUES
    ('English', 1, 1, 1, current_timestamp);
INSERT INTO language
    (language, valid_id, create_by, change_by, change_time)
    VALUES
    ('German', 1, 1, 1, current_timestamp);

# theme
INSERT INTO theme
    (theme, valid_id, create_by, change_by, change_time)
    VALUES
    ('Standard', 1, 1, 1, current_timestamp);
INSERT INTO theme
    (theme, valid_id, create_by, change_by, change_time)
    VALUES
    ('Lite', 1, 1, 1, current_timestamp);

# charset
INSERT INTO charset
        (name, charset, comment, valid_id, create_by, change_by, change_time)
        VALUES
        ('Latin-1', 'iso-8859-1', 'Western European languages.', 1, 1, 1, current_timestamp);
INSERT INTO charset
        (name, charset, comment, valid_id, create_by, change_by, change_time)
        VALUES
        ('Latin-2', 'iso-8859-2', 'Slavic and Central  European  languages.', 1, 1, 1, current_timestamp);
INSERT INTO charset
        (name, charset, comment, valid_id, create_by, change_by, change_time)
        VALUES
        ('Latin-3', 'iso-8859-3', 'Esperanto, Galician, Maltese, and Turkish.', 1, 1, 1, current_timestamp);
INSERT INTO charset
        (name, charset, comment, valid_id, create_by, change_by, change_time)
        VALUES
        ('Latin-4', 'iso-8859-4', 'Estonian, Latvian, and Lithuanian.', 1, 1, 1, current_timestamp);
INSERT INTO charset
        (name, charset, comment, valid_id, create_by, change_by, change_time)
        VALUES
        ('Cyrillic', 'iso-8859-5', 'Bulgarian, Byelorussian, Macedonian, Russian, Serbian  and  Ukrainian.', 1, 1, 1, current_timestamp);
INSERT INTO charset
        (name, charset, comment, valid_id, create_by, change_by, change_time)
        VALUES
        ('Unicode UTF-8', 'UTF-8', 'Unicode UTF-8', 1, 1, 1, current_timestamp);
INSERT INTO charset
        (name, charset, comment, valid_id, create_by, change_by, change_time)
        VALUES
        ('Turkish', 'iso-8859-9', 'Turkish.', 1, 1, 1, current_timestamp);

# ticket_state
INSERT INTO ticket_state (name, comment, valid_id, create_by, change_by, change_time)
    VALUES ('new', 'ticket is new', 1, 1, 1, current_timestamp);
INSERT INTO ticket_state (name, comment, valid_id, create_by, change_by, change_time)
    VALUES ('closed succsessful', 'ticket is closed succsessful', 1, 1, 1, current_timestamp);
INSERT INTO ticket_state (name, comment, valid_id, create_by, change_by, change_time)
    VALUES ('closed unsuccsessful', 'ticket is closed unsuccsessful', 1, 1, 1, current_timestamp);
INSERT INTO ticket_state (name, comment, valid_id, create_by, change_by, change_time)
    VALUES ('open', 'ticket is open', 1, 1, 1, current_timestamp);
INSERT INTO ticket_state (name, comment, valid_id, create_by, change_by, change_time)
    VALUES ('removed', 'customer removed ticket (can reactivate)', 1, 1, 1, current_timestamp);
INSERT INTO ticket_state (name, comment, valid_id, create_by, change_by, change_time)
    VALUES ('waiting_for_customer', 'waiting for customer', 1, 1, 1, current_timestamp);
INSERT INTO ticket_state (name, comment, valid_id, create_by, change_by, change_time)
    VALUES ('waiting_for_info', 'agent is waiting for info', 1, 1, 1, current_timestamp);
INSERT INTO ticket_state (name, comment, valid_id, create_by, change_by, change_time)
    VALUES ('waiting_for_reminder', 'ticket is waiting for agent reminder', 1, 1, 1, current_timestamp);
INSERT INTO ticket_state (name, comment, valid_id, create_by, change_by, change_time)
    VALUES ('waiting_for_closed+', 'ticket is waiting for automatic close', 1, 1, 1, current_timestamp);
INSERT INTO ticket_state (name, comment, valid_id, create_by, change_by, change_time)
    VALUES ('waiting_for_closed-', 'ticket is waiting for automatic close', 1, 1, 1, current_timestamp);

# salutation
INSERT INTO salutation
    (name, text, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('system standard salutation (en)', 'Dear Customer,

Thank you for your request.
', 'std. salutation', 1, 1, 1, current_timestamp);
INSERT INTO salutation
    (name, text, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('system standard salutation (de/buiss)', 'Sehr geehrter Kunde,

Danke fr Ihre Anfrage.
', 'std. salutation', 1, 1, 1, current_timestamp);

# signature
INSERT INTO signature
    (name, text, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('system standard signature (en)', '
Your OTRS-Team

 -
 <OTRS_FIRST_NAME> <OTRS_LAST_NAME> 
--
', 'std signature', 1, 1, 1, current_timestamp);
INSERT INTO signature
    (name, text, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('system standard signature (de/buiss)', '
Ihr OTRS Team

-- 
  <OTRS_FIRST_NAME> <OTRS_LAST_NAME> 
--
', 'std. signature', 1, 1, 1, current_timestamp);

# system_address
INSERT INTO system_address
    (value0, value1, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('otrs@localhost', 'OpenTRS System', 'Std. Address', 1, 1, 1, current_timestamp);
##INSERT INTO system_address
##    (value0, value1, comment, valid_id, create_by, change_by, change_time)
##    VALUES
##    ('martin@linuxatwork.de', 'Martin Edenhofer', 'Std. Address', 1, 1, 1, current_timestamp);

# follow_up_possible
INSERT INTO follow_up_possible
    (name, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('possible', 'Follow ups after closed(+|-) possible. Ticket will be reopen.', 1, 1, 1, current_timestamp);
INSERT INTO follow_up_possible
    (name, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('reject', 'Follow ups after closed(+|-) not possible. No new ticket will be created.', 1, 1, 1, current_timestamp);
INSERT INTO follow_up_possible
    (name, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('new ticket', 'Follow ups after closed(+|-) not possible. A new ticket will be created.', 1, 1, 1, current_timestamp);

# queue
INSERT INTO queue
    (name, group_id, system_address_id, salutation_id, signature_id, follow_up_id, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('Postmaster', 1, 1, 1, 1, 1, 'master queue', 1, 1, 1, current_timestamp);
INSERT INTO queue
    (name, group_id, system_address_id, salutation_id, signature_id, follow_up_id, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('Raw', 1, 1, 1, 1, 1, 'all incoming tickets', 1, 1, 1, current_timestamp);
INSERT INTO queue
    (name, group_id, system_address_id, salutation_id, signature_id, follow_up_id, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('Junk', 1, 1, 1, 1, 1, 'all junk tickets', 1, 1, 1, current_timestamp);
INSERT INTO queue
    (name, group_id, system_address_id, salutation_id, signature_id, follow_up_id, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('Misc', 1, 1, 1, 1, 1, 'all misk tickets', 1, 1, 1, current_timestamp);
INSERT INTO queue
    (name, group_id, system_address_id, salutation_id, signature_id, follow_up_id, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('TEST1', 1, 1, 1, 1, 1, 'all misk tickets', 1, 1, 1, current_timestamp);
INSERT INTO queue
    (name, group_id, system_address_id, salutation_id, signature_id, follow_up_id, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('TEST2', 1, 1, 1, 1, 1, 'all misk tickets', 1, 1, 1, current_timestamp);
INSERT INTO queue
    (name, group_id, system_address_id, salutation_id, signature_id, follow_up_id, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('TEST3', 1, 1, 1, 1, 1, 'all misk tickets', 1, 1, 1, current_timestamp);
INSERT INTO queue
    (name, group_id, system_address_id, salutation_id, signature_id, follow_up_id, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('TEST4', 1, 1, 1, 1, 1, 'all misk tickets', 1, 1, 1, current_timestamp);
INSERT INTO queue
    (name, group_id, system_address_id, salutation_id, signature_id, follow_up_id, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('TEST5', 1, 1, 1, 1, 1, 'all misk tickets', 1, 1, 1, current_timestamp);

# ticket_ticket_history_type
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('NewTicket', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('FollowUp', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('SendAutoReject', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('SendAutoReply', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('SendAutoFollowUp', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('SendAnswer', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('PhoneCallAgent', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('PhoneCallCustomer', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('Close succsessful', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('Close unsuccsessful', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('AddNote', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('Open', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('Reopen', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('Move', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('Lock', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('Unlock', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('WatingForReminder', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('WatingForClose+', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('WatingForClose-', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('Remove', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('StartWork', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('StopWork', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('CustomerUpdate', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('PriorityUpdate', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('OwnerUpdate', 1, 1, 1, current_timestamp);
INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('LoopProtection', 1, 1, 1, current_timestamp);

INSERT INTO ticket_history_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('Misc', 1, 1, 1, current_timestamp);


# article_type
INSERT INTO article_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('email', 1, 1, 1, current_timestamp);
INSERT INTO article_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('phone', 1, 1, 1, current_timestamp);
INSERT INTO article_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('fax', 1, 1, 1, current_timestamp);
INSERT INTO article_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('sms', 1, 1, 1, current_timestamp);
INSERT INTO article_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('webrequest', 1, 1, 1, current_timestamp);
# note-normal!
##INSERT INTO article_type
##        (name, valid_id, create_by, change_by, change_time)
##        VALUES
##        ('note-normal', 1, 1, 1, current_timestamp);
INSERT INTO article_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('note-internal', 1, 1, 1, current_timestamp);
INSERT INTO article_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('note-external', 1, 1, 1, current_timestamp);
INSERT INTO article_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('note-report', 1, 1, 1, current_timestamp);

# article_article_sender_type
INSERT INTO article_sender_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('agent', 1, 1, 1, current_timestamp);
INSERT INTO article_sender_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('system', 1, 1, 1, current_timestamp);
INSERT INTO article_sender_type
        (name, valid_id, create_by, change_by, change_time)
        VALUES
        ('customer', 1, 1, 1, current_timestamp);

# standard_response
INSERT INTO standard_response
        (name, text, valid_id, create_by, change_by, change_time)
        VALUES
        ('empty answer', '', 1, 1, 1, current_timestamp);
INSERT INTO standard_response
        (name, text, valid_id, create_by, change_by, change_time)
        VALUES
        ('test answer', 'test answer ...', 1, 1, 1, current_timestamp);

# queue_standard_response
INSERT INTO queue_standard_response
    (queue_id, standard_response_id, create_by, change_by, change_time)
    VALUES
    (1, 1, 1, 1, current_timestamp);

# auto_response_type
INSERT INTO auto_response_type
    (name, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('auto reply', 'auto replay after a new ticket.', 1, 1, 1, current_timestamp);
INSERT INTO auto_response_type
    (name, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('auto reject', 'auto reject.', 1, 1, 1, current_timestamp);
INSERT INTO auto_response_type
    (name, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('auto follow up', 'auto follow up after a follow up.', 1, 1, 1, current_timestamp);
INSERT INTO auto_response_type
    (name, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('auto reply/new ticket', 'auto reply after a follow up. Because the ticket is closed.', 1, 1, 1, current_timestamp);
INSERT INTO auto_response_type
    (name, comment, valid_id, create_by, change_by, change_time)
    VALUES
    ('auto remove', 'auto remove after a remove email.', 1, 1, 1, current_timestamp);

# auto_response
INSERT INTO auto_response
    (type_id, system_address_id, name, text0, text1, comment, valid_id, create_time, create_by, change_time, change_by)
    VALUES
    (1, 1, 'default reply', 'New Ticket created.', 'thank you for your email.', 'default', 1, current_timestamp, 1, current_timestamp, 1);
INSERT INTO auto_response
    (type_id, system_address_id, name, text0, text1, comment, valid_id, create_time, create_by, change_time, change_by)
    VALUES
    (2, 1, 'default reject', 'Reject.', 'thank you for your email. But you forgot importand infos. Pleace write again with all informations. Thanks', 'default', 1, current_timestamp, 1, current_timestamp, 1);
INSERT INTO auto_response
    (type_id, system_address_id, name, text0, text1, comment, valid_id, create_time, create_by, change_time, change_by)
    VALUES
    (3, 1, 'default follow up', 'Follow up received.', 'thank you for your email. We will answer your follow up ASAP.', 'default', 1, current_timestamp, 1, current_timestamp, 1);
INSERT INTO auto_response
    (type_id, system_address_id, name, text0, text1, comment, valid_id, create_time, create_by, change_time, change_by)
    VALUES
    (4, 1, 'default closed -> new ticket', 'New ticket after follow up.', 'thank you for your email. The old ticket is closed. You have a new ticket now.', 'default', 1, current_timestamp, 1, current_timestamp, 1);
INSERT INTO auto_response
    (type_id, system_address_id, name, text0, text1, comment, valid_id, create_time, create_by, change_time, change_by)
    VALUES
    (5, 1, 'default remove', 'Ticket removed.', 'thank you for your remove email. The ticket is closed.', 'default', 1, current_timestamp, 1, current_timestamp, 1);

# queue_auto_response
INSERT INTO queue_auto_response
    (queue_id, auto_response_id, create_by, change_by, change_time)
    VALUES
    (11, 1, 1, 1, current_timestamp);
INSERT INTO queue_auto_response
    (queue_id, auto_response_id, create_by, change_by, change_time)
    VALUES
    (11, 2, 1, 1, current_timestamp);

# faq
INSERT INTO faq
    (name, text, comment, language_id, valid_id, create_by, change_by, change_time)
    VALUES
    ('What is OpenTRS?', 'Open Ticket Request System ...', 'test fax', 1, 1, 1, 1, current_timestamp);
INSERT INTO faq
    (name, text, comment, language_id, valid_id, create_by, change_by, change_time)
    VALUES
    ('Was ist OpenTRS?', 'Open Ticket Request System ...', 'test faq', 2, 1, 1, 1, current_timestamp);


# --
# welcome ticket
# 2002-02-03 added by martin+code@otrs.org 
# --
INSERT INTO article VALUES (1,1,1,3,
  'OpenTRS Team <feedback@otrs.org>', '', 'OpenTRS <otrs@localhost>', '',
  'Welcome to OpenTRS!', '<007@localhost>',
  'Welcome to OpenTRS!\n\nthank you for installing OpenTRS. \n\nYou will find updates and patches at \nhttp://otrs.org/ . You can also take \nadvantage of our mailing lists: \nhttp://lists.otrs.org/ .\n\n\nYour OpenTRS Team \n=================\n',
  1012757943, '2002/02/3', NULL,NULL,NULL,NULL,NULL,NULL,1,
  20020203183903,1,20020203183903,1);

INSERT INTO ticket VALUES (1,'1010005',2,1,1,1,3,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
  NULL,1,1012757943,20020203183903,1,20020203183903,1);

INSERT INTO ticket_history VALUES (1,'New Ticket [1010005] created.',1,1,1,NULL,1,
  20020203183903,1,20020203183903,1);


