# --
# Kernel/Language/fi.pm - provides fi language translation
# Copyright (C) 2002 Antti Kmrinen <antti at seu.net>
# --
# $Id: fi.pm,v 1.9 2003/01/18 09:11:10 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::fi;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.9 $';
$VERSION =~ s/^.*:\s(\d+\.\d+)\s.*\$/$1/;
# --
sub Data {
    my $Self = shift;
    my %Param = @_;
    my %Hash = ();

    # $$START$$
    # Last translation Wed Jan 15 17:53:14 2003 by 

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D.%M.%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %T %Y';
    $Self->{DateInputFormat} = '%D.%M.%Y - %T';

    %Hash = (
    # Template: AAABase
      ' 2 minutes' => ' 2 Minuuttia',
      ' 5 minutes' => ' 5 Minuuttia',
      ' 7 minutes' => ' 7 Minuuttia',
      '10 minutes' => '10 Minuuttia',
      '15 minutes' => '15 Minuuttia',
      'AddLink' => 'Lis linkki',
      'AdminArea' => 'Yllpito',
      'all' => 'kaikki',
      'All' => 'Kaikki',
      'Attention' => 'Huomio',
      'Bug Report' => 'Lhet bugiraportti',
      'Cancel' => 'Peruuta',
      'Change' => 'Muuta',
      'change' => 'muuta',
      'change!' => 'muuta!',
      'click here' => 'klikkaa tst',
      'Comment' => 'Kommentti',
      'Customer' => 'Asiakas',
      'Customer info' => 'Tietoa asiakkaasta',
      'day' => 'piv',
      'days' => 'piv',
      'description' => 'Selitys',
      'Description' => 'Selitys',
      'Dispatching by email To: field.' => '',
      'Dispatching by selected Queue.' => '',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Ei toimi kyttjID:ll 1(jrjestelmtunnus). Tee uusia kyttji ',
      'Done' => 'Valmis',
      'end' => 'Loppuun',
      'Error' => 'Virhe',
      'Example' => 'Esimerkki',
      'Examples' => 'Esimerkit',
      'Facility' => '',
      'Feature not acitv!' => 'Ominaisuus ei kytss',
      'go' => 'mene',
      'go!' => 'mene!',
      'Group' => 'Ryhm',
      'Hit' => 'Hit',
      'Hits' => 'Hitit',
      'hour' => 'tunti',
      'hours' => 'tuntia',
      'Ignore' => 'Ohita',
      'invalid' => 'Virheellinen',
      'Invalid SessionID!' => 'Virheellinen SessionID',
      'Language' => 'Kieli',
      'Languages' => 'Kielet',
      'Line' => 'Rivi',
      'Lite' => 'Kevyt',
      'Login failed! Your username or password was entered incorrectly.' => '',
      'Logout successful. Thank you for using OTRS!' => 'Uloskirjautuminen onnistui. Kiitos kun kytit OTRS-jrjestelm',
      'Message' => 'Viesti',
      'minute' => 'minutti',
      'minutes' => 'minuuttia',
      'Module' => 'Moduuli',
      'Modulefile' => 'Moduulitiedosto',
      'Name' => 'Nimi',
      'New message' => 'Uusi viesti',
      'New message!' => 'Uusi viesti!',
      'No' => 'Ei',
      'no' => 'ei',
      'No suggestions' => 'Ei ehdotusta',
      'none' => 'ei mitn',
      'none - answered' => 'ei mitn - vastattu',
      'none!' => 'ei mitn!',
      'Off' => 'Pois',
      'off' => 'pois',
      'on' => 'pll',
      'On' => 'Pll',
      'Password' => 'Salasana',
      'Pending till' => 'Odottaa',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Vastaa thn viestiin saadaksesi se takaisin normaalille jonotuslistalle',
      'Please contact your admin' => 'Ota yhteytt yllpitjsi',
      'please do not edit!' => 'l muokkaa, kiitos!',
      'possible' => 'Kytss',
      'QueueView' => 'Jonotuslistankym',
      'reject' => 'Hylk',
      'replace with' => 'Korvaa',
      'Reset' => 'Tyhjenn',
      'Salutation' => 'Tervehdys',
      'Signature' => 'Allekirjoitus',
      'Sorry' => 'Anteeksi',
      'Stats' => 'Tilastot',
      'Subfunction' => 'Alifunktio',
      'submit' => 'lhet',
      'submit!' => 'lhet!',
      'Text' => 'Teksti',
      'The recommended charset for your language is %s!' => 'Suositeltava kirjainasetus kielellesi on %s',
      'Theme' => 'Ulkoasu',
      'There is no account with that login name.' => 'Kyttjtunnus tuntematon',
      'Timeover' => 'Vanhentuu',
      'top' => 'yls',
      'update' => 'pivit',
      'update!' => 'pivit!',
      'User' => 'Kyttj',
      'Username' => 'Kyttjnimi',
      'Valid' => 'Kytss',
      'Warning' => 'Varoitus',
      'Welcome to OTRS' => 'Tervetuloa kyttmn OTRS-jrjestelm',
      'Word' => 'Sana',
      'wrote' => 'kirjoittaa',
      'yes' => 'kyll',
      'Yes' => 'Kyll',
      'You got new message!' => 'Sinulla on uusi viesti!',
      'You have %s new message(s)!' => 'Sinulla on %s kpl uusia viesti!',
      'You have %s reminder ticket(s)!' => 'Sinulla on %s muistutettavaa viesti!',

    # Template: AAAMonth
      'Apr' => 'Huh',
      'Aug' => 'Elo',
      'Dec' => 'Jou',
      'Feb' => 'Hel',
      'Jan' => 'Tam',
      'Jul' => 'Hei',
      'Jun' => 'Kes',
      'Mar' => 'Maa',
      'May' => 'Tou',
      'Nov' => 'Mar',
      'Oct' => 'Loka',
      'Sep' => 'Syys',

    # Template: AAAPreferences
      'Custom Queue' => 'Valitsemasi jonotuslistat',
      'Follow up notification' => 'Ilmoitus jatkokysymyksist',
      'Frontend' => 'Kyttliittym',
      'Mail Management' => 'Osoitteiden hallinta',
      'Move notification' => 'Siirr ilmoitus',
      'New ticket notification' => 'Ilmoitus uusista viesteist',
      'Other Options' => 'Muita asetuksia',
      'Preferences updated successfully!' => 'Asetukset tallennettu onnistuneesti',
      'QueueView refresh time' => 'Jonotusnkymn pivitysaika',
      'Select your frontend Charset.' => 'Valitse kyttliittymn kirjaisinasetukset',
      'Select your frontend language.' => 'Valitse kyttliittymn kieli',
      'Select your frontend QueueView.' => 'Valitse kyttliittymsi jonotusnkym',
      'Select your frontend Theme.' => 'Valitse kyttliittymsi ulkoasu',
      'Select your QueueView refresh time.' => 'Valitse jonotusnkymn pivitysaika',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Lhet ilmoitus jatkokysymyksist, jos olen kyseisen tiketin omistaja',
      'Send me a notification if a ticket is moved into a custom queue.' => 'Lhet minulle ilmoitus, jos tikettej siirretn valitsemiini jonoihin',
      'Send me a notification if a ticket is unlocked by the system.' => 'Lhet minulle ilmoitus, jos jrjestelm poistaa tiketin lukituksen.',
      'Send me a notification if there is a new ticket in my custom queues.' => 'Lhet ilmoitus uusista tiketeist, jotka tulevat valitsemilleni jonotuslistoille',
      'Ticket lock timeout notification' => 'Ilmoitus tiketin lukituksen vanhenemisesta',

    # Template: AAATicket
      '1 very low' => '1 Erittin alhainen',
      '2 low' => '2 Alhainen',
      '3 normal' => '3 Normaali',
      '4 high' => '4 Kiireellinen',
      '5 very high' => '5 Erittin kiireellinen',
      'Action' => 'Hyvksy',
      'Age' => 'Ik',
      'Article' => 'Artikkeli',
      'Attachment' => 'Liitetiedosto',
      'Attachments' => 'Liitetiedostot',
      'Bcc' => 'Piilokopio',
      'Bounce' => 'Delekoi',
      'Cc' => 'Kopio',
      'Close' => 'Sulje',
      'closed successful' => 'Valmistui - Sulje',
      'closed unsuccessful' => 'Keskenerinen - Sulje',
      'Compose' => 'uusia viesti',
      'Created' => 'Luotu',
      'Createtime' => 'Luontiaika',
      'email' => 'shkpostiosoite',
      'eMail' => 'Shkpostiosoite',
      'email-external' => 'Shkposti - sisinen',
      'email-internal' => 'Shkposti - julkinen',
      'Forward' => 'Vlit',
      'From' => 'Lhettj',
      'high' => 'Kiireellinen',
      'History' => 'Historia',
      'If it is not displayed correctly,' => 'Jos tm ei ny oikein,',
      'Lock' => 'Lukitse',
      'low' => 'Alhainen',
      'Move' => 'Siirr',
      'new' => 'uusi',
      'normal' => 'Normaali',
      'note-external' => 'Huomautus - sisinen',
      'note-internal' => 'Huomautus - ulkoinen',
      'note-report' => 'Huomautus - raportti',
      'open' => 'avoin',
      'Owner' => 'Omistaja',
      'Pending' => 'Odottaa',
      'pending auto close+' => '',
      'pending auto close-' => '',
      'pending reminder' => '',
      'phone' => 'puhelimitse',
      'plain' => 'pelkk teksti',
      'Priority' => 'Prioriteetti',
      'Queue' => 'Jonotuslista',
      'removed' => 'poistettu',
      'Sender' => 'Lhettj',
      'sms' => 'tekstiviesti',
      'State' => 'Tila',
      'Subject' => 'Otsikko',
      'This is a' => 'Tm on',
      'This is a HTML email. Click here to show it.' => 'Tm shkposti on HTML-muodossa. Klikkaa tst katsoaksesi sit',
      'This message was written in a character set other than your own.' => 'Tm teksti on kirjoitettu eri kirjaisinasetuksilla kuin omasi',
      'Ticket' => 'Tiketti',
      'To' => 'Vastaanottaja',
      'to open it in a new window.' => 'avataksesi se uuteen ikkunaan.',
      'Unlock' => 'Poista lukitus',
      'very high' => 'Erittin kiireellinen',
      'very low' => 'Erittin alhainen',
      'View' => 'Katso',
      'webrequest' => 'web-pyynt',
      'Zoom' => 'Katso',

    # Template: AAAWeekDay
      'Fri' => 'Pe',
      'Mon' => 'Ma',
      'Sat' => 'La',
      'Sun' => 'Su',
      'Thu' => 'To',
      'Tue' => 'Ti',
      'Wed' => 'Ke',

    # Template: AdminAttachmentForm
      'Add attachment' => 'Lis liitetiedosto',
      'Attachment Management' => 'Liitetiedostojen hallinta',
      'Change attachment settings' => 'Muuta liitetiedostojen asetuksia',

    # Template: AdminAutoResponseForm
      'Add auto response' => 'Lis automaattivastaus',
      'Auto Response From' => 'Automaattivastaus ',
      'Auto Response Management' => 'Automaattivastausten hallinta',
      'Change auto response settings' => 'Muuta automaattivastausten asetuksia',
      'Charset' => 'Kirjaisinasetus',
      'Note' => 'Huomautus',
      'Response' => 'Vastaa',
      'to get the first 20 character of the subject' => 'nhdksesi ensimmiset 20 kirjainta otsikosta',
      'to get the first 5 lines of the email' => 'nhdksesi 5 ensimmist rivi shkpostista',
      'to get the from line of the email' => 'nhdksesi yhden rivin shkpostista',
      'to get the realname of the sender (if given)' => 'nhdksesi kyttjn nimen',
      'to get the ticket number of the ticket' => 'nhdksesi tiketin numeron',
      'Type' => 'Tyyppi',
      'Useable options' => 'Kytettvt asetukset',

    # Template: AdminCharsetForm
      'Add charset' => 'Lis kirjaisinasetus',
      'Change system charset setting' => 'Muuta kirjaisinasetuksia',
      'System Charset Management' => 'Jrjestelmn kirjaisinasetusten hallinta',

    # Template: AdminCustomerUserForm
      'Add customer user' => 'Lis asiakas-kyttj',
      'Change customer user settings' => 'Muuta asiakas-kyttjn asetuksia',
      'Customer User Management' => 'Asiakas-kyttjien hallinta',
      'Customer user will be needed to to login via customer panels.' => 'Asiakas-kyttjn pit kirjautua Asiakas-liittymst',

    # Template: AdminCustomerUserGeneric

    # Template: AdminCustomerUserPreferencesGeneric

    # Template: AdminEmail
      'Admin-Email' => 'Yllpidon shkposti',
      'Body' => 'Runko-osa',
      'OTRS-Admin Info!' => '',
      'Recipents' => 'Vastaanottajat',

    # Template: AdminEmailSent
      'Message sent to' => 'Viesti lhetetty, vastaanottaja: ',

    # Template: AdminGroupForm
      'Add group' => 'Lis ryhm',
      'Change group settings' => 'Muuta ryhmn asetuksia',
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Lis uusi kyttjryhm, ett voit mritell kyttoikeuksia useammille eri tukiryhmille (Huolto, Ostot, Markkinointi jne.)',
      'Group Management' => 'Ryhmien hallinta',
      'It\'s useful for ASP solutions.' => 'Tm on hydyllinen ASP-kytss',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'Admin-ryhmn jsenet psevt yllpito- ja tilastoalueille.',

    # Template: AdminLanguageForm
      'Add language' => 'Lis kieli',
      'Change system language setting' => 'Muokkaa jrjestelmn kieliasetuksua',
      'System Language Management' => 'Jrjestelmn kielen hallinta',

    # Template: AdminLog
      'System Log' => 'Jrjestelmlogi',

    # Template: AdminNavigationBar
      'AdminEmail' => 'Yllpidon shkposti',
      'AgentFrontend' => 'Tukinkym',
      'Auto Response <-> Queue' => 'Automaattivastaukset <-> Jonotuslista',
      'Auto Responses' => 'Automaattivastaukset',
      'Charsets' => 'Kirjaisinasetus',
      'Customer User' => 'Asiakas-kyttj',
      'Email Addresses' => 'Shkpostiosoitteet',
      'Groups' => 'Ryhmt',
      'Logout' => 'Kirjaudu ulos',
      'Misc' => 'Muut',
      'POP3 Account' => 'POP3 -tunnus',
      'Responses' => 'Vastaukset',
      'Responses <-> Queue' => 'Vastaukset <-> Jonotuslista',
      'Select Box' => 'Suodatus',
      'Session Management' => 'Istuntojen hallinta',
      'Status defs' => 'Tikettien tilamritykset',
      'System' => 'Jrjestelm',
      'User <-> Groups' => 'Kyttj <-> Ryhmt',

    # Template: AdminPOP3Form
      'Add POP3 Account' => 'Lis POP3 -tunnus',
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Kaikki saapuvat shkpostit lhetetn valitulle jonotuslistalle',
      'Change POP3 Account setting' => 'Muuta POP3 -asetuksia',
      'Dispatching' => '',
      'Host' => 'Palvelin',
      'If your account is trusted, the x-otrs header (for priority, ...) will be used!' => '',
      'Login' => 'Kyttjtunnus',
      'POP3 Account Management' => 'POP3 -tunnusten hallinta',
      'Trusted' => 'Hyvksytty',

    # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Response Management' => 'Jonotuslista <-> Automaattivastaushallinta',

    # Template: AdminQueueAutoResponseTable

    # Template: AdminQueueForm
      '0 = no escalation' => '0 = ei vanhentumisaikaa',
      '0 = no unlock' => '0 = ei lukituksen poistumista',
      'Add queue' => 'Lis jonotuslista',
      'Change queue settings' => 'Muuta jonotuslistan asetuksia',
      'Escalation time' => 'Maksimi ksittelyaika',
      'Follow up Option' => 'Seuranta-asetukset',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => '',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => '',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => '',
      'Key' => 'Key',
      'Queue Management' => 'Jonotuslistan Hallinta',
      'Systemaddress' => 'Jrjestelmn osoite',
      'The salutation for email answers.' => '',
      'The signature for email answers.' => 'Allekirjoitus shkpostiosoitteeseen',
      'Ticket lock after a follow up' => '',
      'Unlock timeout' => 'Aika lukituksen poistumiseen',
      'Will be the sender address of this queue for email answers.' => '',

    # Template: AdminQueueResponsesChangeForm
      'Change %s settings' => 'Muuta %s asetuksia',
      'Std. Responses <-> Queue Management' => 'Oletusvastaukset <-> Jonotuslista',

    # Template: AdminQueueResponsesForm
      'Answer' => 'Vastaus',
      'Change answer <-> queue settings' => 'Vaihda vastaus <-> Jonotuslista',

    # Template: AdminResponseAttachmentChangeForm
      'Std. Responses <-> Std. Attachment Management' => '',

    # Template: AdminResponseAttachmentForm
      'Change Response <-> Attachment settings' => 'Muokkaa vastauksia <-> Liitetiedostojen hallinta',

    # Template: AdminResponseForm
      'A response is default text to write faster answer (with default text) to customers.' => 'Vastauspohja on oletusteksti, jonka avulla voit nopeuttaa vastaamista asiakkaille',
      'Add response' => 'Lis vastauspohja',
      'Change response settings' => 'Muuta vastauspohjan asetuksia',
      'Don\'t forget to add a new response a queue!' => 'l unohda list uutta vastauspohjaa jonotuslistalle.',
      'Response Management' => 'Vastauspohjien hallinta',

    # Template: AdminSalutationForm
      'Add salutation' => 'Lis tervehdys',
      'Change salutation settings' => 'Muuta tervehdysasetuksia',
      'customer realname' => 'kyttjn oikea nimi',
      'Salutation Management' => 'Tervehdysten hallinta',

    # Template: AdminSelectBoxForm
      'Max Rows' => 'Max. rivimr',

    # Template: AdminSelectBoxResult
      'Limit' => 'Rajoitus',
      'Select Box Result' => 'Suodatustuloksia',
      'SQL' => 'SQL',

    # Template: AdminSession
      'kill all sessions' => 'Tapa kaikki istunnot',

    # Template: AdminSessionTable
      'kill session' => 'Tapa istunto',
      'SessionID' => 'SessionID',

    # Template: AdminSignatureForm
      'Add signature' => 'Lis allekirjoitus',
      'Change signature settings' => 'Muuta allekirjoitusasetuksia',
      'for agent firstname' => 'ksittelijn etunimi',
      'for agent lastname' => 'ksittelijn sukunimi',
      'Signature Management' => 'Allekirjoitusten hallinta',

    # Template: AdminStateForm
      'Add state' => 'Lis uusi tila',
      'Change system state setting' => 'Muuta tiketin tila-asetuksia',
      'System State Management' => 'Tilamahdollisuuksien mrittminen',

    # Template: AdminSystemAddressForm
      'Add system address' => 'Lis jrjestelmn shkpostiosoite',
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Alle eingehenden Emails mit dem "To:" werden in die ausgewhlte Queue einsortiert.',
      'Change system address setting' => 'Muuta jrjestelmn shkpostiasetuksia',
      'Email' => 'Shkposti',
      'Realname' => 'Nimi',
      'System Email Addresses Management' => 'Shkpostiosoitteiden mritys',

    # Template: AdminUserForm
      'Add user' => 'Lis kyttj',
      'Change user settings' => 'Vaihda kyttjn asetuksia',
      'Don\'t forget to add a new user to groups!' => 'l unohda list kyttj ryhmiin!',
      'Firstname' => 'Etunimi',
      'Lastname' => 'Sukunimi',
      'User Management' => 'Kyttjhallinta',
      'User will be needed to handle tickets.' => 'Kyttj tarvitaan tikettien ksittelemiseen.',

    # Template: AdminUserGroupChangeForm
      'Change  settings' => '',
      'User <-> Group Management' => 'Kyttj <-> Ryhmhallinta',

    # Template: AdminUserGroupForm
      'Change user <-> group settings' => 'Vaihda kyttj <-> Ryhmhallinta',

    # Template: AdminUserPreferencesGeneric

    # Template: AgentBounce
      'A message should have a To: recipient!' => 'Viestiss pit olla vastaanottaja!',
      'Bounce ticket' => 'Delekoi tiketti',
      'Bounce to' => 'Delekoi',
      'Inform sender' => '',
      'Next ticket state' => 'Uusi tiketin status',
      'Send mail!' => 'Lhet shkposti!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Laita vastaanottajakenttn shkpostiosoite!',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further inforamtions.' => 'Shkposti, tikettinumero "<OTRS_TICKET>" on vlitetty osoitteeseen: "<OTRS_BOUNCE_TO>" . Ota yhteytt kyseiseen osoitteeseen saadaksesi listietoja',

    # Template: AgentClose
      ' (work units)' => '',
      'Close ticket' => 'Sulje tiketti',
      'Close type' => 'Sulkemisen syy',
      'Close!' => 'Sulje!',
      'Note Text' => 'Huomautusteksti',
      'Note type' => 'Viestityyppi',
      'store' => 'tallenna',
      'Time units' => 'Aikayksikt',

    # Template: AgentCompose
      'A message should have a subject!' => 'Viestiss pit olla otsikko!',
      'Attach' => 'Liite',
      'Compose answer for ticket' => 'Lhet vastaus tikettiin',
      'for pending* states' => '',
      'Is the ticket answered' => '',
      'Options' => 'Asetukset',
      'Pending Date' => 'Odotuspiv',
      'Spell Check' => 'Oikeinkirjoituksen tarkistus',

    # Template: AgentCustomer
      'Back' => 'Takaisin',
      'Change customer of ticket' => 'Vaihda tiketin asiakasta',
      'Set customer id of a ticket' => 'Aseta tiketin asiakasnumero#',

    # Template: AgentCustomerHistory
      'Customer history' => 'Asiakkaan historiatiedot',

    # Template: AgentCustomerHistoryTable

    # Template: AgentCustomerView
      'Customer Data' => '',

    # Template: AgentForward
      'Article type' => 'Huomautustyyppi',
      'Date' => 'Pivmr',
      'End forwarded message' => 'Vlitetyn viestin loppu',
      'Forward article of ticket' => 'Vlit tiketin artikkeli',
      'Forwarded message from' => 'Vlitetty viesti. Lhettj:',
      'Reply-To' => 'Lhet vastaus',

    # Template: AgentHistoryForm
      'History of' => '',

    # Template: AgentMailboxNavBar
      'All messages' => 'Kaikki viestit',
      'CustomerID' => 'AsiakasID#',
      'down' => 'loppuun',
      'Mailbox' => 'Saapuneet',
      'New' => 'Uusi',
      'New messages' => 'Uusia viestej',
      'Open' => 'Avaa',
      'Open messages' => 'Avaa viesti',
      'Order' => 'Jrjestys',
      'Pending messages' => 'Odottavat viestit',
      'Reminder' => 'Muistuttaja',
      'Reminder messages' => 'Muistutettavat viestit',
      'Sort by' => 'Jrjest',
      'Tickets' => 'Tiketit',
      'up' => 'alkuun',

    # Template: AgentMailboxTicket
      'Add Note' => 'Lis huomautus',

    # Template: AgentNavigationBar
      'FAQ' => 'FAQ/UKK',
      'Locked tickets' => 'Lukitut tiketit',
      'new message' => 'uusi viesti',
      'PhoneView' => 'Puhelu / Uusi tiketti',
      'Preferences' => 'Kyttjasetukset',
      'Utilities' => 'Etsi',

    # Template: AgentNote
      'Add note to ticket' => 'Lis huomautus thn tikettiin',
      'Note!' => '',

    # Template: AgentOwner
      'Change owner of ticket' => 'Muuta tmn tiketin omistajaa',
      'Message for new Owner' => '',
      'New user' => 'Uusi kyttj',

    # Template: AgentPending
      'Pending date' => '',
      'Pending type' => '',
      'Set Pending' => '',

    # Template: AgentPhone
      'Customer called' => 'Asiakas soitti',
      'Phone call' => 'Puhelut',
      'Phone call at %s' => 'Puhelu %s',

    # Template: AgentPhoneNew
      'new ticket' => 'Uusi tiketti',

    # Template: AgentPlain
      'ArticleID' => '',
      'Plain' => 'Pelkk teksti',
      'TicketID' => 'TikettiID',

    # Template: AgentPreferencesCustomQueue
      'Select your custom queues' => 'Valitse erityinen jonotuslista',

    # Template: AgentPreferencesForm

    # Template: AgentPreferencesGeneric

    # Template: AgentPreferencesPassword
      'Change Password' => 'Vaihda salasana',
      'New password' => 'Uusi salasana',
      'New password again' => 'Kirjoita salasana uudelleen',

    # Template: AgentPriority
      'Change priority of ticket' => 'Muuta prioriteetti',
      'New state' => 'Uusi tila',

    # Template: AgentSpelling
      'Apply these changes' => 'Hyvksy muutokset',
      'Discard all changes and return to the compose screen' => 'Hylk muutokset ja palaa viestin kirjoitusikkunaan',
      'Return to the compose screen' => 'Palaa viestin kirjoitusikkunaan',
      'Spell Checker' => 'Oikeinkirjoituksen tarkistus',
      'spelling error(s)' => 'Kirjoitusvirheit',
      'The message being composed has been closed.  Exiting.' => '',
      'This window must be called from compose window' => '',

    # Template: AgentStatusView
      'D' => 'A',
      'sort downward' => 'Jrjest laskevasti',
      'sort upward' => 'Jrjest nousevasti',
      'Ticket limit:' => 'Tikettien max mr',
      'Ticket Status' => 'Tiketin tilatieto',
      'U' => 'Y',

    # Template: AgentStatusViewTable

    # Template: AgentStatusViewTableNotAnswerd

    # Template: AgentTicketLocked
      'Ticket locked!' => 'Tiketti lukittu!',
      'unlock' => 'poista lukitus',

    # Template: AgentTicketPrint
      'by' => '',

    # Template: AgentTicketPrintHeader
      'Accounted time' => '',
      'Escalation in' => 'Vanhenee',
      'printed by' => '',

    # Template: AgentUtilSearchByCustomerID
      'Customer history search' => 'Asiakashistoriahaku',
      'Customer history search (e. g. "ID342425").' => 'Asiakashistoriahaku (Esim. "ID342425").',
      'No * possible!' => 'Jokerimerkki (*) ei kytss !',

    # Template: AgentUtilSearchByText
      'Article free text' => '',
      'Fulltext search' => 'Tekstihaku',
      'Fulltext search (e. g. "Mar*in" or "Baue*" or "martin+hallo")' => 'Tekstihaku("Etsi esimerkiksi "Mi*a" tai "Petr+Tekrat"',
      'Search in' => 'Etsi seuraavista:',
      'Ticket free text' => 'Etsi koko tiketist',
      'With State' => '',

    # Template: AgentUtilSearchByTicketNumber
      'search' => 'Etsi',
      'search (e. g. 10*5155 or 105658*)' => 'etsi tikettinumerolla (Esim. 10*5155 or 105658*)',

    # Template: AgentUtilSearchNavBar
      'Results' => 'Hakutulokset',
      'Site' => 'Palvelin',
      'Total hits' => 'Hakutuloksia yhteens',

    # Template: AgentUtilSearchResult

    # Template: AgentUtilTicketStatus
      'All open tickets' => 'Kaikki avoimet tiketit',
      'open tickets' => 'avoimet tiketit',
      'Provides an overview of all' => '',
      'So you see what is going on in your system.' => '',

    # Template: CustomerCreateAccount
      'Create' => 'Luo',
      'Create Account' => 'Luo tunnus',

    # Template: CustomerError
      'Backend' => '',
      'BackendMessage' => '',
      'Click here to report a bug!' => 'Klikkaa tst lhettksesi bugiraportti!',
      'Handle' => '',

    # Template: CustomerFooter
      'Powered by' => '',

    # Template: CustomerHeader
      'Contact' => 'Yhteystiedot',
      'Home' => 'Koti',
      'Online-Support' => 'Online-tuki',
      'Products' => 'Tuotteet',
      'Support' => 'Tuki',

    # Template: CustomerLogin

    # Template: CustomerLostPassword
      'Lost your password?' => 'Unohditko salasanan?',
      'Request new password' => 'Pyyd uutta salasanaa',

    # Template: CustomerMessage
      'Follow up' => 'Ilmoitukset',

    # Template: CustomerMessageNew

    # Template: CustomerNavigationBar
      'Create new Ticket' => 'Luo uusi tiketti',
      'My Tickets' => 'Minun tikettini',
      'New Ticket' => 'Uusi tiketti',
      'Ticket-Overview' => 'Tiketin katselu',
      'Welcome %s' => 'Tervetuloa %s',

    # Template: CustomerPreferencesForm

    # Template: CustomerPreferencesGeneric

    # Template: CustomerPreferencesPassword

    # Template: CustomerStatusView
      'of' => '',

    # Template: CustomerStatusViewTable

    # Template: CustomerTicketZoom

    # Template: CustomerWarning

    # Template: Error

    # Template: Footer

    # Template: Header

    # Template: InstallerStart
      'next step' => 'Seuraava',

    # Template: InstallerSystem
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '',
      '(Email of the system admin)' => 'Yllpitjn shkpostiosoite',
      '(Full qualified domain name of your system)' => '',
      '(Logfile just needed for File-LogModule!)' => '',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '',
      '(Used default language)' => 'Oletuskieli',
      '(Used log backend)' => '',
      '(Used ticket number format)' => 'Tikettinumeroiden oletusformaatti',
      'CheckMXRecord' => '',
      'Default Charset' => 'Oletuskirjaisinasetus',
      'Default Language' => 'Oletuskieli',
      'Logfile' => 'Logitiedosto',
      'LogModule' => '',
      'Organization' => 'Organisaatio',
      'System FQDN' => '',
      'SystemID' => '',
      'Ticket Hook' => '',
      'Ticket Number Generator' => '',
      'Webfrontend' => 'Webnkym',

    # Template: Login

    # Template: LostPassword

    # Template: NoPermission
      'No Permission' => 'Ei kyttoikeutta',

    # Template: Notify
      'Info' => 'Info',

    # Template: PrintFooter
      'URL' => '',

    # Template: PrintHeader
      'Print' => '',

    # Template: QueueView
      'All tickets' => 'Tikettej yhteens',
      'Queues' => 'Jonotuslista',
      'Show all' => 'Yhteens',
      'Ticket available' => 'Tikettej avoinna',
      'tickets' => 'tiketti',
      'Tickets shown' => 'Tikettej nkyviss',

    # Template: SystemStats
      'Graphs' => 'Grafiikat',

    # Template: Test
      'OTRS Test Page' => 'OTRS - Testisivu',

    # Template: TicketEscalation
      'Ticket escalation!' => 'Tiketin maksimi hyvksyttv ksittelyaika!',

    # Template: TicketView
      'Change queue' => 'Vaihda jonotuslistaa',
      'Compose Answer' => 'Vastaa',
      'Contact customer' => 'Ota yhteytt asiakkaaseen',
      'phone call' => 'Puhelut',

    # Template: TicketViewLite

    # Template: TicketZoom

    # Template: TicketZoomNote

    # Template: TicketZoomSystem

    # Template: Warning

    # Misc
      '(Click here to add a group)' => '(Klikkaa tst luodaksesi ryhmn)',
      '(Click here to add a queue)' => '(Klikkaa tst tehdksesi uuden jonotuslistan)',
      '(Click here to add a response)' => '(Klikkaa tst listksesi vastauspohjan)',
      '(Click here to add a salutation)' => '(Klikkaa tst listksesi tervehdyksen)',
      '(Click here to add a signature)' => '(Klikkaa tlt listksesi allekirjoituksen)',
      '(Click here to add a system email address)' => '(Klikkaa tst listksesi jrjestelmn shkpostiosoitteen)',
      '(Click here to add a user)' => '(Klikkaa tst listksesi kyttjn',
      '(Click here to add an auto response)' => '(Klikkaa tst listksesi automaattivastauksen)',
      '(Click here to add charset)' => 'Klikkaa tst listksesi kirjaisinasetuksen',
      '(Click here to add language)' => '(Klikkaa tst listksesi uusi kieli)',
      '(Click here to add state)' => '(Klikkaa tst listksesi uusi status)',
      'A message should have a From: recipient!' => '',
      'New ticket via call.' => 'Uusi ',
      'Time till escalation' => 'Aikaa jljell maksimi ksittelyaikaan',
      'Update auto response' => 'Pivit automaattivastaukset',
      'Update charset' => 'Pivit kirjaisinasetukset',
      'Update group' => 'Pivit ryhmtiedot',
      'Update language' => 'Pivit kieli',
      'Update queue' => 'Pivit jonotuslista',
      'Update response' => 'Pivit vastauspohja',
      'Update salutation' => 'Pivit tervehdys',
      'Update signature' => 'Pivit allekirjoitus',
      'Update state' => 'Pivit status',
      'Update system address' => 'Pivit jrjestelmn shkpostiosoitetta',
      'Update user' => 'Pivit kyttjtiedot',
      'You have to be in the admin group!' => 'Sinun tytyy olla admin -ryhmss!',
      'You have to be in the stats group!' => 'Sinun tytyy olla stats -ryhmss',
      'You need a email address (e. g. customer@example.com) in From:!' => 'Lhettj -kentss pit olla shkpostiosoite (esim. teppo.testi@esimerkki.fi)',
      'auto responses set' => '',
    );

    # $$STOP$$

    $Self->{Translation} = \%Hash;
}
# --
1;
