# --
# Kernel/Language/cz.pm - provides cz language translation
# Copyright (C) 2003 Lukas Vicanek alias networ <lulka at centrum dot cz>
# --
# $Id: cz.pm,v 1.7 2004/02/10 00:18:37 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::cz;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.7 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;
    my %Hash = ();

    # $$START$$
    # Last translation Tue Feb  3 00:41:12 2004 by 

    # possible charsets
    $Self->{Charset} = ['windows-1250', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D/%M/%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %Y %T';
    $Self->{DateInputFormat} = '%D/%M/%Y';
    $Self->{DateInputFormatLong} = '%D/%M/%Y - %T';

    %Hash = (
    # Template: AAABase
      ' 2 minutes' => ' 2 minuty',
      ' 5 minutes' => ' 5 minut',
      ' 7 minutes' => ' 7 minut',
      '(Click here to add)' => '',
      '10 minutes' => '10 minut',
      '15 minutes' => '15 minut',
      'AddLink' => 'Pidat odkaz',
      'Admin-Area' => 'Administran zna',
      'agent' => 'operator',
      'Agent-Area' => '',
      'all' => 've',
      'All' => 'Ve',
      'Attention' => 'Upozornn',
      'before' => '',
      'Bug Report' => 'Upozornn na chybu',
      'Cancel' => 'Zruit',
      'change' => 'zmnit',
      'Change' => 'Zmnit',
      'change!' => 'Zmnit!',
      'click here' => 'kliknte zde',
      'Comment' => 'Koment',
      'Customer' => 'Klient',
      'customer' => 'Klient',
      'Customer Info' => 'Informace o klientovi',
      'day' => 'den',
      'day(s)' => '',
      'days' => 'dn',
      'description' => 'popis',
      'Description' => 'Popis',
      'Dispatching by email To: field.' => 'Odbaven podle pole KOMU:.',
      'Dispatching by selected Queue.' => 'Odbaven podle vybran fronty.',
      'Don\'t show closed Tickets' => '',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Nepracujte s utem slo 1 (systmov et)! Vytvote prosm nov',
      'Done' => 'Hotovo',
      'end' => 'konec',
      'Error' => 'Chyba',
      'Example' => 'Pklad',
      'Examples' => 'Pklady',
      'Facility' => 'Funkce',
      'FAQ-Area' => '',
      'Feature not active!' => 'Funkce je neaktivn!',
      'go' => 'jt',
      'go!' => 'jdi!',
      'Group' => 'Skupina',
      'Hit' => 'Pstup',
      'Hits' => 'Prstup',
      'hour' => 'hodina',
      'hours' => 'hodin',
      'Ignore' => 'Ignorovat',
      'invalid' => 'chybn',
      'Invalid SessionID!' => 'Chybn ID!',
      'Language' => 'Jazyk',
      'Languages' => 'Jazyky',
      'last' => '',
      'Line' => 'Linka',
      'Lite' => 'Omezen',
      'Login failed! Your username or password was entered incorrectly.' => 'Chyba v phlen! patn uivatelsk uet nebo heslo.',
      'Logout successful. Thank you for using OTRS!' => 'Odlogovn probhlov podku. Dkujeme za uvn OTRS!',
      'Message' => 'Zprva',
      'minute' => 'minuta',
      'minutes' => 'minut',
      'Module' => 'Modul',
      'Modulefile' => 'Modulov soubor',
      'month(s)' => '',
      'Name' => 'Jmno',
      'New Article' => '',
      'New message' => 'Nov zprva',
      'New message!' => 'Nov zprva!',
      'No' => 'Ne',
      'no' => 'ne',
      'No entry found!' => 'Nic nebylo nalezeno!',
      'No suggestions' => 'dn nabdka nenalezena',
      'none' => 'dn',
      'none - answered' => 'dn - odpovzeno',
      'none!' => 'dn!',
      'Normal' => '',
      'Off' => 'Vypnuto',
      'off' => 'vypnuto',
      'On' => 'Zapnuto',
      'on' => 'zapnuto',
      'Password' => 'Heslo',
      'Pending till' => 'Nevyzen do',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Prosme odpovezte na tento tiket(y) pro nvrat do pehledu zprv!',
      'Please contact your admin' => 'Kontaktujte prosm Vaeho administrtora',
      'please do not edit!' => 'prosme neupravovat!',
      'Please go away!' => '',
      'possible' => 'mon',
      'Preview' => '',
      'QueueView' => 'Pehled zprv',
      'reject' => 'zruen',
      'replace with' => 'nahradit',
      'Reset' => 'Reset',
      'Salutation' => 'Text',
      'Session has timed out. Please log in again.' => 'Session vyprelo. Pihlaste se znova.',
      'Show closed Tickets' => '',
      'Signature' => 'Podpis',
      'Sorry' => 'Omluva',
      'Stats' => 'Statistiky',
      'Subfunction' => 'Podfunkce',
      'submit' => 'Odeslat',
      'submit!' => 'odelsat!',
      'system' => 'system',
      'Take this User' => 'Vzt tohoto uivatele',
      'Text' => 'Text',
      'The recommended charset for your language is %s!' => 'Doporuen znakov sada pro V jazyk je  %s!',
      'Theme' => 'Tema',
      'There is no account with that login name.' => 'Neexistuje et s tmto jmnem.',
      'Timeover' => 'as vyprel',
      'To: (%s) replaced with database email!' => '',
      'top' => 'nahoru',
      'update' => 'obnovit',
      'Update' => '',
      'update!' => 'obnovit!',
      'User' => 'Uivatel',
      'Username' => 'Jmno uivatele',
      'Valid' => 'Platnost',
      'Warning' => 'Upozornn',
      'week(s)' => '',
      'Welcome to OTRS' => 'Vtejte v OTRS',
      'Word' => 'slovo',
      'wrote' => 'napsal',
      'year(s)' => '',
      'yes' => 'ano ',
      'Yes' => 'Ano ',
      'You got new message!' => 'Mte novou zprvu!',
      'You have %s new message(s)!' => 'Mte %s novou zprvu (zprvy)!',
      'You have %s reminder ticket(s)!' => 'Mte %s zpravu (zprvy) k upozornn',

    # Template: AAAMonth
      'Apr' => 'Dub',
      'Aug' => 'Srp',
      'Dec' => 'Pro',
      'Feb' => 'Uno',
      'Jan' => 'Led',
      'Jul' => 'er',
      'Jun' => 'rv',
      'Mar' => 'Be',
      'May' => 'Kv',
      'Nov' => 'Lis',
      'Oct' => 'j',
      'Sep' => 'Z',

    # Template: AAAPreferences
      'Closed Tickets' => 'Uzaven Tikety',
      'Custom Queue' => 'Vlastn pehled',
      'Follow up notification' => 'Nsledujc zprva',
      'Frontend' => 'Rozhran',
      'Mail Management' => 'Sprva email',
      'Max. shown Tickets a page in Overview.' => '',
      'Max. shown Tickets a page in QueueView.' => '',
      'Move notification' => 'Pesunout zprvu',
      'New ticket notification' => 'Nov Tiket',
      'Other Options' => 'Dal nastaven',
      'PhoneView' => 'Vloit Tiket',
      'Preferences updated successfully!' => 'Nastaven probhlo uspn!',
      'QueueView refresh time' => 'as obnoven pehledu zprv',
      'Screen after new ticket' => '',
      'Select your default spelling dictionary.' => 'Vyberte si slovnk',
      'Select your frontend Charset.' => 'Vyberte si znakovou sadu.',
      'Select your frontend language.' => 'Vyberte si jazyk.',
      'Select your frontend QueueView.' => 'Vyberte si typ pehledu zprv.',
      'Select your frontend Theme.' => 'Vyberte si vzhled.',
      'Select your QueueView refresh time.' => 'Vyberte si as obnovy pehledu zprv.',
      'Select your screen after creating a new ticket.' => '',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Poslat zprvu, pokud klient pole nsledujc zprvu a j jsem sprvce jeho Ticketu.',
      'Send me a notification if a ticket is moved into a custom queue.' => 'Poslat zprvu, pokud je Ticket pesunut do Vlastnho pehledu.',
      'Send me a notification if a ticket is unlocked by the system.' => 'Poslat zprvu, pokud je Ticket odemknut systmem.',
      'Send me a notification if there is a new ticket in my custom queues.' => 'Poslat zprvu, pokud je nov Tiket v mm Vlastnm pehledu.',
      'Show closed tickets.' => 'Zobrazit uzaven Tikety.',
      'Spelling Dictionary' => 'Slovnk',
      'Ticket lock timeout notification' => 'Upozornn na vypren asu u zamknutho Tiketu',
      'TicketZoom' => '',

    # Template: AAATicket
      '1 very low' => '1 velice nzk',
      '2 low' => '2 nzk',
      '3 normal' => '3 normln',
      '4 high' => '4 vysok',
      '5 very high' => '5 velice vysok',
      'Action' => 'Akce',
      'Age' => 'Doba',
      'Article' => 'Artikl',
      'Attachment' => 'Ploha',
      'Attachments' => 'Plohy',
      'Bcc' => 'Bcc',
      'Bounce' => 'Pesun',
      'Cc' => 'Cc',
      'Close' => 'Zavt',
      'closed successful' => 'zaveno - vyreeno',
      'closed unsuccessful' => 'zaveno - nevyeeno',
      'Compose' => 'Napsat',
      'Created' => 'Vytvoeno',
      'Createtime' => 'as',
      'email' => 'eMail',
      'eMail' => '',
      'email-external' => 'email extern',
      'email-internal' => 'email intern',
      'Forward' => 'Peposlat',
      'From' => 'Od',
      'high' => 'vysok',
      'History' => 'Historie',
      'If it is not displayed correctly,' => 'Pokud nen zobrazen v podku,',
      'lock' => 'zamknuto',
      'Lock' => 'Zamknuto',
      'low' => 'nzk',
      'Move' => 'Pesunout',
      'new' => 'nov',
      'normal' => 'normaln',
      'note-external' => 'Poznmka extern',
      'note-internal' => 'Poznmka Intern',
      'note-report' => 'Poznmka',
      'open' => 'oteveno',
      'Owner' => 'Vlastnk',
      'Pending' => 'Ve vyizovn',
      'pending auto close+' => 'vyizovan - auto close+',
      'pending auto close-' => 'vyizovn - auto close-',
      'pending reminder' => 'upomnka ve vyizovn',
      'phone' => 'Telefon',
      'plain' => '',
      'Priority' => 'Priorita ',
      'Queue' => 'ada',
      'removed' => 'smazn',
      'Sender' => 'Odeslatel',
      'sms' => '',
      'State' => 'Status',
      'Subject' => 'Pedmt',
      'This is a' => 'To je',
      'This is a HTML email. Click here to show it.' => 'Toto je HTML email. Kliknte zde pro zobrazen.',
      'This message was written in a character set other than your own.' => 'Tato zprva byla napsna v jin znakov sad.',
      'Ticket' => '',
      'Ticket "%s" created!' => '',
      'To' => 'Komu',
      'to open it in a new window.' => 'pro oteven v novm okn.',
      'unlock' => 'odemknout',
      'Unlock' => 'Odemknout',
      'very high' => 'velmi vysok',
      'very low' => 'velmi nzk',
      'View' => 'Nhled',
      'webrequest' => 'poadavek pes web',
      'Zoom' => 'Detaily',

    # Template: AAAWeekDay
      'Fri' => 'P',
      'Mon' => 'Po',
      'Sat' => 'So',
      'Sun' => 'Ne',
      'Thu' => 't',
      'Tue' => 't',
      'Wed' => 'St',

    # Template: AdminAttachmentForm
      'Add' => '',
      'Attachment Management' => 'Sprva ploh',

    # Template: AdminAutoResponseForm
      'Add auto response' => 'Pidat automatickou odpov',
      'Auto Response From' => 'Automatick odpov OD',
      'Auto Response Management' => 'Sprva automatickch odpovd',
      'Change auto response settings' => 'Zmnit nastaven automatickch odpoved',
      'Note' => 'Poznmka',
      'Response' => 'Odpov',
      'to get the first 20 character of the subject' => 'pro zskni prvnch 20 znaku v pedmtu',
      'to get the first 5 lines of the email' => 'pro zskn prvnch 5 rdk z emailu',
      'to get the from line of the email' => 'pro zskan OD z emailu',
      'to get the realname of the sender (if given)' => 'pro zskan pravho jmna odeslatele (pokud je uren)',
      'to get the ticket id of the ticket' => 'pro zskn ID Tiketu',
      'to get the ticket number of the ticket' => 'pro zskn sla Ticketu',
      'Type' => 'Typ',
      'Useable options' => 'Nastaven',

    # Template: AdminCustomerUserForm
      'Customer User Management' => 'Sprva klient',
      'Customer user will be needed to to login via customer panels.' => 'Klient se mus pihlast pomoc klientskho nastaven.',

    # Template: AdminCustomerUserGeneric

    # Template: AdminCustomerUserGroupChangeForm
      'Change %s settings' => 'Zmnit nastaven %s',
      'Customer User <-> Group Management' => '',
      'Full read and write access to the tickets in this group/queue.' => '',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => '',
      'Permission' => 'Prva',
      'Read only access to the ticket in this group/queue.' => '',
      'ro' => '',
      'rw' => '',
      'Select the user:group permissions.' => '',

    # Template: AdminCustomerUserGroupForm
      'Change user <-> group settings' => 'Zmenit uivatele <-> nastaven skupin',

    # Template: AdminCustomerUserPreferencesGeneric

    # Template: AdminEmail
      'Admin-Email' => 'Email Admin',
      'Body' => 'Text',
      'OTRS-Admin Info!' => 'OTRS-Admin info',
      'Recipents' => '',
      'send' => '',

    # Template: AdminEmailSent
      'Message sent to' => 'Zprva odeslna ',

    # Template: AdminGroupForm
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Vytvoit nov skupiny k lepmu pehledu a nastaven prv pro rozdln skupiny opertor (jako oddlen fakturace, prodeje, podpory,...).',
      'Group Management' => 'Sprva skupin',
      'It\'s useful for ASP solutions.' => 'Pouvan pro ASP een',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'Skupina administrtor m pstup do statistik a administran zny.',

    # Template: AdminLog
      'System Log' => 'System Log',

    # Template: AdminNavigationBar
      'AdminEmail' => 'Admin Email',
      'Attachment <-> Response' => 'Ploha <-> Odpov',
      'Auto Response <-> Queue' => 'Automatick odpov <-> ada',
      'Auto Responses' => 'Automatick odpovdi',
      'Customer User' => 'Klienti',
      'Customer User <-> Groups' => '',
      'Email Addresses' => 'Emailov adresy',
      'Groups' => 'Skupiny',
      'Logout' => 'Odhlsit',
      'Misc' => 'Rzn',
      'Notifications' => '',
      'PostMaster Filter' => '',
      'PostMaster POP3 Account' => 'PostMaster POP3 et',
      'Responses' => 'Odpovdi',
      'Responses <-> Queue' => 'Odpovdi <-> ada',
      'Select Box' => 'Vbr funkc',
      'Session Management' => 'Sprva session',
      'Status' => 'Status',
      'System' => 'System',
      'User <-> Groups' => 'Uivatel <-> Skupiny',

    # Template: AdminNotificationForm
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
      'Notification Management' => '',
      'Notifications are sent to an agent or a customer.' => '',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => '',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => '',

    # Template: AdminPOP3Form
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Vechny pchoz emaily s jednm tem budou pesmrovny do vybran ady!',
      'Dispatching' => 'Roztdit',
      'Host' => '',
      'If your account is trusted, the x-otrs header (for priority, ...) will be used!' => 'Pokud je V uet oven, X-OTRS hlaviky (pro prioritu, ...) budou pouvny!',
      'Login' => '',
      'POP3 Account Management' => 'Sprva POP3 t',
      'Trusted' => 'Ovit',

    # Template: AdminPostMasterFilterForm
      'Match' => '',
      'PostMasterFilter Management' => '',
      'Set' => '',

    # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Response Management' => 'ada <-> automatick opovdi',

    # Template: AdminQueueAutoResponseTable

    # Template: AdminQueueForm
      '0 = no escalation' => '0 = dn eskalace (stupovn)',
      '0 = no unlock' => '0 = dn odemknut',
      'Customer Move Notify' => 'Zprva pro klineta v ppad pesunu',
      'Customer Owner Notify' => 'Zprva pro klienta v ppad zmny opertora',
      'Customer State Notify' => 'Zprva pro klienta v prpad zmny statusu',
      'Escalation time' => 'as eskalace (stupovn)',
      'Follow up Option' => 'Nsledujc - nastaven',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Pokud Ticket je uzaven a klient pole nsledujc Ticket, bude pesunut ke starmu opertorovi.',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Pokud Tiket nebude odpovezen v ase, pouze tento Tiket bude ukzn.',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Pokud opertor uzamkne tiket a nebude na nj odpovezeno bhem tohoto asu, Tiket bude odemknut automatocky. Tiket bude viditeln pro vechny opertory.',
      'Key' => 'Kl',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS pole zprvu klinetovi, pokud Tiket bude pesunut.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS pole zprvu klinetovi, pokud bude zmnn opertor..',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS pole zprvu klientovi, pokud bude zmnn status.',
      'Queue Management' => 'Sprva ad',
      'Sub-Queue of' => 'Podada ',
      'Systemaddress' => 'Adresa systmu',
      'The salutation for email answers.' => 'Osloven pro emailov odpovdi.',
      'The signature for email answers.' => 'Podpis pro emailov odpovdi.',
      'Ticket lock after a follow up' => 'Zamknout Tiket po nsledujc odpovdi',
      'Unlock timeout' => 'as pro odemknut',
      'Will be the sender address of this queue for email answers.' => 'Odeslatelova adresa bude pro odpovdi via email.',

    # Template: AdminQueueResponsesChangeForm
      'Std. Responses <-> Queue Management' => 'Std. odpovdi <-> ada',

    # Template: AdminQueueResponsesForm
      'Answer' => 'Odpov',
      'Change answer <-> queue settings' => 'Upravit odpov <-> nastaven ady',

    # Template: AdminResponseAttachmentChangeForm
      'Std. Responses <-> Std. Attachment Management' => 'Std. odpovdi <-> Std. nastaven piloh',

    # Template: AdminResponseAttachmentForm
      'Change Response <-> Attachment settings' => 'Zmnit odpovdi <-> Nastaven ploh',

    # Template: AdminResponseForm
      'A response is default text to write faster answer (with default text) to customers.' => 'Odpov je defaultn text, kter pe rychlej odpov (s peddefinovanm obsahem) klentm.',
      'Don\'t forget to add a new response a queue!' => 'Nezapomete pidat novou odpove do ady!',
      'Next state' => 'Dals status',
      'Response Management' => 'Sprva odpovd',
      'The current ticket state is' => '',

    # Template: AdminSalutationForm
      'customer realname' => 'prav jmno klienta',
      'for agent firstname' => 'pro opertorovo kestn jmno',
      'for agent lastname' => 'pro opertoovo pjmen',
      'for agent login' => 'pro opertorv login',
      'for agent user id' => 'pro opertorm ID',
      'Salutation Management' => 'Sprva osloven',

    # Template: AdminSelectBoxForm
      'Max Rows' => 'Max. poet dk',

    # Template: AdminSelectBoxResult
      'Limit' => 'Limit',
      'Select Box Result' => 'Vyberte si vsledek',
      'SQL' => '',

    # Template: AdminSession
      'Agent' => '',
      'kill all sessions' => 'Zruit vechny session',
      'Overview' => '',
      'Sessions' => '',
      'Uniq' => '',

    # Template: AdminSessionTable
      'kill session' => 'Zruit session',
      'SessionID' => 'ID session',

    # Template: AdminSignatureForm
      'Signature Management' => 'Sprva podpis',

    # Template: AdminStateForm
      'See also' => '',
      'State Type' => 'Typ statusu',
      'System State Management' => 'Sprva status',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => '',

    # Template: AdminSystemAddressForm
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Vechny pchoz emaily s polem KOME budou zarazeby to vybrane ady!',
      'Email' => 'eMail',
      'Realname' => 'Prav jmno',
      'System Email Addresses Management' => 'Sprva adres',

    # Template: AdminUserForm
      'Don\'t forget to add a new user to groups!' => 'Nezapomete pidat opertora do skupin!',
      'Firstname' => 'Jmno',
      'Lastname' => 'Pjmen',
      'User Management' => 'Sprva opertor',
      'User will be needed to handle tickets.' => 'Opertor se bude zabvat Tikety.',

    # Template: AdminUserGroupChangeForm
      'create' => 'vytvoit',
      'move_into' => '',
      'owner' => '',
      'Permissions to change the ticket owner in this group/queue.' => '',
      'Permissions to change the ticket priority in this group/queue.' => '',
      'Permissions to create tickets in this group/queue.' => '',
      'Permissions to move tickets into this group/queue.' => '',
      'priority' => '',
      'User <-> Group Management' => 'Uivatele <-> sprva skupin',

    # Template: AdminUserGroupForm

    # Template: AdminUserPreferencesGeneric

    # Template: AgentBook
      'Address Book' => '',
      'Discard all changes and return to the compose screen' => 'Zruit vechny zmny a vrtit se k vytven',
      'Return to the compose screen' => 'Vrtit se k vytven',
      'Search' => '',
      'The message being composed has been closed.  Exiting.' => 'Zprvy mus bt vytvoeny, jet ped tm, ne je zavete.',
      'This window must be called from compose window' => 'Toto okno mus bt volno pouze z vytvecho',

    # Template: AgentBounce
      'A message should have a To: recipient!' => 'Zprva by mla obsahovat Komu: pjemce!',
      'Bounce ticket' => 'Pedan tiket',
      'Bounce to' => 'Pedn',
      'Inform sender' => 'Informace o odeslateli',
      'Next ticket state' => 'Dal status Tiketu',
      'Send mail!' => 'Poslat email!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Je poteba vloit emailovou adresu (nap. klient@email.cz) v poli Komu:!',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'V email s slem ticketu "<OTRS_TICKET>" byl pedn "<OTRS_BOUNCE_TO>". Konktantujte se na tto adrese pro dal infromace.',

    # Template: AgentClose
      ' (work units)' => ' (jednotky prce)',
      'A message should have a body!' => '',
      'A message should have a subject!' => 'Zprva by mela mt pedmt!',
      'Close ticket' => 'Zavene tikety',
      'Close type' => 'Typ uzaven',
      'Close!' => 'Zaven!',
      'Note Text' => 'Text poznmky',
      'Note type' => 'Typ poznmky',
      'Options' => 'Nastaven',
      'Spell Check' => 'Kontrola pravopisu',
      'Time units' => 'jednotky asu',
      'You need to account time!' => 'Potebujete et asu!',

    # Template: AgentCompose
      'A message must be spell checked!' => 'Zprva mus bt skontrolovan pravopisem!',
      'Attach' => 'Pipojit',
      'Compose answer for ticket' => 'Vytvoit odpov pro tento tiket',
      'for pending* states' => 'pro status nevyzeno*',
      'Is the ticket answered' => 'Je na tiket odpovzeno?',
      'Pending Date' => 'as v nevyzen',

    # Template: AgentCustomer
      'Back' => 'Zpt',
      'Change customer of ticket' => 'Zmnit klienta tiketu',
      'CustomerID' => 'ID klienta',
      'Search Customer' => 'Vyhledat klienta',
      'Set customer user and customer id of a ticket' => 'Nastavit klienta k tomuto tiketu',

    # Template: AgentCustomerHistory
      'All customer tickets.' => '',
      'Customer history' => 'Historie klienta',

    # Template: AgentCustomerMessage
      'Follow up' => 'Nsledujc',

    # Template: AgentCustomerView
      'Customer Data' => 'Data klienta',

    # Template: AgentForward
      'Article type' => 'Typ artiklu',
      'Date' => 'Datum',
      'End forwarded message' => 'Konec pesmrovan zprvy',
      'Forward article of ticket' => 'Pesmrovan artikl tiketu',
      'Forwarded message from' => 'Pesmrovat zprvu od',
      'Reply-To' => 'Odpovdt',

    # Template: AgentFreeText
      'Change free text of ticket' => 'Zmnit text tiketu',
      'Value' => 'Hodnota',

    # Template: AgentHistoryForm
      'History of' => 'Historie',

    # Template: AgentMailboxNavBar
      'All messages' => 'Vechny zprvy',
      'down' => 'dol',
      'Mailbox' => '',
      'New' => 'Nov',
      'New messages' => 'Nov zprvy',
      'Open' => 'Oteven',
      'Open messages' => 'Oteven zprvy',
      'Order' => 'Seadit',
      'Pending messages' => 'Zprvy ve vyizovn',
      'Reminder' => 'Upomnky',
      'Reminder messages' => 'Zprvy k upomnce',
      'Sort by' => 'Seadit dle',
      'Tickets' => 'Tikety',
      'up' => 'nahoru',

    # Template: AgentMailboxTicket
      '"}' => '',
      '"}","14' => '',

    # Template: AgentMove
      'All Agents' => '',
      'Move Ticket' => 'Pesunout Tiket',
      'New Owner' => '',
      'New Queue' => 'NOv ada',
      'Previous Owner' => '',
      'Queue ID' => '',

    # Template: AgentNavigationBar
      'Locked tickets' => 'Uzamen tikety',
      'new message' => 'nov zprvy',
      'Preferences' => 'Vlastnosti',
      'Utilities' => 'Vyhledvn ',

    # Template: AgentNote
      'Add note to ticket' => 'Pidat poznmku k tiketu',
      'Note!' => 'Poznmka!',

    # Template: AgentOwner
      'Change owner of ticket' => 'Zmnit majitele tiketu',
      'Message for new Owner' => 'Zprva pro movho majitele',

    # Template: AgentPending
      'Pending date' => 'as k vyzen',
      'Pending type' => 'Typ vyizovn',
      'Pending!' => 'Vyizuje se!',
      'Set Pending' => 'Nastaven vyizovn',

    # Template: AgentPhone
      'Customer called' => 'Klient volal',
      'Phone call' => 'Telefon hovor',
      'Phone call at %s' => 'Telefon hovor v %s',

    # Template: AgentPhoneNew
      'Clear From' => 'Zruit pole od',
      'Lock Ticket' => '',
      'new ticket' => 'Nov tiket',

    # Template: AgentPlain
      'ArticleID' => 'Kd artiklu',
      'Plain' => '',
      'TicketID' => 'Kd tiketu',

    # Template: AgentPreferencesCustomQueue
      'Select your custom queues' => 'Vyberte si vlastn adu',

    # Template: AgentPreferencesForm

    # Template: AgentPreferencesGeneric

    # Template: AgentPreferencesPassword
      'Change Password' => 'Zmnit heslo',
      'New password' => 'Nov heslo',
      'New password again' => 'Nov heslo (potvrzen)',

    # Template: AgentPriority
      'Change priority of ticket' => 'Zmnit prioritu tiketu',

    # Template: AgentSpelling
      'Apply these changes' => 'Pout tyto zmna',
      'Spell Checker' => 'Slovnk',
      'spelling error(s)' => 'chyba(y) ve slovech',

    # Template: AgentStatusView
      'D' => 'D',
      'of' => 'z',
      'Site' => 'Strnka',
      'sort downward' => 'seadit dolu',
      'sort upward' => 'seadit nahoru',
      'Ticket Status' => 'Status tiketu',
      'U' => 'U',

    # Template: AgentStatusViewTable

    # Template: AgentStatusViewTableNotAnswerd

    # Template: AgentTicketLink
      'Link' => '',
      'Link to' => '',

    # Template: AgentTicketLocked
      'Ticket locked!' => 'Tiket je zamknut!',
      'Ticket unlock!' => 'Tiket je odemknut!',

    # Template: AgentTicketPrint
      'by' => ' ',

    # Template: AgentTicketPrintHeader
      'Accounted time' => 'Utov as',
      'Escalation in' => '',

    # Template: AgentUtilSearch
      '(e. g. 10*5155 or 105658*)' => '',
      '(e. g. 234321)' => '',
      '(e. g. U5150)' => '',
      'and' => '',
      'Customer User Login' => '',
      'Delete' => '',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => '',
      'No time settings.' => '',
      'Profile' => '',
      'Result Form' => '',
      'Save Search-Profile as Template?' => '',
      'Search-Template' => '',
      'Select' => '',
      'Ticket created' => '',
      'Ticket created between' => '',
      'Ticket Search' => 'Hledn tiketu',
      'TicketFreeText' => '',
      'Times' => '',
      'Yes, save it with name' => '',

    # Template: AgentUtilSearchByCustomerID
      'Customer history search' => 'Vyhledvn historie klienta',
      'Customer history search (e. g. "ID342425").' => 'Vyhledvn historie klienta (nap: "ID342425")',
      'No * possible!' => '* nen povolena!',

    # Template: AgentUtilSearchNavBar
      'Change search options' => '',
      'Results' => 'Vsledky',
      'Search Result' => '',
      'Total hits' => 'Celkem hit',

    # Template: AgentUtilSearchResult
      '"}","15' => '',

    # Template: AgentUtilSearchResultPrint

    # Template: AgentUtilSearchResultPrintTable
      '"}","30' => '',

    # Template: AgentUtilSearchResultShort

    # Template: AgentUtilSearchResultShortTable

    # Template: AgentUtilSearchResultShortTableNotAnswered

    # Template: AgentUtilTicketStatus
      'All closed tickets' => 'Vechny uzaven tikety',
      'All open tickets' => 'Vechny oteven tikety',
      'closed tickets' => 'zavench tiket',
      'open tickets' => 'otevench tiket',
      'or' => 'nebo',
      'Provides an overview of all' => 'Vygenerovat nhled vech',
      'So you see what is going on in your system.' => 'Mete vidt kdo je ve Vaem systmu.',

    # Template: AgentZoomAgentIsCustomer
      'Compose Follow up' => 'Vytvoit nsledujc',
      'Your own Ticket' => 'Vae vlastn tikety',

    # Template: AgentZoomAnswer
      'Compose Answer' => 'Vytvoit odpov',
      'Contact customer' => 'Kontaktovat klienta',
      'phone call' => 'telefon hovor',

    # Template: AgentZoomArticle
      'Split' => 'Oezat',

    # Template: AgentZoomBody
      'Change queue' => 'Zmnit adu',

    # Template: AgentZoomHead
      'Free Fields' => 'Voln pole',
      'Print' => 'TIsknout',

    # Template: AgentZoomStatus
      '"}","18' => '',

    # Template: CustomerCreateAccount
      'Create Account' => 'Vytvoit et',

    # Template: CustomerError
      'Traceback' => '',

    # Template: CustomerFAQArticleHistory
      'Edit' => '',
      'FAQ History' => '',

    # Template: CustomerFAQArticlePrint
      'Category' => '',
      'Keywords' => '',
      'Last update' => '',
      'Problem' => '',
      'Solution' => '',
      'Symptom' => '',

    # Template: CustomerFAQArticleSystemHistory
      'FAQ System History' => '',

    # Template: CustomerFAQArticleView
      'FAQ Article' => '',
      'Modified' => '',

    # Template: CustomerFAQOverview
      'FAQ Overview' => '',

    # Template: CustomerFAQSearch
      'FAQ Search' => '',
      'Fulltext' => '',
      'Keyword' => '',

    # Template: CustomerFAQSearchResult
      'FAQ Search Result' => '',

    # Template: CustomerFooter
      'Powered by' => 'Vytvoeno',

    # Template: CustomerHeader
      'Contact' => 'Konktatk',
      'Home' => '',
      'Online-Support' => 'Online Podpora',
      'Products' => 'Produkty',
      'Support' => 'Podpora',

    # Template: CustomerLogin

    # Template: CustomerLostPassword
      'Lost your password?' => 'Zapoml/a jste heslo?',
      'Request new password' => 'Podat o nov heslo',

    # Template: CustomerMessage

    # Template: CustomerMessageNew

    # Template: CustomerNavigationBar
      'Create new Ticket' => 'Vytvoit nov tiket',
      'FAQ' => 'FAQ',
      'New Ticket' => 'Nov tiket',
      'Ticket-Overview' => 'Pehled tiket',
      'Welcome %s' => 'Vtejte %s',

    # Template: CustomerPreferencesForm

    # Template: CustomerPreferencesGeneric

    # Template: CustomerPreferencesPassword

    # Template: CustomerStatusView
      'My Tickets' => 'Moje tikety',

    # Template: CustomerStatusViewTable

    # Template: CustomerTicketZoom

    # Template: CustomerWarning

    # Template: Error
      'Click here to report a bug!' => 'Kliknutm zde polete chybu!',

    # Template: FAQArticleDelete
      'FAQ Delete' => '',
      'You really want to delete this article?' => '',

    # Template: FAQArticleForm
      'Comment (internal)' => '',
      'Filename' => '',
      'Short Description' => '',

    # Template: FAQArticleHistory

    # Template: FAQArticlePrint

    # Template: FAQArticleSystemHistory

    # Template: FAQArticleView

    # Template: FAQCategoryForm
      'FAQ Category' => '',

    # Template: FAQLanguageForm
      'FAQ Language' => '',

    # Template: FAQNavigationBar

    # Template: FAQOverview

    # Template: FAQSearch

    # Template: FAQSearchResult

    # Template: FAQStateForm
      'FAQ State' => '',

    # Template: Footer
      'Top of Page' => 'Nahoru',

    # Template: Header

    # Template: InstallerBody
      'Create Database' => 'Vytvoit Databazi ',
      'Drop Database' => 'Smazat databazi',
      'Finished' => 'Ukonit',
      'System Settings' => 'Nastaven systmu',
      'Web-Installer' => 'Web-Installer',

    # Template: InstallerFinish
      'Admin-User' => 'Administrace uivatel',
      'After doing so your OTRS is up and running.' => 'Po tomto V OTRS je nainstalovn a funguje',
      'Have a lot of fun!' => 'Hodn tst s OTRS!',
      'Restart your webserver' => 'Restartovat server',
      'Start page' => 'vodn strnka',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Per poter usare OTRS devi inserire questa riga di comando in una shell come utente root.',
      'Your OTRS Team' => 'V OTR tm',

    # Template: InstallerLicense
      'accept license' => 'souhlasm',
      'don\'t accept license' => 'nesouhlasm',
      'License' => 'Licence',

    # Template: InstallerStart
      'Create new database' => 'Vytvoit novou databzi',
      'DB Admin Password' => 'Heslo administrtora k databzi',
      'DB Admin User' => 'Administran username',
      'DB Host' => '',
      'DB Type' => 'Typ databze',
      'default \'hot\'' => '',
      'Delete old database' => 'Smazat starou datab',
      'next step' => 'dal krok',
      'OTRS DB connect host' => '',
      'OTRS DB Name' => '',
      'OTRS DB Password' => '',
      'OTRS DB User' => '',
      'your MySQL DB should have a root password! Default is empty!' => 'Vae databze by mla mt heslo!',

    # Template: InstallerSystem
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kontrola MX zznam pouitho emalu pi vytven odpovd Nepouvejte pokus jste pipojeni na OTR pomoc dial upu!)',
      '(Email of the system admin)' => '(Email administrtora)',
      '(Full qualified domain name of your system)' => '(Pln kvalifikovan domna systmu)',
      '(Logfile just needed for File-LogModule!)' => '(LogFIle potebujete pro modul Souborovho logovn)',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Systmov ID. Kad slo tiketu a kad HTTP session bude startovat tmto slem)',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identiktor tiket. Nekte lid chtej pouvat nap. \'Tiket#\',  \'Hovor\' nebo \'MujTiket\')',
      '(Used default language)' => '(Pouit defaultn jazyk)',
      '(Used log backend)' => '(Uit typ log)',
      '(Used ticket number format)' => '(seln typ tiket)',
      'CheckMXRecord' => 'Zkontrolovat MX zznam',
      'Default Charset' => 'Defaultn znakov sada',
      'Default Language' => 'Defaultn jazyk',
      'Logfile' => 'LogFile',
      'LogModule' => 'Modul Log',
      'Organization' => 'Organizace',
      'System FQDN' => 'System FQDN',
      'SystemID' => 'System ID',
      'Ticket Hook' => 'Prefix riket',
      'Ticket Number Generator' => 'Generator sel tiket',
      'Use utf-8 it your database supports it!' => '',
      'Webfrontend' => 'Webove rozhran',

    # Template: Login

    # Template: LostPassword

    # Template: NoPermission
      'No Permission' => 'Nemte prva',

    # Template: Notify
      'Info' => 'Informace',

    # Template: PrintFooter
      'URL' => '',

    # Template: PrintHeader
      'printed by' => 'tisknuto',

    # Template: QueueView
      'All tickets' => 'Celkem tiket',
      'Page' => '',
      'Queues' => 'ady',
      'Tickets available' => 'Tiket k dispozici',
      'Tickets shown' => 'Zobrazen tikety',

    # Template: SystemStats
      'Graphs' => 'Grafy',

    # Template: Test
      'OTRS Test Page' => 'Test OTRS strnky',

    # Template: TicketEscalation
      'Ticket escalation!' => '',

    # Template: TicketView

    # Template: TicketViewLite
      'Add Note' => 'Pidat poznmku',

    # Template: Warning

    # Misc
      'A message should have a From: recipient!' => 'Vae zprva by mla mt OD: odeslatel!',
      'AgentFrontend' => 'Zna opertor',
      'Article free text' => 'Text artiklu',
      'Charset' => 'Znakov sada',
      'Charsets' => 'Znakov sady',
      'Create' => 'Vytvoit',
      'Customer info' => 'Informace o klientovi',
      'CustomerUser' => 'Klient',
      'Fulltext search' => 'Fulltextov vyhledvn',
      'Fulltext search (e. g. "Mar*in" or "Baue*" or "martin+hallo")' => 'Hledn fulltext (nap. "Mar*in" nebo "Nov*" i "martin+chyba")',
      'Handle' => 'Ovldn',
      'In Queue' => 'V ad',
      'New state' => 'Nov status',
      'New ticket via call.' => 'Nov tiket via telefon.',
      'New user' => 'Nov opertor',
      'Pjemci' => 'Destinatari',
      'Search in' => 'Hledat v',
      'Set customer id of a ticket' => 'Nastaven klient ID v tiketu',
      'Show all' => 'ZObrazit ve',
      'System Charset Management' => 'Sprva znakovch sad',
      'System Language Management' => 'Sprva jazyk',
      'Ticket free text' => 'Text tiketu',
      'With Priority' => 'S prioritou',
      'With State' => 'Se statusem',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further inforamtions.' => 'V email s slem tiketu "<OTRS_TICKET>"   byl pedn "<OTRS_BOUNCE_TO>". Kontaktujte tuto adresu pro dal informace.',
      'auto responses set' => 'nastavit automatick odpovdi',
      'invalid-temporarily' => 'doasn neplatn',
      'odeslno' => 'Invia',
      'search' => 'Hledat',
      'search (e. g. 10*5155 or 105658*)' => 'hledat (nap: 10*5155 nebo 105658*)',
      'store' => 'sklad',
      'tickets' => 'tiket',
      'valid' => 'validn',
    );

    # $$STOP$$
    $Self->{Translation} = \%Hash;
}
# --
1;
