# Kernel/Language/fr.pm - provides fr language translation
# Copyright (C) 2002 Bernard Choppy <choppy at imaginet.fr>
# Copyright (C) 2002 Nicolas Goralski <ngoralski at oceanet-technology.com>
# Copyright (C) 2004 Yann Richard <ze at nawak-online.org>
# --
# $Id: fr.pm,v 1.28 2004/02/10 00:18:37 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::fr;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.28 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;
# --
sub Data {
    my $Self = shift;
    my %Param = @_;
    my %Hash = ();

    # $$START$$
    # Last translation Tue Feb 10 01:07:42 2004 by 

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D.%M.%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %T %Y';
    $Self->{DateInputFormat} = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    %Hash = (
    # Template: AAABase
      ' 2 minutes' => ' 2 minutes',
      ' 5 minutes' => ' 5 minutes',
      ' 7 minutes' => ' 7 minutes',
      '(Click here to add)' => '',
      '10 minutes' => '10 minutes',
      '15 minutes' => '15 minutes',
      'AddLink' => 'Ajouter un lien',
      'Admin-Area' => 'Zone d\'administration',
      'agent' => 'technicien',
      'Agent-Area' => 'Interface du technicien',
      'all' => 'tout',
      'All' => 'Tout',
      'Attention' => 'Attention',
      'before' => '',
      'Bug Report' => 'Rapport d\'anomalie',
      'Cancel' => 'Annuler',
      'change' => 'modifier',
      'Change' => 'Modifier',
      'change!' => 'modifier&nbsp;!',
      'click here' => 'Cliquer ici',
      'Comment' => 'Commentaire',
      'Customer' => 'Client',
      'customer' => 'client',
      'Customer Info' => 'Information client',
      'day' => 'jour',
      'day(s)' => '',
      'days' => 'jours',
      'description' => 'description',
      'Description' => 'Description',
      'Dispatching by email To: field.' => 'Rpartition par le champs \'\' de l\'email',
      'Dispatching by selected Queue.' => 'Rpartition selon la file slectionne',
      'Don\'t show closed Tickets' => 'Ne pas montrer les tickets ferms',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Cela ne fonctionne pas avec l\'identfifiant utilisateur 1 (Compte Systme)! Veuillez crer un nouvel utilisateur!',
      'Done' => 'Fait',
      'end' => 'fin',
      'Error' => 'Erreur',
      'Example' => 'Exemple',
      'Examples' => 'Exemples',
      'Facility' => 'Facilit',
      'FAQ-Area' => 'Foire Aux Questions',
      'Feature not active!' => 'Cette fonctionnalit n\'est pas active',
      'go' => 'aller',
      'go!' => 'c\'est parti&nbsp;!',
      'Group' => 'Groupe',
      'Hit' => 'Hit',
      'Hits' => 'Hits',
      'hour' => 'heure',
      'hours' => 'heures',
      'Ignore' => 'Ignorer',
      'invalid' => 'invalide',
      'Invalid SessionID!' => 'ID de Session Invalide',
      'Language' => 'Langue',
      'Languages' => 'Langues',
      'last' => '',
      'Line' => 'Ligne',
      'Lite' => 'allge',
      'Login failed! Your username or password was entered incorrectly.' => 'La connection a chou ! Votre nom d\'utilisateur ou votre mot de passe sont errons.',
      'Logout successful. Thank you for using OTRS!' => 'Dconnection russie. Merci d\'avoir utilis OTRS!',
      'Message' => 'Message',
      'minute' => 'minute',
      'minutes' => 'minutes',
      'Module' => 'Module',
      'Modulefile' => 'Fichier de module',
      'month(s)' => '',
      'Name' => 'Nom',
      'New Article' => 'Nouvel Article',
      'New message' => 'Nouveau message',
      'New message!' => 'Nouveau message&nbsp;!',
      'No' => 'Non',
      'no' => 'non',
      'No entry found!' => 'Aucun rsultat n\'a t trouv&nbsp;!',
      'No suggestions' => 'Pas de suggestions',
      'none' => 'aucun',
      'none - answered' => 'aucun - rpondu',
      'none!' => 'aucun&nbsp;!',
      'Normal' => '',
      'Off' => 'teint',
      'off' => 'teint',
      'On' => 'Allum',
      'on' => 'allum',
      'Password' => 'Mot de Passe',
      'Pending till' => 'En attendant jusqu\'',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Il faut rpondre  ce(s) ticket(s) pour revenir  une vue normale de la file.',
      'Please contact your admin' => 'Veuillez contacter votre admnistrateur',
      'please do not edit!' => 'Ne pas modifier&nbsp;!',
      'Please go away!' => 'Passez votre chemin&nbsp;!',
      'possible' => 'possible',
      'Preview' => '',
      'QueueView' => 'Vue file',
      'reject' => 'rejet',
      'replace with' => 'remplacer par',
      'Reset' => 'Remise  zro',
      'Salutation' => 'Salutation',
      'Session has timed out. Please log in again.' => 'Le dlai de votre session est dpass, veuillez vous r-authentifier.',
      'Show closed Tickets' => 'Voir les tickets ferms',
      'Signature' => 'Signature',
      'Sorry' => 'Dsol',
      'Stats' => 'Statistiques',
      'Subfunction' => 'sous-fonction',
      'submit' => 'soumettre',
      'submit!' => 'soumettre&nbsp;!',
      'system' => 'systme',
      'Take this User' => 'Prendre cet utilisateur',
      'Text' => 'Texte',
      'The recommended charset for your language is %s!' => 'Le jeu de caractre correspondant  votre langue est %s!',
      'Theme' => 'Thme',
      'There is no account with that login name.' => 'Il n\'y a aucun compte avec ce nom de connexion',
      'Timeover' => 'Temp coul',
      'To: (%s) replaced with database email!' => 'Le champ \'\' (%s) a t remplac avec la valeur de la base de donnes des e-mail&nbsp;!',
      'top' => 'haut',
      'update' => 'Mise  jour',
      'Update' => '',
      'update!' => 'mettre  jour&nbsp;!',
      'User' => 'Utilisateur',
      'Username' => 'Nom d\'utilisateur',
      'Valid' => 'Valide',
      'Warning' => 'Attention',
      'week(s)' => '',
      'Welcome to OTRS' => 'Bienvenue dans OTRS',
      'Word' => 'Mot',
      'wrote' => 'crit',
      'year(s)' => '',
      'yes' => 'oui',
      'Yes' => 'Oui',
      'You got new message!' => 'Vous avez un nouveau message',
      'You have %s new message(s)!' => 'Vous avez %s nouveau(x) message(s)',
      'You have %s reminder ticket(s)!' => 'Vous avez %s rappel(s) de ticket(s)',

    # Template: AAAMonth
      'Apr' => 'Avr',
      'Aug' => 'Aou',
      'Dec' => 'Dc',
      'Feb' => 'Fv',
      'Jan' => 'Jan',
      'Jul' => 'Juil',
      'Jun' => 'Juin',
      'Mar' => 'Mar',
      'May' => 'Mai',
      'Nov' => 'Nov',
      'Oct' => 'Oct',
      'Sep' => 'Sep',

    # Template: AAAPreferences
      'Closed Tickets' => 'Tickets ferms',
      'Custom Queue' => 'File d\'attente personnalis',
      'Follow up notification' => 'Notification de suivi',
      'Frontend' => 'Interface',
      'Mail Management' => 'Gestion des e-mails',
      'Max. shown Tickets a page in Overview.' => 'Nombre de ticket maximum sur la page d\'aperu des tickets',
      'Max. shown Tickets a page in QueueView.' => 'Nombre de ticket maximum sur la page de la vue d\'une file',
      'Move notification' => 'Notification de mouvement',
      'New ticket notification' => 'Notification de nouveau ticket',
      'Other Options' => 'Autres options',
      'PhoneView' => 'Vue tlphone',
      'Preferences updated successfully!' => 'Les prfrences ont bien t mises  jours',
      'QueueView refresh time' => 'Temps de rafrachissement de la vue des files',
      'Screen after new ticket' => 'Ecran aprs un nouveau ticket',
      'Select your default spelling dictionary.' => 'Slectionnez votre correcteur orthographique par dfaut',
      'Select your frontend Charset.' => 'Choix du jeu de caractres de l\'interface',
      'Select your frontend language.' => 'Choix de la langue de l\'interface',
      'Select your frontend QueueView.' => 'Choisissez votre interface de vue des files',
      'Select your frontend Theme.' => 'Choix du thme de l\'interface',
      'Select your QueueView refresh time.' => 'Choix du dlai de rafrachissement de la vue des files',
      'Select your screen after creating a new ticket.' => '',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Me prvenir si un client envoie un suivi (follow-up) et que je suis le propritaire du ticket.',
      'Send me a notification if a ticket is moved into a custom queue.' => 'Me prvenir si un ticket est dplac dans une file personnallis',
      'Send me a notification if a ticket is unlocked by the system.' => 'Me prvenir si un ticket est dvrouill par le systme',
      'Send me a notification if there is a new ticket in my custom queues.' => 'Me prvenir si un nouveau ticket apparat dans mes files personnelles.',
      'Show closed tickets.' => 'Voir les tickets ferms',
      'Spelling Dictionary' => 'Correcteur orthographique',
      'Ticket lock timeout notification' => 'Prvenir du dpassement du dlai d\'un verrou',
      'TicketZoom' => 'Dtails',

    # Template: AAATicket
      '1 very low' => '1 trs bas',
      '2 low' => '2 bas',
      '3 normal' => '3 normal',
      '4 high' => '4 important',
      '5 very high' => '5 trs important',
      'Action' => 'Action',
      'Age' => 'Vieillir',
      'Article' => 'Article',
      'Attachment' => 'Pice jointe',
      'Attachments' => 'Pices jointes',
      'Bcc' => 'Copie Invisible',
      'Bounce' => 'Renvoyer',
      'Cc' => 'Copie ',
      'Close' => 'Fermer',
      'closed successful' => 'clture russie',
      'closed unsuccessful' => 'clture manque',
      'Compose' => 'Composer',
      'Created' => 'Cr ',
      'Createtime' => 'Cration du ',
      'email' => 'courriel',
      'eMail' => 'courriel',
      'email-external' => 'message externe',
      'email-internal' => 'message interne',
      'Forward' => 'Transmettre',
      'From' => 'De ',
      'high' => 'Important',
      'History' => 'Historique',
      'If it is not displayed correctly,' => 'S\'il n\'est pas affich correctement',
      'lock' => 'vrrouiller',
      'Lock' => 'Vrrouiller',
      'low' => 'confort de fonctionnement',
      'Move' => 'Dplacer',
      'new' => 'nouveau',
      'normal' => 'bloque une fonction',
      'note-external' => 'Note externe',
      'note-internal' => 'Note interne',
      'note-report' => 'Note rapport',
      'open' => 'ouvrir',
      'Owner' => 'Propritaire',
      'Pending' => 'En attente',
      'pending auto close+' => 'En attendant la fermeture automatique(+)',
      'pending auto close-' => 'En attendant la fermeture automatique(-)',
      'pending reminder' => 'En attendant le rappel',
      'phone' => 'tlphone',
      'plain' => 'tel quel',
      'Priority' => 'Priorit',
      'Queue' => 'File',
      'removed' => 'supprim',
      'Sender' => 'metteur',
      'sms' => 'sms',
      'State' => 'tat',
      'Subject' => 'Sujet',
      'This is a' => 'Ceci est un',
      'This is a HTML email. Click here to show it.' => 'Ceci est un message au format HTML&nbsp;; cliquer ici pour l\'afficher.',
      'This message was written in a character set other than your own.' => 'Ce message a t &eaute;crit dans un jeu de caractres diffrent du v&ociric;tre.',
      'Ticket' => 'Ticket',
      'Ticket "%s" created!' => 'Le ticket %s a t cre&nbsp;!',
      'To' => ' ',
      'to open it in a new window.' => 'L\'ouvrir dans une nouvelle fentre',
      'unlock' => 'dverrouiller',
      'Unlock' => 'Dverrouiller',
      'very high' => 'trs haut',
      'very low' => 'trs basse',
      'View' => 'Vue',
      'webrequest' => 'Requte par le web',
      'Zoom' => 'Dtails',

    # Template: AAAWeekDay
      'Fri' => 'Ven',
      'Mon' => 'Lun',
      'Sat' => 'Sam',
      'Sun' => 'Dim',
      'Thu' => 'Jeu',
      'Tue' => 'Mar',
      'Wed' => 'Mer',

    # Template: AdminAttachmentForm
      'Add' => 'Ajouter',
      'Attachment Management' => 'Gestion des attachements',

    # Template: AdminAutoResponseForm
      'Add auto response' => 'Ajouter une rponse automatique',
      'Auto Response From' => 'Rponse automatique de ',
      'Auto Response Management' => 'Gestion des rponses automatiques',
      'Change auto response settings' => 'Modifier les paramtres de rponses automatiques',
      'Note' => 'Note',
      'Response' => 'Rponse',
      'to get the first 20 character of the subject' => 'pour avoir les 20 premiers caractres du sujet ',
      'to get the first 5 lines of the email' => 'pour avoir les 5 premires ligne du mail',
      'to get the from line of the email' => 'pour avoir les lignes \'From\' du mail',
      'to get the realname of the sender (if given)' => 'pour avoir le nom rel de l\'utilisateur (s\il est donn)',
      'to get the ticket id of the ticket' => 'pour avoir l\'identifiant du ticket',
      'to get the ticket number of the ticket' => 'pour avoir le numro du ticket',
      'Type' => 'Type',
      'Useable options' => 'Options accessibles',

    # Template: AdminCustomerUserForm
      'Customer User Management' => 'Gestion des clients utilisateurs',
      'Customer user will be needed to to login via customer panels.' => 'Les clients utilisateurs seront invit  se connecter par la page client.',
      'Select source:' => '',
      'Source' => '',

    # Template: AdminCustomerUserGeneric

    # Template: AdminCustomerUserGroupChangeForm
      'Change %s settings' => 'Changer les param&ecirc;tres de %s',
      'Customer User <-> Group Management' => 'Client <-> Groupes',
      'Full read and write access to the tickets in this group/queue.' => 'Accs complet en lecture et criture aux tickets dans cette file/groupe.',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Si rien n\'est slectionn, il n\'y aura pas de droits dans ce groupe (Les tickets ne seront plus disponible pour l\'utilisateur).',
      'Permission' => 'Droits',
      'Read only access to the ticket in this group/queue.' => 'Accs en lecture seulement aux tickets de cette file/groupe.',
      'ro' => 'lecture seule',
      'rw' => 'lecture/criture',
      'Select the user:group permissions.' => 'Slectionnez les permissions pour l\'utilisateur:groupe.',

    # Template: AdminCustomerUserGroupForm
      'Change user <-> group settings' => 'Modifier les paramtres utilisateurs <-> groupes',

    # Template: AdminCustomerUserPreferencesGeneric

    # Template: AdminEmail
      'Admin-Email' => 'Email de l\'administrateur',
      'Body' => 'Corps',
      'OTRS-Admin Info!' => 'Information de l\'administrateur OTRS&nbsp;!',
      'Recipents' => 'Rcipients',
      'send' => 'envoyer',

    # Template: AdminEmailSent
      'Message sent to' => 'Message envoy ',

    # Template: AdminGroupForm
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'De nouveaux groupes permettront de grer les droits d\'accs pour les diffrents groupes du technicien (exemple: achats, comptabilit, support, ventes...).',
      'Group Management' => 'Administration des groupes',
      'It\'s useful for ASP solutions.' => 'C\'est utile pour les fournisseurs d\'applications.',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'Le groupe admin permet d\'accder  la zone d\'administration et le groupe stats  la zone de statistiques.',

    # Template: AdminLog
      'System Log' => 'Logs du Systme',

    # Template: AdminNavigationBar
      'AdminEmail' => 'Email de l\'administrateur.',
      'Attachment <-> Response' => 'Pice jointe <-> Rponse',
      'Auto Response <-> Queue' => 'Rponse Automatique <-> Files',
      'Auto Responses' => 'Rponses automatiques',
      'Customer User' => 'Client Utilisateur',
      'Customer User <-> Groups' => 'Client <-> Groupes',
      'Email Addresses' => 'Adresses lectroniques',
      'Groups' => 'Groupes',
      'Logout' => 'Dconnexion',
      'Misc' => 'Divers',
      'Notifications' => 'Notifications',
      'PostMaster Filter' => '',
      'PostMaster POP3 Account' => 'PostMaster Compte POP3',
      'Responses' => 'Rponses',
      'Responses <-> Queue' => 'Rponses <-> Files',
      'Select Box' => 'Requte SQL libre.',
      'Session Management' => 'Gestion des sessions',
      'Status' => 'Statut',
      'System' => 'Systme',
      'User <-> Groups' => 'Utilisateur <-> Groupes',

    # Template: AdminNotificationForm
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
      'Notification Management' => 'Gestion des notifications',
      'Notifications are sent to an agent or a customer.' => '',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => '',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => '',

    # Template: AdminPOP3Form
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Tout les mails entrants avec un compte seront rpartis dans la file slectionn',
      'Dispatching' => 'Rpartition',
      'Host' => 'Hte',
      'If your account is trusted, the x-otrs header (for priority, ...) will be used!' => 'Si votre compte est vrifi, les en-t&ecirc;tes x-otrs (pour les priorits,...) seront utiliss',
      'Login' => 'Nom d\'utilisateur',
      'POP3 Account Management' => 'Gestion du compte POP3',
      'Trusted' => 'Vrifi',

    # Template: AdminPostMasterFilterForm
      'Match' => '',
      'PostMasterFilter Management' => '',
      'Set' => '',

    # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Response Management' => 'Gestion des files <-> rponses automatiques',

    # Template: AdminQueueAutoResponseTable

    # Template: AdminQueueForm
      '0 = no escalation' => '0 = pas d\'escalade',
      '0 = no unlock' => '0 = pas de vrouillage',
      'Customer Move Notify' => 'Notification lors d\'un changement de file',
      'Customer Owner Notify' => 'Notification lors d\'un changement de propritaire',
      'Customer State Notify' => 'Notification lors d\'un changement d\tat',
      'Escalation time' => 'Dlai d\'escalade',
      'Follow up Option' => 'Option des suivis',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Si un ticket est clotur et que le client envoie une note, le ticket pour l\'ancien propritaire',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Si un ticket n\'est pas rpondu dans le temps impartit, alors juste ce ticket sera affich',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Si un technicien vrouille un ticket et qu\'il/elle n\'envoie pas une rponse dans le temps impartit, le ticket sera dvrouill automatiquement.',
      'Key' => 'Clef',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS envoit un e-mail au client quand la file d\'un ticket a chang',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS envoit un e-mail au client quand le propritaire d\'un ticket a chang',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS envoit un e-mail au client quand l\'tat d\'un ticket a chang',
      'Queue Management' => 'Gestion des files',
      'Sub-Queue of' => 'Sous-file',
      'Systemaddress' => 'Adresse du Systme',
      'The salutation for email answers.' => 'La formule de politesse pour les rponses par mail',
      'The signature for email answers.' => 'La signature pour les rponses par email',
      'Ticket lock after a follow up' => 'Ticket bloqu aprs un suivi',
      'Unlock timeout' => 'Temporisation du dverrouillage',
      'Will be the sender address of this queue for email answers.' => 'Sera l\'adresse d\'exppdition pour les rponses par courrier lectronique',

    # Template: AdminQueueResponsesChangeForm
      'Std. Responses <-> Queue Management' => 'Gestion des rponses standard <-> files',

    # Template: AdminQueueResponsesForm
      'Answer' => 'Rponse',
      'Change answer <-> queue settings' => 'Modifier les paramtres de rponses <-> files',

    # Template: AdminResponseAttachmentChangeForm
      'Std. Responses <-> Std. Attachment Management' => 'Rponses Std <-> Gestion des attachements Std',

    # Template: AdminResponseAttachmentForm
      'Change Response <-> Attachment settings' => 'Param&ecirc;tre des attachements',

    # Template: AdminResponseForm
      'A response is default text to write faster answer (with default text) to customers.' => 'Une rponse est un texte par dfaut destin  rdiger plus rapidement des rponses standard aux clients.',
      'Don\'t forget to add a new response a queue!' => 'Ne pas oublier d\'ajouter une file  une nouvelle rponse&nbsp;!',
      'Next state' => 'Etat suivant',
      'Response Management' => 'Gestion des rponses',
      'The current ticket state is' => 'L\'tat actuel du ticket est',

    # Template: AdminSalutationForm
      'customer realname' => 'nom rel du client',
      'for agent firstname' => 'pour le prnom du technicien',
      'for agent lastname' => 'pour le nom du technicien',
      'for agent login' => 'pour le nom de connexion (login) du technicien',
      'for agent user id' => 'pour l\'identifiant du technicien',
      'Salutation Management' => 'Gestion des salutations',

    # Template: AdminSelectBoxForm
      'Max Rows' => 'Nombre de lignes maximales',

    # Template: AdminSelectBoxResult
      'Limit' => 'Limite',
      'Select Box Result' => 'Choisissez le rsultat',
      'SQL' => 'SQL',

    # Template: AdminSession
      'Agent' => 'Agent',
      'kill all sessions' => 'Terminer toutes les sessions',
      'Overview' => 'Aperu',
      'Sessions' => 'Session',
      'Uniq' => 'Unique',

    # Template: AdminSessionTable
      'kill session' => 'Terminer une session',
      'SessionID' => 'Identifiant de session',

    # Template: AdminSignatureForm
      'Signature Management' => 'Gestion des signatures',

    # Template: AdminStateForm
      'See also' => 'Voir aussi',
      'State Type' => 'Type d\'tat',
      'System State Management' => 'Gestion des tats du systme',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Prennez garde de bien mettre  jour les tats par dfaut dans votre Kernelconfig.pm&nbsp;!',

    # Template: AdminSystemAddressForm
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Tous les courriels avec cette adresse en destinataire (&nbsp;:) seront placs dans la file choisie..',
      'Email' => 'Courrier lectronique',
      'Realname' => 'Vritable Nom',
      'System Email Addresses Management' => 'Gestion des adresses courriel du systme',

    # Template: AdminUserForm
      'Don\'t forget to add a new user to groups!' => 'Ne pas oublier d\'ajouter un nouvel utilisateur aux groupes&nbsp;!',
      'Firstname' => 'Prnom',
      'Lastname' => 'Nom',
      'User Management' => 'Administration des utilisateurs',
      'User will be needed to handle tickets.' => 'Un utilisateur sera ncessaire pour grer les tickets.',

    # Template: AdminUserGroupChangeForm
      'create' => 'crer',
      'move_into' => 'dplacer dans',
      'owner' => 'propritaire',
      'Permissions to change the ticket owner in this group/queue.' => 'Permission de changer le propritaire d\'un ticket dans cette file/groupe.',
      'Permissions to change the ticket priority in this group/queue.' => 'Permission de changer la priorit d\'un ticket dans cette file/groupe.',
      'Permissions to create tickets in this group/queue.' => 'Permission de crer un ticket dans cette file/groupe.',
      'Permissions to move tickets into this group/queue.' => 'Permission de dplacer un ticket dans cette file/groupe.',
      'priority' => 'priorit',
      'User <-> Group Management' => 'Gestion utilisateurs <-> groupes',

    # Template: AdminUserGroupForm

    # Template: AdminUserPreferencesGeneric

    # Template: AgentBook
      'Address Book' => 'Carnet d\'adresse',
      'Discard all changes and return to the compose screen' => 'Annuler tout les changements et retourner  l\'cran de saisie',
      'Return to the compose screen' => 'Retourner  l\'cran de saisie',
      'Search' => 'Chercher',
      'The message being composed has been closed.  Exiting.' => 'Le message en cours de composition a t cltur. Sortie.',
      'This window must be called from compose window' => 'Cette fene&ecirc;tre doit &ecirc;tre appel de la fen&ecirc;tre de composition',

    # Template: AgentBounce
      'A message should have a To: recipient!' => 'Un message doit avoir un destinataire (&nbsp;:)!',
      'Bounce ticket' => 'Renvoyer le ticket',
      'Bounce to' => 'Renvoyer ',
      'Inform sender' => 'Informer l\'emetteur',
      'Next ticket state' => 'Prochain tat du ticket',
      'Send mail!' => 'Envoyer le courriel&nbsp;!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Il faut une adresse courriel (ecemple&nbsp;: client@exemple.fr)&nbsp;!',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Votre email avec le ticket numro "<OTRS_TICKET> est renvoyer  "<OTRS_BOUNCE_TO>". Contactez cette adresse pour de plus amples renseignements',

    # Template: AgentClose
      ' (work units)' => ' Unit de travail',
      'A message should have a body!' => 'Un message doit avoir un corp&nbsp;!',
      'A message should have a subject!' => 'Un message doit avoir un sujet&nbsp;!',
      'Close ticket' => 'Ticket clos',
      'Close type' => 'Type de cloture',
      'Close!' => 'Clture!',
      'Note Text' => 'Note',
      'Note type' => 'Type de note',
      'Options' => 'Options',
      'Spell Check' => 'Vrification orthographique',
      'Time units' => 'Unit de temps',
      'You need to account time!' => '',

    # Template: AgentCompose
      'A message must be spell checked!' => 'L\orthographe d\'un message doit tre vrifi&nbsp;!',
      'Attach' => 'Attach',
      'Compose answer for ticket' => 'Composer une rponse pour le ticket',
      'for pending* states' => 'pour les tats d\'attente',
      'Is the ticket answered' => 'Est-ce que le ticket est rpondu',
      'Pending Date' => 'En attendant la date',

    # Template: AgentCustomer
      'Back' => 'retour',
      'Change customer of ticket' => 'Changer le numro de client du ticket',
      'CustomerID' => 'Numro de client#',
      'Search Customer' => 'Recherche de client',
      'Set customer user and customer id of a ticket' => 'Assigner une valeur pour le client et l\'identifiant client pour le ticket.',

    # Template: AgentCustomerHistory
      'All customer tickets.' => 'Tout les tickets du client',
      'Customer history' => 'Historique du client',

    # Template: AgentCustomerMessage
      'Follow up' => 'Note',

    # Template: AgentCustomerView
      'Customer Data' => 'Donnes client',

    # Template: AgentEmailNew
      'All Agents' => 'Tout les techniciens',
      'Clear From' => 'Vider le formulaire',
      'Compose Email' => '',
      'Lock Ticket' => 'Prendre le Ticket',
      'new ticket' => 'nouveau ticket',

    # Template: AgentForward
      'Article type' => 'Type d\'article',
      'Date' => 'Date',
      'End forwarded message' => 'Fin du message retransmit',
      'Forward article of ticket' => 'Transmettre l\'article du ticket',
      'Forwarded message from' => 'Message renvoy par',
      'Reply-To' => 'Rpondre ',

    # Template: AgentFreeText
      'Change free text of ticket' => 'Changer le texte libre du ticket',
      'Value' => 'Valeur',

    # Template: AgentHistoryForm
      'History of' => 'Historique de',

    # Template: AgentMailboxNavBar
      'All messages' => 'Tout les messages',
      'down' => 'bas',
      'Mailbox' => 'Bo&icirc;te aux lettres',
      'New' => 'Nouveau',
      'New messages' => 'Nouveaux messages',
      'Open' => 'Ouvrir',
      'Open messages' => 'Ouvrir des messages',
      'Order' => 'Ordre',
      'Pending messages' => 'Message en attente',
      'Reminder' => 'Rappel',
      'Reminder messages' => 'Message de rappel',
      'Sort by' => 'Trier par',
      'Tickets' => 'Tickets',
      'up' => 'haut',

    # Template: AgentMailboxTicket
      '"}' => '',
      '"}","14' => '',

    # Template: AgentMove
      'Move Ticket' => 'Changer la file du ticket',
      'New Owner' => 'Nouveau Propitaire',
      'New Queue' => 'Nouvelle File',
      'Previous Owner' => 'Propritaire Prcdent',
      'Queue ID' => 'Identifiant de la File',

    # Template: AgentNavigationBar
      'Locked tickets' => 'Tickets verrouills',
      'new message' => 'Nouveau message',
      'Preferences' => 'Prfrences',
      'Utilities' => 'Utilitaires',

    # Template: AgentNote
      'Add note to ticket' => 'Ajouter une note au ticket',
      'Note!' => 'Note',

    # Template: AgentOwner
      'Change owner of ticket' => 'Changer le propritaire du ticket',
      'Message for new Owner' => 'Message pour le nouveau Propritaire',

    # Template: AgentPending
      'Pending date' => 'Date d\'attente',
      'Pending type' => 'Type d\'attente',
      'Pending!' => 'En attente&nbsp;!',
      'Set Pending' => 'Dfinir l\'attente',

    # Template: AgentPhone
      'Customer called' => 'Client appel',
      'Phone call' => 'Appel tlphonique',
      'Phone call at %s' => 'Appel tlphonique  %s',

    # Template: AgentPhoneNew

    # Template: AgentPlain
      'ArticleID' => 'Identifiant de l\'Article',
      'Plain' => 'Tel quel',
      'TicketID' => 'Identifiant du Ticket',

    # Template: AgentPreferencesCustomQueue
      'Select your custom queues' => 'Choix des files personnelles',

    # Template: AgentPreferencesForm

    # Template: AgentPreferencesGeneric

    # Template: AgentPreferencesPassword
      'Change Password' => 'Modification du mot de passe',
      'New password' => 'Nouveau mot de passe',
      'New password again' => 'Nouveau mot de passe (confirmation)',

    # Template: AgentPriority
      'Change priority of ticket' => 'Modification de la priorit du ticket',

    # Template: AgentSpelling
      'Apply these changes' => 'Appliquer ces changements',
      'Spell Checker' => 'Vrificateur orthographique',
      'spelling error(s)' => 'erreurs d\'orthographe',

    # Template: AgentStatusView
      'D' => 'A-Z',
      'of' => 'de',
      'Site' => 'Site',
      'sort downward' => 'Tri dcroissant',
      'sort upward' => 'Tri croissant',
      'Ticket Status' => 'Status du Ticket',
      'U' => 'Z-A',

    # Template: AgentStatusViewTable

    # Template: AgentStatusViewTableNotAnswerd

    # Template: AgentTicketLink
      'Link' => '',
      'Link to' => '',

    # Template: AgentTicketLocked
      'Ticket locked!' => 'Ticket verrouill&nbsp;!',
      'Ticket unlock!' => 'Rendre le Ticket&nbsp;!',

    # Template: AgentTicketPrint
      'by' => 'par',

    # Template: AgentTicketPrintHeader
      'Accounted time' => 'Temp pass',
      'Escalation in' => 'Escalade dans',

    # Template: AgentUtilSearch
      '(e. g. 10*5155 or 105658*)' => '(ex: 10*5155 or 105658*)',
      '(e. g. 234321)' => '(ex: 234321)',
      '(e. g. U5150)' => '(ex: U5150)',
      'and' => 'et le',
      'Customer User Login' => 'Nom de connexion du client',
      'Delete' => 'Effacer',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Recherche sur le texte d\'un article (ex: "Mar*in" or "Baue*")',
      'No time settings.' => 'Pas de paramettre de temps',
      'Profile' => 'Profil',
      'Result Form' => 'Format du rsultat',
      'Save Search-Profile as Template?' => 'Sauver le profil de recherche ?',
      'Search-Template' => 'Profil de recherche',
      'Select' => 'Slectionner',
      'Ticket created' => 'Ticket cre',
      'Ticket created between' => 'Ticket cre entre le',
      'Ticket Search' => 'Recherche de ticket',
      'TicketFreeText' => 'Texte Libre du Ticket',
      'Times' => 'Fois',
      'Yes, save it with name' => 'Oui, le sauver avec le nom',

    # Template: AgentUtilSearchByCustomerID
      'Customer history search' => 'recherche dans l\'historique client',
      'Customer history search (e. g. "ID342425").' => 'recherche dans l\'historique client (ex: "ID342425")',
      'No * possible!' => 'Pas de * possible',

    # Template: AgentUtilSearchNavBar
      'Change search options' => 'Changer les options de recherche',
      'Results' => 'Rsultat',
      'Search Result' => 'Rsultat de la recherche',
      'Total hits' => 'Total des hits',

    # Template: AgentUtilSearchResult
      '"}","15' => '',

    # Template: AgentUtilSearchResultPrint

    # Template: AgentUtilSearchResultPrintTable
      '"}","30' => '',

    # Template: AgentUtilSearchResultShort

    # Template: AgentUtilSearchResultShortTable

    # Template: AgentUtilSearchResultShortTableNotAnswered

    # Template: AgentUtilTicketStatus
      'All closed tickets' => 'Tout les tickets ferms',
      'All open tickets' => 'Tous les tickets ouverts',
      'closed tickets' => 'tickets ferms',
      'open tickets' => 'tickets ouverts',
      'or' => 'ou',
      'Provides an overview of all' => 'Propose un aperu de tous',
      'So you see what is going on in your system.' => 'Donc vous voyez ce qui se passe sur votre syst&egrave;me',

    # Template: AgentZoomAgentIsCustomer
      'Compose Follow up' => 'Fermer le suivie',
      'Your own Ticket' => 'Votre propre ticket',

    # Template: AgentZoomAnswer
      'Compose Answer' => 'Composer une rponse',
      'Contact customer' => 'Contacter le client',
      'phone call' => 'Appel tlphonique',

    # Template: AgentZoomArticle
      'Split' => 'Partager',

    # Template: AgentZoomBody
      'Change queue' => 'Changer de file',

    # Template: AgentZoomHead
      'Free Fields' => 'Champs libre',
      'Print' => 'Imprimer',

    # Template: AgentZoomStatus
      '"}","18' => '',

    # Template: CustomerCreateAccount
      'Create Account' => 'Crer un compte',

    # Template: CustomerError
      'Traceback' => 'Trace du retour d\'erreur',

    # Template: CustomerFAQArticleHistory
      'Edit' => 'editer',
      'FAQ History' => 'Historique de la FAQ',

    # Template: CustomerFAQArticlePrint
      'Category' => 'Cathgorie',
      'Keywords' => 'Mots cls',
      'Last update' => 'Dernire mise  jour',
      'Problem' => 'Problme',
      'Solution' => 'Solution',
      'Symptom' => 'Symptme',

    # Template: CustomerFAQArticleSystemHistory
      'FAQ System History' => 'Historique systme de la FAQ',

    # Template: CustomerFAQArticleView
      'FAQ Article' => 'Article de la FAQ',
      'Modified' => 'Modifi',

    # Template: CustomerFAQOverview
      'FAQ Overview' => 'Vue d\'ensemble de la FAQ',

    # Template: CustomerFAQSearch
      'FAQ Search' => 'Chercher dans la FAQ',
      'Fulltext' => 'Texte Complet',
      'Keyword' => 'Mot cl',

    # Template: CustomerFAQSearchResult
      'FAQ Search Result' => 'Rsultat de la recherche dans la FAQ',

    # Template: CustomerFooter
      'Powered by' => 'Fonction assur par',

    # Template: CustomerHeader
      'Contact' => 'Contact',
      'Home' => 'Accueil',
      'Online-Support' => 'Support en ligne',
      'Products' => 'Produits',
      'Support' => 'Support',

    # Template: CustomerLogin

    # Template: CustomerLostPassword
      'Lost your password?' => 'Mot de passe perdu ?',
      'Request new password' => 'Demande de nouveau mot de passe',

    # Template: CustomerMessage

    # Template: CustomerMessageNew

    # Template: CustomerNavigationBar
      'Create new Ticket' => 'Crtion d\'un nouveau Ticket',
      'FAQ' => 'FAQ',
      'New Ticket' => 'Nouveau Ticket',
      'Ticket-Overview' => 'Aperu des Tickets',
      'Welcome %s' => 'Bienvenue %s',

    # Template: CustomerPreferencesForm

    # Template: CustomerPreferencesGeneric

    # Template: CustomerPreferencesPassword

    # Template: CustomerStatusView
      'My Tickets' => 'Mes tickets',

    # Template: CustomerStatusViewTable

    # Template: CustomerTicketZoom

    # Template: CustomerWarning

    # Template: Error
      'Click here to report a bug!' => 'Cliquer ici pour signaler une anomalie',

    # Template: FAQArticleDelete
      'FAQ Delete' => 'Effacer la FAQ',
      'You really want to delete this article?' => 'Voulez vous vraiment effacer cet article&nbsp;?',

    # Template: FAQArticleForm
      'Comment (internal)' => '',
      'Filename' => 'Nom de fichier',
      'Short Description' => 'Description Courte',

    # Template: FAQArticleHistory

    # Template: FAQArticlePrint

    # Template: FAQArticleSystemHistory

    # Template: FAQArticleView

    # Template: FAQCategoryForm
      'FAQ Category' => 'Cathgorie dans la FAQ',

    # Template: FAQLanguageForm
      'FAQ Language' => 'Langue dans la FAQ',

    # Template: FAQNavigationBar

    # Template: FAQOverview

    # Template: FAQSearch

    # Template: FAQSearchResult

    # Template: FAQStateForm
      'FAQ State' => '',

    # Template: Footer
      'Top of Page' => 'Haut de page',

    # Template: Header

    # Template: InstallerBody
      'Create Database' => 'Crer la base de donne',
      'Drop Database' => 'Effacer la base de donne',
      'Finished' => 'Fini',
      'System Settings' => 'Paramttres Systme',
      'Web-Installer' => 'Installeur Web',

    # Template: InstallerFinish
      'Admin-User' => 'Administrateur',
      'After doing so your OTRS is up and running.' => 'Aprs avoir fait ceci votre OTRS est en service',
      'Have a lot of fun!' => 'Amusez vous bien&nbsp;!',
      'Restart your webserver' => 'Redemarrer votre serveur web',
      'Start page' => 'Page de dpart',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Pour pouvoir utiliser votre OTRS, vous devez entrer les commandes suivantes dans votre terminal en tant que root.',
      'Your OTRS Team' => 'Votre Groupe OTRS',

    # Template: InstallerLicense
      'accept license' => 'Accepter la licence',
      'don\'t accept license' => 'Ne pas accepter la licence',
      'License' => 'Licence',

    # Template: InstallerStart
      'Create new database' => 'Crer une nouvelle base de donne',
      'DB Admin Password' => 'Mot de passe administrateur base de donne',
      'DB Admin User' => 'nom de connexion de l\'administrateur base de donne',
      'DB Host' => 'Nom d\'hte de la base',
      'DB Type' => 'Type de SGBD',
      'default \'hot\'' => '',
      'Delete old database' => 'Effacer l\'ancine base de donne',
      'next step' => 'tape suivante',
      'OTRS DB connect host' => 'Hte de la base OTRS',
      'OTRS DB Name' => 'Nom de la base OTRS',
      'OTRS DB Password' => 'Mot de passe de la base OTRS',
      'OTRS DB User' => 'Utilisateur de la base OTRS',
      'your MySQL DB should have a root password! Default is empty!' => 'Votre base MySQL doit avoir un mot de passe root&nbsp;! Par dfaut cela est vide&nbsp;!',

    # Template: InstallerSystem
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Verifie les enregistrements MX des adresse email utiliss lors de la composition d\'une rponse. N\'utilisez pas la "Vrification des enregistrements MX" si votre serveur OTRS est derriere une ligne modem $!',
      '(Email of the system admin)' => 'Email de l\'administrateur syst',
      '(Full qualified domain name of your system)' => 'Nom de domaine complet de votre machine',
      '(Logfile just needed for File-LogModule!)' => 'fichier de log ncessaire pour le Module File-Log',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(L\'identit du systme. Chaque numro de ticket et chaque id de session http d avec ce nombre)',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identificateur des tickets. Certaines personnes veulent le configurer avec par ex: \'Ticket#\', \'Appel#\' ou \'MonTicket#\')',
      '(Used default language)' => 'Langage par dfaut utilis',
      '(Used log backend)' => 'Backend de log utilis',
      '(Used ticket number format)' => 'format numrique utilis pour les tickets',
      'CheckMXRecord' => 'Vrifier les enregistrements MX',
      'Default Charset' => 'Charset par dfaut',
      'Default Language' => 'Langage par dfaut ',
      'Logfile' => 'fichier de log',
      'LogModule' => 'Module de log',
      'Organization' => 'Socit',
      'System FQDN' => 'Nom de Domaine Compltement Renseign du systme',
      'SystemID' => 'ID Systme',
      'Ticket Hook' => '',
      'Ticket Number Generator' => 'Gnrateur de numro pour les tickets',
      'Use utf-8 it your database supports it!' => '',
      'Webfrontend' => 'Frontal web',

    # Template: Login

    # Template: LostPassword

    # Template: NoPermission
      'No Permission' => 'Pas d\'autorisation',

    # Template: Notify
      'Info' => 'Information',

    # Template: PrintFooter
      'URL' => 'URL',

    # Template: PrintHeader
      'printed by' => 'Imprim par :',

    # Template: QueueView
      'All tickets' => 'tous les tickets',
      'Page' => 'Page',
      'Queues' => 'Files',
      'Tickets available' => 'Tickets disponibles',
      'Tickets shown' => 'Tickets affichs',

    # Template: SystemStats
      'Graphs' => 'Graphiques',

    # Template: Test
      'OTRS Test Page' => 'Page de test d\'OTRS',

    # Template: TicketEscalation
      'Ticket escalation!' => 'Escalade du ticket',

    # Template: TicketView

    # Template: TicketViewLite
      'Add Note' => 'Ajouter une note',

    # Template: Warning

    # Misc
      'A message should have a From: recipient!' => 'Un message devrait avoir un champ From:',
      'AgentFrontend' => 'Interface du technicien',
      'Article free text' => 'Texte dans l\'article',
      'Charset' => 'Jeu de caractre',
      'Charsets' => 'Jeu de Charactre',
      'Create' => 'Crer',
      'Feature not activ!' => 'Fonction non activ',
      'Fulltext search' => 'Recherche ingrale de texte',
      'Fulltext search (e. g. "Mar*in" or "Baue*" or "martin+hallo")' => 'Recherche intgral de texte (ex: "Mar*in" ou "Constru*" ou "martin+bonjour")',
      'New state' => 'Nouvel tat',
      'New ticket via call.' => 'Nouveau ticket par tlphone',
      'New user' => 'Nouvel utilisateur',
      'Search in' => 'Recherche dans',
      'Select your screen after creating a new ticket via PhoneView.' => 'Choix de l\'cran affich apres avoir cre un ticket via la vue tlphone',
      'Set customer id of a ticket' => 'Dfinir le numro de client d\'un ticket',
      'Show all' => 'Tout montrer',
      'Status defs' => 'Dfinitions des Status',
      'System Charset Management' => 'Gestion du jeu de caractres systme',
      'System Language Management' => 'Gestion des langues du systme',
      'Ticket free text' => 'Texte du ticket',
      'Ticket limit:' => 'limitation des Ticket',
      'Time till escalation' => 'Dure avant escalade',
      'Users' => 'Utilisateurs',
      'With State' => 'Avec l\'tat',
      'You have to be in the admin group!' => 'Il est ncessaire d\'tre dans le groupe d\'administration&nbsp;!',
      'You have to be in the stats group!' => 'Il est ncessaire d\'tre dans le groupe des statistiques&nbsp;!',
      'You need a email address (e. g. customer@example.com) in From:!' => 'Vous devez avoir une adresse email dans le From:! (ex: client@example.com) ',
      'auto responses set' => 'Rponse automatique positionne',
      'search' => 'Recherche',
      'search (e. g. 10*5155 or 105658*)' => 'Recherche (ex: 10*5155 ou 105658*)',
      'store' => 'stocker',
      'tickets' => 'Tickets',
    );

    # $$STOP$$

    $Self->{Translation} = \%Hash;

}
# --
1;
