# --
# Kernel/Language/es.pm - provides es language translation
# Copyright (C) 2003-2004 Jorge Becerra <jorge at icc-cuba.com>
# --
# $Id: es.pm,v 1.25 2005/05/01 22:46:13 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::es;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.25 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;
    my %Hash = ();

    # $$START$$
    # Last translation file sync: Mon May  2 00:38:03 2005

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D.%M.%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %T %Y';
    $Self->{DateInputFormat} = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
      # Template: AAABase
      'Yes' => 'Si',
      'No' => '',
      'yes' => 'si',
      'no' => '',
      'Off' => '',
      'off' => '',
      'On' => '',
      'on' => '',
      'top' => 'inicio',
      'end' => 'fin',
      'Done' => 'Hecho',
      'Cancel' => 'Cancelar',
      'Reset' => 'Resetear',
      'day' => 'dia',
      'days' => 'dias',
      'hour' => 'hora',
      'hours' => 'horas',
      'minute' => 'minuto',
      'minutes' => 'minutos',
      'wrote' => 'escribi',
      'Message' => 'Mensaje',
      'Error' => '',
      'Bug Report' => 'Reporte de errores',
      'Attention' => 'Atencin',
      'Warning' => 'Atencin',
      'Module' => 'Mdulo',
      'Modulefile' => 'Archivo de mdulo',
      'Subfunction' => 'Subfunciones',
      'Line' => 'Linea',
      'Example' => 'Ejemplo',
      'Examples' => 'Ejemplos',
      'invalid' => 'invlido',
      ' 2 minutes' => ' 2 minutos',
      ' 5 minutes' => ' 5 minutos',
      ' 7 minutes' => ' 7 minutos',
      '10 minutes' => '10 minutos',
      '15 minutes' => '15 minutos',
      'Mr.' => '',
      'Mrs.' => '',
      'Next' => 'Siguiente',
      'Back' => 'Regresar',
      'Next...' => 'Siguiente...',
      '...Back' => '..Regresar',
      '-none-' => '',
      'none' => 'nada',
      'none!' => 'nada!',
      'none - answered' => 'nada  - respondido',
      'please do not edit!' => 'Por favor no lo edite!',
      'AddLink' => 'Adicionar enlace',
      'Link' => 'Vinculo',
      'Linked' => '',
      'Link (Normal)' => '',
      'Link (Parent)' => '',
      'Link (Child)' => '',
      'Normal' => '',
      'Parent' => '',
      'Child' => '',
      'Hit' => '',
      'Hits' => '',
      'Text' => 'Texto',
      'Lite' => 'Chica',
      'User' => 'Usuario',
      'Username' => 'Nombre de Usuario',
      'Language' => 'Idioma',
      'Languages' => 'Idiomas',
      'Password' => 'Contrasea',
      'Salutation' => 'Saludo',
      'Signature' => 'Firmas',
      'Customer' => 'Cliente',
      'CustomerID' => 'Nmero de cliente',
      'CustomerIDs' => '',
      'customer' => 'cliente',
      'agent' => 'agente',
      'system' => 'Sistema',
      'Customer Info' => 'Informacin del cliente',
      'go!' => 'ir!',
      'go' => 'ir',
      'All' => 'Todo',
      'all' => 'todo',
      'Sorry' => 'Disculpe',
      'update!' => 'Actualizar!',
      'update' => 'actualizar',
      'Update' => 'Actualizar',
      'submit!' => 'enviar!',
      'submit' => 'enviar',
      'Submit' => '',
      'change!' => 'cambiar!',
      'Change' => 'Cambiar',
      'change' => 'cambiar',
      'click here' => 'haga click aqu',
      'Comment' => 'Comentario',
      'Valid' => 'Vlido',
      'Name' => 'Nombre',
      'Group' => 'Grupo',
      'Description' => 'Descripcin',
      'description' => 'descripcin',
      'Theme' => 'Tema',
      'Created' => 'Creado',
      'Created by' => '',
      'Changed' => '',
      'Changed by' => '',
      'Search' => 'Buscar',
      'and' => 'y',
      'between' => '',
      'Fulltext Search' => '',
      'Data' => '',
      'Options' => 'Opciones',
      'Title' => 'Ttulo',
      'Item' => '',
      'Delete' => 'Borrar',
      'Edit' => 'Editar',
      'View' => 'Ver',
      'Number' => '',
      'System' => 'Sistema',
      'Contact' => 'Contacto',
      'Contacts' => '',
      'Export' => '',
      'Up' => '',
      'Down' => '',
      'Add' => 'Adicionar',
      'Category' => 'Categoria',
      'New message' => 'Nuevo mensaje',
      'New message!' => 'Nuevo mensaje!',
      'Admin-Area' => 'Area de administracin',
      'Agent-Area' => 'Area-Agente',
      'FAQ-Area' => 'Area-FAQ',
      'QueueView' => 'Ver la cola',
      'Stats' => 'Estadisticas',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Por favor responda el ticket para regresar a la vista normal de la cola.',
      'You got new message!' => 'Ud tiene un nuevo mensaje',
      'You have %s new message(s)!' => 'Ud tiene %s nuevos mensaje(s)!',
      'You have %s reminder ticket(s)!' => 'Ud tiene %s tickets recordatorios',
      'The recommended charset for your language is %s!' => 'EL juego de caracteres recomendado para su idioma es %s!',
      'Passwords dosn\'t match! Please try it again!' => 'Las contraseas no coinciden. Por favor Reintente!',
      'Password is already in use! Please use an other password!' => '',
      'Password is already used! Please use an other password!' => '',
      'No suggestions' => 'Sin sugerencias',
      'Word' => 'Palabra',
      'Ignore' => 'Ignorar',
      'replace with' => 'reemplazar con',
      'Welcome to OTRS' => 'Bienvenido a OTRS',
      'There is no account with that login name.' => 'No existe una cuenta con ese login',
      'Login failed! Your username or password was entered incorrectly.' => 'Identificacin incorrecta. Su nombre de usuario o contrasea fue introducido incorrectamente',
      'Please contact your admin' => 'Por favor contace su administrador',
      'Logout successful. Thank you for using OTRS!' => 'Desconexin exitosa. Gracias por utilizar OTRS!',
      'Invalid SessionID!' => 'Sesin no vlida',
      'Feature not active!' => 'Caracterstica no activa',
      'Ticket Number' => 'Ticket Nmero',
      'Ticket Object' => '',
      'No such Ticket Number "%s"! Can\'t link it!' => 'No existe el Ticket Numero "%s"! No puede elnazarlo!',
      'Take this Customer' => 'Tomar este cliente',
      'Take this User' => 'Tomar este usuario',
      'possible' => 'posible',
      'reject' => 'rechazar',
      'Facility' => 'Instalacin',
      'Timeover' => '',
      'Pending till' => 'Pendiente hasta',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'No trabaje con el Identificador 1 (cuenta de sistema)! Cree nuevos usuarios! ',
      'Dispatching by email To: field.' => 'Despachar por correo del campo To:',
      'Dispatching by selected Queue.' => 'Despachar por la cola seleccionada',
      'No entry found!' => 'No se encontr!',
      'Session has timed out. Please log in again.' => 'La sesin ha expirado. Por favor conectese nuevamente.',
      'No Permission!' => 'No tiene Permiso!',
      'To: (%s) replaced with database email!' => 'To: (%s) sustituido con email de la base de datos!',
      'Cc: (%s) added database email!' => '',
      'Don\'t show closed Tickets' => 'No mostrar los tickets cerrados',
      'Show closed Tickets' => 'Mostrar Tickets cerrados',
      'New Article' => 'Nuevo Articulo',
      '(Click here to add)' => '(Haga click aqui para agregar)',
      'last' => 'ltimo',
      'before' => 'antes',
      'day(s)' => 'dias(s)',
      'month(s)' => 'mes(es)',
      'week(s)' => 'semana(s)',
      'year(s)' => 'ao(s)',
      'Preview' => 'Vista Previa',
      'Added User "%s"' => 'Aadido Usuario "%s"',
      'Contract' => 'Contrato',
      'Online Customer: %s' => 'Cliente Conectado: %s',
      'Online Agent: %s' => 'Agente Conectado: %s',
      'Calendar' => 'Calendario',
      'File' => 'Archivo',
      'Filename' => 'Nombre del archivo',
      'Type' => 'Tipo',
      'Size' => 'Tamao',
      'Upload' => '',
      'Directory' => 'Directorio',
      'Signed' => 'Firmado',
      'Sign' => 'Firma',
      'Crypted' => 'Encriptado',
      'Crypt' => 'Encriptar',
      'History::Move' => 'Ticket movido a la cola "%s" (%s) de la cola "%s" (%s).',
      'History::NewTicket' => 'Nuevo Ticket [%s] createdo (Q=%s;P=%s;S=%s).',
      'History::FollowUp' => 'Seguimiento para [%s]. %s',
      'History::SendAutoReject' => 'Rechazo automtico enviado a "%s".',
      'History::SendAutoReply' => 'Respuesta automtica enviada a "%s".',
      'History::SendAutoFollowUp' => 'Seguimiento automtico enviado a "%s".',
      'History::Forward' => 'Reenviado a "%s".',
      'History::Bounce' => 'Reenviado a "%s".',
      'History::SendAnswer' => 'Correo enviado a "%s".',
      'History::SendAgentNotification' => '"%s"-notificacin enviada a "%s".',
      'History::SendCustomerNotification' => 'Notificaci&oacuten; enviada a "%s".',
      'History::EmailAgent' => 'Correo enviado al cliente.',
      'History::EmailCustomer' => 'Adicionado correo. %s',
      'History::PhoneCallAgent' => 'El agente llam al cliente.',
      'History::PhoneCallCustomer' => 'El cliente llam.',
      'History::AddNote' => 'Adicionada nota (%s)',
      'History::Lock' => 'Ticket bloqueado.',
      'History::Unlock' => 'Ticket desbloqueado.',
      'History::TimeAccounting' => '%s unidad(es) de tiempo contabilizadas. Nuevo total : %s uniodad(es) de tiempo.',
      'History::Remove' => '%s',
      'History::CustomerUpdate' => 'Actualizado: %s',
      'History::PriorityUpdate' => 'Cambiar prioridad de "%s" (%s) a "%s" (%s).',
      'History::OwnerUpdate' => 'El nuevo propietario es "%s" (ID=%s).',
      'History::LoopProtection' => 'Proteccin de lazo! NO se envio auto-respuesta a "%s".',
      'History::Misc' => '%s',
      'History::SetPendingTime' => 'Actualizado: %s',
      'History::StateUpdate' => 'Antiguo: "%s" Nuevo: "%s"',
      'History::TicketFreeTextUpdate' => 'Actualizado: %s=%s;%s=%s;',
      'History::WebRequestCustomer' => 'Solicitud de cliente via web.',
      'History::TicketLinkAdd' => 'Adicionado enlace al ticket "%s".',
      'History::TicketLinkDelete' => 'Eliminado enlace al ticket "%s".',

      # Template: AAAMonth
      'Jan' => 'Ene',
      'Feb' => '',
      'Mar' => '',
      'Apr' => 'Abr',
      'May' => '',
      'Jun' => '',
      'Jul' => '',
      'Aug' => 'Ago',
      'Sep' => '',
      'Oct' => '',
      'Nov' => '',
      'Dec' => 'Dic',

      # Template: AAANavBar
      'Send Email and create a new Ticket' => '',
      'Create new Phone Ticket' => 'Crear un nuevo Ticket Telefonico',
      'Ticket-Area' => '',
      'Overview of all open Tickets' => 'Resumen de todos los tickets abiertos',
      'Logout' => 'Desconectarse',
      'Agent Preferences' => 'Preferencias de Agente',
      'Preferences' => 'Preferencias',
      'Agent Mailbox' => '',
      'Stats-Area' => '',
      'FAQ' => '',
      'FAQ-Search' => '',
      'FAQ-Article' => '',
      'FAQ-State' => '',
      'Admin' => '',
      'Create new Ticket' => 'Crear un nuevo ticket',
      'New Ticket' => 'Nuevo ticket',

      # Template: AAAPreferences
      'Preferences updated successfully!' => 'Las preferencia fueron actualizadas!',
      'Mail Management' => 'Gestin de Correos',
      'Frontend' => 'Frontal',
      'Other Options' => 'Otras Opciones',
      'New ticket notification' => 'Notificacin de nuevos tickets',
      'Send me a notification if there is a new ticket in "My Queues".' => 'Notifqueme si hay un nuevo ticket en "Mis Colas".',
      'Follow up notification' => 'Seguimiento a notificaciones',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Notifqueme si un cliente env un seguimiento y yo soy el dueo del ticket.',
      'Ticket lock timeout notification' => 'Notificacin de bloqueo de tickets por tiempo',
      'Send me a notification if a ticket is unlocked by the system.' => 'Notifqueme si un ticket es desbloqueado por el sistema',
      'Move notification' => 'Notificacin de movimientos',
      'Send me a notification if a ticket is moved into one of "My Queues".' => 'Notifqueme si un ticket es colocado en una de "Mis Colas".',
      'Custom Queue' => 'Cola personal',
      'QueueView refresh time' => 'Tiempo de actualizacin de la vista de colas',
      'Select your QueueView refresh time.' => 'Seleccione su tiempo de actualizacin de la vista de colas',
      'Select your frontend language.' => 'Seleccione su idioma de trabajo',
      'Select your frontend Charset.' => 'Seleccione su juego de caracteres',
      'Select your frontend Theme.' => 'Seleccione su tema',
      'Select your frontend QueueView.' => 'Seleccione su Vista de cola de trabajo',
      'Spelling Dictionary' => 'Diccionario Ortogrfico',
      'Select your default spelling dictionary.' => 'Seleccione su diccionario por defecto',
      'PhoneView' => 'Vista telefnica',
      'TicketZoom' => 'Detalle de Ticket',
      'CreateTicket' => 'CrearTicket',
      'Screen after new ticket' => 'Pantalla posterior a nuevo ticket',
      'Select your screen after creating a new ticket.' => 'Seleccione la pantalla a mostrar despues de crear un ticket',
      'Closed Tickets' => 'Tickets Cerrados',
      'Show closed tickets.' => 'Mostrar Tickets cerrados',
      'Max. shown Tickets a page in QueueView.' => 'Cantidad de Tickets a mostrar en la Vista de Cola',
      'Max. shown Tickets a page in Overview.' => 'Cantidad de Tickets a mostrar en Resumen',
      'Can\'t update password, passwords dosn\'t match! Please try it again!' => '',
      'Can\'t update password, invalid characters!' => '',
      'Can\'t update password, need min. 8 characters!' => '',
      'Can\'t update password, need 2 lower and 2 upper characters!' => '',
      'Can\'t update password, need min. 1 digit!' => '',
      'Can\'t update password, need min. 2 characters!' => '',

      # Template: AAATicket
      'Lock' => 'Bloquear',
      'Unlock' => 'Desbloquear',
      'History' => 'Historia',
      'Zoom' => 'Detalle',
      'Age' => 'Antiguedad',
      'Bounce' => 'Rebotar',
      'Forward' => 'Reenviar',
      'From' => 'De',
      'To' => 'Para',
      'Cc' => 'Copia ',
      'Bcc' => 'Copia Invisible',
      'Subject' => 'Asunto',
      'Move' => 'Mover',
      'Queue' => 'Colas',
      'Priority' => 'Prioridad',
      'State' => 'Estado',
      'Compose' => 'Componer',
      'Pending' => 'Pendiente',
      'Owner' => 'Propietario',
      'Sender' => 'Emisor',
      'Article' => 'Artculo',
      'Ticket' => '',
      'Createtime' => 'Fecha de creacin ',
      'plain' => 'texto',
      'eMail' => 'Correo',
      'email' => 'correo',
      'Close' => 'Cerrar',
      'Action' => 'Accin',
      'Attachment' => 'Anexo',
      'Attachments' => 'Anexos',
      'This message was written in a character set other than your own.' => 'Este mensaje fue escrito usando un juego de caracteres distinto al suyo',
      'If it is not displayed correctly,' => 'Si no se muestra correctamente',
      'This is a' => 'Este es un',
      'to open it in a new window.' => 'Para abrir en una nueva ventana',
      'This is a HTML email. Click here to show it.' => 'Este es un mensaje HTML. Haga click aqu para mostrarlo.',
      'closed successful' => 'cerrado exitosamente',
      'closed unsuccessful' => 'cerrado sin xito',
      'new' => 'nuevo',
      'open' => 'abierto',
      'closed' => 'cerrado',
      'removed' => 'eliminado',
      'pending reminder' => 'recordatorio pendiente',
      'pending auto close+' => 'pendiente auto close+',
      'pending auto close-' => 'pendiente auto close-',
      'email-external' => 'correo-externo',
      'email-internal' => 'correo-interno',
      'note-external' => 'nota-externa',
      'note-internal' => 'nota-interna',
      'note-report' => 'nota-reporte',
      'phone' => 'telfono',
      'sms' => '',
      'webrequest' => 'Solicitud via web',
      'lock' => 'bloqueado',
      'unlock' => 'desbloqueado',
      'very low' => 'muy bajo',
      'low' => 'bajo',
      'normal' => '',
      'high' => 'alto',
      'very high' => 'muy alto',
      '1 very low' => '1 muy bajo',
      '2 low' => '2 bajo',
      '3 normal' => '',
      '4 high' => '4 alto',
      '5 very high' => '5 muy alto',
      'Ticket "%s" created!' => 'Ticket "%s" creado!',

      # Template: AAAWeekDay
      'Sun' => 'Dom',
      'Mon' => 'Lun',
      'Tue' => 'Mar',
      'Wed' => 'Mie',
      'Thu' => 'Jue',
      'Fri' => 'Vie',
      'Sat' => 'Sab',

      # Template: AdminAttachmentForm
      'Attachment Management' => 'Gestn de Anexos',

      # Template: AdminAutoResponseForm
      'Auto Response Management' => 'Gestin de respuestas automticas',
      '"} <a href="Action=">$Text{"' => '',
      'Response' => 'Respuesta',
      'Auto Response From' => 'Respuesta automtica de ',
      'Note' => 'Nota',
      'Useable options' => 'Opciones accesibles',
      'to get the first 20 character of the subject' => 'para obtener los primeros 20 caracteres del asunto ',
      'to get the first 5 lines of the email' => 'para obtener las primeras 5 lneas del correo',
      'to get the from line of the email' => 'para obtener la linea from del correo',
      'to get the realname of the sender (if given)' => 'para obtener el nombre del emisor (si lo proporcion)',
      'Options of the ticket data (e. g. &lt;OTRS_TICKET_TicketNumber&gt;, &lt;OTRS_TICKET_TicketID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',

      # Template: AdminCustomerUserForm
      'The message being composed has been closed.  Exiting.' => 'El mensaje que se estaba redactando ha sido cerrado. Saliendo.!',
      'This window must be called from compose window' => 'Esta ventana debe ser llamada desde la ventana de redaccin',
      'Customer User Management' => 'Gestin de clientes',
      'Search for' => 'Buscar por',
      'Result' => 'Resultado',
      'Select Source (for add)' => 'Seleccionar Fuente (para adicionar)',
      'Source' => 'Origen',
      '"} <a href="Action=AdminCustomerUser&Nav=">$Text{"' => '',
      '"}: <font color="red" title="$Text{"This values are required.' => '',
      'This values are read only.' => 'Estos valores son solo-lectura',
      '"} $Text{"' => '',
      '"}:<br><i class="small">($Text{"' => '',
      'This values are required.' => 'Estos valores son obligatorios',
      'Customer user will be needed to have an customer histor and to to login via customer panels.' => 'El cliente necesita tener una historia y conectarse via panel de clientes',

      # Template: AdminCustomerUserGroupChangeForm
      'Customer Users <-> Groups Management' => '',
      'Change %s settings' => 'Cambiar %s especificaciones',
      'Select the user:group permissions.' => 'Seleccionar los permisos de usuario:grupo',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Si no se selecciona algo, no habrn permisos en este grupo (Los tickets no estarn disponibles para este cliente).',
      'Permission' => 'Permisos',
      'ro' => '',
      'Read only access to the ticket in this group/queue.' => 'Acceso de solo lectura a los tickets en este grupo/cola.',
      'rw' => '',
      'Full read and write access to the tickets in this group/queue.' => 'Acceso completo de lectura y escritura a los tickets en este grupo/cola.',

      # Template: AdminCustomerUserGroupForm
      'Change user <-> group settings' => 'Modificar usuario <-> Especificaciones de grupo',

      # Template: AdminEmail
      'Admin-Email' => 'Correo Administrativo',
      'Message sent to' => 'Mensaje enviado a',
      'Recipents' => 'Receptores',
      'Body' => 'Cuerpo',
      'send' => 'enviar',

      # Template: AdminGenericAgent
      'GenericAgent' => '',
      'Job-List' => 'Lista de Tareas',
      'Last run' => 'ltima corrida',
      'valid' => '',
      'Run Now!' => '',
      'x' => '',
      'Save Job as?' => 'Guardar Tarea como?',
      'Is Job Valid?' => '',
      'Is Job Valid' => '',
      'Schedule' => 'Horario',
      'Minutes' => 'Minutos',
      'Hours' => 'Horas',
      'Days' => 'Dias',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Bsqueda de texto en Articulo (ej. "Mar*in" or "Baue*")',
      '(e. g. 10*5155 or 105658*)' => '',
      '(e. g. 234321)' => '',
      'Customer User Login' => 'Identificador del cliente',
      '(e. g. U5150)' => '',
      'Agent' => 'Agente',
      'TicketFreeText' => '',
      'Ticket Lock' => 'Ticket Bloqueado',
      'Times' => 'Veces',
      'No time settings.' => 'Sin especificacin de fecha',
      'Ticket created' => 'Ticket creado',
      'Ticket created between' => 'Ticket creado entre',
      'New Priority' => 'Nueva prioridad',
      'New Queue' => 'Nueva Cola',
      'New State' => 'Nuevo estado',
      'New Agent' => 'Nuevo Agente',
      'New Owner' => 'Nuevo Propietario',
      'New Customer' => 'Nuevo Cliente',
      'New Ticket Lock' => 'Nuevo bloqueo de ticket!',
      'CustomerUser' => 'Usuario Cliente',
      'Add Note' => 'Adicionar Nota',
      'CMD' => '',
      'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Se ejecutar el comando. ARG[0] el nmero del ticket. ARG[0] el id del ticket.',
      'Delete tickets' => 'Eliminar tickets',
      'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Aviso! Estos tickets sern eliminados de la base de datos! Los mismos se perdern!',
      'Modules' => 'Mdulos',
      'Param 1' => 'Parmetro 1',
      'Param 2' => 'Parmetro 2',
      'Param 3' => 'Parmetro 3',
      'Param 4' => 'Parmetro 4',
      'Param 5' => 'Parmetro 5',
      'Param 6' => 'Parmetro 6',
      'Save' => 'Guardar',

      # Template: AdminGroupForm
      'Group Management' => 'Administracin de grupos',
      '"} <a href="Action=AdminGroup">$Text{"' => '',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'El grupo admin es para usar el rea de administracin y el grupo stats para usar el rea estadisticas.',
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crear nuevos grupos para manipular los permisos de acceso por distintos grupos de agente (ejemplo: departamento de compra, departamento de soporte, departamento de ventas,...).',
      'It\'s useful for ASP solutions.' => 'Esto es til para soluciones ASP.',

      # Template: AdminLog
      'System Log' => 'Trazas del Sistema',
      'Time' => 'Tiempo',

      # Template: AdminNavigationBar
      'Users' => '',
      'Groups' => 'Grupos',
      'Roles' => '',
      'Responses' => 'Respuestas',
      'Misc' => 'Miscelaneas',

      # Template: AdminNotificationForm
      'Notification Management' => 'Gestin de Notificaciones',
      'Notification' => '',
      'Notifications are sent to an agent or a customer.' => 'Las notificacin se le envian a un agente o cliente',
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Opciones de configuracin (ej: &lt;OTRS_CONFIG_HttpType&gt;)',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opciones de propietario del ticket (ej. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opciones del usuario activo que solicita esta accin (ej. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Opciones del usuario activo',

      # Template: AdminPackageManager
      'Package Manager' => '',
      'Uninstall' => '',
      'Verion' => '',
      'Do you really want to uninstall this package?' => '',
      'Install' => '',
      'Package' => '',
      'Online Repository' => '',
      'Version' => '',
      'Vendor' => '',
      'Upgrade' => '',
      'Local Repository' => '',
      'Status' => 'Estado',
      'Overview' => 'Resumen',
      'Download' => 'Descargar',
      'Rebuild' => '',
      'Reinstall' => '',

      # Template: AdminPGPForm
      'PGP Management' => '',
      'Identifier' => 'Identificador',
      'Bit' => '',
      'Key' => 'Llave',
      'Fingerprint' => '',
      'Expires' => 'Expira',
      'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'De esta forma Ud puede editar directamente las llaves configuradas en Kernel/Config.pm.',
      'FIXME: WHAT IS PGP?' => '',

      # Template: AdminPOP3Form
      'POP3 Account Management' => 'Gestin de cuenta POP3',
      'Host' => '',
      'Trusted' => 'Confiable',
      'Dispatching' => 'Remitiendo',
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Todos los correos de entrada sern enviados a la cola seleccionada',
      'If your account is trusted, the already existing x-otrs header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Si su cuenta es confiable, los headers ya existentes x-otrs en la llegada se utilizarn para la prioridad! El filtro Postmaster se usa de todas formas.',

      # Template: AdminPostMasterFilter
      'PostMaster Filter Management' => 'Gestin del filtro maestro',
      'Filtername' => '',
      'Match' => 'Coincidir',
      'Header' => 'Encabezado',
      'Value' => 'Valor',
      'Set' => '',
      'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Clasificar o filtrar correos entrantes basado en el encabezamiento X-Headers del correo! Puede utilizar expresiones regulares.',
      'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Si utilza expresion regular, puede tambien usar el valor encontrado en () as [***] en \'Set\'.',

      # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Responses Management' => '',

      # Template: AdminQueueAutoResponseTable

      # Template: AdminQueueForm
      'Queue Management' => 'Gestin de Colas',
      'Sub-Queue of' => 'Subcola de',
      'Unlock timeout' => 'Tiempo para desbloqueo automtico',
      '0 = no unlock' => '0 = sin bloqueo',
      'Escalation time' => 'Tiempo de escalado',
      '0 = no escalation' => '0 = sin escalado',
      'Follow up Option' => 'Opcin de seguimiento',
      'Ticket lock after a follow up' => 'Bloquear un ticket despus del seguimiento',
      'Systemaddress' => 'Direcciones de correo del sistema',
      'Customer Move Notify' => 'Notificar al Cliente al Mover',
      'Customer State Notify' => 'Notificacin de estado al Cliente',
      'Customer Owner Notify' => 'Notificar al Dueo al Mover',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Si un agente bloquea un ticket y el/ella no env una respuesta en este tiempo, el ticket sera desbloqueado automticamente',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Si un ticket no ha sido respondido es este tiempo, solo este ticket se mostrar',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Si el tickes esta cerrado y el cliente env un seguimiento al mismo este ser bloqueado para el antiguo propietario',
      'Will be the sender address of this queue for email answers.' => 'Ser la direccin del emisor en esta cola para respuestas por correo.',
      'The salutation for email answers.' => 'Saludo para las respuestas por correo.',
      'The signature for email answers.' => 'Firma para respuestas por correo.',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS env una notificacin por correo si el ticket se mueve',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS env una notificacin por correo al cliente si el estado del ticket cambia',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS env una notificacin por correo al cliente si el due&ntildeo; del ticket cambia',

      # Template: AdminQueueResponsesChangeForm
      'Responses <-> Queue Management' => '',

      # Template: AdminQueueResponsesForm
      'Answer' => 'Responder',

      # Template: AdminResponseAttachmentChangeForm
      'Responses <-> Attachments Management' => '',

      # Template: AdminResponseAttachmentForm

      # Template: AdminResponseForm
      'Response Management' => 'Gestin de respuestas',
      'A response is default text to write faster answer (with default text) to customers.' => 'Una respuesta es el texto por defecto para escribir respuestas ms rapido (con el texto por defecto) a los clientes.',
      'Don\'t forget to add a new response a queue!' => 'No olvide incluir una nueva respuesta en la cola!',
      'Next state' => 'Siguiente estado',
      'All Customer variables like defined in config option CustomerUser.' => '',
      'The current ticket state is' => 'El estado actual del ticket es',
      'Your email address is new' => 'Su direccin de correo es nueva',

      # Template: AdminRoleForm
      'Role Management' => 'Gestin de Roles',
      'Create a role and put groups in it. Then add the role to the users.' => 'Crea un rol y coloca grupos en el mismo. Luego adiciona el rol a los usuarios.',
      'It\'s useful for a lot of users and groups.' => 'Es til para gestionar muchos usuarios y grupos.',

      # Template: AdminRoleGroupChangeForm
      'Roles <-> Groups Management' => '',
      'move_into' => 'mover_a',
      'Permissions to move tickets into this group/queue.' => 'Permiso para mover tickets a este grupo/cola',
      'create' => 'crear',
      'Permissions to create tickets in this group/queue.' => 'Permiso para crear tickets en este grupo/cola',
      'owner' => 'propietario',
      'Permissions to change the ticket owner in this group/queue.' => 'Permiso para cambiar el propietario del ticket en este grupo/cola',
      'priority' => 'prioridad',
      'Permissions to change the ticket priority in this group/queue.' => 'Permiso para cambiar la prioridad del ticket en este grupo/cola',

      # Template: AdminRoleGroupForm
      'Change roles <-> groups settings' => '',
      'Role' => 'Rol',

      # Template: AdminRoleUserChangeForm
      'Roles <-> Users Management' => '',
      'Active' => 'Activo',
      'Select the role:user relations.' => 'Seleccionar las relaciones Rol-Cliente',

      # Template: AdminRoleUserForm
      'Change users <-> roles settings' => '',

      # Template: AdminSalutationForm
      'Salutation Management' => 'Gestin de saludos',
      '"} <a href="Action=AdminSalutation">$Text{"' => '',
      'customer realname' => 'Nombre del cliente',
      'for agent firstname' => 'nombre del agente',
      'for agent lastname' => 'apellido del agente',
      'for agent user id' => 'id del agente',
      'for agent login' => 'login del agente',

      # Template: AdminSelectBoxForm
      'Select Box' => 'Ventana de seleccin',
      'SQL' => '',
      'Limit' => 'Lmite',
      'Select Box Result' => 'Seleccione tipo de resultado',

      # Template: AdminSession
      'Session Management' => 'Gestin de sesiones',
      'Sessions' => 'Sesiones',
      'Uniq' => '',
      'kill all sessions' => 'Finalizar todas las sesiones',
      'Session' => 'Sesin',
      'kill session' => 'Finalizar una sesin',

      # Template: AdminSignatureForm
      'Signature Management' => 'Gestin de firmas',
      '"} <a href="Action=AdminSignature">$Text{"' => '',

      # Template: AdminSMIMEForm
      'SMIME Management' => '',
      'Add Certificate' => 'Adicionar un certificado',
      'Add Private Key' => 'Adicionar una Llave privada',
      'Secret' => 'Secreto',
      'Hash' => '',
      'In this way you can directly edit the certification and private keys in file system.' => 'De esta fomra Ud puede editar directamente la certificacion y llaves privadas el el sistema de archivos.',
      'FIXME: WHAT IS SMIME?' => '',

      # Template: AdminStateForm
      'System State Management' => 'Gestin de estados del Sistema',
      'State Type' => 'Tipo de estado',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Recuerde tambien actualizar los estados en su archivo Kernel/Config.pm! ',
      'See also' => 'Vea tambien',

      # Template: AdminSysConfig
      'SysConfig' => '',
      'Group selection' => '',
      'Show' => '',
      'Subgroup' => '',

      # Template: AdminSysConfigEdit
      'Options ' => '',
      'for ' => '',
      'Subgroup \'' => '',
      '\' ' => '',
      'Content' => '',
      'New' => 'Nuevo',
      'Group Ro' => '',
      'NavBarName' => '',
      'Image' => '',
      'Typ' => '',
      'Prio' => '',
      'Block' => '',
      'NavBar' => '',

      # Template: AdminSystemAddressForm
      'System Email Addresses Management' => 'Gestin de direcciones de correo del sistema',
      'Email' => 'Correo',
      'Realname' => 'Nombre real',
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Todos los mensajes entrantes con este correo(To:) sern enviados a la cola seleccionada!',

      # Template: AdminUserForm
      'User Management' => 'Administracin de usuarios',
      '"} <a href="Action=AdminUser">$Text{"' => '',
      'Firstname' => 'Nombre',
      'Lastname' => 'Apellido',
      'User will be needed to handle tickets.' => 'Se necesita un usuario para manipular los tickets.',
      'Don\'t forget to add a new user to groups!' => 'No olvide incluir el usuario en grupos!',

      # Template: AdminUserGroupChangeForm
      'Users <-> Groups Management' => '',

      # Template: AdminUserGroupForm

      # Template: AgentBook
      'Address Book' => 'Libreta de Direcciones',
      'Return to the compose screen' => 'Regresar a la pantalla de redaccin',
      'Discard all changes and return to the compose screen' => 'Descartar todos los cambios y regresar a la pantalla de redaccin',

      # Template: AgentCustomerTableView

      # Template: AgentInfo
      'Info' => 'Informacin',

      # Template: AgentLinkObject
      'Link Object' => '',
      '"}" $Text{"with' => '',
      'Select' => 'Seleccionar',
      'Results' => 'Resultados',
      'Total hits' => 'Total de coincidencias',
      'Site' => 'Sitio',
      'Detail' => '',

      # Template: AgentLookup
      'Lookup' => '',

      # Template: AgentNavigationBar
      '"}"><a href="" onmouseover="window.status=\'$Text{"' => '',
      '"}"><br>$Text{"' => '',
      'Ticket selected for bulk action!' => 'Ticket seleccionado para accin mltiple!',
      'You need min. one selected Ticket!' => 'Necesita al menos seleccionar un Ticket!',

      # Template: AgentPreferencesForm

      # Template: AgentSpelling
      'Spell Checker' => 'Chequeo Ortogrfico',
      'spelling error(s)' => 'errores gramaticales',
      'or' => 'o',
      'Apply these changes' => 'Aplicar los cambios',

      # Template: AgentTicketBounce
      'A message should have a To: recipient!' => 'El mensaje debe tenes el destinatario To: !',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Necesita una direccin de correo (ejemplo: cliente@ejemplo.com) en To:!',
      'Bounce ticket' => 'Ticket rebotado',
      'Bounce to' => 'Rebotar a',
      'Next ticket state' => 'Nuevo estado del ticket',
      'Inform sender' => 'Informar al emisor',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Su correo con el ticket nmero "<OTRS_TICKET>"  fue rebotado a "<OTRS_BOUNCE_TO>". Contacte dicha direccin para mas informacin',
      'Send mail!' => 'Enviar correo!',

      # Template: AgentTicketBulk
      'A message should have a subject!' => 'Los mensajes deben tener asunto!',
      'Ticket Bulk Action' => 'Accin mltiple con Tickets',
      '$Text{"Note!' => '$Text{"Nota!',
      'Spell Check' => 'Chequeo Ortogrfico',
      'Note type' => 'Tipo de nota',
      'Unlock Tickets' => '',

      # Template: AgentTicketClose
      'A message should have a body!' => 'Los mensajes deben tener contenido',
      'You need to account time!' => 'Necesita contabilizar el tiempo!',
      'Close ticket' => 'Cerrar el ticket',
      'Close!' => 'Cerrar!',
      'Note Text' => 'Nota!',
      'Close type' => 'Tipo de cierre',
      'Time units' => 'Unidades de tiempo',
      ' (work units)' => ' (unidades de trabajo)',

      # Template: AgentTicketCompose
      'A message must be spell checked!' => 'El mensaje debe ser chequeado ortograficamente!',
      'Compose answer for ticket' => 'Redacte una respuesta al ticket',
      'Attach' => 'Anexo',
      'Pending Date' => 'Fecha pendiente',
      'for pending* states' => 'en estado pendiente*',

      # Template: AgentTicketCustomer
      'Change customer of ticket' => 'Cambiar cliente del ticket',
      'Set customer user and customer id of a ticket' => 'Asignar agente y cliente de un ticket',
      'Customer User' => 'Cliente',
      'Search Customer' => 'Bsquedas del cliente',
      'Customer Data' => 'Informacin del cliente',
      'Customer history' => 'Historia del cliente',
      'All customer tickets.' => 'Todos los tickets de un cliente',

      # Template: AgentTicketCustomerMessage
      'Follow up' => 'Seguimiento',

      # Template: AgentTicketEmail
      'Compose Email' => 'Redactar Correo',
      'new ticket' => 'nuevo ticket',
      'Clear To' => 'Copia Oculta a',
      'All Agents' => 'Todos los Agentes',

      # Template: AgentTicketForward
      'Article type' => 'Tipo de artculo',

      # Template: AgentTicketFreeText
      'Change free text of ticket' => 'Cambiar el texto libre del ticket',

      # Template: AgentTicketHistory
      'History of' => 'Historia de',

      # Template: AgentTicketLocked
      'Ticket locked!' => 'Ticket bloqueado!',
      'Ticket unlock!' => 'Ticket desbloqueado!',

      # Template: AgentTicketMailbox
      'Mailbox' => 'Buzn',
      'Tickets' => '',
      'All messages' => 'Todos los mensajes',
      'New messages' => 'Nuevo mensaje',
      'Pending messages' => 'Mensajes pendientes',
      'Reminder messages' => 'Mensajes recordatorios',
      'Reminder' => 'Recordatorio',
      'Sort by' => 'Ordenado por',
      'Order' => 'Orden',
      'up' => 'arriba',
      'down' => 'abajo',
      '"}\'; return true;" onmouseout="window.status=\'\';" class="menuitem" title="$Text{"' => '',
      '"}"}">$Quote{"$Text{""}' => '',

      # Template: AgentTicketMerge
      'You need to use a ticket number!' => '',
      'Ticket Merge' => '',
      'Merge to' => '',
      'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => '',

      # Template: AgentTicketMove
      'Queue ID' => 'Id de la Cola',
      'Move Ticket' => 'Mover Ticket',
      'Previous Owner' => 'Propietario Anterior',

      # Template: AgentTicketNote
      'Add note to ticket' => 'Adicionar nota al ticket',
      'Inform Agent' => '',
      'Optional' => '',
      'Inform involved Agents' => '',

      # Template: AgentTicketOwner
      'Change owner of ticket' => 'Cambiar el propietario del ticket',
      'Message for new Owner' => 'Mensaje para el nuevo propietario',

      # Template: AgentTicketPending
      'Set Pending' => 'Indicar pendiente',
      'Pending type' => 'Tipo pendiente',
      'Pending date' => 'Fecha pendiente',

      # Template: AgentTicketPhone
      'Phone call' => 'Llamada telefnica',

      # Template: AgentTicketPhoneNew
      'Clear From' => 'Borrar From',

      # Template: AgentTicketPlain
      'Plain' => 'Texto plano',
      'TicketID' => 'Identificador de Ticket',
      'ArticleID' => 'Identificador de articulo',

      # Template: AgentTicketPrint
      'Ticket-Info' => '',
      'Accounted time' => 'Tiempo contabilizado',
      'Escalation in' => 'Escalado en',
      'Linked-Object' => '',
      'Parent-Object' => '',
      'Child-Object' => '',
      'by' => 'por',

      # Template: AgentTicketPriority
      'Change priority of ticket' => 'Cambiar la prioridad al ticket',

      # Template: AgentTicketQueue
      'Tickets shown' => 'Tickets mostrados',
      'Page' => 'Pgina',
      'Tickets available' => 'Tickets disponibles',
      'All tickets' => 'Todos los tickets',
      'Queues' => 'Colas',
      'Ticket escalation!' => 'Escalado de ticket',

      # Template: AgentTicketQueueTicketView
      'Your own Ticket' => 'Sus tickets',
      'Compose Follow up' => 'Redactar seguimiento',
      'Compose Answer' => 'Responder',
      'Contact customer' => 'Contactar el cliente',
      'Change queue' => 'Cambiar cola',

      # Template: AgentTicketQueueTicketViewLite

      # Template: AgentTicketSearch
      'Ticket Search' => 'Buscar ticket',
      'Profile' => 'Perfil',
      'Search-Template' => 'Buscar-Modelo',
      'Created in Queue' => '',
      'Result Form' => 'Modelo de Resultados',
      'Save Search-Profile as Template?' => 'Guardar perfil de bsqueda como patrn?',
      'Yes, save it with name' => 'Si, guardarlo con nombre',
      'Customer history search' => 'Historia de bsquedas del cliente',
      'Customer history search (e. g. "ID342425").' => 'Historia de bsquedas del cliente (ejemplo: "ID342425"',
      'No * possible!' => 'No * posible!',

      # Template: AgentTicketSearchResult
      'Search Result' => 'Buscar resultados',
      'Change search options' => 'Cambiar opciones de bsqueda',

      # Template: AgentTicketSearchResultPrint
      '"}' => '',

      # Template: AgentTicketSearchResultShort
      'sort upward' => 'ordenar ascendente',
      'U' => 'A',
      'sort downward' => 'ordenar descendente',
      'D' => '',
      'Customer history"}\'; return true;" onmouseout="window.status=\'\';"><div title="">$Quote{"' => '',

      # Template: AgentTicketStatusView
      'Ticket Status View' => '',
      'Open Tickets' => '',

      # Template: AgentTicketZoom
      '"}: \';return true;" onmouseout="window.status=\'\';"><img src="" border="0" alt="$Text{"' => '',
      '"}" title="$Text{"' => '',
      'Split' => 'Dividir',

      # Template: AgentTicketZoomStatus
      'Locked' => 'Bloqueado',

      # Template: AgentWindowTabStart

      # Template: AgentWindowTabStop

      # Template: Copyright

      # Template: css

      # Template: customer-css

      # Template: CustomerAccept

      # Template: CustomerError
      'Traceback' => '',

      # Template: CustomerFAQArticleHistory
      'FAQ History' => 'Historia de FAQ',
      'Print' => 'Imprimir',

      # Template: CustomerFAQArticlePrint
      'Keywords' => 'palabras clave',
      'Last update' => 'Ultima Actualizacin',
      'Symptom' => 'Sintoma',
      'Problem' => 'Problema',
      'Solution' => 'Solucin',

      # Template: CustomerFAQArticleSystemHistory
      'FAQ System History' => 'Sistema de historia de FAQ',

      # Template: CustomerFAQArticleView
      'Modified' => 'Modificado',

      # Template: CustomerFAQOverview
      'FAQ Overview' => 'Resumen de la FAQ',

      # Template: CustomerFAQSearch
      'FAQ Search' => 'Buscar en la FAQ',
      'Fulltext' => 'Texto Completo',
      'Keyword' => 'palabra clave',

      # Template: CustomerFAQSearchResult
      'FAQ Search Result' => 'Resultado de bsqueda en la FAQ',

      # Template: CustomerFooter
      'Powered by' => '',

      # Template: CustomerHeader

      # Template: CustomerLogin
      'Login' => 'Identificador',
      'Lost your password?' => 'Perdi su contrasea',
      'Request new password' => 'Solicitar una nueva contrasea',
      'Create Account' => 'Crear Cuenta',

      # Template: CustomerNavigationBar
      'Welcome %s' => 'Bienvenido %s',

      # Template: CustomerPreferencesForm

      # Template: CustomerStatusView
      'of' => 'de',

      # Template: CustomerTicketMessage

      # Template: CustomerTicketMessageNew

      # Template: CustomerTicketSearch

      # Template: CustomerTicketSearchResultCSV

      # Template: CustomerTicketSearchResultPrint

      # Template: CustomerTicketSearchResultShort

      # Template: CustomerTicketZoom

      # Template: CustomerWarning

      # Template: Error
      'Click here to report a bug!' => 'Haga click aqui para reportar un error!',

      # Template: FAQ
      'Comment (internal)' => 'Comentario (interno)',
      'A article should have a title!' => 'Los articulos deben tener ttulo',
      'New FAQ Article' => '',
      'Do you really want to delete this Object?' => '',
      'System History' => '',

      # Template: FAQCategoryForm
      'Name is required!' => 'Debe especificar nombre!',
      'FAQ Category' => 'Categoria de FAQ',

      # Template: FAQLanguageForm
      'FAQ Language' => 'Idioma de la FAQ',

      # Template: Footer
      'Top of Page' => 'Inicio de pgina',

      # Template: FooterSmall

      # Template: Header
      'Home' => 'Inicio',

      # Template: HeaderSmall

      # Template: InstallerBody
      'Web-Installer' => 'Instalador Web',
      'Create Database' => 'Crear Base de Datos',
      'Drop Database' => 'Eliminar Base de Datos',
      'System Settings' => 'Configuracin del sistema',
      'Finished' => 'Finalizado',

      # Template: InstallerFinish
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Para poder utilizar el OTRS debe escribir la siguiente linea de comandos (Terminal/Shell) como root',
      'Restart your webserver' => 'Reinicie su servidor web',
      'After doing so your OTRS is up and running.' => 'Despus de hacer esto su OTRS estar activo y ejecutandose',
      'Start page' => 'Pgina de inicio',
      'Admin-User' => 'Usuario-Admin',
      'Have a lot of fun!' => 'Disfrutelo!',
      'Your OTRS Team' => 'Su equipo OTRS',

      # Template: InstallerLicense
      'License' => 'Licencia',
      'accept license' => 'aceptar licencia',
      'don\'t accept license' => 'no acepto la licencia',

      # Template: InstallerStart
      'DB Admin User' => 'Usuario Admin de la BD',
      'DB Admin Password' => 'Contrasea del Admin de la BD',
      'your MySQL DB should have a root password! Default is empty!' => 'Su BD MySQL debe tener una contrase&ntiulde; de root! Por defecto es va&itilde;a!',
      'DB Host' => '',
      'DB Type' => 'Tipo de BD',
      'OTRS DB Name' => 'Nombre de la BD OTRS',
      'OTRS DB User' => 'Usuario de BD OTRS',
      'OTRS DB Password' => 'Contrasea para BD del usuario OTRS',
      'default \'hot\'' => 'por defecto \'hot\'',
      'OTRS DB connect host' => '',
      'Create new database' => 'Crear nueva base de datos',
      'Delete old database' => 'Eliminar BD antigua',
      'next step' => 'prximo paso',

      # Template: InstallerSystem
      'SystemID' => 'ID de sistema',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(La identidad del sistema. Cada nmero de ticket y cada id de sesi&oacuten http comienza con este nmero)',
      'System FQDN' => 'FQDN del sistema',
      '(Full qualified domain name of your system)' => '(Nombre completo del dominio de su sistema)',
      'AdminEmail' => 'Correo del administrador.',
      '(Email of the system admin)' => '(email del administrador del sistema)',
      'Organization' => 'Organizacin',
      'LogModule' => 'Modulo de trazas',
      '(Used log backend)' => '(Interface de trazas Utilizada)',
      'Logfile' => 'Archivo de trazas',
      '(Logfile just needed for File-LogModule!)' => '(Archivo de trazas necesario para File-LogModule)',
      'CheckMXRecord' => 'Revisar record MX',
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Chequear record MX de direcciones utilizadas al responder. No usarlo si la PC con el Otrs esta detrs de una linea conmutada $!)',
      'Ticket Hook' => '',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identificador de Ticker. Algunas personas gustan de usar por ejemplo \'Ticket#\', \'Call#\' or \'MyTicket#\')',
      'Ticket Number Generator' => 'Generador de nmeros de Tickets',
      '(Used ticket number format)' => '(Formato de ticket usado)',
      'Webfrontend' => 'Interface Web',
      'Default Charset' => 'Juego de caracteres por defecto',
      'Use utf-8 it your database supports it!' => 'Usar utf-8 si su base de datos lo soporta!',
      'Default Language' => 'Lenguaje por defecto',
      '(Used default language)' => '(Lenguaje por defecto)',

      # Template: Login

      # Template: Motd

      # Template: NoPermission
      'No Permission' => 'No tiene autorizacin',

      # Template: Notify

      # Template: PrintFooter
      'URL' => '',

      # Template: PrintHeader
      'printed by' => 'impreso por',

      # Template: Redirect

      # Template: SystemStats
      'Format' => '',

      # Template: Test
      'OTRS Test Page' => 'Pgina de Prueba de OTRS',
      'Counter' => '',

      # Template: Warning
    };
    # $$STOP$$

    $Self->{Translation} = \%Hash;
}
# --
1;
