# --
# Kernel/Language/cz.pm - provides cz language translation
# Copyright (C) 2003 Lukas Vicanek alias networ <lulka at centrum dot cz>
# Copyright (C) 2004 BENETA.cz, s.r.o. <info at beneta dot cz>
#	Translators: Marta Macalkova
#		     Vadim Buzek 
#		     Petr Ocasek
# --
# $Id: cz.pm,v 1.15 2005/05/01 22:46:13 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::cz;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.15 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;
    my %Hash = ();

    # $$START$$
    # Last translation file sync: Mon May  2 00:38:00 2005

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D/%M/%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %Y %T';
    $Self->{DateInputFormat} = '%D/%M/%Y';
    $Self->{DateInputFormatLong} = '%D/%M/%Y - %T';

    $Self->{Translation} = {
      # Template: AAABase
      'Yes' => 'Ano',
      'No' => 'Ne',
      'yes' => 'ano',
      'no' => 'ne',
      'Off' => 'Vypnuto',
      'off' => 'vypnuto',
      'On' => 'Zapnuto',
      'on' => 'zapnuto',
      'top' => 'nahoru',
      'end' => 'konec',
      'Done' => 'Hotovo',
      'Cancel' => 'Stornovat',
      'Reset' => '',
      'day' => 'den',
      'days' => 'dn(dny)',
      'hour' => 'hodina',
      'hours' => 'hodin',
      'minute' => 'minuta',
      'minutes' => 'minut',
      'wrote' => 'napsal',
      'Message' => 'Zprva',
      'Error' => 'Chyba',
      'Bug Report' => 'Upozornn na chybu',
      'Attention' => 'Upozornn',
      'Warning' => 'Varovn',
      'Module' => 'Modul',
      'Modulefile' => 'Modulov soubor',
      'Subfunction' => 'Podfunkce',
      'Line' => 'Linka',
      'Example' => 'Pklad',
      'Examples' => 'Pklady',
      'invalid' => 'neplatn',
      ' 2 minutes' => ' 2 minuty',
      ' 5 minutes' => ' 5 minut',
      ' 7 minutes' => ' 7 minut',
      '10 minutes' => '10 minut',
      '15 minutes' => '15 minut',
      'Mr.' => '',
      'Mrs.' => '',
      'Next' => '',
      'Back' => 'Zpt',
      'Next...' => '',
      '...Back' => '',
      '-none-' => '',
      'none' => 'dn',
      'none!' => 'dn!',
      'none - answered' => 'dn - odpovzeno',
      'please do not edit!' => 'prosme neupravujte!',
      'AddLink' => 'Pidat Odkaz',
      'Link' => 'Odkaz',
      'Linked' => '',
      'Link (Normal)' => '',
      'Link (Parent)' => '',
      'Link (Child)' => '',
      'Normal' => 'Normln',
      'Parent' => '',
      'Child' => '',
      'Hit' => 'Pstup',
      'Hits' => 'Prstup',
      'Text' => '',
      'Lite' => 'Omezen',
      'User' => 'Uivatel',
      'Username' => 'Jmno uivatele',
      'Language' => 'Jazyk',
      'Languages' => 'Jazyky',
      'Password' => 'Heslo',
      'Salutation' => 'Osloven',
      'Signature' => 'Podpis',
      'Customer' => 'Klient',
      'CustomerID' => 'ID klienta',
      'CustomerIDs' => '',
      'customer' => 'klient',
      'agent' => '',
      'system' => 'systm',
      'Customer Info' => 'Informace o klientovi',
      'go!' => 'jdi!',
      'go' => 'jdi',
      'All' => 'Ve',
      'all' => 've',
      'Sorry' => 'Omluva',
      'update!' => 'aktualizovat!',
      'update' => 'aktualizovat',
      'Update' => 'Aktualizovat',
      'submit!' => 'Odeslat!',
      'submit' => 'odeslat',
      'Submit' => '',
      'change!' => 'zmnit!',
      'Change' => 'Zmnit',
      'change' => 'zmnit',
      'click here' => 'kliknte zde',
      'Comment' => 'Koment',
      'Valid' => 'Platnost',
      'Name' => 'Jmno',
      'Group' => 'Skupina',
      'Description' => 'Popis',
      'description' => 'popis',
      'Theme' => 'Design',
      'Created' => 'Vytvoeno',
      'Created by' => '',
      'Changed' => '',
      'Changed by' => '',
      'Search' => 'Vyhledat',
      'and' => 'a',
      'between' => '',
      'Fulltext Search' => '',
      'Data' => '',
      'Options' => 'Monosti',
      'Title' => '',
      'Item' => '',
      'Delete' => 'Smazat',
      'Edit' => 'Editovat',
      'View' => 'Nhled',
      'Number' => '',
      'System' => 'Systm',
      'Contact' => 'Konktakt',
      'Contacts' => '',
      'Export' => '',
      'Up' => '',
      'Down' => '',
      'Add' => 'Pidat',
      'Category' => 'Kategorie',
      'New message' => 'Nov zprva',
      'New message!' => 'Nov zprva!',
      'Admin-Area' => 'Administran zna',
      'Agent-Area' => 'Zna agent',
      'FAQ-Area' => 'FAQ zna',
      'QueueView' => 'Nhled fronty',
      'Stats' => 'Statistiky',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Prosm, odpovzte na tento (tyto) tiket(y) pro nvrat do normlnho nhledu fronty!',
      'You got new message!' => 'Mte novou zprvu!',
      'You have %s new message(s)!' => 'Mte %s novou zprvu (novch zprv)!',
      'You have %s reminder ticket(s)!' => 'Mte %s upomnkov(ch) ticket()',
      'The recommended charset for your language is %s!' => 'Doporuen znakov sada pro V jazyk je %s!',
      'Passwords dosn\'t match! Please try it again!' => '',
      'Password is already in use! Please use an other password!' => '',
      'Password is already used! Please use an other password!' => '',
      'No suggestions' => 'dn nvrhy',
      'Word' => 'Slovo',
      'Ignore' => 'Ignorovat',
      'replace with' => 'nahradit',
      'Welcome to OTRS' => 'Vtejte v OTRS',
      'There is no account with that login name.' => 'dn et s tmto pihlaovacm jmnem neexistuje.',
      'Login failed! Your username or password was entered incorrectly.' => 'Pihlen nespn! Vae uivatelsk jmno i heslo bylo zadno nesprvn.',
      'Please contact your admin' => 'Kontaktujte, prosm, Vaeho administrtora',
      'Logout successful. Thank you for using OTRS!' => 'Odhlen bylo spsn. Dkujeme Vm za pouvn OTRS!',
      'Invalid SessionID!' => 'Neplatn ID relace!',
      'Feature not active!' => 'Funkce je neaktivn!',
      'Ticket Number' => '',
      'Ticket Object' => '',
      'No such Ticket Number "%s"! Can\'t link it!' => '',
      'Take this Customer' => '',
      'Take this User' => 'Pouj tohoto uivatele',
      'possible' => 'mon',
      'reject' => 'zamtnout',
      'Facility' => 'Funkce',
      'Timeover' => 'as vyprel',
      'Pending till' => 'ekn na vyzen do',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Z bezpenostnch dvod nepracujte se superuivatelskm tem - vytvote si novho uivatele!',
      'Dispatching by email To: field.' => 'Piadit podle e-mailu - pole KOMU:.',
      'Dispatching by selected Queue.' => 'Piadit do vybran fronty.',
      'No entry found!' => 'Nebyl nalezen dn zznam!',
      'Session has timed out. Please log in again.' => 'Relace vyprela. Prosm, pihlate se znovu.',
      'No Permission!' => '',
      'To: (%s) replaced with database email!' => 'To: (%s) nahrazeno emailem z databze!',
      'Cc: (%s) added database email!' => '',
      'Don\'t show closed Tickets' => 'Nezobrazovat uzaven tikety',
      'Show closed Tickets' => 'Zobrazit zaven tikety',
      'New Article' => 'Nov poloka',
      '(Click here to add)' => '(Pro pidn kliknte zde)',
      'last' => 'posledn',
      'before' => 'ped',
      'day(s)' => 'den(dn)',
      'month(s)' => 'msc(e)',
      'week(s)' => 'tden(tdny)',
      'year(s)' => 'rok(y)',
      'Preview' => 'Zobrazit',
      'Added User "%s"' => '',
      'Contract' => '',
      'Online Customer: %s' => '',
      'Online Agent: %s' => '',
      'Calendar' => '',
      'File' => '',
      'Filename' => 'Nzev souboru',
      'Type' => 'Typ',
      'Size' => '',
      'Upload' => '',
      'Directory' => '',
      'Signed' => '',
      'Sign' => '',
      'Crypted' => '',
      'Crypt' => '',
      'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
      'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
      'History::FollowUp' => 'FollowUp for [%s]. %s',
      'History::SendAutoReject' => 'AutoReject sent to "%s".',
      'History::SendAutoReply' => 'AutoReply sent to "%s".',
      'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
      'History::Forward' => 'Forwarded to "%s".',
      'History::Bounce' => 'Bounced to "%s".',
      'History::SendAnswer' => 'Email sent to "%s".',
      'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
      'History::SendCustomerNotification' => 'Notification sent to "%s".',
      'History::EmailAgent' => 'Email sent to customer.',
      'History::EmailCustomer' => 'Added email. %s',
      'History::PhoneCallAgent' => 'Agent called customer.',
      'History::PhoneCallCustomer' => 'Customer called us.',
      'History::AddNote' => 'Added note (%s)',
      'History::Lock' => 'Locked ticket.',
      'History::Unlock' => 'Unlocked ticket.',
      'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
      'History::Remove' => '%s',
      'History::CustomerUpdate' => 'Updated: %s',
      'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
      'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
      'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
      'History::Misc' => '%s',
      'History::SetPendingTime' => 'Updated: %s',
      'History::StateUpdate' => 'Old: "%s" New: "%s"',
      'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
      'History::WebRequestCustomer' => 'Customer request via web.',
      'History::TicketLinkAdd' => 'Added link to ticket "%s".',
      'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',

      # Template: AAAMonth
      'Jan' => 'Led',
      'Feb' => 'no',
      'Mar' => 'Be',
      'Apr' => 'Dub',
      'May' => 'Kv',
      'Jun' => 'vc',
      'Jul' => 'er',
      'Aug' => 'Srp',
      'Sep' => 'Z',
      'Oct' => 'j',
      'Nov' => 'Lis',
      'Dec' => 'Pro',

      # Template: AAANavBar
      'Send Email and create a new Ticket' => '',
      'Create new Phone Ticket' => '',
      'Ticket-Area' => '',
      'Overview of all open Tickets' => '',
      'Logout' => 'Odhlsit',
      'Agent Preferences' => '',
      'Preferences' => 'Nastaven',
      'Agent Mailbox' => '',
      'Stats-Area' => '',
      'FAQ' => '',
      'FAQ-Search' => '',
      'FAQ-Article' => '',
      'FAQ-State' => '',
      'Admin' => '',
      'Create new Ticket' => 'Vytvoit nov tiket',
      'New Ticket' => 'Nov tiket',

      # Template: AAAPreferences
      'Preferences updated successfully!' => 'Nastaven spn aktualizovno!',
      'Mail Management' => 'Sprva e-mail',
      'Frontend' => 'Rozhran',
      'Other Options' => 'Jin monosti',
      'New ticket notification' => 'Nov oznmen tiketu',
      'Send me a notification if there is a new ticket in "My Queues".' => '',
      'Follow up notification' => 'Nsledujc oznmen',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Poli mi oznmen, pokud klient pole nsledujc a jsem vlastnk tohoto tiketu.',
      'Ticket lock timeout notification' => 'Oznmen o vypren asu uzamen tiketu',
      'Send me a notification if a ticket is unlocked by the system.' => 'Poli mi oznmen, pokud je tiket odemknut systmem.',
      'Move notification' => 'Pesunout oznmen',
      'Send me a notification if a ticket is moved into one of "My Queues".' => '',
      'Custom Queue' => 'Vlastn fronta',
      'QueueView refresh time' => 'Doba obnoven nhledu fronty',
      'Select your QueueView refresh time.' => 'Vyberte si dobu obnoven nhledu fronty.',
      'Select your frontend language.' => 'Vyberte si jazyk Vaeho rozhran.',
      'Select your frontend Charset.' => 'Vyberte si znakovou sadu Vaeho rozhran.',
      'Select your frontend Theme.' => 'Vyberte si design Vaeho rozhran.',
      'Select your frontend QueueView.' => 'Vyberte si nhled fronty Vaeho rozhran.',
      'Spelling Dictionary' => 'Slovnk kontroly pravopisu',
      'Select your default spelling dictionary.' => 'Vyberte si V vchoz pravopisn slovnk',
      'PhoneView' => 'Nov tiket / hovor',
      'TicketZoom' => 'Zobrazen tiketu',
      'CreateTicket' => 'Vytvoeno Tiketu',
      'Screen after new ticket' => '',
      'Select your screen after creating a new ticket.' => '',
      'Closed Tickets' => 'Uzaven Tikety',
      'Show closed tickets.' => 'Ukzat uzaven tikety.',
      'Max. shown Tickets a page in QueueView.' => 'Max. zobrazench tiket v nhledu fronty na strnku',
      'Max. shown Tickets a page in Overview.' => 'Max. zobrazench tiket v pehledu na strnku',
      'Can\'t update password, passwords dosn\'t match! Please try it again!' => '',
      'Can\'t update password, invalid characters!' => '',
      'Can\'t update password, need min. 8 characters!' => '',
      'Can\'t update password, need 2 lower and 2 upper characters!' => '',
      'Can\'t update password, need min. 1 digit!' => '',
      'Can\'t update password, need min. 2 characters!' => '',

      # Template: AAATicket
      'Lock' => 'Zmek',
      'Unlock' => 'Zmek',
      'History' => 'Historie',
      'Zoom' => 'Zobrazit',
      'Age' => 'St',
      'Bounce' => 'Odeslat zpt',
      'Forward' => 'Pedat',
      'From' => 'Od',
      'To' => 'Komu',
      'Cc' => 'Kopie',
      'Bcc' => 'Slep kopie',
      'Subject' => 'Pedmt',
      'Move' => 'Pesunout',
      'Queue' => 'Fronta',
      'Priority' => 'Priorita',
      'State' => 'Stav',
      'Compose' => 'Sestavit',
      'Pending' => 'ek na vyzen',
      'Owner' => 'Vlastnk',
      'Sender' => 'Odeslatel',
      'Article' => 'Poloka',
      'Ticket' => 'Tiket',
      'Createtime' => 'Doba vytvoen',
      'plain' => 'jednoduch',
      'eMail' => '',
      'email' => '',
      'Close' => 'Zavt',
      'Action' => 'Akce',
      'Attachment' => 'Ploha',
      'Attachments' => 'Plohy',
      'This message was written in a character set other than your own.' => 'Tato zprva byla napsna v jin znakov sad ne Vae.',
      'If it is not displayed correctly,' => 'Pokud nen zobrazeno sprvn,',
      'This is a' => 'Toto je',
      'to open it in a new window.' => 'pro oteven v novm okn.',
      'This is a HTML email. Click here to show it.' => 'Toto je HTML email. Pro zobrazen kliknte zde.',
      'closed successful' => 'uzaveno - vyeeno',
      'closed unsuccessful' => 'uzaveno - nevyeeno',
      'new' => 'nov',
      'open' => 'otevt',
      'closed' => 'uzaveno',
      'removed' => 'odstrann',
      'pending reminder' => 'upomnka pi ekn na vyzen',
      'pending auto close+' => 'ek na vyzen - automaticky zavt+',
      'pending auto close-' => 'ek na vyzen - automaticky zavt-',
      'email-external' => 'extern email',
      'email-internal' => 'intern email',
      'note-external' => 'poznmka-extern',
      'note-internal' => 'poznmka-intern',
      'note-report' => 'poznmka-report',
      'phone' => 'telefon',
      'sms' => '',
      'webrequest' => 'poadavek pes web',
      'lock' => 'zameno',
      'unlock' => 'nezamen',
      'very low' => 'velmi nzk',
      'low' => 'nzk',
      'normal' => 'normaln',
      'high' => 'vysok',
      'very high' => 'velmi vysok',
      '1 very low' => '1 velmi nzk',
      '2 low' => '2 nzk',
      '3 normal' => '3 normln',
      '4 high' => '4 vysok',
      '5 very high' => '5 velmi vysok',
      'Ticket "%s" created!' => 'Tiket "%s" vytvoen!',

      # Template: AAAWeekDay
      'Sun' => 'Ne',
      'Mon' => 'Po',
      'Tue' => 't',
      'Wed' => 'St',
      'Thu' => 't',
      'Fri' => 'P',
      'Sat' => 'So',

      # Template: AdminAttachmentForm
      'Attachment Management' => 'Sprva ploh',

      # Template: AdminAutoResponseForm
      'Auto Response Management' => 'Sprva automatickch odpovd',
      'Response' => 'Odpov',
      'Auto Response From' => 'Automatick odpov Od',
      'Note' => 'Poznmka',
      'Useable options' => 'Dostupn monosti',
      'to get the first 20 character of the subject' => 'pro zskni prvnch 20 znak z pedmtu',
      'to get the first 5 lines of the email' => 'pro zskn prvnch 5 dk z emailu',
      'to get the from line of the email' => 'pro zskan dku Od z emailu',
      'to get the realname of the sender (if given)' => 'pro zskan skutenho jmna odeslatele (pokud je zadno)',
      'Options of the ticket data (e. g. &lt;OTRS_TICKET_TicketNumber&gt;, &lt;OTRS_TICKET_TicketID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',

      # Template: AdminCustomerUserForm
      'The message being composed has been closed.  Exiting.' => 'Vytven zprva byla uzavena. Opoutm.',
      'This window must be called from compose window' => 'Toto okno mus bt vyvolno z okna vytven',
      'Customer User Management' => 'Sprva Klient',
      'Search for' => '',
      'Result' => '',
      'Select Source (for add)' => '',
      'Source' => '',
      'This values are read only.' => '',
      'This values are required.' => '',
      'Customer user will be needed to have an customer histor and to to login via customer panels.' => '',

      # Template: AdminCustomerUserGroupChangeForm
      'Customer Users <-> Groups Management' => '',
      'Change %s settings' => 'Zmnit nastaven %s',
      'Select the user:group permissions.' => 'Vybrat uivatele:prva skupiny',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Pokud nebylo nic vybrno, nejsou v tto skupin dn prva (tikety nebudou pro uivatele dostupn).',
      'Permission' => 'Prva',
      'ro' => 'jen ten',
      'Read only access to the ticket in this group/queue.' => 'Pstup pouze pro ten tiketu v tto skupin/ad.',
      'rw' => 'ten/psan',
      'Full read and write access to the tickets in this group/queue.' => 'Pln pstup pro ten a psan do tiket v tto skupin/front.',

      # Template: AdminCustomerUserGroupForm
      'Change user <-> group settings' => 'Zmnit uivatele <-> nastaven skupiny',

      # Template: AdminEmail
      'Admin-Email' => 'Email administrtora',
      'Message sent to' => 'Zprva odeslna',
      'Recipents' => 'Adresti',
      'Body' => 'Tlo',
      'send' => 'poslat',

      # Template: AdminGenericAgent
      'GenericAgent' => '',
      'Job-List' => '',
      'Last run' => '',
      'valid' => 'platn',
      'Run Now!' => '',
      'x' => '',
      'Save Job as?' => '',
      'Is Job Valid?' => '',
      'Is Job Valid' => '',
      'Schedule' => '',
      'Minutes' => '',
      'Hours' => '',
      'Days' => '',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Fulltextov vyhledvn v poloce (nap. "Mar*in" or "Baue*")',
      '(e. g. 10*5155 or 105658*)' => '(nap. 10*5155 or 105658*)',
      '(e. g. 234321)' => '(nap. 234321)',
      'Customer User Login' => 'Pihlen klienta',
      '(e. g. U5150)' => '(nap. U5150)',
      'Agent' => '',
      'TicketFreeText' => 'Voln text tiketu',
      'Ticket Lock' => '',
      'Times' => 'Doba',
      'No time settings.' => 'dn nastaven doby',
      'Ticket created' => 'Tiket vytvoen',
      'Ticket created between' => 'Tiket vytvoen mezi',
      'New Priority' => '',
      'New Queue' => 'Nov fronta',
      'New State' => '',
      'New Agent' => '',
      'New Owner' => 'Nov vlastnk',
      'New Customer' => '',
      'New Ticket Lock' => '',
      'CustomerUser' => 'Klient',
      'Add Note' => 'Pidat poznmku',
      'CMD' => '',
      'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => '',
      'Delete tickets' => '',
      'Warning! This tickets will be removed from the database! This tickets are lost!' => '',
      'Modules' => '',
      'Param 1' => '',
      'Param 2' => '',
      'Param 3' => '',
      'Param 4' => '',
      'Param 5' => '',
      'Param 6' => '',
      'Save' => '',

      # Template: AdminGroupForm
      'Group Management' => 'Sprva skupiny',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'Skupina administrtora m pstup do administran a statistick zny.',
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Vytvoit nov skupiny pro piazen prv pstup ruznm skupinm agent (nap. oddlen nkupu, oddlen podpory, oddlen prodeje...).',
      'It\'s useful for ASP solutions.' => 'To je vhodn pro een ASP',

      # Template: AdminLog
      'System Log' => 'Log systmu',
      'Time' => '',

      # Template: AdminNavigationBar
      'Users' => '',
      'Groups' => 'Skupiny',
      'Roles' => '',
      'Responses' => 'Odpovdi',
      'Misc' => 'Rzn',

      # Template: AdminNotificationForm
      'Notification Management' => 'Sprva oznmen',
      'Notification' => '',
      'Notifications are sent to an agent or a customer.' => 'Oznmen jsou odeslna agentovi i klientovi',
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => '',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => '',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',

      # Template: AdminPackageManager
      'Package Manager' => '',
      'Uninstall' => '',
      'Verion' => '',
      'Do you really want to uninstall this package?' => '',
      'Install' => '',
      'Package' => '',
      'Online Repository' => '',
      'Version' => '',
      'Vendor' => '',
      'Upgrade' => '',
      'Local Repository' => '',
      'Status' => 'Stav',
      'Overview' => 'Pehled',
      'Download' => '',
      'Rebuild' => '',
      'Reinstall' => '',

      # Template: AdminPGPForm
      'PGP Management' => '',
      'Identifier' => '',
      'Bit' => '',
      'Key' => 'Kl',
      'Fingerprint' => '',
      'Expires' => '',
      'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => '',
      'FIXME: WHAT IS PGP?' => '',

      # Template: AdminPOP3Form
      'POP3 Account Management' => 'Sprva POP3 t',
      'Host' => 'Hostitel',
      'Trusted' => 'Oveno',
      'Dispatching' => 'Zaazen',
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Vechny pchoz emaily z danho tu budou zaazeny do vybran fronty!',
      'If your account is trusted, the already existing x-otrs header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',

      # Template: AdminPostMasterFilter
      'PostMaster Filter Management' => '',
      'Filtername' => '',
      'Match' => 'Obsahuje',
      'Header' => '',
      'Value' => 'Hodnota',
      'Set' => 'Nastavit',
      'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => '',
      'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '',

      # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Responses Management' => '',

      # Template: AdminQueueAutoResponseTable

      # Template: AdminQueueForm
      'Queue Management' => 'Sprva front',
      'Sub-Queue of' => 'Podfronta ',
      'Unlock timeout' => 'as do odemknut',
      '0 = no unlock' => '0 = dn odemknut',
      'Escalation time' => 'Doba stupovn',
      '0 = no escalation' => '0 = dn stupovn',
      'Follow up Option' => 'Nsledujc volba',
      'Ticket lock after a follow up' => 'Zamknout tiket po nsledujcm',
      'Systemaddress' => 'Systmov adresa',
      'Customer Move Notify' => 'Oznmen Klientovi o zmn fronty',
      'Customer State Notify' => 'Oznmen Klientovi o zmn stavu',
      'Customer Owner Notify' => 'Oznmen Klientovi o zmn vlastnka',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Pokud agent uzamkne tiket a neodele v tto dob odpov, tiket bude automaticky odemknut. Tak se stane tiket viditeln pro vechny ostatn agenty.',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Nebude-li tiket odpovzen v danm ase, bude zobrazen pouze tento Tiket.',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Pokud je tiket uzaven a klient odele nsledujc, tiket bude pro starho vlastnka uzamknut.',
      'Will be the sender address of this queue for email answers.' => 'Bude adresou odeslatele z tto fronty pro emailov odpovdi.',
      'The salutation for email answers.' => 'Osloven pro emailov odpovdi.',
      'The signature for email answers.' => 'Podpis pro emailov odpovdi.',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS pole klientovi emailem oznmen, pokud bude tiket pesunut.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS pole klientovi emailem oznmen, pokud se zmn stav tiketu.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS pole klientovi emailem oznmen, pokud se zmn vlastnk tiketu.',

      # Template: AdminQueueResponsesChangeForm
      'Responses <-> Queue Management' => '',

      # Template: AdminQueueResponsesForm
      'Answer' => 'Odpov',

      # Template: AdminResponseAttachmentChangeForm
      'Responses <-> Attachments Management' => '',

      # Template: AdminResponseAttachmentForm

      # Template: AdminResponseForm
      'Response Management' => 'Sprva odpovd',
      'A response is default text to write faster answer (with default text) to customers.' => 'Odpov je obsahuje vchoz text slouc k rychlej reakci (spolu s vchozm textem) klientm.',
      'Don\'t forget to add a new response a queue!' => 'Nezapomete pidat novou reakci odpove do fronty!',
      'Next state' => 'Nasledujc stav',
      'All Customer variables like defined in config option CustomerUser.' => '',
      'The current ticket state is' => 'Aktuln stav tiketu je',
      'Your email address is new' => '',

      # Template: AdminRoleForm
      'Role Management' => '',
      'Create a role and put groups in it. Then add the role to the users.' => '',
      'It\'s useful for a lot of users and groups.' => '',

      # Template: AdminRoleGroupChangeForm
      'Roles <-> Groups Management' => '',
      'move_into' => 'pesunout do',
      'Permissions to move tickets into this group/queue.' => 'Prva pesunout tikety do tto skupiny/fronty',
      'create' => 'vytvoit',
      'Permissions to create tickets in this group/queue.' => 'Prva vytvoit tikety v tto skupin/front',
      'owner' => 'vlastnk',
      'Permissions to change the ticket owner in this group/queue.' => 'Prva zmnit vlastnk tiketu v tto skupin/front',
      'priority' => 'priorita',
      'Permissions to change the ticket priority in this group/queue.' => 'Prva zmnit prioritu tiketu v tto skupin/front',

      # Template: AdminRoleGroupForm
      'Change roles <-> groups settings' => '',
      'Role' => '',

      # Template: AdminRoleUserChangeForm
      'Roles <-> Users Management' => '',
      'Active' => '',
      'Select the role:user relations.' => '',

      # Template: AdminRoleUserForm
      'Change users <-> roles settings' => '',

      # Template: AdminSalutationForm
      'Salutation Management' => 'Sprva osloven',
      'customer realname' => 'skuten jmno klienta',
      'for agent firstname' => 'pro kestn jmno agenta',
      'for agent lastname' => 'pro pjmen agenta',
      'for agent user id' => 'pro uivatelsk ID agenta',
      'for agent login' => 'pro pihlen agenta',

      # Template: AdminSelectBoxForm
      'Select Box' => 'Poadavek na SQL databzi',
      'SQL' => '',
      'Limit' => '',
      'Select Box Result' => 'Vsledek SQL dotazu',

      # Template: AdminSession
      'Session Management' => 'Sprva relace',
      'Sessions' => 'Relace',
      'Uniq' => 'Poet',
      'kill all sessions' => 'Zruit vechny relace',
      'Session' => '',
      'kill session' => 'zruit relaci',

      # Template: AdminSignatureForm
      'Signature Management' => 'Sprva podpis',

      # Template: AdminSMIMEForm
      'SMIME Management' => '',
      'Add Certificate' => '',
      'Add Private Key' => '',
      'Secret' => '',
      'Hash' => '',
      'In this way you can directly edit the certification and private keys in file system.' => '',
      'FIXME: WHAT IS SMIME?' => '',

      # Template: AdminStateForm
      'System State Management' => 'Sprva stavu systmu',
      'State Type' => 'Typ stavu',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Ujistte se, e jste aktualizovali tak vchoz hodnoty ve Vaem Kernel/Config.pm!',
      'See also' => 'Viz. tak',

      # Template: AdminSysConfig
      'SysConfig' => '',
      'Group selection' => '',
      'Show' => '',
      'Subgroup' => '',

      # Template: AdminSysConfigEdit
      'Options ' => '',
      'for ' => '',
      'Subgroup \'' => '',
      '\' ' => '',
      'Content' => '',
      'New' => 'Nov',
      'Group Ro' => '',
      'NavBarName' => '',
      'Image' => '',
      'Typ' => '',
      'Prio' => '',
      'Block' => '',
      'NavBar' => '',

      # Template: AdminSystemAddressForm
      'System Email Addresses Management' => 'Sprva emailovch adres systmu',
      'Email' => '',
      'Realname' => 'Skuten jmno',
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Vechny pchoz emaily obsahujc tohoto adresta (v poli KOMU) budou zaazeny to vybran fronty!',

      # Template: AdminUserForm
      'User Management' => 'Sprva uivatel',
      'Firstname' => 'Kestn jmno',
      'Lastname' => 'Pjmen',
      'User will be needed to handle tickets.' => 'Uivatel bude potebovat prva pro ovldn tiket.',
      'Don\'t forget to add a new user to groups!' => 'Nezapomete pidat novho uivatele do skupin!',

      # Template: AdminUserGroupChangeForm
      'Users <-> Groups Management' => '',

      # Template: AdminUserGroupForm

      # Template: AgentBook
      'Address Book' => 'Adres',
      'Return to the compose screen' => 'Vrtit se zpt do okna vytven',
      'Discard all changes and return to the compose screen' => 'Zruit vechny zmny a vrtit se zpt do okna vytven',

      # Template: AgentCustomerTableView

      # Template: AgentInfo
      'Info' => '',

      # Template: AgentLinkObject
      'Link Object' => '',
      '"}" $Text{"with' => '',
      'Select' => 'Vybrat',
      'Results' => 'Vsledky',
      'Total hits' => 'Celkov poet zznam',
      'Site' => 'Umstn',
      'Detail' => '',

      # Template: AgentLookup
      'Lookup' => '',

      # Template: AgentNavigationBar
      'Ticket selected for bulk action!' => '',
      'You need min. one selected Ticket!' => '',

      # Template: AgentPreferencesForm

      # Template: AgentSpelling
      'Spell Checker' => 'Funkce na kontrolu pravopisu',
      'spelling error(s)' => 'chyba(y) v pravopisu',
      'or' => 'nebo',
      'Apply these changes' => 'Aplikovat tyto zmny',

      # Template: AgentTicketBounce
      'A message should have a To: recipient!' => 'Zprva by mla obsahovat Komu: pjemce!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Muste mt  uvedenu emailovou adresu (nap. klient@priklad.cz) v poli Komu:!',
      'Bounce ticket' => 'Odeslat tiket zpt',
      'Bounce to' => 'Odeslat zpt',
      'Next ticket state' => 'Nsledujc stav tiketu',
      'Inform sender' => 'Informovat odeslatele',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'V email s slem ticketu "<OTRS_TICKET>" je odesln zpt na "<OTRS_BOUNCE_TO>". Kontaktujte tuto adresu pro dal infromace.',
      'Send mail!' => 'Poslat mail!',

      # Template: AgentTicketBulk
      'A message should have a subject!' => 'Zprva by mla mt pedmt!',
      'Ticket Bulk Action' => '',
      '$Text{"Note!' => '',
      'Spell Check' => 'Kontrola pravopisu',
      'Note type' => 'Typ poznmky',
      'Unlock Tickets' => '',

      # Template: AgentTicketClose
      'A message should have a body!' => 'Zprva by mla mt tlo!',
      'You need to account time!' => 'Potebujete tovat dobu!',
      'Close ticket' => 'Zavt tiket',
      'Close!' => 'Zavt!',
      'Note Text' => 'Text poznmky',
      'Close type' => 'Zavt typ',
      'Time units' => 'Jednotky asu',
      ' (work units)' => '(jednotky prce)',

      # Template: AgentTicketCompose
      'A message must be spell checked!' => 'Zprva mus bt pravopisn zkontrolovan!',
      'Compose answer for ticket' => 'Sestavit odpov pro tiket',
      'Attach' => 'Pipojit',
      'Pending Date' => 'Doba ekn na vyzen',
      'for pending* states' => 'pro stavy ekn na vyzen*',

      # Template: AgentTicketCustomer
      'Change customer of ticket' => 'Zmnit klienta tiketu',
      'Set customer user and customer id of a ticket' => 'Nastavit klienta a nastavit ID klienta tiketu',
      'Customer User' => 'Klient - Uivatel',
      'Search Customer' => 'Vyhledat klienta',
      'Customer Data' => 'Data klienta',
      'Customer history' => 'Historie klienta',
      'All customer tickets.' => 'Vechny tikety klienta',

      # Template: AgentTicketCustomerMessage
      'Follow up' => 'Nsledujc',

      # Template: AgentTicketEmail
      'Compose Email' => '',
      'new ticket' => 'nov tiket',
      'Clear To' => '',
      'All Agents' => 'Vichni agenti',

      # Template: AgentTicketForward
      'Article type' => 'Typ poloky',

      # Template: AgentTicketFreeText
      'Change free text of ticket' => 'Zmnit pln text tiketu',

      # Template: AgentTicketHistory
      'History of' => 'Historie',

      # Template: AgentTicketLocked
      'Ticket locked!' => 'Tiket zamknut!',
      'Ticket unlock!' => 'Tiket odemknut!',

      # Template: AgentTicketMailbox
      'Mailbox' => 'Potovn schrnka',
      'Tickets' => 'Tikety',
      'All messages' => 'Vechny zprvy',
      'New messages' => 'Nov zprvy',
      'Pending messages' => 'Zprvy ekajc na vyzen',
      'Reminder messages' => 'Upomnkov zprvy',
      'Reminder' => 'Upomnka',
      'Sort by' => 'Setdit dle',
      'Order' => 'Seadit',
      'up' => 'nahoru',
      'down' => 'dol',
      '"}\'; return true;" onmouseout="window.status=\'\';" class="menuitem" title="$Text{"' => '',
      '"}"}">$Quote{"$Text{""}' => '',

      # Template: AgentTicketMerge
      'You need to use a ticket number!' => '',
      'Ticket Merge' => '',
      'Merge to' => '',
      'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => '',

      # Template: AgentTicketMove
      'Queue ID' => 'ID fronty',
      'Move Ticket' => 'Pesunout tiket',
      'Previous Owner' => 'Pedchoz vlastnk',

      # Template: AgentTicketNote
      'Add note to ticket' => 'Pidat poznmku k tiketu',
      'Inform Agent' => '',
      'Optional' => '',
      'Inform involved Agents' => '',

      # Template: AgentTicketOwner
      'Change owner of ticket' => 'Zmnit vlastnka tiketu',
      'Message for new Owner' => 'Zprva pro novho vlastnka',

      # Template: AgentTicketPending
      'Set Pending' => 'Nastavit - ek na vyzen',
      'Pending type' => 'Typ ekn na vyzen',
      'Pending date' => 'Datum ekn na vyzen',

      # Template: AgentTicketPhone
      'Phone call' => 'Telefon hovor',

      # Template: AgentTicketPhoneNew
      'Clear From' => 'Vymazat pole Od',

      # Template: AgentTicketPlain
      'Plain' => 'Jednoduch',
      'TicketID' => 'ID tiketu',
      'ArticleID' => 'ID poloky',

      # Template: AgentTicketPrint
      'Ticket-Info' => '',
      'Accounted time' => 'tovan doba',
      'Escalation in' => 'Stupovn v',
      'Linked-Object' => '',
      'Parent-Object' => '',
      'Child-Object' => '',
      'by' => 'pes',

      # Template: AgentTicketPriority
      'Change priority of ticket' => 'Zmnit dleitost tiketu',

      # Template: AgentTicketQueue
      'Tickets shown' => 'Zobrazen tikety',
      'Page' => 'Strana',
      'Tickets available' => 'Tiket k dispozici',
      'All tickets' => 'Vechny tikety',
      'Queues' => 'ady',
      'Ticket escalation!' => 'Eskalace tiket',

      # Template: AgentTicketQueueTicketView
      'Your own Ticket' => 'V vlastn tiket',
      'Compose Follow up' => 'Sestavit nsledujc',
      'Compose Answer' => 'Odpovdt',
      'Contact customer' => 'Kontaktovat klienta',
      'Change queue' => 'Zmnit frontu',

      # Template: AgentTicketQueueTicketViewLite

      # Template: AgentTicketSearch
      'Ticket Search' => 'Hledn tiketu',
      'Profile' => 'Profil',
      'Search-Template' => 'Forma vyhledvn',
      'Created in Queue' => '',
      'Result Form' => 'Forma vsledku',
      'Save Search-Profile as Template?' => 'Uloit profil vyhledvn jako ablonu?',
      'Yes, save it with name' => 'Ano, uloit pod nzvem',
      'Customer history search' => 'Vyhledvn historie klienta',
      'Customer history search (e. g. "ID342425").' => 'Vyhledvn historie klienta (nap. "ID342425")',
      'No * possible!' => 'dn * mon!',

      # Template: AgentTicketSearchResult
      'Search Result' => 'Vsledky vyhledvn',
      'Change search options' => 'Zmnit monosti vyhledvn',

      # Template: AgentTicketSearchResultPrint
      '"}' => '',

      # Template: AgentTicketSearchResultShort
      'sort upward' => 'setdit nahoru',
      'U' => 'Z-A',
      'sort downward' => 'setdit dol',
      'D' => 'A-Z',

      # Template: AgentTicketStatusView
      'Ticket Status View' => '',
      'Open Tickets' => '',

      # Template: AgentTicketZoom
      'Split' => 'Rozdlit',

      # Template: AgentTicketZoomStatus
      'Locked' => '',

      # Template: AgentWindowTabStart

      # Template: AgentWindowTabStop

      # Template: Copyright

      # Template: css

      # Template: customer-css

      # Template: CustomerAccept

      # Template: CustomerError
      'Traceback' => 'Jt zpt',

      # Template: CustomerFAQArticleHistory
      'FAQ History' => 'Historie FAQ',
      'Print' => 'Tisknout',

      # Template: CustomerFAQArticlePrint
      'Keywords' => 'Klov slova',
      'Last update' => 'Posledn aktualizace',
      'Symptom' => 'Pznak',
      'Problem' => 'Problm',
      'Solution' => 'een',

      # Template: CustomerFAQArticleSystemHistory
      'FAQ System History' => 'Historie FAQ systmu',

      # Template: CustomerFAQArticleView
      'Modified' => 'Zmnno',

      # Template: CustomerFAQOverview
      'FAQ Overview' => 'Pehled FAQ',

      # Template: CustomerFAQSearch
      'FAQ Search' => 'Vyhledat FAQ',
      'Fulltext' => '',
      'Keyword' => 'Klov slovo',

      # Template: CustomerFAQSearchResult
      'FAQ Search Result' => 'Vsledky vyhledvn FAQ',

      # Template: CustomerFooter
      'Powered by' => 'Vytvoeno',

      # Template: CustomerHeader

      # Template: CustomerLogin
      'Login' => '',
      'Lost your password?' => 'Ztratil/a jste heslo?',
      'Request new password' => 'Podat o nov heslo',
      'Create Account' => 'Vytvoit et',

      # Template: CustomerNavigationBar
      'Welcome %s' => 'Vtejte %s',

      # Template: CustomerPreferencesForm

      # Template: CustomerStatusView
      'of' => 'z',

      # Template: CustomerTicketMessage

      # Template: CustomerTicketMessageNew

      # Template: CustomerTicketSearch

      # Template: CustomerTicketSearchResultCSV

      # Template: CustomerTicketSearchResultPrint

      # Template: CustomerTicketSearchResultShort

      # Template: CustomerTicketZoom

      # Template: CustomerWarning

      # Template: Error
      'Click here to report a bug!' => 'Kliknte zde pro nahlen chyby!',

      # Template: FAQ
      'Comment (internal)' => 'Koment (intern)',
      'A article should have a title!' => '',
      'New FAQ Article' => '',
      'Do you really want to delete this Object?' => '',
      'System History' => '',

      # Template: FAQCategoryForm
      'Name is required!' => '',
      'FAQ Category' => 'Kategorie FAQ',

      # Template: FAQLanguageForm
      'FAQ Language' => 'Jazyk FAQ',

      # Template: Footer
      'Top of Page' => 'Hlava strnky',

      # Template: FooterSmall

      # Template: Header
      'Home' => 'Dom',

      # Template: HeaderSmall

      # Template: InstallerBody
      'Web-Installer' => 'Web-instaltor',
      'Create Database' => 'Vytvoit Databazi',
      'Drop Database' => 'Odstranit databazi',
      'System Settings' => 'Nastaven systmu',
      'Finished' => 'Dokoneno',

      # Template: InstallerFinish
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Abyste mohli pouvat OTRS, muste zadat nsledujc dek do Vaeho pkazovho dku (Terminal/Shell) jako root.',
      'Restart your webserver' => 'Restartujte V webserver',
      'After doing so your OTRS is up and running.' => 'Po dokonen nsledujcch operac je V OTRS sputn a pob',
      'Start page' => 'vodn strnka',
      'Admin-User' => 'Administrtor',
      'Have a lot of fun!' => 'Pejeme hodn spch s OTRS!',
      'Your OTRS Team' => 'V OTRS tm',

      # Template: InstallerLicense
      'License' => 'Licence',
      'accept license' => 'souhlasm s licenc',
      'don\'t accept license' => 'nesouhlasm s licenc',

      # Template: InstallerStart
      'DB Admin User' => 'Administrtor databze',
      'DB Admin Password' => 'Heslo administrtora databze',
      'your MySQL DB should have a root password! Default is empty!' => 'Vae MySQL databze by mla mt root heslo! Vchoz je przdn!',
      'DB Host' => 'Hostitel (server) databze',
      'DB Type' => 'Typ databze',
      'OTRS DB Name' => 'Nzev OTRS databze',
      'OTRS DB User' => 'Uivatel OTRS databze',
      'OTRS DB Password' => 'Heslo OTRS databze',
      'default \'hot\'' => 'vchoz \'hot\'',
      'OTRS DB connect host' => 'Hostitel OTRS databze (server)',
      'Create new database' => 'Vytvoit novou databzi',
      'Delete old database' => 'Smazat starou databzi',
      'next step' => 'dal krok',

      # Template: InstallerSystem
      'SystemID' => 'Systmov ID',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Identita systmu. Kad slo tiketu a ID kad HTTP relace zan tmto slem)',
      'System FQDN' => 'Systm FQDN',
      '(Full qualified domain name of your system)' => '(Platn nzev domny pro v systm (FQDN))',
      'AdminEmail' => 'Email Administrtora',
      '(Email of the system admin)' => '(Email administrtora systmu)',
      'Organization' => 'Organizace',
      'LogModule' => 'Log Modul',
      '(Used log backend)' => '(Pouit vstup do logu)',
      'Logfile' => 'Log soubor',
      '(Logfile just needed for File-LogModule!)' => '(Pro logovn do souboru je nutn zadat nzev souboru logu!)',
      'CheckMXRecord' => 'Kontrolovat MX zznam',
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kontroluj MX zznamy pouitch emailovch adres pi sestavovn odpovdi. Nepouvejte pokud OTRS server pipojen pomoc vyten linky!)',
      'Ticket Hook' => 'Oznaen tiketu',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identifiktor tiket. Nekte lid chtj nastavit nap. \'Tiket#\',  \'Hovor#\' nebo \'MujTiket#\')',
      'Ticket Number Generator' => 'Genertor sel tiket',
      '(Used ticket number format)' => '(Pouit formt sel tiket)',
      'Webfrontend' => 'Webove rozhran',
      'Default Charset' => 'Vchoz znakov sada',
      'Use utf-8 it your database supports it!' => 'Pouijte utf-8 pokud to Vae databze podporuje',
      'Default Language' => 'Vchoz jazyk',
      '(Used default language)' => '(Pouit vchoz jazyk)',

      # Template: Login

      # Template: Motd

      # Template: NoPermission
      'No Permission' => 'dn prva',

      # Template: Notify

      # Template: PrintFooter
      'URL' => '',

      # Template: PrintHeader
      'printed by' => 'tisknuto',

      # Template: Redirect

      # Template: SystemStats
      'Format' => '',

      # Template: Test
      'OTRS Test Page' => 'Testovac OTRS strnka',
      'Counter' => '',

      # Template: Warning
    };
    # $$STOP$$
    $Self->{Translation} = \%Hash;
}
# --
1;

