# Kernel/Language/fr.pm - provides fr language translation
# Copyright (C) 2002 Bernard Choppy <choppy at imaginet.fr>
# Copyright (C) 2002 Nicolas Goralski <ngoralski at oceanet-technology.com>
# Copyright (C) 2004-2005 Yann Richard <ze at nbox.org>
# Copyright (C) 2004 Igor Genibel <igor.genibel at eds-opensource.com>
# --
# $Id: fr.pm,v 1.45 2005/05/16 12:46:35 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::fr;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.45 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;
# --
sub Data {
    my $Self = shift;
    my %Param = @_;

    # $$START$$
    # Last translation file sync: Sun May  8 23:10:46 2005

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D.%M.%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %T %Y';
    $Self->{DateInputFormat} = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
      # Template: AAABase
      'Yes' => 'Oui',
      'No' => 'Non',
      'yes' => 'oui',
      'no' => 'non',
      'Off' => 'teint',
      'off' => 'teint',
      'On' => 'Allum',
      'on' => 'allum',
      'top' => 'haut',
      'end' => 'fin',
      'Done' => 'Fait',
      'Cancel' => 'Annuler',
      'Reset' => 'Remise  zro',
      'day' => 'jour',
      'days' => 'jours',
      'hour' => 'heure',
      'hours' => 'heures',
      'minute' => '',
      'minutes' => '',
      'wrote' => 'crit',
      'Message' => '',
      'Error' => 'Erreur',
      'Bug Report' => 'Rapport d\'anomalie',
      'Attention' => '',
      'Warning' => 'Attention',
      'Module' => '',
      'Modulefile' => 'Fichier de module',
      'Subfunction' => 'sous-fonction',
      'Line' => 'Ligne',
      'Example' => 'Exemple',
      'Examples' => 'Exemples',
      'invalid' => 'invalide',
      ' 2 minutes' => '',
      ' 5 minutes' => '',
      ' 7 minutes' => '',
      '10 minutes' => '',
      '15 minutes' => '',
      'Mr.' => 'M.',
      'Mrs.' => 'Mme',
      'Next' => 'Suivant',
      'Back' => 'Retour',
      'Next...' => 'Suivant...',
      '...Back' => '...Retour',
      '-none-' => '-aucun-',
      'none' => 'aucun',
      'none!' => 'aucun !',
      'none - answered' => 'aucun - rpondu',
      'please do not edit!' => 'Ne pas modifier !',
      'AddLink' => 'Ajouter un lien',
      'Link' => 'Lien',
      'Linked' => 'Lie',
      'Link (Normal)' => 'Lien (Normal)',
      'Link (Parent)' => 'Lien (Parent)',
      'Link (Child)' => 'Lien (Enfant)',
      'Normal' => '',
      'Parent' => '',
      'Child' => 'Enfant',
      'Hit' => '',
      'Hits' => '',
      'Text' => 'Texte',
      'Lite' => 'allge',
      'User' => 'Utilisateur',
      'Username' => 'Nom d\'utilisateur',
      'Language' => 'Langue',
      'Languages' => 'Langues',
      'Password' => 'Mot de Passe',
      'Salutation' => '',
      'Signature' => '',
      'Customer' => 'Client',
      'CustomerID' => 'Numro de client',
      'CustomerIDs' => 'Numro de client (Groupe)',
      'customer' => 'client',
      'agent' => 'technicien',
      'system' => 'systme',
      'Customer Info' => 'Information client',
      'go!' => 'c\'est parti !',
      'go' => 'aller',
      'All' => 'Tout',
      'all' => 'tout',
      'Sorry' => 'Dsol',
      'update!' => 'mettre  jour !',
      'update' => 'mettre  jour',
      'Update' => 'Mettre  jour',
      'submit!' => 'soumettre !',
      'submit' => 'soumettre',
      'Submit' => 'Soumettre',
      'change!' => 'modifier !',
      'Change' => 'Modifier',
      'change' => 'modifier',
      'click here' => 'Cliquer ici',
      'Comment' => 'Commentaire',
      'Valid' => 'Valide',
      'Name' => 'Nom',
      'Group' => 'Groupe',
      'Description' => '',
      'description' => '',
      'Theme' => 'Thme',
      'Created' => 'Cr',
      'Created by' => 'Cre par',
      'Changed' => 'Chang',
      'Changed by' => 'Chang par',
      'Search' => 'Chercher',
      'and' => 'et le',
      'between' => 'entre',
      'Fulltext Search' => '',
      'Data' => '',
      'Options' => '',
      'Title' => 'Titre',
      'Item' => 'lment',
      'Delete' => 'Effacer',
      'Edit' => 'diter',
      'View' => 'Vue',
      'Number' => 'Nombre',
      'System' => 'Systme',
      'Contact' => '',
      'Contacts' => '',
      'Export' => 'Exporter',
      'Up' => 'Haut',
      'Down' => 'Bas',
      'Add' => 'Ajouter',
      'Category' => 'Catgorie',
      'New message' => 'Nouveau message',
      'New message!' => 'Nouveau message !',
      'Admin-Area' => 'Zone d\'administration',
      'Agent-Area' => 'Interface du technicien',
      'FAQ-Area' => 'Foire Aux Questions',
      'QueueView' => 'Vue file',
      'Stats' => 'Statistiques',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Il faut rpondre  ce(s) ticket(s) pour revenir  une vue normale de la file !',
      'You got new message!' => 'Vous avez un nouveau message !',
      'You have %s new message(s)!' => 'Vous avez %s nouveau(x) message(s) !',
      'You have %s reminder ticket(s)!' => 'Vous avez %s rappel(s) de ticket(s) !',
      'The recommended charset for your language is %s!' => 'Le jeu de caractre correspondant  votre langue est %s!',
      'Passwords dosn\'t match! Please try it again!' => 'Les mots de passes diffrent! Essayez de nouveau svp!',
      'Password is already in use! Please use an other password!' => 'Mot de passe dj utilis! Essayez en un autre svp!',
      'Password is already used! Please use an other password!' => 'Ce mot de passe a dj t utilis! Essayez en un autre svp!',
      'No suggestions' => 'Pas de suggestions',
      'Word' => 'Mot',
      'Ignore' => 'Ignorer',
      'replace with' => 'remplacer par',
      'Welcome to OTRS' => 'Bienvenue dans OTRS',
      'There is no account with that login name.' => 'Il n\'y a aucun compte avec ce nom de connexion',
      'Login failed! Your username or password was entered incorrectly.' => 'La connection a chou ! Votre nom d\'utilisateur ou votre mot de passe sont errons.',
      'Please contact your admin' => 'Veuillez contacter votre admnistrateur',
      'Logout successful. Thank you for using OTRS!' => 'Dconnexion russie. Merci d\'avoir utilis OTRS!',
      'Invalid SessionID!' => 'ID de Session Invalide !',
      'Feature not active!' => 'Cette fonctionnalit n\'est pas active !',
      'Ticket Number' => 'Numro de ticket',
      'Ticket Object' => '',
      'No such Ticket Number "%s"! Can\'t link it!' => 'Pas de numro de ticket "%s"! Je ne peut pas le lier',
      'Take this Customer' => 'Choisir ce client',
      'Take this User' => 'Choisir cet utilisateur',
      'possible' => '',
      'reject' => 'rejet',
      'Facility' => 'Service',
      'Timeover' => 'Temp coul',
      'Pending till' => 'En attendant jusqu\'',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Cela ne fonctionne pas avec l\'identfifiant utilisateur 1 (Compte Systme)! Veuillez crer un nouvel utilisateur!',
      'Dispatching by email To: field.' => 'Rpartition par le champs \':\' du courriel',
      'Dispatching by selected Queue.' => 'Rpartition selon la file slectionne',
      'No entry found!' => 'Aucun rsultat n\'a t trouv !',
      'Session has timed out. Please log in again.' => 'Le dlai de votre session est dpass, veuillez vous r-authentifier.',
      'No Permission!' => 'Pas de permission!',
      'To: (%s) replaced with database email!' => 'Le champ \':\' (%s) a t remplac avec la valeur de la base de donnes des des adresses de courriel !',
      'Cc: (%s) added database email!' => 'Cc: (%s) a t ajout  la base de donne d\'e-mail',
      'Don\'t show closed Tickets' => 'Ne pas montrer les tickets ferms',
      'Show closed Tickets' => 'Voir les tickets ferms',
      'New Article' => 'Nouvel Article',
      '(Click here to add)' => '(Cliquez ii pour ajouter)',
      'last' => 'dernier',
      'before' => 'avant',
      'day(s)' => 'jour(s)',
      'month(s)' => 'mois',
      'week(s)' => 'semaine(s)',
      'year(s)' => 'anne(s)',
      'Preview' => 'Aperu',
      'Added User "%s"' => 'Ajout de l\'utilisateur "%s"',
      'Contract' => '',
      'Online Customer: %s' => 'Clients en ligne: %s',
      'Online Agent: %s' => 'Agents en ligne: %s',
      'Calendar' => 'Calendrier',
      'File' => 'Fichier',
      'Filename' => 'Nom de fichier',
      'Type' => '',
      'Size' => 'Taille',
      'Upload' => 'Uploader',
      'Directory' => 'Rpertoire',
      'Signed' => 'Sign',
      'Sign' => 'Signer',
      'Crypted' => 'Crypt',
      'Crypt' => 'Crypter',
      'History::Move' => 'Le ticket a t dplac dans la file "%s" (%s) - Ancienne file: "%s" (%s).',
      'History::NewTicket' => 'Un nouveau ticket a t cre: [%s] created (Q=%s;P=%s;S=%s).',
      'History::FollowUp' => 'Un suivie du ticket [%s]. %s',
      'History::SendAutoReject' => 'Rejet automatique envoy  "%s".',
      'History::SendAutoReply' => 'Rponse automatique envoy  "%s".',
      'History::SendAutoFollowUp' => 'Suivie automatique envoy  "%s".',
      'History::Forward' => 'Transfr vers "%s".',
      'History::Bounce' => 'Redirig vers "%s".',
      'History::SendAnswer' => 'Email envoy  "%s".',
      'History::SendAgentNotification' => '"%s"-notification envoy  "%s".',
      'History::SendCustomerNotification' => 'Notification envoy  "%s".',
      'History::EmailAgent' => 'Email envoy au client.',
      'History::EmailCustomer' => 'Ajout d\'une adresse email. %s',
      'History::PhoneCallAgent' => 'Agent a appell le client.',
      'History::PhoneCallCustomer' => 'Le client nous a appell.',
      'History::AddNote' => 'Ajout d\'une note (%s)',
      'History::Lock' => 'Ticket vrouill.',
      'History::Unlock' => 'Ticket dvrouill.',
      'History::TimeAccounting' => 'Temps pass sur l\'action: %s . Total du temps pass pour ce ticket: %s unit(s).',
      'History::Remove' => '%s',
      'History::CustomerUpdate' => 'Mise  jour: %s',
      'History::PriorityUpdate' => 'Changement de priorit de "%s" (%s) pour "%s" (%s).',
      'History::OwnerUpdate' => 'Le nouveau propritaire est "%s" (ID=%s).',
      'History::LoopProtection' => 'Protection anti-boucle! Pas d\'auto rponse envoy  "%s".',
      'History::Misc' => '%s',
      'History::SetPendingTime' => 'Mise  jour: %s',
      'History::StateUpdate' => 'Avant: "%s" Aprs: "%s"',
      'History::TicketFreeTextUpdate' => 'Mise  jour: %s=%s;%s=%s;',
      'History::WebRequestCustomer' => 'Requte du client via le web.',
      'History::TicketLinkAdd' => 'Added link to ticket "%s".',
      'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',

      # Template: AAAMonth
      'Jan' => '',
      'Feb' => 'Fv',
      'Mar' => '',
      'Apr' => 'Avr',
      'May' => 'Mai',
      'Jun' => 'Juin',
      'Jul' => 'Juil',
      'Aug' => 'Au',
      'Sep' => '',
      'Oct' => '',
      'Nov' => '',
      'Dec' => 'Dc',

      # Template: AAANavBar
      'Ticket-Area' => 'Tickets',
      'Logout' => 'Dconnexion',
      'Agent Preferences' => 'Prfrences de l\'Agent',
      'Preferences' => 'Prfrences',
      'Agent Mailbox' => 'Boite e-mail de l\'Agent',
      'Stats-Area' => 'Statistiques',
      'FAQ' => '',
      'FAQ-Search' => '(FAQ) Rechercher',
      'FAQ-Article' => '(FAQ) Article',
      'FAQ-State' => '(FAQ) tat',
      'Admin' => '',
      'A web calendar' => '',
      'WebMail' => '',
      'A web mail client' => '',
      'FileManager' => '',
      'A web file manager' => '',
      'Artefact' => '',
      'Incident' => '',
      'Advisory' => '',
      'WebWatcher' => '',

      # Template: AAAPreferences
      'Preferences updated successfully!' => 'Les prfrences ont bien t mises  jours !',
      'Mail Management' => 'Gestion des e-mails',
      'Frontend' => 'Interface',
      'Other Options' => 'Autres options',
      'New ticket notification' => 'Notification de nouveau ticket',
      'Send me a notification if there is a new ticket in "My Queues".' => 'Me prvenir si il y a un nouveau ticket dans une de "Mes files".',
      'Follow up notification' => 'Notification de suivi',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Me prvenir si un client envoie un suivi (follow-up) et que je suis le propritaire du ticket.',
      'Ticket lock timeout notification' => 'Prvenir du dpassement du dlai d\'un verrou',
      'Send me a notification if a ticket is unlocked by the system.' => 'Me prvenir si un ticket est dvrouill par le systme',
      'Move notification' => 'Notification de mouvement',
      'Send me a notification if a ticket is moved into one of "My Queues".' => 'Me prvenir si un ticket est dplac dans une de "Mes files".',
      'Custom Queue' => 'File d\'attente personnalis',
      'QueueView refresh time' => 'Temps de rafrachissement de la vue des files',
      'Select your QueueView refresh time.' => 'Choix du dlai de rafrachissement de la vue des files',
      'Select your frontend language.' => 'Choix de la langue de l\'interface',
      'Select your frontend Charset.' => 'Choix du jeu de caractres de l\'interface',
      'Select your frontend Theme.' => 'Choix du thme de l\'interface',
      'Select your frontend QueueView.' => 'Choisissez votre interface de vue des files',
      'Spelling Dictionary' => 'Correcteur orthographique',
      'Select your default spelling dictionary.' => 'Slectionnez votre correcteur orthographique par dfaut',
      'PhoneView' => 'Vue tlphone',
      'TicketZoom' => 'Vue en dtails',
      'CreateTicket' => 'Crer Ticket',
      'Screen after new ticket' => 'cran aprs un nouveau ticket',
      'Select your screen after creating a new ticket.' => 'Slectionnez l\'cran qui sera affich aprs avoir cr un nouveau ticket.',
      'Closed Tickets' => 'Tickets ferms',
      'Show closed tickets.' => 'Voir les tickets ferms',
      'Max. shown Tickets a page in QueueView.' => 'Nombre de tickets maximum sur la page de la vue d\'une file',
      'Max. shown Tickets a page in Overview.' => 'Nombre de tickets maximum sur la page d\'aperu des tickets',
      'Can\'t update password, passwords dosn\'t match! Please try it again!' => 'Mise  jour du mot de passe impossible, les mots de passe diffrent! Essayez  nouveau svp!',
      'Can\'t update password, invalid characters!' => 'Mise  jour du mot de passe impossible, caractres invalides!',
      'Can\'t update password, need min. 8 characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit avoir au moins 8 caractres!',
      'Can\'t update password, need 2 lower and 2 upper characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter 2 majuscules et 2 minuscules!',
      'Can\'t update password, need min. 1 digit!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter un chiffre minimum!',
      'Can\'t update password, need min. 2 characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter 2 caractres minimum!',

      # Template: AAATicket
      'Lock' => 'Vrrouiller',
      'Unlock' => 'Dverrouiller',
      'History' => 'Historique',
      'Zoom' => 'Dtails',
      'Age' => 'ge',
      'Bounce' => 'Renvoyer',
      'Forward' => 'Transmettre',
      'From' => 'De ',
      'To' => '',
      'Cc' => 'Copie ',
      'Bcc' => 'Copie Invisible',
      'Subject' => 'Sujet',
      'Move' => 'Dplacer',
      'Queue' => 'File',
      'Priority' => 'Priorit',
      'State' => 'tat',
      'Compose' => 'Composer',
      'Pending' => 'En attente',
      'Owner' => 'Propritaire',
      'Sender' => 'metteur',
      'Article' => '',
      'Ticket' => '',
      'Createtime' => 'Cration du ',
      'plain' => 'tel quel',
      'eMail' => 'courriel',
      'email' => 'courriel',
      'Close' => 'Fermer',
      'Action' => '',
      'Attachment' => 'Pice jointe',
      'Attachments' => 'Pices jointes',
      'This message was written in a character set other than your own.' => 'Ce message a t crit dans un jeu de caractres diffrent du vtre.',
      'If it is not displayed correctly,' => 'S\'il n\'est pas affich correctement',
      'This is a' => 'Ceci est un',
      'to open it in a new window.' => 'L\'ouvrir dans une nouvelle fentre',
      'This is a HTML email. Click here to show it.' => 'Ceci est un message au format HTML ; cliquer ici pour l\'afficher.',
      'closed successful' => 'clture russie',
      'closed unsuccessful' => 'clture manque',
      'new' => 'nouveau',
      'open' => 'ouvrir',
      'closed' => 'fermer',
      'removed' => 'supprim',
      'pending reminder' => 'Attente du rappel',
      'pending auto close+' => 'Attente de la fermeture automatique(+)',
      'pending auto close-' => 'Attente de la fermeture automatique(-)',
      'email-external' => 'message externe',
      'email-internal' => 'message interne',
      'note-external' => 'Note externe',
      'note-internal' => 'Note interne',
      'note-report' => 'Note rapport',
      'phone' => 'tlphone',
      'sms' => '',
      'webrequest' => 'Requte par le web',
      'lock' => 'vrrouiller',
      'unlock' => 'dverrouiller',
      'very low' => 'trs basse',
      'low' => 'confort de fonctionnement',
      'normal' => '',
      'high' => 'important',
      'very high' => 'trs haut',
      '1 very low' => '1 trs bas',
      '2 low' => '2 bas',
      '3 normal' => '',
      '4 high' => '4 important',
      '5 very high' => '5 trs important',
      'Ticket "%s" created!' => 'Le ticket %s a t cr !',
      'Email-Ticket' => '',
      'Create new Email Ticket' => '',
      'Phone-Ticket' => '',
      'Create new Phone Ticket' => 'Crer un nouveau Ticket "tlphone"',
      'Search Tickets' => '',
      'Edit Customer Users' => '',
      'Bulk-Action' => '',
      'Bulk Actions on Tickets' => '',
      'Send Email and create a new Ticket' => 'Envoyer un courriel et crer un nouveau Ticket',
      'Overview of all open Tickets' => 'Vue de tout les Tickets',
      'Locked tickets' => '',
      'Lock it to work on it!' => '',
      'Unlock to give it back to the queue!' => '',
      'Shows the ticket history!' => '',
      'Print this ticket!' => '',
      'Change the ticket priority!' => '',
      'Change the ticket free fields!' => '',
      'Link this ticket to an other objects!' => '',
      'Change the ticket owner!' => '',
      'Change the ticket customer!' => '',
      'Add a note to this ticket!' => '',
      'Merge this ticket!' => '',
      'Set this ticket to pending!' => '',
      'Close this ticket!' => '',
      'Look into a ticket!' => '',
      'Delete this ticket!' => '',

      # Template: AAAWeekDay
      'Sun' => 'Dim',
      'Mon' => 'Lun',
      'Tue' => 'Mar',
      'Wed' => 'Mer',
      'Thu' => 'Jeu',
      'Fri' => 'Ven',
      'Sat' => 'Sam',

      # Template: AdminAttachmentForm
      'Attachment Management' => 'Gestion des attachements',

      # Template: AdminAutoResponseForm
      'Auto Response Management' => 'Gestion des rponses automatiques',
      'Response' => 'Rponse',
      'Auto Response From' => 'Rponse automatique de ',
      'Note' => '',
      'Useable options' => 'Options accessibles',
      'to get the first 20 character of the subject' => 'pour avoir les 20 premiers caractres du sujet ',
      'to get the first 5 lines of the email' => 'pour avoir les 5 premires ligne du mail',
      'to get the from line of the email' => 'pour avoir les lignes \'De\' du courriel',
      'to get the realname of the sender (if given)' => 'pour avoir le nom rel de l\'utilisateur (s\il est donn)',
      'Options of the ticket data (e. g. &lt;OTRS_TICKET_TicketNumber&gt;, &lt;OTRS_TICKET_TicketID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',

      # Template: AdminCustomerUserForm
      'The message being composed has been closed.  Exiting.' => 'Le message en cours de rdaction a t cltur. Sortie.',
      'This window must be called from compose window' => 'Cette fentre doit tre appele de la fentre depuis la fentre de rdaction',
      'Customer User Management' => 'Gestion des clients utilisateurs',
      'Search for' => 'Chercher ',
      'Result' => 'Rsultat',
      'Select Source (for add)' => 'Slectionnez une source (pour ajout)',
      'Source' => '',
      'This values are read only.' => 'Ces valeurs sont en lecture seule.',
      'This values are required.' => 'Ces valeurs sont obligatoires.',
      'Customer user will be needed to have an customer histor and to to login via customer panels.' => 'Les clients utilisateurs seront invits  se connecter par la page client.',

      # Template: AdminCustomerUserGroupChangeForm
      'Customer Users <-> Groups Management' => 'Clients <-> Gestion des groupes',
      'Change %s settings' => 'Changer les param&ecirc;tres de %s',
      'Select the user:group permissions.' => 'Slectionnez les permissions pour l\'utilisateur:groupe.',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Si rien n\'est slectionn, il n\'y aura pas de droits dans ce groupe (Les tickets ne seront plus disponible pour l\'utilisateur).',
      'Permission' => 'Droits',
      'ro' => 'lecture seule',
      'Read only access to the ticket in this group/queue.' => 'Accs en lecture seulement aux tickets de cette file/groupe.',
      'rw' => 'lecture/criture',
      'Full read and write access to the tickets in this group/queue.' => 'Accs complet en lecture et criture aux tickets dans cette file/groupe.',

      # Template: AdminCustomerUserGroupForm
      'Change user <-> group settings' => 'Modifier les paramtres utilisateurs <-> groupes',

      # Template: AdminEmail
      'Admin-Email' => 'Email de l\'administrateur',
      'Message sent to' => 'Message envoy ',
      'Recipents' => 'Rcipients',
      'Body' => 'Corps',
      'send' => 'envoyer',

      # Template: AdminGenericAgent
      'GenericAgent' => '',
      'Job-List' => '',
      'Last run' => '',
      'valid' => '',
      'Run Now!' => '',
      'x' => '',
      'Save Job as?' => '',
      'Is Job Valid?' => '',
      'Is Job Valid' => '',
      'Schedule' => 'Planifier',
      'Minutes' => '',
      'Hours' => 'Heures',
      'Days' => 'Jours',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Recherche sur le texte d\'un article (ex: "Mar*in" or "Baue*")',
      '(e. g. 10*5155 or 105658*)' => '(ex: 10*5155 or 105658*)',
      '(e. g. 234321)' => '(ex: 234321)',
      'Customer User Login' => 'Nom de connexion du client',
      '(e. g. U5150)' => '(ex: U5150)',
      'Agent' => 'Technicien',
      'TicketFreeText' => 'Texte Libre du Ticket',
      'Ticket Lock' => 'Ticket vrouill',
      'Times' => 'Fois',
      'No time settings.' => 'Pas de paramtre de temps',
      'Ticket created' => 'Ticket cr',
      'Ticket created between' => 'Ticket cr entre le',
      'New Priority' => 'Nouvelle Priorit',
      'New Queue' => 'Nouvelle File',
      'New State' => 'Nouvel tat',
      'New Agent' => 'Nouvel Agent',
      'New Owner' => 'Nouveau Propritaire',
      'New Customer' => 'Nouveau Client',
      'New Ticket Lock' => 'Nouveau Verrou',
      'CustomerUser' => 'Client utilisateur',
      'Add Note' => 'Ajouter une note',
      'CMD' => '',
      'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Cette commande sera excut. ARG[0] sera le numro du ticket et ARG[1] son identifiant.',
      'Delete tickets' => 'Effacer les tickets',
      'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Attention, ces tickets seront ffacs de la base de donne ! Ils seront dfinitivement perdu !',
      'Modules' => '',
      'Param 1' => 'Paramtre 1',
      'Param 2' => 'Paramtre 2',
      'Param 3' => 'Paramtre 3',
      'Param 4' => 'Paramtre 4',
      'Param 5' => 'Paramtre 5',
      'Param 6' => 'Paramtre 6',
      'Save' => 'Sauver',

      # Template: AdminGroupForm
      'Group Management' => 'Administration des groupes',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'Le groupe admin permet d\'accder  la zone d\'administration et le groupe stats  la zone de statistiques.',
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crer de nouveaux groupes permettra de grer les droits d\'accs pour les diffrents groupes du technicien (exemple: achats, comptabilit, support, ventes...).',
      'It\'s useful for ASP solutions.' => 'C\'est utile pour les fournisseurs d\'applications.',

      # Template: AdminLog
      'System Log' => 'Journaux du Systme',
      'Time' => 'Date et heure',

      # Template: AdminNavigationBar
      'Users' => 'Utilisateurs',
      'Groups' => 'Groupes',
      'Roles' => 'Rles',
      'Responses' => 'Rponses',
      'Misc' => 'Divers',

      # Template: AdminNotificationForm
      'Notification Management' => 'Gestion des notifications',
      'Notification' => '',
      'Notifications are sent to an agent or a customer.' => 'Des notifications sont envoyes  un technicien ou  un client.',
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Options de configuration (ex: &lt;OTRS_CONFIG_HttpType&gt;)',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Options du propritaire d\'un ticket (ex: &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Options concernant l\'utilisateur actuel ayant effectu cet action (ex: &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Options concernant les donnes du client actuel (ex: &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',

      # Template: AdminPackageManager
      'Package Manager' => 'Gestionnaire de paquet',
      'Uninstall' => 'Dinstallation',
      'Verion' => 'Version',
      'Do you really want to uninstall this package?' => 'Voulez-vous vraiment dinstaller ce paquet ?',
      'Install' => 'Installation',
      'Package' => 'Paquet',
      'Online Repository' => '',
      'Version' => '',
      'Vendor' => 'Vendeur',
      'Upgrade' => 'Mise  jour',
      'Local Repository' => '',
      'Status' => 'tat',
      'Overview' => 'Aperu',
      'Download' => 'Tlchargement',
      'Rebuild' => 'Re-construction',
      'Reinstall' => 'R-installation',

      # Template: AdminPGPForm
      'PGP Management' => 'Gestion de PGP',
      'Identifier' => 'Identifiant',
      'Bit' => '',
      'Key' => 'Cl',
      'Fingerprint' => 'Empreinte',
      'Expires' => 'Expiration',
      'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Dans ce cas vous pouvez directement diter le trousseau de cl dans Kernel/Config.pm',
      'FIXME: WHAT IS PGP?' => 'FIXEZ MOI: Qu\'est ce que PGP',

      # Template: AdminPOP3Form
      'POP3 Account Management' => 'Gestion du compte POP3',
      'Host' => 'Hte',
      'Trusted' => 'Vrifi',
      'Dispatching' => 'Rpartition',
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Tous les courriels entrants avec un compte seront rpartis dans la file slectionne !',
      'If your account is trusted, the already existing x-otrs header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Si votre compte est vrifi, les ent&ecirc;tes x-otrs (pour les priorits,...) seront utiliss !',

      # Template: AdminPostMasterFilter
      'PostMaster Filter Management' => 'Gestion des filtres PostMaster',
      'Filtername' => 'Nom du filtre',
      'Match' => 'Correspond',
      'Header' => 'En-tte',
      'Value' => 'Valeur',
      'Set' => 'Assigner',
      'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'dispatcher ou filtrer les courriels entrant bas sur les en-ttes (X-*)! L\'utilisationd\'expression rgulire est aussi possible.',
      'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '',

      # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Responses Management' => 'Files <-> Gestion des rponses automatiques',

      # Template: AdminQueueAutoResponseTable

      # Template: AdminQueueForm
      'Queue Management' => 'Gestion des files',
      'Sub-Queue of' => 'Sous-file',
      'Unlock timeout' => 'Dlai du dverrouillage',
      '0 = no unlock' => '0 = pas de vrouillage',
      'Escalation time' => 'Dlai de remont du ticket',
      '0 = no escalation' => '0 = pas de remont du ticket',
      'Follow up Option' => 'Option des suivis',
      'Ticket lock after a follow up' => 'Ticket verrouill aprs un suivi',
      'Systemaddress' => 'Adresse du Systme',
      'Customer Move Notify' => 'Notification lors d\'un changement de file',
      'Customer State Notify' => 'Notification lors d\'un changement d\'tat',
      'Customer Owner Notify' => 'Notification lors d\'un changement de propritaire',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Si un technicien verrouille un ticket et qu\'il/elle n\'envoie pas une rponse dans le temps imparti, le ticket sera dverrouill automatiquement. Le ticket sera alors visible de tous les autres techniciens',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Si un ticket n\'est pas rpondu dans le temps imparti, ce ticket sera seulement affich',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Si un ticket est clotur et que le client envoie une note, le ticket sera verrouill pour l\'ancien propritaire',
      'Will be the sender address of this queue for email answers.' => 'Sera l\'adresse d\'expdition pour les rponses par courriel.',
      'The salutation for email answers.' => 'La formule de politesse pour les rponses par mail',
      'The signature for email answers.' => 'La signature pour les rponses par courriel',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS envoit un courriel au client ilorsque le ticket change de file.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS envoit un courriel au client lorsque le ticket change d\'tat.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS envoit un courriel au client lorsque le ticket change de propritaire.',

      # Template: AdminQueueResponsesChangeForm
      'Responses <-> Queue Management' => 'Rponses <-> Gestion des files',

      # Template: AdminQueueResponsesForm
      'Answer' => 'Rponse',

      # Template: AdminResponseAttachmentChangeForm
      'Responses <-> Attachments Management' => 'Rponses <-> Gestion des pices jointes',

      # Template: AdminResponseAttachmentForm

      # Template: AdminResponseForm
      'Response Management' => 'Gestion des rponses',
      'A response is default text to write faster answer (with default text) to customers.' => 'Une rponse est un texte par dfaut destin  rdiger plus rapidement des rponses standard aux clients.',
      'Don\'t forget to add a new response a queue!' => 'Ne pas oublier d\'ajouter une file  une nouvelle rponse !',
      'Next state' => 'tat suivant',
      'All Customer variables like defined in config option CustomerUser.' => 'Toutes les variables client tels que dfinies dans les options "Client utilisateur"',
      'The current ticket state is' => 'L\'tat actuel du ticket est',
      'Your email address is new' => 'Votre adresse lectronique est nouvelle',

      # Template: AdminRoleForm
      'Role Management' => 'Gestion des Rles',
      'Create a role and put groups in it. Then add the role to the users.' => 'Crer un rle et ',
      'It\'s useful for a lot of users and groups.' => 'Pratique lorsqu\'on a beaucoup d\'utilisateurs et de groupes',

      # Template: AdminRoleGroupChangeForm
      'Roles <-> Groups Management' => 'Rles <-> Gestion des groupes',
      'move_into' => 'dplacer dans',
      'Permissions to move tickets into this group/queue.' => 'Permission de dplacer un ticket dans cette file/groupe.',
      'create' => 'crer',
      'Permissions to create tickets in this group/queue.' => 'Permission de crer un ticket dans cette file/groupe.',
      'owner' => 'propritaire',
      'Permissions to change the ticket owner in this group/queue.' => 'Permission de changer le propritaire d\'un ticket dans cette file/groupe.',
      'priority' => 'priorit',
      'Permissions to change the ticket priority in this group/queue.' => 'Permission de changer la priorit d\'un ticket dans cette file/groupe.',

      # Template: AdminRoleGroupForm
      'Change roles <-> groups settings' => 'Changer les rles <-> paramttres des groupes',
      'Role' => 'Rles',

      # Template: AdminRoleUserChangeForm
      'Roles <-> Users Management' => 'Rles <-> Gestion des utilisateurs',
      'Active' => 'Actif',
      'Select the role:user relations.' => 'Slection des relations role/utilisateur',

      # Template: AdminRoleUserForm
      'Change users <-> roles settings' => 'Changement d\'utilisateur <-> parramttres des rles',

      # Template: AdminSalutationForm
      'Salutation Management' => 'Prfixes des messages',
      'customer realname' => 'nom rel du client',
      'for agent firstname' => 'pour le prnom du technicien',
      'for agent lastname' => 'pour le nom du technicien',
      'for agent user id' => 'pour l\'identifiant du technicien',
      'for agent login' => 'pour le nom de connexion (login) du technicien',

      # Template: AdminSelectBoxForm
      'Select Box' => 'Requte SQL libre.',
      'SQL' => '',
      'Limit' => 'Limite',
      'Select Box Result' => 'Choisissez le rsultat',

      # Template: AdminSession
      'Session Management' => 'Gestion des sessions',
      'Sessions' => 'Session',
      'Uniq' => 'Unique',
      'kill all sessions' => 'Terminer toutes les sessions',
      'Session' => '',
      'kill session' => 'Terminer une session',

      # Template: AdminSignatureForm
      'Signature Management' => 'Gestion des signatures',

      # Template: AdminSMIMEForm
      'SMIME Management' => 'Gestion SMIME',
      'Add Certificate' => 'Ajouter un certificat',
      'Add Private Key' => 'Ajouter une cl prive',
      'Secret' => 'Secrt',
      'Hash' => 'Hashage',
      'In this way you can directly edit the certification and private keys in file system.' => 'Dans ce cas vous pouvez directement diter le certificat et la cl prive dans le systme de fichier',
      'FIXME: WHAT IS SMIME?' => 'FIXME: Qu\'est ce que SMIME?',

      # Template: AdminStateForm
      'System State Management' => 'Gestion des tats du systme',
      'State Type' => 'Type d\'tat',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Prennez garde de bien mettre  jour les tats par dfaut dans votre Kernel/Config.pm !',
      'See also' => 'Voir aussi',

      # Template: AdminSysConfig
      'SysConfig' => 'Configuration Systme',
      'Group selection' => 'Slection du groupe',
      'Show' => 'Voir',
      'Subgroup' => 'Sous-groupe',

      # Template: AdminSysConfigEdit
      'Options ' => 'Options',
      'for ' => 'pour',
      'Subgroup \'' => 'Sous-groupe \'',
      'Content' => '',
      'New' => 'Nouveau',
      'Group Ro' => 'Groupe lecture seule',
      'NavBarName' => 'Nom de la barre de navigation',
      'Image' => '',
      'Typ' => 'Type',
      'Prio' => 'Priorit',
      'Block' => '',
      'NavBar' => 'Barre de navigation',

      # Template: AdminSystemAddressForm
      'System Email Addresses Management' => 'Gestion des adresses courriel du systme',
      'Email' => 'Courrier lectronique',
      'Realname' => 'Vritable Nom',
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Tous les courriels avec cette adresse en destinataire (:) seront rpartis dans la file slectionne !',

      # Template: AdminUserForm
      'User Management' => 'Administration des utilisateurs',
      'Firstname' => 'Prnom',
      'Lastname' => 'Nom',
      'User will be needed to handle tickets.' => 'Un utilisateur sera ncessaire pour grer les tickets.',
      'Don\'t forget to add a new user to groups!' => 'Ne pas oublier d\'ajouter un nouvel utilisateur aux groupes !',

      # Template: AdminUserGroupChangeForm
      'Users <-> Groups Management' => 'Utilisateurs <-> Gestion des groupes',

      # Template: AdminUserGroupForm

      # Template: AgentBook
      'Address Book' => 'Carnet d\'adresses',
      'Return to the compose screen' => 'Retourner  l\'cran de saisie',
      'Discard all changes and return to the compose screen' => 'Annuler tous les changements et retourner  l\'cran de saisie',

      # Template: AgentCustomerTableView

      # Template: AgentInfo
      'Info' => 'Information',

      # Template: AgentLinkObject
      'Link Object' => '',
      '"}" $Text{"with' => '',
      'Select' => 'Slectionner',
      'Results' => 'Rsultat',
      'Total hits' => 'Total des hits',
      'Site' => '',
      'Detail' => 'Dtail',

      # Template: AgentLookup
      'Lookup' => 'Consulter',

      # Template: AgentNavigationBar
      'Ticket selected for bulk action!' => 'Ticket slectionn pour une action group!',
      'You need min. one selected Ticket!' => 'Vous devez nommer au moins un Ticket!',

      # Template: AgentPreferencesForm

      # Template: AgentSpelling
      'Spell Checker' => 'Vrificateur orthographique',
      'spelling error(s)' => 'erreurs d\'orthographe',
      'or' => 'ou',
      'Apply these changes' => 'Appliquer ces changements',

      # Template: AgentTicketBounce
      'A message should have a To: recipient!' => 'Un message doit avoir un destinataire (:)!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Il faut une adresse courriel (ex&nbsp;: client@exemple.fr)&nbsp;!',
      'Bounce ticket' => 'Renvoyer le ticket',
      'Bounce to' => 'Renvoyer ',
      'Next ticket state' => 'Prochain tat du ticket',
      'Inform sender' => 'Informer l\'emetteur',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Votre message concernant le ticket numro "<OTRS_TICKET> est rmis  "<OTRS_BOUNCE_TO>". Contactez cette adresse pour de plus amples renseignements',
      'Send mail!' => 'Envoyer le courriel !',

      # Template: AgentTicketBulk
      'A message should have a subject!' => 'Un message doit avoir un sujet !',
      'Ticket Bulk Action' => 'Ticket en action group',
      '$Text{"Note!' => '',
      'Spell Check' => 'Vrification orthographique',
      'Note type' => 'Type de note',
      'Unlock Tickets' => 'Dvrouiller Tickets',

      # Template: AgentTicketClose
      'A message should have a body!' => 'Un message doit avoir un corp !',
      'You need to account time!' => 'Vous devez avoir un compte de temps&nbsp;!',
      'Close ticket' => 'Ticket clos',
      'Close!' => 'Clture!',
      'Note Text' => 'Note',
      'Close type' => 'Type de clture',
      'Time units' => 'Unit de temps',
      ' (work units)' => ' Unit de travail',

      # Template: AgentTicketCompose
      'A message must be spell checked!' => 'Lorthographe dun message doit tre vrifi!',
      'Compose answer for ticket' => 'Rdiger une rponse pour le ticket',
      'Attach' => 'Attach',
      'Pending Date' => 'En attendant la date',
      'for pending* states' => 'pour tous les tats d\'attente',

      # Template: AgentTicketCustomer
      'Change customer of ticket' => 'Changer le client du ticket',
      'Set customer user and customer id of a ticket' => 'Assigner un utilisateur client et un identifiant client pour le ticket.',
      'Customer User' => 'Client Utilisateur',
      'Search Customer' => 'Recherche de client',
      'Customer Data' => 'Donnes client',
      'Customer history' => 'Historique du client',
      'All customer tickets.' => 'Tout les tickets du client',

      # Template: AgentTicketCustomerMessage
      'Follow up' => 'Note',

      # Template: AgentTicketEmail
      'Compose Email' => 'crire un courriel',
      'new ticket' => 'nouveau ticket',
      'Clear To' => 'Effacer la zone de saisie "De:"',
      'All Agents' => 'Tous les techniciens',

      # Template: AgentTicketForward
      'Article type' => 'Type d\'article',

      # Template: AgentTicketFreeText
      'Change free text of ticket' => 'Changer le texte libre du ticket',

      # Template: AgentTicketHistory
      'History of' => 'Historique de',

      # Template: AgentTicketLocked
      'Ticket locked!' => 'Ticket verrouill !',
      'Ticket unlock!' => 'Rendre le ticket !',

      # Template: AgentTicketMailbox
      'Mailbox' => 'Bo&icirc;te aux lettres',
      'Tickets' => '',
      'All messages' => 'Tous les messages',
      'New messages' => 'Nouveaux messages',
      'Pending messages' => 'Message en attente',
      'Reminder messages' => 'Message de rappel',
      'Reminder' => 'Rappel',
      'Sort by' => 'Trier par',
      'Order' => 'Ordre',
      'up' => 'vers le haut',
      'down' => 'vers le bas',
      '"}\'; return true;" onmouseout="window.status=\'\';" class="menuitem" title="$Text{"' => '',
      '"}"}">$Quote{"$Text{""}' => '',

      # Template: AgentTicketMerge
      'You need to use a ticket number!' => 'Vous devez utiliser un numro de ticket!',
      'Ticket Merge' => 'Fusion de Ticket',
      'Merge to' => 'Fusionner avec',
      'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Votre ticket numro "<OTRS_TICKET>" a t fusionn avec le ticket numro "<OTRS_MERGE_TO_TICKET>".',

      # Template: AgentTicketMove
      'Queue ID' => 'Identifiant de la File',
      'Move Ticket' => 'Changer la file du ticket',
      'Previous Owner' => 'Propritaire Prcdent',

      # Template: AgentTicketNote
      'Add note to ticket' => 'Ajouter une note au ticket',
      'Inform Agent' => 'Informer l\'agent',
      'Optional' => 'Optionnel',
      'Inform involved Agents' => 'Informer les agents impliqus',

      # Template: AgentTicketOwner
      'Change owner of ticket' => 'Changer le propritaire du ticket',
      'Message for new Owner' => 'Message pour le nouveau propritaire',

      # Template: AgentTicketPending
      'Set Pending' => 'Dfinir l\'attente',
      'Pending type' => 'Type d\'attente',
      'Pending date' => 'Dlais d\'attente',

      # Template: AgentTicketPhone
      'Phone call' => 'Appel tlphonique',

      # Template: AgentTicketPhoneNew
      'Clear From' => 'Vider le formulaire',

      # Template: AgentTicketPlain
      'Plain' => 'Tel quel',
      'TicketID' => 'Identifiant du Ticket',
      'ArticleID' => 'Identifiant de l\'Article',

      # Template: AgentTicketPrint
      'Ticket-Info' => 'Information du Ticket',
      'Accounted time' => 'Temp pass',
      'Escalation in' => 'Remonte dans',
      'Linked-Object' => 'Objet li',
      'Parent-Object' => 'Objet Parent',
      'Child-Object' => 'Objet Enfant',
      'by' => 'par',

      # Template: AgentTicketPriority
      'Change priority of ticket' => 'Modification de la priorit du ticket',

      # Template: AgentTicketQueue
      'Tickets shown' => 'Tickets affichs',
      'Page' => '',
      'Tickets available' => 'Tickets disponibles',
      'All tickets' => 'tous les tickets',
      'Queues' => 'Files',
      'Ticket escalation!' => 'Remonte du ticket !',

      # Template: AgentTicketQueueTicketView
      'Your own Ticket' => 'Votre propre ticket',
      'Compose Follow up' => 'Fermer le suivi',
      'Compose Answer' => 'Rdiger une rponse',
      'Contact customer' => 'Contacter le client',
      'Change queue' => 'Changer de file',

      # Template: AgentTicketQueueTicketViewLite

      # Template: AgentTicketSearch
      'Ticket Search' => 'Recherche de ticket',
      'Profile' => 'Profil',
      'Search-Template' => 'Profil de recherche',
      'Created in Queue' => 'Cr dans la file',
      'Result Form' => 'Format du rsultat',
      'Save Search-Profile as Template?' => 'Sauver le profil de recherche ?',
      'Yes, save it with name' => 'Oui, le sauver avec le nom',
      'Customer history search' => 'Recherche dans l\'historique client',
      'Customer history search (e. g. "ID342425").' => 'Recherche dans l\'historique client (ex: "ID342425")',
      'No * possible!' => 'Pas de * possible !',

      # Template: AgentTicketSearchResult
      'Search Result' => 'Rsultat de la recherche',
      'Change search options' => 'Changer les options de recherche',

      # Template: AgentTicketSearchResultPrint
      '"}' => '',

      # Template: AgentTicketSearchResultShort
      'sort upward' => 'Tri croissant',
      'U' => 'Z-A',
      'sort downward' => 'Tri dcroissant',
      'D' => 'A-Z',

      # Template: AgentTicketStatusView
      'Ticket Status View' => 'Vue de l\'tat du ticket',
      'Open Tickets' => 'Tickets ouverts',

      # Template: AgentTicketZoom
      'Split' => 'Scinder',

      # Template: AgentTicketZoomStatus
      'Locked' => 'Vrrouill',

      # Template: AgentWindowTabStart

      # Template: AgentWindowTabStop

      # Template: Copyright

      # Template: css

      # Template: customer-css

      # Template: CustomerAccept

      # Template: CustomerError
      'Traceback' => 'Trace du retour d\'erreur',

      # Template: CustomerFAQArticleHistory
      'FAQ History' => 'Historique de la FAQ',
      'Print' => 'Imprimer',

      # Template: CustomerFAQArticlePrint
      'Keywords' => 'Mots cls',
      'Last update' => 'Dernire mise  jour',
      'Symptom' => 'Symptme',
      'Problem' => 'Problme',
      'Solution' => '',

      # Template: CustomerFAQArticleSystemHistory
      'FAQ System History' => 'Historique systme de la FAQ',

      # Template: CustomerFAQArticleView
      'Modified' => 'Modifi',

      # Template: CustomerFAQOverview
      'FAQ Overview' => 'Vue d\'ensemble de la FAQ',

      # Template: CustomerFAQSearch
      'FAQ Search' => 'Chercher dans la FAQ',
      'Fulltext' => 'Texte Complet',
      'Keyword' => 'Mot cl',

      # Template: CustomerFAQSearchResult
      'FAQ Search Result' => 'Rsultat de la recherche dans la FAQ',

      # Template: CustomerFooter
      'Powered by' => 'Fonction assure par',

      # Template: CustomerHeader

      # Template: CustomerLogin
      'Login' => 'S\'authentifier',
      'Lost your password?' => 'Mot de passe perdu ?',
      'Request new password' => 'Demande de nouveau mot de passe',
      'Create Account' => 'Crer un compte',

      # Template: CustomerNavigationBar
      'Welcome %s' => 'Bienvenue %s',

      # Template: CustomerPreferencesForm

      # Template: CustomerStatusView
      'of' => 'de',

      # Template: CustomerTicketMessage

      # Template: CustomerTicketMessageNew

      # Template: CustomerTicketSearch

      # Template: CustomerTicketSearchResultCSV

      # Template: CustomerTicketSearchResultPrint

      # Template: CustomerTicketSearchResultShort

      # Template: CustomerTicketZoom

      # Template: CustomerWarning

      # Template: Error
      'Click here to report a bug!' => 'Cliquer ici pour signaler une anomalie !',

      # Template: FAQ
      'Comment (internal)' => 'Commentaire interne',
      'A article should have a title!' => 'Un article doit avoir un titre',
      'New FAQ Article' => '(FAQ) Nouvel article',
      'Do you really want to delete this Object?' => 'Voulez vous vraiment effacer cet objet ?',
      'System History' => 'Historique du systme',

      # Template: FAQCategoryForm
      'Name is required!' => 'Un nom est requis!',
      'FAQ Category' => 'Catgorie dans la FAQ',

      # Template: FAQLanguageForm
      'FAQ Language' => 'Langue dans la FAQ',

      # Template: Footer
      'Top of Page' => 'Haut de page',

      # Template: FooterSmall

      # Template: Header
      'Home' => 'Accueil',

      # Template: HeaderSmall

      # Template: InstallerBody
      'Web-Installer' => 'Installeur Web',
      'Create Database' => 'Crer la base de donnes',
      'Drop Database' => 'Effacer la base de donnes',
      'System Settings' => 'Paramtres Systme',
      'Finished' => 'Fini',

      # Template: InstallerFinish
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Pour pouvoir utiliser OTRS, vous devez entrer les commandes suivantes dans votre terminal en tant que root.',
      'Restart your webserver' => 'Redmarrer votre serveur web',
      'After doing so your OTRS is up and running.' => 'Aprs avoir fait ceci votre OTRS est en service',
      'Start page' => 'Page de dmarrage',
      'Admin-User' => 'Administrateur',
      'Have a lot of fun!' => 'Amusez vous bien !',
      'Your OTRS Team' => 'Votre quipe OTRS',

      # Template: InstallerLicense
      'License' => 'Licence',
      'accept license' => 'Accepter la licence',
      'don\'t accept license' => 'Ne pas accepter la licence',

      # Template: InstallerStart
      'DB Admin User' => 'nom de connexion de l\'administrateur base de donne',
      'DB Admin Password' => 'Mot de passe administrateur base de donnes',
      'your MySQL DB should have a root password! Default is empty!' => 'Votre base MySQL doit avoir un mot de passe root ! Par dfaut cela est vide !',
      'DB Host' => 'Nom d\'hte de la base',
      'DB Type' => 'Type de SGBD',
      'OTRS DB Name' => 'Nom de la base OTRS',
      'OTRS DB User' => 'Utilisateur de la base OTRS',
      'OTRS DB Password' => 'Mot de passe de la base OTRS',
      'default \'hot\'' => 'hte par dfaut',
      'OTRS DB connect host' => 'Hte de la base OTRS',
      'Create new database' => 'Crer une nouvelle base de donnes',
      'Delete old database' => 'Effacer l\'ancienne base de donnes',
      'next step' => 'tape suivante',

      # Template: InstallerSystem
      'SystemID' => 'ID Systme',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(L\'identit du systme. Chaque numro de ticket et chaque id de session http commence avec ce nombre)',
      'System FQDN' => 'Nom de Domaine complet du systme',
      '(Full qualified domain name of your system)' => '(Nom de domaine complet de votre machine)',
      'AdminEmail' => 'Courriel de l\'administrateur.',
      '(Email of the system admin)' => '(Adresse de l\'administrateur systme)',
      'Organization' => 'Socit',
      'LogModule' => 'Module de log',
      '(Used log backend)' => '(Backend de log utilis)',
      'Logfile' => 'fichier de log',
      '(Logfile just needed for File-LogModule!)' => '(fichier de log ncessaire pour le Module File-Log !)',
      'CheckMXRecord' => 'Vrifier les enregistrements MX',
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Verifie les enregistrements MX des adresses lectroniques utilises lors de la rdaction d\'une rponse. N\'utilisez pas la "Vrification des enregistrements MX" si votre serveur OTRS est derrire une ligne modem $!',
      'Ticket Hook' => '',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identifiiant des tickets. Certaines personnes veulent le configurer avec par ex: \'Ticket#\', \'Appel#\' ou \'MonTicket#\')',
      'Ticket Number Generator' => 'Gnrateur de numro pour les tickets',
      '(Used ticket number format)' => '(Format numrique utilis pour les tickets)',
      'Webfrontend' => 'Frontal web',
      'Default Charset' => 'Charset par dfaut',
      'Use utf-8 it your database supports it!' => 'Utilisez UTF-8 si votre base de donne le supporte !',
      'Default Language' => 'Langage par dfaut ',
      '(Used default language)' => '(Langage par dfaut utilis)',

      # Template: Login

      # Template: Motd

      # Template: NoPermission
      'No Permission' => 'Pas d\'autorisation',

      # Template: Notify

      # Template: PrintFooter
      'URL' => '',

      # Template: PrintHeader
      'printed by' => 'Imprim par :',

      # Template: Redirect

      # Template: SystemStats
      'Format' => '',

      # Template: Test
      'OTRS Test Page' => 'Page de test d\'OTRS',
      'Counter' => 'Compteur',
      'Mark as Spam!' => '',
      'Your queue selection of your favorite queues. You also get notified about this queues via email if enabled.' => '',
      'New password' => '',
      'New password again' => '',
      'Change Password' => '',
      'My Queues' => '',

      # Template: Warning
    };
    # $$STOP$$
}
# --
1;
