# --
# Kernel/Language/sv.pm - Swedish language translation
# Copyright (C) 2004 Mats Eric Olausson <mats@synergy.se>
# --
# $Id: sv.pm,v 1.32 2007/04/02 15:34:19 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --

package Kernel::Language::sv;

use strict;

use vars qw($VERSION);
$VERSION = q$Revision: 1.32 $;
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

sub Data {
    my $Self = shift;
    my %Param = @_;

    # $$START$$
    # Last translation file sync: Mon Apr  2 17:25:51 2007

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D/%M %Y %T';
    $Self->{DateFormatLong} = '%A %D. %B %Y %T';
    $Self->{DateFormatShort} = '%D.%M.%Y';
    $Self->{DateInputFormat} = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Ja',
        'No' => 'Nej',
        'yes' => 'ja',
        'no' => 'inga',
        'Off' => 'Av',
        'off' => 'av',
        'On' => 'P',
        'on' => 'p',
        'top' => 'topp',
        'end' => 'slut',
        'Done' => 'Klar',
        'Cancel' => 'Avbryt',
        'Reset' => 'Nollstll',
        'last' => 'sista',
        'before' => 'fre',
        'day' => 'dag',
        'days' => 'dagar',
        'day(s)' => 'dag(ar)',
        'hour' => 'timme',
        'hours' => 'timmar',
        'hour(s)' => '',
        'minute' => 'minut',
        'minutes' => 'minuter',
        'minute(s)' => '',
        'month' => '',
        'months' => '',
        'month(s)' => 'mnad(er)',
        'week' => '',
        'week(s)' => 'vecka(or)',
        'year' => '',
        'years' => '',
        'year(s)' => 'r',
        'second(s)' => '',
        'seconds' => '',
        'second' => '',
        'wrote' => 'skrev',
        'Message' => 'Meddelande',
        'Error' => 'Fel',
        'Bug Report' => 'Rapportera fel',
        'Attention' => 'OBS',
        'Warning' => 'Varning',
        'Module' => 'Modul',
        'Modulefile' => 'Modulfil',
        'Subfunction' => 'Underfunktion',
        'Line' => 'Rad',
        'Example' => 'Exempel',
        'Examples' => 'Exempel',
        'valid' => 'giltig',
        'invalid' => 'ogiltig',
        'invalid-temporarily' => '',
        ' 2 minutes' => ' 2 minuter',
        ' 5 minutes' => ' 5 minuter',
        ' 7 minutes' => ' 7 minuter',
        '10 minutes' => '10 minuter',
        '15 minutes' => '15 minuter',
        'Mr.' => '',
        'Mrs.' => '',
        'Next' => '',
        'Back' => 'Tillbaka',
        'Next...' => '',
        '...Back' => '',
        '-none-' => '',
        'none' => 'inga',
        'none!' => 'inga!',
        'none - answered' => 'inga - besvarat',
        'please do not edit!' => 'Var vnlig och ndra inte detta!',
        'AddLink' => 'Lgg till lnk',
        'Link' => 'Lnk',
        'Linked' => '',
        'Link (Normal)' => '',
        'Link (Parent)' => '',
        'Link (Child)' => '',
        'Normal' => '',
        'Parent' => '',
        'Child' => '',
        'Hit' => 'Trff',
        'Hits' => 'Trffar',
        'Text' => '',
        'Lite' => 'Enkel',
        'User' => 'Anvndare',
        'Username' => 'Anvndarnamn',
        'Language' => 'Sprk',
        'Languages' => 'Sprk',
        'Password' => 'Lsenord',
        'Salutation' => 'Hlsning',
        'Signature' => 'Signatur',
        'Customer' => 'Kund',
        'CustomerID' => 'Organisations-ID',
        'CustomerIDs' => '',
        'customer' => 'kund',
        'agent' => '',
        'system' => 'System',
        'Customer Info' => 'Kundinfo',
        'Customer Company' => '',
        'go!' => 'Starta!',
        'go' => 'Starta',
        'All' => 'Alla',
        'all' => 'alla',
        'Sorry' => 'Beklagar',
        'update!' => 'Uppdatera!',
        'update' => 'uppdatera',
        'Update' => 'Uppdatera',
        'submit!' => 'Skicka!',
        'submit' => 'Skicka',
        'Submit' => '',
        'change!' => 'ndra!',
        'Change' => 'ndra',
        'change' => 'ndra',
        'click here' => 'klicka hr',
        'Comment' => 'Kommentar',
        'Valid' => 'Giltigt',
        'Invalid Option!' => '',
        'Invalid time!' => '',
        'Invalid date!' => '',
        'Name' => 'Namn',
        'Group' => 'Grupp',
        'Description' => 'Beskrivning',
        'description' => 'beskrivning',
        'Theme' => 'Tema',
        'Created' => 'Skapat',
        'Created by' => '',
        'Changed' => '',
        'Changed by' => '',
        'Search' => 'Sk',
        'and' => 'og',
        'between' => '',
        'Fulltext Search' => '',
        'Data' => '',
        'Options' => 'Tillval',
        'Title' => '',
        'Item' => '',
        'Delete' => 'Radera',
        'Edit' => 'Redigera',
        'View' => 'Bild',
        'Number' => '',
        'System' => '',
        'Contact' => 'Kontakt',
        'Contacts' => '',
        'Export' => '',
        'Up' => '',
        'Down' => '',
        'Add' => 'Lgg till',
        'Category' => 'Kategori',
        'Viewer' => '',
        'New message' => 'Nytt meddelande',
        'New message!' => 'Nytt meddelande!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Vnligen besvara denna/dessa renden fr att komma tillbaka till den normala k-visningsbilden!',
        'You got new message!' => 'Du har ftt ett nytt meddelande!',
        'You have %s new message(s)!' => 'Du har %s nya meddelanden!',
        'You have %s reminder ticket(s)!' => 'Du har %s pminnelse-rende(n)!',
        'The recommended charset for your language is %s!' => 'Den rekommenderade teckenuppsttningen fr ditt sprk r %s!',
        'Passwords doesn\'t match! Please try it again!' => '',
        'Password is already in use! Please use an other password!' => '',
        'Password is already used! Please use an other password!' => '',
        'You need to activate %s first to use it!' => '',
        'No suggestions' => 'Inga frslag',
        'Word' => 'Ord',
        'Ignore' => 'Ignorera',
        'replace with' => 'Erstt med',
        'There is no account with that login name.' => 'Det finns inget konto med detta namn.',
        'Login failed! Your username or password was entered incorrectly.' => 'Inloggningen misslyckades! Angivet anvndarnamn och/eller lsenord r inte korrekt.',
        'Please contact your admin' => 'Vnligen kontakta administratren',
        'Logout successful. Thank you for using OTRS!' => 'Utloggningen lyckades.  Tack fr att du anvnde OTRS!',
        'Invalid SessionID!' => 'Ogiltigt SessionID!',
        'Feature not active!' => 'Funktion inte aktiverad!',
        'Login is needed!' => '',
        'Password is needed!' => '',
        'License' => 'Licens',
        'Take this Customer' => '',
        'Take this User' => 'Vlj denna anvndare',
        'possible' => 'mjlig',
        'reject' => 'Avvisas',
        'reverse' => '',
        'Facility' => 'Innrttning',
        'Timeover' => 'Tidsvertrdelse',
        'Pending till' => 'Vntande tills',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Det r inte rekommenderat att arbeta som userid 1 (systemkonto)! Skapa nya anvndare!',
        'Dispatching by email To: field.' => 'Skickar ivg enligt epostmeddelandets Till:-flt.',
        'Dispatching by selected Queue.' => '',
        'No entry found!' => 'Ingen inmatning funnen!',
        'Session has timed out. Please log in again.' => 'Sessionstiden har lpt ut.  Vnligen logga p igen.',
        'No Permission!' => '',
        'To: (%s) replaced with database email!' => 'Till: (%s) ersatt med epost frn databas!',
        'Cc: (%s) added database email!' => '',
        '(Click here to add)' => '(Klicka hr fr att lgga till)',
        'Preview' => 'Forhandsvisning',
        'Package not correctly deployed! You should reinstall the Package again!' => '',
        'Added User "%s"' => '',
        'Contract' => '',
        'Online Customer: %s' => '',
        'Online Agent: %s' => '',
        'Calendar' => '',
        'File' => '',
        'Filename' => 'Filnamn',
        'Type' => 'Typ',
        'Size' => '',
        'Upload' => '',
        'Directory' => '',
        'Signed' => '',
        'Sign' => '',
        'Crypted' => '',
        'Crypt' => '',
        'Office' => '',
        'Phone' => '',
        'Fax' => '',
        'Mobile' => '',
        'Zip' => '',
        'City' => '',
        'Country' => '',
        'installed' => '',
        'uninstalled' => '',
        'Security Note: You should activate %s because application is already running!' => '',
        'Unable to parse Online Repository index document!' => '',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => '',
        'No Packages or no new Packages in selected Online Repository!' => '',
        'printed at' => '',

        # Template: AAAMonth
        'Jan' => 'jan',
        'Feb' => 'feb',
        'Mar' => 'mar',
        'Apr' => 'apr',
        'May' => 'maj',
        'Jun' => 'jun',
        'Jul' => 'jul',
        'Aug' => 'aug',
        'Sep' => 'sep',
        'Oct' => 'okt',
        'Nov' => 'nov',
        'Dec' => 'dec',
        'January' => '',
        'February' => '',
        'March' => '',
        'April' => '',
        'June' => '',
        'July' => '',
        'August' => '',
        'September' => '',
        'October' => '',
        'November' => '',
        'December' => '',

        # Template: AAANavBar
        'Admin-Area' => 'Admin-omrde',
        'Agent-Area' => 'Agent-omrde',
        'Ticket-Area' => '',
        'Logout' => 'Logga ut',
        'Agent Preferences' => '',
        'Preferences' => 'Instllningar',
        'Agent Mailbox' => '',
        'Stats' => 'Statistik',
        'Stats-Area' => '',
        'Admin' => '',
        'Customer Users' => '',
        'Customer Users <-> Groups' => '',
        'Users <-> Groups' => '',
        'Roles' => '',
        'Roles <-> Users' => '',
        'Roles <-> Groups' => '',
        'Salutations' => '',
        'Signatures' => '',
        'Email Addresses' => '',
        'Notifications' => '',
        'Category Tree' => '',
        'Admin Notification' => '',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Instllningar lagrade!',
        'Mail Management' => 'Eposthantering',
        'Frontend' => 'Grnssnitt',
        'Other Options' => 'Andra tillval',
        'Change Password' => '',
        'New password' => '',
        'New password again' => '',
        'Select your QueueView refresh time.' => 'Vlj automatisk uppdateringsintervall fr K-bild.',
        'Select your frontend language.' => 'Vlj sprk.',
        'Select your frontend Charset.' => 'Vlj teckenuppsttning.',
        'Select your frontend Theme.' => 'Vlj stil-tema.',
        'Select your frontend QueueView.' => 'Vlj K-bild.',
        'Spelling Dictionary' => 'Stavningslexikon',
        'Select your default spelling dictionary.' => 'Vlj standard ordbok for stavningskontroll.',
        'Max. shown Tickets a page in Overview.' => 'Max. visade renden per sida i versikt.',
        'Can\'t update password, passwords doesn\'t match! Please try it again!' => '',
        'Can\'t update password, invalid characters!' => '',
        'Can\'t update password, need min. 8 characters!' => '',
        'Can\'t update password, need 2 lower and 2 upper characters!' => '',
        'Can\'t update password, need min. 1 digit!' => '',
        'Can\'t update password, need min. 2 characters!' => '',

        # Template: AAAStats
        'Stat' => '',
        'Please fill out the required fields!' => '',
        'Please select a file!' => '',
        'Please select an object!' => '',
        'Please select a graph size!' => '',
        'Please select one element for the X-axis!' => '',
        'You have to select two or more attributes from the select field!' => '',
        'Please select only one element or turn of the button \'Fixed\' where the select field is marked!' => '',
        'If you use a checkbox you have to select some attributes of the select field!' => '',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => '',
        'The selected end time is before the start time!' => '',
        'You have to select one or more attributes from the select field!' => '',
        'The selected Date isn\'t valid!' => '',
        'Please select only one or two elements via the checkbox!' => '',
        'If you use a time scale element you can only select one element!' => '',
        'You have an error in your time selection!' => '',
        'Your reporting time interval is to small, please use a larger time scale!' => '',
        'The selected start time is before the allowed start time!' => '',
        'The selected end time is after the allowed end time!' => '',
        'The selected time period is larger than the allowed time period!' => '',
        'Common Specification' => '',
        'Xaxis' => '',
        'Value Series' => '',
        'Restrictions' => '',
        'graph-lines' => '',
        'graph-bars' => '',
        'graph-hbars' => '',
        'graph-points' => '',
        'graph-lines-points' => '',
        'graph-area' => '',
        'graph-pie' => '',
        'extended' => '',
        'Agent/Owner' => '',
        'Created by Agent/Owner' => '',
        'Created Priority' => '',
        'Created State' => '',
        'Create Time' => '',
        'CustomerUserLogin' => '',
        'Close Time' => '',

        # Template: AAATicket
        'Lock' => 'Ls',
        'Unlock' => 'Ls upp',
        'History' => 'Historik',
        'Zoom' => '',
        'Age' => 'lder',
        'Bounce' => 'Studsa',
        'Forward' => 'Vidarebefordra',
        'From' => 'Frn',
        'To' => 'Till',
        'Cc' => '',
        'Bcc' => '',
        'Subject' => 'mne',
        'Move' => 'Flytta',
        'Queue' => 'K',
        'Priority' => 'Prioritet',
        'State' => 'Status',
        'Compose' => 'Frfatta',
        'Pending' => 'Vntande',
        'Owner' => 'gare',
        'Owner Update' => '',
        'Responsible' => '',
        'Responsible Update' => '',
        'Sender' => 'Avsndare',
        'Article' => 'Artikel',
        'Ticket' => 'rende',
        'Createtime' => 'Tidpunkt fr skapande',
        'plain' => 'r',
        'Email' => '',
        'email' => '',
        'Close' => 'Stng',
        'Action' => 'tgrd',
        'Attachment' => 'Bifogat dokument',
        'Attachments' => 'Bifogade dokument',
        'This message was written in a character set other than your own.' => 'Detta meddelande r skrivet med en annan teckenuppsttning n den du anvnder.',
        'If it is not displayed correctly,' => 'Ifall det inte visas korrekt,',
        'This is a' => 'Detta r en',
        'to open it in a new window.' => 'fr att ppna i ett nytt fnster',
        'This is a HTML email. Click here to show it.' => 'Detta r ett HTML-email. Klicka hr fr att visa.',
        'Free Fields' => '',
        'Merge' => '',
        'merged' => '',
        'closed successful' => 'Lst och stngt',
        'closed unsuccessful' => 'Olst men stngt',
        'new' => 'ny',
        'open' => 'ppen',
        'closed' => '',
        'removed' => 'borttagen',
        'pending reminder' => 'vntar p pminnelse',
        'pending auto' => '',
        'pending auto close+' => 'vntar p att stngas (lst)',
        'pending auto close-' => 'vntar p att stngas (olst)',
        'email-external' => 'email externt',
        'email-internal' => 'email internt',
        'note-external' => 'notis externt',
        'note-internal' => 'notis internt',
        'note-report' => 'notis till rapport',
        'phone' => 'telefon',
        'sms' => '',
        'webrequest' => 'web-anmodan',
        'lock' => 'lst',
        'unlock' => 'upplst',
        'very low' => 'planeras',
        'low' => 'lg',
        'normal' => '',
        'high' => 'hg',
        'very high' => 'kritisk',
        '1 very low' => '1 Planeras',
        '2 low' => '2 lg',
        '3 normal' => '3 medium',
        '4 high' => '4 hg',
        '5 very high' => '5 kritisk',
        'Ticket "%s" created!' => 'rende "%s" skapad!',
        'Ticket Number' => '',
        'Ticket Object' => '',
        'No such Ticket Number "%s"! Can\'t link it!' => '',
        'Don\'t show closed Tickets' => 'Visa inte lsta renden',
        'Show closed Tickets' => 'Visa lsta renden',
        'New Article' => 'Ny artikel',
        'Email-Ticket' => '',
        'Create new Email Ticket' => '',
        'Phone-Ticket' => '',
        'Search Tickets' => '',
        'Edit Customer Users' => '',
        'Bulk-Action' => '',
        'Bulk Actions on Tickets' => '',
        'Send Email and create a new Ticket' => '',
        'Create new Email Ticket and send this out (Outbound)' => '',
        'Create new Phone Ticket (Inbound)' => '',
        'Overview of all open Tickets' => '',
        'Locked Tickets' => '',
        'Watched Tickets' => '',
        'Watched' => '',
        'Subscribe' => '',
        'Unsubscribe' => '',
        'Lock it to work on it!' => '',
        'Unlock to give it back to the queue!' => '',
        'Shows the ticket history!' => '',
        'Print this ticket!' => '',
        'Change the ticket priority!' => '',
        'Change the ticket free fields!' => '',
        'Link this ticket to an other objects!' => '',
        'Change the ticket owner!' => '',
        'Change the ticket customer!' => '',
        'Add a note to this ticket!' => '',
        'Merge this ticket!' => '',
        'Set this ticket to pending!' => '',
        'Close this ticket!' => '',
        'Look into a ticket!' => '',
        'Delete this ticket!' => '',
        'Mark as Spam!' => '',
        'My Queues' => '',
        'Shown Tickets' => '',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => '',
        'New ticket notification' => 'Meddelande om nyskapat rende',
        'Send me a notification if there is a new ticket in "My Queues".' => '',
        'Follow up notification' => 'Meddelande om uppfljning',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Skicka mig ett meddelande om kundkorrespondens fr renden som jag r gare till.',
        'Ticket lock timeout notification' => 'Meddela mig d tiden gtt ut fr ett rende-ls',
        'Send me a notification if a ticket is unlocked by the system.' => 'Skicka mig ett meddelande ifall systemet tar bort lset p ett rende.',
        'Move notification' => 'Meddelande om ndring av k',
        'Send me a notification if a ticket is moved into one of "My Queues".' => '',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => '',
        'Custom Queue' => 'Utvald k',
        'QueueView refresh time' => 'Automatisk uppdateringsintervall f K-bild',
        'Screen after new ticket' => 'Skrm efter inmatning av nytt rende',
        'Select your screen after creating a new ticket.' => 'Vlj skrmbild som visas efter registrering av ny hnvisning/rende.',
        'Closed Tickets' => 'Lsta renden',
        'Show closed tickets.' => 'Visa lsta renden.',
        'Max. shown Tickets a page in QueueView.' => 'Max. visade renden per sida i K-bild.',
        'CompanyTickets' => '',
        'MyTickets' => '',
        'New Ticket' => '',
        'Create new Ticket' => '',
        'Customer called' => '',
        'phone call' => '',
        'Responses' => 'Svar',
        'Responses <-> Queue' => '',
        'Auto Responses' => '',
        'Auto Responses <-> Queue' => '',
        'Attachments <-> Responses' => '',
        'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
        'History::TypeUpdate' => '',
        'History::ServiceUpdate' => '',
        'History::SLAUpdate' => '',
        'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp for [%s]. %s',
        'History::SendAutoReject' => 'AutoReject sent to "%s".',
        'History::SendAutoReply' => 'AutoReply sent to "%s".',
        'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
        'History::Forward' => 'Forwarded to "%s".',
        'History::Bounce' => 'Bounced to "%s".',
        'History::SendAnswer' => 'Email sent to "%s".',
        'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
        'History::SendCustomerNotification' => 'Notification sent to "%s".',
        'History::EmailAgent' => 'Email sent to customer.',
        'History::EmailCustomer' => 'Added email. %s',
        'History::PhoneCallAgent' => 'Agent called customer.',
        'History::PhoneCallCustomer' => 'Customer called us.',
        'History::AddNote' => 'Added note (%s)',
        'History::Lock' => 'Locked ticket.',
        'History::Unlock' => 'Unlocked ticket.',
        'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Updated: %s',
        'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
        'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Updated: %s',
        'History::StateUpdate' => 'Old: "%s" New: "%s"',
        'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Customer request via web.',
        'History::TicketLinkAdd' => 'Added link to ticket "%s".',
        'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',

        # Template: AAAWeekDay
        'Sun' => 'sn',
        'Mon' => 'mn',
        'Tue' => 'tis',
        'Wed' => 'ons',
        'Thu' => 'tor',
        'Fri' => 'fre',
        'Sat' => 'lr',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Hantering av bifogade dokument',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Autosvar-hantering',
        'Response' => 'Svar',
        'Auto Response From' => 'autosvar-avsndare',
        'Note' => 'Notis',
        'Useable options' => 'Anvndbara tillgg',
        'To get the first 20 character of the subject.' => '',
        'To get the first 5 lines of the email.' => '',
        'To get the realname of the sender (if given).' => '',
        'To get the article attribut (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => '',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => '',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => '',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => '',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => '',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => '',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => '',
        'Add Customer Company' => '',
        'Add a new Customer Company.' => '',
        'List' => '',
        'This values are required.' => '',
        'This values are read only.' => '',

        # Template: AdminCustomerUserForm
        'Customer User Management' => 'Kundanvndare',
        'Search for' => '',
        'Add User' => '',
        'Source' => 'Klla',
        'Create' => '',
        'Customer user will be needed to have a customer history and to login via customer panel.' => '',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => '',
        'Change %s settings' => 'ndra %s-instllningar',
        'Select the user:group permissions.' => 'Vlj anvndar:grupp-rettigheter.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Om ingenting r valt finns inga rttigheter i denna grupp (renden i denna grupp kommer inte att finnas tillgngliga fr anvndaren).',
        'Permission' => 'Rttighet',
        'ro' => '',
        'Read only access to the ticket in this group/queue.' => 'Endast lsrttighet till renden i denna grupp/k.',
        'rw' => '',
        'Full read and write access to the tickets in this group/queue.' => 'Fulla ls- och skrivrttigheter till renden i denna grupp/k.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminEmail
        'Message sent to' => 'Meddelande skicakt till',
        'Recipents' => 'Mottagare',
        'Body' => 'Meddelandetext',
        'Send' => '',

        # Template: AdminGenericAgent
        'GenericAgent' => '',
        'Job-List' => '',
        'Last run' => '',
        'Run Now!' => '',
        'x' => '',
        'Save Job as?' => '',
        'Is Job Valid?' => '',
        'Is Job Valid' => '',
        'Schedule' => '',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Fritextsk i artiklar (t.ex. "Mar*in" eller "Baue*")',
        '(e. g. 10*5155 or 105658*)' => 't.ex. 10*5144 eller 105658*',
        '(e. g. 234321)' => 't.ex. 234321',
        'Customer User Login' => 'kundanvndare loginnamn',
        '(e. g. U5150)' => 't.ex. U5150',
        'Agent' => '',
        'Ticket Lock' => '',
        'TicketFreeFields' => '',
        'Create Times' => '',
        'No create time settings.' => '',
        'Ticket created' => 'rende skapat',
        'Ticket created between' => 'rendet skapat mellan',
        'Pending Times' => '',
        'No pending time settings.' => '',
        'Ticket pending time reached' => '',
        'Ticket pending time reached between' => '',
        'New Priority' => '',
        'New Queue' => 'Ny K',
        'New State' => '',
        'New Agent' => '',
        'New Owner' => 'Ny gare',
        'New Customer' => '',
        'New Ticket Lock' => '',
        'CustomerUser' => 'Kundanvndare',
        'New TicketFreeFields' => '',
        'Add Note' => 'Lgg till anteckning',
        'CMD' => '',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => '',
        'Delete tickets' => '',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => '',
        'Send Notification' => '',
        'Param 1' => '',
        'Param 2' => '',
        'Param 3' => '',
        'Param 4' => '',
        'Param 5' => '',
        'Param 6' => '',
        'Send no notifications' => '',
        'Yes means, send no agent and customer notifications on changes.' => '',
        'No means, send agent and customer notifications on changes.' => '',
        'Save' => '',
        '%s Tickets affected! Do you really want to use this job?' => '',
        '"}' => '',

        # Template: AdminGroupForm
        'Group Management' => 'grupphantering',
        'Add Group' => '',
        'Add a new Group.' => '',
        'The admin group is to get in the admin area and the stats group to get stats area.' => '\'admin\'-gruppen ger tillgng till Admin-arean, \'stats\'-gruppen till Statistik-arean.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Skapa nya grupper fr att kunna handtera olika rttigheter fr skilda grupper av agenter (t.ex. inkpsavdelning, supportavdelning, frsljningsavdelning, ...).',
        'It\'s useful for ASP solutions.' => 'Nyttigt fr ASP-lsningar.',

        # Template: AdminLog
        'System Log' => 'Systemlogg',
        'Time' => '',

        # Template: AdminMailAccount
        'Mail Account Management' => '',
        'Host' => '',
        'Account Type' => '',
        'POP3' => '',
        'POP3S' => '',
        'IMAP' => '',
        'IMAPS' => '',
        'Mailbox' => '',
        'Port' => '',
        'Trusted' => 'Betrodd',
        'Dispatching' => 'Frdelning',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Inkommande email frn POP3-konton sorteras till vald k!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',

        # Template: AdminNavigationBar
        'Users' => '',
        'Groups' => 'grupper',
        'Misc' => 'Div',

        # Template: AdminNotificationForm
        'Notification Management' => 'Meddelandehantering',
        'Notification' => '',
        'Notifications are sent to an agent or a customer.' => 'Meddelanden skickats till agenter eller kunder.',

        # Template: AdminPackageManager
        'Package Manager' => '',
        'Uninstall' => '',
        'Version' => '',
        'Do you really want to uninstall this package?' => '',
        'Reinstall' => '',
        'Do you really want to reinstall this package (all manual changes get lost)?' => '',
        'Cancle' => '',
        'Continue' => '',
        'Install' => '',
        'Package' => '',
        'Online Repository' => '',
        'Vendor' => '',
        'Upgrade' => '',
        'Local Repository' => '',
        'Status' => '',
        'Overview' => 'versikt',
        'Download' => '',
        'Rebuild' => '',
        'ChangeLog' => '',
        'Date' => '',
        'Filelist' => '',
        'Download file from package!' => '',
        'Required' => '',
        'PrimaryKey' => '',
        'AutoIncrement' => '',
        'SQL' => '',
        'Diff' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => '',
        'This feature is enabled!' => '',
        'Just use this feature if you want to log each request.' => '',
        'Of couse this feature will take some system performance it self!' => '',
        'Disable it here!' => '',
        'This feature is disabled!' => '',
        'Enable it here!' => '',
        'Logfile too large!' => '',
        'Logfile too large, you need to reset it!' => '',
        'Range' => '',
        'Interface' => '',
        'Requests' => '',
        'Min Response' => '',
        'Max Response' => '',
        'Average Response' => '',

        # Template: AdminPGPForm
        'PGP Management' => '',
        'Result' => '',
        'Identifier' => '',
        'Bit' => '',
        'Key' => 'Nyckel',
        'Fingerprint' => '',
        'Expires' => '',
        'In this way you can directly edit the keyring configured in SysConfig.' => '',

        # Template: AdminPOP3
        'POP3 Account Management' => 'Administration av POP3-Konto',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => '',
        'Filtername' => '',
        'Match' => 'Trff',
        'Header' => '',
        'Value' => 'Innehll',
        'Set' => '',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => '',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => '',

        # Template: AdminQueueForm
        'Queue Management' => 'Khantering',
        'Sub-Queue of' => 'Underk till',
        'Unlock timeout' => 'Tidsintervall fr borttagning av ls',
        '0 = no unlock' => '0 = ingen upplsning',
        'Escalation - First Response Time' => '',
        '0 = no escalation' => '0 = ingen upptrappning',
        'Escalation - Update Time' => '',
        'Escalation - Solution Time' => '',
        'Follow up Option' => 'Korrespondens p lst rende',
        'Ticket lock after a follow up' => 'rendet lses efter uppfljningsmail',
        'Systemaddress' => 'Systemadress',
        'Customer Move Notify' => 'Meddelande om flytt av kund',
        'Customer State Notify' => 'Meddelande om statusndring fr Kund',
        'Customer Owner Notify' => 'Meddelande om byte av gare av Kund',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Ifall ett rende som r lst av en agent men nd inte blir besvarat inom denna tid, kommer lset automatiskt att tas bort.',
        'Escalation time' => 'Upptrappningstid',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Ifall ett rende inte blir besvarat inom denna tid, visas enbart detta rende.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Ifall en kund skickar uppfljningsmail p ett lst rende, blir rendet lst till frra garen.',
        'Will be the sender address of this queue for email answers.' => 'Avsndaradress fr email i denna K.',
        'The salutation for email answers.' => 'Hlsningsfras fr email-svar.',
        'The signature for email answers.' => 'Signatur fr email-svar.',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS skickar ett meddelande till kunden ifall rendet flyttas.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS skickar ett meddelande till kunden vid statusuppdatering.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS skickar ett meddelande till kunden vid garbyte.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => '',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Svar',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => '',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Hantera svar',
        'A response is default text to write faster answer (with default text) to customers.' => 'Ett svar r en standardtext fr att underltta besvarandet av vanliga kundfrgor.',
        'Don\'t forget to add a new response a queue!' => 'Kom ihg att lgga till ett nytt svar till en k!',
        'The current ticket state is' => 'Nuvarande rende-status',
        'Your email address is new' => '',

        # Template: AdminRoleForm
        'Role Management' => '',
        'Add Role' => '',
        'Add a new Role.' => '',
        'Create a role and put groups in it. Then add the role to the users.' => '',
        'It\'s useful for a lot of users and groups.' => '',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => '',
        'move_into' => 'Flytta till',
        'Permissions to move tickets into this group/queue.' => 'Rtt att flytta renden i denna grupp/K.',
        'create' => 'Skapa',
        'Permissions to create tickets in this group/queue.' => 'Rtt att skapa renden i denna grupp/K.',
        'owner' => 'gare',
        'Permissions to change the ticket owner in this group/queue.' => 'Rtt att ndra rende-gare i denna grupp/K.',
        'priority' => 'prioritet',
        'Permissions to change the ticket priority in this group/queue.' => 'Rtt att ndra rendeprioritet i denna grupp/K.',

        # Template: AdminRoleGroupForm
        'Role' => '',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => '',
        'Active' => '',
        'Select the role:user relations.' => '',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Hantering av Hlsningsfraser',
        'Add Salutation' => '',
        'Add a new Salutation.' => '',

        # Template: AdminSelectBoxForm
        'Select Box' => 'SQL-access',
        'Limit' => '',
        'Go' => '',
        'Select Box Result' => 'Select Box Resultat',

        # Template: AdminService
        'Service Management' => '',
        'Service' => '',
        'Sub-Service of' => '',

        # Template: AdminSession
        'Session Management' => 'Sessionshantering',
        'Sessions' => 'Sessioner',
        'Uniq' => '',
        'Kill all sessions' => '',
        'Session' => '',
        'Content' => '',
        'kill session' => 'Terminera session',

        # Template: AdminSignatureForm
        'Signature Management' => 'Signaturhantering',
        'Add Signature' => '',
        'Add a new Signature.' => '',

        # Template: AdminSLA
        'SLA Management' => '',
        'SLA' => '',
        'First Response Time' => '',
        'Update Time' => '',
        'Solution Time' => '',

        # Template: AdminSMIMEForm
        'S/MIME Management' => '',
        'Add Certificate' => '',
        'Add Private Key' => '',
        'Secret' => '',
        'Hash' => '',
        'In this way you can directly edit the certification and private keys in file system.' => '',

        # Template: AdminStateForm
        'State Management' => '',
        'Add State' => '',
        'Add a new State.' => '',
        'State Type' => 'Statustyp',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Se till att du ocks uppdaterade standardutgngslgena i Kernel/Config.pm!',
        'See also' => 'Se ocks',

        # Template: AdminSysConfig
        'SysConfig' => '',
        'Group selection' => '',
        'Show' => '',
        'Download Settings' => '',
        'Download all system config changes.' => '',
        'Load Settings' => '',
        'Subgroup' => '',
        'Elements' => '',

        # Template: AdminSysConfigEdit
        'Config Options' => '',
        'Default' => '',
        'New' => 'Nytt',
        'New Group' => '',
        'Group Ro' => '',
        'New Group Ro' => '',
        'NavBarName' => '',
        'NavBar' => '',
        'Image' => '',
        'Prio' => '',
        'Block' => '',
        'AccessKey' => '',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Hantera System-emailadresser',
        'Add System Address' => '',
        'Add a new System Address.' => '',
        'Realname' => 'Fullstndigt namn',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Alla inkommande mail till denna adressat (To:) delas ut till vald k.',

        # Template: AdminSystemStatus
        'System Status' => '',

        # Template: AdminTicketCustomerNotification
        'Notification (Customer)' => '',
        'Event' => '',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => '',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => '',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',

        # Template: AdminTypeForm
        'Type Management' => '',
        'Add Type' => '',
        'Add a new Type.' => '',

        # Template: AdminUserForm
        'User Management' => 'Anvndarhantering',
        'Add a new Agent.' => '',
        'Login as' => '',
        'Firstname' => 'Frnamn',
        'Lastname' => 'Efternamn',
        'User will be needed to handle tickets.' => 'Anvndare krvs fr att hantera renden.',
        'Don\'t forget to add a new user to groups and/or roles!' => '',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => '',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Adressbok',
        'Return to the compose screen' => 'Stng fnstret',
        'Discard all changes and return to the compose screen' => 'Bortse frn ndringarna och stng fnstret',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerTableView

        # Template: AgentInfo
        'Info' => '',

        # Template: AgentLinkObject
        'Link Object' => '',
        'Select' => 'Vlj',
        'Results' => 'Resultat',
        'Total hits' => 'Totalt hittade',
        'Page' => 'Sida',
        'Detail' => '',

        # Template: AgentLookup
        'Lookup' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Stavningskontroll',
        'spelling error(s)' => 'Stavfel',
        'or' => 'eller',
        'Apply these changes' => 'Verkstll ndringar',

        # Template: AgentStatsDelete
        'Stat#' => '',
        'Do you really want to delete this Object?' => '',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => '',
        'Fixed' => '',
        'Please select only one Element or turn of the button \'Fixed\'.' => '',
        'Absolut Period' => '',
        'Between' => '',
        'Relative Period' => '',
        'The last' => '',
        'Finish' => '',
        'Here you can make restrictions to your stat.' => '',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributs of the corresponding element.' => '',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => '',
        'Permissions' => '',
        'Format' => '',
        'Graphsize' => '',
        'Sum rows' => '',
        'Sum columns' => '',
        'Cache' => '',
        'Required Field' => '',
        'Selection needed' => '',
        'Explanation' => '',
        'In this form you can select the basic specifications.' => '',
        'Attribute' => '',
        'Title of the stat.' => '',
        'Here you can insert a description of the stat.' => '',
        'Dynamic-Object' => '',
        'Here you can select the dynamic object you want to use.' => '',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '',
        'Static-File' => '',
        'For very complex stats it is possible to include a hardcoded file.' => '',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => '',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => '',
        'Multiple selection of the output format.' => '',
        'If you use a graph as output format you have to select at least one graph size.' => '',
        'If you need the sum of every row select yes' => '',
        'If you need the sum of every column select yes.' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => '',
        '(Note: Useful for big databases and low performance server)' => '',
        'With an invalid stat it isn\'t feasible to generate a stat.' => '',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => '',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => '',
        'Scale' => '',
        'minimal' => '',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => '',
        'Here you can the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => '',
        'maximal period' => '',
        'minimal scale' => '',
        'Here you can define the x-axis. You can select one element via the radio button. Than you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsImport
        'Import' => '',
        'File is not a Stats config' => '',
        'No File selected' => '',

        # Template: AgentStatsOverview
        'Object' => '',

        # Template: AgentStatsPrint
        'Print' => 'Skriv ut',
        'No Element selected.' => '',

        # Template: AgentStatsView
        'Export Config' => '',
        'Informations about the Stat' => '',
        'Exchange Axis' => '',
        'Configurable params of static stat' => '',
        'No element selected.' => '',
        'maximal period from' => '',
        'to' => '',
        'Start' => '',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => '',

        # Template: AgentTicketArticleUpdate
        'A message should have a subject!' => 'Ett meddelande mste ha en mnesrad!',
        'A message should have a body!' => 'Ett meddelande mste innehlla en meddelandetext!',
        'You need to account time!' => 'Du mste redovisa tiden!',
        'Edit Article' => '',

        # Template: AgentTicketBounce
        'Bounce ticket' => 'Skicka ver rende',
        'Ticket locked!' => 'rendet lst',
        'Ticket unlock!' => 'rendet upplst',
        'Bounce to' => 'Skicka ver till',
        'Next ticket state' => 'Nsta rendestatus',
        'Inform sender' => 'Informera avsndare',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Emailen med rendenummer "<OTRS_TICKET>" har skickats ver till "<OTRS_BOUNCE_TO>". Vnligen kontakta denna adress fr vidare hnvisningar.',
        'Send mail!' => 'Skicka mail!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => '',
        'Spell Check' => 'Stavningskontroll',
        'Note type' => 'Anteckningstyp',
        'Unlock Tickets' => '',

        # Template: AgentTicketClose
        'Close ticket' => 'Stng rende',
        'Previous Owner' => 'Tidigare gare',
        'Inform Agent' => '',
        'Optional' => '',
        'Inform involved Agents' => '',
        'Attach' => 'Bifoga',
        'Next state' => 'Nsta tillstnd',
        'Pending date' => 'Vntande datum',
        'Time units' => 'Tidsenheter',
        ' (work units)' => ' (arbetsenheter)',

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Frfatta svar till rende',
        'Pending Date' => 'Vntar till',
        'for pending* states' => 'fr vntetillstnd',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'ndra kund fr rende',
        'Set customer user and customer id of a ticket' => 'Ange kundanvndare och organisations-id fr ett rende',
        'Customer User' => 'Kundanvndare',
        'Search Customer' => 'Sk kund',
        'Customer Data' => 'Kunddata',
        'Customer history' => 'Kundhistorik',
        'All customer tickets.' => 'Alla kundrenden.',

        # Template: AgentTicketCustomerMessage
        'Follow up' => 'Uppfljning',

        # Template: AgentTicketEmail
        'Compose Email' => 'Skriv email',
        'new ticket' => 'Nytt rende',
        'Refresh' => '',
        'Clear To' => '',

        # Template: AgentTicketForward
        'Article type' => 'Artikeltyp',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'ndra friatextflt i rende',

        # Template: AgentTicketHistory
        'History of' => 'Historik fr',

        # Template: AgentTicketLocked

        # Template: AgentTicketMailbox
        'Tickets' => 'renden',
        'of' => 'av',
        'Filter' => '',
        'New messages' => 'Nya meddelanden',
        'Reminder' => 'Pminnelse',
        'Sort by' => 'Sortera efter',
        'Order' => 'Sortering',
        'up' => 'stigande',
        'down' => 'sjunkande',

        # Template: AgentTicketMerge
        'Ticket Merge' => '',
        'Merge to' => '',

        # Template: AgentTicketMove
        'Move Ticket' => 'Flytta rende',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Lgg till anteckning till rende',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'ndra ett rendes gare',

        # Template: AgentTicketPending
        'Set Pending' => 'Markera som vntande',

        # Template: AgentTicketPhone
        'Phone call' => 'Telefonsamtal',
        'Clear From' => 'Nollstll Frn:',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Enkel',
        'TicketID' => '',
        'ArticleID' => '',

        # Template: AgentTicketPrint
        'Ticket-Info' => '',
        'Accounted time' => 'Redovisad tid',
        'Escalation in' => 'Upptrappning om',
        'Linked-Object' => '',
        'Parent-Object' => '',
        'Child-Object' => '',
        'by' => 'av',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'ndra rendeprioritet',

        # Template: AgentTicketQueue
        'Tickets shown' => 'renden som visas',
        'Tickets available' => 'Tillgngliga renden',
        'All tickets' => 'Alla renden',
        'Queues' => 'Ker',
        'Ticket escalation!' => 'rende-upptrappning!',

        # Template: AgentTicketQueueTicketView
        'First Response' => '',
        'Service Time' => '',
        'Your own Ticket' => 'Ditt eget rende',
        'Compose Follow up' => 'Skriv uppfljningssvar',
        'Compose Answer' => 'Skriv svar',
        'Contact customer' => 'Kontakta kund',
        'Change queue' => 'ndra k',

        # Template: AgentTicketQueueTicketViewLite

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => '',

        # Template: AgentTicketSearch
        'Ticket Search' => 'rende-sk',
        'Profile' => 'Profil',
        'Search-Template' => 'Skmall',
        'TicketFreeText' => '',
        'Created in Queue' => '',
        'Result Form' => 'Resultatbild',
        'Save Search-Profile as Template?' => 'Spara skkriterier som mall?',
        'Yes, save it with name' => 'Ja, spara med namn',

        # Template: AgentTicketSearchResult
        'Search Result' => 'Skeresultat',
        'Change search options' => 'ndra skinstllningar',

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketSearchResultShort
        'U' => '',
        'D' => 'N',

        # Template: AgentTicketStatusView
        'Ticket Status View' => '',
        'Open Tickets' => '',
        'Locked' => '',

        # Template: AgentTicketZoom

        # Template: AgentWindowTab

        # Template: Copyright

        # Template: css

        # Template: customer-css

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => '',

        # Template: CustomerFAQ

        # Template: CustomerFooter
        'Powered by' => '',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => '',
        'Lost your password?' => 'Glmt lsenordet?',
        'Request new password' => 'Be om nytt lsenord',
        'Create Account' => 'Skapa konto',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Vlkommen %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Tider',
        'No time settings.' => 'Inga tidsinstllningar.',

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Klicka hr fr att rapportera ett fel!',

        # Template: Footer
        'Top of Page' => 'Brjan av sidan',

        # Template: FooterSmall

        # Template: Header

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Web-installation',
        'Accept license' => '',
        'Don\'t accept license' => '',
        'Admin-User' => 'Admin-anvndare',
        'Admin-Password' => '',
        'your MySQL DB should have a root password! Default is empty!' => 'Din MySQL-databas br ha ett root-lsenord satt!  Default r inget lsenord!',
        'Database-User' => '',
        'default \'hot\'' => '',
        'DB connect host' => '',
        'Database' => '',
        'false' => '',
        'SystemID' => '',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Unikt id fr detta system.  Alla rendenummer och http-sesssionsid brjar med denna id)',
        'System FQDN' => '',
        '(Full qualified domain name of your system)' => '(Fullt kvalificerat dns-namn fr ditt system)',
        'AdminEmail' => 'Admin-email',
        '(Email of the system admin)' => '(Email till systemadmin)',
        'Organization' => 'Organisation',
        'Log' => '',
        'LogModule' => '',
        '(Used log backend)' => '(Valt logg-backend)',
        'Logfile' => 'Logfil',
        '(Logfile just needed for File-LogModule!)' => '(Logfil behvs enbart fr File-LogModule!)',
        'Webfrontend' => 'Web-grnssnitt',
        'Default Charset' => 'Standard teckenuppsttning',
        'Use utf-8 it your database supports it!' => 'Anvnd utf-8 ifall din databas stdjer det!',
        'Default Language' => 'Standardsprk',
        '(Used default language)' => '(Valt standardsprk)',
        'CheckMXRecord' => '',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kontrollerar mx-uppslag fr uppgivna emailadresser i meddelanden som skrivs.  Anvnd inte CheckMXRecord om din OTRS-maskin r bakom en uppringd lina!)',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Fr att kunna anvnda OTRS, mste fljende rad skrivas p kommandoraden som root.',
        'Restart your webserver' => 'Starta om din webserver',
        'After doing so your OTRS is up and running.' => 'Efter detta r OTRS igng.',
        'Start page' => 'Startsida',
        'Have a lot of fun!' => 'Ha det s roligt!',
        'Your OTRS Team' => 'Ditt OTRS-Team',

        # Template: Login
        'Welcome to %s' => 'Vlkommen till %s',

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Ingen tkomst',

        # Template: Notify
        'Important' => '',

        # Template: PrintFooter
        'URL' => '',

        # Template: PrintHeader
        'printed by' => 'utskrivet av',

        # Template: PublicFAQ

        # Template: PublicView
        'Management Summary' => '',

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'OTRS Test-sida',
        'Counter' => '',

        # Template: Warning
        # Misc
        'Create Database' => 'Skapa databas',
        'DB Host' => 'DB host',
        'Change roles <-> groups settings' => '',
        'Ticket Number Generator' => 'rende-nummergenerator',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => '',
        'Create new Phone Ticket' => '',
        'Symptom' => '',
        'A message should have a To: recipient!' => 'Ett meddelande mste ha en mottagare i Till:-fltet!',
        'Site' => 'plats',
        'Customer history search (e. g. "ID342425").' => 'Sk efter kundhistorik (t.ex. "ID342425").',
        'Close!' => 'Stng!',
        'for agent firstname' => 'fr agents frnamn',
        'Subgroup \'' => '',
        'The message being composed has been closed.  Exiting.' => 'Det tilhrande redigeringsfnstret har stngts. Avslutar.',
        'A web calendar' => '',
        'to get the realname of the sender (if given)' => 'fr att f fram avsndarens fulla namn (om mjligt)',
        'OTRS DB Name' => 'OTRS DB namn',
        'Select Source (for add)' => '',
        'Days' => '',
        'Queue ID' => 'K-id',
        'Home' => 'Hem',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Konfigurationsval (t.ex. <OTRS_CONFIG_HttpType>)',
        'System History' => '',
        'customer realname' => 'Fullt kundnamn',
        'Pending messages' => 'Vntande meddelanden',
        'Modules' => '',
        'for agent login' => 'fr agents login',
        'Keyword' => 'Nyckelord',
        'Close type' => 'Stngningstillstnd',
        'DB Admin User' => 'DB Adminanvndare',
        'for agent user id' => 'fr agents anvndar-id',
        'sort upward' => 'Sortera stigande',
        'Change user <-> group settings' => 'ndra anvndar- <-> grupp-instllningar',
        'Problem' => '',
        'for ' => '',
        'next step' => 'nsta steg',
        'Customer history search' => 'Kundhistorik',
        'Admin-Email' => 'Admin-email',
        'Create new database' => 'Skapa ny databas',
        'A message must be spell checked!' => 'Stavningskontroll mste utfras p alla meddelanden!',
        '\' ' => '',
        'All Agents' => 'Alla agenter',
        'Keywords' => 'Nyckelord',
        'Typ' => '',
        'No * possible!' => 'Wildcards * inte tilltna!',
        'Options ' => '',
        'Message for new Owner' => 'Meddelande till ny gare',
        'to get the first 5 lines of the email' => 'fr att f fram de frsta 5 raderna av emailen',
        'OTRS DB Password' => 'OTRS DB lsenord',
        'Last update' => 'Senast ndrat',
        'to get the first 20 character of the subject' => 'fr att f fram de frste 20 tecknen i mnesbeskrivningen',
        'DB Admin Password' => 'DB Adminlsenord',
        'Drop Database' => 'Radera databas',
        'Advisory' => '',
        'FileManager' => '',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'ger tillgng till data fr gllande kund (t.ex. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Pending type' => 'Vntande typ',
        'Comment (internal)' => 'Kommentar (intern)',
        'This window must be called from compose window' => 'Denne funktion mste startas frn redigeringsfnstret',
        'Minutes' => '',
        'You need min. one selected Ticket!' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        '(Used ticket number format)' => '(Valt format fr rendenummer)',
        'Fulltext' => 'Fritext',
        'Incident' => '',
        'OTRS DB connect host' => '',
        'All Agent variables.' => '',
        'All Customer variables like defined in config option CustomerUser.' => '',
        'accept license' => 'godknn licens',
        'for agent lastname' => 'fr agents efternamn',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'ger tillgng till data fr agenten som utfr handlingen (t.ex. <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages' => 'Pminnelsemeddelanden',
        'Change users <-> roles settings' => '',
        'Ticket Hook' => '',
        'TicketZoom' => 'rende Zoom',
        'Don\'t forget to add a new user to groups!' => 'Glm inte att lgga in en ny anvndare i en grupp!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'I Till-fltet mste anges en giltig emailadress (t.ex. kund@exempeldomain.se)!',
        'CreateTicket' => 'Skapa rende',
        'System Settings' => 'Systeminstllningar',
        'WebWatcher' => '',
        'Hours' => '',
        'Finished' => 'Klar',
        'Split' => 'Dela',
        'All messages' => 'Alla meddelanden',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        'Artefact' => '',
        'A article should have a title!' => '',
        'don\'t accept license' => 'godknn inte licens',
        'A web mail client' => '',
        'WebMail' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        'Article time' => '',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'ger tillgang till data fr agenten som str som gare till rendet (t.ex. <OTRS_OWNER_UserFirstname>)',
        'Name is required!' => '',
        'DB Type' => 'DB typ',
        'Termin1' => '',
        'kill all sessions' => 'Terminera alla sessioner',
        'to get the from line of the email' => 'fr att f fram avsndarraden i emailen',
        'Solution' => 'Lsning',
        'QueueView' => 'Ker',
        'Welcome to OTRS' => '',
        'modified' => '',
        'Delete old database' => 'Radera gammal databas',
        'sort downward' => 'Sortera sjunkande',
        'You need to use a ticket number!' => '',
        'A web file manager' => '',
        'send' => 'Skicka',
        'Note Text' => 'Anteckingstext',
        'System State Management' => 'Hantering av systemstatus',
        'OTRS DB User' => 'OTRS DB anvndare',
        'PhoneView' => 'Tel.samtal',
        'maximal period form' => '',
        'Verion' => '',
        'Modified' => 'ndrat',
        'Ticket selected for bulk action!' => '',
        'Company' => '',
    };
    # $$STOP$$
}

1;
