# --
# Kernel/Language/nb_SW.pm - Swedish language translation
# Copyright (C) 2004 Mats Eric Olausson <mats@synergy.se>
# --
# $Id: sv.pm,v 1.10 2005/07/28 20:32:31 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::sv;

use strict;

use vars qw($VERSION);
$VERSION = q$Revision: 1.10 $;
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;

    # $$START$$
    # Last translation file sync: Thu Jul 28 22:14:53 2005

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D/%M %Y %T';
    $Self->{DateFormatLong} = '%A %D. %B %Y %T';
    $Self->{DateInputFormat} = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
      # Template: AAABase
      'Yes' => 'Ja',
      'No' => 'Nej',
      'yes' => 'ja',
      'no' => 'inga',
      'Off' => 'Av',
      'off' => 'av',
      'On' => 'P',
      'on' => 'p',
      'top' => 'topp',
      'end' => 'slut',
      'Done' => 'Klar',
      'Cancel' => 'Avbryt',
      'Reset' => 'Nollstll',
      'last' => 'sista',
      'before' => 'fre',
      'day' => 'dag',
      'days' => 'dagar',
      'day(s)' => 'dag(ar)',
      'hour' => 'timme',
      'hours' => 'timmar',
      'hour(s)' => '',
      'minute' => 'minut',
      'minutes' => 'minuter',
      'minute(s)' => '',
      'month' => '',
      'months' => '',
      'month(s)' => 'mnad(er)',
      'week' => '',
      'week(s)' => 'vecka(or)',
      'year' => '',
      'years' => '',
      'year(s)' => 'r',
      'wrote' => 'skrev',
      'Message' => 'Meddelande',
      'Error' => 'Fel',
      'Bug Report' => 'Rapportera fel',
      'Attention' => 'OBS',
      'Warning' => 'Varning',
      'Module' => 'Modul',
      'Modulefile' => 'Modulfil',
      'Subfunction' => 'Underfunktion',
      'Line' => 'Rad',
      'Example' => 'Exempel',
      'Examples' => 'Exempel',
      'valid' => 'giltig',
      'invalid' => 'ogiltig',
      'invalid-temporarily' => '',
      ' 2 minutes' => ' 2 minuter',
      ' 5 minutes' => ' 5 minuter',
      ' 7 minutes' => ' 7 minuter',
      '10 minutes' => '10 minuter',
      '15 minutes' => '15 minuter',
      'Mr.' => '',
      'Mrs.' => '',
      'Next' => '',
      'Back' => 'Tillbaka',
      'Next...' => '',
      '...Back' => '',
      '-none-' => '',
      'none' => 'inga',
      'none!' => 'inga!',
      'none - answered' => 'inga - besvarat',
      'please do not edit!' => 'Var vnlig och ndra inte detta!',
      'AddLink' => 'Lgg till lnk',
      'Link' => 'Lnk',
      'Linked' => '',
      'Link (Normal)' => '',
      'Link (Parent)' => '',
      'Link (Child)' => '',
      'Normal' => '',
      'Parent' => '',
      'Child' => '',
      'Hit' => 'Trff',
      'Hits' => 'Trffar',
      'Text' => '',
      'Lite' => 'Enkel',
      'User' => 'Anvndare',
      'Username' => 'Anvndarnamn',
      'Language' => 'Sprk',
      'Languages' => 'Sprk',
      'Password' => 'Lsenord',
      'Salutation' => 'Hlsning',
      'Signature' => 'Signatur',
      'Customer' => 'Kund',
      'CustomerID' => 'Organisations-ID',
      'CustomerIDs' => '',
      'customer' => 'kund',
      'agent' => '',
      'system' => 'System',
      'Customer Info' => 'Kundinfo',
      'go!' => 'Starta!',
      'go' => 'Starta',
      'All' => 'Alla',
      'all' => 'alla',
      'Sorry' => 'Beklagar',
      'update!' => 'Uppdatera!',
      'update' => 'uppdatera',
      'Update' => 'Uppdatera',
      'submit!' => 'Skicka!',
      'submit' => 'Skicka',
      'Submit' => '',
      'change!' => 'ndra!',
      'Change' => 'ndra',
      'change' => 'ndra',
      'click here' => 'klicka hr',
      'Comment' => 'Kommentar',
      'Valid' => 'Giltigt',
      'Invalid Option!' => '',
      'Invalid time!' => '',
      'Invalid date!' => '',
      'Name' => 'Namn',
      'Group' => 'Grupp',
      'Description' => 'Beskrivning',
      'description' => 'beskrivning',
      'Theme' => 'Tema',
      'Created' => 'Skapat',
      'Created by' => '',
      'Changed' => '',
      'Changed by' => '',
      'Search' => 'Sk',
      'and' => 'og',
      'between' => '',
      'Fulltext Search' => '',
      'Data' => '',
      'Options' => 'Tillval',
      'Title' => '',
      'Item' => '',
      'Delete' => 'Radera',
      'Edit' => 'Redigera',
      'View' => 'Bild',
      'Number' => '',
      'System' => '',
      'Contact' => 'Kontakt',
      'Contacts' => '',
      'Export' => '',
      'Up' => '',
      'Down' => '',
      'Add' => 'Lgg till',
      'Category' => 'Kategori',
      'Viewer' => '',
      'New message' => 'Nytt meddelande',
      'New message!' => 'Nytt meddelande!',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Vnligen besvara denna/dessa renden fr att komma tillbaka till den normala k-visningsbilden!',
      'You got new message!' => 'Du har ftt ett nytt meddelande!',
      'You have %s new message(s)!' => 'Du har %s nya meddelanden!',
      'You have %s reminder ticket(s)!' => 'Du har %s pminnelse-rende(n)!',
      'The recommended charset for your language is %s!' => 'Den rekommenderade teckenuppsttningen fr ditt sprk r %s!',
      'Passwords dosn\'t match! Please try it again!' => '',
      'Password is already in use! Please use an other password!' => '',
      'Password is already used! Please use an other password!' => '',
      'You need to activate %s first to use it!' => '',
      'No suggestions' => 'Inga frslag',
      'Word' => 'Ord',
      'Ignore' => 'Ignorera',
      'replace with' => 'Erstt med',
      'Welcome to OTRS' => 'Vlkommen till OTRS',
      'There is no account with that login name.' => 'Det finns inget konto med detta namn.',
      'Login failed! Your username or password was entered incorrectly.' => 'Inloggningen misslyckades! Angivet anvndarnamn och/eller lsenord r inte korrekt.',
      'Please contact your admin' => 'Vnligen kontakta administratren',
      'Logout successful. Thank you for using OTRS!' => 'Utloggningen lyckades.  Tack fr att du anvnde OTRS!',
      'Invalid SessionID!' => 'Ogiltigt SessionID!',
      'Feature not active!' => 'Funktion inte aktiverad!',
      'Take this Customer' => '',
      'Take this User' => 'Vlj denna anvndare',
      'possible' => 'mjlig',
      'reject' => 'Avvisas',
      'Facility' => 'Innrttning',
      'Timeover' => 'Tidsvertrdelse',
      'Pending till' => 'Vntande tills',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Det r inte rekommenderat att arbeta som userid 1 (systemkonto)! Skapa nya anvndare!',
      'Dispatching by email To: field.' => 'Skickar ivg enligt epostmeddelandets Till:-flt.',
      'Dispatching by selected Queue.' => '',
      'No entry found!' => 'Ingen inmatning funnen!',
      'Session has timed out. Please log in again.' => 'Sessionstiden har lpt ut.  Vnligen logga p igen.',
      'No Permission!' => '',
      'To: (%s) replaced with database email!' => 'Till: (%s) ersatt med epost frn databas!',
      'Cc: (%s) added database email!' => '',
      '(Click here to add)' => '(Klicka hr fr att lgga till)',
      'Preview' => 'Forhandsvisning',
      'Added User "%s"' => '',
      'Contract' => '',
      'Online Customer: %s' => '',
      'Online Agent: %s' => '',
      'Calendar' => '',
      'File' => '',
      'Filename' => 'Filnamn',
      'Type' => 'Typ',
      'Size' => '',
      'Upload' => '',
      'Directory' => '',
      'Signed' => '',
      'Sign' => '',
      'Crypted' => '',
      'Crypt' => '',

      # Template: AAAMonth
      'Jan' => 'jan',
      'Feb' => 'feb',
      'Mar' => 'mar',
      'Apr' => 'apr',
      'May' => 'maj',
      'Jun' => 'jun',
      'Jul' => 'jul',
      'Aug' => 'aug',
      'Sep' => 'sep',
      'Oct' => 'okt',
      'Nov' => 'nov',
      'Dec' => 'dec',

      # Template: AAANavBar
      'Admin-Area' => 'Admin-omrde',
      'Agent-Area' => 'Agent-omrde',
      'Ticket-Area' => '',
      'Logout' => 'Logga ut',
      'Agent Preferences' => '',
      'Preferences' => 'Instllningar',
      'Agent Mailbox' => '',
      'Stats' => 'Statistik',
      'Stats-Area' => '',
      'FAQ-Area' => 'FAQ-omrde',
      'FAQ' => '',
      'FAQ-Search' => '',
      'FAQ-Article' => '',
      'New Article' => 'Ny artikel',
      'FAQ-State' => '',
      'Admin' => '',
      'A web calendar' => '',
      'WebMail' => '',
      'A web mail client' => '',
      'FileManager' => '',
      'A web file manager' => '',
      'Artefact' => '',
      'Incident' => '',
      'Advisory' => '',
      'WebWatcher' => '',
      'Customer Users' => '',
      'Customer Users <-> Groups' => '',
      'Users <-> Groups' => '',
      'Roles' => '',
      'Roles <-> Users' => '',
      'Roles <-> Groups' => '',
      'Salutations' => '',
      'Signatures' => '',
      'Email Addresses' => '',
      'Notifications' => '',
      'Category Tree' => '',
      'Admin Notification' => '',

      # Template: AAAPreferences
      'Preferences updated successfully!' => 'Instllningar lagrade!',
      'Mail Management' => 'Eposthantering',
      'Frontend' => 'Grnssnitt',
      'Other Options' => 'Andra tillval',
      'Change Password' => '',
      'New password' => '',
      'New password again' => '',
      'Select your QueueView refresh time.' => 'Vlj automatisk uppdateringsintervall fr K-bild.',
      'Select your frontend language.' => 'Vlj sprk.',
      'Select your frontend Charset.' => 'Vlj teckenuppsttning.',
      'Select your frontend Theme.' => 'Vlj stil-tema.',
      'Select your frontend QueueView.' => 'Vlj K-bild.',
      'Spelling Dictionary' => 'Stavningslexikon',
      'Select your default spelling dictionary.' => 'Vlj standard ordbok for stavningskontroll.',
      'Max. shown Tickets a page in Overview.' => 'Max. visade renden per sida i versikt.',
      'Can\'t update password, passwords dosn\'t match! Please try it again!' => '',
      'Can\'t update password, invalid characters!' => '',
      'Can\'t update password, need min. 8 characters!' => '',
      'Can\'t update password, need 2 lower and 2 upper characters!' => '',
      'Can\'t update password, need min. 1 digit!' => '',
      'Can\'t update password, need min. 2 characters!' => '',
      'Password is needed!' => '',

      # Template: AAATicket
      'Lock' => 'Ls',
      'Unlock' => 'Ls upp',
      'History' => 'Historik',
      'Zoom' => '',
      'Age' => 'lder',
      'Bounce' => 'Studsa',
      'Forward' => 'Vidarebefordra',
      'From' => 'Frn',
      'To' => 'Till',
      'Cc' => '',
      'Bcc' => '',
      'Subject' => 'mne',
      'Move' => 'Flytta',
      'Queue' => 'K',
      'Priority' => 'Prioritet',
      'State' => 'Status',
      'Compose' => 'Frfatta',
      'Pending' => 'Vntande',
      'Owner' => 'gare',
      'Owner Update' => '',
      'Sender' => 'Avsndare',
      'Article' => 'Artikel',
      'Ticket' => 'rende',
      'Createtime' => 'Tidpunkt fr skapande',
      'plain' => 'r',
      'eMail' => '',
      'email' => '',
      'Close' => 'Stng',
      'Action' => 'tgrd',
      'Attachment' => 'Bifogat dokument',
      'Attachments' => 'Bifogade dokument',
      'This message was written in a character set other than your own.' => 'Detta meddelande r skrivet med en annan teckenuppsttning n den du anvnder.',
      'If it is not displayed correctly,' => 'Ifall det inte visas korrekt,',
      'This is a' => 'Detta r en',
      'to open it in a new window.' => 'fr att ppna i ett nytt fnster',
      'This is a HTML email. Click here to show it.' => 'Detta r ett HTML-email. Klicka hr fr att visa.',
      'Free Fields' => '',
      'Merge' => '',
      'closed successful' => 'Lst och stngt',
      'closed unsuccessful' => 'Olst men stngt',
      'new' => 'ny',
      'open' => 'ppen',
      'closed' => '',
      'removed' => 'borttagen',
      'pending reminder' => 'vntar p pminnelse',
      'pending auto close+' => 'vntar p att stngas (lst)',
      'pending auto close-' => 'vntar p att stngas (olst)',
      'email-external' => 'email externt',
      'email-internal' => 'email internt',
      'note-external' => 'notis externt',
      'note-internal' => 'notis internt',
      'note-report' => 'notis till rapport',
      'phone' => 'telefon',
      'sms' => '',
      'webrequest' => 'web-anmodan',
      'lock' => 'lst',
      'unlock' => 'upplst',
      'very low' => 'planeras',
      'low' => 'lg',
      'normal' => '',
      'high' => 'hg',
      'very high' => 'kritisk',
      '1 very low' => '1 Planeras',
      '2 low' => '2 lg',
      '3 normal' => '3 medium',
      '4 high' => '4 hg',
      '5 very high' => '5 kritisk',
      'Ticket "%s" created!' => 'rende "%s" skapad!',
      'Ticket Number' => '',
      'Ticket Object' => '',
      'No such Ticket Number "%s"! Can\'t link it!' => '',
      'Don\'t show closed Tickets' => 'Visa inte lsta renden',
      'Show closed Tickets' => 'Visa lsta renden',
      'Email-Ticket' => '',
      'Create new Email Ticket' => '',
      'Phone-Ticket' => '',
      'Create new Phone Ticket' => '',
      'Search Tickets' => '',
      'Edit Customer Users' => '',
      'Bulk-Action' => '',
      'Bulk Actions on Tickets' => '',
      'Send Email and create a new Ticket' => '',
      'Overview of all open Tickets' => '',
      'Locked Tickets' => '',
      'Lock it to work on it!' => '',
      'Unlock to give it back to the queue!' => '',
      'Shows the ticket history!' => '',
      'Print this ticket!' => '',
      'Change the ticket priority!' => '',
      'Change the ticket free fields!' => '',
      'Link this ticket to an other objects!' => '',
      'Change the ticket owner!' => '',
      'Change the ticket customer!' => '',
      'Add a note to this ticket!' => '',
      'Merge this ticket!' => '',
      'Set this ticket to pending!' => '',
      'Close this ticket!' => '',
      'Look into a ticket!' => '',
      'Delete this ticket!' => '',
      'Mark as Spam!' => '',
      'My Queues' => '',
      'Shown Tickets' => '',
      'New ticket notification' => 'Meddelande om nyskapat rende',
      'Send me a notification if there is a new ticket in "My Queues".' => '',
      'Follow up notification' => 'Meddelande om uppfljning',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Skicka mig ett meddelande om kundkorrespondens fr renden som jag r gare till.',
      'Ticket lock timeout notification' => 'Meddela mig d tiden gtt ut fr ett rende-ls',
      'Send me a notification if a ticket is unlocked by the system.' => 'Skicka mig ett meddelande ifall systemet tar bort lset p ett rende.',
      'Move notification' => 'Meddelande om ndring av k',
      'Send me a notification if a ticket is moved into one of "My Queues".' => '',
      'Your queue selection of your favorite queues. You also get notified about this queues via email if enabled.' => '',
      'Custom Queue' => 'Utvald k',
      'QueueView refresh time' => 'Automatisk uppdateringsintervall f K-bild',
      'Screen after new ticket' => 'Skrm efter inmatning av nytt rende',
      'Select your screen after creating a new ticket.' => 'Vlj skrmbild som visas efter registrering av ny hnvisning/rende.',
      'Closed Tickets' => 'Lsta renden',
      'Show closed tickets.' => 'Visa lsta renden.',
      'Max. shown Tickets a page in QueueView.' => 'Max. visade renden per sida i K-bild.',
      'Responses' => 'Svar',
      'Responses <-> Queue' => '',
      'Auto Responses' => '',
      'Auto Responses <-> Queue' => '',
      'Attachments <-> Responses' => '',
      'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
      'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
      'History::FollowUp' => 'FollowUp for [%s]. %s',
      'History::SendAutoReject' => 'AutoReject sent to "%s".',
      'History::SendAutoReply' => 'AutoReply sent to "%s".',
      'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
      'History::Forward' => 'Forwarded to "%s".',
      'History::Bounce' => 'Bounced to "%s".',
      'History::SendAnswer' => 'Email sent to "%s".',
      'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
      'History::SendCustomerNotification' => 'Notification sent to "%s".',
      'History::EmailAgent' => 'Email sent to customer.',
      'History::EmailCustomer' => 'Added email. %s',
      'History::PhoneCallAgent' => 'Agent called customer.',
      'History::PhoneCallCustomer' => 'Customer called us.',
      'History::AddNote' => 'Added note (%s)',
      'History::Lock' => 'Locked ticket.',
      'History::Unlock' => 'Unlocked ticket.',
      'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
      'History::Remove' => '%s',
      'History::CustomerUpdate' => 'Updated: %s',
      'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
      'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
      'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
      'History::Misc' => '%s',
      'History::SetPendingTime' => 'Updated: %s',
      'History::StateUpdate' => 'Old: "%s" New: "%s"',
      'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
      'History::WebRequestCustomer' => 'Customer request via web.',
      'History::TicketLinkAdd' => 'Added link to ticket "%s".',
      'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',

      # Template: AAAWeekDay
      'Sun' => 'sn',
      'Mon' => 'mn',
      'Tue' => 'tis',
      'Wed' => 'ons',
      'Thu' => 'tor',
      'Fri' => 'fre',
      'Sat' => 'lr',

      # Template: AdminAttachmentForm
      'Attachment Management' => 'Hantering av bifogade dokument',

      # Template: AdminAutoResponseForm
      'Auto Response Management' => 'Autosvar-hantering',
      'Response' => 'Svar',
      'Auto Response From' => 'autosvar-avsndare',
      'Note' => 'Notis',
      'Useable options' => 'Anvndbara tillgg',
      'to get the first 20 character of the subject' => 'fr att f fram de frste 20 tecknen i mnesbeskrivningen',
      'to get the first 5 lines of the email' => 'fr att f fram de frsta 5 raderna av emailen',
      'to get the from line of the email' => 'fr att f fram avsndarraden i emailen',
      'to get the realname of the sender (if given)' => 'fr att f fram avsndarens fulla namn (om mjligt)',
      'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',

      # Template: AdminCustomerUserForm
      'The message being composed has been closed.  Exiting.' => 'Det tilhrande redigeringsfnstret har stngts. Avslutar.',
      'This window must be called from compose window' => 'Denne funktion mste startas frn redigeringsfnstret',
      'Customer User Management' => 'Kundanvndare',
      'Search for' => '',
      'Result' => '',
      'Select Source (for add)' => '',
      'Source' => 'Klla',
      'This values are read only.' => '',
      'This values are required.' => '',
      'Customer user will be needed to have an customer histor and to to login via customer panels.' => '',

      # Template: AdminCustomerUserGroupChangeForm
      'Customer Users <-> Groups Management' => '',
      'Change %s settings' => 'ndra %s-instllningar',
      'Select the user:group permissions.' => 'Vlj anvndar:grupp-rettigheter.',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Om ingenting r valt finns inga rttigheter i denna grupp (renden i denna grupp kommer inte att finnas tillgngliga fr anvndaren).',
      'Permission' => 'Rttighet',
      'ro' => '',
      'Read only access to the ticket in this group/queue.' => 'Endast lsrttighet till renden i denna grupp/k.',
      'rw' => '',
      'Full read and write access to the tickets in this group/queue.' => 'Fulla ls- och skrivrttigheter till renden i denna grupp/k.',

      # Template: AdminCustomerUserGroupForm

      # Template: AdminEmail
      'Message sent to' => 'Meddelande skicakt till',
      'Recipents' => 'Mottagare',
      'Body' => 'Meddelandetext',
      'send' => 'Skicka',

      # Template: AdminGenericAgent
      'GenericAgent' => '',
      'Job-List' => '',
      'Last run' => '',
      'Run Now!' => '',
      'x' => '',
      'Save Job as?' => '',
      'Is Job Valid?' => '',
      'Is Job Valid' => '',
      'Schedule' => '',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Fritextsk i artiklar (t.ex. "Mar*in" eller "Baue*")',
      '(e. g. 10*5155 or 105658*)' => 't.ex. 10*5144 eller 105658*',
      '(e. g. 234321)' => 't.ex. 234321',
      'Customer User Login' => 'kundanvndare loginnamn',
      '(e. g. U5150)' => 't.ex. U5150',
      'Agent' => '',
      'TicketFreeText' => '',
      'Ticket Lock' => '',
      'Times' => 'Tider',
      'No time settings.' => 'Inga tidsinstllningar.',
      'Ticket created' => 'rende skapat',
      'Ticket created between' => 'rendet skapat mellan',
      'New Priority' => '',
      'New Queue' => 'Ny K',
      'New State' => '',
      'New Agent' => '',
      'New Owner' => 'Ny gare',
      'New Customer' => '',
      'New Ticket Lock' => '',
      'CustomerUser' => 'Kundanvndare',
      'Add Note' => 'Lgg till anteckning',
      'CMD' => '',
      'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => '',
      'Delete tickets' => '',
      'Warning! This tickets will be removed from the database! This tickets are lost!' => '',
      'Modules' => '',
      'Param 1' => '',
      'Param 2' => '',
      'Param 3' => '',
      'Param 4' => '',
      'Param 5' => '',
      'Param 6' => '',
      'Save' => '',

      # Template: AdminGroupForm
      'Group Management' => 'grupphantering',
      'The admin group is to get in the admin area and the stats group to get stats area.' => '\'admin\'-gruppen ger tillgng till Admin-arean, \'stats\'-gruppen till Statistik-arean.',
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Skapa nya grupper fr att kunna handtera olika rttigheter fr skilda grupper av agenter (t.ex. inkpsavdelning, supportavdelning, frsljningsavdelning, ...).',
      'It\'s useful for ASP solutions.' => 'Nyttigt fr ASP-lsningar.',

      # Template: AdminLog
      'System Log' => 'Systemlogg',
      'Time' => '',

      # Template: AdminNavigationBar
      'Users' => '',
      'Groups' => 'grupper',
      'Misc' => 'Div',

      # Template: AdminNotificationForm
      'Notification Management' => 'Meddelandehantering',
      'Notification' => '',
      'Notifications are sent to an agent or a customer.' => 'Meddelanden skickats till agenter eller kunder.',
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Konfigurationsval (t.ex. &lt;OTRS_CONFIG_HttpType&gt;)',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'ger tillgang till data fr agenten som str som gare till rendet (t.ex. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'ger tillgng till data fr agenten som utfr handlingen (t.ex. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'ger tillgng till data fr gllande kund (t.ex. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',

      # Template: AdminPackageManager
      'Package Manager' => '',
      'Uninstall' => '',
      'Verion' => '',
      'Do you really want to uninstall this package?' => '',
      'Install' => '',
      'Package' => '',
      'Online Repository' => '',
      'Version' => '',
      'Vendor' => '',
      'Upgrade' => '',
      'Local Repository' => '',
      'Status' => '',
      'Overview' => 'versikt',
      'Download' => '',
      'Rebuild' => '',
      'Reinstall' => '',

      # Template: AdminPGPForm
      'PGP Management' => '',
      'Identifier' => '',
      'Bit' => '',
      'Key' => 'Nyckel',
      'Fingerprint' => '',
      'Expires' => '',
      'In this way you can directly edit the keyring configured in SysConfig.' => '',

      # Template: AdminPOP3Form
      'POP3 Account Management' => 'Administration av POP3-Konto',
      'Host' => '',
      'Trusted' => 'Betrodd',
      'Dispatching' => 'Frdelning',
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Inkommande email frn POP3-konton sorteras till vald k!',
      'If your account is trusted, the already existing x-otrs header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',

      # Template: AdminPostMasterFilter
      'PostMaster Filter Management' => '',
      'Filtername' => '',
      'Match' => 'Trff',
      'Header' => '',
      'Value' => 'Innehll',
      'Set' => '',
      'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => '',
      'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '',

      # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Responses Management' => '',

      # Template: AdminQueueAutoResponseTable

      # Template: AdminQueueForm
      'Queue Management' => 'Khantering',
      'Sub-Queue of' => 'Underk till',
      'Unlock timeout' => 'Tidsintervall fr borttagning av ls',
      '0 = no unlock' => '0 = ingen upplsning',
      'Escalation time' => 'Upptrappningstid',
      '0 = no escalation' => '0 = ingen upptrappning',
      'Follow up Option' => 'Korrespondens p lst rende',
      'Ticket lock after a follow up' => 'rendet lses efter uppfljningsmail',
      'Systemaddress' => 'Systemadress',
      'Customer Move Notify' => 'Meddelande om flytt av kund',
      'Customer State Notify' => 'Meddelande om statusndring fr Kund',
      'Customer Owner Notify' => 'Meddelande om byte av gare av Kund',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Ifall ett rende som r lst av en agent men nd inte blir besvarat inom denna tid, kommer lset automatiskt att tas bort.',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Ifall ett rende inte blir besvarat inom denna tid, visas enbart detta rende.',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Ifall en kund skickar uppfljningsmail p ett lst rende, blir rendet lst till frra garen.',
      'Will be the sender address of this queue for email answers.' => 'Avsndaradress fr email i denna K.',
      'The salutation for email answers.' => 'Hlsningsfras fr email-svar.',
      'The signature for email answers.' => 'Signatur fr email-svar.',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS skickar ett meddelande till kunden ifall rendet flyttas.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS skickar ett meddelande till kunden vid statusuppdatering.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS skickar ett meddelande till kunden vid garbyte.',

      # Template: AdminQueueResponsesChangeForm
      'Responses <-> Queue Management' => '',

      # Template: AdminQueueResponsesForm
      'Answer' => 'Svar',

      # Template: AdminResponseAttachmentChangeForm
      'Responses <-> Attachments Management' => '',

      # Template: AdminResponseAttachmentForm

      # Template: AdminResponseForm
      'Response Management' => 'Hantera svar',
      'A response is default text to write faster answer (with default text) to customers.' => 'Ett svar r en standardtext fr att underltta besvarandet av vanliga kundfrgor.',
      'Don\'t forget to add a new response a queue!' => 'Kom ihg att lgga till ett nytt svar till en k!',
      'Next state' => 'Nsta tillstnd',
      'All Customer variables like defined in config option CustomerUser.' => '',
      'The current ticket state is' => 'Nuvarande rende-status',
      'Your email address is new' => '',

      # Template: AdminRoleForm
      'Role Management' => '',
      'Create a role and put groups in it. Then add the role to the users.' => '',
      'It\'s useful for a lot of users and groups.' => '',

      # Template: AdminRoleGroupChangeForm
      'Roles <-> Groups Management' => '',
      'move_into' => 'Flytta till',
      'Permissions to move tickets into this group/queue.' => 'Rtt att flytta renden i denna grupp/K.',
      'create' => 'Skapa',
      'Permissions to create tickets in this group/queue.' => 'Rtt att skapa renden i denna grupp/K.',
      'owner' => 'gare',
      'Permissions to change the ticket owner in this group/queue.' => 'Rtt att ndra rende-gare i denna grupp/K.',
      'priority' => 'prioritet',
      'Permissions to change the ticket priority in this group/queue.' => 'Rtt att ndra rendeprioritet i denna grupp/K.',

      # Template: AdminRoleGroupForm
      'Role' => '',

      # Template: AdminRoleUserChangeForm
      'Roles <-> Users Management' => '',
      'Active' => '',
      'Select the role:user relations.' => '',

      # Template: AdminRoleUserForm

      # Template: AdminSalutationForm
      'Salutation Management' => 'Hantering av Hlsningsfraser',
      'customer realname' => 'Fullt kundnamn',
      'for agent firstname' => 'fr agents frnamn',
      'for agent lastname' => 'fr agents efternamn',
      'for agent user id' => 'fr agents anvndar-id',
      'for agent login' => 'fr agents login',

      # Template: AdminSelectBoxForm
      'Select Box' => 'SQL-access',
      'SQL' => '',
      'Limit' => '',
      'Select Box Result' => 'Select Box Resultat',

      # Template: AdminSession
      'Session Management' => 'Sessionshantering',
      'Sessions' => 'Sessioner',
      'Uniq' => '',
      'kill all sessions' => 'Terminera alla sessioner',
      'Session' => '',
      'kill session' => 'Terminera session',

      # Template: AdminSignatureForm
      'Signature Management' => 'Signaturhantering',

      # Template: AdminSMIMEForm
      'SMIME Management' => '',
      'Add Certificate' => '',
      'Add Private Key' => '',
      'Secret' => '',
      'Hash' => '',
      'In this way you can directly edit the certification and private keys in file system.' => '',

      # Template: AdminStateForm
      'System State Management' => 'Hantering av systemstatus',
      'State Type' => 'Statustyp',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Se till att du ocks uppdaterade standardutgngslgena i Kernel/Config.pm!',
      'See also' => 'Se ocks',

      # Template: AdminSysConfig
      'SysConfig' => '',
      'Group selection' => '',
      'Show' => '',
      'Download Settings' => '',
      'Download all system config changes.' => '',
      'Load Settings' => '',
      'Subgroup' => '',
      'Elements' => '',

      # Template: AdminSysConfigEdit
      'Config Options' => '',
      'Default' => '',
      'Content' => '',
      'New' => 'Nytt',
      'New Group' => '',
      'Group Ro' => '',
      'New Group Ro' => '',
      'NavBarName' => '',
      'Image' => '',
      'Prio' => '',
      'Block' => '',
      'NavBar' => '',
      'AccessKey' => '',

      # Template: AdminSystemAddressForm
      'System Email Addresses Management' => 'Hantera System-emailadresser',
      'Email' => '',
      'Realname' => 'Fullstndigt namn',
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Alla inkommande mail till denna adressat (To:) delas ut till vald k.',

      # Template: AdminUserForm
      'User Management' => 'Anvndarhantering',
      'Firstname' => 'Frnamn',
      'Lastname' => 'Efternamn',
      'User will be needed to handle tickets.' => 'Anvndare krvs fr att hantera renden.',
      'Don\'t forget to add a new user to groups and/or roles!' => '',

      # Template: AdminUserGroupChangeForm
      'Users <-> Groups Management' => '',

      # Template: AdminUserGroupForm

      # Template: AgentBook
      'Address Book' => 'Adressbok',
      'Return to the compose screen' => 'Stng fnstret',
      'Discard all changes and return to the compose screen' => 'Bortse frn ndringarna och stng fnstret',

      # Template: AgentCalendarSmall

      # Template: AgentCalendarSmallIcon

      # Template: AgentCustomerTableView

      # Template: AgentInfo
      'Info' => '',

      # Template: AgentLinkObject
      'Link Object' => '',
      'Select' => 'Vlj',
      'Results' => 'Resultat',
      'Total hits' => 'Totalt hittade',
      'Site' => 'plats',
      'Detail' => '',

      # Template: AgentLookup
      'Lookup' => '',

      # Template: AgentNavigationBar
      'Ticket selected for bulk action!' => '',
      'You need min. one selected Ticket!' => '',

      # Template: AgentPreferencesForm

      # Template: AgentSpelling
      'Spell Checker' => 'Stavningskontroll',
      'spelling error(s)' => 'Stavfel',
      'or' => 'eller',
      'Apply these changes' => 'Verkstll ndringar',

      # Template: AgentTicketBounce
      'A message should have a To: recipient!' => 'Ett meddelande mste ha en mottagare i Till:-fltet!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'I Till-fltet mste anges en giltig emailadress (t.ex. kund@exempeldomain.se)!',
      'Bounce ticket' => 'Skicka ver rende',
      'Bounce to' => 'Skicka ver till',
      'Next ticket state' => 'Nsta rendestatus',
      'Inform sender' => 'Informera avsndare',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Emailen med rendenummer "<OTRS_TICKET>" har skickats ver till "<OTRS_BOUNCE_TO>". Vnligen kontakta denna adress fr vidare hnvisningar.',
      'Send mail!' => 'Skicka mail!',

      # Template: AgentTicketBulk
      'A message should have a subject!' => 'Ett meddelande mste ha en mnesrad!',
      'Ticket Bulk Action' => '',
      'Spell Check' => 'Stavningskontroll',
      'Note type' => 'Anteckningstyp',
      'Unlock Tickets' => '',

      # Template: AgentTicketClose
      'A message should have a body!' => 'Ett meddelande mste innehlla en meddelandetext!',
      'You need to account time!' => 'Du mste redovisa tiden!',
      'Close ticket' => 'Stng rende',
      'Note Text' => 'Anteckingstext',
      'Close type' => 'Stngningstillstnd',
      'Time units' => 'Tidsenheter',
      ' (work units)' => ' (arbetsenheter)',

      # Template: AgentTicketCompose
      'A message must be spell checked!' => 'Stavningskontroll mste utfras p alla meddelanden!',
      'Compose answer for ticket' => 'Frfatta svar till rende',
      'Attach' => 'Bifoga',
      'Pending Date' => 'Vntar till',
      'for pending* states' => 'fr vntetillstnd',

      # Template: AgentTicketCustomer
      'Change customer of ticket' => 'ndra kund fr rende',
      'Set customer user and customer id of a ticket' => 'Ange kundanvndare och organisations-id fr ett rende',
      'Customer User' => 'Kundanvndare',
      'Search Customer' => 'Sk kund',
      'Customer Data' => 'Kunddata',
      'Customer history' => 'Kundhistorik',
      'All customer tickets.' => 'Alla kundrenden.',

      # Template: AgentTicketCustomerMessage
      'Follow up' => 'Uppfljning',

      # Template: AgentTicketEmail
      'Compose Email' => 'Skriv email',
      'new ticket' => 'Nytt rende',
      'Clear To' => '',
      'All Agents' => 'Alla agenter',
      'Termin1' => '',

      # Template: AgentTicketForward
      'Article type' => 'Artikeltyp',

      # Template: AgentTicketFreeText
      'Change free text of ticket' => 'ndra friatextflt i rende',

      # Template: AgentTicketHistory
      'History of' => 'Historik fr',

      # Template: AgentTicketLocked
      'Ticket locked!' => 'rendet lst',
      'Ticket unlock!' => 'rendet upplst',

      # Template: AgentTicketMailbox
      'Mailbox' => '',
      'Tickets' => 'renden',
      'All messages' => 'Alla meddelanden',
      'New messages' => 'Nya meddelanden',
      'Pending messages' => 'Vntande meddelanden',
      'Reminder messages' => 'Pminnelsemeddelanden',
      'Reminder' => 'Pminnelse',
      'Sort by' => 'Sortera efter',
      'Order' => 'Sortering',
      'up' => 'stigande',
      'down' => 'sjunkande',

      # Template: AgentTicketMerge
      'You need to use a ticket number!' => '',
      'Ticket Merge' => '',
      'Merge to' => '',
      'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => '',

      # Template: AgentTicketMove
      'Queue ID' => 'K-id',
      'Move Ticket' => 'Flytta rende',
      'Previous Owner' => 'Tidigare gare',

      # Template: AgentTicketNote
      'Add note to ticket' => 'Lgg till anteckning till rende',
      'Inform Agent' => '',
      'Optional' => '',
      'Inform involved Agents' => '',

      # Template: AgentTicketOwner
      'Change owner of ticket' => 'ndra ett rendes gare',
      'Message for new Owner' => 'Meddelande till ny gare',

      # Template: AgentTicketPending
      'Set Pending' => 'Markera som vntande',
      'Pending type' => 'Vntande typ',
      'Pending date' => 'Vntande datum',

      # Template: AgentTicketPhone
      'Phone call' => 'Telefonsamtal',

      # Template: AgentTicketPhoneNew
      'Clear From' => 'Nollstll Frn:',

      # Template: AgentTicketPlain
      'Plain' => 'Enkel',
      'TicketID' => '',
      'ArticleID' => '',

      # Template: AgentTicketPrint
      'Ticket-Info' => '',
      'Accounted time' => 'Redovisad tid',
      'Escalation in' => 'Upptrappning om',
      'Linked-Object' => '',
      'Parent-Object' => '',
      'Child-Object' => '',
      'by' => 'av',

      # Template: AgentTicketPriority
      'Change priority of ticket' => 'ndra rendeprioritet',

      # Template: AgentTicketQueue
      'Tickets shown' => 'renden som visas',
      'Page' => 'Sida',
      'Tickets available' => 'Tillgngliga renden',
      'All tickets' => 'Alla renden',
      'Queues' => 'Ker',
      'Ticket escalation!' => 'rende-upptrappning!',

      # Template: AgentTicketQueueTicketView
      'Your own Ticket' => 'Ditt eget rende',
      'Compose Follow up' => 'Skriv uppfljningssvar',
      'Compose Answer' => 'Skriv svar',
      'Contact customer' => 'Kontakta kund',
      'Change queue' => 'ndra k',

      # Template: AgentTicketQueueTicketViewLite

      # Template: AgentTicketSearch
      'Ticket Search' => 'rende-sk',
      'Profile' => 'Profil',
      'Search-Template' => 'Skmall',
      'Created in Queue' => '',
      'Result Form' => 'Resultatbild',
      'Save Search-Profile as Template?' => 'Spara skkriterier som mall?',
      'Yes, save it with name' => 'Ja, spara med namn',
      'Customer history search' => 'Kundhistorik',
      'Customer history search (e. g. "ID342425").' => 'Sk efter kundhistorik (t.ex. "ID342425").',
      'No * possible!' => 'Wildcards * inte tilltna!',

      # Template: AgentTicketSearchResult
      'Search Result' => 'Skeresultat',
      'Change search options' => 'ndra skinstllningar',

      # Template: AgentTicketSearchResultPrint
      '"}' => '',

      # Template: AgentTicketSearchResultShort
      'sort upward' => 'Sortera stigande',
      'U' => '',
      'sort downward' => 'Sortera sjunkande',
      'D' => 'N',

      # Template: AgentTicketStatusView
      'Ticket Status View' => '',
      'Open Tickets' => '',

      # Template: AgentTicketZoom
      'Split' => 'Dela',

      # Template: AgentTicketZoomStatus
      'Locked' => '',

      # Template: AgentWindowTabStart

      # Template: AgentWindowTabStop

      # Template: Copyright

      # Template: css

      # Template: customer-css

      # Template: CustomerAccept

      # Template: CustomerCalendarSmallIcon

      # Template: CustomerError
      'Traceback' => '',

      # Template: CustomerFAQ
      'Print' => 'Skriv ut',
      'Keywords' => 'Nyckelord',
      'Symptom' => '',
      'Problem' => '',
      'Solution' => 'Lsning',
      'Modified' => 'ndrat',
      'Last update' => 'Senast ndrat',
      'FAQ System History' => '',
      'modified' => '',
      'FAQ Search' => 'FAQ Sk',
      'Fulltext' => 'Fritext',
      'Keyword' => 'Nyckelord',
      'FAQ Search Result' => 'FAQ Skresultat',
      'FAQ Overview' => 'FAQ versikt',

      # Template: CustomerFooter
      'Powered by' => '',

      # Template: CustomerFooterSmall

      # Template: CustomerHeader

      # Template: CustomerHeaderSmall

      # Template: CustomerLogin
      'Login' => '',
      'Lost your password?' => 'Glmt lsenordet?',
      'Request new password' => 'Be om nytt lsenord',
      'Create Account' => 'Skapa konto',

      # Template: CustomerNavigationBar
      'Welcome %s' => 'Vlkommen %s',

      # Template: CustomerPreferencesForm

      # Template: CustomerStatusView
      'of' => 'av',

      # Template: CustomerTicketMessage

      # Template: CustomerTicketMessageNew

      # Template: CustomerTicketSearch

      # Template: CustomerTicketSearchResultCSV

      # Template: CustomerTicketSearchResultPrint

      # Template: CustomerTicketSearchResultShort

      # Template: CustomerTicketZoom

      # Template: CustomerWarning

      # Template: Error
      'Click here to report a bug!' => 'Klicka hr fr att rapportera ett fel!',

      # Template: FAQ
      'Comment (internal)' => 'Kommentar (intern)',
      'A article should have a title!' => '',
      'New FAQ Article' => '',
      'Do you really want to delete this Object?' => '',
      'System History' => '',

      # Template: FAQCategoryForm
      'Name is required!' => '',
      'FAQ Category' => 'FAQ Kategori',

      # Template: FAQLanguageForm
      'FAQ Language' => 'FAQ Sprk',

      # Template: Footer
      'QueueView' => 'Ker',
      'PhoneView' => 'Tel.samtal',
      'Top of Page' => 'Brjan av sidan',

      # Template: FooterSmall

      # Template: Header
      'Home' => 'Hem',

      # Template: HeaderSmall

      # Template: Installer
      'Web-Installer' => 'Web-installation',
      'accept license' => 'godknn licens',
      'don\'t accept license' => 'godknn inte licens',
      'Admin-User' => 'Admin-anvndare',
      'Admin-Password' => '',
      'your MySQL DB should have a root password! Default is empty!' => 'Din MySQL-databas br ha ett root-lsenord satt!  Default r inget lsenord!',
      'Database-User' => '',
      'default \'hot\'' => '',
      'DB connect host' => '',
      'Database' => '',
      'Create' => '',
      'false' => '',
      'SystemID' => '',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Unikt id fr detta system.  Alla rendenummer och http-sesssionsid brjar med denna id)',
      'System FQDN' => '',
      '(Full qualified domain name of your system)' => '(Fullt kvalificerat dns-namn fr ditt system)',
      'AdminEmail' => 'Admin-email',
      '(Email of the system admin)' => '(Email till systemadmin)',
      'Organization' => 'Organisation',
      'Log' => '',
      'LogModule' => '',
      '(Used log backend)' => '(Valt logg-backend)',
      'Logfile' => 'Logfil',
      '(Logfile just needed for File-LogModule!)' => '(Logfil behvs enbart fr File-LogModule!)',
      'Webfrontend' => 'Web-grnssnitt',
      'Default Charset' => 'Standard teckenuppsttning',
      'Use utf-8 it your database supports it!' => 'Anvnd utf-8 ifall din databas stdjer det!',
      'Default Language' => 'Standardsprk',
      '(Used default language)' => '(Valt standardsprk)',
      'CheckMXRecord' => '',
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kontrollerar mx-uppslag fr uppgivna emailadresser i meddelanden som skrivs.  Anvnd inte CheckMXRecord om din OTRS-maskin r bakom en uppringd lina!)',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Fr att kunna anvnda OTRS, mste fljende rad skrivas p kommandoraden som root.',
      'Restart your webserver' => 'Starta om din webserver',
      'After doing so your OTRS is up and running.' => 'Efter detta r OTRS igng.',
      'Start page' => 'Startsida',
      'Have a lot of fun!' => 'Ha det s roligt!',
      'Your OTRS Team' => 'Ditt OTRS-Team',

      # Template: Login

      # Template: Motd

      # Template: NoPermission
      'No Permission' => 'Ingen tkomst',

      # Template: Notify
      'Important' => '',

      # Template: PrintFooter
      'URL' => '',

      # Template: PrintHeader
      'printed by' => 'utskrivet av',

      # Template: Redirect

      # Template: SystemStats
      'Format' => '',

      # Template: Test
      'OTRS Test Page' => 'OTRS Test-sida',
      'Counter' => '',

      # Template: Warning
      # Misc
      'OTRS DB connect host' => '',
      'Create Database' => 'Skapa databas',
      'DB Host' => 'DB host',
      'Change roles <-> groups settings' => '',
      'Ticket Number Generator' => 'rende-nummergenerator',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '',
      'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => '',
      'Change users <-> roles settings' => '',
      'Ticket Hook' => '',
      'Close!' => 'Stng!',
      'Subgroup \'' => '',
      'TicketZoom' => 'rende Zoom',
      'Don\'t forget to add a new user to groups!' => 'Glm inte att lgga in en ny anvndare i en grupp!',
      'License' => 'Licens',
      'CreateTicket' => 'Skapa rende',
      'OTRS DB Name' => 'OTRS DB namn',
      'System Settings' => 'Systeminstllningar',
      'Hours' => '',
      'Finished' => 'Klar',
      'Days' => '',
      'DB Admin User' => 'DB Adminanvndare',
      'Article time' => '',
      'Options of the ticket data (e. g. &lt;OTRS_TICKET_TicketNumber&gt;, &lt;OTRS_TICKET_TicketID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',
      'Change user <-> group settings' => 'ndra anvndar- <-> grupp-instllningar',
      'for ' => '',
      'DB Type' => 'DB typ',
      'next step' => 'nsta steg',
      'FIXME: WHAT IS PGP?' => '',
      'Admin-Email' => 'Admin-email',
      'Create new database' => 'Skapa ny databas',
      '\' ' => '',
      'Delete old database' => 'Radera gammal databas',
      'Typ' => '',
      'OTRS DB User' => 'OTRS DB anvndare',
      'Options ' => '',
      'FIXME: WHAT IS SMIME?' => '',
      'OTRS DB Password' => 'OTRS DB lsenord',
      'DB Admin Password' => 'DB Adminlsenord',
      'Drop Database' => 'Radera databas',
      'Minutes' => '',
      '(Used ticket number format)' => '(Valt format fr rendenummer)',
      'FAQ History' => '',
    };
    # $$STOP$$
}
# --
1;
