# --
# Kernel/Language/pt.pm - provides pt language translation
# Copyright (C) 2004 CAT <filipehenriques at ip.pt>
# --
# $Id: pt.pm,v 1.31 2006/10/05 04:46:50 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::pt;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.31 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

sub Data {
    my $Self = shift;
    my %Param = @_;

    # $$START$$
    # Last translation file sync: Thu Oct  5 06:05:04 2006

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%Y-%M-%D %T';
    $Self->{DateFormatLong} = '%A, %D de %B de %Y, %T';
    $Self->{DateFormatShort} = '';
    $Self->{DateInputFormat} = '%Y-%M-%D';
    $Self->{DateInputFormatLong} = '%Y-%M-%D - %T';

    $Self->{Translation} = {
      # Template: AAABase
      'Yes' => 'Sim',
      'No' => 'No',
      'yes' => 'sim',
      'no' => 'no',
      'Off' => 'Desligado',
      'off' => 'desligado',
      'On' => 'Ligado',
      'on' => 'ligado',
      'top' => 'incio',
      'end' => 'fim',
      'Done' => 'Feito',
      'Cancel' => 'Cancelar',
      'Reset' => 'Limpar',
      'last' => 'nos ltimos',
      'before' => 'h mais de',
      'day' => 'dia',
      'days' => 'dias',
      'day(s)' => 'dia(s)',
      'hour' => 'hora',
      'hours' => 'horas',
      'hour(s)' => 'hora(s)',
      'minute' => 'minuto',
      'minutes' => 'minutos',
      'minute(s)' => 'minuto(s)',
      'month' => 'ms',
      'months' => 'meses',
      'month(s)' => 'mes(ses)',
      'week' => 'semana',
      'week(s)' => 'semana(s)',
      'year' => 'ano',
      'years' => 'anos',
      'year(s)' => 'ano(s)',
      'second(s)' => '',
      'seconds' => '',
      'second' => '',
      'wrote' => 'escreveu',
      'Message' => 'Mensagem',
      'Error' => 'Erro',
      'Bug Report' => 'Relatrio de Erros',
      'Attention' => 'Ateno',
      'Warning' => 'Aviso',
      'Module' => 'Mdulo',
      'Modulefile' => 'Ficheiro de Mdulo',
      'Subfunction' => 'Subfuno',
      'Line' => 'Linha',
      'Example' => 'Exemplo',
      'Examples' => 'Exemplos',
      'valid' => 'vlido',
      'invalid' => 'invlido',
      'invalid-temporarily' => 'invlido-temporariamente',
      ' 2 minutes' => ' 2 minutos',
      ' 5 minutes' => ' 5 minutos',
      ' 7 minutes' => ' 7 minutos',
      '10 minutes' => '10 minutos',
      '15 minutes' => '15 minutos',
      'Mr.' => 'Sr.',
      'Mrs.' => 'Sr.',
      'Next' => 'Prximo',
      'Back' => 'Voltar',
      'Next...' => 'Prximo...',
      '...Back' => '...Voltar',
      '-none-' => '-nenhum(a)-',
      'none' => 'nenhum(a)',
      'none!' => 'nenhum(a)!',
      'none - answered' => 'nenhum - respondido',
      'please do not edit!' => 'por favor no editar!',
      'AddLink' => 'Adicionar Ligao',
      'Link' => 'Ligar',
      'Linked' => 'Ligado',
      'Link (Normal)' => 'Ligar (Normal)',
      'Link (Parent)' => 'Ligar (Ascendente)',
      'Link (Child)' => 'Ligar (Descendente)',
      'Normal' => '',
      'Parent' => 'Ascendente',
      'Child' => 'Descendente',
      'Hit' => 'Acerto',
      'Hits' => 'Acertos',
      'Text' => 'Texto',
      'Lite' => 'Leve',
      'User' => 'Utilizador',
      'Username' => 'Nome de utilizador',
      'Language' => 'Idioma',
      'Languages' => 'Idiomas',
      'Password' => 'Palavra-passe',
      'Salutation' => 'Saudao',
      'Signature' => 'Assinatura',
      'Customer' => 'Cliente',
      'CustomerID' => 'ID de Cliente',
      'CustomerIDs' => 'ID de Cliente',
      'customer' => 'cliente',
      'agent' => 'agente',
      'system' => 'sistema',
      'Customer Info' => 'Informao de Cliente',
      'go!' => 'ir!',
      'go' => 'ir',
      'All' => 'Todos',
      'all' => 'todos',
      'Sorry' => 'Desculpe',
      'update!' => 'actualizar!',
      'update' => 'actualizar',
      'Update' => 'Actualizar',
      'submit!' => 'submeter!',
      'submit' => 'Submeter',
      'Submit' => 'Submeter',
      'change!' => 'alterar!',
      'Change' => 'Alterar',
      'change' => 'alterar',
      'click here' => 'clique aqui',
      'Comment' => 'Comentrio',
      'Valid' => 'Vlido',
      'Invalid Option!' => 'Opo Invlida!',
      'Invalid time!' => 'Hora invlida!',
      'Invalid date!' => 'Data invlida!',
      'Name' => 'Nome',
      'Group' => 'Grupo',
      'Description' => 'Descrio',
      'description' => 'descrio',
      'Theme' => 'Tema',
      'Created' => 'Criado',
      'Created by' => 'Criado por',
      'Changed' => 'Modificado',
      'Changed by' => 'Modificado por',
      'Search' => 'Procurar',
      'and' => 'e',
      'between' => 'entre',
      'Fulltext Search' => 'Procura Exaustiva no Texto',
      'Data' => '',
      'Options' => 'Opes',
      'Title' => 'Ttulo',
      'Item' => '',
      'Delete' => 'Eliminar',
      'Edit' => 'Editar',
      'View' => 'Ver',
      'Number' => 'Nmero',
      'System' => 'Sistema',
      'Contact' => 'Contacto',
      'Contacts' => 'Contactos',
      'Export' => 'Exportar',
      'Up' => 'Subir',
      'Down' => 'Descer',
      'Add' => 'Adicionar',
      'Category' => 'Categoria',
      'Viewer' => 'Visualizador',
      'New message' => 'Nova mensagem',
      'New message!' => 'Nova mensagem!',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Por favor, responda a este(s) bilhete(s) para regressar  visualizao de filas!',
      'You got new message!' => 'Tem uma mensagem nova!',
      'You have %s new message(s)!' => 'Tem %s mensagem(s) nova(s)!',
      'You have %s reminder ticket(s)!' => 'Tem %s lembrete(s)!',
      'The recommended charset for your language is %s!' => 'O cdigo recomendado para o seu idioma  %s!',
      'Passwords doesn\'t match! Please try it again!' => 'As palavras-passe no correspondem! Tente de novo!',
      'Password is already in use! Please use an other password!' => 'A palavra-passe est j em uso! Por favor use outra!',
      'Password is already used! Please use an other password!' => 'A palavra-passe j foi usada! Por favor use outra!',
      'You need to activate %s first to use it!' => 'Tem de activar %s antes de o usar!',
      'No suggestions' => 'Sem sugestes',
      'Word' => 'Palavra',
      'Ignore' => 'Ignorar',
      'replace with' => 'substituir por',
      'Welcome to OTRS' => 'Bem-vindo ao OTRS',
      'There is no account with that login name.' => 'No existe nenhuma conta com esse nome de utilizador',
      'Login failed! Your username or password was entered incorrectly.' => 'Entrada falhou! Ou o nome de utilizador ou a palavra-passe foram introduzidos incorrectamente.',
      'Please contact your admin' => 'Por favor contactar o seu administrador de sistemas',
      'Logout successful. Thank you for using OTRS!' => 'Saiu com sucesso. Obrigado por utilizar o Sistema de Ajuda do ISCTE!',
      'Invalid SessionID!' => 'ID de Sesso Invlido',
      'Feature not active!' => 'Caracterstica no activa!',
      'License' => 'Licena',
      'Take this Customer' => 'Fique com este Cliente',
      'Take this User' => 'Fique com este Utilizador',
      'possible' => 'possvel',
      'reject' => 'rejeitar',
      'reverse' => '',
      'Facility' => 'Instalao',
      'Timeover' => 'Tempo a mais',
      'Pending till' => 'Pendente at',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'No trabalhe com o UserID 1 (Conta de sistema)! Crie novos utilizadores!',
      'Dispatching by email To: field.' => 'Despachado atravs do campo Para:',
      'Dispatching by selected Queue.' => 'Despachado pela Fila escolhida',
      'No entry found!' => 'No se encontrou nada!',
      'Session has timed out. Please log in again.' => 'A sesso expirou. Por favor autentique-se novamente',
      'No Permission!' => 'Sem Permisso!',
      'To: (%s) replaced with database email!' => 'Para: (%s) substitudo pelo endereo na base de dados!',
      'Cc: (%s) added database email!' => 'Cc: (%s) acrescentado endereo na base de dados!',
      '(Click here to add)' => '(Clique aqui para adicionar)',
      'Preview' => 'Prever',
      'Package not correctly deployed! You should reinstall the Package again!' => '',
      'Added User "%s"' => 'Acrescentado Utilizador "%s"',
      'Contract' => 'Contrato',
      'Online Customer: %s' => 'Cliente em-linha: %s',
      'Online Agent: %s' => 'Agente em-linha: %s',
      'Calendar' => 'Calendrio',
      'File' => 'Ficheiro',
      'Filename' => 'Nome de ficheiro',
      'Type' => 'Tipo',
      'Size' => 'Tamanho',
      'Upload' => 'Carregar',
      'Directory' => 'Pasta',
      'Signed' => 'Assinado',
      'Sign' => 'Assinar',
      'Crypted' => 'Cifrado',
      'Crypt' => 'Cifrar',
      'Office' => 'Gabinete',
      'Phone' => 'Telefone',
      'Fax' => '',
      'Mobile' => '',
      'Zip' => '',
      'City' => '',
      'Country' => '',
      'installed' => 'instalado',
      'uninstalled' => 'desinstalado',
      'printed at' => '',

      # Template: AAAMonth
      'Jan' => 'Janeiro',
      'Feb' => 'Feveveiro',
      'Mar' => 'Maro',
      'Apr' => 'Abril',
      'May' => 'Maio',
      'Jun' => 'Junho',
      'Jul' => 'Julho',
      'Aug' => 'Agosto',
      'Sep' => 'Setembro',
      'Oct' => 'Outubro',
      'Nov' => 'Novembro',
      'Dec' => 'Dezembro',
      'January' => '',
      'February' => '',
      'March' => '',
      'April' => '',
      'June' => '',
      'July' => '',
      'August' => '',
      'September' => '',
      'October' => '',
      'November' => '',
      'December' => '',

      # Template: AAANavBar
      'Admin-Area' => 'rea de Administrao',
      'Agent-Area' => 'rea de Agente',
      'Ticket-Area' => 'rea de Bilhetes',
      'Logout' => 'Sair',
      'Agent Preferences' => 'Preferncias de Agente',
      'Preferences' => 'Preferncias',
      'Agent Mailbox' => 'Caixa do Correio do Agente',
      'Stats' => 'Estatsticas',
      'Stats-Area' => 'rea de Estatsticas',
      'New Article' => 'Novo Artigo',
      'Admin' => 'Administrao',
      'A web calendar' => 'Um calendrio na Web',
      'WebMail' => 'Correio electrnico na Web',
      'A web mail client' => 'Um cliente de correio electrnico na Web',
      'FileManager' => 'Gestor de Ficheiros',
      'A web file manager' => 'Um gestor de ficheiros na Web',
      'Artefact' => 'Artefacto',
      'Incident' => 'Incidente',
      'Advisory' => 'Recomendao',
      'WebWatcher' => 'Observador da Web',
      'Customer Users' => 'Utilizadores Clientes',
      'Customer Users <-> Groups' => 'Utilizadores Clientes <-> Grupos',
      'Users <-> Groups' => 'Utilizadores <-> Grupos',
      'Roles' => 'Papeis',
      'Roles <-> Users' => 'Papeis <-> Utilizadores',
      'Roles <-> Groups' => 'Papeis <-> Grupos',
      'Salutations' => 'Saudaes',
      'Signatures' => 'Assinaturas',
      'Email Addresses' => 'Endereos de Correio Electrnico',
      'Notifications' => 'Notificaes',
      'Category Tree' => 'rvore de Categorias',
      'Admin Notification' => 'Notificaes de Administrao',

      # Template: AAAPreferences
      'Preferences updated successfully!' => 'Preferncias actualizadas com sucesso!',
      'Mail Management' => 'Gesto de Correio Electrnico',
      'Frontend' => 'Interface',
      'Other Options' => 'Outras Opes',
      'Change Password' => 'Mudar a Palavra-passe',
      'New password' => 'Nova palavra-passe',
      'New password again' => 'De novo',
      'Select your QueueView refresh time.' => 'Selecione o tempo de refrescamento da Visualizao de Filas.',
      'Select your frontend language.' => 'Selecione o idioma da interface.',
      'Select your frontend Charset.' => 'Selecione a codificao da interface.',
      'Select your frontend Theme.' => 'Selecione o tema da sua interface.',
      'Select your frontend QueueView.' => 'Selecione a Visualizao de Filas da Interface.',
      'Spelling Dictionary' => 'Dicionrio Ortogrfico',
      'Select your default spelling dictionary.' => 'Seleccione o dicionrio ortogrfico por omisso.',
      'Max. shown Tickets a page in Overview.' => 'Nmero mximo de bilhetes por pgina em Viso Geral.',
      'Can\'t update password, passwords doesn\'t match! Please try it again!' => 'Impossvel actualizar a palavra-passe: as palavras-passe no correspondem! Tente de novo!',
      'Can\'t update password, invalid characters!' => 'Impossvel actualizar palavra-passe: caracteres invlidos!',
      'Can\'t update password, need min. 8 characters!' => 'Impossvel actualizar palavra-passe: necessrios pelo menos oito caracteres!',
      'Can\'t update password, need 2 lower and 2 upper characters!' => 'Impossvel actualizar palavra-passe: pelo menos duas minsculas e duas maisculas!',
      'Can\'t update password, need min. 1 digit!' => 'Impossvel actualizar palavra-passe: pelo menos um dgito!',
      'Can\'t update password, need min. 2 characters!' => 'Impossvel actualizar palavra-passe: pelo menos um caractere!',
      'Password is needed!' => 'Palavra-passe indispensvel!',

      # Template: AAAStats
      'Stat' => '',
      'Please fill out the required fields!' => '',
      'Please select a file!' => '',
      'Please select an object!' => '',
      'Please select a graph size!' => '',
      'Please select one element for the X-axis!' => '',
      'You have to select two or more attributes from the select field!' => '',
      'Please select only one element or turn of the button \'Fixed\' where the select field is marked!' => '',
      'If you use a checkbox you have to select some attributes of the select field!' => '',
      'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => '',
      'The selected end time is before the start time!' => '',
      'You have to select one or more attributes from the select field!' => '',
      'The selected Date isn\'t valid!' => '',
      'Please select only one or two elements via the checkbox!' => '',
      'If you use a time scale element you can only select one element!' => '',
      'You have an error in your time selection!' => '',
      'Your reporting time interval is to small, please use a larger time scale!' => '',
      'The selected start time is before the allowed start time!' => '',
      'The selected end time is after the allowed end time!' => '',
      'The selected time period is larger than the allowed time period!' => '',
      'Common Specification' => '',
      'Xaxis' => '',
      'Value Series' => '',
      'Restrictions' => '',
      'graph-lines' => '',
      'graph-bars' => '',
      'graph-hbars' => '',
      'graph-points' => '',
      'graph-lines-points' => '',
      'graph-area' => '',
      'graph-pie' => '',
      'extended' => '',
      'Agent/Owner' => '',
      'Created by Agent/Owner' => '',
      'Created Priority' => '',
      'Created State' => '',
      'Create Time' => '',
      'CustomerUserLogin' => '',
      'Close Time' => '',

      # Template: AAATicket
      'Lock' => 'Bloquear',
      'Unlock' => 'Desbloquear',
      'History' => 'Histrico',
      'Zoom' => 'Pormenores',
      'Age' => 'Idade',
      'Bounce' => 'Devolver',
      'Forward' => 'Encaminhar',
      'From' => 'De',
      'To' => 'Para',
      'Cc' => '',
      'Bcc' => '',
      'Subject' => 'Assunto',
      'Move' => 'Mover',
      'Queue' => 'Fila',
      'Priority' => 'Prioridade',
      'State' => 'Estado',
      'Compose' => 'Compr',
      'Pending' => 'Pendncias',
      'Owner' => 'Proprietrio',
      'Owner Update' => 'Actualizar Proprietrio',
      'Responsible' => '',
      'Responsible Update' => '',
      'Sender' => 'Remetente',
      'Article' => 'Artigo',
      'Ticket' => 'Bilhete',
      'Createtime' => 'Hora de criao',
      'plain' => 'verbatim',
      'Email' => 'Correio Electrnico',
      'email' => 'correio electrnico',
      'Close' => 'Fechar',
      'Action' => 'Aco',
      'Attachment' => 'Anexo',
      'Attachments' => 'Anexos',
      'This message was written in a character set other than your own.' => 'Esta mensagem foi escrita usando uma codificao diferente da sua.',
      'If it is not displayed correctly,' => 'Se no for exibida correctamente,',
      'This is a' => 'Este  um',
      'to open it in a new window.' => 'para a abrir em nova janela.',
      'This is a HTML email. Click here to show it.' => 'Esta  uma mensagem HTML. Clicar aqui para a mostrar.',
      'Free Fields' => 'Campos Livres',
      'Merge' => 'Juntar',
      'closed successful' => 'fechado com sucesso',
      'closed unsuccessful' => 'fechado sem sucesso',
      'new' => 'novo',
      'open' => 'aberto',
      'closed' => 'fechado',
      'removed' => 'removido',
      'pending reminder' => 'pendente com lembrete',
      'pending auto close+' => 'pendente com fecho automtico positivo',
      'pending auto close-' => 'pendente com fecho automtico negativo',
      'email-external' => 'mensagem de correio electrnico externa',
      'email-internal' => 'mensagem de correio electrnico externa',
      'note-external' => 'nota externa',
      'note-internal' => 'nota interna',
      'note-report' => 'relatrio de nota',
      'phone' => 'telefone',
      'sms' => '',
      'webrequest' => 'pedido via Web',
      'lock' => 'bloquear',
      'unlock' => 'desbloquear',
      'very low' => 'muito baixa',
      'low' => 'baixa',
      'normal' => '',
      'high' => 'alta',
      'very high' => 'muito alta',
      '1 very low' => '1 muito baixa',
      '2 low' => '2 baixa',
      '3 normal' => '',
      '4 high' => '4 alta',
      '5 very high' => '5 muito alta',
      'Ticket "%s" created!' => 'Bilhete "%s" criado!',
      'Ticket Number' => 'Nmero do Bilhete',
      'Ticket Object' => 'Objecto Bilhete',
      'No such Ticket Number "%s"! Can\'t link it!' => 'No existe Nmero de Bilhete "%s"! No posso ligar a ele!',
      'Don\'t show closed Tickets' => 'No mostrar bilhetes fechados',
      'Show closed Tickets' => 'Mostrar bilhetes fechados',
      'Email-Ticket' => 'Mensagem',
      'Create new Email Ticket' => 'Criar novo Bilhete via Correio Electrnico',
      'Phone-Ticket' => 'Telefonema',
      'Create new Phone Ticket' => 'Criar novo Bilhete via Telefone',
      'Search Tickets' => 'Procurar Bilhetes',
      'Edit Customer Users' => 'Editar Utilizadores Clientes',
      'Bulk-Action' => 'Em Lote',
      'Bulk Actions on Tickets' => 'Aces em Lote sobre Bilhetes',
      'Send Email and create a new Ticket' => 'Enviar mensagem e criar novo Bilhete',
      'Overview of all open Tickets' => 'Viso geral de todos os Bilhetes abertos',
      'Locked Tickets' => 'Bilhetes Bloqueados',
      'Lock it to work on it!' => 'Bloqueie-o para trabalhar nele!',
      'Unlock to give it back to the queue!' => 'Desbloqueie-o para o devolver  fila!',
      'Shows the ticket history!' => 'Mostra o histrico do bilhete!',
      'Print this ticket!' => 'Imprime o bilhete!',
      'Change the ticket priority!' => 'Muda a prioridade do bilhete!',
      'Change the ticket free fields!' => 'Alterar os campos livres do bilhete!',
      'Link this ticket to an other objects!' => 'Liga este bilhete a outros objectos!',
      'Change the ticket owner!' => 'Muda o proprietrio do bilhete!',
      'Change the ticket customer!' => 'Muda o cliente do bilhete!',
      'Add a note to this ticket!' => 'Acrescentar uma nota ao bilhete!',
      'Merge this ticket!' => 'Juntar este bilhete a outro!',
      'Set this ticket to pending!' => 'Tornar o bilhete pendente!',
      'Close this ticket!' => 'Fechar este bilhete!',
      'Look into a ticket!' => 'Ver um bilhete!',
      'Delete this ticket!' => 'Remover este bilhete!',
      'Mark as Spam!' => 'Marcar como Spam!',
      'My Queues' => 'As Minhas Filas',
      'Shown Tickets' => 'Mostrar Bilhetes',
      'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'A sua mensagem com o nmero de bilhete "<OTRS_TICKET>" foi junta a "<OTRS_MERGE_TO_TICKET>".',
      'New ticket notification' => 'Notificao de novo bilhete',
      'Send me a notification if there is a new ticket in "My Queues".' => 'Envie-me uma notificao se houver um novo bilhete nas "Minhas Filas".',
      'Follow up notification' => 'Notificao de seguimento',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Notifique-me se um cliente enviar um seguimento e eu for proprietrio deste bilhete.',
      'Ticket lock timeout notification' => 'Notificao por expirao do tempo de bloqueio',
      'Send me a notification if a ticket is unlocked by the system.' => 'Notifique-me se um bilhete for desbloqueado pelo sistema.',
      'Move notification' => 'Notificao de movimentos',
      'Send me a notification if a ticket is moved into one of "My Queues".' => 'Notifique-me se um bilhete for movido para uma das "Minhas Filas".',
      'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Seleco das suas filas favoritas. Ser notificado acerca destas filas via correio electrnico se o servio estiver activo.',
      'Custom Queue' => 'Fila Personalizada',
      'QueueView refresh time' => 'Tempo de refrescamento da Visualizao  de Filas',
      'Screen after new ticket' => 'Ecr aps novo bilhete',
      'Select your screen after creating a new ticket.' => 'Seleccionar ecr aps criao de novo bilhete.',
      'Closed Tickets' => 'Bilhetes Fechados',
      'Show closed tickets.' => 'Mostrar bilhetes fechados',
      'Max. shown Tickets a page in QueueView.' => 'Nmero mximo de bilhetes por pgina em Visualio de Filas',
      'CompanyTickets' => 'Bilhetes da Instituio',
      'MyTickets' => 'Meus Bilhetes',
      'New Ticket' => 'Novo Bilhete',
      'Create new Ticket' => 'Criar novo Bilhete',
      'Customer called' => 'O cliente telefonou',
      'phone call' => '',
      'Responses' => 'Respostas',
      'Responses <-> Queue' => 'Respostas <-> Filas',
      'Auto Responses' => 'Respostas Automticas',
      'Auto Responses <-> Queue' => 'Respostas Automticas <-> Filas',
      'Attachments <-> Responses' => 'Anexos <-> Respostas',
      'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
      'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
      'History::FollowUp' => 'FollowUp for [%s]. %s',
      'History::SendAutoReject' => 'AutoReject sent to "%s".',
      'History::SendAutoReply' => 'AutoReply sent to "%s".',
      'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
      'History::Forward' => 'Forwarded to "%s".',
      'History::Bounce' => 'Bounced to "%s".',
      'History::SendAnswer' => 'Email sent to "%s".',
      'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
      'History::SendCustomerNotification' => 'Notification sent to "%s".',
      'History::EmailAgent' => 'Email sent to customer.',
      'History::EmailCustomer' => 'Added email. %s',
      'History::PhoneCallAgent' => 'Agent called customer.',
      'History::PhoneCallCustomer' => 'Customer called us.',
      'History::AddNote' => 'Added note (%s)',
      'History::Lock' => 'Locked ticket.',
      'History::Unlock' => 'Unlocked ticket.',
      'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
      'History::Remove' => '%s',
      'History::CustomerUpdate' => 'Updated: %s',
      'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
      'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
      'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
      'History::Misc' => '%s',
      'History::SetPendingTime' => 'Updated: %s',
      'History::StateUpdate' => 'Old: "%s" New: "%s"',
      'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
      'History::WebRequestCustomer' => 'Customer request via web.',
      'History::TicketLinkAdd' => 'Added link to ticket "%s".',
      'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',

      # Template: AAAWeekDay
      'Sun' => 'domingo',
      'Mon' => 'segunda-feira',
      'Tue' => 'tera-feira',
      'Wed' => 'quarta-feira',
      'Thu' => 'quinta-feira',
      'Fri' => 'sexta-feira',
      'Sat' => 'sbado',

      # Template: AdminAttachmentForm
      'Attachment Management' => 'Gesto de Anexos',

      # Template: AdminAutoResponseForm
      'Auto Response Management' => 'Gesto de Respostas Automticas',
      'Response' => 'Resposta',
      'Auto Response From' => 'Resposta Automtica De',
      'Note' => 'Nota',
      'Useable options' => 'Opes acessveis',
      'to get the first 20 character of the subject' => 'para obter os 20 primeiros caracteres do assunto',
      'to get the first 5 lines of the email' => 'para obter as 5 primeiras linhas da mensagem de correio electrnico',
      'to get the from line of the email' => 'para obter a linha "De:" da mensagem',
      'to get the realname of the sender (if given)' => 'para obter o nome do remetente (se indicado na mensagem)',
      'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Opes dos dados do bilhete (e.g., &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Opes de Configurao (Ex. &lt;OTRS_CONFIG_HttpType&gt;)',

      # Template: AdminCustomerUserForm
      'The message being composed has been closed.  Exiting.' => 'A mensagem sendo composta foi fechada. Saindo.',
      'This window must be called from compose window' => 'Esta janela deve ser chamada da janela de composio',
      'Customer User Management' => 'Gesto de Utilizadores Clientes',
      'Search for' => 'Procurar por',
      'Result' => 'Resultado',
      'Select Source (for add)' => 'Seleccionar fonte (para a adio)',
      'Source' => 'Fonte',
      'This values are read only.' => 'Estes valores so apenas de leitura.',
      'This values are required.' => 'Estes valores so obrigatrios.',
      'Customer user will be needed to have a customer history and to login via customer panel.' => 'Utilizador cliente ter de ter um historial como cliente e de se autenticar via os paineis de cliente.',

      # Template: AdminCustomerUserGroupChangeForm
      'Customer Users <-> Groups Management' => '',
      'Change %s settings' => 'Modificar %s configuraes',
      'Select the user:group permissions.' => 'Seleccionar o utilizador:permisses de grupo.',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Se nada for seleccionado, ento no h permisses neste grupo (bilhetes no estaram disponveis para o utilizador).',
      'Permission' => 'Permisso',
      'ro' => 'leitura',
      'Read only access to the ticket in this group/queue.' => 'Acesso apenas de leitura para o bilhete neste grupo/fila.',
      'rw' => 'escrita',
      'Full read and write access to the tickets in this group/queue.' => 'Acesso total de leitura e escrita para os bilhetes neste grupo/queue.',

      # Template: AdminCustomerUserGroupForm

      # Template: AdminEmail
      'Message sent to' => 'Mensagem enviada para',
      'Recipents' => 'Destinatrios',
      'Body' => 'Corpo',
      'send' => 'enviar',

      # Template: AdminGenericAgent
      'GenericAgent' => 'Agente Genrico',
      'Job-List' => 'Lista de Tarefas',
      'Last run' => 'ltima execuo',
      'Run Now!' => 'Excutar Agora!',
      'x' => '',
      'Save Job as?' => 'Guardar Tarefa como?',
      'Is Job Valid?' => 'A Tarefa  Vlida?',
      'Is Job Valid' => 'A Tarefa  Vlida',
      'Schedule' => 'Agendamento',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Procura exaustiva no texto no artigo (ex: "autentic*" ou "*vido")',
      '(e. g. 10*5155 or 105658*)' => '(e.g., 10*5155 ou 105658*)',
      '(e. g. 234321)' => '(e.g., 234321)',
      'Customer User Login' => 'Nome de Utilizador de Cliente',
      '(e. g. U5150)' => '(e.g., mms ou jpps)',
      'Agent' => 'Agente',
      'Ticket Lock' => 'Bloqueio de Bilhete',
      'TicketFreeFields' => '',
      'Times' => 'Tempos',
      'No time settings.' => 'Sem definies de tempo.',
      'Ticket created' => 'Bilhete criado',
      'Ticket created between' => 'Bilhete criado entre',
      'New Priority' => 'Nova Prioridade',
      'New Queue' => 'Nova Fila',
      'New State' => 'Novo Estado',
      'New Agent' => 'Novo Agente',
      'New Owner' => 'Novo Proprietrio',
      'New Customer' => 'Novo Cliente',
      'New Ticket Lock' => 'Novo Bloqueio do Bilhete',
      'CustomerUser' => 'Utilizador Cliente',
      'New TicketFreeFields' => '',
      'Add Note' => 'Adicionar Nota',
      'CMD' => '',
      'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Este comando ser executado. ARG[0] ser o nmero do bilhete e ARG[1] o seu ID.',
      'Delete tickets' => 'Remover bilhetes',
      'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Aviso! Estes bilhetes sero removidos da base de dados! Sero perdidos!',
      'Send Notification' => '',
      'Param 1' => 'Parmetro 1',
      'Param 2' => 'Parmetro 2',
      'Param 3' => 'Parmetro 3',
      'Param 4' => 'Parmetro 4',
      'Param 5' => 'Parmetro 5',
      'Param 6' => 'Parmetro 6',
      'Send no notifications' => '',
      'Yes means, send no agent and customer notifications on changes.' => '',
      'No means, send agent and customer notifications on changes.' => '',
      'Save' => 'Guardar',
      '%s Tickets affected! Do you really want to use this job?' => '',

      # Template: AdminGroupForm
      'Group Management' => 'Gesto de Grupos',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'O grupo admin  para uso na rea de administrao e o grupo stats  para uso na rea de estatsticas.',
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crie novos grupos para manipular as permisses de acesso para diferentes grupos de agentes (e.g., departamento de compras, departamento de suporte, departamento de vendas, etc.).',
      'It\'s useful for ASP solutions.' => 'Isto  til para solues ASP.',

      # Template: AdminLog
      'System Log' => 'Registo do Sistema',
      'Time' => 'Tempo',

      # Template: AdminNavigationBar
      'Users' => 'Utilizadores',
      'Groups' => 'Grupos',
      'Misc' => 'Vrios',

      # Template: AdminNotificationForm
      'Notification Management' => 'Gesto de Notificao',
      'Notification' => 'Notificaes',
      'Notifications are sent to an agent or a customer.' => 'As notificaes so enviadas para um agente ou um cliente.',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opes do dono do bilhete',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opes do utilizador que requereu a aco (Ex. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Opoes do Cliente corrente (Ex. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
      'Options of the ticket data (e. g. &lt;OTRS_TICKET_TicketNumber&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',

      # Template: AdminPackageManager
      'Package Manager' => 'Gestor de Pacotes',
      'Uninstall' => 'Desinstalar',
      'Version' => 'Verso',
      'Do you really want to uninstall this package?' => 'Deseja mesmo desinstalar este pacote?',
      'Reinstall' => 'Reinstalar',
      'Do you really want to reinstall this package (all manual changes get lost)?' => '',
      'Install' => 'Instalar',
      'Package' => 'Pacote',
      'Online Repository' => 'Repositrio Em-linha',
      'Vendor' => 'Vendedor',
      'Upgrade' => 'Melhoria de Verso',
      'Local Repository' => 'Repositrio Local',
      'Status' => 'Estado',
      'Package not correctly deployed, you need to deploy it again!' => '',
      'Overview' => 'Viso Geral',
      'Download' => 'Descarregar',
      'Rebuild' => 'Reconstruir',
      'Download file from package!' => '',
      'Required' => '',
      'PrimaryKey' => '',
      'AutoIncrement' => '',
      'SQL' => '',
      'Diff' => '',

      # Template: AdminPerformanceLog
      'Performance Log' => '',
      'Logfile too large!' => '',
      'Logfile too large, you need to reset it!' => '',
      'Range' => '',
      'Interface' => '',
      'Requests' => '',
      'Min Response' => '',
      'Max Response' => '',
      'Average Response' => '',

      # Template: AdminPGPForm
      'PGP Management' => 'Gesto de PGP',
      'Identifier' => 'Identificador',
      'Bit' => '',
      'Key' => 'Chave',
      'Fingerprint' => 'Impresso Digital',
      'Expires' => 'Expira',
      'In this way you can directly edit the keyring configured in SysConfig.' => 'Desta forma pode editar directamente o anel de chaves configurado no SysConfig',

      # Template: AdminPOP3
      'POP3 Account Management' => 'Gesto de Contas POP3',
      'Host' => 'Anfitrio',
      'List' => '',
      'Trusted' => 'Confivel',
      'Dispatching' => 'Despachando',
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Todas as mensagens recebidas correspondentes a uma com uma conta sero despachados para a fila selecionada!',
      'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',

      # Template: AdminPostMasterFilter
      'PostMaster Filter Management' => 'Gesto de Filtros do Chefe do Correio',
      'Filtername' => 'Nome do Filtro',
      'Match' => 'Corresponde',
      'Header' => 'Cabealho',
      'Value' => 'Valor',
      'Set' => 'Coloca',
      'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Despachar ou filtrar mensagens recebidas de acordo com os seus Cabealhos-X! Pode-se usar expresses regulares.',
      'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Se usar expresses regulares, pode aceder ao valor emparelhado em () como [***] em \'Coloca\'.',

      # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Responses Management' => 'Fila <-> Gesto de Respostas Automticas',

      # Template: AdminQueueForm
      'Queue Management' => 'Gesto de Filas',
      'Sub-Queue of' => 'Subfila de',
      'Unlock timeout' => 'Tempo de desbloqueio',
      '0 = no unlock' => '0 = sem desbloqueio',
      'Escalation time' => 'Tempo de escalamento',
      '0 = no escalation' => '0 = sem escalamento',
      'Follow up Option' => 'Opo de Seguimento',
      'Ticket lock after a follow up' => 'Bloqueio do bilhete aps seguimento',
      'Systemaddress' => 'Endereo do Sistema',
      'Customer Move Notify' => 'Movimento de Cliente Notificado',
      'Customer State Notify' => 'Estado de Cliente Notificado',
      'Customer Owner Notify' => 'Proprietrio de Cliente Notificado',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Se um agente bloqueia um bilhete e no enviar uma resposta dentro deste tempo, o bilhete ser desbloqueado automaticamente, ficando visvel para todos os outros agentes.',
      'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Se um bilhete no for respondido dentro deste tempo, apenas os bilhetes com este tempo vencido sero exibidos.',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Se um bilhete estiver fechado e um cliente enviar um seguimento, ser bloqueado em nome do seu proprietrio.',
      'Will be the sender address of this queue for email answers.' => 'Ser o endereo de correio electrnico usado para respostas nesta fila.',
      'The salutation for email answers.' => 'A saudao das respostas de correio electrnico.',
      'The signature for email answers.' => 'A assinatura das respostas de correio electrnico.',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'O OTRS envia uma mensagem de notificao ao cliente se o bilhete for movido.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'O OTRS envia uma mensagem de notificao ao cliente se o estado do bilhete for alterado.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'O OTRS envia uma mensagem de notificao ao cliente se o proprietrio do bilhete for alterado.',

      # Template: AdminQueueResponsesChangeForm
      'Responses <-> Queue Management' => 'Respostas <-> Gesto de Filas',

      # Template: AdminQueueResponsesForm
      'Answer' => 'Resposta',

      # Template: AdminResponseAttachmentChangeForm
      'Responses <-> Attachments Management' => 'Respostas <-> Gesto de Anexos',

      # Template: AdminResponseAttachmentForm

      # Template: AdminResponseForm
      'Response Management' => 'Gesto de Respostas',
      'A response is default text to write faster answer (with default text) to customers.' => 'Uma resposta  um texto padro para compr respostas rpidas (com texto padro) para clientes.',
      'Don\'t forget to add a new response a queue!' => 'No se esquea de adicionar a nova resposta a uma fila!',
      'Next state' => 'Prximo estado',
      'All Customer variables like defined in config option CustomerUser.' => 'todas as variveis de Cliente tais como definidas na opo de configurao CustomerUser',
      'The current ticket state is' => 'O estado corrente do bilhete ',
      'Your email address is new' => 'O seu endereo de correio electrnico  novo',

      # Template: AdminRoleForm
      'Role Management' => 'Gesto de Papeis',
      'Create a role and put groups in it. Then add the role to the users.' => 'Criar um papel e atribuir-lhe grupos. Depois acrescentar o papel aos utilizadores.',
      'It\'s useful for a lot of users and groups.' => 'til para muitos utilizadores e grupos.',

      # Template: AdminRoleGroupChangeForm
      'Roles <-> Groups Management' => 'Papeis <-> Gesto de Grupos',
      'move_into' => 'mover para',
      'Permissions to move tickets into this group/queue.' => 'Permisses para mover bilhetes neste grupo/queue',
      'create' => 'criar',
      'Permissions to create tickets in this group/queue.' => 'Permisses para criar bilhetes neste grupo/queue',
      'owner' => 'dono',
      'Permissions to change the ticket owner in this group/queue.' => 'Permisses para modificar o dono do bilhete neste grupo/queue',
      'priority' => 'prioridade',
      'Permissions to change the ticket priority in this group/queue.' => 'Permisses para modificar a prioridade do bilhete neste grupo/queue',

      # Template: AdminRoleGroupForm
      'Role' => 'Papel',

      # Template: AdminRoleUserChangeForm
      'Roles <-> Users Management' => 'Papeis <-> Gesto de Utilizadores',
      'Active' => 'Activo',
      'Select the role:user relations.' => 'Seleccione as relaes papel:utilizador',

      # Template: AdminRoleUserForm

      # Template: AdminSalutationForm
      'Salutation Management' => 'Gesto de Saudaes',
      'customer realname' => 'nome do cliente',
      'All Agent variables.' => '',
      'for agent firstname' => 'para o nome prprio do agente',
      'for agent lastname' => 'para o apelido do agente',
      'for agent user id' => 'para o ID de utilizador do agente',
      'for agent login' => 'para o nome de utilizador do agente',

      # Template: AdminSelectBoxForm
      'Select Box' => 'Caixa de Seleco',
      'Limit' => 'Limite',
      'Select Box Result' => 'Selecione a Caixa de Resultado',

      # Template: AdminSession
      'Session Management' => 'Gesto de Sesses',
      'Sessions' => 'Sesses',
      'Uniq' => 'nico',
      'kill all sessions' => 'Finalizar todas as sesses',
      'Session' => 'Sesso',
      'Content' => 'Contedo',
      'kill session' => 'finalizar sesso',

      # Template: AdminSignatureForm
      'Signature Management' => 'Gesto de Assinaturas',

      # Template: AdminSMIMEForm
      'S/MIME Management' => '',
      'Add Certificate' => 'Adicionar Certificado',
      'Add Private Key' => 'Adicionar Chave Privada',
      'Secret' => 'Segredo',
      'Hash' => '',
      'In this way you can directly edit the certification and private keys in file system.' => 'Aqui pode editar directamente os certificados e chaves privadas presentes no sistema de ficheiros.',

      # Template: AdminStateForm
      'System State Management' => 'Gesto de Estados do Sistema',
      'State Type' => 'Estado Tipo',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Garanta que tambm actualisou os estados por omisso no seu Kernel/Config.pm!',
      'See also' => 'Ver tambm',

      # Template: AdminSysConfig
      'SysConfig' => 'Configurao do Sistema',
      'Group selection' => 'Seleco do grupo',
      'Show' => 'Mostrar',
      'Download Settings' => 'Descarregar Configurao',
      'Download all system config changes.' => 'Descarregar todas as alteraes da configurao do sistema.',
      'Load Settings' => 'Carregar Configurao',
      'Subgroup' => 'Subgrupo',
      'Elements' => 'Elementos',

      # Template: AdminSysConfigEdit
      'Config Options' => 'Opes de Configurao',
      'Default' => 'Por Omisso',
      'New' => 'Novo',
      'New Group' => 'Novo Grupo',
      'Group Ro' => '',
      'New Group Ro' => '',
      'NavBarName' => '',
      'NavBar' => '',
      'Image' => 'Imagem',
      'Prio' => '',
      'Block' => '',
      'AccessKey' => '',

      # Template: AdminSystemAddressForm
      'System Email Addresses Management' => 'Gesto dos Endereos de Correio Electrnico do Sistema',
      'Realname' => 'Nome',
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Todas mensagens recebidas com este destinatrio (Para:) sero despachados para a fila selecionada!',

      # Template: AdminUserForm
      'User Management' => 'Gesto de Utilizadores',
      'Login as' => 'Entrar como',
      'Firstname' => 'Nome',
      'Lastname' => 'Apelido',
      'User will be needed to handle tickets.' => ' necessrio um utilizador para manipular os bilhetes.',
      'Don\'t forget to add a new user to groups and/or roles!' => 'No se esquea de adicionar um novo utilizador a grupos e/ou papeis!',

      # Template: AdminUserGroupChangeForm
      'Users <-> Groups Management' => 'Utilizadores <-> Gesto de Grupos',

      # Template: AdminUserGroupForm

      # Template: AgentBook
      'Address Book' => 'Lista de Endereos',
      'Return to the compose screen' => 'Retornar para o ecr de composio',
      'Discard all changes and return to the compose screen' => 'Descartar todas as modificaes e retornar para o ecr de composio',

      # Template: AgentCalendarSmall

      # Template: AgentCalendarSmallIcon

      # Template: AgentCustomerTableView

      # Template: AgentInfo
      'Info' => 'Informao',

      # Template: AgentLinkObject
      'Link Object' => 'Ligar Objecto',
      'Select' => 'Seleccionar',
      'Results' => 'Resultados',
      'Total hits' => 'Total de acertos',
      'Page' => 'Pgina',
      'Detail' => 'Pormenor',

      # Template: AgentLookup
      'Lookup' => 'Procura',

      # Template: AgentNavigationBar
      'Ticket selected for bulk action!' => 'Bilhete seleccionado para aco em lote!',
      'You need min. one selected Ticket!' => 'Precisa de seleccionar pelo menos um Bilhete!',

      # Template: AgentPreferencesForm

      # Template: AgentSpelling
      'Spell Checker' => 'Verificador Ortogrfico',
      'spelling error(s)' => 'erro(s) ortogrfico(s)',
      'or' => 'ou',
      'Apply these changes' => 'Aplicar estas modificaes',

      # Template: AgentStatsDelete
      'Do you really want to delete this Object?' => 'Deseja realmente remover este Objecto?',

      # Template: AgentStatsEditRestrictions
      'Select the restrictions to characterise the stat' => '',
      'Fixed' => '',
      'Please select only one Element or turn of the button \'Fixed\'.' => '',
      'Absolut Period' => '',
      'Between' => '',
      'Relative Period' => '',
      'The last' => '',
      'Finish' => '',
      'Here you can make restrictions to your stat.' => '',
      'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributs of the corresponding element.' => '',

      # Template: AgentStatsEditSpecification
      'Insert of the common specifications' => '',
      'Permissions' => '',
      'Format' => 'Formato',
      'Graphsize' => '',
      'Sum rows' => '',
      'Sum columns' => '',
      'Cache' => '',
      'Required Field' => '',
      'Selection needed' => '',
      'Explanation' => '',
      'In this form you can select the basic specifications.' => '',
      'Attribute' => '',
      'Title of the stat.' => '',
      'Here you can insert a description of the stat.' => '',
      'Dynamic-Object' => '',
      'Here you can select the dynamic object you want to use.' => '',
      '(Note: It depends on your installation how many dynamic objects you can use)' => '',
      'Static-File' => '',
      'For very complex stats it is possible to include a hardcoded file.' => '',
      'If a new hardcoded file is available this attribute will be shown and you can select one.' => '',
      'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => '',
      'Multiple selection of the output format.' => '',
      'If you use a graph as output format you have to select at least one graph size.' => '',
      'If you need the sum of every row select yes' => '',
      'If you need the sum of every column select yes.' => '',
      'Most of the stats can be cached. This will speed up the presentation of this stat.' => '',
      '(Note: Useful for big databases and low performance server)' => '',
      'With an invalid stat it isn\'t feasible to generate a stat.' => '',
      'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => '',

      # Template: AgentStatsEditValueSeries
      'Select the elements for the value series' => '',
      'Scale' => '',
      'minimal' => '',
      'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => '',
      'Here you can the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

      # Template: AgentStatsEditXaxis
      'Select the element, which will be used at the X-axis' => '',
      'maximal period' => '',
      'minimal scale' => '',
      'Here you can define the x-axis. You can select one element via the radio button. Than you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

      # Template: AgentStatsImport
      'Import' => '',
      'File is not a Stats config' => '',
      'No File selected' => '',

      # Template: AgentStatsOverview
      'Object' => '',

      # Template: AgentStatsPrint
      'Print' => 'Imprimir',
      'No Element selected.' => '',

      # Template: AgentStatsView
      'Export Config' => '',
      'Informations about the Stat' => '',
      'Exchange Axis' => '',
      'Configurable params of static stat' => '',
      'No element selected.' => '',
      'maximal period form' => '',
      'to' => '',
      'Start' => 'Incio',
      'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => '',

      # Template: AgentTicketBounce
      'A message should have a To: recipient!' => 'Uma mensagem deve possuir um Para: destinatrio!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Precisa de um endereo de correio electrnico (e.g., cliente@exemplo.pt) no Para:!',
      'Bounce ticket' => 'Devolver bilhete',
      'Bounce to' => 'Devolver para',
      'Next ticket state' => 'Prximo estado do bilhete',
      'Inform sender' => 'Informe o remetente',
      'Send mail!' => 'Enviar mensagem de correio electrnico!',

      # Template: AgentTicketBulk
      'A message should have a subject!' => 'A mensagem deve conter um assunto!',
      'Ticket Bulk Action' => 'Aco sobre Lote de Bilhetes',
      'Spell Check' => 'Verificar Ortografia',
      'Note type' => 'Tipo de nota',
      'Unlock Tickets' => 'Desbloquear Bilhetes',

      # Template: AgentTicketClose
      'A message should have a body!' => 'A mensagem deve conter um texto!',
      'You need to account time!' => ' necessrio o tempo dispendido',
      'Close ticket' => 'Fechar bilhete',
      'Ticket locked!' => 'Bilhete bloqueado!',
      'Ticket unlock!' => 'Bilhete desbloqueado!',
      'Previous Owner' => 'Proprietrio Anterior',
      'Inform Agent' => '',
      'Optional' => '',
      'Inform involved Agents' => '',
      'Attach' => 'Anexo',
      'Pending date' => 'Data da pendncia',
      'Time units' => 'Unidades de tempo',

      # Template: AgentTicketCompose
      'A message must be spell checked!' => 'Tem de verificar a ortografia da mensagem!',
      'Compose answer for ticket' => 'Compor uma resposta para o bilhete',
      'Pending Date' => 'Prazo de pendncia',
      'for pending* states' => 'para os estados "pendente ..."',

      # Template: AgentTicketCustomer
      'Change customer of ticket' => 'Modificar o cliente do bilhete',
      'Set customer user and customer id of a ticket' => 'Atribua o nome de utilizador e o ID do cliente do bilhete',
      'Customer User' => 'Nome de Utilizador do Cliente',
      'Search Customer' => 'Procurar Cliente',
      'Customer Data' => 'Dados do Cliente',
      'Customer history' => 'Histrico do cliente',
      'All customer tickets.' => 'Todos os bilhetes do cliente.',

      # Template: AgentTicketCustomerMessage
      'Follow up' => 'Seguimento',

      # Template: AgentTicketEmail
      'Compose Email' => 'Compor Mensagem de Correio Electrnico',
      'new ticket' => 'novo bilhete',
      'Refresh' => '',
      'Clear To' => '',
      'All Agents' => 'Todos os Agentes',

      # Template: AgentTicketForward
      'Article type' => 'Tipo de artigo',

      # Template: AgentTicketFreeText
      'Change free text of ticket' => 'Alterar Texto livre do bilhete',

      # Template: AgentTicketHistory
      'History of' => 'Histrico de',

      # Template: AgentTicketLocked

      # Template: AgentTicketMailbox
      'Mailbox' => 'Caixa de Entrada',
      'Tickets' => 'Bilhetes',
      'of' => 'de',
      'Filter' => '',
      'All messages' => 'Todas as mensagens',
      'New messages' => 'Mensagens novas',
      'Pending messages' => 'Mensagens pendentes',
      'Reminder messages' => 'Mensagens com lembretes',
      'Reminder' => 'Lembretes',
      'Sort by' => 'Ordenado pela',
      'Order' => 'Ordem',
      'up' => 'crescente',
      'down' => 'decrescente',

      # Template: AgentTicketMerge
      'You need to use a ticket number!' => '',
      'Ticket Merge' => 'Juntar Bilhete',
      'Merge to' => 'Juntar a',

      # Template: AgentTicketMove
      'Move Ticket' => 'Mover Bilhete',

      # Template: AgentTicketNote
      'Add note to ticket' => 'Adicionar nota ao bilhete',

      # Template: AgentTicketOwner
      'Change owner of ticket' => 'Modificar o proprietrio do bilhete',

      # Template: AgentTicketPending
      'Set Pending' => 'Definir como Pendente',

      # Template: AgentTicketPhone
      'Phone call' => 'Chamada telefnica',
      'Clear From' => 'Limpar De',
      'Create' => 'Criar',

      # Template: AgentTicketPhoneOutbound

      # Template: AgentTicketPlain
      'Plain' => 'Verbatim',
      'TicketID' => 'ID de Bilhete',
      'ArticleID' => 'ID de Artigo',

      # Template: AgentTicketPrint
      'Ticket-Info' => 'Informao de Bilhete',
      'Accounted time' => 'Tempo contabilizado',
      'Escalation in' => 'Escalado em',
      'Linked-Object' => 'Objecto-Ligado',
      'Parent-Object' => 'Objecto-Ascendente',
      'Child-Object' => 'Objecto-Descendente',
      'by' => 'por',

      # Template: AgentTicketPriority
      'Change priority of ticket' => 'Modificar a prioridade do bilhete',

      # Template: AgentTicketQueue
      'Tickets shown' => 'Bilhetes mostrados',
      'Tickets available' => 'Bilhetes disponveis',
      'All tickets' => 'Todos os bilhetes',
      'Queues' => 'Filas',
      'Ticket escalation!' => 'Escalamento de bilhetes!',

      # Template: AgentTicketQueueTicketView
      'Your own Ticket' => 'O seu Bilhete',
      'Compose Follow up' => 'Compor Seguimento',
      'Compose Answer' => 'Compor resposta',
      'Contact customer' => 'Contactar o cliente',
      'Change queue' => 'Modificar a fila',

      # Template: AgentTicketQueueTicketViewLite

      # Template: AgentTicketResponsible
      'Change responsible of ticket' => '',

      # Template: AgentTicketSearch
      'Ticket Search' => 'Procura de Bilhetes',
      'Profile' => 'Perfil',
      'Search-Template' => 'Modelo de procura',
      'TicketFreeText' => 'Texto Livre do Bilhete',
      'Created in Queue' => 'Criado na Fila',
      'Result Form' => 'Formato do resultado',
      'Save Search-Profile as Template?' => 'Guardar Perfil de Procura como Modelo?',
      'Yes, save it with name' => 'Sim, guardar com o nome',

      # Template: AgentTicketSearchResult
      'Search Result' => 'Resultado de Procura',
      'Change search options' => 'Alterar opes de procura',

      # Template: AgentTicketSearchResultPrint

      # Template: AgentTicketSearchResultShort
      'sort upward' => 'ordenar crescentemente',
      'U' => 'C',
      'sort downward' => 'ordenar decrescentemente',
      'D' => '',

      # Template: AgentTicketStatusView
      'Ticket Status View' => 'Visualizao do Estado dos Bilhetes',
      'Open Tickets' => 'Bilhetes Abertos',

      # Template: AgentTicketZoom
      'Locked' => 'Bloqueado',
      'Split' => 'Dividir',

      # Template: AgentWindowTab

      # Template: AgentWindowTabStart

      # Template: AgentWindowTabStop

      # Template: Copyright

      # Template: css

      # Template: customer-css

      # Template: CustomerAccept

      # Template: CustomerCalendarSmallIcon

      # Template: CustomerError
      'Traceback' => 'Retroceder',

      # Template: CustomerFooter
      'Powered by' => 'Produzido por',

      # Template: CustomerFooterSmall

      # Template: CustomerHeader

      # Template: CustomerHeaderSmall

      # Template: CustomerLogin
      'Login' => 'Autenticao',
      'Lost your password?' => 'Esqueceu a palavra-passe?',
      'Request new password' => 'Solicitar nova palavra-passe',
      'Create Account' => 'Criar Conta',

      # Template: CustomerNavigationBar
      'Welcome %s' => 'Bem-vindo, %s',

      # Template: CustomerPreferencesForm

      # Template: CustomerStatusView

      # Template: CustomerTicketMessage

      # Template: CustomerTicketSearch

      # Template: CustomerTicketSearchResultCSV

      # Template: CustomerTicketSearchResultPrint

      # Template: CustomerTicketSearchResultShort

      # Template: CustomerTicketZoom

      # Template: CustomerWarning

      # Template: Error
      'Click here to report a bug!' => 'Clique aqui para reportar um erro!',

      # Template: Footer
      'Top of Page' => 'Topo da Pgina',

      # Template: FooterSmall

      # Template: Header
      'Home' => 'Incio',

      # Template: HeaderSmall

      # Template: Installer
      'Web-Installer' => 'Instalador Web',
      'accept license' => 'aceitar licena',
      'don\'t accept license' => 'no aceitar licena',
      'Admin-User' => 'Utilizador de Admin',
      'Admin-Password' => '',
      'your MySQL DB should have a root password! Default is empty!' => 'a sua Base de Dados MySQL deve ter uma palavra-passe de administrao! Por omisso ela est vazia!',
      'Database-User' => 'Utilizador da Base de Dados',
      'default \'hot\'' => 'por omisso \'hot\'',
      'DB connect host' => 'Anfitrio para ligaes  Base de Dados',
      'Database' => 'Base de dados',
      'false' => 'falso',
      'SystemID' => 'ID do sistema',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(A identidade do sistema. Cada nmero de bilhete e cada id. da sesso http, inicia com este nmero)',
      'System FQDN' => 'FQDN do sistema',
      '(Full qualified domain name of your system)' => '(Nome de domnio totalmente qualificado do seu sistema)',
      'AdminEmail' => 'Correio Electrnico do Administrador',
      '(Email of the system admin)' => '(Endereo de correio electrnico do administrador do sistema)',
      'Organization' => 'Organizao',
      'Log' => 'Registo',
      'LogModule' => 'Mdulo de Registos',
      '(Used log backend)' => '(Usei o sistema de registos)',
      'Logfile' => 'Ficheiro de Log',
      '(Logfile just needed for File-LogModule!)' => '(Ficheiro de registo para File-LogModule)',
      'Webfrontend' => 'Interface Web',
      'Default Charset' => 'Codificao por Omisso',
      'Use utf-8 it your database supports it!' => 'Usar UTF-8 se a base de dados o suportar',
      'Default Language' => 'Idioma por Omisso',
      '(Used default language)' => '(Idioma por omisso utilizado)',
      'CheckMXRecord' => 'Verificar registo MX',
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Verifica os registos MX dos endereos de correio electrnico usados quando compe uma resposta. No usar caso esteja a usar uma ligao telefnica!)',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Para usar o OTRS tem de dar o seguinte comando no seu Terminal/Consola, como administrador.',
      'Restart your webserver' => 'Reinicie o seu servidor Web',
      'After doing so your OTRS is up and running.' => 'Depois de o fazer, o seu OTRS estar funcional.',
      'Start page' => 'Pgina inicial',
      'Have a lot of fun!' => 'Divirta-se!',
      'Your OTRS Team' => 'A sua Equipa OTRS',

      # Template: Login
      'Welcome to %s' => '',

      # Template: Motd

      # Template: NoPermission
      'No Permission' => 'Sem Autorizao',

      # Template: Notify
      'Important' => 'Importante',

      # Template: PrintFooter
      'URL' => '',

      # Template: PrintHeader
      'printed by' => 'impresso por',

      # Template: Redirect

      # Template: Test
      'OTRS Test Page' => 'Pgina de Teste do OTRS',
      'Counter' => 'Contador',

      # Template: Warning
      # Misc
      'OTRS DB connect host' => 'Servidor de ligao da Base de Dados OTRS',
      'Create Database' => 'Criar Base de Dados',
      'End' => 'Fim',
      ' (work units)' => ' (unidades de trabalho)',
      'DB Host' => 'Servidor Base de Dados',
      'Multiplier:' => 'Multiplicador:',
      'Ticket Number Generator' => 'Gerador de Nmeros de Bilhetes',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identificao do bilhete. Algumas pessoas usam \'Bilhete#\', \'Chamada#\' or \'MeuBilhete#\')',
      'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => '',
      'Symptom' => 'Sintoma',
      'Site' => 'Pgina',
      'If your account is trusted, the already existing x-otrs header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Se a sua conta for acreditada, cabealhos X-OTRS existentes  chegada (para prioridade, etc.) sero usados! O filtro do Chefe do Correio ser sempre usado, no entanto.',
      'Customer history search (e. g. "ID342425").' => 'Procura no histrico do cliente (e.g., "ID342425")',
      'Ticket Hook' => 'Identificador do Bilhete',
      'Close!' => 'Fechar!',
      'TicketZoom' => 'DetalhesDoBilhete',
      'Don\'t forget to add a new user to groups!' => 'No esquea de adicionar um novo user nos grupos!',
      'OTRS DB Name' => 'Nome da Base de Dados OTRS',
      'PGP Key' => 'Chave PGP',
      'System Settings' => 'Propriedades de Sistema',
      'Finished' => 'Terminado',
      'System Status' => 'Estado do Sistema',
      'Queue ID' => 'ID da Queue',
      'A article should have a title!' => 'Um artigo tem de ter um ttulo!',
      'System History' => 'Histrico do Sistema',
      'Benchmark' => 'Desempenho',
      'Update:' => 'Actualizar:',
      'Modules' => 'Mdulos',
      'PGP Key Upload' => 'Carregamento de Chave PGP',
      'Keyword' => 'Palavra-chave',
      'with' => 'a',
      'Close type' => 'Tipo de fecho',
      'DB Admin User' => 'Utilizador Admin da Base de Dados',
      'Options of the ticket data (e. g. &lt;OTRS_TICKET_TicketNumber&gt;, &lt;OTRS_TICKET_TicketID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',
      'Change user <-> group settings' => 'Modificar users <-> configuraes de grupos',
      'Name is required!' => ' necessrio um nome!',
      'Problem' => 'Problema',
      'DB Type' => 'Tipo da Base de Dados',
      'next step' => 'prximo passo',
      'Termin1' => '',
      'Customer history search' => 'Procura no histrico do cliente',
      'Solution' => 'Soluo',
      'Admin-Email' => 'Endereo de Correio Electrnico do Administrador',
      'OTRS-Admin Info!' => 'Informao do Administrador OTRS!',
      'Requests:' => 'Pedidos:',
      'QueueView' => 'Filas',
      'SMIME Certificate Upload' => 'Carregamento de Certificado SMIME',
      'Create new database' => 'Criar nova base de dados',
      'SMIME Certificate' => 'Certificado SMIME',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Seu email com o nmero de bilhete "<OTRS_TICKET>" foi devolvido para "<OTRS_BOUNCE_TO>". Contate este endereo para mais informaes.',
      'Delete old database' => 'Eliminar base de dados antiga',
      'Ticket %s locked.' => 'Bilhete %s bloqueado.',
      'Keywords' => 'Palavras-chave',
      'Note Text' => 'Nota',
      'Select:' => 'Seleccionar:',
      'No * possible!' => 'No so possveis *!',
      'Insert:' => 'Inserir:',
      'Security Note: You should activate %s because applications is already running!' => 'Nota de Segurana: Deve activar o %s, pois a aplicao est j em produo!',
      'PostMaster Filter' => 'Filtros do Chefe do Correio',
      'OTRS DB User' => 'Utilizador de Base de Dados OTRS',
      'PhoneView' => 'Visualizao de Chamada',
      'PostMaster POP3 Account' => 'Conta do Chefe do Correio',
      'Verion' => 'Verso',
      'Message for new Owner' => 'Mensagem para o novo Proprietrio',
      'merged' => 'junto',
      'OTRS DB Password' => 'Palavra-passe da Base de Dados OTRS',
      'Last update' => 'ltima actualizao',
      'Sorry, feature not active!' => 'Lamentamos, caracterstica no activa!',
      'DB Admin Password' => 'Palavra-passe de Administrador da Base de Dados',
      'Drop Database' => 'Apagar Base de Dados',
      'Pending type' => 'Tipo de pendncia',
      'Comment (internal)' => 'Comentrio (interno)',
      'SMIME Management' => 'Gesto de SMIME',
      'Note!' => 'Nota!',
      '(Used ticket number format)' => '(Formato de nmero de bilhete utilizado)',
      'Fulltext' => 'Texto completo',
      'Modified' => 'Modificado',
      'Ticket\#' => 'N de Bilhete',
    };
    # $$STOP$$
}

1;

