# --
# Kernel/Language/pt_BR.pm - provides pt_BR language translation
# Copyright (C) 2003 Gilberto Cezar de Almeida <gibalmeida at hotmail.com>
# Copyright (C) 2005 Alterado por Glaucia C. Messina (glauglauu@yahoo.com)
# Copyright (C) 2007-2010 Fabricio Luiz Machado <soprobr gmail.com>
# --
# $Id: pt_BR.pm,v 1.89.2.8 2011/03/23 12:49:30 mg Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::pt_BR;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.89.2.8 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Sat May 21 12:47:50 2010

    # possible charsets
    $Self->{Charset} = ['UTF-8', 'iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%D/%M/%Y %T';
    $Self->{DateFormatLong}      = '%A %D %B %T %Y';
    $Self->{DateFormatShort}     = '%D/%M/%Y';
    $Self->{DateInputFormat}     = '%D/%M/%Y';
    $Self->{DateInputFormatLong} = '%D/%M/%Y - %T';
    $Self->{Separator}           = ';';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Sim',
        'No' => 'No',
        'yes' => 'sim',
        'no' => 'no',
        'Off' => 'Desligado',
        'off' => 'desligado',
        'On' => 'Ligado',
        'on' => 'ligado',
        'top' => 'incio',
        'end' => 'fim',
        'Done' => 'Feito',
        'Cancel' => 'Cancelar',
        'Reset' => 'Reiniciar',
        'last' => 'ltimo',
        'before' => 'antes',
        'day' => 'dia',
        'days' => 'dias',
        'day(s)' => 'dia(s)',
        'hour' => 'hora',
        'hours' => 'horas',
        'hour(s)' => 'hora(s)',
        'minute' => 'minuto',
        'minutes' => 'minutos',
        'minute(s)' => 'minuto(s)',
        'month' => 'ms',
        'months' => 'meses',
        'month(s)' => 'ms(s)',
        'week' => 'semana',
        'week(s)' => 'semana(s)',
        'year' => 'ano',
        'years' => 'anos',
        'year(s)' => 'ano(s)',
        'second(s)' => 'segundo(s)',
        'seconds' => 'segundos',
        'second' => 'segundo',
        'wrote' => 'escreveu',
        'Message' => 'Mensagem',
        'Error' => 'Erro',
        'Bug Report' => 'Relatrio de Erros',
        'Attention' => 'Ateno',
        'Warning' => 'Aviso',
        'Module' => 'Mdulo',
        'Modulefile' => 'Arquivo de Mdulo',
        'Subfunction' => 'Subfuno',
        'Line' => 'Linha',
        'Setting' => 'Configurao',
        'Settings' => 'Configuraes',
        'Example' => 'Exemplo',
        'Examples' => 'Exemplos',
        'valid' => 'Vlido',
        'invalid' => 'Invlido',
        '* invalid' => '* invlido',
        'invalid-temporarily' => 'Invlido-temporariamente',
        ' 2 minutes' => ' 2 minutos',
        ' 5 minutes' => ' 5 minutos',
        ' 7 minutes' => ' 7 minutos',
        '10 minutes' => '10 minutos',
        '15 minutes' => '15 minutos',
        'Mr.' => 'Sr.',
        'Mrs.' => 'Sra.',
        'Next' => 'Prximo',
        'Back' => 'Voltar',
        'Next...' => 'Prximo',
        '...Back' => '...Voltar',
        '-none-' => '-vazio-',
        'none' => 'Vazio',
        'none!' => 'Vazio!',
        'none - answered' => 'vazio  - respondido',
        'please do not edit!' => 'Por favor, no edite!',
        'AddLink' => 'Adicionar associao',
        'Link' => 'Associar',
        'Unlink' => 'Desassociar',
        'Linked' => 'Associado',
        'Link (Normal)' => 'Associao (Normal)',
        'Link (Parent)' => 'Associao (Pai)',
        'Link (Child)' => 'Associao (Filho)',
        'Normal' => '',
        'Parent' => 'Pai',
        'Child' => 'Filho',
        'Hit' => 'Acesso',
        'Hits' => 'Acessos',
        'Text' => 'Texto',
        'Lite' => 'Simples',
        'User' => 'Usurio',
        'Username' => 'Login',
        'Language' => 'Idioma',
        'Languages' => 'Idiomas',
        'Password' => 'Senha',
        'Salutation' => 'Tratamento (Sr./Sra.)',
        'Signature' => 'Assinatura',
        'Customer' => 'Cliente',
        'CustomerID' => 'ID. do Cliente',
        'CustomerIDs' => 'IDs do Cliente',
        'customer' => 'Cliente',
        'agent' => 'Atendente',
        'system' => 'Sistema',
        'Customer Info' => 'Informao do Cliente',
        'Customer Company' => 'Empresa de Clientes',
        'Company' => 'Empresa',
        'go!' => 'ir!',
        'go' => 'ir',
        'All' => 'Todas',
        'all' => 'todas',
        'Sorry' => 'Desculpe',
        'update!' => 'atualizar!',
        'update' => 'atualizar',
        'Update' => 'Atualizar',
        'Updated!' => 'Atualizado!',
        'submit!' => 'Enviar!',
        'submit' => 'enviar',
        'Submit' => 'Enviar',
        'change!' => 'alterar!',
        'Change' => 'Alterar',
        'change' => 'alterar',
        'click here' => 'clique aqui',
        'Comment' => 'Comentrio',
        'Valid' => 'Vlido',
        'Invalid Option!' => 'Opo Invlida',
        'Invalid time!' => 'Hora Invlida',
        'Invalid date!' => 'Data Invlida',
        'Name' => 'Nome',
        'Group' => 'Grupo',
        'Description' => 'Descrio',
        'description' => 'descrio',
        'Theme' => 'Tema',
        'Created' => 'Criado',
        'Created by' => 'Criado por',
        'Changed' => 'Alterado',
        'Changed by' => 'Alterado por',
        'Search' => 'Procurar',
        'and' => 'e',
        'between' => 'entre',
        'Fulltext Search' => 'Busca por texto completo',
        'Data' => 'Dado',
        'Options' => 'Opes',
        'Title' => 'Ttulo',
        'Item' => '',
        'Delete' => 'Excluir',
        'Edit' => 'Editar',
        'View' => 'Ver',
        'Number' => 'Nmero',
        'System' => 'Sistema',
        'Contact' => 'Contato',
        'Contacts' => 'Contatos',
        'Export' => 'Exportar',
        'Up' => 'Acima',
        'Down' => 'Abaixo',
        'Add' => 'Adicionar',
        'Added!' => 'Adicionado!',
        'Category' => 'Categoria',
        'Viewer' => 'Visualizao',
        'Expand' => 'Expandir',
        'Small' => 'Pequeno',
        'Medium' => 'Mdio',
        'Large' => 'Grande',
        'New message' => 'Nova mensagem',
        'New message!' => 'Nova mensagem!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Por favor, responda esta(s) solicitao(s) para retornar a fila!',
        'You got new message!' => 'Voc recebeu uma nova mensagem',
        'You have %s new message(s)!' => 'Voc tem %s nova(s) mensagem(s)!',
        'You have %s reminder ticket(s)!' => 'Voc tem %s solicitao(s) remanescente(s)',
        'The recommended charset for your language is %s!' => 'O conjunto de caracteres recomendado para o seu idioma  %s!',
        'Passwords doesn\'t match! Please try it again!' => 'Senhas no so equivalentes! Tente novamente!',
        'Password is already in use! Please use an other password!' => 'Senha em uso! Tente outra senha!',
        'Password is already used! Please use an other password!' => 'Senha est sendo utilizada! Tente outra senha!',
        'You need to activate %s first to use it!' => 'Primeiramente ative %s, para uso!',
        'No suggestions' => 'Sem sugestes',
        'Word' => 'Palavra',
        'Ignore' => 'Ignorar',
        'replace with' => 'substituir por',
        'There is no account with that login name.' => 'No existe conta com este nome de usurio',
        'Login failed! Your username or password was entered incorrectly.' => 'Login incorreto! Seu login ou senha foram informados incorretamente.',
        'Please contact your admin' => 'Por favor, contate administrador do sistema!',
        'Logout successful. Thank you for using OTRS!' => 'Encerrado com sucesso. Obrigado por utilizar nosso gerenciador de solicitaes!',
        'Invalid SessionID!' => 'Identificao de Sesso Invlida',
        'Feature not active!' => 'Funcionalidade no ativada!',
        'Notification (Event)' => 'Noticao (Evento)',
        'Login is needed!' => '',
        'Password is needed!' => 'Senha  obrigatria!',
        'License' => 'Licena',
        'Take this Customer' => 'Atenda este Cliente',
        'Take this User' => 'Atenda este Usurio',
        'possible' => 'possvel',
        'reject' => 'rejeitar',
        'reverse' => 'reverso',
        'Facility' => 'Facilidade',
        'Timeover' => 'Tempo esgotado',
        'Pending till' => 'Pendente at',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'No trabalhe com o UserID 1(Conta do Sistema)! Crie novos usurios!',
        'Dispatching by email To: field.' => 'Despachar pelo PARA:  email',
        'Dispatching by selected Queue.' => 'Despachar pela fila selecionada',
        'No entry found!' => 'No h entradas!',
        'Session has timed out. Please log in again.' => 'Tempo esgotado de sesso. Entre novamente.',
        'No Permission!' => 'Sem permisso!',
        'To: (%s) replaced with database email!' => 'PARA: (%s) alterado!',
        'Cc: (%s) added database email!' => 'CC: (%s) adicionado! ',
        '(Click here to add)' => '(Clique aqui para adicionar)',
        'Preview' => 'Pr-visualizar',
        'Package not correctly deployed! You should reinstall the Package again!' => 'O pacote no foi instalado coretamente! Voc deve reinstal-lo!',
        'Added User "%s"' => 'Usurio Adicionado "%s"',
        'Contract' => 'Contrato',
        'Online Customer: %s' => 'Clientes Online: %s',
        'Online Agent: %s' => 'Atendentes Online: %s',
        'Calendar' => 'Calendrio',
        'File' => 'Arquivo',
        'Filename' => 'Nome do arquivo',
        'Type' => 'Tipo',
        'Size' => 'Tam',
        'Upload' => '',
        'Directory' => 'Diretrio',
        'Signed' => 'Assinado',
        'Sign' => 'Assinar',
        'Crypted' => 'Criptografado',
        'Crypt' => 'Criptografar',
        'Office' => 'Escritrio',
        'Phone' => 'Telefone',
        'Fax' => '',
        'Mobile' => 'Celular',
        'Zip' => 'CEP',
        'City' => 'Cidade',
        'Street' => 'Rua',
        'Country' => 'Pas',
        'Location' => 'Locao',
        'installed' => 'instalado',
        'uninstalled' => 'desinstalado',
        'Security Note: You should activate %s because application is already running!' => '',
        'Unable to parse Online Repository index document!' => '',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => '',
        'No Packages or no new Packages in selected Online Repository!' => '',
        'printed at' => 'impresso em',
        'Dear Mr. %s,' => 'Caro Sr. %s,',
        'Dear Mrs. %s,' => 'Cara Sra. %s,',
        'Dear %s,' => 'Caro %s,',
        'Hello %s,' => 'Ol %s,',
        'This account exists.' => 'Esta conta existe.',
        'New account created. Sent Login-Account to %s.' => 'Nova conta criada. Enviado Login para %s.',
        'Please press Back and try again.' => 'Por favor, pressione Voltar e tente novamente.',
        'Sent password token to: %s' => 'Enviado token de senha para: %s',
        'Sent new password to: %s' => 'Enviada nova senha para: %s',
        'Upcoming Events' => 'Prximos Eventos',
        'Event' => 'Evento',
        'Events' => 'Eventos',
        'Invalid Token!' => 'Token Invlido!',
        'more' => 'mais',
        'For more info see:' => 'Para mais informaes acesse',
        'Package verification failed!' => 'A verificao do pacote falhou!',
        'Collapse' => 'Recolher',
        'News' => 'Notcias',
        'Product News' => 'Notcias do Produto',
        'OTRS News' => 'Notcias sobre o OTRS',
        '7 Day Stats' => 'Estatsticas (7 Dias)',
        'Bold' => 'Negrito',
        'Italic' => 'Itlico',
        'Underline' => 'Sublinhado',
        'Font Color' => 'Cor da Fonte',
        'Background Color' => 'Cor do Plano de Fundo',
        'Remove Formatting' => 'Remover Formatao',
        'Show/Hide Hidden Elements' => 'Mostrar/Esconder Formatao',
        'Align Left' => 'Alinhar  Esquerda',
        'Align Center' => 'Centralizado',
        'Align Right' => 'Alinhar  Direita',
        'Justify' => 'Justificado',
        'Header' => 'Cabealho',
        'Indent' => 'Aumentar Recuo',
        'Outdent' => 'Diminuir Recuo',
        'Create an Unordered List' => 'Criar uma lista sem ordenao',
        'Create an Ordered List' => 'Criar uma lista ordenada',
        'HTML Link' => 'Hiperlink',
        'Insert Image' => 'Inserir Imagem',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => 'Desfazer',
        'Redo' => 'Refazer',

        # Template: AAAMonth
        'Jan' => '',
        'Feb' => 'Fev',
        'Mar' => '',
        'Apr' => 'Abr',
        'May' => 'Mai',
        'Jun' => '',
        'Jul' => '',
        'Aug' => 'Ago',
        'Sep' => 'Set',
        'Oct' => 'Out',
        'Nov' => '',
        'Dec' => 'Dez',
        'January' => 'Janeiro',
        'February' => 'Fevereiro',
        'March' => 'Maro',
        'April' => 'Abril',
        'May_long' => 'Maio',
        'June' => 'Junho',
        'July' => 'Julho',
        'August' => 'Agosto',
        'September' => 'Setembro',
        'October' => 'Outubro',
        'November' => 'Novembro',
        'December' => 'Dezembro',

        # Template: AAANavBar
        'Admin-Area' => 'rea de Administrao',
        'Agent-Area' => 'rea de Atendente',
        'Ticket-Area' => 'rea de Solicitao',
        'Logout' => 'Sair',
        'Agent Preferences' => 'Preferncias Atendente',
        'Preferences' => 'Preferncias',
        'Agent Mailbox' => 'Mailbox Atendente',
        'Stats' => 'Estatsticas',
        'Stats-Area' => 'rea de Estatsticas',
        'Admin' => '',
        'Customer Users' => 'Clientes',
        'Customer Users <-> Groups' => 'Clientes <-> Grupos',
        'Users <-> Groups' => 'Usurios <-> Grupos',
        'Roles' => 'Papis',
        'Roles <-> Users' => 'Papis <-> Usurios',
        'Roles <-> Groups' => 'Papis <-> Grupos',
        'Salutations' => 'Tratamentos (Sr./Sra.)',
        'Signatures' => 'Assinaturas',
        'Email Addresses' => 'E-mail',
        'Notifications' => 'Notificaes',
        'Category Tree' => 'Categorias',
        'Admin Notification' => 'Notificao Administrativa',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Preferncias atualizadas com sucesso!',
        'Mail Management' => 'Gerenciamento de E-mail',
        'Frontend' => 'Interface',
        'Other Options' => 'Outras Opes',
        'Change Password' => 'Trocar senha',
        'New password' => 'Nova senha',
        'New password again' => 'Repita sua nova senha',
        'Select your QueueView refresh time.' => 'Selecione o tempo de atualizao das Filas',
        'Select your frontend language.' => 'Selecione o Idioma.',
        'Select your frontend Charset.' => 'Selecione o Conjunto de Caracteres.',
        'Select your frontend Theme.' => 'Selecione o Tema.',
        'Select your frontend QueueView.' => 'Selecione a Viso da Fila.',
        'Spelling Dictionary' => 'Dicionrio (Lngua)',
        'Select your default spelling dictionary.' => 'Escolha o seu corretor ortogrfico padro.',
        'Max. shown Tickets a page in Overview.' => 'Mx. solicitaes em uma tela.',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Senha no atualizada, por que esto diferentes! Tente novamente!',
        'Can\'t update password, invalid characters!' => 'Senha no atualizada, caracteres invlidos!',
        'Can\'t update password, must be at least %s characters!' => 'Senha no atualizada, digite no mnimo %s caracteres!',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Senha no atualizada, digite no mnimo 2 caracteres minsculos e 2 maisculos',
        'Can\'t update password, needs at least 1 digit!' => 'Senha no atualizada, digite no mnimo 1 nmero',
        'Can\'t update password, needs at least 2 characters!' => 'Senha no atualizada, digite no mnimo 2 caracteres',

        # Template: AAAStats
        'Stat' => 'Status',
        'Please fill out the required fields!' => 'Por favor, preencha os campos obrigatrios!',
        'Please select a file!' => 'Por favor, selecione um arquivo!',
        'Please select an object!' => 'Por favor, selecione um objeto!',
        'Please select a graph size!' => 'Por favor, selecione o tamanho do grfico!',
        'Please select one element for the X-axis!' => 'Por favor, selecione um elemento do eixo X!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Por favor, selecione somente um elemento ou desmarque o boto \'Fixo\' onde o campo selecionado est marcado!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Se voc utiliza um checkbox, deves selecionar alguns atributos no campo \'selecionar\'!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Por favor, insira um valor no campo selecionado ou desmarque a checkbox \'Fixo\'!',
        'The selected end time is before the start time!' => 'A data final  anterior  data inicial!',
        'You have to select one or more attributes from the select field!' => 'Voc deve selecionar ao menos um atributo no campo \'selecionar\'!',
        'The selected Date isn\'t valid!' => 'A data selecionada  invlida!',
        'Please select only one or two elements via the checkbox!' => 'Por favor, selecione apenas um ou dois elementos atravs da checkbox!',
        'If you use a time scale element you can only select one element!' => 'Se voc usa um elemento como parmetro de tempo, deves selecionar apenas um elemento!',
        'You have an error in your time selection!' => 'Voc tem um erro na hora selecionada!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'O intervalo de tempo para o aviso  muito pequeno, por favor, utilize um perodo maior!',
        'The selected start time is before the allowed start time!' => 'A data inicial selecionada  anterior  permitida!',
        'The selected end time is after the allowed end time!' => 'A data final selecionada  posterior  permitida!',
        'The selected time period is larger than the allowed time period!' => 'O perodo de tempo selecionado  maior do que o permitido!',
        'Common Specification' => 'Especificao Comum',
        'Xaxis' => 'Eixo X',
        'Value Series' => 'Sequncia de Valores',
        'Restrictions' => 'Restries',
        'graph-lines' => 'grfico de linhas',
        'graph-bars' => 'grfico de barras',
        'graph-hbars' => 'grfico de barras\(2\)',
        'graph-points' => 'grfico de pontos',
        'graph-lines-points' => 'grfico de linhas e pontos',
        'graph-area' => 'grfico de rea',
        'graph-pie' => 'grfico de pizza',
        'extended' => 'extendido',
        'Agent/Owner' => 'Atendente/Proprietrio',
        'Created by Agent/Owner' => 'Criado pelo Atendente/Proprietrio',
        'Created Priority' => 'Prioridade',
        'Created State' => 'Status',
        'Create Time' => 'Data/Hora',
        'CustomerUserLogin' => 'Usurio do Cliente',
        'Close Time' => 'Data/Hora de Fechamento',
        'TicketAccumulation' => 'Acumulao de Chamado',
        'Attributes to be printed' => 'Atributos a serem impressos',
        'Sort sequence' => 'Sequncia de Ordenamento',
        'Order by' => 'Ordenar por',
        'Limit' => 'Limite',
        'Ticketlist' => 'ListaChamado',
        'ascending' => 'ascendente',
        'descending' => 'descendente',
        'First Lock' => 'Primeiro Bloqueio',
        'Evaluation by' => 'Avaliado por',
        'Total Time' => 'Tempo Total',
        'Ticket Average' => 'Mdia de Solicitaes',
        'Ticket Min Time' => 'Horrio Mnimo das Solicitaes',
        'Ticket Max Time' => 'Horrio Mximo das Solicitaes',
        'Number of Tickets' => 'Nmero de Solicitaes',
        'Article Average' => 'Mdia de Artigos',
        'Article Min Time' => 'Horrio Mnimo dos Artigos',
        'Article Max Time' => 'Horrio Mximo dos Artigos',
        'Number of Articles' => 'Nmero de Histricos',
        'Accounted time by Agent' => 'Tempo contabilizado por Atendente',
        'Ticket/Article Accounted Time' => 'Tempo contabilizado por Solicitao/Artigo',
        'TicketAccountedTime' => 'TempoContabilizadoSolicitao',
        'Ticket Create Time' => 'Horrio de Criao da Solicitao',
        'Ticket Close Time' => 'Horrio de Fechamento da Solicitao',

        # Template: AAATicket
        'Lock' => 'Bloquear',
        'Unlock' => 'Desbloquear',
        'History' => 'Histrico',
        'Zoom' => 'Detalhes',
        'Age' => 'Idade',
        'Bounce' => 'Devolver',
        'Forward' => 'Encaminhar',
        'From' => 'De',
        'To' => 'Para',
        'Cc' => 'Cpia ',
        'Bcc' => 'Cpia Oculta',
        'Subject' => 'Assunto',
        'Move' => 'Mover',
        'Queue' => 'Fila',
        'Priority' => 'Prioridade',
        'Priority Update' => 'Atualizao de Prioridade',
        'State' => 'Estado',
        'Compose' => 'Compor',
        'Pending' => 'Pendente',
        'Owner' => 'Proprietrio',
        'Owner Update' => 'Atualizao Proprietrio',
        'Responsible' => 'Responsvel',
        'Responsible Update' => 'Atualizao do Responsvel',
        'Sender' => 'Remetente',
        'Article' => 'Artigo',
        'Ticket' => 'Solicitao',
        'Createtime' => 'Hora de criao',
        'plain' => 'texto',
        'Email' => 'E-mail',
        'email' => 'e-mail',
        'Close' => 'Fechar',
        'Action' => 'Ao',
        'Attachment' => 'Anexo',
        'Attachments' => 'Anexos',
        'This message was written in a character set other than your own.' => 'Esta mensagem foi escrita utilizando um conjunto de caracteres diferente do seu.',
        'If it is not displayed correctly,' => 'Se ele no for exibido corretamente,',
        'This is a' => 'Este  um',
        'to open it in a new window.' => 'para abri-lo em uma nova janela.',
        'This is a HTML email. Click here to show it.' => 'Este e-mail est em formato HTML. Clique aqui para exibi-lo.',
        'Free Fields' => 'Campos Livres',
        'Merge' => 'Agrupar',
        'merged' => 'agrupada',
        'closed successful' => 'fechada com xito',
        'closed unsuccessful' => 'fechada sem xito',
        'new' => 'nova',
        'open' => 'aberta',
        'Open' => 'Aberta',
        'closed' => 'fechada',
        'Closed' => 'Fechada',
        'removed' => 'removida',
        'pending reminder' => 'lembrete de pendente',
        'pending auto' => 'pendente automtico',
        'pending auto close+' => 'pendente auto fechamento+',
        'pending auto close-' => 'pendente auto fechamento-',
        'email-external' => 'email-externo',
        'email-internal' => 'email-interno',
        'note-external' => 'nota-externa',
        'note-internal' => 'nota-interna',
        'note-report' => 'nota-relatrio',
        'phone' => 'telefone',
        'sms' => '',
        'webrequest' => 'solicitao web',
        'lock' => 'bloqueada',
        'unlock' => 'desbloqueada',
        'very low' => 'muito baixo',
        'low' => 'baixo',
        'normal' => '',
        'high' => 'alto',
        'very high' => 'muito alto',
        '1 very low' => '1 muito baixo',
        '2 low' => '2 baixo',
        '3 normal' => '',
        '4 high' => '4 alto',
        '5 very high' => '5 muito alto',
        'Ticket "%s" created!' => 'Solicitao "%s" criada!',
        'Ticket Number' => 'Nmero da Solicitao',
        'Ticket Object' => 'Objeto da Solicitao',
        'No such Ticket Number "%s"! Can\'t link it!' => 'No existe a solicitao "%s"! No foi possvel associ-la!',
        'Don\'t show closed Tickets' => 'No mostrar solicitaes fechadas',
        'Show closed Tickets' => 'Mostrar solicitaes fechadas',
        'New Article' => 'Novo Artigo',
        'Email-Ticket' => 'Solicitao E-mail',
        'Create new Email Ticket' => 'Criar nova Solicitao E-mail',
        'Phone-Ticket' => 'Solicitao Fone',
        'Search Tickets' => 'Pesquisar Solicitaes',
        'Edit Customer Users' => 'Editar Clientes (Usurios)',
        'Edit Customer Company' => '',
        'Bulk Action' => 'Executar Ao',
        'Bulk Actions on Tickets' => 'Aes em massa em solicitaes',
        'Send Email and create a new Ticket' => 'Enviar e-mail e criar nova solicitao',
        'Create new Email Ticket and send this out (Outbound)' => 'Criar nova solicitao e-mail e envi-la (sada)',
        'Create new Phone Ticket (Inbound)' => 'Criar nova solicitao fone (entrada)',
        'Overview of all open Tickets' => 'Viso geral de todas as solicitaes abertas',
        'Locked Tickets' => 'Solicitaes Bloqueadas',
        'Watched Tickets' => 'Solicitaes Monitoradas',
        'Watched' => 'Monitorados',
        'Subscribe' => 'Monitorar',
        'Unsubscribe' => 'Desmonitorar',
        'Lock it to work on it!' => 'Bloquear para trabalhar com a solicitao!',
        'Unlock to give it back to the queue!' => 'Desbloqueie para envi-lo devolta  fila!',
        'Shows the ticket history!' => 'Apresentar histrico de solicitaes',
        'Print this ticket!' => 'Imprimir esta solicitao!',
        'Change the ticket priority!' => 'Alterar a prioridade da solicitao!',
        'Change the ticket free fields!' => 'Alterar os campos em branco na solicitao!',
        'Link this ticket to an other objects!' => 'Associar esta solicitao com outros objetos!',
        'Change the ticket owner!' => 'Alterar o proprietrio da solicitao!',
        'Change the ticket customer!' => 'Alterar o cliente da solicitao',
        'Add a note to this ticket!' => 'Adicionar um nota a esta solicitao!',
        'Merge this ticket!' => 'Agrupar esta solicitao!',
        'Set this ticket to pending!' => 'Marcar esta solicitao como pendente!',
        'Close this ticket!' => 'Fechar esta solicitao!',
        'Look into a ticket!' => 'Examinar em detalhes o contedo de uma solicitao!',
        'Delete this ticket!' => 'Apagar esta solicitao!',
        'Mark as Spam!' => 'Marque como Spam',
        'My Queues' => 'Minhas Filas',
        'Shown Tickets' => 'Mostrar Solicitaes',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'A sua mensagem com a solicitao nmero "<OTRS_TICKET>" foi agrupada com a solicitao nmero "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => 'Solicitao %s: primeiro tempo de soluo est ultrapassado (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Solicitao %s: primeiro tempo de soluo expirar em %s!',
        'Ticket %s: update time is over (%s)!' => 'Solicitao %s: tempo de atualizao est ultrapassado (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Solicitao %s: tempo de atualizao expirar em %s!',
        'Ticket %s: solution time is over (%s)!' => 'Solicitao %s: tempo de soluo est ultrapassado (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Solicitao %s: tempo de soluo expirar em %s!',
        'There are more escalated tickets!' => 'H mais solicitaes escaladas!',
        'New ticket notification' => 'Notificao de nova solicitao',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Envie-me uma notificao se h um nova solicitao em "Minhas Filas".',
        'Follow up notification' => 'Notificao de continuao',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => 'Notifique-me se um cliente enviar uma continuao e sou o proprietrio da solicitao.',
        'Ticket lock timeout notification' => 'Notificao de bloqueio por tempo expirado',
        'Send me a notification if a ticket is unlocked by the system.' => 'Notifique-me se uma solicitao  desbloqueada pelo sistema.',
        'Move notification' => 'Notificao de movimentos',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Notifique-me se Solicitaes forem movimentadas para "Minhas Filas"',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Suas filas favoritas. Voc tambm ser notificado sobre estas filas via e-mail se habilitado.',
        'Custom Queue' => 'Fila Personalizada',
        'QueueView refresh time' => 'Tempo de atualizao das Filas',
        'Screen after new ticket' => 'Tela aps nova solicitao',
        'Select your screen after creating a new ticket.' => 'Selecione a tela seguinte aps a criao de uma nova solicitao.',
        'Closed Tickets' => 'Solicitaes Fechadas',
        'Show closed tickets.' => 'Apresentar solicitaes fechadas.',
        'Max. shown Tickets a page in QueueView.' => 'N mximo de solicitaes apresentadas por pgina.',
        'Watch notification' => 'Notificao de Monitoramento',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'Envie-me uma notificao de uma solicitao monitorada como no caso de um proprietrio de solicitao.',
        'Out Of Office' => 'Ausncia do Escritrio',
        'Select your out of office time.' => 'Selecione seu horrio de ausncia do escritrio (frias, licenas etc.).',
        'CompanyTickets' => 'Solicitaes da Empresa',
        'MyTickets' => 'Minhas Solicitaes',
        'New Ticket' => 'Nova Solicitao',
        'Create new Ticket' => 'Criar nova Solicitao',
        'Customer called' => 'O Cliente Telefonou',
        'phone call' => 'Chamada Telefnica',
        'Reminder Reached' => 'Lembrete Expirado',
        'Reminder Tickets' => 'Solicitaes com Lembrete',
        'Escalated Tickets' => 'Solicitaes Escaladas',
        'New Tickets' => 'Solicitaes Novas',
        'Open Tickets / Need to be answered' => 'Solicitaes Abertas / Precisam ser respondidas',
        'Tickets which need to be answered!' => 'Solicitaes que precisam ser respondidas!',
        'All new tickets!' => 'Todas as novas solicitaes!',
        'All tickets which are escalated!' => 'Todas as olicitaes que foram escaladas!',
        'All tickets where the reminder date has reached!' => 'Todas as olicitaes cujos prazos de lembrete expiraram!',
        'Responses' => 'Respostas',
        'Responses <-> Queue' => 'Respostas <-> Fila',
        'Auto Responses' => 'Auto respostas',
        'Auto Responses <-> Queue' => 'Auto respostas <-> Fila',
        'Attachments <-> Responses' => 'Anexos <-> respostas',
        'History::Move' => 'Solicitao foi movida para a Fila "%s" (%s) vinda da Fila "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'Nova Solicitao [%s] foi criada (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'Acompanhado por [%s]. %s',
        'History::SendAutoReject' => 'Rejeio automtica enviada para "%s".',
        'History::SendAutoReply' => 'Auto Resposta enviada para "%s".',
        'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
        'History::Forward' => 'Encaminhado para "%s".',
        'History::Bounce' => 'Devolvido a "%s".',
        'History::SendAnswer' => 'Email enviado para "%s".',
        'History::SendAgentNotification' => '"%s"-notificao enviada para "%s".',
        'History::SendCustomerNotification' => 'Notificao enviada para "%s".',
        'History::EmailAgent' => 'E-mail enviado para Cliente.',
        'History::EmailCustomer' => 'E-mail adicionado. %s',
        'History::PhoneCallAgent' => 'Atendente telefonou para cliente.',
        'History::PhoneCallCustomer' => 'Cliente telefonou para a equipe de suporte.',
        'History::AddNote' => 'Nota adicionada (%s)',
        'History::Lock' => 'Solicitao Bloqueada.',
        'History::Unlock' => 'Solicitao Desbloqueada.',
        'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
        'Change the ticket responsible!' => 'Alterar o responsvel pela solicitao!',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Atualizado: %s',
        'History::PriorityUpdate' => 'Prioridade atualizada por "%s" (%s) to "%s" (%s).',
        'History::OwnerUpdate' => 'Novo proprietrio  "%s" (ID=%s).',
        'History::LoopProtection' => 'Proteo de Loop! Auto resposta enviada para "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Atualizado: %s',
        'History::StateUpdate' => 'Anterior: "%s" Novo: "%s"',
        'History::TicketFreeTextUpdate' => 'Atualizado: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Requisio do Cliente via web.',
        'History::TicketLinkAdd' => 'Adicionados associaes  solicitao "%s".',
        'History::TicketLinkDelete' => 'Associaes da solicitao Excludos "%s".',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',

        # Template: AAAWeekDay
        'Sun' => 'Dom',
        'Mon' => 'Seg',
        'Tue' => 'Ter',
        'Wed' => 'Qua',
        'Thu' => 'Qui',
        'Fri' => 'Sex',
        'Sat' => 'Sab',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Gerenciamento de Anexos',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Administrao de Auto-Respostas',
        'Response' => 'Resposta',
        'Auto Response From' => 'Auto-Resposta De',
        'Note' => 'Nota',
        'Useable options' => 'Opes disponveis',
        'To get the first 20 character of the subject.' => 'Para buscar os primeiros 20 caracteres do assunto.',
        'To get the first 5 lines of the email.' => 'Para buscar as primeiras 5 linhas do e-mail.',
        'To get the realname of the sender (if given).' => 'Para buscar o nome real do remetente (se fornecido).',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Para buscar o atributo do artigo (ex.: (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Opes de informaes do usurio cliente (ex.: <OTRS_CUSTOMER_DATA_UserFirstname>).',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Opes do proprietrio do Chamado (ex.: <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Opes do responsvel pelo Chamado (ex.: <OTRS_RESPONSIBLE_UserFirstname>).',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Opes do usurio atual que requisitou esta ao (ex.: <OTRS_CURRENT_UserFirstname>).',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Opes de informao do Chamado (ex.: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Opes de Configurao (ex.: <OTRS_CONFIG_HttpType>).',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => 'Gerenciamento de Empresa de Clientes',
        'Search for' => 'Pesquisar por',
        'Add Customer Company' => 'Adicionar Empresa de Clientes',
        'Add a new Customer Company.' => 'Adicionar uma nova Empresa de Clientes.',
        'List' => 'Lista',
        'This values are required.' => 'Estes valores so obrigatrios.',
        'This values are read only.' => 'Estes valores so apenas para leitura.',

        # Template: AdminCustomerUserForm
        'Title{CustomerUser}' => '',
        'Firstname{CustomerUser}' => '',
        'Lastname{CustomerUser}' => '',
        'Username{CustomerUser}' => '',
        'Email{CustomerUser}' => '',
        'CustomerID{CustomerUser}' => '',
        'Phone{CustomerUser}' => '',
        'Fax{CustomerUser}' => '',
        'Mobile{CustomerUser}' => '',
        'Street{CustomerUser}' => '',
        'Zip{CustomerUser}' => '',
        'City{CustomerUser}' => '',
        'Country{CustomerUser}' => '',
        'Comment{CustomerUser}' => '',
        'The message being composed has been closed.  Exiting.' => 'A mensagem sendo composta foi fechada. Saindo.',
        'This window must be called from compose window' => 'Esta janela deve ser chamada da janela de composio',
        'Customer User Management' => 'Administrao de Clientes',
        'Add Customer User' => 'Adicionar Cliente',
        'Source' => 'Origem',
        'Create' => 'Criar',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'O usurio do cliente ser necessrio para que exista um histrico do cliente e para login na rea de clientes.',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'Clientes <-> Admin Grupos',
        'Change %s settings' => 'Modificar %s configuraes',
        'Select the user:group permissions.' => 'Selecionar as permisses de  usurio:grupo.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Se nada estiver selecionado, ento no h nenhuma permisso neste grupo (as solicitaes no estaro disponveis para o usurio).',
        'Permission' => 'Permisses',
        'ro' => 'somente leitura',
        'Read only access to the ticket in this group/queue.' => 'Acesso Somente com Leitura de solicitaes neste grupo/fila',
        'rw' => 'leitura e escrita',
        'Full read and write access to the tickets in this group/queue.' => 'Acesso leitura e escrita de solicitaes neste grupo/fila',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => 'Clientes <-> Gerenciamento de Servios',
        'CustomerUser' => 'Usurio Cliente',
        'Service' => 'Servio',
        'Edit default services.' => 'Editar servios padro',
        'Search Result' => 'Resultado da Busca',
        'Allocate services to CustomerUser' => 'Alocar servios a usurio cliente',
        'Active' => 'Ativo',
        'Allocate CustomerUser to service' => 'Alocar usurio cliente a servio',

        # Template: AdminEmail
        'Message sent to' => 'Mensagem enviada para',
        'A message should have a subject!' => 'Uma mensagem deve conter um assunto!',
        'Recipients' => 'Destinatrios',
        'Body' => 'Corpo',
        'Send' => 'Enviar',

        # Template: AdminGenericAgent
        'GenericAgent' => 'Atendente Genrico',
        'Job-List' => 'Lista de jobs',
        'Last run' => 'ltima execuo',
        'Run Now!' => 'Executar Agora',
        'x' => '',
        'Save Job as?' => 'Salvar trabalho como?',
        'Is Job Valid?' => 'O trabalho  vlido?',
        'Is Job Valid' => 'O trabalho  vlido.',
        'Schedule' => 'Agenda',
        'Currently this generic agent job will not run automatically.' => '',
        'To enable automatic execution select at least one value from minutes, hours and days!' => '',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Busca por texto completo no Artigo (ex.: "Mar*in" or "Baue*")',
        '(e. g. 10*5155 or 105658*)' => '(ex.: 10*5155 or 105658*)',
        '(e. g. 234321)' => '(ex.: 234321)',
        'Customer User Login' => 'Cliente Login',
        '(e. g. U5150)' => '(ex.: U5150)',
        'SLA' => '',
        'Agent' => 'Atendente',
        'Ticket Lock' => 'Solicitao bloqueada',
        'TicketFreeFields' => 'Campos livres da solicitao',
        'Create Times' => 'Horrios de Criao',
        'No create time settings.' => 'Ignorar horrios de criao',
        'Ticket created' => 'Solicitao criada',
        'Ticket created between' => 'Solicitao criada entre',
        'Close Times' => 'Horrios de Fechamento',
        'No close time settings.' => 'Ignorar horrios de fechamento',
        'Ticket closed' => 'Solicitao fechada',
        'Ticket closed between' => 'Solicitao fechada entre',
        'Pending Times' => 'Horrios Pendentes',
        'No pending time settings.' => 'Ignorar horrios pendentes',
        'Ticket pending time reached' => 'Prazo de Solicitao pendentes expirado',
        'Ticket pending time reached between' => 'Prazo de Solicitao pendentes expirado entre',
        'Escalation Times' => 'Prazo de Escalao',
        'No escalation time settings.' => 'Ignorar prazos de escalao',
        'Ticket escalation time reached' => 'Prazos de escalaes expirado',
        'Ticket escalation time reached between' => 'Prazos de escalao expirado entre',
        'Escalation - First Response Time' => 'Escalao - Prazo da Primeira Resposta',
        'Ticket first response time reached' => 'Prazo de primeira resposta expirado',
        'Ticket first response time reached between' => 'Prazo de primeira resposta expirado entre',
        'Escalation - Update Time' => 'Escalao - Prazo de Atualizao',
        'Ticket update time reached' => 'Prazo de atualizao expirado',
        'Ticket update time reached between' => 'Prazo de atualizao expirado entre',
        'Escalation - Solution Time' => 'Escalao - Prazo de Soluo',
        'Ticket solution time reached' => 'Prazo de soluo expirado',
        'Ticket solution time reached between' => 'Prazo de soluo expirado entre',
        'New Service' => 'Novo Servio',
        'New SLA' => 'Novo SLA',
        'New Priority' => 'Nova Prioridade',
        'New Queue' => 'Nova Fila',
        'New State' => 'Novo Estado',
        'New Agent' => 'Novo Atendente',
        'New Owner' => 'Novo Proprietrio',
        'New Customer' => 'Novo Cliente',
        'New Ticket Lock' => 'Solicitao nova bloqueada',
        'New Type' => 'Novo Tipo',
        'New Title' => 'Novo Ttulo',
        'New TicketFreeFields' => 'Novos campos livres da solicitao',
        'Add Note' => 'Adicionar Nota',
        'Time units' => 'Unidades de tempo',
        'CMD' => 'Comando',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Este comando ser executado. ARG[0] ser o nmero da solicitao. ARG[1] o id da solicitao.',
        'Delete tickets' => 'Excluir Solicitaes',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Alerta! Esta solicitao ser removida da base de dados! Esta solicitao esr perdida permanentemente!',
        'Send Notification' => 'Enviar Notificao',
        'Param 1' => 'Parmetro 1',
        'Param 2' => 'Parmetro 2',
        'Param 3' => 'Parmetro 3',
        'Param 4' => 'Parmatro 4',
        'Param 5' => 'Parmetro 5',
        'Param 6' => 'Parmetro 6',
        'Send agent/customer notifications on changes' => 'Enviar notificaes de alteraes para agente/cliente',
        'Save' => 'Salvar',
        '%s Tickets affected! Do you really want to use this job?' => '%s Solicitaes afetadas! Voc quer realmente utilizar este processo?',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '',
        'Group Management' => 'Administrao de Grupos',
        'Add Group' => 'Adicionar grupo',
        'Add a new Group.' => 'Adicionar um novo grupo',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'O grupo admin  para uso na rea de administrao e o grupo stats  para uso na rea de estatsticas.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crie novos grupos para manipular as permisses de acesso para diferentes grupos de agentes (exemplos: departamento de compras, departamento de suporte, departamento de vendas, etc...).',
        'It\'s useful for ASP solutions.' => 'Isto  til para solues ASP.',

        # Template: AdminLog
        'System Log' => 'Registro do Sistema',
        'Time' => 'Hora',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Gerenciamento de Contas de E-Mail',
        'Host' => 'Servidor',
        'Trusted' => 'Confivel',
        'Dispatching' => 'Despachando',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Todos os emails de entrada com uma conta ser despachado na fila selecionada!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Se a sua conta for confivel, os headers "X-OTRS" existentes na recepo (para prioridade, ...) sero utilizados! O filtro ser utilizado mesmo assim.',

        # Template: AdminNavigationBar
        'Users' => 'Usurios',
        'Groups' => 'Grupos',
        'Misc' => 'Variedades',

        # Template: AdminNotificationEventForm
        'Notification Management' => 'Admin de Notificaes',
        'Add Notification' => 'Adicionar Notificao',
        'Add a new Notification.' => 'Adicionar uma nova Notificao',
        'Name is required!' => 'O Nome  requerido',
        'Event is required!' => 'Evento  obrigatrio!',
        'A message should have a body!' => 'A mensagem deve conter um texto!',
        'Recipient' => 'Destinatrio',
        'Group based' => 'Baseado em Grupo',
        'Agent based' => 'Baseado em Agente',
        'Email based' => 'Baseado em E-Mail',
        'Article Type' => 'Tipo do Artigo',
        'Only for ArticleCreate Event.' => 'Somente para Eventos de Criao de Artigo.',
        'Subject match' => 'Casar Assunto',
        'Body match' => 'Casar Corpo',
        'Notifications are sent to an agent or a customer.' => 'Notificaes sero enviadas para um Atedente ou Cliente.',
        'To get the first 20 character of the subject (of the latest agent article).' => 'Para buscar os primeiros 20 caracteres do assunto (do ltimo artigo do agente)',
        'To get the first 5 lines of the body (of the latest agent article).' => 'Para buscar as primeiras 5 linhas do corpo (do ltimo artigo do atendente)',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'Para buscar o atributo do artigo (ex.: (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).',
        'To get the first 20 character of the subject (of the latest customer article).' => 'Para buscar os primeiros 20 caracteres do assunto (do ltimo artigo do cliente)',
        'To get the first 5 lines of the body (of the latest customer article).' => 'Para buscar as primeiras 5 linhas do corpo (do ltimo artigo do cliente)',

        # Template: AdminNotificationForm
        'Notification' => 'Notificaes',

        # Template: AdminPackageManager
        'Package Manager' => 'Gerenciador de Pacotes',
        'Uninstall' => 'Desinstalar',
        'Version' => 'Verso',
        'Do you really want to uninstall this package?' => 'Voc quer realmente desinstalar este pacote?',
        'Reinstall' => 'Reinstalar',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Voc quer realmente reinstalar este pacote?',
        'Continue' => 'Continuar',
        'Install' => 'Instalar',
        'Package' => 'Pacotes',
        'Online Repository' => 'Repositrio Online',
        'Vendor' => 'Fornecedor',
        'Module documentation' => 'Documentao do Mdulo',
        'Upgrade' => 'Atualizar Verso',
        'Local Repository' => 'Repositrio Local',
        'Status' => 'Estado',
        'Overview' => 'Viso Geral',
        'Download' => '',
        'Rebuild' => 'Reconstruir',
        'ChangeLog' => '',
        'Date' => 'Data',
        'Filelist' => 'Lista de arquivos',
        'Download file from package!' => 'Baixar arquivo do pacote!',
        'Required' => 'Requerido',
        'PrimaryKey' => 'Chave Primria',
        'AutoIncrement' => 'Autoincremento',
        'SQL' => '',
        'Diff' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Log de Performance',
        'This feature is enabled!' => 'Esta funcionalidade foi habilitada!',
        'Just use this feature if you want to log each request.' => 'Use esta funcionalidade se voc quiser logar cada requisio.',
        'Activating this feature might affect your system performance!' => 'Ao ativar esta funcionalidade pode-se afetar o desempenho do seu sistema!',
        'Disable it here!' => 'Desabilite-o aqui!',
        'This feature is disabled!' => 'Esta funcionalidade foi desabilitada!',
        'Enable it here!' => 'Habilite-o aqui!',
        'Logfile too large!' => 'Arquivo de log muito grande!',
        'Logfile too large, you need to reset it!' => 'Arquivo de log muito grande, voc deve reinici-lo!',
        'Range' => 'Intervalo',
        'Interface' => 'Interface',
        'Requests' => 'Requisies',
        'Min Response' => 'Tempo mnimo de resposta',
        'Max Response' => 'Tempo mximo de resposta',
        'Average Response' => 'Mdia de tempo de resposta',
        'Period' => 'Perodo',
        'Min' => 'Mn.',
        'Max' => 'Mx.',
        'Average' => 'Mdia',

        # Template: AdminPGPForm
        'PGP Management' => 'Gerenciamento do PGP',
        'Result' => 'Resultado',
        'Identifier' => 'Identificador',
        'Bit' => '',
        'Key' => 'Chave',
        'Fingerprint' => 'Impresso Digital',
        'Expires' => 'Expira',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Neste caso, voc pode editar diretamente o "keyring" configurado no "SysConfig".',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Gerenciamento de Filtros (Postmaster)',
        'Filtername' => 'Nome do Filtro',
        'Stop after match' => 'Parar aps encontrar',
        'Match' => 'Busca',
        'Value' => 'Valor',
        'Set' => 'Configurar',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Para despachar ou filtrar os e-mails entrantes baseados em "X-Headers". Expresses regularos tambm podem ser utilizadas.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Se voc quiser casar somente o endereo de e-mail, use EMAILADDRESS:info@example.com em From, To or Cc.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Se utilizar expresses regulares, voc pode usar o valor encontrado no () como [***] em \'Set\'.',

        # Template: AdminPriority
        'Priority Management' => 'Gerenciamento de Prioridade',
        'Add Priority' => 'Adicionar Prioridade',
        'Add a new Priority.' => 'Adicionar nova Prioridade',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'Fila <-> Gerenciamento de Auto Respostas',
        'settings' => 'configuraes',

        # Template: AdminQueueForm
        'Queue Management' => 'Gerenciamento de Filas',
        'Sub-Queue of' => 'Subfila de',
        'Unlock timeout' => 'Tempo de expirao de desbloqueio',
        '0 = no unlock' => '0 = sem desbloqueio',
        'Only business hours are counted.' => 'Apenas horas teis so contadas.',
        '0 = no escalation' => '0 = sem escalao',
        'Notify by' => 'Notificar por',
        'Follow up Option' => 'Opo de continuao',
        'Ticket lock after a follow up' => 'Bloqueio da solicitao aps as continuaes',
        'Systemaddress' => 'Endereo do Sistema',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Se um atendente bloquear uma solicitao e ele no enviar uma resposta dentro deste tempo, a solicitao ser desbloqueada automaticamente. Ento a solicitao ser visvel para todos os atendentes.',
        'Escalation time' => 'Tempo de escalao',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Se uma solicitao no for respondida neste prazo, apenas esta solicitao ser exibida.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Se uma solicitao est fechada e um cliente envia uma continuao, esta mesma solicitao ser bloqueada para o antigo proprietrio.',
        'Will be the sender address of this queue for email answers.' => 'Ser o endereo de email de respostas desta fila.',
        'The salutation for email answers.' => 'A saudao para as respostas de emails.',
        'The signature for email answers.' => 'A assinatura para as respostas de emails.',
        'Customer Move Notify' => 'Cliente Notificar Alterao',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'O OTRS envia uma notificao por e-mail ao cliente, caso a solicitao seja movida.',
        'Customer State Notify' => 'Notificar Status do Cliente',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'O OTRS envia uma notificao por e-mail ao cliente, caso o status da solicitao seja alterado.',
        'Customer Owner Notify' => 'Cliente Notificar Proprietrio',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'O OTRS envia uma notificao por e-mail ao cliente, caso o dono da solicitao seja alterado.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'Respostas <-> Gerenciamento de Filas',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Resposta',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'Respostas <-> Gerenciamento de Anexos',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Gerenciamento de Respostas',
        'A response is default text to write faster answer (with default text) to customers.' => 'Uma resposta padro  um texto para responder mais rapidamente aos clientes.',
        'Don\'t forget to add a new response a queue!' => 'No se esquea de adicionar a nova resposta a uma fila!',
        'The current ticket state is' => 'O estado da solicitao  ',
        'Your email address is new' => 'Seu e-mail  novo',

        # Template: AdminRoleForm
        'Role Management' => 'Gerenciamento de Papis',
        'Add Role' => 'Adicionar Papel',
        'Add a new Role.' => 'Adicionar um novo papel',
        'Create a role and put groups in it. Then add the role to the users.' => 'Crie um papel e relacione grupos a ele. Ento adicione regras aos usurios. ',
        'It\'s useful for a lot of users and groups.' => 'Isto  muito til para uma grande quantidade de usurios e grupos.',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'Papis <-> Gerenciamento de Grupos',
        'move_into' => 'mover_para',
        'Permissions to move tickets into this group/queue.' => 'Permisses para movimento de Solicitaes neste grupo/fila.',
        'create' => 'criar',
        'Permissions to create tickets in this group/queue.' => 'Permisses para criar solicitaes neste grupo/fila. ',
        'owner' => 'proprietrio',
        'Permissions to change the ticket owner in this group/queue.' => 'Permisses para alterar a solicitao neste grupo/fila.  ',
        'priority' => 'prioridade',
        'Permissions to change the ticket priority in this group/queue.' => 'Permisses para alterar o proprietrio neste grupo/fila.',

        # Template: AdminRoleGroupForm
        'Role' => 'Papel',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => 'Papel <-> Gerenciamento de Usurios',
        'Select the role:user relations.' => 'Selecione a relao entre o papel/usurio.',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Gerenciamento de Tratamento (Sr./Sra.)',
        'Add Salutation' => 'Adicionar Tratamento',
        'Add a new Salutation.' => 'Adicionar um novo Tratamento',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => 'Modo de Segurana deve ser ativado!',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'Modo de Segurana ser (normalmente) ativado aps a instalao inicial.',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'Modo de Segurana deve estar desabilitado para reinstalar utilizando o instalador web.',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'Se o Modo de Segurana no estiver ativado, ative-o atravs do SysConfig, porque sua aplicao j est rodando.',

        # Template: AdminSelectBoxForm
        'SQL Box' => 'Comandos SQL',
        'Go' => 'Executar',
        'Select Box Result' => 'Selecione a Caixa de Resultado',

        # Template: AdminService
        'Service Management' => 'Gerenciamento de Servios',
        'Add Service' => 'Adicionar Servio',
        'Add a new Service.' => 'Adicionar um novo Servio',
        'Sub-Service of' => 'Subservio de',

        # Template: AdminSession
        'Session Management' => 'Gerenciamento de Sesses',
        'Sessions' => 'Sesses',
        'Uniq' => 'nico',
        'Kill all sessions' => 'Finalizar todas as sesses',
        'Session' => 'Sesso',
        'Content' => 'Contedo',
        'kill session' => 'Finalizar sesso',

        # Template: AdminSignatureForm
        'Signature Management' => 'Gerenciamento de Assinaturas',
        'Add Signature' => 'Adicionar Assinatura',
        'Add a new Signature.' => 'Adicionar uma nova Assinatura',

        # Template: AdminSLA
        'SLA Management' => 'Gerenciamento de SLA',
        'Add SLA' => 'Adicionar SLA',
        'Add a new SLA.' => 'Adicionar um novo SLA',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'Gerenciamento S/MIME',
        'Add Certificate' => 'Adicionar Certificado',
        'Add Private Key' => 'Adicionar Chave Privada',
        'Secret' => 'Senha',
        'Hash' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'Neste caso, voc pode editar diretamente a certificao e chaves privadas no sistema de arquivos.',

        # Template: AdminStateForm
        'State Management' => 'Gerenciamento de Estado',
        'Add State' => 'Adicionar Estado',
        'Add a new State.' => 'Adicionar um novo Estado',
        'State Type' => 'Tipo de Estado',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Tenha cuidado se voc tambm atualizou os estados padro no Kernel/Config.pm!',
        'See also' => 'Veja tambm',

        # Template: AdminSysConfig
        'SysConfig' => 'Configurao do Sistema',
        'Group selection' => 'Seleo de Grupo',
        'Show' => 'Visualizar',
        'Download Settings' => 'Baixar Configuraes',
        'Download all system config changes.' => 'Baixar todas as configuraes do sistema que foram alteradas.',
        'Load Settings' => 'Carregar Configuraes',
        'Subgroup' => 'Subgrupo',
        'Elements' => 'Elementos',

        # Template: AdminSysConfigEdit
        'Config Options' => 'Opes de Configurao',
        'Default' => 'Padro',
        'New' => 'Novo',
        'New Group' => 'Novo Grupo',
        'Group Ro' => 'Grupo Somente Leitura',
        'New Group Ro' => 'Novo Grupo Somente Leitura',
        'NavBarName' => 'Nome da Barra de Navegao',
        'NavBar' => 'Barra de Navegao',
        'Image' => 'Imagem',
        'Prio' => 'Prioridade',
        'Block' => 'Bloquear',
        'AccessKey' => 'Chave de Acesso',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Gerenciamento dos Endereos de E-mail do Sistema',
        'Add System Address' => 'Adicionar Endereos do Sistema',
        'Add a new System Address.' => 'Adicionar um novo endereo de sistema.',
        'Realname' => 'Nome real',
        'All email addresses get excluded on replaying on composing an email.' => '',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Todos os emails entrantes com este Email(To:) sero despachados na fila selecionada!',

        # Template: AdminTypeForm
        'Type Management' => 'Gerenciamento de Tipo',
        'Add Type' => 'Adicionar Tipo',
        'Add a new Type.' => 'Adicionar um novo Tipo',

        # Template: AdminUserForm
        'User Management' => 'Gerenciamento de Usurios',
        'Add User' => 'Adicionar Usurio',
        'Add a new Agent.' => 'Adicionar um novo Atendente',
        'Login as' => 'Logar-se como',
        'Firstname' => 'Nome',
        'Lastname' => 'Sobrenome',
        'Start' => 'Incio',
        'End' => 'Fim',
        'User will be needed to handle tickets.' => 'Ser necessrio um usurio para manipular as solicitaes.',
        'Don\'t forget to add a new user to groups and/or roles!' => 'No se esquea de adicionar o novo usurio em grupos e/ou papis!',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Usurios <-> Gerenciamento de Grupos',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Catlogo de Endereos',
        'Return to the compose screen' => 'Retornar para a tela de composio',
        'Discard all changes and return to the compose screen' => 'Descartar todas as modificaes e retornar para a tela de composio',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Agent Dashboard' => 'Dashboard do Atendente',

        # Template: AgentDashboardCalendarOverview
        'in' => 'em',

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s est disponvel!',
        'Please update now.' => 'Por favor atualize agora.',
        'Release Note' => 'Notas da Verso',
        'Level' => 'Nvel',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Postado h %s atrs.',

        # Template: AgentDashboardTicketOverview

        # Template: AgentDashboardTicketStats

        # Template: AgentInfo
        'Info' => 'Informao',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Objeto associado: %s',
        'Object' => 'Objeto',
        'Link Object' => 'Associar Objeto',
        'with' => 'com',
        'Select' => 'Selecionar',
        'Unlink Object: %s' => 'Desassociar Objeto',

        # Template: AgentLookup
        'Lookup' => 'Buscar',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Checar a Ortografia',
        'spelling error(s)' => 'erro(s) ortogrficos',
        'or' => 'ou',
        'Apply these changes' => 'Aplicar estas modificaes',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Voc quer realmente remover este objeto?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => 'Selecione as restries para caracterizar o status',
        'Fixed' => 'Fixado',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Por favor, selecione apenas um elemento ou desmarque o boto \'Fixado\'.',
        'Absolut Period' => 'Perodo Absoluto',
        'Between' => 'Entre',
        'Relative Period' => 'Perodo Relativo',
        'The last' => 'O ltimo',
        'Finish' => 'Finalizar',
        'Here you can make restrictions to your stat.' => 'Aqui voc pode criar as restries do seu status',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Se voc remover a seleo da caixa \'Fixado\', o atendente que gerar a estatstica pode alterar os atributos do elemento correspondente.',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => 'Insero das especificaes comuns',
        'Permissions' => 'Permisses',
        'Format' => 'Formato',
        'Graphsize' => 'Tamanho do Grfico',
        'Sum rows' => 'Somar linhas',
        'Sum columns' => 'Somar colunas',
        'Cache' => '',
        'Required Field' => 'Campo Requerido',
        'Selection needed' => ' necessria a seleo',
        'Explanation' => 'Explanao',
        'In this form you can select the basic specifications.' => 'Neste formulrio voc pode selecionar as especificaes bsicas.',
        'Attribute' => 'Atributo',
        'Title of the stat.' => 'Ttulo da estatstica.',
        'Here you can insert a description of the stat.' => 'Aqui voc pode inserir uma descrio da estatstica.',
        'Dynamic-Object' => 'Objeto-Dinmico',
        'Here you can select the dynamic object you want to use.' => 'Aqui voc pode selecionar o objeto dinmico que voc quer usar.',
        '(Note: It depends on your installation how many dynamic objects you can use)' => 'A quantidade de objetos dinmicos depende da sua instalao',
        'Static-File' => 'Arquivo-Esttico',
        'For very complex stats it is possible to include a hardcoded file.' => 'Para estatsticas muito complexas  possvel incluir um cdigo fonte.',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Se um novo cdigo estiver disponvel ele pode ser exibido e voc poder escolh-lo. ',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Configuraes de permisso. Voc pode selecionar um ou mais grupos para que as estatsticas configuradas sejam exibidas para agentes diferentes.',
        'Multiple selection of the output format.' => 'Mltiplas escolhas de formato de sada.',
        'If you use a graph as output format you have to select at least one graph size.' => 'Se voc utiliza um grfico como formato de sada, voc deve selecionar ao menos um tamanho de grfico.',
        'If you need the sum of every row select yes' => 'Se voc necessita da soma de todos as linhas selecione SIM',
        'If you need the sum of every column select yes.' => 'Se voc necessita da soma de todas as colunas seleciona SIM',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'A maioria das estatsticas podem ser mantidas em cache. Isto tornar sua visualizao mais rpida.',
        '(Note: Useful for big databases and low performance server)' => '(Nota: til para base de dados grandes e servidores de baixa performance)',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'Com uma estatstica no estado de invlida no  possvel ger-la.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Isso  til se voc no quer que ningum obtenha o resultado da estatstica ou a estatstica no est configurada totalmente.',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => 'Selecione os elementos para cada conjunto de valores',
        'Scale' => 'Escala',
        'minimal' => 'mnimo',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Lembre que a escala para o conjunto de valores deve ser mair que o eixo X (ex.: Eixo X => Ms, Conjunto de Valores => Ano).',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => ' possvel escolher um ou dois elementos. Ento voc pode selecionar os atributos dos elementos. Cada atributo ser mostrado como um conjunto nico de valores. Se voc no selecionar nenhum atributo, todos os atributos do elemento sero utilizados para gerar a estatstica. Assim como um novo atributo  adicionado desde a ltima configurao.',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => 'Selecione o elemento que ser usado no eixo X',
        'maximal period' => 'perodo mximo',
        'minimal scale' => 'perodo mnimo',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Aqui voc pode definir o eixo-x. Voc pode selecionar um elemento via boto de rdio. Se voc no fizer uma seleo, todos os atributos do elemento sero usados se voc gerar uma estatstica. Assim como um novo atributo  adicionado desde a ltima configurao.',

        # Template: AgentStatsImport
        'Import' => 'Importar',
        'File is not a Stats config' => 'Este no  um arquivo de configurao',
        'No File selected' => 'Nenhum arquivo selecionado',

        # Template: AgentStatsOverview
        'Results' => 'Resultados',
        'Total hits' => 'Total de acertos',
        'Page' => 'Pgina',

        # Template: AgentStatsPrint
        'Print' => 'Imprimir',
        'No Element selected.' => 'Nenhum elemento selecionado.',

        # Template: AgentStatsView
        'Export Config' => 'Exportar Configurao',
        'Information about the Stat' => 'Informaes sobre a Estatstica',
        'Exchange Axis' => 'Trocar Eixo',
        'Configurable params of static stat' => 'Parmetros configurveis da estatstica esttica',
        'No element selected.' => 'Nenhum elemento selecionado.',
        'maximal period from' => 'mximo perdo de',
        'to' => 'para',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'Com os campos de insero e seleo, voc pode configurar a estatstica de acordo com a sua necessidade. Os elementos da estatstica que voc pode editar dependem das permisses concedidas a voc pelo administrador do sistema.',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => 'Uma mensagem deve possuir um To: destinatrio!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Voc precisa de um endereo de email (exemplo: cliente@exemplo.com.br) no To:!',
        'Bounce ticket' => 'Devolver solicitao',
        'Ticket locked!' => 'Solicitao bloqueada!',
        'Ticket unlock!' => 'Solicitao desbloqueada!',
        'Bounce to' => 'Devolver para',
        'Next ticket state' => 'Prximo estado da solicitao',
        'Inform sender' => 'Informe o remetente',
        'Send mail!' => 'Enviar email!',

        # Template: AgentTicketBulk
        'You need to account time!' => 'Voc deve contabilizar o tempo!',
        'Ticket Bulk Action' => 'Ao em Massa em Solicitao',
        'Spell Check' => 'Checar Ortografia',
        'Note type' => 'Tipo de nota',
        'Next state' => 'Prximo estado',
        'Pending date' => 'Data de pendncia',
        'Merge to' => 'Agrupar com',
        'Merge to oldest' => 'Agrupar com a mais antiga',
        'Link together' => 'Associar junto',
        'Link to Parent' => 'Associar a Pai',
        'Unlock Tickets' => 'Desbloquear Solicitaes',

        # Template: AgentTicketClose
        'Ticket Type is required!' => 'Tipo de solicitao  requerido!',
        'A required field is:' => 'Campo requerido :',
        'Close ticket' => 'Fechar a solicitao',
        'Previous Owner' => 'Dono Anterior',
        'Inform Agent' => 'Informar Atendente',
        'Optional' => 'Opcional',
        'Inform involved Agents' => 'Informar os atendentes envolvidos',
        'Attach' => 'Anexo',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => 'A mensagem necessita ser verificada ortograficamente!',
        'Compose answer for ticket' => 'Compr uma resposta para a solicitao',
        'Pending Date' => 'Data de Pendncia',
        'for pending* states' => 'em estado pendente*',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Modificar o cliente da solicitao',
        'Set customer user and customer id of a ticket' => 'Configurar usurio e id do cliente na solicitao',
        'Customer User' => 'Cliente',
        'Search Customer' => 'Busca do cliente',
        'Customer Data' => 'Dados do Cliente',
        'Customer history' => 'Histrico do cliente',
        'All customer tickets.' => 'Todas as solicitaes do cliente',

        # Template: AgentTicketEmail
        'Compose Email' => 'Compor E-mail',
        'new ticket' => 'Nova Solicitao',
        'Refresh' => 'Atualizar',
        'Clear To' => 'Limpar',
        'All Agents' => 'Todos os Atendentes',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => 'Tipo de artigo',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'Alterar os campos em branco na solicitao',

        # Template: AgentTicketHistory
        'History of' => 'Histrico de',

        # Template: AgentTicketLocked
        'My Locked Tickets' => 'Minhas solicitaes bloqueadas',

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => 'Voc deve utilizar um nmero da solicitao!',
        'Ticket Merge' => 'Agrupar Solicitao',

        # Template: AgentTicketMove
        'If you want to account time, please provide Subject and Text!' => '',
        'Move Ticket' => 'Mover Solicitao',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Adicionar nota  solicitao',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => '',
        'Service Time' => '',
        'Update Time' => '',
        'Solution Time' => '',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => 'Voc deve selecionar ao menos 1(uma) solicitao!',

        # Template: AgentTicketOverviewNavBar
        'Filter' => 'Filtro',
        'Change search options' => 'Alterar as oes de busca',
        'Tickets' => 'Solicitaes',
        'of' => 'de',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => 'Compor Resposta',
        'Contact customer' => 'Contatar cliente',
        'Change queue' => 'Modificar fila',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => 'ordem crescente',
        'up' => 'normal',
        'sort downward' => 'ordem decrescente',
        'down' => 'inversa',
        'Escalation in' => 'Escalada em',
        'Locked' => 'Bloqueio',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Modificar o proprietrio ds solicitao',

        # Template: AgentTicketPending
        'Set Pending' => 'Marcar Pendente',

        # Template: AgentTicketPhone
        'Phone call' => 'Chamada telefnica',
        'Clear From' => 'Limpar',
        'Next ticket state' => 'Prximo status da solicitao',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Texto',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Dados da Solicitao',
        'Accounted time' => 'Tempo contabilizado',
        'Linked-Object' => 'Objeto "Linkado"',
        'by' => 'por',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'Modificar a prioridade da solicitao',

        # Template: AgentTicketQueue
        'Tickets shown' => 'Solicitaes mostradas',
        'Tickets available' => 'Solicitaes disponveis',
        'All tickets' => 'Todas as solicitaes',
        'Queues' => 'Filas',
        'Ticket escalation!' => 'Escalao de solicitaes!',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => 'Alterar o responsvel pela solicitao',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Busca de Solicitao',
        'Profile' => 'Perfil',
        'Search-Template' => 'Modelo de Busca',
        'TicketFreeText' => 'Texto livre Solicitao',
        'Created in Queue' => 'Criado na Fila',
        'Article Create Times' => 'Horrio da Criao do Artigo',
        'Article created' => 'Artigo criado',
        'Article created between' => 'Artigo criado entre',
        'Change Times' => 'Horrio de Alterao',
        'No change time settings.' => 'Ignorar horrios de alterao.',
        'Ticket changed' => 'Solicitao alterada',
        'Ticket changed between' => 'Solicitao alterada entre',
        'Result Form' => 'Resultado',
        'Save Search-Profile as Template?' => 'Salvar o Perfil de Busca como Modelo?',
        'Yes, save it with name' => 'Sim, salve-o com o nome',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext
        'Fulltext' => 'Texto Completo',

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => 'Viso Expandida',
        'Collapse View' => 'Viso Recolhida',
        'Split' => 'Dividir',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => 'Configuraes de filtro de artigos',
        'Save filter settings as default' => 'Salvar configuraes de filtro como padro',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => '',

        # Template: CustomerFooter
        'Powered by' => 'Desenvolvido por',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => '',
        'Lost your password?' => 'Esqueceu sua senha?',
        'Request new password' => 'Solicitar uma nova senha',
        'Create Account' => 'Criar Conta',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Bem-vindo %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Hora',
        'No time settings.' => 'Sem configuraes de hora.',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Clique aqui para relatar um erro!',

        # Template: Footer
        'Top of Page' => 'Topo da Pgina',

        # Template: FooterSmall

        # Template: Header
        'Home' => 'Incio',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Instalador Web',
        'Welcome to %s' => 'Bem-vindo ao %s',
        'Accept license' => 'Aceitar licena',
        'Don\'t accept license' => 'No aceitar licena',
        'Admin-User' => 'Usurio do Administrador',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => '',
        'Admin-Password' => 'Senha do Administrador',
        'Database-User' => 'Usurio da Base',
        'default \'hot\'' => 'padro \'hot\'',
        'DB connect host' => 'Servidor da Base',
        'Database' => 'Base de Dados',
        'Default Charset' => 'Conjunto de Caracteres Padro',
        'utf8' => '',
        'false' => 'falso',
        'SystemID' => 'ID do sistema',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(A identidade do sistema. Cada nmero de solicitao e cada id. da sesso http, inicia com este nmero)',
        'System FQDN' => 'FQDN do sistema',
        '(Full qualified domain name of your system)' => '(Nome completo do domnio de seu sistema)',
        'AdminEmail' => 'Email do Administrador',
        '(Email of the system admin)' => '(Email do administrador do sistema)',
        'Organization' => 'Organizao',
        'Log' => '',
        'LogModule' => 'Mdulo LOG',
        '(Used log backend)' => '(Utilizado LOG como base)',
        'Logfile' => 'Arquivo de registro',
        '(Logfile just needed for File-LogModule!)' => '(Arquivo de registro para File-LogModule)',
        'Webfrontend' => 'Interface Web',
        'Use utf-8 it your database supports it!' => 'Use UTF-8 se sua base de dados suportar!',
        'Default Language' => 'Idioma Padro',
        '(Used default language)' => '(Idioma padro utilizado)',
        'CheckMXRecord' => 'Averiguar MX',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => 'Checar os registros do MX de endereos de e-mail utilizados na composio de uma resposta. No utilizar checagem de registros do MX se o seu servidor OTRS estiver sib um acesso discado $!',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Para poder utilizar o OTRS voc deve',
        'Restart your webserver' => 'Reiniciar o Webserver',
        'After doing so your OTRS is up and running.' => 'Aps isto, ento seu OTRS est funcionando.',
        'Start page' => 'Iniciar pgina',
        'Your OTRS Team' => 'Sua Equipe de Suporte',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Sem Permisso',

        # Template: Notify
        'Important' => 'Importante',

        # Template: PrintFooter
        'URL' => '',

        # Template: PrintHeader
        'printed by' => 'Impresso por',

        # Template: PublicDefault

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'Pgina de Teste do Gerenciador de Solicitaes',
        'Counter' => 'Contador',

        # Template: Warning

        # Template: YUI

        # Misc
        'Create Database' => 'Criar Banco de Dados',
        'verified' => 'verificado',
        'File-Name' => 'Nome do Arquivo',
        'Ticket Number Generator' => 'Gerador de Nmero de Solicitao',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identificador da Solicitao. Algumas pessoas gostam de usar por exemplo \'Solicitao#\, \'Chamado#\' ou \'MinhaSolicitao#\')',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Neste caso, voc pode editar diretamente a "keyring" configurada no Kernel/Config.pm.',
        'Create new Phone Ticket' => 'Criar nova Solicitao Fone',
        'U' => 'C',
        'Site' => 'Site',
        'Customer history search (e. g. "ID342425").' => 'Busca no Histrico do cliente (exemplo: "ID342425")',
        'Can not delete link with %s!' => 'No  possvel deletar associao com %s!',
        'Close!' => 'Fechar!',
        'for agent firstname' => 'Nome do Atendente',
        'Reporter' => 'Relator',
        'Process-Path' => 'Caminho do Processo',
        'to get the realname of the sender (if given)' => 'para obter o nome do remetente (se possuir no email)',
        'FAQ Search Result' => 'Resultado da procura por FAQ',
        'Notification (Customer)' => 'Notificao (Cliente)',
        'CSV' => 'CSV',
        'Select Source (for add)' => 'Selecione Origem (para adio)',
        'Node-Name' => 'Nome do N',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',
        'Child-Object' => 'Objeto Filho',
        'Workflow Groups' => 'Grupos de Fluxo de Trabalho',
        'Current Impact Rating' => 'Taxa de Impacto Atual',
        'FAQ System History' => 'Histrico do Sistema de FAQ',
        'customer realname' => 'Nome real do cliente',
        'Pending messages' => 'Mensagens pendentes',
        'Modules' => 'Mdulos',
        'for agent login' => 'Login do Atendente',
        'Keyword' => 'Palavra-Chave',
        'Reference' => 'Referncia',
        'Close type' => 'Tipo de fechamento',
        'DB Admin User' => 'Usurio Administrador do DB',
        'for agent user id' => 'Id do Atendente',
        'Classification' => 'Classificao',
        'Change user <-> group settings' => 'Modificar configuraes de usurios <-> grupos',
        'Escalation' => 'Escalao',
        'Order' => 'Ordem',
        'next step' => 'prximo passo',
        'Follow up' => 'Continuao',
        'Customer history search' => 'Busca no Histrico do cliente',
        'not verified' => 'no verificado',
        'Stat#' => 'Estatstica N:.',
        'Create new database' => 'Criar novo banco de dados',
        'Year' => 'Ano',
        'X-axis' => 'Eixo-X',
        'Keywords' => 'Palavras-Chave',
        'Ticket Escalation View' => 'Viso Escalao de Solicitaes',
        'Today' => 'Hoje',
        'No * possible!' => 'No so possveis *!',
        'Load' => 'Carregar',
        'Change Time' => 'Horrio de Alterao',
        'Options of the current user who requested this action (e.g. OTRS_CURRENT_USERFIRSTNAME)' => 'Opes do usurio atual que requisitou esta ao (ex.: OTRS_CURRENT_USERFIRSTNAME)',
        'Message for new Owner' => 'Mensagem para um novo Proprietrio',
        'to get the first 5 lines of the email' => 'para obter as 5 primeiras linhas do email',
        'Sent new password to: ' => 'Enviada nova senha para: ',
        'Sort by' => 'Ordenado pela',
        'OTRS DB Password' => 'Password do OTRS DB',
        'Last update' => 'ltima Atualizao',
        'Tomorrow' => 'Amanh',
        'not rated' => 'no avaliado',
        'to get the first 20 character of the subject' => 'para obter os 20 primeiros caracteres do assunto',
        'Select the customeruser:service relations.' => 'Selecione as relaes cliente:servio.',
        'DB Admin Password' => 'Password de Administrador do DB',
        'Drop Database' => 'Deletar Database',
        'Options of the current customer user data (e. g. OTRS_CUSTOMER_DATA_USERFIRSTNAME)' => 'Opes de dados do usurio do cliente atual (ex.: OTRS_CUSTOMER_DATA_USERFIRSTNAME)',
        'Pending type' => 'Tipo de pendncia',
        'Comment (internal)' => 'Comentrio (interno)',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opes do proprietrio da solicitao (z. B. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'User-Number' => 'Nmero-Usurio',
        'Options of the ticket data (e. g. OTRS_TICKET_TicketNumber, OTRS_TICKET_TicketID, OTRS_TICKET_Queue, OTRS_TICKET_State)' => 'Opes de dados da solicitao (e. g. OTRS_TICKET_TicketNumber, OTRS_TICKET_TicketID, OTRS_TICKET_Queue, OTRS_TICKET_State)',
        '(Used ticket number format)' => '(Formato usado do nmero da solicitao)',
        'Reminder' => 'Lembretes',
        'Month' => 'Ms',
        'Node-Address' => 'Endereo-N',
        'All Agent variables.' => 'Todas as variveis do Atendente',
        ' (work units)' => ' (unidades de trabalho)',
        'Next Week' => 'Prxima Semana',
        'You use the DELETE option! Take care, all deleted Tickets are lost!!!' => 'Voc usou a opo DELETAR! Cuidado, todas as solicitao apagadas sero perdidas!!!',
        'All Customer variables like defined in config option CustomerUser.' => 'Todas as variveis do cliente como foram definidas nas opes de configurao de "usurio"',
        'for agent lastname' => 'Sobrenome do Atendente',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Opes do atual usurio que solicitou a ao (e. g. <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages' => 'Mensagens com lembretes',
        'Parent-Object' => 'Objeto-Pai',
        'Of couse this feature will take some system performance it self!' => 'Com certeza esta funcionalidade ir consumir certa quantidade de recursos do sistema!',
        'Your own Ticket' => 'Sua prpria solicitao',
        'Detail' => 'Detalhe',
        'TicketZoom' => 'Detalhe da Solicitao',
        'Don\'t forget to add a new user to groups!' => 'No se esquea de adicionar o novo usurio a grupos!',
        'Open Tickets' => 'Solicitaes Abertas',
        'CreateTicket' => 'Criar Solicitao',
        'unknown' => 'desconhecido',
        'System Settings' => 'Configuraes Sistema',
        'Finished' => 'Finalizado',
        'Imported' => 'Importado',
        'unread' => 'no lida',
        'Ticket Number Generator' => 'Gerador de Nmeros de Solicitaes',
        'Change roles <-> groups settings' => 'Alterar configuraes Papis <-> Grupos',
        'Edit Article' => 'Editar Artigo',
        'No means, send agent and customer notifications on changes.' => 'No siginifica \'envie notificaes ao atendente e ao cliente nas alteraes\'.',
        'A web calendar' => 'Um calendrio online',
        'Config options (e. g. OTRS_CONFIG_HttpType)' => 'Opes de configurao (ex.: OTRS_CONFIG_HttpType)',
        'Queue ID' => 'ID da Fila',
        'Locked tickets' => 'Solicitaes bloqueadas',
        'System History' => 'Histrico do Sistema',
        'Problem' => 'Problema',
        '"}' => '',
        'Admin-Email' => 'E-mail Admin.',
        'Options of the ticket data (e. g. OTRS_TICKET_Number, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State)' => 'Opes de dados da solicitao (ex.: OTRS_TICKET_Number, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State;)',
        'ArticleID' => 'Id. do Artigo',
        'Options ' => 'Opes ',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => '',
        'Advisory' => 'Aviso',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Aqui voc pode definir o eixo X. Voc pode selecionar um elemento atravs do \'radio button\'. Ento voc deve selecionar dois ou mais atributos do elemento. Se no efetuou nenhum seleo, todos os atributos do elemento sero utilizados se voc gerar uma estatstica. Assim como um novo atributo  adicionado desde a ltima configurao.',
        'FileManager' => 'Adm Arquivo',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opes de dono da solicitao (ex.: &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Incident' => 'Incidente',
        'accept license' => 'aceitar licena',
        'Of couse this feature will take some system performance it self!' => '',
        'Don\'t forget to add a new user to groups!' => 'No esquea de adicionar um novo usurio nos grupos!',
        'You have to select two or more attributes from the select field!' => 'Voc deve selecionar dois ou mais atributos no campo \'selecionar\'!',
        'WebWatcher' => 'Visitante',
        'D' => 'D',
        'All messages' => 'Todas as mensagens',
        'Artefact' => 'Artefato',
        'Object already linked as %s.' => 'Objeto j associado como %s.',
        'A article should have a title!' => 'O Artigo dever ter um Ttulo!',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
        'Customer Users <-> Services' => 'Clientes <-> Servios',
        'All email addresses get excluded on replaying on composing and email.' => '',
        'don\'t accept license' => 'no acentiar a licena',
        'A web mail client' => 'Webmail Cliente',
        'Compose Follow up' => 'Compor Continuao',
        'WebMail' => '',
        'kill all sessions' => 'Finalizar todas as sesses',
        'to get the from line of the email' => 'para obter a linha "From" do email',
        'Solution' => 'Soluo',
        'QueueView' => 'Fila',
        'Options of the ticket data (e. g. OTRS_TICKET_TicketNumber, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State)' => 'Opes de dados da solicitao (ex.: OTRS_TICKET_TicketNumber, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State)',
        'Select Box' => 'Caixa de Seleo',
        'New messages' => 'Mensagens novas',
        'Can not create link with %s!' => 'No foi possvel associar com %s!',
        'Linked as' => 'Associado como',
        'Welcome to OTRS' => 'Bem-vindo ao OTRS',
        'modified' => 'modificado',
        'A web file manager' => 'Gerenciador de Arquivos Web',
        'Have a lot of fun!' => 'Divirta-se!',
        'send' => 'enviar',
        'Send no notifications' => 'No enviar notificaes',
        'Note Text' => 'Nota',
        'POP3 Account Management' => 'Gerenciamento de Contas POP3',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Opes de informaes do cliente (ex.: &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'System State Management' => 'Gerenciamento de Estados do Sistema',
        'Mailbox' => 'Caixa de Entrada',
        'PhoneView' => 'Chamada',
        'maximal period form' => 'formulrio de perodo mximo',
        'TicketID' => 'Id. da Solicitao',
        'Escaladed Tickets' => 'Solicitaes Escaladas',
        'Yes means, send no agent and customer notifications on changes.' => 'Sim significa \'no envie notificaes ao atendente e ao cliente nas alteraes\'.',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Seu email com o nmero de solicitao "<OTRS_TICKET>" foi devolvido para "<OTRS_BOUNCE_TO>". Contate este endereo para mais informaes.',
        'Ticket Status View' => 'Visualizao do Status da Solicitao',
        'Modified' => 'Modificado',
        'Ticket selected for bulk action!' => 'Solicitao selecionada para execuo de ao em massa!',
        '%s is not writable!' => '%s  somente leitura!',
        'Cannot create %s!' => 'No foi possvel criar %s!',
        'Symptom' => 'Sintoma',
    };
    # $$STOP$$
    return;
}

1;
