# --
# Kernel/Language/pt_BR.pm - provides pt_BR language translation
# Copyright (C) 2003 Gilberto Cezar de Almeida <gibalmeida at hotmail.com>
# Copyright (C) 2005 Alterado por Glaucia C. Messina (glauglauu@yahoo.com)
# Copyright (C) 2007 Fabricio Luiz Machado <soprobr gmail.com>
# --
# $Id: pt_BR.pm,v 1.89 2009/08/25 12:19:24 mb Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::pt_BR;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.89 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Sat Jun 27 13:55:35 2009

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%A %D %B %T %Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Sim',
        'No' => 'No',
        'yes' => 'sim',
        'no' => 'no',
        'Off' => 'Desligado',
        'off' => 'desligado',
        'On' => 'Ligado',
        'on' => 'ligado',
        'top' => 'incio',
        'end' => 'fim',
        'Done' => 'Feito',
        'Cancel' => 'Cancelar',
        'Reset' => 'Reiniciar',
        'last' => 'ltimo',
        'before' => 'antes',
        'day' => 'dia',
        'days' => 'dias',
        'day(s)' => 'dia(s)',
        'hour' => 'hora',
        'hours' => 'horas',
        'hour(s)' => 'hora(s)',
        'minute' => 'minuto',
        'minutes' => 'minutos',
        'minute(s)' => 'minuto(s)',
        'month' => 'ms',
        'months' => 'meses',
        'month(s)' => 'ms(s)',
        'week' => 'semana',
        'week(s)' => 'semana(s)',
        'year' => 'ano',
        'years' => 'anos',
        'year(s)' => 'ano(s)',
        'second(s)' => 'segundo(s)',
        'seconds' => 'segundos',
        'second' => 'segundo',
        'wrote' => 'escreveu',
        'Message' => 'Mensagem',
        'Error' => 'Erro',
        'Bug Report' => 'Relatrio de Erros',
        'Attention' => 'Ateno',
        'Warning' => 'Aviso',
        'Module' => 'Mdulo',
        'Modulefile' => 'Arquivo de Mdulo',
        'Subfunction' => 'Sub-funo',
        'Line' => 'Linha',
        'Setting' => '',
        'Settings' => '',
        'Example' => 'Exemplo',
        'Examples' => 'Exemplos',
        'valid' => 'vlido',
        'invalid' => 'invlido',
        '* invalid' => '',
        'invalid-temporarily' => 'invlido-temporariamente',
        ' 2 minutes' => ' 2 minutos',
        ' 5 minutes' => ' 5 minutos',
        ' 7 minutes' => ' 7 minutos',
        '10 minutes' => '10 minutos',
        '15 minutes' => '15 minutos',
        'Mr.' => 'Sr.',
        'Mrs.' => 'Sra.',
        'Next' => 'Prximo',
        'Back' => 'Voltar',
        'Next...' => 'Prximo',
        '...Back' => '...Voltar',
        '-none-' => 'vazio',
        'none' => 'vazio',
        'none!' => 'vazio!',
        'none - answered' => 'vazio  - respondido',
        'please do not edit!' => 'Por favor, no edite!',
        'AddLink' => 'Adicionar link',
        'Link' => '',
        'Unlink' => '',
        'Linked' => '',
        'Link (Normal)' => '',
        'Link (Parent)' => 'Link (Pai)',
        'Link (Child)' => 'Link (Filho)',
        'Normal' => '',
        'Parent' => 'Pai',
        'Child' => 'Filho',
        'Hit' => 'Acesso',
        'Hits' => 'Acessos',
        'Text' => 'Texto',
        'Lite' => 'Simples',
        'User' => 'Usurio',
        'Username' => 'Login',
        'Language' => 'Idioma',
        'Languages' => 'Idiomas',
        'Password' => 'Senha',
        'Salutation' => 'Tratamento (Sr./Sra)',
        'Signature' => 'Assinatura',
        'Customer' => 'Cliente',
        'CustomerID' => 'ID.do Cliente',
        'CustomerIDs' => 'IDs do Cliente',
        'customer' => 'cliente',
        'agent' => 'Atendente',
        'system' => 'sistema',
        'Customer Info' => 'Informao do Cliente',
        'Customer Company' => '',
        'Company' => '',
        'go!' => 'ir!',
        'go' => 'ir',
        'All' => 'Todos',
        'all' => 'todos',
        'Sorry' => 'Desculpe',
        'update!' => 'atualizar!',
        'update' => 'atualizar',
        'Update' => 'Atualizar',
        'Updated!' => '',
        'submit!' => 'Enviar!',
        'submit' => 'enviar',
        'Submit' => 'Enviar',
        'change!' => 'alterar!',
        'Change' => 'Alterar',
        'change' => 'alterar',
        'click here' => 'clique aqui',
        'Comment' => 'Comentrio',
        'Valid' => 'Vlido',
        'Invalid Option!' => 'Opo Invlida',
        'Invalid time!' => 'Hora Invlida',
        'Invalid date!' => 'Data Invlida',
        'Name' => 'Nome',
        'Group' => 'Grupo',
        'Description' => 'Descrio',
        'description' => 'descrio',
        'Theme' => 'Tema',
        'Created' => 'Criado',
        'Created by' => 'Criado por',
        'Changed' => 'Alterado',
        'Changed by' => 'Alterado por',
        'Search' => 'Buscar',
        'and' => 'e',
        'between' => 'entre',
        'Fulltext Search' => 'Busca por texto completo',
        'Data' => 'Dado',
        'Options' => 'Opes',
        'Title' => 'Ttulo',
        'Item' => '',
        'Delete' => 'Excluir',
        'Edit' => 'Editar',
        'View' => 'Ver',
        'Number' => 'Nmero',
        'System' => 'Sistema',
        'Contact' => 'Contato',
        'Contacts' => 'Contatos',
        'Export' => 'Exportar',
        'Up' => 'Acima',
        'Down' => 'Abaixo',
        'Add' => 'Adicionar',
        'Added!' => '',
        'Category' => 'Categoria',
        'Viewer' => 'Visualizao',
        'Expand' => '',
        'New message' => 'Nova mensagem',
        'New message!' => 'Nova mensagem!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Por favor, responda este(s) chamado(s) para retornar a fila!',
        'You got new message!' => 'Voc recebeu uma nova mensagem',
        'You have %s new message(s)!' => 'Voc tem %s nova(s) mensagem(s)!',
        'You have %s reminder ticket(s)!' => 'Voc tem %s chamado(s) remanescente(s)',
        'The recommended charset for your language is %s!' => 'O conjunto de caracteres recomendado para o seu idioma  %s!',
        'Passwords doesn\'t match! Please try it again!' => 'Senha incorreta! Tente novamente!',
        'Password is already in use! Please use an other password!' => 'Senha em uso! Tente outra senha!',
        'Password is already used! Please use an other password!' => 'Senha est sendo utilizada! Tente outra senha!',
        'You need to activate %s first to use it!' => 'Primeiramente ative %s, para uso!',
        'No suggestions' => 'Sem sugestes',
        'Word' => 'Palavra',
        'Ignore' => 'Ignorar',
        'replace with' => 'substituir com',
        'There is no account with that login name.' => 'No existe conta com este nome de usurio',
        'Login failed! Your username or password was entered incorrectly.' => 'Login incorreto! Seu Login  ou senha foram informados incorretamente.',
        'Please contact your admin' => 'Por favor, contate administrador do sistema!',
        'Logout successful. Thank you for using OTRS!' => 'Encerrado com sucesso. Obrigado por utilizar o OTRS!',
        'Invalid SessionID!' => 'Identificao de Sesso Invlida',
        'Feature not active!' => 'Funo no ativada!',
        'Notification (Event)' => '',
        'Login is needed!' => '',
        'Password is needed!' => 'Senha  obrigatria!',
        'License' => 'Licena',
        'Take this Customer' => 'Atenda este Cliente',
        'Take this User' => 'Atenda este Usurio',
        'possible' => 'possvel',
        'reject' => 'rejeitar',
        'reverse' => 'reverso',
        'Facility' => 'Facilidade',
        'Timeover' => 'Tempo esgotado',
        'Pending till' => 'Gaveta pendente',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'No trabalhe com o UserID 1(Conta do Sistema)! Crie novos usurios!',
        'Dispatching by email To: field.' => 'Despachar pelo PARA:  email',
        'Dispatching by selected Queue.' => 'Despachar pela fila selecionada',
        'No entry found!' => 'No h entradas!',
        'Session has timed out. Please log in again.' => 'Tempo esgotado de sesso. Entre novamente.',
        'No Permission!' => 'Sem permisso!',
        'To: (%s) replaced with database email!' => 'PARA: (%s)  alterado!',
        'Cc: (%s) added database email!' => 'CC: (%s) adicionado! ',
        '(Click here to add)' => '(Clique aqui para adicionar)',
        'Preview' => 'Visualizar',
        'Package not correctly deployed! You should reinstall the Package again!' => 'O pacote no foi instalado coretamente! Voc deve reinstal-lo!',
        'Added User "%s"' => 'Usurio Adicionado "%s"',
        'Contract' => 'Contrato',
        'Online Customer: %s' => 'Clientes Online: %s',
        'Online Agent: %s' => 'Atendentes Online: %s',
        'Calendar' => 'Calendrio',
        'File' => 'Arquivo',
        'Filename' => 'Nome Arquivo',
        'Type' => 'Tipo',
        'Size' => 'Tam',
        'Upload' => '',
        'Directory' => 'Diretrio',
        'Signed' => 'Assinado',
        'Sign' => 'Assinar',
        'Crypted' => 'Criptografado',
        'Crypt' => 'Criptografar',
        'Office' => 'Escritrio',
        'Phone' => 'Telefone',
        'Fax' => '',
        'Mobile' => 'Celular',
        'Zip' => 'CEP',
        'City' => 'Cidade',
        'Street' => 'Rua',
        'Country' => 'Pas',
        'Location' => 'Locao',
        'installed' => 'instalado',
        'uninstalled' => 'desinstalado',
        'Security Note: You should activate %s because application is already running!' => '',
        'Unable to parse Online Repository index document!' => '',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => '',
        'No Packages or no new Packages in selected Online Repository!' => '',
        'printed at' => 'impresso em',
        'Dear Mr. %s,' => '',
        'Dear Mrs. %s,' => '',
        'Dear %s,' => '',
        'Hello %s,' => '',
        'This account exists.' => '',
        'New account created. Sent Login-Account to %s.' => '',
        'Please press Back and try again.' => '',
        'Sent password token to: %s' => '',
        'Sent new password to: %s' => '',
        'Upcoming Events' => '',
        'Event' => '',
        'Events' => '',
        'Invalid Token!' => '',
        'more' => '',
        'For more info see:' => '',
        'Package verification failed!' => '',
        'Collapse' => '',
        'News' => '',
        'Product News' => '',
        'Bold' => '',
        'Italic' => '',
        'Underline' => '',
        'Font Color' => '',
        'Background Color' => '',
        'Remove Formatting' => '',
        'Show/Hide Hidden Elements' => '',
        'Align Left' => '',
        'Align Center' => '',
        'Align Right' => '',
        'Justify' => '',
        'Header' => 'Cabealho',
        'Indent' => '',
        'Outdent' => '',
        'Create an Unordered List' => '',
        'Create an Ordered List' => '',
        'HTML Link' => '',
        'Insert Image' => '',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => '',
        'Redo' => '',

        # Template: AAAMonth
        'Jan' => '',
        'Feb' => 'Fev',
        'Mar' => '',
        'Apr' => 'Abr',
        'May' => 'Mai',
        'Jun' => '',
        'Jul' => '',
        'Aug' => 'Ago',
        'Sep' => 'Set',
        'Oct' => 'Out',
        'Nov' => '',
        'Dec' => 'Dez',
        'January' => 'Janeiro',
        'February' => 'Fevereiro',
        'March' => 'Maro',
        'April' => 'Abril',
        'May_long' => 'Maio',
        'June' => 'Junho',
        'July' => 'Julho',
        'August' => 'Agosto',
        'September' => 'Setembro',
        'October' => 'Outubro',
        'November' => 'Novembro',
        'December' => 'Dezembro',

        # Template: AAANavBar
        'Admin-Area' => 'rea-Administrao',
        'Agent-Area' => 'rea-Atendente',
        'Ticket-Area' => 'rea-Chamado',
        'Logout' => 'Sair',
        'Agent Preferences' => 'Preferncias Atendente',
        'Preferences' => 'Preferncias',
        'Agent Mailbox' => 'Mailbox Atendente',
        'Stats' => 'Estatsticas',
        'Stats-Area' => 'rea-Estatsticas',
        'Admin' => '',
        'Customer Users' => 'Clientes',
        'Customer Users <-> Groups' => 'Clientes <-> Grupos',
        'Users <-> Groups' => 'Usurios <-> Grupos',
        'Roles' => 'Regras',
        'Roles <-> Users' => 'Regras <-> Usurios',
        'Roles <-> Groups' => 'Regras <-> Grupos',
        'Salutations' => 'Tratamentos (Sr./Sra.)',
        'Signatures' => 'Assinaturas',
        'Email Addresses' => 'E-mail',
        'Notifications' => 'Notificaes',
        'Category Tree' => 'Categorias',
        'Admin Notification' => 'Notificao Admin',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Preferncias atualizadas com sucesso!',
        'Mail Management' => 'Gerenciamento Mail',
        'Frontend' => 'Interface',
        'Other Options' => 'Outras Opes',
        'Change Password' => 'Trocar senha',
        'New password' => 'Nova senha',
        'New password again' => 'Repita sua nova senha',
        'Select your QueueView refresh time.' => 'Selecione o tempo de atualizao das Filas',
        'Select your frontend language.' => 'Selecione o Idioma.',
        'Select your frontend Charset.' => 'Selecione o Conjunto de Caracteres.',
        'Select your frontend Theme.' => 'Selecione o Tema.',
        'Select your frontend QueueView.' => 'Selecione a Viso da Fila.',
        'Spelling Dictionary' => 'Dicionrio (Lngua)',
        'Select your default spelling dictionary.' => 'Escolha o seu corretor ortogrfico padro.',
        'Max. shown Tickets a page in Overview.' => 'Max. Chamados em uma tela.',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Senha no atualizada, por que esto diferentes! Tente novamente!',
        'Can\'t update password, invalid characters!' => 'Senha no atualizada, caracteres invlidos!',
        'Can\'t update password, must be at least %s characters!' => 'Senha no atualizada, digite no mnimo %s caracteres!',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Senha no atualizada, digite no mnimo 2 caracteres minsculos e 2 maisculos',
        'Can\'t update password, needs at least 1 digit!' => 'Senha no atualizada, digite no mnimo 1 nmero',
        'Can\'t update password, needs at least 2 characters!' => 'Senha no atualizada, digite no mnimo 2 caracteres',

        # Template: AAAStats
        'Stat' => 'Status',
        'Please fill out the required fields!' => 'Por favor, preencha os campos obrigatrios!',
        'Please select a file!' => 'Por favor, selecione um arquivo!',
        'Please select an object!' => 'Por favor, selecione um objeto!',
        'Please select a graph size!' => 'Por favor, selecione o tamanho do grfico!',
        'Please select one element for the X-axis!' => 'Por favor, selecione um elemento do eixo X!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Por favor, selecione somente um elemento ou desmarque o boto \'Fixo\' onde o campo selecionado est marcado!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Se voc utiliza um checkbox, deves selecionar alguns atributos no campo \'selecionar\'!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Por favor, insira um valor no campo selecionado ou desmarque a checkbox \'Fixo\'!',
        'The selected end time is before the start time!' => 'A data final  anterior  data inicial!',
        'You have to select one or more attributes from the select field!' => 'Voc deve selecionar ao menos um atributo no campo \'selecionar\'!',
        'The selected Date isn\'t valid!' => 'A data selecionada  invlida!',
        'Please select only one or two elements via the checkbox!' => 'Por favor, selecione apenas um ou dois elementos atravs da checkbox!',
        'If you use a time scale element you can only select one element!' => 'Se voc usa um elemento como parmetro de tempo, deves selecionar apenas um elemento!',
        'You have an error in your time selection!' => 'Voc tem um erro na hora selecionada!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'O intervalo de tempo para o aviso  muito pequeno, por favor, utilize um perodo maior!',
        'The selected start time is before the allowed start time!' => 'A data inicial selecionada  anterior  permitida!',
        'The selected end time is after the allowed end time!' => 'A data final selecionada  posterior  permitida!',
        'The selected time period is larger than the allowed time period!' => 'O perodo de tempo selecionado  maior do que o permitido!',
        'Common Specification' => 'Especificao Comum',
        'Xaxis' => 'Eixo X',
        'Value Series' => 'Sequncia de Valores',
        'Restrictions' => 'Restries',
        'graph-lines' => 'grfico de linhas',
        'graph-bars' => 'grfico de barras',
        'graph-hbars' => 'grfico de barras\(2\)',
        'graph-points' => 'grfico de pontos',
        'graph-lines-points' => 'grfico de linhas e pontos',
        'graph-area' => 'grfico de rea',
        'graph-pie' => 'grfico de pizza',
        'extended' => 'extendido',
        'Agent/Owner' => 'Atendente/Proprietrio',
        'Created by Agent/Owner' => 'Criado pelo Atendente/Proprietrio',
        'Created Priority' => 'Prioridade',
        'Created State' => 'Status',
        'Create Time' => 'Data/Hora',
        'CustomerUserLogin' => 'Usurio do Cliente',
        'Close Time' => 'Data/Hora de Fechamento',
        'TicketAccumulation' => '',
        'Attributes to be printed' => '',
        'Sort sequence' => '',
        'Order by' => '',
        'Limit' => 'Limite',
        'Ticketlist' => '',
        'ascending' => '',
        'descending' => '',
        'First Lock' => '',
        'Evaluation by' => '',
        'Total Time' => '',
        'Ticket Average' => '',
        'Ticket Min Time' => '',
        'Ticket Max Time' => '',
        'Number of Tickets' => '',
        'Article Average' => '',
        'Article Min Time' => '',
        'Article Max Time' => '',
        'Number of Articles' => '',
        'Accounted time by Agent' => '',
        'Ticket/Article Accounted Time' => '',
        'TicketAccountedTime' => '',
        'Ticket Create Time' => '',
        'Ticket Close Time' => '',

        # Template: AAATicket
        'Lock' => 'Bloquear',
        'Unlock' => 'Desbloquear',
        'History' => 'Histrico',
        'Zoom' => 'Detalhes',
        'Age' => 'Tempo',
        'Bounce' => 'Devolver',
        'Forward' => 'Encaminhar',
        'From' => 'De',
        'To' => 'Para',
        'Cc' => 'Cpia ',
        'Bcc' => 'Cpia Oculta',
        'Subject' => 'Assunto',
        'Move' => 'Mover',
        'Queue' => 'Fila',
        'Priority' => 'Prioridade',
        'Priority Update' => '',
        'State' => 'Estado',
        'Compose' => 'Compr',
        'Pending' => 'Pendentes',
        'Owner' => 'Proprietrio',
        'Owner Update' => 'Atualizao Proprietrio',
        'Responsible' => 'Responsvel',
        'Responsible Update' => 'Atualizao do Responsvel',
        'Sender' => 'Remetente',
        'Article' => 'Artigo',
        'Ticket' => 'Chamado',
        'Createtime' => 'Hora de criao',
        'plain' => 'texto',
        'Email' => 'E-mail',
        'email' => 'mail',
        'Close' => 'Fechar',
        'Action' => 'Ao',
        'Attachment' => 'Anexo',
        'Attachments' => 'Anexos',
        'This message was written in a character set other than your own.' => 'Esta mensagem foi escrita utilizando um conjunto de caracteres diferente do seu.',
        'If it is not displayed correctly,' => 'Se ele no for exibido corretamente,',
        'This is a' => 'Este  um',
        'to open it in a new window.' => 'para abri-lo em uma nova janela.',
        'This is a HTML email. Click here to show it.' => 'Este e-mail est em formato HTML. Clique aqui para exibi-lo.',
        'Free Fields' => 'Campos Livres',
        'Merge' => 'Mesclar',
        'merged' => '',
        'closed successful' => 'fechado com xito',
        'closed unsuccessful' => 'fechado sem xito',
        'new' => 'novo',
        'open' => 'aberto',
        'Open' => '',
        'closed' => 'fechado',
        'Closed' => '',
        'removed' => 'removido',
        'pending reminder' => 'lembrete de pendente',
        'pending auto' => '',
        'pending auto close+' => 'pendente auto fechamento+',
        'pending auto close-' => 'pendente auto fechamento-',
        'email-external' => 'email-externo',
        'email-internal' => 'email-interno',
        'note-external' => 'nota-externa',
        'note-internal' => 'nota-interna',
        'note-report' => 'nota-relatrio',
        'phone' => 'telefone',
        'sms' => '',
        'webrequest' => 'Solicitar via web',
        'lock' => 'bloqueado',
        'unlock' => 'desbloquear',
        'very low' => 'muito baixo',
        'low' => 'baixo',
        'normal' => '',
        'high' => 'alto',
        'very high' => 'muito alto',
        '1 very low' => '1 muito baixo',
        '2 low' => '2 baixo',
        '3 normal' => '',
        '4 high' => '4 alto',
        '5 very high' => '5 muito alto',
        'Ticket "%s" created!' => 'Chamado "%s" criado!',
        'Ticket Number' => 'N Chamado',
        'Ticket Object' => 'Objeto Chamado',
        'No such Ticket Number "%s"! Can\'t link it!' => 'No existe o Chamado "%s"! No foi possvel "link-lo"',
        'Don\'t show closed Tickets' => 'No mostrar chamados fechados',
        'Show closed Tickets' => 'Mostrar chamados fechados',
        'New Article' => 'Novo Artigo',
        'Email-Ticket' => 'Chamado-Mail',
        'Create new Email Ticket' => 'Criar novo Mail Chamado',
        'Phone-Ticket' => 'Chamado-Fone',
        'Search Tickets' => 'Pesquisar Chamados',
        'Edit Customer Users' => 'Editar Clientes(Usurios)',
        'Edit Customer Company' => '',
        'Bulk Action' => 'Executar Ao',
        'Bulk Actions on Tickets' => 'Executar Ao nos Chamados',
        'Send Email and create a new Ticket' => 'Enviar mail e criar novo Chamado',
        'Create new Email Ticket and send this out (Outbound)' => '',
        'Create new Phone Ticket (Inbound)' => '',
        'Overview of all open Tickets' => 'Viso geral de todos Chamados abertos',
        'Locked Tickets' => 'Chamados Bloqueados',
        'Watched Tickets' => 'Chamados Monitorados',
        'Watched' => 'Monitorados',
        'Subscribe' => 'Cadastrar',
        'Unsubscribe' => 'Descadastrar',
        'Lock it to work on it!' => 'Bloquear para trabalhar com o Chamado!',
        'Unlock to give it back to the queue!' => 'Desbloqueie para envi-lo devolta  fila!',
        'Shows the ticket history!' => 'Apresentar histrico de Chamados',
        'Print this ticket!' => 'Imprimir este Chamado!',
        'Change the ticket priority!' => 'Alterar a prioridade do Chamado!',
        'Change the ticket free fields!' => 'Alterar os campos em branco no Chamado!',
        'Link this ticket to an other objects!' => '"Linkar" este Chamado com outros objetos!',
        'Change the ticket owner!' => 'Mudar proprietrio do Chamado!',
        'Change the ticket customer!' => 'Mudar o Cliente do Chamado',
        'Add a note to this ticket!' => 'Adicionar um Note neste Chamado!',
        'Merge this ticket!' => 'Agrupar este chamado!',
        'Set this ticket to pending!' => 'Marcar este Chamado como Pendente!',
        'Close this ticket!' => 'Feche este chamado!',
        'Look into a ticket!' => 'Olhe contedo de um chamado!',
        'Delete this ticket!' => 'Apague este Chamado',
        'Mark as Spam!' => 'Marque como Spam',
        'My Queues' => 'Minhas Filas',
        'Shown Tickets' => 'Mostrar Chamados',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'A sua mensagem com o chamado nmero "<OTRS_TICKET>" foi unido com o chamado nmero "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => '',
        'Ticket %s: first response time will be over in %s!' => '',
        'Ticket %s: update time is over (%s)!' => '',
        'Ticket %s: update time will be over in %s!' => '',
        'Ticket %s: solution time is over (%s)!' => '',
        'Ticket %s: solution time will be over in %s!' => '',
        'There are more escalated tickets!' => '',
        'New ticket notification' => 'Notificao de novo Chamado',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Envie-me uma notificao se h um Novo Chamado em "Minhas Filas".',
        'Follow up notification' => 'Notificao de continuao',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Notifique me se um cliente enviar uma continuao e sou o proprietrio do Chamado.',
        'Ticket lock timeout notification' => 'Notificao de bloqueio por tempo expirado',
        'Send me a notification if a ticket is unlocked by the system.' => 'Notifique me se um Chamado  desbloqueado pelo sistema.',
        'Move notification' => 'Notificao de movimentos',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Notifique-me se  Chamados foram movimentados para "Minhas Filas"',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Suas filas favoritas. Voc tambm ser notificado sobre estas filas via e-mail se habilitado.',
        'Custom Queue' => 'Fila Personalizada',
        'QueueView refresh time' => 'Tempo de atualizao das Filas',
        'Screen after new ticket' => 'Tela aps novo chamado',
        'Select your screen after creating a new ticket.' => 'Selecione a tela seguinte aps a criao de um novo chamado.',
        'Closed Tickets' => 'Chamados Fechados',
        'Show closed tickets.' => 'Apresentar chamados fechados.',
        'Max. shown Tickets a page in QueueView.' => 'N mximo de chamados apresentados por pgina.',
        'Watch notification' => '',
        'Send me a notification of an watched ticket like an owner of an ticket.' => '',
        'Out Of Office' => '',
        'Select your out of office time.' => '',
        'CompanyTickets' => 'Chamados da Empresa',
        'MyTickets' => 'Meus Chamados',
        'New Ticket' => 'Novo Chamado',
        'Create new Ticket' => 'Criar novo Chamado',
        'Customer called' => 'O Cliente Telefonou',
        'phone call' => 'Chamada Telefnica',
        'Reminder Reached' => '',
        'Reminder Tickets' => '',
        'Escalated Tickets' => '',
        'New Tickets' => '',
        'Open Tickets / Need to be answered' => '',
        'Tickets which need to be answered!' => '',
        'All new tickets!' => '',
        'All tickets which are escalated!' => '',
        'All tickets where the reminder date has reached!' => '',
        'Responses' => 'Respostas',
        'Responses <-> Queue' => 'Respostas <-> Fila',
        'Auto Responses' => 'Auto respostas',
        'Auto Responses <-> Queue' => 'Auto respostas <-> Fila',
        'Attachments <-> Responses' => 'Anexos <-> respostas',
        'History::Move' => 'Chamado foi movido para a Fila "%s" (%s) vinda da Fila "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'Novo Chamado  [%s] foi criado (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp for [%s]. %s',
        'History::SendAutoReject' => 'Rejeio automtica enviada para "%s".',
        'History::SendAutoReply' => 'Auto Resposta enviada para "%s".',
        'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
        'History::Forward' => 'Forwarded to "%s".',
        'History::Bounce' => 'Bounced to "%s".',
        'History::SendAnswer' => 'Email enviado para "%s".',
        'History::SendAgentNotification' => '"%s"-notificao enviada para "%s".',
        'History::SendCustomerNotification' => 'Notificao enviada para "%s".',
        'History::EmailAgent' => 'Email enviado para Cliente.',
        'History::EmailCustomer' => 'Email adicionado. %s',
        'History::PhoneCallAgent' => 'Atendente telefonou para Cliente.',
        'History::PhoneCallCustomer' => 'Cliente telefonou para Service Desk SAP.',
        'History::AddNote' => 'Nota adicionada (%s)',
        'History::Lock' => 'Chamado Bloqueado.',
        'History::Unlock' => 'Chamado Desbloqueado.',
        'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Atualizado: %s',
        'History::PriorityUpdate' => 'Prioridade atualizada por "%s" (%s) to "%s" (%s).',
        'History::OwnerUpdate' => 'Novo proprietrio  "%s" (ID=%s).',
        'History::LoopProtection' => 'Proteo de Loop! Auto resposta enviada para "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Atualizado: %s',
        'History::StateUpdate' => 'Old: "%s" Novo: "%s"',
        'History::TicketFreeTextUpdate' => 'Atualizado: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Requisio do Cliente via web.',
        'History::TicketLinkAdd' => 'Adicionados links ao Chamado "%s".',
        'History::TicketLinkDelete' => 'Links do Chamado Excludos "%s".',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',

        # Template: AAAWeekDay
        'Sun' => 'Dom',
        'Mon' => 'Seg',
        'Tue' => 'Ter',
        'Wed' => 'Qua',
        'Thu' => 'Qui',
        'Fri' => 'Sex',
        'Sat' => 'Sab',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Administrao de Anexos',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Administrao de Auto-Respostas',
        'Response' => 'Resposta',
        'Auto Response From' => 'Auto-Resposta De',
        'Note' => 'Nota',
        'Useable options' => 'Opes acessveis',
        'To get the first 20 character of the subject.' => '',
        'To get the first 5 lines of the email.' => '',
        'To get the realname of the sender (if given).' => '',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => '',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => '',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => '',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => '',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => '',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => '',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => '',
        'Search for' => 'Pesquisar por',
        'Add Customer Company' => '',
        'Add a new Customer Company.' => '',
        'List' => 'Lista',
        'This values are required.' => 'Estes valores so obrigatrios.',
        'This values are read only.' => 'Estes valores so apenas para leitura.',

        # Template: AdminCustomerUserForm
        'The message being composed has been closed.  Exiting.' => 'A mensagem sendo composta foi fechada. Saindo.',
        'This window must be called from compose window' => 'Esta janela deve ser chamada da janela de composio',
        'Customer User Management' => 'Administrao de Clientes',
        'Add Customer User' => '',
        'Source' => 'Origem',
        'Create' => 'Criar',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'O usurio do cliente ser necessrio para que exista um histrico do cliente e para login na rea de clientes.',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'Clientes <-> Admin Grupos',
        'Change %s settings' => 'Modificar %s configuraes',
        'Select the user:group permissions.' => 'Selecionar as permisses de  usurio:grupo.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Se nada estiver selecionado, ento no h nenhuma permisso neste grupo (os chamados no estaro disponveis para o usurio).',
        'Permission' => 'Permisses',
        'ro' => 'somente leitura',
        'Read only access to the ticket in this group/queue.' => 'Acesso Somente com Leitura de chamados neste grupo/fila',
        'rw' => 'leitura/escrita',
        'Full read and write access to the tickets in this group/queue.' => 'Acesso leitura e escrita  de chamados neste grupo/fila',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => '',
        'CustomerUser' => 'Usurio Cliente',
        'Service' => '',
        'Edit default services.' => '',
        'Search Result' => 'Resultado da Busca',
        'Allocate services to CustomerUser' => '',
        'Active' => 'Ativo',
        'Allocate CustomerUser to service' => '',

        # Template: AdminEmail
        'Message sent to' => 'Mensagem enviada para',
        'A message should have a subject!' => 'Uma mensagem deve conter um assunto!',
        'Recipients' => 'Destinatrios',
        'Body' => 'Corpo',
        'Send' => '',

        # Template: AdminGenericAgent
        'GenericAgent' => 'Atendente Genrico',
        'Job-List' => 'Lista de jobs',
        'Last run' => 'ltima execuo',
        'Run Now!' => 'Executar Agora',
        'x' => '',
        'Save Job as?' => 'Salvar job como',
        'Is Job Valid?' => 'O job  vlido?',
        'Is Job Valid' => 'O job  vlido.',
        'Schedule' => 'Agenda',
        'Currently this generic agent job will not run automatically.' => '',
        'To enable automatic execution select at least one value from minutes, hours and days!' => '',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Busca por texto completo no Artigo (ex.: "Mar*in" or "Baue*")',
        '(e. g. 10*5155 or 105658*)' => '(ex.: 10*5155 or 105658*)',
        '(e. g. 234321)' => '(ex.: 234321)',
        'Customer User Login' => 'Cliente Login',
        '(e. g. U5150)' => '(ex.: U5150)',
        'SLA' => '',
        'Agent' => 'Atendente',
        'Ticket Lock' => 'Chamado bloqueado',
        'TicketFreeFields' => 'Campos livres do Chamado',
        'Create Times' => '',
        'No create time settings.' => '',
        'Ticket created' => 'Chamado criado',
        'Ticket created between' => 'Chamado criado entre',
        'Close Times' => '',
        'No close time settings.' => '',
        'Ticket closed' => '',
        'Ticket closed between' => '',
        'Pending Times' => '',
        'No pending time settings.' => '',
        'Ticket pending time reached' => '',
        'Ticket pending time reached between' => '',
        'Escalation Times' => '',
        'No escalation time settings.' => '',
        'Ticket escalation time reached' => '',
        'Ticket escalation time reached between' => '',
        'Escalation - First Response Time' => '',
        'Ticket first response time reached' => '',
        'Ticket first response time reached between' => '',
        'Escalation - Update Time' => '',
        'Ticket update time reached' => '',
        'Ticket update time reached between' => '',
        'Escalation - Solution Time' => '',
        'Ticket solution time reached' => '',
        'Ticket solution time reached between' => '',
        'New Service' => '',
        'New SLA' => '',
        'New Priority' => 'Nova Prioridade',
        'New Queue' => 'Nova Fila',
        'New State' => 'Novo Estado',
        'New Agent' => 'Novo Atendente',
        'New Owner' => 'Novo Proprietrio',
        'New Customer' => 'Novo Cliente',
        'New Ticket Lock' => 'Chamado novo bloqueado',
        'New Type' => '',
        'New Title' => '',
        'New TicketFreeFields' => 'Novos campos livres do Chamado',
        'Add Note' => 'Adicionar Nota',
        'Time units' => 'Unidades de tempo',
        'CMD' => 'Comando',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Este comando ser executado. ARG[0] ser o nmero do chamado. ARG[1] o id do chamado.',
        'Delete tickets' => 'Excluir Chamados',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Alerta! Este Chamado ser removido da base de dados! Este Chamado esr perdido permanentemente!',
        'Send Notification' => 'Enviar Notificao',
        'Param 1' => 'Parmetro 1',
        'Param 2' => 'Parmetro 2',
        'Param 3' => 'Parmetro 3',
        'Param 4' => 'Parmatro 4',
        'Param 5' => 'Parmetro 5',
        'Param 6' => 'Parmetro 6',
        'Send agent/customer notifications on changes' => '',
        'Save' => 'Salvar',
        '%s Tickets affected! Do you really want to use this job?' => '%s Chamados afetados! Voc quer realmente utilizar este processo?',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '',
        'Group Management' => 'Admin de Grupos',
        'Add Group' => '',
        'Add a new Group.' => '',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'O grupo admin  para uso na rea de administrao e o grupo stats  para uso na rea de estatsticas.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crie novos grupos para manipular as permisses de acesso para diferentes grupos de agentes (exemplos: departamento de compras, departamento de suporte, departamento de vendas, etc...).',
        'It\'s useful for ASP solutions.' => 'Isto  til para solues ASP.',

        # Template: AdminLog
        'System Log' => 'Registro do Sistema',
        'Time' => 'Hora',

        # Template: AdminMailAccount
        'Mail Account Management' => '',
        'Host' => 'Servidor',
        'Trusted' => 'Confivel',
        'Dispatching' => 'Despachando',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Todos os emails de entrada com uma conta ser despachado na fila selecionada!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Se a sua conta for "trusted", os headers "X-OTRS" existentes na recepo (para prioridade, ...) sero utilizados! O filtro ser utilizado mesmo assim.',

        # Template: AdminNavigationBar
        'Users' => 'Usurios',
        'Groups' => 'Grupos',
        'Misc' => 'Variedades',

        # Template: AdminNotificationEventForm
        'Notification Management' => 'Admin de Notificaes',
        'Add Notification' => '',
        'Add a new Notification.' => '',
        'Name is required!' => 'O Nome  requerido',
        'Event is required!' => '',
        'A message should have a body!' => 'A mensagem deve conter um texto!',
        'Recipient' => '',
        'Group based' => '',
        'Agent based' => '',
        'Email based' => '',
        'Article Type' => '',
        'Only for ArticleCreate Event.' => '',
        'Subject match' => '',
        'Body match' => '',
        'Notifications are sent to an agent or a customer.' => 'Notificaes sero enviadas a um Agent ou a um Cliente.',
        'To get the first 20 character of the subject (of the latest agent article).' => '',
        'To get the first 5 lines of the body (of the latest agent article).' => '',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => '',
        'To get the first 20 character of the subject (of the latest customer article).' => '',
        'To get the first 5 lines of the body (of the latest customer article).' => '',

        # Template: AdminNotificationForm
        'Notification' => 'Notificaes',

        # Template: AdminPackageManager
        'Package Manager' => 'Admin Pacotes',
        'Uninstall' => 'Desinstalar',
        'Version' => 'Verso',
        'Do you really want to uninstall this package?' => 'Voc quer realmente desinstalar este pacote?',
        'Reinstall' => 'Reinstalar',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Voc quer realmente reinstalar este pacote?',
        'Continue' => '',
        'Install' => 'Instalar',
        'Package' => 'Pacotes',
        'Online Repository' => 'Repositrio OnLine',
        'Vendor' => 'Vendedor',
        'Module documentation' => '',
        'Upgrade' => 'Atualizar Verso',
        'Local Repository' => 'Repositrio Local',
        'Status' => '',
        'Overview' => 'Viso Geral',
        'Download' => '',
        'Rebuild' => 'Reconstruir',
        'ChangeLog' => '',
        'Date' => '',
        'Filelist' => '',
        'Download file from package!' => 'Baixar arquivo do pacote!',
        'Required' => 'Requerido',
        'PrimaryKey' => 'Chave Primria',
        'AutoIncrement' => '',
        'SQL' => '',
        'Diff' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Log de Performance',
        'This feature is enabled!' => '',
        'Just use this feature if you want to log each request.' => '',
        'Activating this feature might affect your system performance!' => '',
        'Disable it here!' => '',
        'This feature is disabled!' => '',
        'Enable it here!' => '',
        'Logfile too large!' => 'Arquivo de log muito grande!',
        'Logfile too large, you need to reset it!' => 'Arquivo de log muito grande, voc deve reinici-lo!',
        'Range' => 'Intervalo',
        'Interface' => '',
        'Requests' => 'Requisies',
        'Min Response' => 'Tempo mnimo de resposta',
        'Max Response' => 'Tempo mximo de resposta',
        'Average Response' => 'Mdia de tempo de resposta',
        'Period' => '',
        'Min' => '',
        'Max' => '',
        'Average' => '',

        # Template: AdminPGPForm
        'PGP Management' => 'Gerenciamento do PGP',
        'Result' => 'Resultado',
        'Identifier' => 'Identificador',
        'Bit' => '',
        'Key' => 'Chave',
        'Fingerprint' => '',
        'Expires' => 'Expira',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Neste caso, voc pode editar diretamente o "keyring" configurado no "SysConfig".',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Adm Filtros Postmaster',
        'Filtername' => 'Nome Filtro',
        'Stop after match' => '',
        'Match' => 'Busca',
        'Value' => 'Valor',
        'Set' => 'Configurar',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Para despachar ou filtrar os e-mails entrantes baseados em "X-Headers". Expresses regularos tambm podem ser utilizadas.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => '',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Se utilizar expresses regulares, voc pode usar o valor encontrado no () como [***] em \'Set\'.',

        # Template: AdminPriority
        'Priority Management' => '',
        'Add Priority' => '',
        'Add a new Priority.' => '',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'Fila <-> Adm de Auto respostas',
        'settings' => '',

        # Template: AdminQueueForm
        'Queue Management' => 'Admin de Filas',
        'Sub-Queue of' => 'Sub-Fila de',
        'Unlock timeout' => 'Tempo de expirao de desbloqueio',
        '0 = no unlock' => '0 = sem desbloqueio',
        'Only business hours are counted.' => '',
        '0 = no escalation' => '0 = sem escalao',
        'Notify by' => '',
        'Follow up Option' => 'Opo de continuao',
        'Ticket lock after a follow up' => 'Bloqueio do chamado aps as continuaes',
        'Systemaddress' => 'Endereo do Sistema',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Se um Atendente bloquear um chamado e ele no enviar uma resposta dentro deste tempo, o Chamado ser desbloqueado automaticamente. Ento o Chamado ser visvel para todos Atendentes.',
        'Escalation time' => 'Tempo de escalao',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Se um Chamado, no for respondido dentro do prazo, sero apresentados.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Se um chamado est fechado e um cliente envia uma continuao, este mesmo chamado ser bloqueado para o antigo proprietrio.',
        'Will be the sender address of this queue for email answers.' => 'Ser o endereo de email de respostas desta fila.',
        'The salutation for email answers.' => 'A saudao para as respostas de emails.',
        'The signature for email answers.' => 'A assinatura para as respostas de emails.',
        'Customer Move Notify' => 'Cliente Notificar Alterao',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'O OTRS envia uma notificao por e-mail ao cliente, caso o chamado seja movido.',
        'Customer State Notify' => 'Cliente Notificar Estado',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'O OTRS envia uma notificao por e-mail ao cliente, caso o status do chamado seja alterado.',
        'Customer Owner Notify' => 'Cliente Notificar Proprietrio',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'O OTRS envia uma notificao por e-mail ao cliente, caso o dono do chamado seja alterado.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'Respostas <-> Adm Fila',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Resposta',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'Respostas <-> Admin Anexos',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Admin Respostas',
        'A response is default text to write faster answer (with default text) to customers.' => 'Uma resposta padro foi composta, para respostas rpidas (com texto padro) para clientes.',
        'Don\'t forget to add a new response a queue!' => 'No se esquea de adicionar a nova resposta a uma fila!',
        'The current ticket state is' => 'O Estado do Chamado  ',
        'Your email address is new' => 'Seu  mail  novo',

        # Template: AdminRoleForm
        'Role Management' => 'Regras Admin',
        'Add Role' => '',
        'Add a new Role.' => '',
        'Create a role and put groups in it. Then add the role to the users.' => 'Crie uma regra e relacione grupos a ele. Ento adicione regras aos usurios. ',
        'It\'s useful for a lot of users and groups.' => 'Isto  muito til para uma grande quantidade de usurios e grupos.',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'Regras <-> Admin Grupos',
        'move_into' => 'mova_para',
        'Permissions to move tickets into this group/queue.' => 'Permisses para movimento de Chamados neste grupo/fila.',
        'create' => 'criar',
        'Permissions to create tickets in this group/queue.' => 'Permisses para criar Chamados neste grupo/fila. ',
        'owner' => 'proprietrio',
        'Permissions to change the ticket owner in this group/queue.' => 'Permisses para alterar o Chamado neste grupo/fila.  ',
        'priority' => 'prioridade',
        'Permissions to change the ticket priority in this group/queue.' => 'Permisses para alterar o proprietrio neste grupo/fila.',

        # Template: AdminRoleGroupForm
        'Role' => 'Papel',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => 'Papel <-> Gerenciamento de Usurios',
        'Select the role:user relations.' => 'Selecione a relao entre o papel/usurio.',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Gerenciamento de Tratamento (Sr./Sra.)',
        'Add Salutation' => '',
        'Add a new Salutation.' => '',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => '',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => '',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBoxForm
        'SQL Box' => '',
        'Go' => '',
        'Select Box Result' => 'Selecione a Caixa de Resultado',

        # Template: AdminService
        'Service Management' => '',
        'Add Service' => '',
        'Add a new Service.' => '',
        'Sub-Service of' => '',

        # Template: AdminSession
        'Session Management' => 'Gerenciamento de Sesses',
        'Sessions' => 'Sesses',
        'Uniq' => 'nico',
        'Kill all sessions' => '',
        'Session' => 'Sesso',
        'Content' => 'Contedo',
        'kill session' => 'Finalizar sesso',

        # Template: AdminSignatureForm
        'Signature Management' => 'Gerenciamento de Assinaturas',
        'Add Signature' => '',
        'Add a new Signature.' => '',

        # Template: AdminSLA
        'SLA Management' => '',
        'Add SLA' => '',
        'Add a new SLA.' => '',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'Gerenciamento S/MIME',
        'Add Certificate' => 'Adicionar Certificado',
        'Add Private Key' => 'Adicionar Chave Privada',
        'Secret' => 'Senha',
        'Hash' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'Neste caso, voc pode editar diretamente a certificao e chaves privadas no sistema de arquivos.',

        # Template: AdminStateForm
        'State Management' => '',
        'Add State' => '',
        'Add a new State.' => '',
        'State Type' => 'Tipo de Estado',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Tenha cuidado se voc tambm atualizou os estados padro no Kernel/Config.pm!',
        'See also' => 'Veja tambm',

        # Template: AdminSysConfig
        'SysConfig' => 'Configurao do Sistema',
        'Group selection' => 'Seleo de Grupo',
        'Show' => 'Visualizar',
        'Download Settings' => 'Baixar Configuraes',
        'Download all system config changes.' => 'Baixar todas as configuraes do sistema que foram alteradas.',
        'Load Settings' => 'Carregar Configuraes',
        'Subgroup' => 'Subgrupo',
        'Elements' => 'Elementos',

        # Template: AdminSysConfigEdit
        'Config Options' => 'Opes de Configurao',
        'Default' => 'Padro',
        'New' => 'Novo',
        'New Group' => 'Novo Grupo',
        'Group Ro' => 'Grupo Somente Leitura',
        'New Group Ro' => 'Novo Grupo Somente Leitura',
        'NavBarName' => 'Nome da Barra de Navegao',
        'NavBar' => 'Barra de Navegao',
        'Image' => 'Imagem',
        'Prio' => 'Prioridade',
        'Block' => 'Bloquear',
        'AccessKey' => 'Chave de Acesso',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Gerenciamento dos Endereos de E-mail do Sistema',
        'Add System Address' => '',
        'Add a new System Address.' => '',
        'Realname' => 'Nome',
        'All email addresses get excluded on replaying on composing an email.' => '',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Todos os emails entrantes com este Email(To:) sero despachados na fila selecionada!',

        # Template: AdminTypeForm
        'Type Management' => '',
        'Add Type' => '',
        'Add a new Type.' => '',

        # Template: AdminUserForm
        'User Management' => 'Gerenciamento de Usurios',
        'Add User' => '',
        'Add a new Agent.' => '',
        'Login as' => 'Logar-se como',
        'Firstname' => 'Nome',
        'Lastname' => 'Sobrenome',
        'Start' => 'Incio',
        'End' => '',
        'User will be needed to handle tickets.' => 'Ser necessrio um usurio para manipular os chamados.',
        'Don\'t forget to add a new user to groups and/or roles!' => 'No se esquea de adicionar o novo usurio em grupos e/ou papis!',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Usurios <-> Gerenciamento de Grupos',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Catlogo de Endereos',
        'Return to the compose screen' => 'Retornar para a tela de composio',
        'Discard all changes and return to the compose screen' => 'Descartar todas as modificaes e retornar para a tela de composio',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => '',

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '',
        'Please update now.' => '',
        'Release Note' => '',
        'Level' => '',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => '',

        # Template: AgentDashboardTicketOverview

        # Template: AgentDashboardTicketStats

        # Template: AgentInfo
        'Info' => 'Informao',

        # Template: AgentLinkObject
        'Link Object: %s' => '',
        'Object' => 'Objeto',
        'Link Object' => '"Linkar" Objeto',
        'with' => '',
        'Select' => 'Selecionar',
        'Unlink Object: %s' => '',

        # Template: AgentLookup
        'Lookup' => 'Buscar',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Checar a Ortografia',
        'spelling error(s)' => 'erro(s) ortogrficos',
        'or' => 'ou',
        'Apply these changes' => 'Aplicar estas modificaes',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Voc quer realmente remover este objeto?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => 'Selecione as restries para caracterizar o status',
        'Fixed' => 'Fixado',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Por favor, selecione apenas um elemento ou desmarque o boto \'Fixado\'.',
        'Absolut Period' => 'Perodo Absoluto',
        'Between' => 'Entre',
        'Relative Period' => 'Perodo Relativo',
        'The last' => 'O ltimo',
        'Finish' => 'Finalizar',
        'Here you can make restrictions to your stat.' => 'Aqui voc pode criar as restries do seu status',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Se voc remover a seleo da caixa \'Fixado\', o atendente que gerar o status pode alterar os atributos do elemento correspondente.',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => 'Insero das especificaes comuns',
        'Permissions' => 'Permisses',
        'Format' => 'Formato',
        'Graphsize' => 'Tamanho do Grfico',
        'Sum rows' => 'Somar linhas',
        'Sum columns' => 'Somar colunas',
        'Cache' => '',
        'Required Field' => 'Campo Requerido',
        'Selection needed' => ' necessrio a seleo',
        'Explanation' => 'Explanao',
        'In this form you can select the basic specifications.' => 'Neste formulrio voc pode selecionar as especificaes bsicas.',
        'Attribute' => 'Atributo',
        'Title of the stat.' => 'Ttulo da estatstica.',
        'Here you can insert a description of the stat.' => 'Aqui voc pode inserir uma descrio da estatstica.',
        'Dynamic-Object' => 'Objeto-Dinmico',
        'Here you can select the dynamic object you want to use.' => 'Aqui voc pode selecionar o objeto dinmico que voc quer usar.',
        '(Note: It depends on your installation how many dynamic objects you can use)' => 'A quantidade de objetos dinmicos depende da sua instalao',
        'Static-File' => 'Arquivo-Esttico',
        'For very complex stats it is possible to include a hardcoded file.' => 'Para estatsticas muito complexas  possvel incluir um cdigo fonte.',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Se um novo cdigo estiver disponvel ele pode ser exibido e voc poder escolh-lo. ',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Configuraes de permisso. Voc pode selecionar um ou mais grupos para que as estatsticas configuradas sejam exibidas para agentes diferentes.',
        'Multiple selection of the output format.' => 'Mltiplas escolhas de formato de sada.',
        'If you use a graph as output format you have to select at least one graph size.' => 'Se voc utiliza um grfico como formato de sada, voc deve selecionar ao menos um tamanho de grfico.',
        'If you need the sum of every row select yes' => 'Se voc necessita da soma de todos as linhas selecione SIM',
        'If you need the sum of every column select yes.' => 'Se voc necessita da soma de todas as colunas seleciona SIM',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'A maioria das estatsticas podem ser mantidas em cache. Isto tornar sua visualizao mais rpida.',
        '(Note: Useful for big databases and low performance server)' => '(Nota: til para base de dados grandes e servidores de baixa performance)',
        'With an invalid stat it isn\'t feasible to generate a stat.' => '',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => '',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => 'Selecione os elementos para cada conjunto de valores',
        'Scale' => 'Escala',
        'minimal' => 'mnimo',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Lembre que a escala para o conjunto de valores deve ser mair que o eixo X (ex.: Eixo X => Ms, Conjunto de Valores => Ano).',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => ' possvel escolher um ou dois elementos. Ento voc pode selecionar os atributos dos elementos. Cada atributo ser mostrado como um conjunto nico de valores. Se voc no selecionar nenhum atributo todos os atributos do elemento sero utilizados para gerar a estatstica. Assim como um novo atributo  adicionado desde a ltima configurao.',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => 'Selecione o elemento que ser usado no eixo X',
        'maximal period' => 'perodo mximo',
        'minimal scale' => 'perodo mnimo',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsImport
        'Import' => 'Importar',
        'File is not a Stats config' => 'Este no  um arquivo de configurao',
        'No File selected' => 'Nenhum arquivo selecionado',

        # Template: AgentStatsOverview
        'Results' => 'Resultados',
        'Total hits' => 'Total de acertos',
        'Page' => 'Pgina',

        # Template: AgentStatsPrint
        'Print' => 'Imprimir',
        'No Element selected.' => 'Nenhum elemento selecionado.',

        # Template: AgentStatsView
        'Export Config' => 'Exportar Configurao',
        'Information about the Stat' => 'Informaes sobre a Estatstica',
        'Exchange Axis' => 'Trocar Eixo',
        'Configurable params of static stat' => 'Parmetros configurveis da estatstica esttica',
        'No element selected.' => 'Nenhum elemento selecionado.',
        'maximal period from' => '',
        'to' => 'para',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => '',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => 'Uma mensagem deve possuir um To: destinatrio!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Voc precisa de um endereo de email (exemplo: cliente@exemplo.com.br) no To:!',
        'Bounce ticket' => 'Devolver chamado',
        'Ticket locked!' => 'Chamado bloqueado!',
        'Ticket unlock!' => 'Chamado desbloqueado!',
        'Bounce to' => 'Devolver para',
        'Next ticket state' => 'Prximo estado do chamado',
        'Inform sender' => 'Informe o remetente',
        'Send mail!' => 'Enviar email!',

        # Template: AgentTicketBulk
        'You need to account time!' => 'Voc deve contabilizar o tempo!',
        'Ticket Bulk Action' => 'Executar Ao no Chamado',
        'Spell Check' => 'Checar Ortografia',
        'Note type' => 'Tipo de nota',
        'Next state' => 'Novo Estado',
        'Pending date' => 'Data da pendncia',
        'Merge to' => 'Unir com',
        'Merge to oldest' => '',
        'Link together' => '',
        'Link to Parent' => '',
        'Unlock Tickets' => 'Desbloquear Chamados',

        # Template: AgentTicketClose
        'Ticket Type is required!' => '',
        'A required field is:' => '',
        'Close ticket' => 'Fechar o chamado',
        'Previous Owner' => 'Dono Anterior',
        'Inform Agent' => 'Informar Atendente',
        'Optional' => 'Opcional',
        'Inform involved Agents' => 'Informar os Atendentes Envolvidos',
        'Attach' => 'Anexo',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => 'A mensagem necessita ser verificada ortograficamente!',
        'Compose answer for ticket' => 'Compr uma resposta para o chamado',
        'Pending Date' => 'Data de Pendncia',
        'for pending* states' => 'em estado pendente*',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Modificar o cliente do chamado',
        'Set customer user and customer id of a ticket' => 'Configurar usurio e id do cliente no chamado',
        'Customer User' => 'Cliente',
        'Search Customer' => 'Busca do cliente',
        'Customer Data' => 'Dados do Cliente',
        'Customer history' => 'Histrico do cliente',
        'All customer tickets.' => 'Todos os chamados do cliente',

        # Template: AgentTicketEmail
        'Compose Email' => 'Compor Email',
        'new ticket' => 'Novo Chamado',
        'Refresh' => 'Atualizar',
        'Clear To' => 'Limpar',
        'All Agents' => 'Todos os Atendentes',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => 'Tipo de artigo',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'Alterar os campos em branco no chamado',

        # Template: AgentTicketHistory
        'History of' => 'Histrico de',

        # Template: AgentTicketLocked

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => 'Voc deve utilizar um nmero de chamado!',
        'Ticket Merge' => 'Unir Chamado',

        # Template: AgentTicketMove
        'Move Ticket' => 'Mover Chamado',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Adicionar nota ao chamado',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => '',
        'Service Time' => '',
        'Update Time' => '',
        'Solution Time' => '',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => 'Voc deve selecionar ao menos  1(um) chamado!',

        # Template: AgentTicketOverviewNavBar
        'Filter' => 'Filtro',
        'Change search options' => 'Alterar as oes de busca',
        'Tickets' => 'Chamado',
        'of' => 'de',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => 'Compr resposta',
        'Contact customer' => 'Contatar cliente',
        'Change queue' => 'Modificar Fila',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => 'ordem crescente',
        'up' => 'normal',
        'sort downward' => 'ordem decrescente',
        'down' => 'inversa',
        'Escalation in' => 'Escalado em',
        'Locked' => 'Bloqueado',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Modificar o proprietrio do chamado',

        # Template: AgentTicketPending
        'Set Pending' => 'Marcar Pendente',

        # Template: AgentTicketPhone
        'Phone call' => 'Chamada telefnica',
        'Clear From' => 'Limpar',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Texto',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Informao do Chamado',
        'Accounted time' => 'Tempo contabilizado',
        'Linked-Object' => 'Objeto "Linkado"',
        'by' => 'por',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'Modificar a prioridade do chamado',

        # Template: AgentTicketQueue
        'Tickets shown' => 'Chamados mostrados',
        'Tickets available' => 'Chamados disponveis',
        'All tickets' => 'Todos chamados',
        'Queues' => 'Filas',
        'Ticket escalation!' => 'Escalao de chamados!',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => '',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Busca de Chamado',
        'Profile' => 'Perfil',
        'Search-Template' => 'Modelo de Busca',
        'TicketFreeText' => 'Texto livre Chamado',
        'Created in Queue' => 'Criado na Fila',
        'Article Create Times' => '',
        'Article created' => '',
        'Article created between' => '',
        'Change Times' => '',
        'No change time settings.' => '',
        'Ticket changed' => '',
        'Ticket changed between' => '',
        'Result Form' => 'Resultado',
        'Save Search-Profile as Template?' => 'Salvar o Perfil de Busca como Modelo?',
        'Yes, save it with name' => 'Sim, salve-o com o nome',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext
        'Fulltext' => 'Texto Completo',

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => '',
        'Collapse View' => '',
        'Split' => 'Dividir',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => '',
        'Save filter settings as default' => '',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => '',

        # Template: CustomerFooter
        'Powered by' => '',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => '',
        'Lost your password?' => 'Esqueceu sua senha?',
        'Request new password' => 'Solicitar uma nova senha',
        'Create Account' => 'Criar Conta',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Bem-vindo %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Hora',
        'No time settings.' => 'Sem configuraes de hora.',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Clique aqui para relatar um erro!',

        # Template: Footer
        'Top of Page' => 'Topo da Pgina',

        # Template: FooterSmall

        # Template: Header
        'Home' => 'Incio',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Instalador Web',
        'Welcome to %s' => '',
        'Accept license' => '',
        'Don\'t accept license' => '',
        'Admin-User' => 'Usurio do Administrador',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => '',
        'Admin-Password' => 'Senha do Administrador',
        'Database-User' => 'Usurio da Base',
        'default \'hot\'' => 'padro \'hot\'',
        'DB connect host' => 'Servidor da Base',
        'Database' => 'Base de Dados',
        'Default Charset' => 'Conjunto de Caracteres Padro',
        'utf8' => '',
        'false' => 'falso',
        'SystemID' => 'ID do sistema',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(A identidade do sistema. Cada nmero de chamado e cada id. da sesso http, inicia com este nmero)',
        'System FQDN' => 'FQDN do sistema',
        '(Full qualified domain name of your system)' => '(Nome completo do domnio de seu sistema)',
        'AdminEmail' => 'Email do Administrador',
        '(Email of the system admin)' => '(Email do administrador do sistema)',
        'Organization' => 'Organizao',
        'Log' => '',
        'LogModule' => 'LOG Modulo',
        '(Used log backend)' => '(Utilizado LOG como base)',
        'Logfile' => 'Arquivo de registro',
        '(Logfile just needed for File-LogModule!)' => '(Arquivo de registro para File-LogModule)',
        'Webfrontend' => 'Interface Web',
        'Use utf-8 it your database supports it!' => 'A sua Base de dados suporta utf-8!',
        'Default Language' => 'Idioma Padro',
        '(Used default language)' => '(Idioma padro utilizado)',
        'CheckMXRecord' => 'Averiguar MX',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => 'Checar os registros do MX de endereos de e-mail utilizados na composio de uma resposta. No utilizar checagem de registros do MX se o seu servidor OTRS estiver sib um acesso discado $!',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Para poder utilizar o OTRS voc deve',
        'Restart your webserver' => 'Reiniciar o Webserver',
        'After doing so your OTRS is up and running.' => 'Aps isto, ento seu OTRS est funcionando.',
        'Start page' => 'Iniciar pgina',
        'Your OTRS Team' => 'Equipe Service Desk SAP',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Sem Permisso',

        # Template: Notify
        'Important' => 'Importante',

        # Template: PrintFooter
        'URL' => '',

        # Template: PrintHeader
        'printed by' => 'impresso por',

        # Template: PublicDefault

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'Pgina de Teste Service Desk SAP',
        'Counter' => 'Contador',

        # Template: Warning

        # Template: YUI

        # Misc
        'Edit Article' => '',
        'Change roles <-> groups settings' => 'Alterar configuraes Regras <-> Grupos',
        'Ticket Number Generator' => 'Gerador de Nmeros de Chamados',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identificador Chamado. Algumas pessoas gostam de usar por exemplo \'Chamado#\, \'Chamado#\' ou \'MeuChamado#\')',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Neste caso, voc pode editar diretamente a "keyring" configurada no Kernel/Config.pm.',
        'Create new Phone Ticket' => 'Criar novo Fone Chamado',
        'Symptom' => 'Sintoma',
        'U' => 'C',
        'Options of the current user who requested this action (e. g. OTRS_CURRENT_USERFIRSTNAME)' => 'Opes do usurio atual que requisitou esta ao (ex.: OTRS_CURRENT_USERFIRSTNAME)',
        'Customer history search (e. g. "ID342425").' => 'Busca no Histrico do cliente (exemplo: "ID342425")',
        'Can not delete link with %s!' => '',
        'Close!' => 'Fechar!',
        'for agent firstname' => 'Nome do Atendente',
        'No means, send agent and customer notifications on changes.' => 'No siginifica \'envie notificaes ao atendente e ao cliente nas alteraes\'.',
        'A web calendar' => 'Calendrio',
        'to get the realname of the sender (if given)' => 'para obter o nome do remetente (se possuir no email)',
        'Notification (Customer)' => '',
        'Select Source (for add)' => 'Selecione Origem (para adio)',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',
        'Child-Object' => 'Objeto Filho',
        'Config options (e. g. OTRS_CONFIG_HttpType)' => 'Opes de configurao (ex.: OTRS_CONFIG_HttpType)',
        'Queue ID' => 'ID da Fila',
        'Locked tickets' => 'Chamados Bloqueados',
        'System History' => 'Histrico do Sistema',
        'customer realname' => 'Nome do cliente',
        'Pending messages' => 'Mensagens pendentes',
        'Modules' => 'Modulos',
        'for agent login' => 'Login do Atendente',
        'Keyword' => 'Palavra-Chave',
        'Close type' => 'Tipo de fechamento',
        'for agent user id' => 'Id do Atendente',
        'Change user <-> group settings' => 'Modificar configuraes de usurios <-> grupos',
        'Problem' => 'Problema',
        'Escalation' => '',
        '"}' => '',
        'Order' => 'Ordem',
        'next step' => 'prximo passo',
        'Follow up' => 'Continuao',
        'Customer history search' => 'Busca no Histrico do cliente',
        'Options of the ticket data (e. g. OTRS_TICKET_TicketNumber, OTRS_TICKET_TicketID, OTRS_TICKET_Queue, OTRS_TICKET_State)' => 'Opes de dados do Chamado (e. g. OTRS_TICKET_TicketNumber, OTRS_TICKET_TicketID, OTRS_TICKET_Queue, OTRS_TICKET_State)',
        'Admin-Email' => 'Email Admin.',
        'Stat#' => '',
        'Options of the ticket data (e. g. OTRS_TICKET_Number, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State)' => 'Opes de dados do chamado (ex.: OTRS_TICKET_Number, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State;)',
        'Options of the current customer user data (e. g. OTRS_CUSTOMER_DATA_USERFIRSTNAME)' => 'Opes de dados do usurio do cliente atual (ex.: OTRS_CUSTOMER_DATA_USERFIRSTNAME)',
        'ArticleID' => 'Id.do artigo',
        'Keywords' => 'Palavras-Chave',
        'Ticket Escalation View' => '',
        'Today' => '',
        'No * possible!' => 'No so possveis *!',
        'Options ' => 'Opes',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => '',
        'Message for new Owner' => 'Mensagem para um novo Proprietrio',
        'to get the first 5 lines of the email' => 'para obter as 5 primeiras linhas do email',
        'Sort by' => 'Ordenado pela',
        'Last update' => 'ltima Atualizao',
        'Tomorrow' => '',
        'to get the first 20 character of the subject' => 'para obter os 20 primeiros caracteres do assunto',
        'Select the customeruser:service relations.' => '',
        'Advisory' => 'Aviso',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Aqui voc pode definir o eixo X. Voc pode selecionar um elemento atravs do \'radio button\'. Ento voc deve selecionar dois ou mais atributos do elemento. Se no efetuou nenhum seleo, todos os atributos do elemento sero utilizados se voc gerar uma estatstica. Assim como um novo atributo  adicionado desde a ltima configurao. ',
        'FileManager' => 'Adm Arquivo',
        'Pending type' => 'Tipo de pendncia',
        'Comment (internal)' => 'Comentrio (interno)',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opes de dono do chamado (ex.: &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        '(Used ticket number format)' => '(Formato de Chamado utilizado)',
        'Reminder' => 'Lembretes',
        'Incident' => 'Incidente',
        'All Agent variables.' => 'Todas as variveis do Atendente',
        ' (work units)' => ' (unidades de trabalho)',
        'Next Week' => '',
        'All Customer variables like defined in config option CustomerUser.' => 'Todas as variveis do cliente como foram definidas nas opes de configurao de "usurio"',
        'accept license' => 'aceitar licena',
        'for agent lastname' => 'Sobrenome do Atendente',
        'Reminder messages' => 'Mensagens com lembretes',
        'Parent-Object' => 'Objeto Pai',
        'Of couse this feature will take some system performance it self!' => '',
        'Detail' => 'Detalhe',
        'Your own Ticket' => 'Seu prprio Chamado',
        'Don\'t forget to add a new user to groups!' => 'No esquea de adicionar um novo usurio nos grupos!',
        'Open Tickets' => 'Chamados Abertos',
        'You have to select two or more attributes from the select field!' => 'Voc deve selecionar dois ou mais atributos no campo \'selecionar\'!',
        'System Settings' => 'Configuraes Sistema',
        'WebWatcher' => 'Visitante',
        'Finished' => 'Finalizado',
        'D' => '',
        'All messages' => 'Todas as mensagens',
        'Artefact' => 'Artefato',
        'Object already linked as %s.' => '',
        'A article should have a title!' => 'O Artigo dever ter um Ttulo!',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
        'All email addresses get excluded on replaying on composing and email.' => '',
        'don\'t accept license' => 'no acentiar a licena',
        'A web mail client' => 'Webmail Cliente',
        'Compose Follow up' => 'Compor Continuao',
        'WebMail' => '',
        'kill all sessions' => 'Finalizar todas as sesses',
        'to get the from line of the email' => 'para obter a linha "From" do email',
        'Solution' => 'Soluo',
        'QueueView' => 'Fila',
        'Options of the ticket data (e. g. OTRS_TICKET_TicketNumber, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State)' => 'Opes de dados do chamado (ex.: OTRS_TICKET_TicketNumber, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State)',
        'Select Box' => 'Caixa de Seleo',
        'New messages' => 'Mensagens novas',
        'Can not create link with %s!' => '',
        'Linked as' => '',
        'Welcome to OTRS' => 'Bem-vindo ao OTRS',
        'modified' => 'modificado',
        'A web file manager' => 'Adm Arquivo Web',
        'Have a lot of fun!' => 'Divirta-se!',
        'send' => 'enviar',
        'Send no notifications' => 'No enviar notificaes',
        'Note Text' => 'Nota',
        'POP3 Account Management' => 'Gerenciamento de Contas POP3',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',
        'System State Management' => 'Gerenciamento de Estados do Sistema',
        'Mailbox' => 'Caixa de Entrada',
        'PhoneView' => 'Chamada',
        'maximal period form' => 'formulrio de perodo mximo',
        'TicketID' => 'Id.do Chamado',
        'Escaladed Tickets' => '',
        'Yes means, send no agent and customer notifications on changes.' => 'Sim significa \'no envie notificaes ao atendente e ao cliente nas alteraes\'.',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Seu email com o nmero de chamado "<OTRS_TICKET>" foi devolvido para "<OTRS_BOUNCE_TO>". Contate este endereo para mais informaes.',
        'Ticket Status View' => 'Visualizao do Status do Chamado',
        'Modified' => 'Modificado',
        'Ticket selected for bulk action!' => 'Chamado selecionado para execuo de ao!',
    };
    # $$STOP$$
    return;
}

1;
