# --
# Kernel/Language/da.pm - provides da (Danish) language translation
# Copyright (C) 2006 Thorsten Rossner <thorsten.rossner[at]stepstone.de>
# Copyright (C) 2007-2010 Mads N. Vestergaard <mnv[at]timmy.dk>
# Copyright (C) 2010 Jesper Ulrik Rnnov <jeron[at]faaborgmidtfyn.dk>
# --
# $Id: da.pm,v 1.76 2010/11/12 14:51:47 mb Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --
package Kernel::Language::da;

use strict;
use warnings;

use vars qw($VERSION);

$VERSION = qw($Revision: 1.76 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2010-11-12 14:48:34

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%A %D %B %T %Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    # csv separator
    $Self->{Separator} = '';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Ja',
        'No' => 'Nej',
        'yes' => 'ja',
        'no' => 'nej',
        'Off' => 'Fra',
        'off' => 'fra',
        'On' => 'Til',
        'on' => 'til',
        'top' => 'start',
        'end' => 'slut',
        'Done' => 'Frdig',
        'Cancel' => 'Annuller',
        'Reset' => 'Nulstil',
        'last' => 'sidste',
        'before' => 'fr',
        'day' => 'dag',
        'days' => 'dage',
        'day(s)' => 'dag(e)',
        'hour' => 'time',
        'hours' => 'timer',
        'hour(s)' => 'time(r)',
        'Hours' => '',
        'minute' => 'minut',
        'minutes' => 'minutter',
        'minute(s)' => 'minut(ter)',
        'Minutes' => '',
        'month' => 'mned',
        'months' => 'mneder',
        'month(s)' => 'mned(er)',
        'week' => 'uge',
        'week(s)' => 'uge(r)',
        'year' => 'r',
        'years' => 'r',
        'year(s)' => 'r',
        'second(s)' => 'sekund(er)',
        'seconds' => 'sekunder',
        'second' => 'sekund',
        'wrote' => 'skrev',
        'Message' => 'Meddelelse',
        'Error' => 'Fejl',
        'Bug Report' => 'Fejlrapport',
        'Attention' => 'OBS',
        'Warning' => 'Advarsel',
        'Module' => 'Modul',
        'Modulefile' => 'Modulfil',
        'Subfunction' => 'Underfunktion',
        'Line' => 'Linje',
        'Setting' => 'Indstilling',
        'Settings' => 'Indstillinger',
        'Example' => 'Eksempel',
        'Examples' => 'Eksempler',
        'valid' => 'gyldig',
        'invalid' => 'ugyldig',
        '* invalid' => '* ugyldig',
        'invalid-temporarily' => 'ugyldig-midlertidigt',
        ' 2 minutes' => '2 minutter',
        ' 5 minutes' => '5 minutter',
        ' 7 minutes' => '7 minutter',
        '10 minutes' => '10 minutter',
        '15 minutes' => '15 minutter',
        'Mr.' => 'Hr.',
        'Mrs.' => 'Fru',
        'Next' => 'Nste',
        'Back' => 'Tilbage',
        'Next...' => 'Nste...',
        '...Back' => '...Tilbage',
        '-none-' => '-ingen-',
        'none' => 'ingen',
        'none!' => 'ingen!',
        'none - answered' => 'ingen - svarede',
        'please do not edit!' => 'vr venlig ikke at redigere!',
        'Need Action' => 'Handling er ndvendig',
        'AddLink' => 'TilfjLink',
        'Link' => 'Link',
        'Unlink' => 'Fjern link',
        'Linked' => 'Linket',
        'Link (Normal)' => 'Link (normal)',
        'Link (Parent)' => 'Link (forldre)',
        'Link (Child)' => 'Link (barn)',
        'Normal' => 'Normal',
        'Parent' => 'Forldre',
        'Child' => 'Barn',
        'Hit' => 'Resultat',
        'Hits' => 'Antal resultater',
        'Text' => 'Tekst',
        'Standard' => '',
        'Lite' => 'Let',
        'User' => 'Bruger',
        'Username' => 'Brugernavn',
        'Language' => 'Sprog',
        'Languages' => 'Sprog',
        'Password' => 'Adgangskode',
        'Preferences' => 'Indstillinger',
        'Salutation' => 'Hilsen',
        'Salutations' => 'Hilsner',
        'Signature' => 'Underskrift',
        'Signatures' => 'Underskrifter',
        'Customer' => 'Kunde',
        'CustomerID' => 'Kunde-ID',
        'CustomerIDs' => 'Kunde-ID\'er',
        'customer' => 'kunde',
        'agent' => 'konsulent',
        'system' => 'system',
        'Customer Info' => 'Kundeinfo',
        'Customer Information' => 'Kunde Information',
        'Customer Company' => 'Kunde Firma',
        'Customer Companies' => '',
        'Company' => 'Firma',
        'go!' => 'g!',
        'go' => 'g',
        'All' => 'Alle',
        'all' => 'alle',
        'Sorry' => 'Beklager',
        'update!' => 'opdater!',
        'update' => 'opdater',
        'Update' => 'Opdater',
        'Updated!' => 'Opdateret!',
        'submit!' => 'indsend!',
        'submit' => 'indsend',
        'Submit' => 'Indsend',
        'change!' => 'skift!',
        'Change' => 'Skift',
        'change' => 'skift',
        'click here' => 'klik her',
        'Comment' => 'Kommentar',
        'Valid' => 'Gyldig',
        'Invalid Option!' => 'Ugyldig valgmulighed!',
        'Invalid time!' => 'Ugyldigt tidsrum!',
        'Invalid date!' => 'Ugyldig dato!',
        'Name' => 'Navn',
        'Group' => 'Gruppe',
        'Description' => 'Beskrivelse',
        'description' => 'beskrivelse',
        'Theme' => 'Tema',
        'Created' => 'Oprettet',
        'Created by' => 'Oprettet af',
        'Changed' => 'Udskiftet',
        'Changed by' => 'Udskiftet af',
        'Search' => 'Sg',
        'and' => 'og',
        'between' => 'mellem',
        'Fulltext Search' => 'Fritekstsgning',
        'Data' => 'Data',
        'Options' => 'Valgmuligheder',
        'Title' => 'Titel',
        'Item' => 'Punkt',
        'Delete' => 'Slet',
        'Edit' => 'Rediger',
        'View' => 'Vis',
        'Number' => 'Nummer',
        'System' => 'System',
        'Contact' => 'Kontaktperson',
        'Contacts' => 'Kontaktpersoner',
        'Export' => 'Eksporter',
        'Up' => 'Op',
        'Down' => 'Ned',
        'Add' => 'Tilfj',
        'Added!' => 'Tilfjet!',
        'Category' => 'Kategori',
        'Viewer' => 'Fremviser',
        'Expand' => 'Udvid',
        'Small' => 'Lille',
        'Medium' => 'Mellem',
        'Large' => 'Stor',
        'Date picker' => 'Dato vlger',
        'New message' => 'Ny meddelelse',
        'New message!' => 'Ny meddelelse!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Vr venlig at besvare n eller flere sager for at komme tilbage til kens normale visning!',
        'You have %s new message(s)!' => 'Du har %s ny(e) meddelelse(r)!',
        'You have %s reminder ticket(s)!' => 'Du har %s pmindelses sag(er)!',
        'The recommended charset for your language is %s!' => 'Det anbefalede tegnst til dit sprog er %s!',
        'Change your password.' => 'Skift dit kodeord.',
        'Please activate %s first!' => 'Aktiver venligst %s frst!',
        'No suggestions' => 'Ingen forslag',
        'Word' => 'Ord',
        'Ignore' => 'Ignorer',
        'replace with' => 'udskift med',
        'There is no account with that login name.' => 'Der er ingen konto med det login-navn.',
        'Login failed! Your user name or password was entered incorrectly.' => '',
        'There is no acount with that user name.' => '',
        'Please contact your administrator' => '',
        'Logout' => 'Log ud',
        'Logout successful. Thank you for using OTRS!' => 'Du er nu logget ud. Tak fordi du bruger OTRS.',
        'Invalid SessionID!' => 'Ugyldigt sessions-ID!',
        'Feature not active!' => 'Funktionen er ikke aktiv!',
        'Agent updated!' => '',
        'Create Database' => 'Opret database',
        'System Settings' => 'Systemindstillinger',
        'Mail Configuration' => '',
        'Finished' => 'Frdig',
        'Login is needed!' => 'Login er pkrvet',
        'Password is needed!' => 'Adgangskode er pkrvet!',
        'License' => 'Licens',
        'Take this Customer' => 'Tag denne kunde',
        'Take this User' => 'Tag denne bruger',
        'possible' => 'mulig',
        'reject' => 'afvis',
        'reverse' => 'omvendt',
        'Facility' => 'Facilitet',
        'Time Zone' => '',
        'Pending till' => 'Afventer til',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Arbejd ikke med bruger-ID 1 (systemkonto)! Opret nye brugere!',
        'Dispatching by email To: field.' => 'Sendes via e-mail til: felt.',
        'Dispatching by selected Queue.' => 'Sendes via den valgte k.',
        'No entry found!' => 'Ingen post fundet!',
        'Session has timed out. Please log in again.' => 'Sessionens tidsfrist er udlbet. Vr venlig at logge ind igen.',
        'No Permission!' => 'Ingen tilladelse!',
        'To: (%s) replaced with database email!' => 'Til: (%s) udskiftet med e-mail til database!',
        'Cc: (%s) added database email!' => 'Cc: (%s) tilfjet e-mail til database!',
        '(Click here to add)' => '(Klik her for at tilfje)',
        'Preview' => 'Vis udskrift',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Pakke ikke korrekt indsat. Du br installere pakken igen.',
        '%s is not writable!' => '%s er ikke skrivbar!',
        'Cannot create %s!' => 'Can ikke oprette %s!',
        'Customer %s added' => '',
        'Role added!' => 'Rolel tilfjet!',
        'Role updated!' => '',
        'Attachment added!' => '',
        'Attachment updated!' => '',
        'Response added!' => '',
        'Response updated!' => '',
        'Group updated!' => '',
        'Queue added!' => '',
        'Queue updated!' => '',
        'State added!' => '',
        'State updated!' => '',
        'Type added!' => '',
        'Type updated!' => '',
        'Customer updated!' => '',
        'Contract' => 'Kontrakt',
        'Online Customer: %s' => 'Online kunde: %s ',
        'Online Agent: %s' => 'Online konsulenter: %s ',
        'Calendar' => 'Kalender',
        'File' => 'Fil',
        'Filename' => 'Filnavn',
        'Type' => 'Type',
        'Size' => 'Strrelse',
        'Upload' => 'Upload',
        'Directory' => 'Katalog',
        'Signed' => 'Underskrevet',
        'Sign' => 'Underskriv',
        'Crypted' => 'Krypteret',
        'Crypt' => 'Krypter',
        'PGP' => '',
        'PGP Key' => '',
        'PGP Keys' => '',
        'S/MIME' => '',
        'S/MIME Certificate' => '',
        'S/MIME Certificates' => '',
        'Office' => 'Kontor',
        'Phone' => 'Telefon',
        'Fax' => 'Fax',
        'Mobile' => 'Mobil',
        'Zip' => 'Post Nr.',
        'City' => 'By',
        'Street' => 'Gade',
        'Country' => 'Land',
        'Location' => 'Lokation',
        'installed' => 'installeret',
        'uninstalled' => 'afinstalleret',
        'Security Note: You should activate %s because application is already running!' => 'Sikkerheds advarsel: Du skal aktivere %s fordi applikationen allerede krer!',
        'Unable to parse repository index document.' => '',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => '',
        'No packages, or no new packages, found in selected repository.' => '',
        'Edit the system configuration settings.' => '',
        'printed at' => 'printet den',
        'Loading...' => 'Henter...',
        'Dear Mr. %s,' => 'Kre Hr. %s',
        'Dear Mrs. %s,' => 'Kre Fru. %s',
        'Dear %s,' => 'Kre %s',
        'Hello %s,' => 'Hej %s',
        'This email address already exists. Please log in or reset your password.' => '',
        'New account created. Sent login information to %s. Please check your email.' => '',
        'Please press Back and try again.' => 'Tryk venligst tilbage og prv igen.',
        'Sent password reset instructions to %s. Please check your email.' => '',
        'Sent new password to %s. Please check your email.' => '',
        'Upcoming Events' => 'Kommende hndelser',
        'Event' => 'Handling',
        'Events' => 'Hndelser',
        'Invalid Token!' => 'Ugyldigt kendetegn!',
        'more' => 'mere',
        'For more info see:' => 'For mere information se:',
        'Package verification failed!' => 'Pakke godkendelse fejlede!',
        'Collapse' => 'Indskrnk',
        'Shown' => 'Viste',
        'News' => 'Nyheder',
        'Product News' => 'Produktnyheder',
        'OTRS News' => 'OTRS Nyheder',
        '7 Day Stats' => '7 dages statistik',
        'Bold' => 'Fed',
        'Italic' => 'Kursiv',
        'Underline' => 'Understregning',
        'Font Color' => 'Font farve',
        'Background Color' => 'Baggrundsfarve',
        'Remove Formatting' => 'Fjern formattering',
        'Show/Hide Hidden Elements' => 'Vis/Skjul Skjulte elementer',
        'Align Left' => 'Venstrestil',
        'Align Center' => 'Centre',
        'Align Right' => 'Hjrestil',
        'Justify' => 'Lige margner',
        'Header' => 'Overskrift',
        'Indent' => 'Forg indrykning',
        'Outdent' => 'Formindsk indrykning',
        'Create an Unordered List' => 'Lav en usorteret liste',
        'Create an Ordered List' => 'Lav en sorteret liste',
        'HTML Link' => '',
        'Insert Image' => 'Indst billed',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => 'Fortryd',
        'Redo' => 'Gendan',

        # Template: AAAMonth
        'Jan' => 'Jan',
        'Feb' => 'Feb',
        'Mar' => 'Mar',
        'Apr' => 'Apr',
        'May' => 'Maj',
        'Jun' => 'Jun',
        'Jul' => 'Jul',
        'Aug' => 'Aug',
        'Sep' => 'Sep',
        'Oct' => 'Okt',
        'Nov' => 'Nov',
        'Dec' => 'Dec',
        'January' => 'Januar',
        'February' => 'Februar',
        'March' => 'Marts',
        'April' => 'April',
        'May_long' => 'Maj',
        'June' => 'Juni',
        'July' => 'Juli',
        'August' => 'August',
        'September' => 'September',
        'October' => 'Oktober',
        'November' => 'November',
        'December' => 'December',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Indstillingerne er opdateret!',
        'User Profile' => 'Profil',
        'Email Settings' => 'Email indstillinger',
        'Other Settings' => 'Andre indstillinger',
        'Change Password' => 'Skift adgangskode',
        'Current Password' => 'Nuvrende kodeord',
        'New password' => 'Ny adgangskode',
        'Verify password' => '',
        'Spelling Dictionary' => 'Ordbog til stavekontrol',
        'Default spelling dictionary' => '',
        'Max. shown Tickets a page in Overview.' => 'Max. viste sager pr. side i oversigten.',
        'The current password is not correct. Please try again!' => 'Det nuvrende kodeord er ikke korrekt. Prv igen!',
        'Can\'t update password, your new passwords do not match. Please try again!' => 'Kan ikke opdatere kodeord, de nye kodeord er ikke ens. Prv igen!',
        'Can\'t update password, it contains invalid characters!' => 'Kan ikke opdatere kodeord, de indeholder ugyldige tegn!',
        'Can\'t update password, it must be at least %s characters long!' => 'Kan ikke opdatere kodeord, det skal vre %s tegn langt!',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => 'Kan ikke opdatere kodeord, det skal indeholde mindst 2 sm og 2 store bogstaver!',
        'Can\'t update password, it must contain at least 1 digit!' => 'Kan ikke opdatere kodeord, det skal indeholde mindst 1 tal.',
        'Can\'t update password, it must contain at least 2 characters!' => 'Kan ikke opdatere kodeord, det skal vre mindst 2 tegn langt!',
        'Can\'t update password, this password has already been used. Please choose a new one!' => 'Kan ikke opdatere kodeord, dette kodeord har tidligere vret benyttet. Vlg venligst et nyt!',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => '',
        'CSV Separator' => '',

        # Template: AAAStats
        'Stat' => 'Statistik',
        'Please fill out the required fields!' => 'Udfyld venligst de pkrvede felter.',
        'Please select a file!' => 'Vlg venligst en fil',
        'Please select an object!' => 'Vlg venligst et objekt',
        'Please select a graph size!' => 'Vlg venligst graf strrelse',
        'Please select one element for the X-axis!' => 'Vlg venligst et element til X-aksen',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Vlg venligst kun et element, eller vend knappen \'Fixed\' hvor feltet er markeret',
        'If you use a checkbox you have to select some attributes of the select field!' => 'For at bruge en checkbox, skal du vlge nogle attributter fra feltet',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Indtast venligst en vrdi, i det valghte input felt, eller fra vlg \'Fixed\' checkboxen.',
        'The selected end time is before the start time!' => 'Den valgte sluttid, er fr starttiden.',
        'You have to select one or more attributes from the select field!' => 'Du skal vlge en eller flere attributter fra det valgte felt.',
        'The selected Date isn\'t valid!' => 'Den valgte dato er ugyldig.',
        'Please select only one or two elements via the checkbox!' => 'Vlg kun ene eller 2 elemeter fra checkboksene.',
        'If you use a time scale element you can only select one element!' => 'Hvis du bruger en tidsskale, kan du kun vlge et element!',
        'You have an error in your time selection!' => 'iDer er fejl i den valgte tid!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'Rapport tids-intervallet er for kort, vlg en strre tids horisont!',
        'The selected start time is before the allowed start time!' => 'Den valgte start tid, er fr den tilladte starttid!',
        'The selected end time is after the allowed end time!' => 'Den valgte slut tid, el senere end den tilladte sluttid!',
        'The selected time period is larger than the allowed time period!' => 'Den valgte tidsperiode, er lngere end den tilladte tidsperiode!',
        'Common Specification' => 'Flles sspecifikationer',
        'Xaxis' => 'X-akse',
        'Value Series' => 'Vrdi serier',
        'Restrictions' => 'Begrnsning',
        'graph-lines' => 'graf-linjer',
        'graph-bars' => 'graf-bar',
        'graph-hbars' => 'graf-hbar',
        'graph-points' => 'graf-punkter',
        'graph-lines-points' => 'graf-linje-punkter',
        'graph-area' => 'praf-omrde',
        'graph-pie' => 'graf-cirkel',
        'extended' => 'udvidet',
        'Agent/Owner' => 'Konsulent/ejer',
        'Created by Agent/Owner' => 'Oprettet af konsulent/ejer',
        'Created Priority' => 'Oprettelses prioritet',
        'Created State' => 'Oprettelses Status',
        'Create Time' => 'Oprettelses tid',
        'CustomerUserLogin' => 'KundeBrugerLogin',
        'Close Time' => 'Slut tid',
        'TicketAccumulation' => 'Sagsakkumulation',
        'Attributes to be printed' => 'Attributter til udskrift',
        'Sort sequence' => 'Sorter sekvens',
        'Order by' => 'Sorter efter',
        'Limit' => 'Grnse',
        'Ticketlist' => 'Sagsliste',
        'ascending' => 'stigende',
        'descending' => 'falende',
        'First Lock' => 'Frste ls',
        'Evaluation by' => 'Evaluering af',
        'Total Time' => 'Samlet tid',
        'Ticket Average' => 'Sagsgennemsnit',
        'Ticket Min Time' => 'Sag - Min.tid',
        'Ticket Max Time' => 'Sag - Max.tid',
        'Number of Tickets' => 'Antal af sager',
        'Article Average' => 'Artikel gennemsnit',
        'Article Min Time' => 'Artikel - Min.tid',
        'Article Max Time' => 'Artikel - Max.tid',
        'Number of Articles' => 'Antal af artikler',
        'Accounted time by Agent' => 'Konteret tid for konsulent',
        'Ticket/Article Accounted Time' => 'Sag/Artikel - Konteret tid',
        'TicketAccountedTime' => 'SagKonteretTid',
        'Ticket Create Time' => 'Tidspunkt for sagsoprettelse',
        'Ticket Close Time' => 'Tidspunkt for sagslukning',

        # Template: AAATicket
        'Status View' => '',
        'Bulk' => '',
        'Lock' => 'Ls',
        'Unlock' => 'Ulst',
        'History' => 'Historik',
        'Zoom' => 'Vis',
        'Age' => 'Alder',
        'Bounce' => 'Retur til afsender',
        'Forward' => 'Videresend',
        'From' => 'Fra',
        'To' => 'Til',
        'Cc' => 'Cc',
        'Bcc' => 'Bcc',
        'Subject' => 'Emne',
        'Move' => 'Flyt',
        'Queue' => 'K',
        'Queues' => 'Ker',
        'Priority' => 'Prioritering',
        'Priorities' => '',
        'Priority Update' => 'Prioritets opdatering',
        'SLA' => 'SLA',
        'Service Level Agreement' => 'Service aftale',
        'Service Level Agreements' => '',
        'Service' => 'Service',
        'Services' => '',
        'State' => 'Status',
        'States' => '',
        'Status' => 'Status',
        'Statuses' => 'Statuser',
        'Ticket Type' => 'Sags type',
        'Ticket Types' => 'Sags typer',
        'Compose' => 'Skrive',
        'Pending' => 'Afventer',
        'Owner' => 'Konsulent',
        'Owner Update' => 'Konsulent Opdatering',
        'Responsible' => 'Ansvarlig',
        'Responsible Update' => 'Ansvarlig Opdatering',
        'Sender' => 'Afsender',
        'Article' => 'Artikel',
        'Ticket' => 'Sag',
        'Createtime' => 'Oprettelses tid',
        'plain' => 'almindelig',
        'Email' => 'E-mail',
        'email' => 'e-mail',
        'Close' => 'Luk',
        'Action' => 'Handling',
        'Attachment' => 'Vedhftet fil',
        'Attachments' => 'Vedhftede filer',
        'This message was written in a character set other than your own.' => 'Denne meddelelse blev skrevet i et andet tegnst end dit eget.',
        'If it is not displayed correctly,' => 'Vises den ikke korrekt,',
        'This is a' => 'Dette er en',
        'to open it in a new window.' => 'for at bne i et nyt vindue.',
        'This is a HTML email. Click here to show it.' => 'Dette er en e-mail i HTML. Klik her for at vise den.',
        'Free Fields' => 'Frie felter',
        'Merge' => 'Sammel',
        'merged' => 'samlet',
        'closed successful' => 'lukning lykkedes',
        'closed unsuccessful' => 'lukning mislykkedes',
        'Locked Tickets Total' => '',
        'Locked Tickets Reminder Reached' => '',
        'Locked Tickets New' => '',
        'Responsible Tickets Total' => '',
        'Responsible Tickets New' => '',
        'Responsible Tickets Reminder Reached' => '',
        'Watched Tickets Total' => '',
        'Watched Tickets New' => '',
        'Watched Tickets Reminder Reached' => '',
        'new' => 'ny',
        'open' => 'ben',
        'Open' => 'ben',
        'closed' => 'lukket',
        'Closed' => 'Lukket',
        'removed' => 'fjernet',
        'pending reminder' => 'afventer pmindelse',
        'pending auto' => 'afventer auto',
        'pending auto close+' => 'afventer autolukning+',
        'pending auto close-' => 'afventer autolukning-',
        'email-external' => 'email-ekstern',
        'email-internal' => 'email-intern',
        'note-external' => 'bemrkning-ekstern',
        'note-internal' => 'bemrkning-intern',
        'note-report' => 'bemrkning-rapport',
        'phone' => 'telefon',
        'sms' => 'sms',
        'webrequest' => 'webanmodning',
        'lock' => 'ls',
        'unlock' => 'ulst',
        'very low' => 'meget lav',
        'low' => 'lav',
        'normal' => 'normal',
        'high' => 'hj',
        'very high' => 'meget hj',
        '1 very low' => '1 meget lav',
        '2 low' => '2 lav',
        '3 normal' => '3 normal',
        '4 high' => '4 hj',
        '5 very high' => '5 meget hj',
        'Ticket "%s" created!' => 'Sag "%s" oprettet!',
        'Ticket Number' => 'Sagsnummer',
        'Ticket Object' => 'Sagsobjekt',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Intet sdant sagsnummer "%s"! Kan ikke sammenkde det!',
        'Don\'t show closed Tickets' => 'Vis ikke lukkede sag',
        'Show closed Tickets' => 'Vis lukkede sag',
        'New Article' => 'Ny artikkel',
        'Unread article(s) available' => '',
        'Remove from list of watched tickets' => '',
        'Add to list of watched tickets' => '',
        'Email-Ticket' => 'E-mail-sag',
        'Create new Email Ticket' => 'Opret ny e-mailsag',
        'Phone-Ticket' => 'Telefon-Sag',
        'Search Tickets' => 'Sg sager',
        'Edit Customer Users' => 'Rediger kundebrugere',
        'Edit Customer Company' => 'Rediger kunde firma',
        'Bulk Action' => 'Massehandling',
        'Bulk Actions on Tickets' => 'Massehandlinger vedrrende sager',
        'Send Email and create a new Ticket' => 'Send e-mail og opret en ny sag',
        'Create new Email Ticket and send this out (Outbound)' => 'Opret ny email sag, og afsend denne (Outbound)',
        'Create new Phone Ticket (Inbound)' => 'Opret ny telefon sag (Inbound)',
        'Overview of all open Tickets' => 'Oversigt over alle bne sager',
        'Locked Tickets' => 'Lste sager',
        'My Locked Tickets' => 'Mine lste sager',
        'My Watched Tickets' => '',
        'My Responsible Tickets' => '',
        'Watched Tickets' => 'Overvgede sager',
        'Watched' => 'Overvget',
        'Watch' => '',
        'Unwatch' => '',
        'Lock it to work on it!' => 'Ls den for at arbejde p den!',
        'Unlock to give it back to the queue!' => 'Ls den op for at give den tilbage til ken!',
        'Shows the ticket history!' => 'Vis saghistorik!',
        'Print this ticket!' => 'Udskriv denne sag!',
        'Change the ticket priority!' => 'Skift sagsprioriteringen!',
        'Change the ticket free fields!' => 'Skift sagens frie felter!',
        'Link this ticket to an other objects!' => 'Sammenkd denne sag til et andet objekt!',
        'Change the ticket owner!' => 'Skift konsulent p sagen!',
        'Change the ticket customer!' => 'Skift sagskunden!',
        'Add a note to this ticket!' => 'Tilfj en bemrkning til denne sag!',
        'Merge this ticket!' => 'Saml denne sag!',
        'Set this ticket to pending!' => 'Marker denne sag som afventende!',
        'Close this ticket!' => 'Luk denne sag!',
        'Look into a ticket!' => 'Se nrmere p en sag!',
        'Delete this ticket!' => 'Slet denne sag!',
        'Mark as Spam!' => 'Markr som spam!',
        'My Queues' => 'Mine ker',
        'Shown Tickets' => 'Vis sager',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Din e-mail med sagnummer "<OTRS_TICKET>" er samlet til "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => 'Sag %s: frste svar er overskredet (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Sag %s: frste svar vil vre overskrevet om %s!',
        'Ticket %s: update time is over (%s)!' => 'Sag %s: opdaterings tid er overskredet (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Sag %s: opdaterings tid vil vre overskredet om %s!',
        'Ticket %s: solution time is over (%s)!' => 'Sag %s: Lsnings tid er overskredet (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Sag %s: lsnings tid er overskredet om %s!',
        'There are more escalated tickets!' => 'Der er ikke flere eskalerede sager!',
        'Plain Format' => '',
        'Reply All' => '',
        'Direction' => '',
        'New ticket notification' => 'Besked om ny sag',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Send mig en besked, hvis der er en ny sag i "Mine ker".',
        'Send new ticket notifications' => '',
        'Ticket follow up notification' => '',
        'Ticket lock timeout notification' => 'Besked om sagls efter tidsfristens udlb',
        'Send me a notification if a ticket is unlocked by the system.' => 'Send mig en besked, hvis systemet lser en sag op.',
        'Send ticket lock timeout notifications' => '',
        'Ticket move notification' => '',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Send mig en besked, hvis en sag flyttes ind i en af "Mine ker".',
        'Send ticket move notifications' => '',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Dit kvalg af foretrukne ker. Du fr ogs besked om disse ker via e-mail, hvis det er aktiveret.',
        'Custom Queue' => 'Brugertilpas k',
        'QueueView refresh time' => 'KVisnings genindlsningstid',
        'If enabled, the QueueView will automatically refresh after the specified time.' => '',
        'Refresh QueueView after' => '',
        'Screen after new ticket' => 'Skrm efter ny sag',
        'Show this screen after I created a new ticket' => '',
        'Closed Tickets' => 'Lukkede sager',
        'Show closed tickets.' => 'Vis lukkede sager.',
        'Max. shown Tickets a page in QueueView.' => 'Max. viste sager pr. side i k-visning - QueueView.',
        'Ticket Overview "Small" Limit' => '',
        'Ticket limit per page for Ticket Overview "Small"' => '',
        'Ticket Overview "Medium" Limit' => '',
        'Ticket limit per page for Ticket Overview "Medium"' => '',
        'Ticket Overview "Preview" Limit' => '',
        'Ticket limit per page for Ticket Overview "Preview"' => '',
        'Ticket watch notification' => '',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => '',
        'Send ticket watch notifications' => '',
        'Out Of Office Time' => '',
        'New Ticket' => 'Ny sag',
        'Create new Ticket' => 'Opret ny sag',
        'Customer called' => 'Opkald fra Kunde',
        'phone call' => 'opringning',
        'Phone Call Outbound' => '',
        'Reminder Reached' => 'Pmindelse net',
        'Reminder Tickets' => 'Sager med pmindelse',
        'Escalated Tickets' => 'Eskalerede sager',
        'New Tickets' => 'Nye sager',
        'Open Tickets / Need to be answered' => 'Sager under behandling',
        'All open tickets, these tickets have already been worked on, but need a response' => '',
        'All new tickets, these tickets have not been worked on yet' => '',
        'All escalated tickets' => '',
        'All tickets with a reminder set where the reminder date has been reached' => '',
        'History::Move' => 'Historik::Flytning',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'Historik::NySag',
        'History::FollowUp' => 'Historik::Opflgning',
        'History::SendAutoReject' => 'Historik::SendAutoAfslag',
        'History::SendAutoReply' => 'Historik::SendAutoSvar',
        'History::SendAutoFollowUp' => 'Historik::SendAutoOpflgning',
        'History::Forward' => 'Historik::Videresend',
        'History::Bounce' => 'Historik::Retur til afsender',
        'History::SendAnswer' => 'Historik::SendSvar',
        'History::SendAgentNotification' => 'Historik::SendAgentBesked',
        'History::SendCustomerNotification' => 'Historik::SendKundeBesked',
        'History::EmailAgent' => 'Historik::E-mailAgent',
        'History::EmailCustomer' => 'Historik::E-mailKunde',
        'History::PhoneCallAgent' => 'Historik::TelefonOpkaldAgent',
        'History::PhoneCallCustomer' => 'Historik::TelefonOpkaldKunde',
        'History::AddNote' => 'Historik::TilfjBemrkning',
        'History::Lock' => 'Historik::Ls',
        'History::Unlock' => 'Historik::Ls op',
        'History::TimeAccounting' => 'Historik::TidRegnskab',
        'History::Remove' => 'Historik::Fjern',
        'History::CustomerUpdate' => 'Historik::KundeOpdatering',
        'History::PriorityUpdate' => 'Historik::Prioritetsopdatering',
        'History::OwnerUpdate' => 'Historik::IndehaverOpdatering',
        'History::LoopProtection' => 'Historik::LoopBeskyttelse',
        'History::Misc' => 'Historik::Diverse',
        'History::SetPendingTime' => 'Historik::IndstilVentetid',
        'History::StateUpdate' => 'Historik::TilstandOpdatering',
        'History::TicketFreeTextUpdate' => 'Historik::SagFriTekstOpdatering',
        'History::WebRequestCustomer' => 'Historik::WebAnmodningKunde',
        'History::TicketLinkAdd' => 'Historik::SagLinkTilfj',
        'History::TicketLinkDelete' => 'Historik::SagLinkSlet',
        'History::Subscribe' => 'Historik::Tilmeld',
        'History::Unsubscribe' => 'Historik::Afmeld',
        'History::SystemRequest' => 'Historik::SystemForesprgsel',
        'History::ResponsibleUpdate' => 'Historik::AnsvarligOpdatering',

        # Template: AAAWeekDay
        'Sun' => 'Sn',
        'Mon' => 'Man',
        'Tue' => 'Tir',
        'Wed' => 'Ons',
        'Thu' => 'Tor',
        'Fri' => 'Fre',
        'Sat' => 'Lr',

        # Template: AdminAttachment
        'Attachment Management' => 'Styring af vedhftede filer',
        'Actions' => 'Handlinger',
        'Go to overview' => 'G til oversigt',
        'Add attachment' => '',
        'List' => 'Liste',
        'No data found.' => 'Ingen data blev fundet',
        'Download file' => 'Download fil',
        'Delete this attachment' => 'Slet denne vedhftning',
        'Add Attachment' => 'Tilfj vedhftning',
        'Edit Attachment' => 'Rediger vedhftning',
        'This field is required.' => 'Dette felt er pkrvet',
        'or' => 'eller',

        # Template: AdminAutoResponse
        'Auto Response Management' => 'Styring af autosvar',
        'Add auto response' => 'Tilfj autosvar',
        'Add Auto Response' => 'Tilfj autosvar',
        'Edit Auto Response' => 'Rediger autosvar',
        'Response' => 'Svar',
        'Auto response from' => 'Autosvar afsender',
        'Reference' => 'Reference',
        'You can use the following tags' => 'Du kan benytte flgende tags',
        'To get the first 20 character of the subject.' => 'For at f de frste 20 tegn af emnet.',
        'To get the first 5 lines of the email.' => 'For at f de frste 5 linjer af emailen.',
        'To get the realname of the sender (if given).' => 'For at f afsenderes navn, hvis angivet.',
        'To get the article attribute' => 'For at f artiklens attributter',
        ' e. g.' => ' f.eks.',
        'Options of the current customer user data' => 'Muligheder for den nuvrende kundes data',
        'Ticket owner options' => 'Sags ejer muligheder',
        'Ticket responsible options' => 'Sags ansvarlig muligheder',
        'Options of the current user who requested this action' => 'Muligheder for den nuvrende bruger, der har forespurgt denne handling',
        'Options of the ticket data' => 'Muligheder for sags data',
        'Config options' => 'Konfigurations muligheder',
        'Example response' => 'Eksempel svar',

        # Template: AdminCustomerCompany
        'Customer Company Management' => 'Kunde Firma Administration',
        'Wildcards are allowed.' => 'Jokertegn er tilladt',
        'Add customer company' => 'Tilfj kunde firma',
        'Please enter a search term to look for customer companies.' => 'Indtast venligst en sge streng for at finde kunde firmaer',
        'Add Customer Company' => 'Tilfj kunde firma',

        # Template: AdminCustomerUser
        'Customer Management' => 'Kunde Hndtering',
        'Add customer' => 'Tilfj kunde',
        'Select' => 'Vlg',
        'Hint' => '',
        'Customer will be needed to have a customer history and to login via customer panel.' => 'Kunde er ndvendig for at have en historik, og for at kunne logge ind i kunde panalet.',
        'Please enter a search term to look for customers.' => 'Indtast venligst et sgeord, for at sge efter kunder.',
        'Last Login' => 'Sidste login',
        'Add Customer' => 'Tilfj kunde',
        'Edit Customer' => 'Rediger kunde',
        'This field is required and needs to be a valid email address.' => '',
        'This email address is not allowed due to the system configuration.' => '',
        'This email address failed MX check.' => '',
        'The syntax of this email address is incorrect.' => '',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => 'Administrer Kunde-Gruppe relationer',
        'Notice' => 'Besked',
        'This feature is disabled!' => 'Denne mulighed er deaktiveret!',
        'Just use this feature if you want to define group permissions for customers.' => '',
        'Enable it here!' => 'Aktiver det her!',
        'Search for customers (wildcards are allowed).' => 'Sg efter kunder (jokertegn er tilladt).',
        'Edit Customer Default Groups' => 'Rediger Kunde Standard gruppe',
        'These groups are automatically assigned to all customers.' => 'Disse grupper er automatisk tildelt alle kunder.',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '',
        'Filter for Groups' => 'Filter for grupper',
        'Select the customer:group permissions.' => 'Vlg kunde:gruppe rettigheder',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => 'Hvis intet er valgt, er der ingen rettigeheder i denne gruppe (sager vil ikke vre tilgngelig for kunden).',
        'Search Result:' => 'Sge resultater:',
        'Customers' => '',
        'Groups' => 'Grupper',
        'No matches found.' => 'Ingen resultater fundet',
        'Change Group Relations for Customer' => '',
        'Change Customer Relations for Group' => '',
        'Toggle %s Permission for all' => 'Skift %s rettigheder for alle',
        'Toggle %s permission for %s' => 'Skift %s rettigheder for %s',
        'Customer Default Groups:' => 'Kunde standard grupper:',
        'No changes can be made to these groups.' => 'Der kan ikke laves ndringer ved disse grupper',
        'ro' => 'ro',
        'Read only access to the ticket in this group/queue.' => 'Kun lseadgang til sager i denne gruppe/k.',
        'rw' => 'rw',
        'Full read and write access to the tickets in this group/queue.' => 'Komplet lse- og skriveadgang til sagerne i denne gruppe/k.',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => 'Administrer Kunde-Service relationer',
        'Edit default services' => 'Rediger standard services',
        'Filter for Services' => 'Filer for services',
        'Allocate Services to Customer' => '',
        'Allocate Customers to Service' => '',
        'Toggle active state for all' => 'Skift aktiv stadie for alle',
        'Active' => 'Aktiv',
        'Toggle active state for %s' => 'Skift aktiv stadie for %s',

        # Template: AdminEmail
        'Admin Notification' => 'Besked til admin',
        'Send Administrative Message to Agents' => 'Send administrative beskeder til agenter',
        'Your message was sent to' => 'Din besked blev sent til',
        'Send message to users' => 'Send besked til brugere',
        'Send message to group members' => 'Send besked til gruppe medlemmer',
        'Group members need to have permission' => 'Gruppe medlemmer skal have rettigheder',
        'Send message to role members' => 'Send besked til alle rolle medlemmer',
        'Also send to customers in groups' => 'Send ogs til kunder i gruppe',
        'Please enter subject.' => 'Indtast et emne.',
        'Body' => 'Hovedtekst',
        'Send' => 'Afsend',

        # Template: AdminGenericAgent
        'Generic Agent' => 'General agent',
        'Add job' => 'Tilfj job',
        'Last run' => 'Sidste krsel',
        'Run Now!' => 'Kr nu!',
        'Delete this task' => 'Slet denne opgave',
        'Run this task' => 'Kr denne opgave',
        'Job Settings' => 'Job indstillinger',
        'Job name' => 'Job navn',
        'Please provide a name.' => 'Angiv et navn.',
        'Schedule minutes' => 'Planlg minutter',
        'Schedule hours' => 'Planlg timer',
        'Schedule days' => 'Planlg dage',
        'Currently this generic agent job will not run automatically.' => 'Lige nu vil denne generiske agent ikke krer automatisk.',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'For at aktivere automatisk krsel skal du vlge mindst en vrdi fra minutter, timer og dage!',
        'Toggle this widget' => '',
        'Ticket Filter' => 'Sags filter',
        '(e. g. 10*5155 or 105658*)' => '(f.eks. 10*5155 eller 105658*)',
        '(e. g. 234321)' => '(f.eks. 234321)',
        'Customer login' => 'Kunde login',
        '(e. g. U5150)' => '(f.eks. U5150)',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => 'Fuldtekst sgning i artikkel (f.eks. "Mar*in" or "Hanse*").',
        'Agent' => 'Konsulent',
        'Ticket lock' => 'Sags ls',
        'TicketFreeFields' => 'SagsFriFelter',
        'Create times' => 'Oprettelses tider',
        'No create time settings.' => 'Opret ikke tider.',
        'Ticket created' => 'Sag oprettet',
        'Ticket created between' => 'Sag oprettet mellem',
        'Close times' => 'Luknings tider',
        'No close time settings.' => 'Ingen lukke tids indstillinger',
        'Ticket closed' => 'Sag lukket',
        'Ticket closed between' => 'Sag lukket mellem',
        'Pending times' => 'Afventende tider',
        'No pending time settings.' => 'Ingen afventende tider',
        'Ticket pending time reached' => 'Sags afvents tid er net',
        'Ticket pending time reached between' => 'Sagens afventnings tid er opnet mellem',
        'Escalation times' => 'Eskalations tider',
        'No escalation time settings.' => 'Der er ikke sat nogen eskalationstid.',
        'Ticket escalation time reached' => 'Sagens eskalationstid er net',
        'Ticket escalation time reached between' => 'Sagens eskalationstid er net mellem',
        'Escalation - first response time' => 'Eskalation - frste reaktions tid',
        'Ticket first response time reached' => 'Sagens tid for frste svar er net',
        'Ticket first response time reached between' => 'Sagens tid for frste svar er net mellem',
        'Escalation - update time' => 'Eskalation - opdaterings tid',
        'Ticket update time reached' => 'Sagens opdaterings tid er net',
        'Ticket update time reached between' => 'Sagens ogdateringstid er net mellem',
        'Escalation - solution time' => 'Eskalation - lsnings tid',
        'Ticket solution time reached' => 'Sagens lsningstid er net',
        'Ticket solution time reached between' => 'Sagens lsningstid er net mellem',
        'Archive search option' => 'Arkiver sge muligheder',
        'Ticket Action' => 'Sags handling',
        'Set new service' => 'Angiv ny service',
        'Set new Service Level Agreement' => '',
        'Set new priority' => 'Angiv ny prioritet',
        'Set new queue' => 'Angiv ny k',
        'Set new state' => 'Angiv nyt stadie',
        'Set new agent' => 'Angiv ny agent',
        'new owner' => 'ny ejer',
        'Set new ticket lock' => 'Angiv ny sags ls',
        'New customer' => 'Ny kunde',
        'New customer ID' => 'Nyt kunde ID',
        'New title' => 'Ny titel',
        'New type' => 'Ny type',
        'New TicketFreeFields' => 'Ny SagsFriFelter',
        'Add Note' => 'Tilfj bemrkning',
        'Time units' => 'Tidsenheder',
        ' (work units)' => '(arbejdsenheder)',
        'Archive selected tickets' => 'Arkiver valgte sager',
        'Ticket Commands' => '',
        'Send agent/customer notifications on changes' => 'Send besked til konsulenten ved ndringer',
        'CMD' => 'CMD',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Denne kommando vil blive udfrt. ARG[0] bliver sagens nummer. ARG[1] sagens ID. ',
        'Delete tickets' => 'Slet sager',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => 'Advarsel: Alle berrte sager vil blive fjernet fra databasen, og kan ikke genskabes!',
        'Execute Custom Module' => 'Eksekver brugerdefineret modul',
        'Param %s key' => '',
        'Param %s value' => '',
        'Save Changes' => '',
        'Save' => 'Gem',
        'Results' => 'Resultater',
        '%s Tickets affected! What do you want to do?' => '%s sager berrt! Hvad vil du gre?',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => 'Advarsel: Du brugte SLET funktionen. Alle slettede sager er fjernet!',
        'Edit job' => 'Rediger job',
        'Run job' => 'Kr job',
        'Affected Tickets' => 'Berrte sager',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '',
        'Group Management' => 'Gruppestyring',
        'Add group' => 'Tilfj gruppe',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Admin-gruppen skal ind i administratoromrdet og statistikgruppen i statistikomrdet.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => 'Tilfj nye gruppe for at hndtere adgangs rettigheder, for forskellige gruppe til en agent (f.eks. Indkbsafdeling, Salgsafdeling, Support afdeling, .....).',
        'It\'s useful for ASP solutions. ' => 'Dette er nyttigt til ASP lsninger',
        'Add Group' => 'Tilfj Gruppe',
        'Edit Group' => 'Rediger gruppe',

        # Template: AdminLog
        'System Log' => 'Systemlog',
        'Here you will find log information about your system.' => 'Her vil du finde information omkring dit system.',
        'Time' => 'Tid',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Mail Konto Administration',
        'Add mail account' => 'Tilfj mail konto',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Alle indkommende e-mails med 1 konto sendes til den valgte k!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Er der tillid til din konto, bliver den allerede eksisterende X-OTRS-header ved ankomsttidspunktet (for prioritering, ...) anvendt! Der anvendes PostMaster-filter under alle omstndigheder.',
        'Host' => 'Vrt',
        'Delete account' => 'Slet konto',
        'Fetch mail' => 'Hent mail',
        'Add Mail Account' => 'Tilfj mail konto',
        'Example: mail.example.com' => '',
        'Trusted' => 'Plidelig',
        'Dispatching' => 'Sender',
        'Edit Mail Account' => 'Rediger mail konto',

        # Template: AdminNavigationBar
        'Admin' => 'Administrator',
        'Agent Management' => 'Agent Hndtering',
        'Queue Settings' => 'K indstillinger',
        'Ticket Settings' => 'Sags indstillinger',
        'System Administration' => 'System administration',

        # Template: AdminNotification
        'Notification Management' => 'Beskedstyring',
        'Filter for Language' => 'Filter for sprog',
        'Filter for Notification' => 'Filter for beskeder',
        'Notifications are sent to an agent or a customer.' => 'Beskeder sendes til en konsulent eller kunde.',
        'Notification' => 'Besked',
        'Edit Notification' => 'Rediger besked',
        'e. g.' => 'f. eks.',
        'Options of the current customer data' => 'Muligheder for nuvrende kundes data',

        # Template: AdminNotificationEvent
        'Add notification' => 'Tilfj besked',
        'Delete this notification' => 'Slet denne besked',
        'Add Notification' => 'Tilfj besked',
        'Recipient groups' => 'Modtager grupper',
        'Recipient agents' => 'Modtager agenter',
        'Recipient roles' => 'Modtager roller',
        'Recipient email addresses' => 'Modtager email adresser',
        'Article type' => 'Artikeltype',
        'Only for ArticleCreate event' => 'Kun for ArtikkelOprettelses hndelser',
        'Subject match' => 'Emne ens',
        'Body match' => 'Indhold ens',
        'Include attachments to notification' => 'Inkluder vedhftninger til notifikationer',
        'Notification article type' => '',
        'Only for notifications to specified email addresses' => '',
        'To get the first 20 character of the subject (of the latest agent article).' => 'For at f de frste 20 tegn af emnet (af den sidste konsulents artikel).',
        'To get the first 5 lines of the body (of the latest agent article).' => 'For at f de frste 5 linier af teksten (af den sidste konsulents artikel).',
        'To get the first 20 character of the subject (of the latest customer article).' => 'For at f de frste 20 tegn af emnet (af den sidste kundes artikel).',
        'To get the first 5 lines of the body (of the latest customer article).' => 'For at f de frste 5 linier af teksten (af den sidste kundes artikel).',

        # Template: AdminPGP
        'PGP Management' => 'PGP-styring',
        'Add PGP key' => 'Tilfj PGP ngle',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Du kan p denne mde direkte redigere den nglering, der er konfigureret i SysConfig.',
        'Introduction to PGP' => '',
        'Result' => 'Resultat',
        'Identifier' => 'Identifikator',
        'Bit' => 'Bit',
        'Key' => 'Ngle',
        'Fingerprint' => 'Fingeraftryk',
        'Expires' => 'Udlber',
        'Delete this key' => 'Slet denne ngle',
        'Add PGP Key' => 'Tilfj PGP ngle',

        # Template: AdminPackageManager
        'Package Manager' => 'Pakke Styring',
        'Uninstall package' => 'Afinstaller pakke',
        'Version' => 'Version',
        'Do you really want to uninstall this package?' => 'Er du sikker p, du nsker at afinstallere denne pakke?',
        'Reinstall package' => 'Geninstaller pakke',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => '',
        'Continue' => 'Fortst',
        'Install' => 'Installation',
        'Install Package' => 'Installer pakke',
        'Update repository information' => 'Opdater repository infromation',
        'Online Repository' => 'Online lagerdepot',
        'Vendor' => 'Slger',
        'Module documentation' => 'Modul-dokumentation',
        'Upgrade' => 'Opgrader',
        'Local Repository' => 'Lokalt lagerdepot',
        'Uninstall' => 'Afinstaller',
        'Package not correctly deployed! You should reinstall the package again!' => '',
        'Reinstall' => 'Geninstaller',
        'Download package' => 'Download pakke',
        'Rebuild package' => 'Genopbyg pakke',
        'Metadata' => 'Metadata',
        'Change Log' => '',
        'Date' => 'Dato',
        'List of Files' => 'Liste af filer',
        'Permission' => 'Tilladdelse',
        'Download' => 'Download',
        'Download file from package!' => 'Download fil fra pakke!',
        'Required' => 'Pkrvet',
        'PrimaryKey' => 'PrimrNgle',
        'AutoIncrement' => 'AutoForhjelse',
        'SQL' => 'SQL',
        'File differences for file %s' => 'Fil forskelligheder til fil %s',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Ydelses log',
        'This feature is enabled!' => 'Denne fuktion er aktiveret',
        'Just use this feature if you want to log each request.' => 'Benyt denne funktion hvis du nsker at alle foresprgsler skal logges.',
        'Activating this feature might affect your system performance!' => 'Aktivering af denne funktion, vil mske pvirke effekten af dit system!',
        'Disable it here!' => 'Deaktiver det her!',
        'Logfile too large!' => 'Logfil er for stor',
        'The logfile is too large, you need to reset it' => 'Logfiler er for stor, du skal nulstille den',
        'Overview' => 'Oversigt',
        'Range' => 'Omrde',
        'Interface' => 'Interface',
        'Requests' => 'Foresprgsel',
        'Min Response' => 'Min Svar',
        'Max Response' => 'Max Svar',
        'Average Response' => 'Gennemsnitligt Svar',
        'Period' => 'Periode',
        'Min' => 'Min',
        'Max' => 'Max',
        'Average' => 'Gennemsnitlig',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'PostMasters filterstyring',
        'Add filter' => '',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Hvis du kun nsker at matche email adressen, s brug EMAILADDRESS:info@example.com i Fra, Til eller Cc.',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '',
        'Delete this filter' => '',
        'Add PostMaster Filter' => '',
        'Edit PostMaster Filter' => '',
        'Filter name' => '',
        'Stop after match' => 'Stop efter resultat',
        'Filter Condition' => '',
        'Value' => 'Vrdi',
        'Set Email Headers' => '',

        # Template: AdminPriority
        'Priority Management' => 'Prioritets administration',
        'Add priority' => '',
        'Add Priority' => 'Tilfj prioritet',
        'Edit Priority' => '',

        # Template: AdminQueue
        'Manage Queues' => '',
        'Add queue' => '',
        'Add Queue' => '',
        'Edit Queue' => '',
        'Sub-queue of' => '',
        'Unlock timeout' => 'Ls tisfristen op',
        '0 = no unlock' => '0 = ingen oplsning',
        'Only business hours are counted.' => 'Kun normal kontor tid er beregnet.',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => '',
        'Notify by' => 'Adviser via',
        '0 = no escalation' => '0 = ingen eskalering',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => '',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => '',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => '',
        'Follow up Option' => 'Opflgningsmulighed',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => '',
        'Ticket lock after a follow up' => 'Sag oplst efter en opflgning',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => '',
        'System address' => '',
        'Will be the sender address of this queue for email answers.' => 'Bliver til denne ks afsenderadresse for e-mailsvar.',
        'Default sign key' => '',
        'The salutation for email answers.' => 'Den hilsen, der bruges til e-mailsvar.',
        'The signature for email answers.' => 'Den underskrift, der bruges til e-mailsvar.',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => '',
        'Filter for Queues' => '',
        'Filter for Auto Responses' => '',
        'Auto Responses' => 'Autosvar',
        'Change Auto Response Relations for Queue' => '',
        'settings' => 'indstillinger',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => '',
        'Filter' => 'Filter',
        'Filter for Responses' => '',
        'Responses' => 'Svar',
        'Change Queue Relations for Response' => '',
        'Change Response Relations for Queue' => '',

        # Template: AdminResponse
        'Manage Responses' => '',
        'Add response' => '',
        'A response is default text to write faster answer (with default text) to customers.' => 'Et Svar er en standardtekst, der bruges til at skrive et hurtigere svar (med standardtekst) til kunderne.',
        'Don\'t forget to add a new response a queue!' => 'Glem ikke at tilfje et nyt svar pr. k!',
        'Delete this entry' => '',
        'Add Response' => '',
        'Edit Response' => '',
        'The current ticket state is' => 'Den aktuelle sags status er',
        'Your email address is' => '',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => '',
        'Filter for Attachments' => '',
        'Change Response Relations for Attachment' => '',
        'Change Attachment Relations for Response' => '',
        'Toggle active for all' => '',
        'Link %s to selected %s' => '',

        # Template: AdminRole
        'Role Management' => 'Rollestyring',
        'Add role' => '',
        'Create a role and put groups in it. Then add the role to the users.' => 'Opret en rolle og indst grupper i den. Tilfj dernst brugernes rolle.',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => '',
        'Add Role' => 'Tilfj rolle',
        'Edit Role' => '',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => '',
        'Filter for Roles' => '',
        'Roles' => 'Roller',
        'Select the role:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => '',
        'Change Role Relations for Group' => '',
        'Change Group Relations for Role' => '',
        'Toggle %s permission for all' => '',
        'move_into' => 'flyt_til',
        'Permissions to move tickets into this group/queue.' => 'Tilladelser til at flytte sager ind i denne gruppe/k.',
        'create' => 'opret',
        'Permissions to create tickets in this group/queue.' => 'Tilladelser til at oprette sager i denne gruppe/k.',
        'priority' => 'prioritering',
        'Permissions to change the ticket priority in this group/queue.' => 'Tilladelser til at ndre sagprioriteringen i denne gruppe/k.',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => '',
        'Filter for Agents' => '',
        'Agents' => '',
        'Manage Role-Agent Relations' => '',
        'Change Role Relations for Agent' => '',
        'Change Agent Relations for Role' => '',

        # Template: AdminSLA
        'SLA Management' => 'SLA Administration',
        'Add SLA' => 'Tilfj SLA',
        'Edit SLA' => '',
        'Please write only numbers!' => '',

        # Template: AdminSMIME
        'S/MIME Management' => 'S/MIME Styring',
        'Add private key' => '',
        'Add certificate' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'Du kan p denne mde direkte redigere certificeringsngler og private ngler i filsystemet.',
        'See also' => 'Se ogs',
        'Hash/Fingerprint' => '',
        'Create/Expires' => '',
        'Delete this certificate' => '',
        'Add Certificate' => 'Tilfj certifikat',
        'Add Private Key' => 'Tilfj privat ngle',
        'Secret' => 'Hemmelig',

        # Template: AdminSalutation
        'Salutation Management' => 'Styring af hilsner',
        'Add salutation' => '',
        'Add Salutation' => 'Tilfj hilsen',
        'Edit Salutation' => '',
        'Example salutation' => '',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'Sikker tilstand vil (normalt) vret slet til efter installationen er fuldfrt.',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'Sikker tilstand skal vre slet fra for at reinstallere via Web-installer',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBox
        'SQL Box' => 'SQL Box',
        'Here you can enter SQL to send it directly to the application database.' => '',
        'Result format' => '',
        'Run Query' => '',

        # Template: AdminService
        'Service Management' => 'Service administration',
        'Add service' => '',
        'Add Service' => 'Tilfj service',
        'Edit Service' => '',
        'Sub-service of' => '',

        # Template: AdminSession
        'Session Management' => 'Sessionsstyring',
        'All sessions' => '',
        'Agent sessions' => '',
        'Customer sessions' => '',
        'Unique agents' => '',
        'Unique customers' => '',
        'Kill all sessions' => 'Drb alle sessions',
        'Session' => 'Session',
        'Kill' => '',
        'Kill this session' => '',
        'Detail View for SessionID' => '',

        # Template: AdminSignature
        'Signature Management' => 'Underskriftstyring',
        'Add signature' => '',
        'Add Signature' => 'Tilfj underskrift',
        'Edit Signature' => '',
        'Example signature' => '',

        # Template: AdminState
        'State Management' => 'Tilstands administration',
        'Add state' => '',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Srg for, at du ogs opdatede standardtilstandene i Kernel/Config.pm!',
        'Add State' => 'Tilfj tilstand',
        'Edit State' => '',
        'State type' => '',

        # Template: AdminSysConfig
        'SysConfig' => 'SysConfig',
        'Navigate by searching in %s settings' => '',
        'Select Group' => '',
        'Navigate by selecting config groups' => '',
        'Select group' => '',
        'Download all system config changes' => '',
        'Export settings' => '',
        'Load SysConfig settings from file' => '',
        'Import settings' => '',
        'Import Settings' => '',
        'Import' => 'Importer',
        'Please enter a search term to look for settings.' => '',
        'Subgroup' => 'Undergruppe',
        'Elements' => 'Elementer',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => '',
        'This config item is only available in a higher config level!' => '',
        'Reset this setting' => '',
        'Default value' => '',
        'Error: this file could not be found.' => '',
        'Error: this directory could not be found.' => '',
        'Error: an invalid value was entered.' => '',
        'Content' => 'Indhold',
        'Remove this entry' => '',
        'Add entry' => '',
        'Remove entry' => '',
        'Add new entry' => '',
        'Create new entry' => '',
        'New group' => '',
        'Group ro' => '',
        'Readonly group' => '',
        'New group ro' => '',
        'Loader' => '',
        'File to load for this frontend module' => '',
        'New Loader File' => '',
        'NavBarName' => 'NavBarNavn',
        'NavBar' => 'NavBar',
        'LinkOption' => '',
        'Block' => 'Blok',
        'AccessKey' => 'AdgangsNgle',
        'Add NavBar entry' => '',
        'Year' => '',
        'Month' => '',
        'Day' => '',
        'Invalid year' => '',
        'Invalid month' => '',
        'Invalid day' => '',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'Systems e-mailadressestyring',
        'Add system address' => '',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => '',
        'Email address' => '',
        'Display name' => '',
        'Add System Email Address' => '',
        'Edit System Email Address' => '',
        'The display name and email address will be shown on mail you send.' => '',

        # Template: AdminType
        'Type Management' => 'Type administration',
        'Add ticket type' => '',
        'Add Type' => 'Tilfj type',
        'Edit Type' => '',

        # Template: AdminUser
        'Add agent' => '',
        'Agents will be needed to handle tickets.' => '',
        'Don\'t forget to add a new agent to groups and/or roles!' => '',
        'Please enter a search term to look for agents.' => '',
        'Last login' => '',
        'Login as' => 'Login som',
        'Switch to agent' => '',
        'Add Agent' => '',
        'Edit Agent' => '',
        'Firstname' => 'Fornavn',
        'Lastname' => 'Efternavn',
        'Start' => 'Start',
        'End' => 'Slut',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => '',
        'Change Group Relations for Agent' => '',
        'Change Agent Relations for Group' => '',
        'note' => '',
        'Permissions to add notes to tickets in this group/queue.' => '',
        'owner' => 'konsulent',
        'Permissions to change the owner of tickets in this group/queue.' => '',

        # Template: AgentBook
        'Address Book' => 'Adressebog',
        'Search for a customer' => '',
        'Add email address %s to the To field' => '',
        'Add email address %s to the Cc field' => '',
        'Add email address %s to the Bcc field' => '',
        'Apply' => '',

        # Template: AgentCustomerSearch
        'Search Customer' => 'Sg kunde',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Oversigt',
        'Show or hide the content' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => 'i',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s er tilgngelig',
        'Please update now.' => 'Opgrader venligst nu.',
        'Release Note' => 'Frigivelsesnoter',
        'Level' => 'Niveau',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Indsendt %s siden',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket was locked' => '',
        'Undo & close window' => '',

        # Template: AgentInfo
        'Info' => 'Info',
        'To accept some news, a license or some changes.' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Kd objekt: %s',
        'Close window' => '',
        'go to link delete screen' => '',
        'Select Target Object' => '',
        'Link Object' => 'Kd til objekt',
        'with' => 'med',
        'Unlink Object: %s' => 'Fjern kdning af objekt: %s',
        'go to link add screen' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => '',

        # Template: AgentSpelling
        'Spell Checker' => 'Stavekontrolprogram',
        'spelling error(s)' => 'stavefejl',
        'Apply these changes' => 'Anvend disse ndringer',

        # Template: AgentStatsDelete
        'Delete stat' => '',
        'Stat#' => '',
        'Do you really want to delete this stat?' => '',

        # Template: AgentStatsEditRestrictions
        'Step %s' => '',
        'General Specifications' => '',
        'Select the element that will be used at the X-axis' => '',
        'Select the elements for the value series' => 'Vlg elementerne for vrdi serien',
        'Select the restrictions to characterize the stat' => '',
        'Here you can make restrictions to your stat.' => 'Her kan du begrnse din stat',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Vis du fjerner markeringen i boksen "Fast", kan agenten ndrer attributterne ved det valgte element.',
        'Fixed' => 'Fast',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Vlg venligst kun et Element, eller fravlg knappen \'Fast\'',
        'Absolute Period' => '',
        'Between' => 'Mellem',
        'Relative Period' => 'Relativ periode',
        'The last' => 'Den sidste',
        'Finish' => 'Frdig',

        # Template: AgentStatsEditSpecification
        'Permissions' => 'Rettigeheder',
        'Some result formats are disabled because at least one needed package is not installed.' => '',
        'Please contact your administrator.' => '',
        'Graph size' => '',
        'Sum rows' => 'Antal rkker',
        'Sum columns' => 'Antal Kollonner',
        'Use cache' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'De fleste statistikker kan blive cachet, det vil gre prsentationen hurtigere',
        'If set to invalid end users can not generate the stat.' => '',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => '',
        'You have the possibility to select one or two elements.' => '',
        'Then you can select the attributes of elements.' => '',
        'Each attribute will be shown as single value series.' => '',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => 'Skala',
        'minimal' => 'minimum',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Husk venligst at skalen for vrdi serien, skal vre strre end den skala for X-Aksen (f.eks. X-Akse => Month, VrdiSerie => r).',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '',
        'maximal period' => 'maksimal periode',
        'minimal scale' => 'minimal skala',

        # Template: AgentStatsImport
        'Import Stat' => '',
        'File is not a Stats config' => 'Filen er ikke en Stats konfiguration',
        'No File selected' => 'Ingen fil valgt',

        # Template: AgentStatsOverview
        'Stats' => 'Statistik',
        'Object' => 'Objekt',

        # Template: AgentStatsPrint
        'Print' => 'Udskriv',
        'No Element selected.' => 'Intet element er valgt',

        # Template: AgentStatsView
        'Export config' => '',
        'With the input and select fields you can influence the format and contents of the statistic.' => '',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => '',
        'Stat Details' => '',
        'Format' => 'Format',
        'Graphsize' => 'Graf strrelse',
        'Cache' => 'Cache',
        'Exchange Axis' => 'Udskiftning af akser',
        'Configurable params of static stat' => 'Konfigurer bare parametre af en statitisk stat',
        'No element selected.' => 'Intet element er valgt',
        'maximal period from' => 'maksimal periode fra',
        'to' => 'til',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => '',
        'Change Owner of Ticket' => '',
        'Close Ticket' => '',
        'Add Note to Ticket' => '',
        'Set Pending' => 'Indstil afventer',
        'Change Priority of Ticket' => '',
        'Change Responsible of Ticket' => '',
        'Cancel & close window' => '',
        'Service invalid.' => '',
        'New Owner' => 'Ny konsulent',
        'Please set a new owner!' => '',
        'Previous Owner' => 'Tidligere konsulent',
        'Inform Agent' => 'Informer konsulent',
        'Optional' => 'Valgfri',
        'Inform involved Agents' => 'Informer involverede konsulenter',
        'Spell check' => '',
        'Note type' => 'Bemrkningstype',
        'Next state' => 'Nste status',
        'Pending date' => 'Afventer dato',
        'Date invalid!' => '',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => '',
        'Bounce to' => 'Retur til',
        'You need a email address.' => '',
        'Need a valid email address or don\'t use a local email address.' => '',
        'Next ticket state' => 'Nste sags status',
        'Inform sender' => 'Informer afsender',
        'Send mail!' => 'Send email',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Sagsmassehandling',
        'Merge to' => 'Saml til',
        'Invalid ticket identifier!' => '',
        'Merge to oldest' => 'Saml til ldste',
        'Link together' => 'Link sammen',
        'Link to parent' => '',
        'Unlock tickets' => '',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Formuler svar til sag',
        'Need a valid email address.' => '',
        'Address book' => '',
        'Pending Date' => 'Afventer dato',
        'for pending* states' => 'for afventende* tilstande',
        'Date Invalid!' => '',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Skift sagskunde',
        'Customer Data' => 'Kundedata',
        'Customer user' => '',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => '',
        'From queue' => '',
        'Get all' => '',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => '',
        'Need a valid email address or don\'t use a local email address' => '',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'Historik af',
        'History Content' => '',
        'Zoom view' => '',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Sagfletning',
        'The Ticket was locked' => '',
        'You need to use a ticket number!' => 'Du skal have et sagsnummer!',
        'A valid ticket number is required.' => '',

        # Template: AgentTicketMove
        'Move Ticket' => 'Flyt sag',
        'New Queue' => 'Ny k',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => '',
        'No ticket data found.' => '',
        'First Response Time' => 'Frste svar tid',
        'Service Time' => 'Service tid',
        'Update Time' => 'Opdaterings tid',
        'Solution Time' => 'Lsnings tid',
        'Move ticket to a different queue' => '',
        'Change queue' => 'Skift k',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => 'Skift sgemuligheder',
        'Max. shown Tickets a page' => '',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'Eskalering ind',
        'Locked' => 'Lst',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => '',
        'From customer' => '',
        'To queue' => '',
        'Create' => 'Opret',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => 'Telefonopkald',

        # Template: AgentTicketPlain
        'Email Text Plain View' => '',
        'Plain' => 'Almindelig',
        'Download this email' => '',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Sag-Info',
        'Accounted time' => 'Benyttet tid',
        'Linked-Object' => 'Linket-Objekt',
        'by' => 'af',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'Sge-skabelon',
        'Create New' => '',
        'Create Template' => '',
        'Save changes in template' => '',
        'Add another attribute' => '',
        'Output' => 'Resultatformular',
        'Fulltext' => 'Fritekst',
        'Remove' => '',
        'Customer User Login' => 'Kundebrugers login',
        'Time1' => '',
        'Time2' => '',
        'Time3' => '',
        'Time4' => '',
        'Time5' => '',
        'Time6' => '',
        'Created in Queue' => 'Oprettet i k',
        'Lock state' => '',
        'Watcher' => '',
        'Article Create Time (before/after)' => '',
        'Article Create Time (between)' => '',
        'Ticket Create Time (before/after)' => '',
        'Ticket Create Time (between)' => '',
        'Ticket Change Time (before/after)' => '',
        'Ticket Change Time (between)' => '',
        'Ticket Close Time (before/after)' => '',
        'Ticket Close Time (between)' => '',
        'Archive Search' => '',
        'Run Search' => '',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => '',
        'Save filter settings as default' => 'Gem filter som standard',
        'Ticket Information' => '',
        'Linked Objects' => '',
        'Article(s)' => '',
        'Change Queue' => '',
        'Article Filter' => '',
        'Add Filter' => '',
        'Set' => 'Indstil',
        'Reset Filter' => '',
        'Show one article' => '',
        'Show all articles' => '',
        'Unread articles' => '',
        'No.' => '',
        'Unread Article!' => '',
        'Incoming message' => '',
        'Outgoing message' => '',
        'Internal message' => '',
        'Resize' => '',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => '',
        'Load blocked content.' => '',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => 'Tilbagesporing',

        # Template: CustomerFooter
        'Powered by' => 'Drevet af',
        'One or more errors occurred!' => '',
        'Close this dialog' => '',
        'Could not open popup window. Please disable any popup blockers for this application.' => '',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => 'Login',
        'User name' => '',
        'Your user name' => '',
        'Your password' => '',
        'Forgot password?' => '',
        'Log In' => '',
        'Not yet registered?' => '',
        'Sign up now' => '',
        'Request new password' => 'Anmod om ny adgangskode',
        'Your User Name' => '',
        'A new password will be sent to your email address.' => '',
        'Create Account' => 'Opret konto',
        'Please fill out this form to recieve login credentials.' => '',
        'How we should address you' => '',
        'Your First Name' => '',
        'Please supply a first name' => '',
        'Your Last Name' => '',
        'Please supply a last name' => '',
        'The User Name you wish to have' => '',
        'Please supply a' => '',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => '',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => '',

        # Template: CustomerTicketOverView
        'You have not created a ticket yet.' => '',
        'You as the customer have the ability to let us support staff people jump around as you wish because it\'s all about you.' => '',
        'We stop eating if you wish us to do.' => '',
        'Your way to communicate with us is this thing called \'ticket\'.' => '',
        'Please command us.' => '',
        'Create your first Ticket' => '',

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Profile' => 'Profil',
        'e. g. 10*5155 or 105658*' => '',
        'Customer ID' => '',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => '',
        'Recipient' => 'Modtaget',
        'Carbon Copy' => '',
        'Time restrictions' => '',
        'Only tickets created' => '',
        'Only tickets created between' => '',
        'Search-Profile as Template?' => '',
        'Save as Template?' => '',
        'Template Name' => '',
        'Output to' => '',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => 'af',
        'Page' => 'Side',
        'Search Results for' => '',

        # Template: CustomerTicketZoom
        'Loading' => '',
        'Reply' => '',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => '',
        'Previous' => '',
        'Sunday' => '',
        'Monday' => '',
        'Tuesday' => '',
        'Wednesday' => '',
        'Thursday' => '',
        'Friday' => '',
        'Saturday' => '',
        'Su' => '',
        'Mo' => '',
        'Tu' => '',
        'We' => '',
        'Th' => '',
        'Fr' => '',
        'Sa' => '',
        'Open date selection' => '',

        # Template: Error
        'Oops! An Error occurred.' => '',
        'Error Message' => '',
        'You can' => '',
        'Send a bugreport' => '',
        'go back to the previous page' => '',
        'Error Details' => '',

        # Template: Footer
        'Top of page' => '',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => '',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => '',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => '',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => '',
        'Database Settings' => '',
        'General Specifications and Mail Settings' => '',
        'Welcome to %s' => 'Velkommen til %s',
        'Web site' => '',
        'Database check successful.' => '',
        'Mail check successful.' => '',
        'Error in the mail settings. Please correct and try again.' => '',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => '',
        'Outbound mail type' => '',
        'Select outbound mail type.' => '',
        'Outbound mail port' => '',
        'Select outbound mail port.' => '',
        'SMTP host' => '',
        'SMTP host.' => '',
        'SMTP authentication' => '',
        'Does your SMTP host need authentication?' => '',
        'SMTP auth user' => '',
        'Username for SMTP auth.' => '',
        'SMTP auth password' => '',
        'Password for SMTP auth.' => '',
        'Configure Inbound Mail' => '',
        'Inbound mail type' => '',
        'Select inbound mail type.' => '',
        'Inbound mail host' => '',
        'Inbound mail host.' => '',
        'Inbound mail user' => '',
        'User for inbound mail.' => '',
        'Inbound mail password' => '',
        'Password for inbound mail.' => '',
        'Result of mail configuration check' => '',
        'Check mail configuration' => '',
        'Skip this step' => '',

        # Template: InstallerDBResult
        'False' => '',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'Hvis du har sat et root kodeord til din database skal du taste det her. Hvis ikke, lad feltet vre tomt. Af sikkerheds rsager anbefaler vi at stte et root kodeord. For mere information henviser vi til documentationen for din database.',
        'Currently only MySQL is supported in the web installer.' => '',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => '',
        'Database-User' => 'Database-bruger',
        'New' => 'Ny',
        'A new database user with limited rights will be created for this OTRS system.' => '',
        'default \'hot\'' => 'standard \'hot\'',
        'DB--- host' => '',
        'Database' => 'Database',
        'Check database settings' => '',
        'Result of database check' => '',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'For at kunne anvende OTRS, er du ndt til at indtaste flgende linje i din kommandolinje (Terminal/Shell) som root.',
        'Restart your webserver' => 'Genstart webserveren',
        'After doing so your OTRS is up and running.' => 'Nr det er gjort, er din OTRS sat i gang og fungerer.',
        'Start page' => 'Startside',
        'Your OTRS Team' => 'Dit OTRS Team',

        # Template: InstallerLicense
        'Accept license' => 'Accepter licens',
        'Don\'t accept license' => 'Accepter ikke icensen',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'System-ID',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => '',
        'System FQDN' => 'Systemets FQDN',
        'Fully qualified domain name of your system.' => '',
        'AdminEmail' => 'AdminE-mail',
        'Email address of the system administrator.' => '',
        'Organization' => 'Organisation',
        'Log' => 'Log',
        'LogModule' => 'LogModul',
        'Log backend to use.' => '',
        'LogFile' => '',
        'Log file location is only needed for File-LogModule!' => '',
        'Webfrontend' => 'Webfrontend',
        'Default language' => '',
        'Default language.' => '',
        'CheckMXRecord' => 'KontrollerMXRecord',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => '',

        # Template: LinkObject
        'Object#' => '',
        'Add links' => '',
        'Delete links' => '',

        # Template: Login
        'JavaScript Not Available' => '',
        'Browser Warning' => '',
        'The browser you are using is too old.' => '',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => '',
        'Please see the documentation or ask your admin for further information.' => '',
        'Lost your password?' => 'Mistet din adgangskode?',
        'Request New Password' => '',
        'Back to login' => '',

        # Template: Motd
        'Message of the Day' => '',

        # Template: NoPermission
        'Insufficient Rights' => '',
        'Back to the previous page' => '',

        # Template: Notify

        # Template: Pagination
        'Show first page' => '',
        'Show previous pages' => '',
        'Show page %s' => '',
        'Show next pages' => '',
        'Show last page' => '',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'udskrevet af',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'OTRS prveside',
        'Welcome %s' => 'Velkommen %s',
        'Counter' => 'Tller',

        # Template: Warning
        'Go back to the previous page' => '',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => '',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => '',
        'Activates lost password feature for agents, in the agent interface.' => '',
        'Activates lost password feature for customers.' => '',
        'Activates support for customer groups.' => '',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => '',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => '',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => '',
        'Activates time accounting.' => '',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => '',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Agent Notifications' => '',
        'Agent interface article notification module to check PGP.' => '',
        'Agent interface article notification module to check S/MIME.' => '',
        'Agent interface module to access fulltext search via nav bar.' => '',
        'Agent interface module to access search profiles via nav bar.' => '',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => '',
        'Agents <-> Roles' => '',
        'Allows adding notes in the close ticket screen of the agent interface.' => '',
        'Allows adding notes in the ticket free text screen of the agent interface.' => '',
        'Allows adding notes in the ticket note screen of the agent interface.' => '',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => '',
        'Allows agents to exchange the axis of a stat if they generate one.' => '',
        'Allows agents to generate individual-related stats.' => '',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attribrutes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Attachments <-> Responses' => 'Vedhftede filer <-> Responssvar',
        'Auto Responses <-> Queues' => '',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => '',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => '',
        'Company Tickets' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => '',
        'Create and manage Service Level Agreements (SLAs).' => '',
        'Create and manage agents.' => '',
        'Create and manage attachments.' => '',
        'Create and manage companies.' => '',
        'Create and manage customers.' => '',
        'Create and manage event based notifications.' => '',
        'Create and manage groups.' => '',
        'Create and manage notifications that are sent to agents.' => '',
        'Create and manage queues.' => '',
        'Create and manage response templates.' => '',
        'Create and manage responses that are automatically sent.' => '',
        'Create and manage roles.' => '',
        'Create and manage salutations.' => '',
        'Create and manage services.' => '',
        'Create and manage signatures.' => '',
        'Create and manage ticket priorities.' => '',
        'Create and manage ticket states.' => '',
        'Create and manage ticket types.' => '',
        'Create new email ticket and send this out (outbound)' => '',
        'Create new phone ticket (inbound)' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => '',
        'Customers <-> Groups' => '',
        'Customers <-> Services' => '',
        'Data used to export the search result in CSV format.' => '',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => '',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => '',
        'Default ticket ID used by the system in the agent interface.' => '',
        'Default ticket ID used by the system in the customer interface.' => '',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => '',
        'Defines a default list of words, that are ignored by the spell checker.' => '',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => '',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => '',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 2 for articles to add a new article attribute.' => '',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 3 for articles to add a new article attribute.' => '',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => '',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free time key field number 1 for tickets.' => '',
        'Defines the free time key field number 2 for tickets.' => '',
        'Defines the free time key field number 3 for tickets.' => '',
        'Defines the free time key field number 4 for tickets.' => '',
        'Defines the free time key field number 5 for tickets.' => '',
        'Defines the free time key field number 6 for tickets.' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repositoriy, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => '',
        'Defines the name of the calendar number 2.' => '',
        'Defines the name of the calendar number 3.' => '',
        'Defines the name of the calendar number 4.' => '',
        'Defines the name of the calendar number 5.' => '',
        'Defines the name of the calendar number 6.' => '',
        'Defines the name of the calendar number 7.' => '',
        'Defines the name of the calendar number 8.' => '',
        'Defines the name of the calendar number 9.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => '',
        'Defines whether the free time field number 2 is optional or not.' => '',
        'Defines whether the free time field number 3 is optional or not.' => '',
        'Defines whether the free time field number 4 is optional or not.' => '',
        'Defines whether the free time field number 5 is optional or not.' => '',
        'Defines whether the free time field number 6 is optional or not.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'E-mailadresser',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => '',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => '',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => '',
        'Execute SQL statements.' => '',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => '',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => '',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => '',
        'GenericAgent' => 'Generel konsulent',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove tailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => '',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => '',
        'Link agents to roles.' => '',
        'Link attachments to responses templates.' => '',
        'Link customers to groups.' => '',
        'Link customers to services.' => '',
        'Link queues to auto responses.' => '',
        'Link responses to queues.' => '',
        'Link roles to groups.' => '',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => '',
        'Manage POP3 or IMAP accounts to fetch email from.' => '',
        'Manage S/MIME certificates for email encryption.' => '',
        'Manage existing sessions.' => '',
        'Manage periodic tasks.' => '',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Max. displayed tickets' => '',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to genetare accounted time ticket statistics.' => '',
        'Module to genetare ticket solution and response time statistics.' => '',
        'Module to genetare ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => '',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New email ticket' => '',
        'New phone ticket' => '',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => '',
        'Number of displayed tickets' => '',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => '',
        'Overview of all open Tickets.' => '',
        'PGP Key Upload' => '',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'PostMaster Filters' => '',
        'PostMaster Mail Accounts' => '',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => '',
        'QueueView Refresh Time' => '',
        'Refresh interval' => '',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => '',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => 'Roller <-> Grupper',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => '',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Search Ticket' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Select your frontend Theme.' => 'Vlg dit tema til frontend.',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => 'Send mig en besked, hvis en kunde sender en opflgning, og jeg er denne sags indehaver.',
        'Send notifications to users.' => '',
        'Send ticket follow up notifications' => '',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => '',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of lines that are displayed in the preview of messages (e.g. for tickets in the QueueView).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Skin' => '',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => '',
        'Status view' => '',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => '',
        'Tickets' => 'Sager',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => '',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => '',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => '',
        'View system log messages.' => '',
        'Wear this frontend skin' => '',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => '',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        ' (minutes)' => ' (minutter)',
        ' Param 1 value' => 'Parameter 1 vrdi',
        ' Param 2 value' => 'Parameter 2 vrdi',
        ' Param 3 value' => 'Parameter 3 vrdi',
        ' Param 4 value' => 'Parameter 4 vrdi',
        ' Param 5 value' => 'Parameter 5 vrdi',
        ' Param 6 value' => 'Parameter 6 vrdi',
        '%s Tickets affected! Do you really want to use this job?' => '%s sager bliver berrt! nsker du stadig at kre dette job.',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kontrollerer MX-records af anvendte e-mailadresser ved at udforme et svar. Anvend ikke KontrollerMXRecord, hvis OTRS-maskinen befinder sig bag en opkaldslinje $!)',
        '(Email of the system admin)' => '(Systemadministrators e-mail)',
        '(Full qualified domain name of your system)' => '(Dit systems FQDN(Fully qualified domain name)) ',
        '(Logfile just needed for File-LogModule!)' => '(Logfilen behves kun til Fil-LogModul!)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '(Bemlrk: Det afhnger af din installation hvor mange dynamiske objekter du kan bruge)',
        '(Note: Useful for big databases and low performance server)' => '(Bemrk: Brugbart for store databse og lavydelse servere)',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Systemets identificering. Hvert sagnummer og hver http-sessions ID starter med dette tal) ',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Sagidentifikator. Nogle personer nsker at indstille dette til f.eks. \Ticket#\, \Call#\ eller \MyTicket#\)',
        '(Used default language)' => '(Anvendt standardsprog)',
        '(Used log backend)' => '(Anvendt log til backend)',
        '(Used ticket number format)' => '(Anvendt sagsnummerformat)',
        'A article should have a title!' => 'En artikel skal have en titel!',
        'A message must be spell checked!' => 'En meddelelse skal stavekontrolleres!',
        'A message should have a To: recipient!' => 'En meddelelse skal have en Til: modtager!',
        'A message should have a body!' => 'En meddelelse skal have en tekst!',
        'A message should have a subject!' => 'En meddelelse skal have et emne!',
        'A required field is:' => 'Et krvet felt er:',
        'A web calendar' => 'En webkalender',
        'A web file manager' => 'En webfilmanager',
        'A web mail client' => 'En webmailklient',
        'Absolut Period' => 'Absolut periode',
        'Account Type' => 'Konto type',
        'Add Customer User' => 'Tilfj Kunde Bruger',
        'Add System Address' => 'Tilfj system adresse',
        'Add User' => 'Tilfj bruger',
        'Add a new Agent.' => 'Tilfj en ny Agent',
        'Add a new Customer Company.' => 'Tilfj et nyt Kunde firma',
        'Add a new Group.' => 'Tilfj en ny Gruppe',
        'Add a new Notification.' => 'Tilfj en ny besked',
        'Add a new Priority.' => 'Tilfj ny prioritet',
        'Add a new Role.' => 'Tilfj en ny rolle',
        'Add a new SLA.' => 'Tilfj en ny SLA',
        'Add a new Salutation.' => 'Tilfj en ny hilsen',
        'Add a new Service.' => 'Tilfj en ny service',
        'Add a new Signature.' => 'Tilfj ny underskrift',
        'Add a new State.' => 'Tilfj en ny tilstand',
        'Add a new System Address.' => 'Tilfj en ny system adresse',
        'Add a new Type.' => 'Tilfj en ny type',
        'Add new attachment' => 'Tilfj ny vedhftning',
        'Add note to ticket' => 'Tilfj bemrkning til sag',
        'Added User "%s"' => 'Tilfjet til bruger "%s"',
        'Admin-Area' => 'Admin-omrde',
        'Admin-Email' => 'Admin-E-mail',
        'Admin-Password' => 'Admin-adgangskode',
        'Admin-User' => 'Admin-bruger',
        'Advisory' => 'Bekendtgrelse',
        'Agent Mailbox' => 'Konsulentmailboks',
        'Agent Preferences' => 'Konsulentindstillinger',
        'Agent based' => 'Konsulent baseret',
        'Agent-Area' => 'Konsulent-omrde',
        'All Agent variables.' => 'Alle konsulent variabler',
        'All Agents' => 'Alle konsulenter',
        'All Customer variables like defined in config option CustomerUser.' => 'Alle kundevariabler som definerede i konfigurationsmuligheden KundeBruger.',
        'All customer tickets.' => 'Alle kundesager.',
        'All email addresses get excluded on replaying on composing an email.' => 'Alle email adresser ekskluderes ved gentagelse af oprettelse af ny email.',
        'All email addresses get excluded on replaying on composing and email.' => 'Alle email adresser er ekskluderet nr du besvarer eller laver en ny email.',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Alle indkommende e-mail med denne "E-mail" (Til:) sendes til den valgte k!',
        'All messages' => 'Alle meddelelser',
        'All new tickets!' => 'Alle nye sager',
        'All tickets' => 'Alle sager',
        'All tickets where the reminder date has reached!' => 'Alle sager som har net en pmindelse',
        'All tickets which are escalated!' => 'Alle sager som er eskaleret',
        'Allocate %s to' => 'Tildel %s til',
        'Allocate CustomerUser to service' => 'Vlg kunde bruger til service',
        'Allocate services to CustomerUser' => 'Vlg services til kunde bruger',
        'Answer' => 'Svar',
        'Artefact' => 'Artefakt',
        'Article Create Times' => 'Artikel oprettet',
        'Article Type' => 'Artikel type',
        'Article created' => 'Artikel oprettet',
        'Article created between' => 'Artikel oprettet mellem',
        'Article filter settings' => 'Indstillinger for artikel filter',
        'ArticleID' => 'Artikel-ID',
        'Attach' => 'Vedhft',
        'Attribute' => 'Atribut',
        'Auto Response From' => 'Autosvar fra',
        'Auto Responses <-> Queue' => 'Autosvar <-> K',
        'Bounce ticket' => 'Sag retur til afsender',
        'Can\'t update password, invalid characters!' => 'Kan ikke opdatere adgangskode, ugyldige tegn!',
        'Can\'t update password, must be at least %s characters!' => 'Kan ikke opdatere adgangskode, der skal vre mindst %s tegn!',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Kan ikke opdatere adgangskode, der skal vre 2 sm og 2 store bogstaver!',
        'Can\'t update password, needs at least 1 digit!' => 'Kan ikke opdatere adgangskode, mindst 1 tal mangler!',
        'Can\'t update password, needs at least 2 characters!' => 'Kan ikke opdatere adgangskode, mindst 2 tegn mangler!',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Kan ikke opdatere adgangskode, adgangskoderne er ikke ens! Prv igen!',
        'Category Tree' => 'Kategoritr',
        'Change %s Relations for' => 'Skift %s relationer for',
        'Change %s settings' => 'Skift %s indstillinger',
        'Change Times' => 'Skift tider',
        'Change free text of ticket' => 'Skift sagens fritekst',
        'Change owner of ticket' => 'Skift konsulent',
        'Change priority of ticket' => 'Skift sagsprioritering',
        'Change responsible of ticket' => 'Skift Ansvarlig for sag',
        'Change user <-> group settings' => 'Skift bruger <-> gruppeindstillinger',
        'ChangeLog' => 'ChangeLog',
        'Child-Object' => 'Barn-Objekt',
        'Clear From' => 'Ryd fra',
        'Clear To' => 'Ryd til',
        'Click here to report a bug!' => 'Klik her for at rapportere en fejl!',
        'Close Times' => 'Lukke tid',
        'Close ticket' => 'Luk sag',
        'Close type' => 'Luk type',
        'Close!' => 'Luk!',
        'Collapse View' => 'Indskrnk visning',
        'Comment (internal)' => 'Kommentar (intern)',
        'CompanyTickets' => 'Virksomhedssager',
        'Compose Answer' => 'Formuler svar',
        'Compose Email' => 'Formuler e-mail',
        'Compose Follow up' => 'Formuler opflgning',
        'Config Options' => 'Konfiguationsmuligheder',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Konfigurations muligheder (f.eks. &lt;OTRS_CONFIG_HttpType&gt;)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Konfigurationsmuligheder (f.eks. <OTRS_CONFIG_HttpType>)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Konfigurations muligheder (f.eks. <OTRS_CONFIG_HttpType>).',
        'Contact customer' => 'Kontakt kunde',
        'Create Times' => 'Opret tider',
        'Create new Phone Ticket' => 'Opret ny telefonsag',
        'Create new database' => 'Opret ny database',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Opret nye grupper til at hndtere adgangstilladelser for konsulentens forskellige grupper (f.eks. indkbs-, support- og salgsafdeling ...).',
        'CreateTicket' => 'Opret sag',
        'Customer Move Notify' => 'Kundebesked ved flytning',
        'Customer Owner Notify' => 'Besked til kundeejer',
        'Customer State Notify' => 'Besked om kunde status',
        'Customer User' => 'Kundebruger',
        'Customer User Management' => 'Styring af kundebruger',
        'Customer Users' => 'Kundebrugere',
        'Customer Users <-> Groups' => 'Kundebrugere <-> Grupper',
        'Customer Users <-> Groups Management' => 'Kundebrugere <-> Gruppestyring',
        'Customer Users <-> Services Management' => 'Kunde Bruger <-> Service Administration',
        'Customer history' => 'Kundehistorik',
        'Customer history search' => 'Kunde historik sgning',
        'Customer history search (e. g. "ID342425").' => 'Kundehistoriksgning (f.eks. "ID342425").',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'Kundebrugeren er ndvendig for at have en kundehistorik og for at logge ind via kundepanelerne.',
        'CustomerUser' => 'KundeBruger',
        'D' => 'N',
        'DB Admin Password' => 'DB-admins adgangskode',
        'DB Admin User' => 'DB-admin-bruger',
        'DB Host' => 'DB vrtscomputer',
        'DB Type' => 'DB type',
        'DB connect host' => 'DB tilsluttes vrtscomputer',
        'Default' => 'Standard',
        'Default Charset' => 'Standardtegnst',
        'Default Language' => 'Standardsprog',
        'Delete old database' => 'Slet gammel database',
        'Detail' => 'Oplysning',
        'Diff' => 'Diff',
        'Discard all changes and return to the compose screen' => 'Kassr alle ndringer og vend tilbage til skriveskrmen',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Send eller filtrer indkommende e-mail baseret p hver e-mails X-header! RegExp er ogs mulig.',
        'Do you really want to delete this Object?' => 'Er du sikker p, du nsker at slette dette objekt?',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'nsker du virkeleg at geninstallere denne pakke (Alle manuelle ndringer vil blive slettet)?',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Glem ikke at tilfje en ny bruger til grupper og/eller roller!',
        'Don\'t forget to add a new user to groups!' => 'Glem ikke at tilfje en ny bruger til grupper!',
        'Download Settings' => 'Download indstillinger',
        'Download all system config changes.' => 'Download alle systemkonfigurations ndringer.',
        'Drop Database' => 'Udelad database',
        'Dynamic-Object' => 'Dynamisk-Objekt',
        'Edit Article' => 'Ret artikkel',
        'Edit default services.' => 'Ret standard services.',
        'Email based' => 'Email baseret',
        'Escaladed Tickets' => 'Eskalerede sager',
        'Escalation' => 'Eskalering',
        'Escalation - First Response Time' => 'Eskalation - Frste svar tid',
        'Escalation - Solution Time' => 'Eskalation - Lsnings tid',
        'Escalation - Update Time' => 'Eskalation - Opdaterings tid',
        'Escalation Times' => 'Eskalationstider',
        'Escalation time' => 'Eskaleringstid',
        'Event is required!' => 'Hndelse er pkrvet',
        'Expand View' => 'Udvid visning',
        'Explanation' => 'Forklaring',
        'Export Config' => 'Eksporter konfiguration',
        'FileManager' => 'FilManager',
        'Filelist' => 'Filliste',
        'Filtername' => 'Filternavn',
        'Follow up' => 'Opflgning',
        'Follow up notification' => 'Besked om opflgning',
        'For very complex stats it is possible to include a hardcoded file.' => 'For meget komplekse statistiker er det muligt at inkludere en hardcoded fil.',
        'Form' => 'Form',
        'Frontend' => 'Frontend',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Fritekstsgning i artikel (f.eks. "Mar*in" eller "Baue*")',
        'Go' => 'G',
        'Group Ro' => 'Gruppe Ro',
        'Group based' => 'Gruppebaseret',
        'Group selection' => 'Gruppevalg',
        'Hash' => 'Hash',
        'Have a lot of fun!' => 'Hav det rigtig sjovt!',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Her kan du vlge vrdi serierne. Du har muligheden for at vlge en eller to elementer. Derefter kan du vlge attributter for elementerne. Hvert element vil blive vist som en enkelt vrdi sere. Hvis du ikke har valgt nogle attributter, vil alle attributter for elementet blive brugt til at generere stat. Ligesom en ny attribut vil blive tilfjet siden sidste konfiguration.',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Her kan du definere X-aksen. Du kan vlge et element via knapperne. Hvis du ikke vlger s vil alle egenskaberne ved elementet blive benyttet nr du laver statistik. Svel som nye egenskaber der er tilfjet siden sidste konfiguration.',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Her kan du definere X-aksen. Du kan vlge et element med radio button. Derefter skal du vlge et eller flere attributter til elementet. Hvis du ikke vlger nogle attributter, vil alle attributter blive brugt, ligesom et nyt attribut vil blive gemt, siden sidste konfiguration.',
        'Here you can insert a description of the stat.' => 'Her kan du indtaste en beskrivelse af stat.',
        'Here you can select the dynamic object you want to use.' => 'Her kan du vlge det dynamiske objekt du vil bruge',
        'Home' => 'Hjem',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'Hvis sikker tilstand ikker er slet til, s gr det via SysConfig, da programmet allerede krer.',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Hvis en hardcoded fil er tilgngelig, vil denne attribute vre vist, og du kan vlge den.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Er en sag lukket, og kunden sender en opflgning, lses sagen for den gamle konsulent.',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Besvares en sag ikke inden for dette tidsrum, vil kun denne sag blive vist.',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Hvis en konsulent lser en sag, og vedkommende ikke sender et svar inden for dette tidsrum, lses sagen automatisk op. Derved kan alle andre konsulenter se sagen.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Er intet valgt, er der ingen rettigheder i denne gruppe (der er ingen tilgngelige sag til brugeren).',
        'If you need the sum of every column select yes.' => 'Hvis du skal bruge summe af hver kolonne vlg da ja',
        'If you need the sum of every row select yes' => 'Hvis du skal bruge summen af hver rkke, vlg da ja',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Anvender du RegExp, kan du ogs bruge den matchede vrdi i () som [***] i \'Set\'.',
        'If you use a graph as output format you have to select at least one graph size.' => 'iHvis du bruger en graf som output format skal du vlge mindst en graf strrelse',
        'If you want to account time, please provide Subject and Text!' => 'Hvis du nsker at tlle tid, s indst Emne og Tekst',
        'Image' => 'Billede',
        'Important' => 'Vigtigt',
        'In this form you can select the basic specifications.' => 'I denne formular kan du vlge de grundlggende specifikationer.',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Du kan p denne mde direkte redigere den nglering, der er konfigureret i Kernel/Config.pm.',
        'Incident' => 'Hndelse',
        'Information about the Stat' => 'Information om Stat',
        'Insert of the common specifications' => 'Indst flles specifikationer',
        'Is Job Valid' => 'Er jobbet gyldigt',
        'Is Job Valid?' => 'Er jobbet gyldigt?',
        'It\'s useful for ASP solutions.' => 'Det er nyttigt for ASP-lsninger.',
        'It\'s useful for a lot of users and groups.' => 'Det er nyttigt for mange brugere og grupper.',
        'Job-List' => 'Job-Liste',
        'Keyword' => 'Sgeord',
        'Keywords' => 'Sgeord',
        'Last update' => 'Sidste opdatering',
        'Link to Parent' => 'Link til forldre',
        'Load Settings' => 'Indls indstillinger',
        'Logfile' => 'Logfil',
        'Logfile too large, you need to reset it!' => 'Log fil er fort stor, du skal nulstille den',
        'Login failed! Your username or password was entered incorrectly.' => 'Login mislykkedes! Brugernavnet eller adgangskoden blev forkert indtastet.',
        'Lookup' => 'Find',
        'Mail Management' => 'Mailstyring',
        'Mailbox' => 'Mailboks',
        'Match' => 'Match',
        'Message for new Owner' => 'Meddelelse til ny konsulent',
        'Message sent to' => 'Meddelelse sendt til',
        'Misc' => 'Diverse',
        'Modified' => 'Modificeret',
        'Modules' => 'Moduler',
        'Move notification' => 'Besked om flytning',
        'Multiple selection of the output format.' => 'Flere valg af output format',
        'MyTickets' => 'Mine sager',
        'Name is required!' => 'Navn er pkrvet!',
        'New Agent' => 'Ny konsulent',
        'New Customer' => 'Ny kunde',
        'New Group' => 'Ny gruppe',
        'New Group Ro' => 'Ny grupperolle',
        'New Password' => 'Nyt kodeord',
        'New Priority' => 'Ny prioritering',
        'New SLA' => 'Ny SLA',
        'New Service' => 'Ny service',
        'New State' => 'Ny status',
        'New Ticket Lock' => 'Ny sagls',
        'New Title' => 'Ny titel',
        'New Type' => 'Ny type',
        'New account created. Sent Login-Account to %s.' => 'Ny konto er oprettet. Login informationer er sendt til %s.',
        'New messages' => 'Nye meddelelser',
        'New password again' => 'Ny adgangskode igen',
        'Next Week' => 'Nste uge',
        'No * possible!' => 'Ingen * er mulig!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'Der var ingen pakker for the valgte Framework i Online Repositoryet, der var dog pakker til andre Frameworks!',
        'No Packages or no new Packages in selected Online Repository!' => 'Der var ingen pakker, eller ingen nye pakker i det valgte Online Repository.',
        'No Permission' => 'Ingen Rettighed',
        'No change time settings.' => 'Ingen skift tid indstillinger',
        'No matches found' => 'Ingen resultater blev fundet',
        'No means, send agent and customer notifications on changes.' => 'Nej betyder, send meddelser til konsulent eller Kunde ved ndringer.',
        'No time settings.' => 'Ingen tidsindstillinger.',
        'Note' => 'Bemrkning',
        'Note Text' => 'Bemrkningstekst',
        'Notification (Customer)' => 'Meddelse (Kunde)',
        'Notification (Event)' => 'Besked (Event)',
        'Notifications' => 'Beskeder',
        'OTRS DB Name' => 'OTRS DB-navn',
        'OTRS DB Password' => 'OTRS DB-adgangskode',
        'OTRS DB User' => 'OTRS DB-bruger',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS sender en e-mail med besked til kunden, hvis sagen er flyttet.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS sender en e-mail med besked til kunden, hvis sagen har fet en anden indehaver.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS sender en e-mail med besked til kunden, hvis sagens tilstand er ndret.',
        'Of couse this feature will take some system performance it self!' => 'Selvflgelig vil denne mulighed tage noget af system krften.',
        'Only for ArticleCreate Event.' => 'Kun for hndelsen NyArtikel',
        'Open Tickets' => 'bne sager',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Muligheder for den nuvrende kundes data (f.eks. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Valgmuligheder for de aktuelle kundebrugerdata (f.eks. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Muligheder for den nuvrendes kundes data (f.eks. <OTRS_CUSTOMER_DATA_UserFirstname>).',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Muligheder for den nuvrende bruger der har udfrt denne handling (f.eks. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Valgmuligheder for den aktuelle bruger, som anmodede om denne handling (f.eks. <OTRS_CURRENT_UserFirstname>)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Muligheder for bruger der har udfrt denne handling (f.eks. <OTRS_CURRENT_UserFirstname>).',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Muligheder for sags data (f.eks. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Valgmuligheder for sagens data (f.eks. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Valgmuligheder for de aktuelle sagsdata (f.eks. lt;OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Valgmuligheder for sagens data (f.eks. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Muligheder for sags data (f.eks. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Order' => 'Ordre',
        'Other Options' => 'Andre valgmuligheder',
        'Out Of Office' => 'Ikke-p-kontoret',
        'POP3 Account Management' => 'POP3 kontostyring',
        'Package' => 'Pakke',
        'Package not correctly deployed, you need to deploy it again!' => 'Pakken blev ikke korrekt installeret, den skal installeres igen!',
        'Param 1' => 'Param 1',
        'Param 1 key' => 'Parameter 1 ngle',
        'Param 2' => 'Param 2',
        'Param 2 key' => 'Paramater 2 ngle',
        'Param 3' => 'Param 3',
        'Param 3 key' => 'Parameter 3 ngle',
        'Param 4' => 'Param 4',
        'Param 4 key' => 'Parameter 4 ngle',
        'Param 5' => 'Param 5',
        'Param 5 key' => 'Parameter 5 ngle',
        'Param 6' => 'Param 6',
        'Param 6 key' => 'Parameter 6 ngle',
        'Parent-Object' => 'Forldre-Objekt',
        'Password is already in use! Please use an other password!' => 'Adgangskoden er allerede i brug! Brug venligst en anden adgangskode!',
        'Password is already used! Please use an other password!' => 'Adgangskoden er allerede brugt! Brug venligst en anden adgangskode!',
        'Passwords doesn\'t match! Please try it again!' => 'Adgangskoderne er ikke ens! Prv igen!',
        'Pending Times' => 'Afventende tider',
        'Pending messages' => 'Afventer meddelelser',
        'Pending type' => 'Afventer type',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Rettigheds indstillinger, Du kan vlge en eller flere grupper, for at gre den konfigurerede stat synlig for forskellige agenter.',
        'Permissions to change the ticket owner in this group/queue.' => 'Tilladelser til at ndre ansvarlig konsulent i denne gruppe/k.',
        'PhoneView' => 'TelefonVisning',
        'Please contact your admin' => 'Kontakt din administrator',
        'Port' => 'Port',
        'Prio' => 'Prio',
        'Problem' => 'Problem',
        'Queue <-> Auto Responses Management' => 'K <-> Styring af autosvar',
        'Queue ID' => 'K-ID',
        'Queue Management' => 'Kstyring',
        'QueueView' => 'KVisning',
        'Realname' => 'RigtigtNavn',
        'Rebuild' => 'Genopbyg',
        'Recipients' => 'Modtagere',
        'Refresh' => 'Opdater',
        'Reminder' => 'Pmindelse',
        'Reminder messages' => 'Pmindelsesmeddelelser',
        'Required Field' => 'Pkrvede felter',
        'Response Management' => 'Svar Styring',
        'Responses <-> Attachments Management' => 'Svar <-> Styring af vedhftede filer',
        'Responses <-> Queue' => 'Svar <-> K',
        'Responses <-> Queue Management' => 'Svar <-> Kstyring',
        'Return to the compose screen' => 'Vend tilbage til skriveskrmen',
        'Role' => 'Rolle',
        'Roles <-> Groups Management' => 'Roller <-> Gruppestyring',
        'Roles <-> Users' => 'Roller <-> Brugere',
        'Roles <-> Users Management' => 'Roller <-> Brugerstyring',
        'SMIME Management' => 'SMIME-styring',
        'Save Job as?' => 'Gem et job som?',
        'Save Search-Profile as Template?' => 'Gem sgeprofil som skabelon?',
        'Schedule' => 'Tidsplan',
        'Search Result' => 'Sgeresultat',
        'Search for' => 'Sg efter',
        'Secure Mode need to be enabled!' => 'Sikker tilstand skal vre slet til!',
        'Select Box' => 'Vlg felt',
        'Select Box Result' => 'Vlg feltresultat',
        'Select Source (for add)' => 'Vlg kilde (til tilfjelse)',
        'Select the customeruser:service relations.' => 'Udvlg Kundebruger service relationer.',
        'Select the element, which will be used at the X-axis' => 'Vlg det element der skal bruges ved X-aksen',
        'Select the restrictions to characterise the stat' => 'Vlg begrnsningerne til at karakterisere stat',
        'Select the role:user relations.' => 'Vlg relationer mellem rollen:brugeren.',
        'Select the user:group permissions.' => 'Vlg rettigheder til brugeren:gruppen.',
        'Select your QueueView refresh time.' => 'Vlg genindlsningstid til kvisningen.',
        'Select your default spelling dictionary.' => 'Vlg din standardordbog til stavekontrol.',
        'Select your frontend Charset.' => 'Vlg dit tegnst til frontend.',
        'Select your frontend QueueView.' => 'Vlg din kvisning til frontend.',
        'Select your frontend language.' => 'Vlg dit sprog til frontend.',
        'Select your out of office time.' => 'Vlg din Ikke-p-kontoret tid',
        'Select your screen after creating a new ticket.' => 'Vlg din skrm, efter ioprettelse af ny sag.',
        'Selection needed' => 'Valg pkrvet',
        'Send Notification' => 'Send Meddelse',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'Send mig beskeder om en overvget sag, p samme mde som konsulenten',
        'Send no notifications' => 'Send ingen meddelser',
        'Sent new password to: %s' => 'Nyt kodeord er sendt til: %s',
        'Sent password token to: %s' => 'Kodeords kendetegn er sendt til: %s',
        'Sessions' => 'Sessioner',
        'Set customer user and customer id of a ticket' => 'Indstil en sags kundebruger og kunde-ID',
        'Set new SLA' => 'Angiv ny SLA',
        'Show' => 'Vis',
        'Site' => 'Websted',
        'Solution' => 'Lsning',
        'Sort by' => 'Sorter efter',
        'Source' => 'Kilde',
        'Spell Check' => 'Stavekontrol',
        'Split' => 'Del',
        'State Type' => 'Tilstandstype',
        'Static-File' => 'Statisk-Fil',
        'Stats-Area' => 'Statistikomrde',
        'Sub-Queue of' => 'Underk af',
        'Sub-Service of' => 'Under service af',
        'Subscribe' => 'Tilmeld',
        'Symptom' => 'Symptom',
        'System History' => 'Systemhistorik',
        'System State Management' => 'Systemtilstandsstyring',
        'System Status' => 'System status',
        'Systemaddress' => 'Systemadresse',
        'Termin1' => 'Termin1',
        'The field is required.' => 'Dette felt er pkrvet',
        'The message being composed has been closed.  Exiting.' => 'Den meddelelse, der er ved at blive formuleret, er blevet lukket.  Afslutter.',
        'They can be administrered through the configuration setting "CustomerGroupAlwaysGroups".' => 'De kan administreres gennem konfigurations indstillingen "CustomerGroupAlwaysGroups".',
        'This account exists.' => 'Denne konto eksisterer allerede.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Dette er brugbart hvis du ikke nsker at nogen kan se resultatet afen stat der ikke er konfigureret.',
        'This values are read only.' => 'Disse vrdier kan kun lses.',
        'This values are required.' => 'Disse vrdier er pkrvede.',
        'This window must be called from compose window' => 'Dette vindue skal bnes via Skriv-vinduet.',
        'Ticket Comands' => 'Sags kommandoer',
        'Ticket Escalation View' => 'Sags eskalerings visning',
        'Ticket Lock' => 'Sagsls',
        'Ticket Number Generator' => 'Sagsnummergenerator',
        'Ticket Search' => 'Sagssgning',
        'Ticket Status View' => 'Sagsstatusvisning',
        'Ticket Type is required!' => 'Sagstype er krvet!',
        'Ticket add note' => 'Tilfj sags note',
        'Ticket changed' => 'Sag ndret',
        'Ticket changed between' => 'Sag ndret mellem',
        'Ticket escalation!' => 'Sagskalering!',
        'Ticket locked!' => 'Sag lst!',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Sagen konsulent muligheder (f.eks. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Konsulent valgmuligheder (f.eks. <OTRS_OWNER_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Sagens konsulent muligheder (f.eks. <OTRS_OWNER_UserFirstname>)',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Sags ansvarlig muligheder (f.eks. <OTRS_RESPONSIBLE_UserFirstname>).',
        'Ticket selected for bulk action!' => 'Sag valgt til massehandling!',
        'Ticket unlock!' => 'Sag lst op!',
        'Ticket-Area' => 'Sag-Omrde',
        'TicketFreeText' => 'SagFriTekst',
        'TicketID' => 'Sag-ID',
        'Tickets available' => 'Ledige sager',
        'Tickets shown' => 'Viste sager',
        'Tickets which need to be answered!' => 'Sag som besvares',
        'Timeover' => 'Tidsoverskridelse',
        'Times' => 'Tider',
        'Title of the stat.' => 'Title p stat.',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'For at f artikel attributter (fx. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'For at f articlens attributter( f.eks. <OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).',
        'Today' => 'Idag',
        'Tomorrow' => 'Imorgen',
        'Top of Page' => 'verst p siden',
        'Total hits' => 'Samlede antal hit',
        'U' => 'O',
        'Unable to parse Online Repository index document!' => 'Det var ikke muligt at lse Online Repositoryets index dokument',
        'Uniq' => 'Unik',
        'Unlock Tickets' => 'Ls sager op',
        'Unsubscribe' => 'Afmeld',
        'Use utf-8 it your database supports it!' => 'Anvend utf-8, hvis din database understtter det!',
        'Useable options' => 'Brugbare valgmuligheder',
        'User Management' => 'Brugerstyring',
        'User will be needed to handle tickets.' => 'Brugeren behves til at hndtere sagerne.',
        'Users' => 'Brugere',
        'Users <-> Groups' => 'Brugere <-> Grupper',
        'Users <-> Groups Management' => 'Brugere <-> Gruppestyring',
        'Verify New Password' => 'Bekrft nyt kodeord',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Advarsel! Denne sag fjernes fra databasen! Denne sag er get tabt!',
        'Watch notification' => 'Se notifikation',
        'Web-Installer' => 'Web-Installation',
        'WebMail' => 'WebMail',
        'WebWatcher' => 'WebWatcher',
        'Welcome to OTRS' => 'Velkommen til OTRS',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'Med en ugyldig stat er det ikke muligt at generere en stat',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'Med input og select felterne kan du konfigurere en stat til dine behov. Hvilket element af en stat du kan rette afhnger af administratoren der har konfigureret denne stat.',
        'Yes means, send no agent and customer notifications on changes.' => 'Ja betyder, send ingen meddelser til konsulent eller Kunde ved ndringer.',
        'Yes, save it with name' => 'Ja, gem den med navn',
        'You got new message!' => 'Du har fet en ny meddelelse!',
        'You have to select two or more attributes from the select field!' => 'Du skal vlge to eller flere attributter fra feltet!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Der skal vre en e-mailadresse (f.eks. customer@eksempel.com) i feltet Til:!',
        'You need min. one selected Ticket!' => 'Du skal vlge mindst 1 dag!',
        'You need to account time!' => 'Du skal beregne tiden!',
        'You need to activate %s first to use it!' => 'Du skal frst aktivere %s for at bruge den!',
        'Your email address is new' => 'Din e-mailadresse er ny',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Din e-mail med sagnummer "<OTRS_TICKET>" er sendt retur til afsender til "<OTRS_BOUNCE_TO>". Kontakt denne adresse for at f flere oplysninger.',
        'Your own Ticket' => 'Din egen sag',
        'accept license' => 'accepter licens',
        'customer realname' => 'kundens virkelige navn',
        'don\'t accept license' => 'accepter ikke licens',
        'down' => 'ned',
        'false' => 'negativ',
        'for agent firstname' => 'til konsulentens fornavn',
        'for agent lastname' => 'til agents efternavn',
        'for agent login' => 'til konsulentens login',
        'for agent user id' => 'til konsulentens bruger-ID',
        'kill all sessions' => 'afbryd alle sessioner',
        'kill session' => 'afbryd session',
        'maximal period form' => 'maksimal periode form',
        'modified' => 'modificeret',
        'new ticket' => 'ny sag',
        'next step' => 'nste trin',
        'sort downward' => 'sorter faldende',
        'sort upward' => 'sorter stigende',
        'to get the first 20 character of the subject' => 'for at f emnets frste 20 tegn',
        'to get the first 5 lines of the email' => 'for at f e-mailens frste 5 linjer',
        'to get the from line of the email' => 'for at f e-mailens "fra"-linje',
        'to get the realname of the sender (if given)' => 'for at f afsenderens virkelige navn (hvis det er oplyst)',
        'up' => 'op',
        'utf8' => 'utf8',
        'x' => 'x',
        'your MySQL DB should have a root password! Default is empty!' => 'din MySQL DB skat have en rod-adgangskode! Standarden er tom!',
        '}' => '}',
    };
    # $$STOP$$
    return;
}
1;
