# --
# Kernel/Language/vi_VN.pm - provides Vietnamese language translation
# Copyright (C) 2001-2012 OTRS AG, http://otrs.org/
# --
# $Id: vi_VN.pm,v 1.47.2.4 2012-03-09 07:37:02 mg Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --
package Kernel::Language::vi_VN;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.47.2.4 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2012-03-09 08:32:12

    # possible charsets
    $Self->{Charset} = ['viscii', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%T - %D.%M.%Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    # csv separator
    $Self->{Separator} = ';';

    $Self->{Translation} = {

        # Template: AAABase
        'Yes' => 'C',
        'No' => 'Khng',
        'yes' => 'C',
        'no' => 'Khng',
        'Off' => 'Tt',
        'off' => 'tt',
        'On' => 'M',
        'on' => 'm',
        'top' => 'trn u',
        'end' => 'cui',
        'Done' => ' xong',
        'Cancel' => 'Hy',
        'Reset' => 'Lm li',
        'last' => 'Sau',
        'before' => 'Tr߾c',
        'Today' => '',
        'Tomorrow' => '',
        'Next Week' => '',
        'day' => 'ngy',
        'days' => 'ngy',
        'day(s)' => 'ngy',
        'd' => '',
        'hour' => 'gi',
        'hours' => 'gi',
        'hour(s)' => 'gi',
        'Hours' => '',
        'h' => '',
        'minute' => 'pht',
        'minutes' => 'pht',
        'minute(s)' => 'pht',
        'Minutes' => '',
        'm' => '',
        'month' => 'thng',
        'months' => 'thng',
        'month(s)' => 'thng',
        'week' => 'tun',
        'week(s)' => 'tun',
        'year' => 'nm',
        'years' => 'nm',
        'year(s)' => 'nm',
        'second(s)' => 'giy',
        'seconds' => 'giy',
        'second' => 'giy',
        's' => '',
        'wrote' => 'vit',
        'Message' => 'Thng bo',
        'Error' => 'Li',
        'Bug Report' => 'Bo co li',
        'Attention' => 'Ch ',
        'Warning' => 'Cnh bo',
        'Module' => 'M un',
        'Modulefile' => 'File m un',
        'Subfunction' => 'Chc nng con',
        'Line' => 'Dng',
        'Setting' => '',
        'Settings' => '',
        'Example' => 'V d',
        'Examples' => 'Cc v d',
        'valid' => 'Hp l',
        'invalid' => 'Khng hp l',
        '* invalid' => '* khng hp l',
        'invalid-temporarily' => 'tm thi khng hp l',
        ' 2 minutes' => '2 pht',
        ' 5 minutes' => '5 pht',
        ' 7 minutes' => '7 pht',
        '10 minutes' => '10 pht',
        '15 minutes' => '15 pht',
        'Mr.' => 'ng',
        'Mrs.' => 'B',
        'Next' => 'Tip',
        'Back' => 'Tr li',
        'Next...' => 'Tip...',
        '...Back' => '...Tr li',
        '-none-' => 'khng',
        'none' => 'khng',
        'none!' => 'khng!',
        'none - answered' => 'khng c tr li',
        'please do not edit!' => 'Xin ng chnh sa!',
        'Need Action' => '',
        'AddLink' => 'Thm lin kt',
        'Link' => 'Lin kt',
        'Unlink' => '',
        'Linked' => ' lin kt',
        'Link (Normal)' => 'Lin kt (Th߶ng)',
        'Link (Parent)' => 'Lin kt (Cha)',
        'Link (Child)' => 'Lin kt (Con)',
        'Normal' => 'Th߶ng',
        'Parent' => 'Cha',
        'Child' => 'Con',
        'Hit' => 'Nhn chut',
        'Hits' => 'Nhn chut',
        'Text' => 'Vn bn',
        'Standard' => '',
        'Lite' => 'Nh',
        'User' => 'Ng߶i dng',
        'Username' => 'Tn ng nhp',
        'Language' => 'Ngn ng',
        'Languages' => 'Cc ngn ng',
        'Password' => 'Mt khu',
        'Preferences' => 'Giao din',
        'Salutation' => 'Li cho',
        'Salutations' => 'Li cho',
        'Signature' => 'Ch k',
        'Signatures' => 'Ch k',
        'Customer' => 'Khch hng',
        'CustomerID' => 'M khch hng',
        'CustomerIDs' => 'M khch hng',
        'customer' => 'khch hng',
        'agent' => 'nhn vin',
        'system' => 'h thng',
        'Customer Info' => 'Thng tin khch hng',
        'Customer Information' => '',
        'Customer Company' => 'Cng ty khch hng',
        'Customer Companies' => '',
        'Company' => 'Cng ty',
        'go!' => 'tip tc!',
        'go' => 'tip tc',
        'All' => 'tt c',
        'all' => 'tt c',
        'Sorry' => 'Xin li',
        'update!' => 'cp nht!',
        'update' => 'cp nht',
        'Update' => 'Cp nht',
        'Updated!' => '',
        'submit!' => 'xc nhn!',
        'submit' => 'xc nhn',
        'Submit' => 'Xc nhn',
        'change!' => 'thay i!',
        'Change' => 'Thay i',
        'change' => 'thay i',
        'click here' => 'Nhn chut vo y',
        'Comment' => 'Nhn xt',
        'Valid' => 'Hp l',
        'Invalid Option!' => 'La chn khng hp l!',
        'Invalid time!' => 'Thi gian khng hp l!',
        'Invalid date!' => 'Ngy thng khng hp l!',
        'Name' => 'Tn',
        'Group' => 'Nhm',
        'Description' => 'M t',
        'description' => 'm t',
        'Theme' => 'Giao din',
        'Created' => ' khi to',
        'Created by' => 'Khi to bi',
        'Changed' => ' thay i',
        'Changed by' => 'Thay i bi',
        'Search' => 'Tm kim',
        'and' => 'v',
        'between' => 'gia',
        'Fulltext Search' => 'Tm kim ton b vn bn',
        'Data' => 'D liu',
        'Options' => 'Cc ty chn',
        'Title' => 'Tiu ',
        'Item' => 'Mc',
        'Delete' => 'Xa',
        'Edit' => 'Sa',
        'View' => 'Xem',
        'Number' => 'S',
        'System' => 'H thng',
        'Contact' => 'Lin h',
        'Contacts' => 'Lin h',
        'Export' => 'Xut',
        'Up' => 'Trn',
        'Down' => 'D߾i',
        'Add' => 'Thm',
        'Added!' => '',
        'Category' => 'Phn loi',
        'Viewer' => 'Trnh xem',
        'Expand' => '',
        'Small' => '',
        'Medium' => '',
        'Large' => '',
        'Date picker' => '',
        'New message' => 'Tin nhn mi',
        'New message!' => 'Tin nhn mi!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Hy tr li th ny  tr li phn xem cc hng i thng th߶ng!',
        'You have %s new message(s)!' => 'Bn c %s tin nhn mi!',
        'You have %s reminder ticket(s)!' => 'Bn c %s th nhc cng vic!',
        'The recommended charset for your language is %s!' => 'B k t gi  cho ngn ng ca bn l %s!',
        'Change your password.' => '',
        'Please activate %s first!' => '',
        'No suggestions' => 'Khng c gi  no',
        'Word' => 'T',
        'Ignore' => 'B qua',
        'replace with' => 'thay th bng',
        'There is no account with that login name.' => 'Khng c ti khon no vi tn truy cp nh th.',
        'Login failed! Your user name or password was entered incorrectly.' => '',
        'There is no acount with that user name.' => '',
        'Please contact your administrator' => '',
        'Logout' => 'ng xut',
        'Logout successful. Thank you for using OTRS!' => 'ng xut thnh cng! Cm n bn  s dng OTRS!',
        'Invalid SessionID!' => 'M phin khng hp l!',
        'Feature not active!' => 'Tnh nng khng hot ng!',
        'Agent updated!' => '',
        'Create Database' => 'To c s d liu',
        'System Settings' => 'Thit t h thng',
        'Mail Configuration' => '',
        'Finished' => 'Kt thc',
        'Login is needed!' => 'Cn ng nhp!',
        'Password is needed!' => 'Cn mt khu!',
        'License' => 'Giy php',
        'Take this Customer' => 'Chp nhn khch hng ny',
        'Take this User' => 'Chp nhn ng߶i dng ny',
        'possible' => 'c th',
        'reject' => 't chi',
        'reverse' => 'o ngc',
        'Facility' => 'Tin ch',
        'Time Zone' => '',
        'Pending till' => 'Treo ti khi',
        'Don\'t use the Superuser account to work with OTRS! Create new Agents and work with these accounts instead.' => '',
        'Dispatching by email To: field.' => 'Gi bng email ti: tr߶ng.',
        'Dispatching by selected Queue.' => 'Gi bi hng i  chn.',
        'No entry found!' => 'Khng tm thy mc no!',
        'Session has timed out. Please log in again.' => 'Phin  b gin on. Xin hy ng nhp li.',
        'No Permission!' => 'Khng c quyn!',
        'To: (%s) replaced with database email!' => 'Ti: (%s) c thay th bi email c s d liu!',
        'Cc: (%s) added database email!' => 'Cc: (%s) email c s d liu thm!',
        '(Click here to add)' => '(Nhn chut vo y  thm)',
        'Preview' => 'Xem tr߾c',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Gi cha c trin khai chnh xc! Bn nn ci t li gi ln na!',
        '%s is not writable!' => '',
        'Cannot create %s!' => '',
        'Check to activate this date' => '',
        'Customer %s added' => '',
        'Role added!' => '',
        'Role updated!' => '',
        'Attachment added!' => '',
        'Attachment updated!' => '',
        'Response added!' => '',
        'Response updated!' => '',
        'Group updated!' => '',
        'Queue added!' => '',
        'Queue updated!' => '',
        'State added!' => '',
        'State updated!' => '',
        'Type added!' => '',
        'Type updated!' => '',
        'Customer updated!' => '',
        'Contract' => 'Hp ng',
        'Online Customer: %s' => 'Khch hng trc tuyn: %s',
        'Online Agent: %s' => 'Nhn vin ang online: %s',
        'Calendar' => 'Lch',
        'File' => 'File',
        'Filename' => 'Tn file',
        'Type' => 'Loi',
        'Size' => 'C',
        'Upload' => 'Ti ln',
        'Directory' => '߶ng dn',
        'Signed' => ' k',
        'Sign' => 'K',
        'Crypted' => ' gn m',
        'Crypt' => 'Gn m',
        'PGP' => '',
        'PGP Key' => '',
        'PGP Keys' => '',
        'S/MIME' => '',
        'S/MIME Certificate' => '',
        'S/MIME Certificates' => '',
        'Office' => 'Vn phng',
        'Phone' => 'in thoi',
        'Fax' => 'Fax',
        'Mobile' => 'Di ng',
        'Zip' => 'M vng',
        'City' => 'Thnh ph',
        'Street' => '',
        'Country' => 'N߾c',
        'Location' => '',
        'installed' => ' ci t',
        'uninstalled' => ' g ci t',
        'Security Note: You should activate %s because application is already running!' => 'Lu  bo mt: Bn nn kch hot %s bi ng dng  hot ng!',
        'Unable to parse repository index document.' => '',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => '',
        'No packages, or no new packages, found in selected repository.' => '',
        'Edit the system configuration settings.' => '',
        'printed at' => 'c in ti',
        'Loading...' => '',
        'Dear Mr. %s,' => '',
        'Dear Mrs. %s,' => '',
        'Dear %s,' => '',
        'Hello %s,' => '',
        'This email address already exists. Please log in or reset your password.' => '',
        'New account created. Sent login information to %s. Please check your email.' => '',
        'Please press Back and try again.' => 'Xin hy nhn Tr li v th li ln na.',
        'Sent password reset instructions. Please check your email.' => '',
        'Sent new password to %s. Please check your email.' => '',
        'Upcoming Events' => '',
        'Event' => 'S kin',
        'Events' => '',
        'Invalid Token!' => '',
        'more' => '',
        'For more info see:' => '',
        'Package verification failed!' => '',
        'Collapse' => '',
        'Shown' => '',
        'News' => '',
        'Product News' => '',
        'OTRS News' => '',
        '7 Day Stats' => '',
        'Bold' => '',
        'Italic' => '',
        'Underline' => '',
        'Font Color' => '',
        'Background Color' => '',
        'Remove Formatting' => '',
        'Show/Hide Hidden Elements' => '',
        'Align Left' => '',
        'Align Center' => '',
        'Align Right' => '',
        'Justify' => '',
        'Header' => 'Хu trang',
        'Indent' => '',
        'Outdent' => '',
        'Create an Unordered List' => '',
        'Create an Ordered List' => '',
        'HTML Link' => '',
        'Insert Image' => '',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => '',
        'Redo' => '',

        # Template: AAAMonth
        'Jan' => 'Thng 1',
        'Feb' => 'Thng 2',
        'Mar' => 'Thng 3',
        'Apr' => 'Thng 4',
        'May' => 'Thng 5',
        'Jun' => 'Thng 6',
        'Jul' => 'Thng 7',
        'Aug' => 'Thng 8',
        'Sep' => 'Thng 9',
        'Oct' => 'Thng 10',
        'Nov' => 'Thng 11',
        'Dec' => 'Thng 12',
        'January' => 'Thng Mt',
        'February' => 'Thng Hai',
        'March' => 'Thng Ba',
        'April' => 'Thng T',
        'May_long' => 'Thng Nm',
        'June' => 'Thng Su',
        'July' => 'Thng By',
        'August' => 'Thng Tm',
        'September' => 'Thng Chn',
        'October' => 'Thng M߶i',
        'November' => 'Thng M߶i mt',
        'December' => 'Thng M߶i hai',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Giao din  c cp nht thnh cng!',
        'User Profile' => '',
        'Email Settings' => '',
        'Other Settings' => '',
        'Change Password' => 'бi mt khu',
        'Current Password' => '',
        'New password' => 'Mt khu mi',
        'Verify password' => '',
        'Spelling Dictionary' => 'T in chnh t',
        'Default spelling dictionary' => '',
        'Max. shown Tickets a page in Overview.' => 'S th hin th ti a trn mt trang trong phn Tng quan.',
        'The current password is not correct. Please try again!' => '',
        'Can\'t update password, your new passwords do not match. Please try again!' => '',
        'Can\'t update password, it contains invalid characters!' => '',
        'Can\'t update password, it must be at least %s characters long!' => '',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => '',
        'Can\'t update password, it must contain at least 1 digit!' => '',
        'Can\'t update password, it must contain at least 2 characters!' => '',
        'Can\'t update password, this password has already been used. Please choose a new one!' => '',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => '',
        'CSV Separator' => '',

        # Template: AAAStats
        'Stat' => 'Thng k',
        'Sum' => '',
        'Please fill out the required fields!' => 'Hy nhp vo cc tr߶ng bt buc!',
        'Please select a file!' => 'Hy chn 1 file!',
        'Please select an object!' => 'Hy chn 1 i tng!',
        'Please select a graph size!' => 'Hy chn 1 c biu !',
        'Please select one element for the X-axis!' => 'Hy chn 1 thnh t cho trc X!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Hy chn duy nht 1 thnh t hoc tt nt \' sa\'ni tr߶ng  chn c nh du!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Nu bn s dng mt hp chn bn phi chn mt s thuc tnh ca tr߶ng  chn!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Hy chn mt gi tr trong tr߶ng nhp  chn hoc tt hp chn \' sa\'!',
        'The selected end time is before the start time!' => 'Thi gian kt thc  chn tr߾c thi gian bt u!',
        'You have to select one or more attributes from the select field!' => 'Bn phi chn 1 hoc nhiu thuc tnh t tr߶ng  chn!',
        'The selected Date isn\'t valid!' => 'Ngy  chn khng hp l!',
        'Please select only one or two elements via the checkbox!' => 'Hy chn ch 1 hoc 2 thnh t thng qua hp chn!',
        'If you use a time scale element you can only select one element!' => 'Nu bn s dng thnh t khung thi gian bn c th ch chn 1 thnh t!',
        'You have an error in your time selection!' => 'C 1 li trong qu trnh chn thi gian ca bn!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'Khong thi gian bo co qu nh, hy s dng khung thi gian ln hn!',
        'The selected start time is before the allowed start time!' => 'Thi gian bt u  chn tr߾c thi gian bt u cho php!',
        'The selected end time is after the allowed end time!' => 'Thi gian kt thc  chn sau thi gian kt thc cho php!',
        'The selected time period is larger than the allowed time period!' => 'Khong thi gian  chn ln hn khong thi gian cho php!',
        'Common Specification' => 'Уc t chung',
        'X-axis' => 'trc X',
        'Value Series' => 'Chui gi tr',
        'Restrictions' => 'Cc hn ch',
        'graph-lines' => 'Biu  ߶ng k',
        'graph-bars' => 'Biu  thanh',
        'graph-hbars' => 'Biu  thanh ngang',
        'graph-points' => 'Biu  chm',
        'graph-lines-points' => 'Biu  ߶ng k chm',
        'graph-area' => 'Biu  vng',
        'graph-pie' => 'Biu  trn',
        'extended' => 'm rng',
        'Agent/Owner' => 'Nhn vin/Ph trch',
        'Created by Agent/Owner' => 'c to bi nhn vin/ng߶i ph trch',
        'Created Priority' => 'u tin khi to',
        'Created State' => 'Trng thi khi to',
        'Create Time' => 'Thi gian khi to',
        'CustomerUserLogin' => 'Ng߶i dng khch hng ng nhp',
        'Close Time' => 'Thigian ng',
        'TicketAccumulation' => '',
        'Attributes to be printed' => '',
        'Sort sequence' => '',
        'Order by' => '',
        'Limit' => 'Gii hn',
        'Ticketlist' => '',
        'ascending' => '',
        'descending' => '',
        'First Lock' => '',
        'Evaluation by' => '',
        'Total Time' => '',
        'Ticket Average' => '',
        'Ticket Min Time' => '',
        'Ticket Max Time' => '',
        'Number of Tickets' => '',
        'Article Average' => '',
        'Article Min Time' => '',
        'Article Max Time' => '',
        'Number of Articles' => '',
        'Accounted time by Agent' => '',
        'Ticket/Article Accounted Time' => '',
        'TicketAccountedTime' => '',
        'Ticket Create Time' => '',
        'Ticket Close Time' => '',

        # Template: AAATicket
        'Status View' => '',
        'Bulk' => '',
        'Lock' => 'Kha',
        'Unlock' => 'M kha',
        'History' => 'Lch s',
        'Zoom' => 'Phng i',
        'Age' => 'Tui',
        'Bounce' => 'B',
        'Forward' => 'Chuyn tip',
        'From' => 'T',
        'To' => 'Ti',
        'Cc' => 'Cc',
        'Bcc' => 'Bcc',
        'Subject' => 'Tiu ',
        'Move' => 'Chuyn',
        'Queue' => 'Hng i',
        'Queues' => 'Hng i',
        'Priority' => 'u tin',
        'Priorities' => '',
        'Priority Update' => '',
        'SLA' => 'SLA',
        'Service Level Agreement' => '',
        'Service Level Agreements' => '',
        'Service' => 'Dch v',
        'Services' => '',
        'State' => 'Trng thi',
        'States' => '',
        'Status' => 'Trng thi',
        'Statuses' => '',
        'Ticket Type' => '',
        'Ticket Types' => '',
        'Compose' => 'To',
        'Pending' => 'ang treo',
        'Owner' => 'Ph trch',
        'Owner Update' => 'Cp nht ph trch',
        'Responsible' => 'Chu trch nhim',
        'Responsible Update' => 'Cp nht trch nhim',
        'Sender' => 'Ng߶i gi',
        'Article' => 'Bi vit',
        'Ticket' => 'Th',
        'Createtime' => 'Thi gian khi to',
        'plain' => 'gc',
        'Email' => 'E-Mail',
        'email' => 'E-Mail',
        'Close' => 'ng',
        'Action' => 'Hnh ng',
        'Attachment' => 'nh km',
        'Attachments' => 'nh km',
        'This message was written in a character set other than your own.' => 'Tin nhn ny  c vit bng b k t khc vi ca bn.',
        'If it is not displayed correctly,' => 'Nu n khng hin th chnh xc,',
        'This is a' => 'y l mt',
        'to open it in a new window.' => 'm trong ca s mi',
        'This is a HTML email. Click here to show it.' => 'y l mt email HTML. Nhn chut vo y  xem.',
        'Free Fields' => 'Cc tr߶ng t do',
        'Merge' => 'Trn',
        'merged' => ' trn',
        'closed successful' => 'ng thnh cng',
        'closed unsuccessful' => 'ng khng thnh cng',
        'Locked Tickets Total' => '',
        'Locked Tickets Reminder Reached' => '',
        'Locked Tickets New' => '',
        'Responsible Tickets Total' => '',
        'Responsible Tickets New' => '',
        'Responsible Tickets Reminder Reached' => '',
        'Watched Tickets Total' => '',
        'Watched Tickets New' => '',
        'Watched Tickets Reminder Reached' => '',
        'All tickets' => 'Tt c cc th',
        'Tickets available' => 'Cc th sn sng s dng',
        'Escalation' => '',
        'last-search' => '',
        'QueueView' => 'Xem hng i',
        'Ticket Escalation View' => '',
        'Message from' => '',
        'End message' => '',
        'Forwarded message from' => '',
        'End forwarded message' => '',
        'new' => 'mi',
        'open' => 'm',
        'Open' => '',
        'closed' => 'ng',
        'Closed' => '',
        'removed' => 'g b',
        'pending reminder' => 'ang treo nhc nh',
        'pending auto' => 'ang treo t ng',
        'pending auto close+' => 'ang treo t ng ng+',
        'pending auto close-' => 'ang treo t ng ng-',
        'email-external' => 'E-mail bn ngoi',
        'email-internal' => 'E-mail ni b',
        'note-external' => 'lu  bn ngoi',
        'note-internal' => 'lu  ni b',
        'note-report' => 'lu  bo co',
        'phone' => 'in thoi',
        'sms' => 'tin nhn sms',
        'webrequest' => 'yu cu web',
        'lock' => 'kha',
        'unlock' => 'khng kha',
        'very low' => 'rt chm',
        'low' => 'chm',
        'normal' => 'bnh th߶ng',
        'high' => 'cao',
        'very high' => 'rt cao',
        '1 very low' => '1 rt chm',
        '2 low' => '2 chm',
        '3 normal' => '3 bnh th߶ng',
        '4 high' => '4 cao',
        '5 very high' => '5 rt cao',
        'Ticket "%s" created!' => 'Th "%s"  c to!',
        'Ticket Number' => 'S th',
        'Ticket Object' => 'Яi tng th',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Khng c th no c s "%s" nh vy! Khng th lin kt ti !',
        'Don\'t show closed Tickets' => 'Khng hin th cc th  ng',
        'Show closed Tickets' => 'Hin th cc th  ng',
        'New Article' => 'Bi vit mi',
        'Unread article(s) available' => '',
        'Remove from list of watched tickets' => '',
        'Add to list of watched tickets' => '',
        'Email-Ticket' => 'Th e-mail',
        'Create new Email Ticket' => 'To th e-mail mi',
        'Phone-Ticket' => 'Th Cuc gi',
        'Search Tickets' => 'Tm kim th',
        'Edit Customer Users' => 'Sa ng߶i dng khch hng',
        'Edit Customer Company' => '',
        'Bulk Action' => 'Lnh l',
        'Bulk Actions on Tickets' => 'Lnh l trn cc th',
        'Send Email and create a new Ticket' => 'Gi e-mail v to 1 th mi',
        'Create new Email Ticket and send this out (Outbound)' => 'To 1 th e-mail mi v gi ra ngoi',
        'Create new Phone Ticket (Inbound)' => 'To th cuc gi mi (vo trong)',
        'Overview of all open Tickets' => 'Tng quan tt c cc th m',
        'Locked Tickets' => 'Cc th  kha',
        'My Locked Tickets' => '',
        'My Watched Tickets' => '',
        'My Responsible Tickets' => '',
        'Watched Tickets' => 'Cc th  xem',
        'Watched' => ' xem',
        'Watch' => '',
        'Unwatch' => '',
        'Lock it to work on it!' => 'Kha  lm vic trn !',
        'Unlock to give it back to the queue!' => 'M kha  a tr v hng i!',
        'Shows the ticket history!' => 'Xem lch s th!',
        'Print this ticket!' => 'In th ny!',
        'Change the ticket priority!' => 'Thay i u tin th',
        'Change the ticket free fields!' => 'Thay i cc tr߶ng t do ca th',
        'Link this ticket to an other objects!' => 'Lin kt th ny vi cc i tng khc!',
        'Change the ticket owner!' => 'Thay i ph trch th!',
        'Change the ticket customer!' => 'Thay i khch hng th!',
        'Add a note to this ticket!' => 'Thm lu  i vi th ny!',
        'Merge this ticket!' => 'Trn th ny!',
        'Set this ticket to pending!' => 'Thit t treo th ny!',
        'Close this ticket!' => 'ng th ny!',
        'Look into a ticket!' => 'Xem xt mt th!',
        'Delete this ticket!' => 'Xa th ny!',
        'Mark as Spam!' => 'nh du l th rc!',
        'My Queues' => 'Hng i ca ti',
        'Shown Tickets' => 'Cc th c hin th',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'E-mail ca bn vi s th "<OTRS_TICKET>" c trn thnh "<OTRS_MERGE_TO_TICKET>"!',
        'Ticket %s: first response time is over (%s)!' => 'Th %s: ln phn hi u tin qu (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Th %s: ln phn hi u tin s qu %s!',
        'Ticket %s: update time is over (%s)!' => 'Th %s: ln cp nht qu (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Th %s: ln cp nht s qu %s!',
        'Ticket %s: solution time is over (%s)!' => 'Ticket %s: L?sungszeit ist abgelaufen (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Th %s: ln gii php s qu %s!',
        'There are more escalated tickets!' => 'C nhiu th hn!',
        'Plain Format' => '',
        'Reply All' => '',
        'Direction' => '',
        'Agent (All with write permissions)' => '',
        'Agent (Owner)' => '',
        'Agent (Responsible)' => '',
        'Ticket is locked by another agent.' => '',
        'New ticket notification' => 'Thng bo th mi',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Gi thng bo cho ti nu c th mi trong "Hng i ca ti".',
        'Send new ticket notifications' => '',
        'Ticket follow up notification' => '',
        'Ticket lock timeout notification' => 'Thng bo thi gian ch kha th',
        'Send me a notification if a ticket is unlocked by the system.' => 'Gi thng bo cho ti nu mt th cha c kha bi h thng.',
        'Send ticket lock timeout notifications' => '',
        'Ticket move notification' => '',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Gi thng bo cho ti nu mt th c chuyn vo trong "Hng i ca ti".',
        'Send ticket move notifications' => '',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'La chn hng i trong s cc hng i a thch ca bn. Bn cng s nhn c thng bo v chng thng qua email nu chc nng c kch hot',
        'Custom Queue' => '',
        'QueueView refresh time' => 'Thi gian lm mi Hng i',
        'If enabled, the QueueView will automatically refresh after the specified time.' => '',
        'Refresh QueueView after' => '',
        'Screen after new ticket' => 'Mn hnh sau khi to th mi',
        'Show this screen after I created a new ticket' => '',
        'Closed Tickets' => 'Cc th  ng',
        'Show closed tickets.' => 'Hin th cc th  ng.',
        'Max. shown Tickets a page in QueueView.' => 'Cc th hin th ti a trn mi trang trong Hng i.',
        'Ticket Overview "Small" Limit' => '',
        'Ticket limit per page for Ticket Overview "Small"' => '',
        'Ticket Overview "Medium" Limit' => '',
        'Ticket limit per page for Ticket Overview "Medium"' => '',
        'Ticket Overview "Preview" Limit' => '',
        'Ticket limit per page for Ticket Overview "Preview"' => '',
        'Ticket watch notification' => '',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => '',
        'Send ticket watch notifications' => '',
        'Out Of Office Time' => '',
        'New Ticket' => 'Th mi',
        'Create new Ticket' => 'To th mi',
        'Customer called' => 'Khch hng c gi',
        'phone call' => 'cuc gi',
        'Phone Call Outbound' => '',
        'Reminder Reached' => '',
        'Reminder Tickets' => '',
        'Escalated Tickets' => '',
        'New Tickets' => '',
        'Open Tickets / Need to be answered' => '',
        'All open tickets, these tickets have already been worked on, but need a response' => '',
        'All new tickets, these tickets have not been worked on yet' => '',
        'All escalated tickets' => '',
        'All tickets with a reminder set where the reminder date has been reached' => '',
        'Archived tickets' => '',
        'Unarchived tickets' => '',
        'History::Move' => 'Lch s::Chuyn.',
        'History::TypeUpdate' => 'Lch s::Cp nht loi.',
        'History::ServiceUpdate' => 'Lch s::Cp nht dch v.',
        'History::SLAUpdate' => 'Lch s::Cp nht SLA "%s" (ID=%s).',
        'History::NewTicket' => 'Lch s::Th mi [%s] (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'Lch s::Theo di',
        'History::SendAutoReject' => 'Lch s::Gi t chi t ng.',
        'History::SendAutoReply' => 'Lch s::Gi phn hi t ng.',
        'History::SendAutoFollowUp' => 'Lch s::Gi theo di t ng.',
        'History::Forward' => 'Lch s::Chuyn tip.',
        'History::Bounce' => 'Lch s::T b',
        'History::SendAnswer' => 'Lch s::Gi tr li',
        'History::SendAgentNotification' => 'Lch s::Gi thng bo cho nhn vin ph trch',
        'History::SendCustomerNotification' => 'Lch s::Gi thng bo khch hng',
        'History::EmailAgent' => 'Lch s::Email nhn vin',
        'History::EmailCustomer' => 'Lch s::Email khch hng',
        'History::PhoneCallAgent' => 'Lch s::Cuc gi nhn vin',
        'History::PhoneCallCustomer' => 'Lch s::Cuc gi khch hng',
        'History::AddNote' => 'Lch s::Thm lu ',
        'History::Lock' => 'Lch s::Kha',
        'History::Unlock' => 'Lch s::M kha',
        'History::TimeAccounting' => 'Lch s::Gii thch thi gian',
        'History::Remove' => 'Lch s::G b',
        'History::CustomerUpdate' => 'Lch s::Cp nht khch hng',
        'History::PriorityUpdate' => 'Lch s::Cp nht u tin',
        'History::OwnerUpdate' => 'Lch s::Cp nht ph trch',
        'History::LoopProtection' => 'Lch s::Bo v vng lp',
        'History::Misc' => 'Lch s::Khc',
        'History::SetPendingTime' => 'Lch s::Уt thi gian treo',
        'History::StateUpdate' => 'Lch s::Cp nht trng thi',
        'History::TicketFreeTextUpdate' => 'Lch s::Cp nht th',
        'History::WebRequestCustomer' => 'Lch s::Khch hng yu cu web',
        'History::TicketLinkAdd' => 'Lch s::Thm lin kt th',
        'History::TicketLinkDelete' => 'Lch s::Xa lin kt th',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',
        'History::SystemRequest' => '',
        'History::ResponsibleUpdate' => '',
        'History::ArchiveFlagUpdate' => '',

        # Template: AAAWeekDay
        'Sun' => 'Ch nht',
        'Mon' => 'Th hai',
        'Tue' => 'Th ba',
        'Wed' => 'Th t',
        'Thu' => 'Th nm',
        'Fri' => 'Th su',
        'Sat' => 'Th by',

        # Template: AdminAttachment
        'Attachment Management' => 'Qun tr nh km',
        'Actions' => '',
        'Go to overview' => '',
        'Add attachment' => '',
        'List' => 'Danh sch',
        'No data found.' => '',
        'Download file' => '',
        'Delete this attachment' => '',
        'Add Attachment' => '',
        'Edit Attachment' => '',
        'This field is required.' => '',
        'or' => 'hoc',

        # Template: AdminAutoResponse
        'Auto Response Management' => 'Qun tr phn hi t ng',
        'Add auto response' => '',
        'Add Auto Response' => '',
        'Edit Auto Response' => '',
        'Response' => 'Phn hi',
        'Auto response from' => '',
        'Reference' => 'Tham chiu',
        'You can use the following tags' => '',
        'To get the first 20 character of the subject.' => 'Ly 20 k t u tin ca tiu ',
        'To get the first 5 lines of the email.' => 'Ly 5 dng u tin ca email',
        'To get the realname of the sender (if given).' => 'Ly tn thc ca ng߶i gi (nu  cho)',
        'To get the article attribute' => '',
        ' e. g.' => '',
        'Options of the current customer user data' => '',
        'Ticket owner options' => '',
        'Ticket responsible options' => '',
        'Options of the current user who requested this action' => '',
        'Options of the ticket data' => '',
        'Config options' => '',
        'Example response' => '',

        # Template: AdminCustomerCompany
        'Customer Company Management' => 'Qun tr cng ty khch hng',
        'Wildcards like \'*\' are allowed.' => '',
        'Add customer company' => '',
        'Please enter a search term to look for customer companies.' => '',
        'Add Customer Company' => 'Thm cng ty khch hng',

        # Template: AdminCustomerUser
        'Customer Management' => '',
        'Add customer' => '',
        'Select' => 'Chn',
        'Hint' => '',
        'Customer will be needed to have a customer history and to login via customer panel.' => '',
        'Please enter a search term to look for customers.' => '',
        'Last Login' => '',
        'Add Customer' => '',
        'Edit Customer' => '',
        'This field is required and needs to be a valid email address.' => '',
        'This email address is not allowed due to the system configuration.' => '',
        'This email address failed MX check.' => '',
        'DNS problem, please check your configuration and the error log.' => '',
        'The syntax of this email address is incorrect.' => '',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => '',
        'Notice' => '',
        'This feature is disabled!' => 'Tnh nng ny  b v hiu ha!',
        'Just use this feature if you want to define group permissions for customers.' => '',
        'Enable it here!' => 'Kch hot ti y!',
        'Search for customers.' => '',
        'Edit Customer Default Groups' => '',
        'These groups are automatically assigned to all customers.' => '',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '',
        'Filter for Groups' => '',
        'Select the customer:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => '',
        'Search Result:' => '',
        'Customers' => '',
        'Groups' => 'Nhm',
        'No matches found.' => '',
        'Change Group Relations for Customer' => '',
        'Change Customer Relations for Group' => '',
        'Toggle %s Permission for all' => '',
        'Toggle %s permission for %s' => '',
        'Customer Default Groups:' => '',
        'No changes can be made to these groups.' => '',
        'ro' => 'Ch c',
        'Read only access to the ticket in this group/queue.' => 'Quyn ch c truy cp vo th trong nhm/hng i ny.',
        'rw' => 'c v ghi',
        'Full read and write access to the tickets in this group/queue.' => 'Quyn c v ghi truy cp vo th trong nhm/hng i ny.',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => '',
        'Edit default services' => '',
        'Filter for Services' => '',
        'Allocate Services to Customer' => '',
        'Allocate Customers to Service' => '',
        'Toggle active state for all' => '',
        'Active' => 'Hot ng',
        'Toggle active state for %s' => '',

        # Template: AdminEmail
        'Admin Notification' => 'Thng bo qun tr',
        'With this module, administrators can send messages to agents, group or role members.' => '',
        'Create Administrative Message' => '',
        'Your message was sent to' => '',
        'Send message to users' => '',
        'Send message to group members' => '',
        'Group members need to have permission' => '',
        'Send message to role members' => '',
        'Also send to customers in groups' => '',
        'Body' => 'Ni dung',
        'Send' => 'Gi',

        # Template: AdminGenericAgent
        'Generic Agent' => '',
        'Add job' => '',
        'Last run' => 'Ln vn hnh tr߾c',
        'Run Now!' => 'Vn hnh ngay!',
        'Delete this task' => '',
        'Run this task' => '',
        'Job Settings' => '',
        'Job name' => '',
        'Currently this generic agent job will not run automatically.' => '',
        'To enable automatic execution select at least one value from minutes, hours and days!' => '',
        'Schedule minutes' => '',
        'Schedule hours' => '',
        'Schedule days' => '',
        'Toggle this widget' => '',
        'Ticket Filter' => '',
        '(e. g. 10*5155 or 105658*)' => 'v d: 10*5144 hoc 105658*',
        '(e. g. 234321)' => 'v d: 234321',
        'Customer login' => '',
        '(e. g. U5150)' => 'v d: U5150',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => '',
        'Agent' => 'Nhn vin',
        'Ticket lock' => '',
        'TicketFreeFields' => 'Cc tr߶ng khng th',
        'Create times' => '',
        'No create time settings.' => 'Khng c thit t ln khi to',
        'Ticket created' => 'Th  to',
        'Ticket created between' => 'Th  to gia',
        'Close times' => '',
        'No close time settings.' => '',
        'Ticket closed' => '',
        'Ticket closed between' => '',
        'Pending times' => '',
        'No pending time settings.' => 'Khng c thit t ln treo',
        'Ticket pending time reached' => 'Ln treo th  t ti',
        'Ticket pending time reached between' => 'Ln treo th  t ti gia',
        'Escalation times' => '',
        'No escalation time settings.' => '',
        'Ticket escalation time reached' => '',
        'Ticket escalation time reached between' => '',
        'Escalation - first response time' => '',
        'Ticket first response time reached' => '',
        'Ticket first response time reached between' => '',
        'Escalation - update time' => '',
        'Ticket update time reached' => '',
        'Ticket update time reached between' => '',
        'Escalation - solution time' => '',
        'Ticket solution time reached' => '',
        'Ticket solution time reached between' => '',
        'Archive search option' => '',
        'Ticket Action' => '',
        'Set new service' => '',
        'Set new Service Level Agreement' => '',
        'Set new priority' => '',
        'Set new queue' => '',
        'Set new state' => '',
        'Set new agent' => '',
        'new owner' => '',
        'Set new ticket lock' => '',
        'New customer' => '',
        'New customer ID' => '',
        'New title' => '',
        'New type' => '',
        'New TicketFreeFields' => 'Cc tr߶ng khng th mi',
        'Archive selected tickets' => '',
        'Add Note' => 'Thm lu ',
        'Time units' => 'Cc n v thi gian',
        ' (work units)' => ' (cc n v lm vic)',
        'Ticket Commands' => '',
        'Send agent/customer notifications on changes' => '',
        'CMD' => 'CMD',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Lnh ny s c chy. ARG[0] s l s th. ARG[1] l m th.',
        'Delete tickets' => 'Xa th',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => '',
        'Execute Custom Module' => '',
        'Param %s key' => '',
        'Param %s value' => '',
        'Save Changes' => '',
        'Save' => 'Lu',
        'Results' => 'Kt qu',
        '%s Tickets affected! What do you want to do?' => '',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => '',
        'Edit job' => '',
        'Run job' => '',
        'Affected Tickets' => '',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '',
        'Group Management' => 'Qun tr nhm',
        'Add group' => '',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Nhm qun tr ly trong khu vc qun tr v nhm thng k ly trong khu vc thng k.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => '',
        'It\'s useful for ASP solutions. ' => '',
        'Add Group' => 'Thm nhm',
        'Edit Group' => '',

        # Template: AdminLog
        'System Log' => 'Bn ghi h thng',
        'Here you will find log information about your system.' => '',
        'Hide this message' => '',
        'Recent Log Entries' => '',
        'Time' => 'Thi giab',

        # Template: AdminMailAccount
        'Mail Account Management' => '',
        'Add mail account' => '',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Tt c cc email n vi 1 ti khon s c gi vo trong hng i  chn!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Nu ti khon ca bn l ng tin cy, u trang X-OTRS  c ti thi gian n (cho mc  u tin, ...) s c s dng! B lc PostMaster cng s c dng.',
        'Host' => 'My ch host',
        'Delete account' => '',
        'Fetch mail' => '',
        'Add Mail Account' => '',
        'Example: mail.example.com' => '',
        'Trusted' => 'Tin cy',
        'Dispatching' => 'ang gi',
        'Edit Mail Account' => '',

        # Template: AdminNavigationBar
        'Admin' => 'Qun tr',
        'Agent Management' => '',
        'Queue Settings' => '',
        'Ticket Settings' => '',
        'System Administration' => '',

        # Template: AdminNotification
        'Notification Management' => 'Qun tr thng bo',
        'Select a different language' => '',
        'Filter for Notification' => '',
        'Notifications are sent to an agent or a customer.' => 'Cc thng bo  c gi ti 1 nhn vin hoc khch hng.',
        'Notification' => 'Thng bo',
        'Edit Notification' => '',
        'e. g.' => '',
        'Options of the current customer data' => '',

        # Template: AdminNotificationEvent
        'Add notification' => '',
        'Delete this notification' => '',
        'Add Notification' => '',
        'Recipient groups' => '',
        'Recipient agents' => '',
        'Recipient roles' => '',
        'Recipient email addresses' => '',
        'Article type' => 'Loi bi vit',
        'Only for ArticleCreate event' => '',
        'Subject match' => '',
        'Body match' => '',
        'Include attachments to notification' => '',
        'Notification article type' => '',
        'Only for notifications to specified email addresses' => '',
        'To get the first 20 character of the subject (of the latest agent article).' => '',
        'To get the first 5 lines of the body (of the latest agent article).' => '',
        'To get the first 20 character of the subject (of the latest customer article).' => '',
        'To get the first 5 lines of the body (of the latest customer article).' => '',

        # Template: AdminPGP
        'PGP Management' => 'Qun tr PGP',
        'Use this feature if you want to work with PGP keys.' => '',
        'Add PGP key' => '',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Theo cch ny bn c th sa trc tip cu hnh kha trong Cu hnh h thng.',
        'Introduction to PGP' => '',
        'Result' => 'Kt qu',
        'Identifier' => 'T nh danh',
        'Bit' => 'Bit',
        'Key' => 'Kha',
        'Fingerprint' => 'Du tay',
        'Expires' => 'Ht hn',
        'Delete this key' => '',
        'Add PGP Key' => '',
        'PGP key' => '',

        # Template: AdminPackageManager
        'Package Manager' => 'Qun tr gi',
        'Uninstall package' => '',
        'Version' => 'Phin bn',
        'Do you really want to uninstall this package?' => 'Bn c thc s mun g ci t gi ny?',
        'Reinstall package' => '',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => '',
        'Continue' => 'Tip tc',
        'Install' => 'Ci t',
        'Install Package' => '',
        'Update repository information' => '',
        'Did not find a required feature? OTRS Group provides their subscription customers with exclusive Add-Ons:' => '',
        'Online Repository' => 'Kho trc tuyn',
        'Vendor' => 'Ng߶i bn',
        'Module documentation' => '',
        'Upgrade' => 'Nng cp',
        'Local Repository' => 'Kho cc b',
        'Uninstall' => 'G ci t',
        'Package not correctly deployed! You should reinstall the package again!' => '',
        'Reinstall' => 'Ci li',
        'Download package' => '',
        'Rebuild package' => '',
        'Metadata' => '',
        'Change Log' => '',
        'Date' => 'D liu',
        'List of Files' => '',
        'Permission' => 'Quyn',
        'Download' => 'Ti xung',
        'Download file from package!' => 'Ti file t gi xung!',
        'Required' => 'c yu cu',
        'PrimaryKey' => 'Kha chnh',
        'AutoIncrement' => 'Gia tng t ng',
        'SQL' => 'SQL',
        'File differences for file %s' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Bn ghi thc thi',
        'This feature is enabled!' => 'Tnh nng ny  c kch hot!',
        'Just use this feature if you want to log each request.' => 'Ch s dng tnh nng ny nu bn mun ghi mi yu cu.',
        'Activating this feature might affect your system performance!' => '',
        'Disable it here!' => 'V hiu ha ti y!',
        'Logfile too large!' => 'File bn ghi qu ln!',
        'The logfile is too large, you need to reset it' => '',
        'Overview' => 'Tng quan',
        'Range' => 'Di',
        'Interface' => 'Giao din',
        'Requests' => 'Yu cu',
        'Min Response' => 'Phn hi ti thiu',
        'Max Response' => 'Phn hi ti a',
        'Average Response' => 'Phn hi trung bnh',
        'Period' => '',
        'Min' => '',
        'Max' => '',
        'Average' => '',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Qun tr b lc PostMaster',
        'Add filter' => '',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Nu bn mun kt hp cc a ch email, hy dng EMAILADDRESS:info@example.com trong tr߶ng T, Ъn hoc Cc.',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '',
        'Delete this filter' => '',
        'Add PostMaster Filter' => '',
        'Edit PostMaster Filter' => '',
        'Filter name' => '',
        'The name is required.' => '',
        'Stop after match' => '',
        'Filter Condition' => '',
        'Value' => 'Gi tr',
        'The field needs to be a valid regular expression or a literal word.' => '',
        'Set Email Headers' => '',
        'The field needs to be a literal word.' => '',

        # Template: AdminPriority
        'Priority Management' => '',
        'Add priority' => '',
        'Add Priority' => '',
        'Edit Priority' => '',

        # Template: AdminQueue
        'Manage Queues' => '',
        'Add queue' => '',
        'Add Queue' => '',
        'Edit Queue' => '',
        'Sub-queue of' => '',
        'Unlock timeout' => 'Thi gian ch m kha',
        '0 = no unlock' => '0 = khng m kha',
        'Only business hours are counted.' => '',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => '',
        'Notify by' => '',
        '0 = no escalation' => '0 = khng tip tc',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => '',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => '',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => '',
        'Follow up Option' => 'Theo di ty chn',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => '',
        'Ticket lock after a follow up' => 'Kha th sau khi theo di',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => '',
        'System address' => '',
        'Will be the sender address of this queue for email answers.' => 'S l a ch ng߶i gi ca hng i ny cho cc email tr li.',
        'Default sign key' => '',
        'The salutation for email answers.' => 'Li cho cho cc email tr li.',
        'The signature for email answers.' => 'Ch k cho cc email tr li.',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => '',
        'Filter for Queues' => '',
        'Filter for Auto Responses' => '',
        'Auto Responses' => 'Cc tr li t ng',
        'Change Auto Response Relations for Queue' => '',
        'settings' => '',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => '',
        'Filter' => 'Lc',
        'Filter for Responses' => '',
        'Responses' => 'Cc tr li',
        'Change Queue Relations for Response' => '',
        'Change Response Relations for Queue' => '',

        # Template: AdminResponse
        'Manage Responses' => '',
        'Add response' => '',
        'A response is default text to write faster answer (with default text) to customers.' => 'Mt phn hi l mt vn bn mc nh c vit cu tr li nhanh gi cho khch hng.',
        'Don\'t forget to add a new response a queue!' => 'ng qun thm phn hi mi vo hng i!',
        'Delete this entry' => '',
        'Add Response' => '',
        'Edit Response' => '',
        'The current ticket state is' => 'Trng thi th hin ti l',
        'Your email address is' => '',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => '',
        'Filter for Attachments' => '',
        'Change Response Relations for Attachment' => '',
        'Change Attachment Relations for Response' => '',
        'Toggle active for all' => '',
        'Link %s to selected %s' => '',

        # Template: AdminRole
        'Role Management' => 'Qun tr vai tr',
        'Add role' => '',
        'Create a role and put groups in it. Then add the role to the users.' => 'To 1 vai tr v t cc nhm vo . Ri thm vai tr cho ng߶i dng.',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => '',
        'Add Role' => 'Thm vai tr',
        'Edit Role' => '',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => '',
        'Filter for Roles' => '',
        'Roles' => 'Vai tr',
        'Select the role:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => '',
        'Change Role Relations for Group' => '',
        'Change Group Relations for Role' => '',
        'Toggle %s permission for all' => '',
        'move_into' => 'chuyn ti',
        'Permissions to move tickets into this group/queue.' => 'Cc quyn  chuyn th vo trong nhm/hng i ny.',
        'create' => 'to',
        'Permissions to create tickets in this group/queue.' => 'Cc quyn  to th trong nhm/hng i ny.',
        'priority' => 'u tin',
        'Permissions to change the ticket priority in this group/queue.' => 'Cc quyn  thay i u tin th trong nhm/hng i ny.',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => '',
        'Filter for Agents' => '',
        'Agents' => '',
        'Manage Role-Agent Relations' => '',
        'Change Role Relations for Agent' => '',
        'Change Agent Relations for Role' => '',

        # Template: AdminSLA
        'SLA Management' => 'Qun tr SLA',
        'Add SLA' => 'Thm SLA',
        'Edit SLA' => '',
        'Please write only numbers!' => '',

        # Template: AdminSMIME
        'S/MIME Management' => 'Qun tr S/MIME',
        'Add certificate' => '',
        'Add private key' => '',
        'Filter for certificates' => '',
        'Filter for SMIME certs' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'Theo cch ny bn c th sa chng ch v kha c nhn trc tip trong h thng file.',
        'See also' => 'Xem',
        'Hash' => 'Bm',
        'Create' => 'To',
        'Delete this certificate' => '',
        'Add Certificate' => 'Thm chng ch',
        'Add Private Key' => 'Thm kha c nhn',
        'Secret' => 'B mt',

        # Template: AdminSalutation
        'Salutation Management' => 'Qun tr li cho',
        'Add salutation' => '',
        'Add Salutation' => 'Thm li cho',
        'Edit Salutation' => '',
        'Example salutation' => '',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => '',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => '',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBox
        'SQL Box' => '',
        'Here you can enter SQL to send it directly to the application database.' => '',
        'The syntax of your SQL query has a mistake. Please check it.' => '',
        'There is at least one parameter missing for the binding. Please check it.' => '',
        'Result format' => '',
        'Run Query' => '',

        # Template: AdminService
        'Service Management' => 'Qun tr dch v',
        'Add service' => '',
        'Add Service' => 'Thm dch v',
        'Edit Service' => '',
        'Sub-service of' => '',

        # Template: AdminSession
        'Session Management' => 'Qun tr phin',
        'All sessions' => '',
        'Agent sessions' => '',
        'Customer sessions' => '',
        'Unique agents' => '',
        'Unique customers' => '',
        'Kill all sessions' => 'Xa tt c cc phin',
        'Kill this session' => '',
        'Session' => 'Phin',
        'Kill' => '',
        'Detail View for SessionID' => '',

        # Template: AdminSignature
        'Signature Management' => 'Qun tr ch k',
        'Add signature' => '',
        'Add Signature' => 'Thm ch k',
        'Edit Signature' => '',
        'Example signature' => '',

        # Template: AdminState
        'State Management' => 'Qun tr trng thi',
        'Add state' => '',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Hy lu  rng bn  cp nht cc trng thi mc nh trong Kernel/Config.pm!',
        'Add State' => 'Thm trng thi',
        'Edit State' => '',
        'State type' => '',

        # Template: AdminSysConfig
        'SysConfig' => 'Cu hnh h thng',
        'Navigate by searching in %s settings' => '',
        'Navigate by selecting config groups' => '',
        'Download all system config changes' => '',
        'Export settings' => '',
        'Load SysConfig settings from file' => '',
        'Import settings' => '',
        'Import Settings' => '',
        'Import' => 'Nhp',
        'Please enter a search term to look for settings.' => '',
        'Subgroup' => 'Nhm con',
        'Elements' => 'Cc thnh t',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => '',
        'This config item is only available in a higher config level!' => '',
        'Reset this setting' => '',
        'Default value' => '',
        'Error: this file could not be found.' => '',
        'Error: this directory could not be found.' => '',
        'Error: an invalid value was entered.' => '',
        'Content' => 'Ni dung',
        'Remove this entry' => '',
        'Add entry' => '',
        'Remove entry' => '',
        'Add new entry' => '',
        'Create new entry' => '',
        'New group' => '',
        'Group ro' => '',
        'Readonly group' => '',
        'New group ro' => '',
        'Loader' => '',
        'File to load for this frontend module' => '',
        'New Loader File' => '',
        'NavBarName' => 'Tn thanh iu h߾ng',
        'NavBar' => 'Thanh iu h߾ng',
        'LinkOption' => '',
        'Block' => 'Khi',
        'AccessKey' => 'Phm truy cp',
        'Add NavBar entry' => '',
        'Year' => 'Nm',
        'Month' => 'Thng',
        'Day' => 'Ngy',
        'Invalid year' => '',
        'Invalid month' => '',
        'Invalid day' => '',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'Qun tr a ch email h thng',
        'Add system address' => '',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => '',
        'Email address' => '',
        'Display name' => '',
        'Add System Email Address' => '',
        'Edit System Email Address' => '',
        'The display name and email address will be shown on mail you send.' => '',

        # Template: AdminType
        'Type Management' => 'Qun tr loi',
        'Add ticket type' => '',
        'Add Type' => 'Thm loi',
        'Edit Type' => '',

        # Template: AdminUser
        'Add agent' => '',
        'Agents will be needed to handle tickets.' => '',
        'Don\'t forget to add a new agent to groups and/or roles!' => '',
        'Please enter a search term to look for agents.' => '',
        'Last login' => '',
        'Login as' => 'ng nhp vi',
        'Switch to agent' => '',
        'Add Agent' => '',
        'Edit Agent' => '',
        'Firstname' => 'H',
        'Lastname' => 'Tn',
        'Password is required.' => '',
        'Start' => 'bt u',
        'End' => '',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => '',
        'Change Group Relations for Agent' => '',
        'Change Agent Relations for Group' => '',
        'note' => '',
        'Permissions to add notes to tickets in this group/queue.' => '',
        'owner' => 'ph trch',
        'Permissions to change the owner of tickets in this group/queue.' => '',

        # Template: AgentBook
        'Address Book' => 'S a ch',
        'Search for a customer' => '',
        'Add email address %s to the To field' => '',
        'Add email address %s to the Cc field' => '',
        'Add email address %s to the Bcc field' => '',
        'Apply' => '',

        # Template: AgentCustomerSearch
        'Search Customer' => 'Tm kim khch hng',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => '',
        'Show or hide the content' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => '',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '',
        'Please update now.' => '',
        'Release Note' => '',
        'Level' => '',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => '',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket has been locked' => '',
        'Undo & close window' => '',

        # Template: AgentInfo
        'Info' => 'Thng tin',
        'To accept some news, a license or some changes.' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => '',
        'Close window' => '',
        'go to link delete screen' => '',
        'Select Target Object' => '',
        'Link Object' => 'Яi tng lin kt',
        'with' => 'vi',
        'Unlink Object: %s' => '',
        'go to link add screen' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => '',

        # Template: AgentSpelling
        'Spell Checker' => 'Kim tra chnh t',
        'spelling error(s)' => 'Li chnh t',
        'Apply these changes' => 'p dng nhng thay i ny',

        # Template: AgentStatsDelete
        'Delete stat' => '',
        'Stat#' => 'Thng k s',
        'Do you really want to delete this stat?' => '',

        # Template: AgentStatsEditRestrictions
        'Step %s' => '',
        'General Specifications' => '',
        'Select the element that will be used at the X-axis' => '',
        'Select the elements for the value series' => 'Chn cc thnh t cho chui gi tr',
        'Select the restrictions to characterize the stat' => '',
        'Here you can make restrictions to your stat.' => 'Bn c th to cc gii hn cho thng k ti y.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Nu bn b nh du trong  " sa", nhn vin ph trch sinh thng k c th thay i cc thuc tnh ca thnh t lin quan.',
        'Fixed' => ' sa',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Hy chn ch 1 thnh t hoc tt nt \' sa\'!',
        'Absolute Period' => '',
        'Between' => 'Gia',
        'Relative Period' => 'Chu k lin quan',
        'The last' => 'Cui cng',
        'Finish' => 'Kt thc',

        # Template: AgentStatsEditSpecification
        'Permissions' => 'Cc quyn',
        'You can select one or more groups to define access for different agents.' => '',
        'Some result formats are disabled because at least one needed package is not installed.' => '',
        'Please contact your administrator.' => '',
        'Graph size' => '',
        'If you use a graph as output format you have to select at least one graph size.' => 'Nu bn dng mt biu  lm nh dng u ra, bn phi chn t nht 1 c biu .',
        'Sum rows' => 'Tng s hng',
        'Sum columns' => 'Tng s ct',
        'Use cache' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'Hu ht cc thng k u c th c lu. iu ny s y nhanh tc  trnh din ca thng k.',
        'If set to invalid end users can not generate the stat.' => '',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => '',
        'You have the possibility to select one or two elements.' => '',
        'Then you can select the attributes of elements.' => '',
        'Each attribute will be shown as single value series.' => '',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => 'Phm vi',
        'minimal' => 'ti thiu',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Hy nh rng, phm vi cho chui gi tr phi ln hn phm vi cho trc X (v d: trc X => Thng; Chui gi tr => Nm).',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '',
        'maximal period' => 'chu k ti a',
        'minimal scale' => 'phm vi ti thiu',

        # Template: AgentStatsImport
        'Import Stat' => '',
        'File is not a Stats config' => 'File khng phi l mt cu hnh thng k',
        'No File selected' => 'Khng c file no c chn',

        # Template: AgentStatsOverview
        'Stats' => 'Thng k',
        'Object' => 'Яi tng',

        # Template: AgentStatsPrint
        'Print' => 'In',
        'No Element selected.' => 'Khng thnh t no c chn.',

        # Template: AgentStatsView
        'Export config' => '',
        'With the input and select fields you can influence the format and contents of the statistic.' => '',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => '',
        'Stat Details' => '',
        'Format' => 'иnh dng',
        'Graphsize' => 'C biu ',
        'Cache' => 'Lu tr',
        'Exchange Axis' => 'Trc trao i',
        'Configurable params of static stat' => 'Tham s cu hnh ca thng k tnh',
        'No element selected.' => 'Khng thnh t no c chn.',
        'maximal period from' => 'chu k ti a t',
        'to' => 'n',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => '',
        'Change Owner of Ticket' => '',
        'Close Ticket' => '',
        'Add Note to Ticket' => '',
        'Set Pending' => 'Thit t treo',
        'Change Priority of Ticket' => '',
        'Change Responsible of Ticket' => '',
        'Cancel & close window' => '',
        'Service invalid.' => '',
        'New Owner' => 'Ph trch mi',
        'Please set a new owner!' => '',
        'Previous Owner' => 'Ph trch tr߾c',
        'Inform Agent' => 'Nhn vin thng bo',
        'Optional' => 'Ty chn',
        'Inform involved Agents' => 'Thng bo cc nhn vin lin quan',
        'Spell check' => '',
        'Note type' => 'Loi lu ',
        'Next state' => 'Trng thi tip',
        'Pending date' => 'Ngy treo',
        'Date invalid!' => '',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => '',
        'Bounce to' => 'T b t',
        'You need a email address.' => '',
        'Need a valid email address or don\'t use a local email address.' => '',
        'Next ticket state' => 'Trng thi th tip theo',
        'Inform sender' => 'Thng bo ng߶i gi',
        'Send mail!' => 'Gi mail!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Lnh l trn th',
        'Merge to' => 'Trn vi',
        'Invalid ticket identifier!' => '',
        'Merge to oldest' => '',
        'Link together' => '',
        'Link to parent' => '',
        'Unlock tickets' => '',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Son tr li cho th',
        'Need a valid email address.' => '',
        'Address book' => '',
        'Pending Date' => 'Ngy treo',
        'for pending* states' => 'i vi cc trng thi treo*',
        'Date Invalid!' => '',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Thay i khch hng ca th',
        'Customer Data' => 'D liu khch hng',
        'Customer user' => '',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => '',
        'From queue' => '',
        'Get all' => '',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => '',
        'Need a valid email address or don\'t use a local email address' => '',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'Lch s ca',
        'History Content' => '',
        'Zoom view' => '',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Trn th',
        'You need to use a ticket number!' => 'Bn cn dng s th!',
        'A valid ticket number is required.' => '',

        # Template: AgentTicketMove
        'Move Ticket' => 'Chuyn th',
        'New Queue' => 'Hng i mi',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => '',
        'No ticket data found.' => '',
        'First Response Time' => 'Ln phn hi u tin',
        'Service Time' => 'Thi gian dch v',
        'Update Time' => 'Thi gian cp nht',
        'Solution Time' => 'Thi gian gii php',
        'Move ticket to a different queue' => '',
        'Change queue' => 'Thay i hng i',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => 'Thay i ty chn tm kim',
        'Tickets per page' => '',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'Tip tc trong',
        'Locked' => ' kha',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => '',
        'From customer' => '',
        'To queue' => '',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => 'Cuc gi',

        # Template: AgentTicketPlain
        'Email Text Plain View' => '',
        'Plain' => 'Gc',
        'Download this email' => '',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Thng tin th',
        'Accounted time' => 'Thi gian k khai',
        'Linked-Object' => 'Яi tng lin kt',
        'by' => 'bi',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'Tm kim mu',
        'Create Template' => '',
        'Create New' => '',
        'Profile link' => '',
        'Save changes in template' => '',
        'Add another attribute' => '',
        'Output' => 'Kt qu t',
        'Fulltext' => 'Ton b vn bn',
        'Remove' => '',
        'Customer User Login' => 'ng nhp ng߶i dng khch hng',
        'Time1' => '',
        'Time2' => '',
        'Time3' => '',
        'Time4' => '',
        'Time5' => '',
        'Time6' => '',
        'Created in Queue' => ' to trong hng i',
        'Lock state' => '',
        'Watcher' => 'Ng߶i xem',
        'Article Create Time (before/after)' => '',
        'Article Create Time (between)' => '',
        'Ticket Create Time (before/after)' => '',
        'Ticket Create Time (between)' => '',
        'Ticket Change Time (before/after)' => '',
        'Ticket Change Time (between)' => '',
        'Ticket Close Time (before/after)' => '',
        'Ticket Close Time (between)' => '',
        'Archive Search' => '',
        'Run Search' => '',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => '',
        'Article Type' => '',
        'Sender Type' => '',
        'Save filter settings as default' => '',
        'Ticket Information' => '',
        'Linked Objects' => '',
        'Article(s)' => '',
        'Change Queue' => '',
        'Article Filter' => '',
        'Add Filter' => '',
        'Set' => 'Thit t',
        'Reset Filter' => '',
        'Show one article' => '',
        'Show all articles' => '',
        'Unread articles' => '',
        'No.' => '',
        'Unread Article!' => '',
        'Incoming message' => '',
        'Outgoing message' => '',
        'Internal message' => '',
        'Resize' => '',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => '',
        'Load blocked content.' => '',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => 'Truy nguyn',

        # Template: CustomerFooter
        'Powered by' => 'Chy trn nn',
        'One or more errors occurred!' => '',
        'Close this dialog' => '',
        'Could not open popup window. Please disable any popup blockers for this application.' => '',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => 'ng nhp',
        'User name' => '',
        'Your user name' => '',
        'Your password' => '',
        'Forgot password?' => '',
        'Log In' => '',
        'Not yet registered?' => '',
        'Sign up now' => '',
        'Request new password' => 'Yu cu mt khu mi',
        'Your User Name' => '',
        'A new password will be sent to your email address.' => '',
        'Create Account' => 'To ti khon',
        'Please fill out this form to recieve login credentials.' => '',
        'How we should address you' => '',
        'Your First Name' => '',
        'Please supply a first name' => '',
        'Your Last Name' => '',
        'Please supply a last name' => '',
        'The User Name you wish to have' => '',
        'Please supply a' => '',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => '',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => '',

        # Template: CustomerTicketOverView
        'Welcome!' => '',
        'Please click the button below to create your first ticket.' => '',
        'Create your first ticket' => '',

        # Template: CustomerTicketPrint
        'Ticket Print' => '',

        # Template: CustomerTicketSearch
        'Profile' => 'H s',
        'e. g. 10*5155 or 105658*' => '',
        'Customer ID' => '',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => '',
        'Recipient' => '',
        'Carbon Copy' => '',
        'Time restrictions' => '',
        'Only tickets created' => '',
        'Only tickets created between' => '',
        'Search-Profile as Template?' => '',
        'Save as Template?' => '',
        'Save as Template' => '',
        'Template Name' => '',
        'Pick a profile name' => '',
        'Output to' => '',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => 'ca',
        'Page' => 'Trang',
        'Search Results for' => '',

        # Template: CustomerTicketZoom
        'Expand article' => '',
        'Reply' => '',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => '',
        'Previous' => '',
        'Sunday' => '',
        'Monday' => '',
        'Tuesday' => '',
        'Wednesday' => '',
        'Thursday' => '',
        'Friday' => '',
        'Saturday' => '',
        'Su' => '',
        'Mo' => '',
        'Tu' => '',
        'We' => '',
        'Th' => '',
        'Fr' => '',
        'Sa' => '',
        'Open date selection' => '',

        # Template: Error
        'Oops! An Error occurred.' => '',
        'Error Message' => '',
        'You can' => '',
        'Send a bugreport' => '',
        'go back to the previous page' => '',
        'Error Details' => '',

        # Template: Footer
        'Top of page' => '',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => '',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => '',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => '',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => '',
        'Database Settings' => '',
        'General Specifications and Mail Settings' => '',
        'Welcome to %s' => 'Cho mng ti %s',
        'Web site' => '',
        'Database check successful.' => '',
        'Mail check successful.' => '',
        'Error in the mail settings. Please correct and try again.' => '',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => '',
        'Outbound mail type' => '',
        'Select outbound mail type.' => '',
        'Outbound mail port' => '',
        'Select outbound mail port.' => '',
        'SMTP host' => '',
        'SMTP host.' => '',
        'SMTP authentication' => '',
        'Does your SMTP host need authentication?' => '',
        'SMTP auth user' => '',
        'Username for SMTP auth.' => '',
        'SMTP auth password' => '',
        'Password for SMTP auth.' => '',
        'Configure Inbound Mail' => '',
        'Inbound mail type' => '',
        'Select inbound mail type.' => '',
        'Inbound mail host' => '',
        'Inbound mail host.' => '',
        'Inbound mail user' => '',
        'User for inbound mail.' => '',
        'Inbound mail password' => '',
        'Password for inbound mail.' => '',
        'Result of mail configuration check' => '',
        'Check mail configuration' => '',
        'Skip this step' => '',

        # Template: InstallerDBResult
        'False' => '',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => '',
        'Currently only MySQL is supported in the web installer.' => '',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => '',
        'Database-User' => 'Ng߶i dng c s d liu',
        'New' => 'Mi',
        'A new database user with limited rights will be created for this OTRS system.' => '',
        'default \'hot\'' => 'mc nh \'hot\'',
        'DB--- host' => '',
        'Database' => 'C s d liu',
        'Check database settings' => '',
        'Result of database check' => '',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Ь c th s dng OTRS bn phi nhp dng sau vo dng lnh ca bn (Terminal/Shell) lm gc.',
        'Restart your webserver' => 'Khi ng li my ch web.',
        'After doing so your OTRS is up and running.' => 'Sau khi thc hin OTRS ca bn  hot ng.',
        'Start page' => 'Trang bt u',
        'Your OTRS Team' => 'еi OTRS ca bn',

        # Template: InstallerLicense
        'Accept license' => 'Chp nhn giy php',
        'Don\'t accept license' => 'Khng chp nhn giy php',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'M h thng',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => '',
        'System FQDN' => 'H thng FQDN',
        'Fully qualified domain name of your system.' => '',
        'AdminEmail' => 'Email qun tr',
        'Email address of the system administrator.' => '',
        'Organization' => 'T chc',
        'Log' => 'Bn ghi',
        'LogModule' => 'M un bn ghi',
        'Log backend to use.' => '',
        'LogFile' => '',
        'Log file location is only needed for File-LogModule!' => '',
        'Webfrontend' => 'Mt ngoi web',
        'Default language' => '',
        'Default language.' => '',
        'CheckMXRecord' => 'Kim tra bn ghi MX',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => '',

        # Template: LinkObject
        'Object#' => '',
        'Add links' => '',
        'Delete links' => '',

        # Template: Login
        'JavaScript Not Available' => '',
        'Browser Warning' => '',
        'The browser you are using is too old.' => '',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => '',
        'Please see the documentation or ask your admin for further information.' => '',
        'Lost your password?' => 'Mt mt khu?',
        'Request New Password' => '',
        'Back to login' => '',

        # Template: Motd
        'Message of the Day' => '',

        # Template: NoPermission
        'Insufficient Rights' => '',
        'Back to the previous page' => '',

        # Template: Notify

        # Template: Pagination
        'Show first page' => '',
        'Show previous pages' => '',
        'Show page %s' => '',
        'Show next pages' => '',
        'Show last page' => '',

        # Template: PictureUpload
        'Need FormID!' => '',
        'No file found!' => '',
        'The file is not an image that can be shown inline!' => '',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'c in bi',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'Trang test OTRS',
        'Welcome %s' => 'Cho mng %s',
        'Counter' => 'B m',

        # Template: Warning
        'Go back to the previous page' => '',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => '',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => '',
        'Activates lost password feature for agents, in the agent interface.' => '',
        'Activates lost password feature for customers.' => '',
        'Activates support for customer groups.' => '',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => '',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => '',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => '',
        'Activates time accounting.' => '',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => '',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Agent Notifications' => '',
        'Agent interface article notification module to check PGP.' => '',
        'Agent interface article notification module to check S/MIME.' => '',
        'Agent interface module to access fulltext search via nav bar.' => '',
        'Agent interface module to access search profiles via nav bar.' => '',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => '',
        'Agents <-> Roles' => '',
        'Allows adding notes in the close ticket screen of the agent interface.' => '',
        'Allows adding notes in the ticket free text screen of the agent interface.' => '',
        'Allows adding notes in the ticket note screen of the agent interface.' => '',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => '',
        'Allows agents to exchange the axis of a stat if they generate one.' => '',
        'Allows agents to generate individual-related stats.' => '',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attributes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Attachments <-> Responses' => 'Cc nh km <-> Cc tr li',
        'Auto Responses <-> Queues' => 'Cc tr li t ng <-> Hng i',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => '',
        'Change queue!' => '',
        'Change the ticket responsible!' => '',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Christmas Eve' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => '',
        'Company Tickets' => '',
        'Configure your own log text for PGP.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => '',
        'Create and manage Service Level Agreements (SLAs).' => '',
        'Create and manage agents.' => '',
        'Create and manage attachments.' => '',
        'Create and manage companies.' => '',
        'Create and manage customers.' => '',
        'Create and manage event based notifications.' => '',
        'Create and manage groups.' => '',
        'Create and manage notifications that are sent to agents.' => '',
        'Create and manage queues.' => '',
        'Create and manage response templates.' => '',
        'Create and manage responses that are automatically sent.' => '',
        'Create and manage roles.' => '',
        'Create and manage salutations.' => '',
        'Create and manage services.' => '',
        'Create and manage signatures.' => '',
        'Create and manage ticket priorities.' => '',
        'Create and manage ticket states.' => '',
        'Create and manage ticket types.' => '',
        'Create new email ticket and send this out (outbound)' => '',
        'Create new phone ticket (inbound)' => '',
        'Custom text for the page shown to customers that have no tickets yet.' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => '',
        'Customers <-> Groups' => '',
        'Customers <-> Services' => '',
        'Data used to export the search result in CSV format.' => '',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimePointFormat=year;TicketCreateTimePointStart=Last;TicketCreateTimePoint=2;".' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimeStartYear=2010;TicketCreateTimeStartMonth=10;TicketCreateTimeStartDay=4;TicketCreateTimeStopYear=2010;TicketCreateTimeStopMonth=11;TicketCreateTimeStopDay=3;".' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => '',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => '',
        'Default ticket ID used by the system in the agent interface.' => '',
        'Default ticket ID used by the system in the customer interface.' => '',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => '',
        'Defines a default list of words, that are ignored by the spell checker.' => '',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => '',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines if time accounting must be set to all tickets in bulk action.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => '',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 2 for articles to add a new article attribute.' => '',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 3 for articles to add a new article attribute.' => '',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => '',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free time key field number 1 for tickets.' => '',
        'Defines the free time key field number 2 for tickets.' => '',
        'Defines the free time key field number 3 for tickets.' => '',
        'Defines the free time key field number 4 for tickets.' => '',
        'Defines the free time key field number 5 for tickets.' => '',
        'Defines the free time key field number 6 for tickets.' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repository, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => '',
        'Defines the name of the calendar number 2.' => '',
        'Defines the name of the calendar number 3.' => '',
        'Defines the name of the calendar number 4.' => '',
        'Defines the name of the calendar number 5.' => '',
        'Defines the name of the calendar number 6.' => '',
        'Defines the name of the calendar number 7.' => '',
        'Defines the name of the calendar number 8.' => '',
        'Defines the name of the calendar number 9.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the sender for rejected emails.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => '',
        'Defines whether the free time field number 2 is optional or not.' => '',
        'Defines whether the free time field number 3 is optional or not.' => '',
        'Defines whether the free time field number 4 is optional or not.' => '',
        'Defines whether the free time field number 5 is optional or not.' => '',
        'Defines whether the free time field number 6 is optional or not.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries in milliseconds.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'иa ch email',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => '',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => '',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => '',
        'Execute SQL statements.' => '',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => '',
        'First Christmas Day' => '',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => '',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => '',
        'GenericAgent' => 'Nhn vin ph trch chung',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove trailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Ignore article with system sender type for new article feature (e. g. auto responses or email notifications).' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => '',
        'International Workers\' Day' => '',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => '',
        'Link agents to roles.' => '',
        'Link attachments to responses templates.' => '',
        'Link customers to groups.' => '',
        'Link customers to services.' => '',
        'Link queues to auto responses.' => '',
        'Link responses to queues.' => '',
        'Link roles to groups.' => '',
        'Link this ticket to other objects!' => '',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => '',
        'Manage POP3 or IMAP accounts to fetch email from.' => '',
        'Manage S/MIME certificates for email encryption.' => '',
        'Manage existing sessions.' => '',
        'Manage periodic tasks.' => '',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate accounted time ticket statistics.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to generate ticket solution and response time statistics.' => '',
        'Module to generate ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => '',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New Year\'s Day' => '',
        'New Year\'s Eve' => '',
        'New email ticket' => '',
        'New phone ticket' => '',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => '',
        'Number of displayed tickets' => '',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => '',
        'Overview of all open Tickets.' => '',
        'PGP Key Upload' => '',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'PostMaster Filters' => '',
        'PostMaster Mail Accounts' => '',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => '',
        'QueueView Refresh Time' => '',
        'Refresh interval' => '',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => 'Cc tr li <-> Hng i',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => 'Vai tr <-> Nhm',
        'Runs an initial wildcard search of the existing customer users when accessing the AdminCustomerUser module.' => '',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => '',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Saves the login and password on the session table in the database, if "DB" was selected for SessionModule.' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Second Christmas Day' => '',
        'Select your frontend Theme.' => 'Hy chn giao din mt ngoi ca bn.',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => '',
        'Send notifications to users.' => '',
        'Send ticket follow up notifications' => '',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => '',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set this to yes if you trust in all your public and private pgp keys, even if they are not certified with a trusted signature.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Show article as rich text even if rich text writing is disabled.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to move a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Shows time use complete description (days, hours, minutes), if set to "Yes"; or just first letter (d, h, m), if set to "No".' => '',
        'Skin' => '',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => '',
        'Status view' => '',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => '',
        'Tickets' => 'Cc th',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => '',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => '',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => '',
        'View system log messages.' => '',
        'Wear this frontend skin' => '',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => '',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        '%s Tickets affected! Do you really want to use this job?' => '%s th b nh h߷ng! Bn c thc s mun dng cng vic ny?',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kim tra cc bn ghi MX ca cc a ch email  s dng bng cch to mt tr li. Khng dng Kim tra bn ghi MX nu h thng OTRS ca bn nm sau 1 ߶ng dial-up!)',
        '(Email of the system admin)' => '(Email ca qun tr h thng)',
        '(Full qualified domain name of your system)' => '(Tn min y  iu kin ca h thng)',
        '(Logfile just needed for File-LogModule!)' => '(File bn ghi ch cn cho m un File-Log!)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '(Lu : N ph thuc vo ci t ca bn c bao nhiu i tng ng bn mun dng)',
        '(Note: Useful for big databases and low performance server)' => '(Lu : Hu dng i vi cc c s d liu ln v my ch cu hnh thp)',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Nhn dng ca h thng. Mi s th v mi m phin http u bt u bng s ny)',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Nhn dng th. Mt s ng߶i mun thit t iu ny thnh v d nh \'Ticket#\', \'Call#\' hoc \'MyTicket#\')',
        '(Used default language)' => '(Dng ngn ng mc nh)',
        '(Used log backend)' => '( s dng cc bn ghi mt sau)',
        '(Used ticket number format)' => '(иnh dng s th s dng)',
        'A article should have a title!' => 'Bi vit nn c tiu !',
        'A message must be spell checked!' => 'Tin nhn phi c kim tra chnh t!',
        'A message should have a To: recipient!' => 'Mt tin nhn nn c tr߶ng ng߶i nhn!',
        'A message should have a body!' => 'Tin nhn nn c ni dung!',
        'A message should have a subject!' => 'Th nn c tiu !',
        'Absolut Period' => 'Chu k tuyt i',
        'Add Customer User' => 'Thm ng߶i dng khch hng',
        'Add System Address' => 'Thm a ch h thng',
        'Add User' => 'Thm ng߶i dng',
        'Add a new Agent.' => 'Thm mt nhn vin mi.',
        'Add a new Customer Company.' => 'Thm 1 cng ty khch hng mi',
        'Add a new Group.' => 'Thm 1 nhm mi.',
        'Add a new Role.' => 'Thm vai tr mi.',
        'Add a new SLA.' => 'Thm SLA mi.',
        'Add a new Salutation.' => 'Thm li cho mi.',
        'Add a new Service.' => 'Thm dch v mi.',
        'Add a new Signature.' => 'Thm ch k mi.',
        'Add a new State.' => 'Thm trng thi mi.',
        'Add a new System Address.' => 'Thm a ch h thng mi.',
        'Add a new Type.' => 'Thm loi mi.',
        'Add note to ticket' => 'Thm lu  cho th',
        'Added User "%s"' => 'Ng߶i dng "%s"  c thm.',
        'Admin-Area' => 'Khu vc dnh cho qun tr',
        'Admin-Password' => 'Mt khu qun tr',
        'Admin-User' => 'Tn truy cp qun tr',
        'Agent Mailbox' => 'Hp th dnh cho nhn vin',
        'Agent Preferences' => 'Giao din cho nhn vin ph trch',
        'Agent-Area' => 'Khu vc dnh cho nhn vin',
        'All Agent variables.' => 'Tt c cc bin s nhn vin',
        'All Agents' => 'Tt c nhn vin',
        'All Customer variables like defined in config option CustomerUser.' => 'Tt c cc bin s khch hng  nh ngha trong cu hnh ty chn ng߶i dng khch hng.',
        'All customer tickets.' => 'Tt c cc th khch hng.',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Tt c cc email n vi c t "Email" (Ti:) s c gi vo trong hng i  chn.',
        'All messages' => 'Tt c tin nhn',
        'Allocate CustomerUser to service' => 'Phn phi ng߶i dng khch hng ti dch v',
        'Allocate services to CustomerUser' => 'Phn phi dch v ti ng߶i dng khch hng',
        'Answer' => 'Tr li',
        'Attach' => 'nh km',
        'Attribute' => 'Thuc tnh',
        'Auto Response From' => 'Phn hi t ng t',
        'Bounce ticket' => 'Th  b',
        'CSV' => 'CSV',
        'Can\'t update password, invalid characters!' => 'Khng th cp nht mt khu, cc k t khng hp l.',
        'Can\'t update password, must be at least %s characters!' => 'Khng th cp nht mt khu, mt khu phi t nht %s k t.',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Khng th cp nht mt khu, cn c 2 k t d߾i v 2 k t trn.',
        'Can\'t update password, needs at least 1 digit!' => 'Khng th cp nht mt khu, mt khu cn c t nht 1 con s!',
        'Can\'t update password, needs at least 2 characters!' => 'Khng th cp nht mt khu, mt khu cn c t nht 2 k t!',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Khng th cp nht mt khu, cc mt khu khng khp nhau! Hy th li ln na!',
        'Category Tree' => 'Cy th mc',
        'Change %s settings' => 'Thay i %s thit t',
        'Change Time' => 'Thay i thi gian',
        'Change free text of ticket' => 'Thay i ni dung th',
        'Change owner of ticket' => 'Thay i ph trch th',
        'Change priority of ticket' => 'Thay i mc  u tin ca th',
        'Change responsible of ticket' => 'Thay i ng߶i chu trch nhim ca th',
        'Change user <-> group settings' => 'Thay i ng߶i dng <-> cc thit t nhm',
        'ChangeLog' => 'Bn ghi thay i',
        'Child-Object' => 'Яi tng con',
        'Classification' => 'Phn loi',
        'Clear From' => 'Xa t',
        'Clear To' => 'Xa ti',
        'Click here to report a bug!' => 'Nhn chut vo y  gi bo co li!',
        'Close ticket' => 'ng th',
        'Close type' => 'ng loi',
        'Close!' => 'ng!',
        'Comment (internal)' => 'Nhn xt (ni b)',
        'CompanyTickets' => 'Th cng ty',
        'Compose Answer' => 'Son tr li',
        'Compose Email' => 'Son email',
        'Compose Follow up' => 'Son theo di',
        'Config Options' => 'Cc ty chn cu hnh',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Cc ty chn cu hnh (v d: &lt;OTRS_CONFIG_HttpType&gt;)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Cc ty chn cu hnh (v d: <OTRS_CONFIG_HttpType>)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Ty chn cu hnh (v d: <OTRS_CONFIG_HttpType).',
        'Contact customer' => 'Lin h khch hng',
        'Create Times' => 'Cc ln khi to',
        'Create new Phone Ticket' => 'To th cuc gi mi',
        'Create new database' => 'To c s d liu mi',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'To cc nhm mi  iu khin quyn truy cp cho cc nhm nhn vin khc nhau (v d: b phn mua hng, b phn h tr, b phn kinh doanh,...).',
        'CreateTicket' => 'To th',
        'Current Impact Rating' => 'Mc nh h߷ng hin ti',
        'Customer Move Notify' => 'Thng bo chuyn khch hng',
        'Customer Owner Notify' => 'Thng bo ph trch khch hng',
        'Customer State Notify' => 'Thng bo trng thi khch hng',
        'Customer User' => 'Ng߶i dng khch hng',
        'Customer User Management' => 'Qun tr ng߶i dng khch hng',
        'Customer Users' => 'Ng߶i dng khch hng',
        'Customer Users <-> Groups' => 'Ng߶i dng khch hng <-> Nhm',
        'Customer Users <-> Groups Management' => 'Ng߶i dng khch hng <-> Qun tr nhm',
        'Customer Users <-> Services' => 'Ng߶i dng khch hng <-> Dch v',
        'Customer Users <-> Services Management' => 'Ng߶i dng khch hng <-> Qun tr dch v',
        'Customer history' => 'Lch s khch hng',
        'Customer history search' => 'Tm kim lch s khch hng',
        'Customer history search (e. g. "ID342425").' => 'Tm kim lch s khch hng (v d: "ID342425").',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'Ng߶i dng khch hng s cn c mt lch s khch hng v ng nhp thng qua bng iu khin khch hng',
        'CustomerUser' => 'Ng߶i dng khch hng',
        'D' => 'D',
        'DB Admin Password' => 'Mt khu qun tr C s d liu',
        'DB Admin User' => 'Ng߶i dng qun tr C s d liu',
        'DB connect host' => 'My ch host kt ni c s d liu',
        'Default' => 'Mc nh',
        'Default Charset' => 'M k t mc nh',
        'Default Language' => 'Ngn ng mc nh',
        'Delete old database' => 'Xa c s d liu c',
        'Detail' => 'Chi tit',
        'Diff' => 'Khc nhau',
        'Discard all changes and return to the compose screen' => 'T b mi thay i v tr li mn hnh son',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Gi hoc lc cc email n da trn X-Headers email! RegExp cng c th.',
        'Do you really want to delete this Object?' => 'Bn c thc s mun xa i tng ny khng?',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Bn c thc s mun ci li t gi ny (tt c nhng thay i b mt)?',
        'Don\'t forget to add a new user to groups and/or roles!' => 'ng qun thm mt ng߶i dng mi vo nhm v/hoc vai tr!',
        'Don\'t forget to add a new user to groups!' => 'ng qun b sung mt ng߶i dng mi vo nhm!',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Khng lm vic vi m ng߶i dng 1 (ti khon h thng)! Hy to ng߶i dng mi!',
        'Download Settings' => 'Cc thit t ti xung',
        'Download all system config changes.' => 'Ti xung cc thay i cu hnh h thng.',
        'Drop Database' => 'B qua C s d liu',
        'Dynamic-Object' => 'Яi tng ng',
        'Edit default services.' => 'Sa dch v mc nh.',
        'Escalation - First Response Time' => 'Tip tc - Thi gian phn hi u tin',
        'Escalation - Solution Time' => 'Tip tc - Thi gian gii php',
        'Escalation - Update Time' => 'Tip tc - Thi gian cp nht',
        'Escalation time' => 'Thi gian tip tc',
        'Explanation' => 'Gii thch',
        'Export Config' => 'Cu hnh xut',
        'FAQ Search Result' => 'Kt qu tm kim FAQ',
        'FAQ System History' => 'Lch s h thng FAQ',
        'File-Name' => 'Tn file',
        'File-Path' => '߶ng dn file',
        'Filelist' => 'Danh sch file',
        'Filtername' => 'Lc tn',
        'Follow up' => 'Theo di',
        'Follow up notification' => 'Thng bo theo di',
        'For very complex stats it is possible to include a hardcoded file.' => 'Яi vi cc thng k phc tp c th bao gm c file  m ha.',
        'Frontend' => 'Mt ngoi',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Tm kim trong bi vit (v d: "Mar*in" hoc "Baue*")',
        'Go' => 'Ti',
        'Group Ro' => 'Nhm ch c',
        'Group selection' => 'La chn nhm',
        'Have a lot of fun!' => 'Hy tn h߷ng s vui thch!',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Bn c th nh ngha chui gi tr ti y. Bn c kh nng chon 1 hoc 2 thnh t. Sau  c th chn cc thuc tnh ca thnh t. Mi thuc tnh s c hin th l mt chui gi tr n l. Nu khng chn thuc tnh no, tt c thuc tnh ca thnh t s c s dng nu bn sinh thng k. Cng vi  mt thuc tnh mi cng c thm k t ln cu hnh cui cng.',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Bn c th nh ngha trc X ti y. Bn c th chn 1 thnh t thng qua nt bm radio. Sau  phi chn 1 hoc nhiu thuc tnh ca thnh t. Nu khng chn tt c thuc tnh ca thnh t s c s dng nu bn sinh thng k. Cng vi  mt thuc tnh mi cng c thm k t ln cu hnh cui cng.',
        'Here you can insert a description of the stat.' => 'Bn c th chn m t thng k ti y.',
        'Here you can select the dynamic object you want to use.' => 'Bn c th chn i tng ng mun s dng ti y.',
        'Home' => 'Trang ch',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Nu mt file  m ha sn sng s dng, thuc tnh ny s c hin th v bn c th chn n.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Nu mt th c ng v khch hng gi theo di, th s b kha cho ng߶i ph trch c.',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Nu mt th khng c tr li trong thi gian ny, ch duy nht th ny s c hin th.',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Nu 1 nhn vin kha th v h khng gi tr li trong thi gian ny, th s c t ng m kha. Do vy tt c cc nhn vin khc u c th nhn thy th .',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Nu khng chn ci g th s khng c quyn no trong nhm ny (cc th s khng sn sng s dng i vi ng߶i dng).',
        'If you need the sum of every column select yes.' => 'Nu bn cn tng s ct, Hy chn \'C\'.',
        'If you need the sum of every row select yes' => 'Nu bn cn tng s hng, Hy chn \'C\'.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Nu bn dng RegExp, bn cng c th s dng gi tr kt hp trong () thnh [***] trong \'Thit t\'.',
        'Image' => 'nh',
        'Important' => 'Quan trng',
        'Imported' => 'Nhp',
        'Imported by' => 'Nhp bi',
        'In this form you can select the basic specifications.' => 'Trong mu ny bn c th chn cc c t c bn.',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Theo cch ny bn c th sa trc tip cu hnh kha trong Kernel/Config.pm',
        'Information about the Stat' => 'Thng tin v thng k',
        'Insert of the common specifications' => 'Chn cu hnh chung',
        'Instance' => 'Tr߶ng hp',
        'Is Job Valid' => 'Cng vic c hp l',
        'Is Job Valid?' => 'Cng vic c hp l?',
        'It\'s useful for ASP solutions.' => 'N hu ch cho gii php ASP.',
        'It\'s useful for a lot of users and groups.' => 'N hu ch i vi nhiu ng߶i dng v nhm.',
        'Job-List' => 'Danh sch cng vic',
        'Keyword' => 'T kha',
        'Keywords' => 'T kha',
        'Last update' => 'Ln cp nht tr߾c',
        'Load' => 'Ti',
        'Load Settings' => 'Cc thit t ti',
        'Logfile' => 'File bn ghi',
        'Logfile too large, you need to reset it!' => 'File bn ghi qu ln, bn cn thit t li!',
        'Login failed! Your username or password was entered incorrectly.' => 'ng nhp tht bi! Tn truy cp hoc mt khu nhp khng chnh xc.',
        'Lookup' => 'Tra',
        'Mail Management' => 'Qun tr mail',
        'Mailbox' => 'Hp mail',
        'Match' => 'Kt hp',
        'Message for new Owner' => 'Tin nhn cho ph trch mi',
        'Message sent to' => 'Tin nhn c gi ti',
        'Misc' => 'Khc',
        'Modified' => ' chnh sa',
        'Modules' => 'M un',
        'Move notification' => 'Thng bo chuyn',
        'Multiple selection of the output format.' => 'Nhiu la chn ca nh dng u ra.',
        'My Queue' => 'Hng i ca ti',
        'MyTickets' => 'Th ca ti',
        'Name is required!' => 'Tn c yu cu!',
        'New Agent' => 'Nhn vin mi',
        'New Customer' => 'Khch hng mi',
        'New Group' => 'Nhm mi',
        'New Group Ro' => 'Nhm ch c mi',
        'New Priority' => 'u tin mi',
        'New State' => 'Trng thi mi',
        'New Ticket Lock' => 'Kha th mi',
        'New messages' => 'Tin nhn mi',
        'New password again' => 'G li mt khu mi',
        'No * possible!' => 'Khng * c th!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'Khng c gi no cho cu trc yu cu trong Kho cha trc tuyn ny, nhng c cc gi cho nhng cu trc khc.',
        'No Packages or no new Packages in selected Online Repository!' => 'Khng c gi no hoc khng c gi mi no trong Kho cha trc tuyn  chn!',
        'No Permission' => 'Khng c quyn',
        'No means, send agent and customer notifications on changes.' => 'Khng, ngha l, gi thng bo cho nhn vin v khch hng v cc thay i.',
        'No time settings.' => 'Khng c thit t thi gian.',
        'Node-Address' => 'иa ch nt',
        'Node-Name' => 'Tn nt',
        'Note' => 'Lu ',
        'Note Text' => 'Lu ',
        'Notification (Customer)' => 'Thng bo (Khch hng)',
        'Notifications' => 'Thng bo',
        'OTRS DB Password' => 'Mt khu c s d liu OTRS',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS gi mt email thng bo ti khch hng nu th c chuyn.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS gi mt email thng bo ti khch hng nu ph trch th thay i.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS gi mt email thng bo ti khch hng nu trng thi th thay i.',
        'Of couse this feature will take some system performance it self!' => 'Tt nhin tnh nng ny s t thc thi h thng.',
        'Open Tickets' => 'M th',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Cc ty chn ca d liu ng߶i dng khch hng hin ti ((v d: &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;).',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Cc ty chn ca d liu ng߶i dng khch hng hin ti (v d: <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Cc ty chn ca d liu ng߶i dng khch hng hin ti (v d: <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Cc ty chn ca ng߶i dng hin ti yu cu hnh ng ny (v d: &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Cc ty chn ca ng߶i dng hin ti ng߶i yu cu hnh ng ny (v d: <OTRS_CURRENT_UserFirstname>)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Cc ty chn ca ng߶i dng khch hng yu cu hnh ng ny (v d: <OTRS_CURRENT_UserFirstname).',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Cc ty chn ca d liu th (v d: &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Cc ty chn ca d liu th (v d: <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Cc ty chn ca d liu th (v d: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Cc ty chn ca d liu th (v d: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Order' => 'Trt t',
        'Other Options' => 'Cc ty chn khc',
        'POP3 Account Management' => 'Qun tr ti khon POP3',
        'Package' => 'Gi',
        'Param 1' => 'Tham s 1',
        'Param 2' => 'Tham s 2',
        'Param 3' => 'Tham s 3',
        'Param 4' => 'Tham s 4',
        'Param 5' => 'Tham s 5',
        'Param 6' => 'Tham s 6',
        'Parent-Object' => 'Яi tng cha',
        'Password is already in use! Please use an other password!' => 'Mt khu  tng c s dng! Hy s dng mt mt khu khc!',
        'Password is already used! Please use an other password!' => 'Mt khu  tng c s dng! Hy s dng mt mt khu khc!',
        'Passwords doesn\'t match! Please try it again!' => 'Cc mt khu khng khp nhau! Hy th li!',
        'Pending Times' => 'Cc ln treo',
        'Pending messages' => 'Cc tin nhn treo',
        'Pending type' => 'Loi treo',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Cc thit t quyn. Bn c th la chn 1 hoc nhiu nhm  to thng k  c cu hnh m cc nhn vin khc nhau u c th nhn thy.',
        'Permissions to change the ticket owner in this group/queue.' => 'Cc quyn  thay i ph trch th trong nhm/hng i ny.',
        'PhoneView' => 'Xem s in thoi',
        'Please contact your admin' => 'Hy lin h vi qun tr h thng ca bn',
        'Prio' => 'u tin',
        'Process-Path' => '߶ng dn quy trnh',
        'Product' => 'Sn phm',
        'Queue <-> Auto Responses Management' => 'Hng i <-> Qun tr phn hi t ng',
        'Queue Management' => 'Qun tr hng i',
        'Realname' => 'Tn thc',
        'Rebuild' => 'Dng li',
        'Recipients' => 'Ng߶i nhn',
        'Refresh' => 'Lm mi',
        'Reminder' => 'Nhc nh',
        'Reminder messages' => 'Tin nhn nhc nh',
        'Reporter' => 'Ng߶i bo co',
        'Required Field' => 'Tr߶ng bt buc',
        'Response Management' => 'Qun tr phn hi',
        'Responses <-> Attachments Management' => 'Phn hi <-> Qun tr nh km',
        'Responses <-> Queue Management' => 'Phn hi <-> Qun tr hng i',
        'Return to the compose screen' => 'Tr li mn hnh son',
        'Role' => 'Vai tr',
        'Roles <-> Groups Management' => 'Vai tr <-> Qun tr nhm',
        'Roles <-> Users' => 'Vai tr <-> Ng߶i dng',
        'Roles <-> Users Management' => 'Vai tr <-> Qun tr ng߶i dng',
        'Save Job as?' => 'Lu cng vic?',
        'Save Search-Profile as Template?' => 'Lu h s tm kim thnh mu?',
        'Schedule' => 'K hoch',
        'Search Result' => 'Kt qu tm kim',
        'Search for' => 'Tm kim cho',
        'Select Box' => 'Chn ',
        'Select Box Result' => 'Chn  kt qu',
        'Select Source (for add)' => 'Chn ngun ( thm)',
        'Select the customeruser:service relations.' => 'Chn mi quan h ng߶i dng khch hng:dch v.',
        'Select the element, which will be used at the X-axis' => 'Chn thnh t s dng trn trc X.',
        'Select the restrictions to characterise the stat' => 'La chn cc gii hn c trng cho thng k',
        'Select the role:user relations.' => 'Chn mi quan h vai tr:ng߶i dng.',
        'Select the user:group permissions.' => 'La chn ng߶i dng: cc quyn ca nhm.',
        'Select your QueueView refresh time.' => 'Hy chn thi gian lm mi hng i ca bn.',
        'Select your default spelling dictionary.' => 'Hy chn t in chnh t mc nh ca bn.',
        'Select your frontend Charset.' => 'Hy chn b m k t mt ngoi ca bn.',
        'Select your frontend QueueView.' => 'Hy chn cch xem hng i mt ngoi ca bn.',
        'Select your frontend language.' => 'Hy chn ngn ng mt ngoi ca bn.',
        'Select your screen after creating a new ticket.' => 'Hy la chn mn hnh sau khi to mt th mi.',
        'Selection needed' => 'La chn cn',
        'Send Notification' => 'Gi thng bo',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Gi thng bo cho ti nu c khch hng gi theo di v ti l ph trch ca th ny.',
        'Send no notifications' => 'Khng gi thng bo no',
        'Sent new password to: ' => ' gi mt khu mi ti: ',
        'Service-Name' => 'Tn dch v',
        'Sessions' => 'Cc phin',
        'Set customer user and customer id of a ticket' => 'Thit t m khch hng v ng߶i dng khch hng ca th',
        'Show' => 'Hin th',
        'Site' => 'Site',
        'Solution' => 'Gii php',
        'Sort by' => 'Sp xp theo',
        'Source' => 'Ngun',
        'Spell Check' => 'Kim tra chnh t',
        'Split' => 'Chia',
        'State Type' => 'Loi trng thi',
        'Static-File' => 'File tnh',
        'Stats-Area' => 'Khu vc dnh cho thng k',
        'Sub-Queue of' => 'Hng i con ca',
        'Sub-Service of' => 'Dch v con ca',
        'Subscribe' => 'Xc nhn',
        'System State Management' => 'Qun tr trng thi h thng',
        'System Status' => 'Trng thi h thng',
        'Systemaddress' => 'иa ch h thng',
        'The message being composed has been closed.  Exiting.' => 'Tin nhn ang son b ng. ang thot.',
        'These values are read-only.' => 'Gi tr ny ch c',
        'These values are required.' => 'Gi tr ny c yu cu',
        'This account exists.' => 'Ti khon ny  tn ti.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'iu ny s c ch nu bn mun khng ai c th ly kt qu ca thng k hoc thng k khng sn sng c cu hnh.',
        'This window must be called from compose window' => 'Ca s ny cn phi c gi t ca s son tho',
        'Ticket Lock' => 'Kha th',
        'Ticket Number Generator' => 'H sinh s th',
        'Ticket Search' => 'Tm kim th',
        'Ticket Status View' => 'Xem trng thi th',
        'Ticket escalation!' => 'Cc th tip tc!',
        'Ticket locked!' => 'Th kha!',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Cc ty chn ph trch th (v d: &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Cc ty chn ch th (v d <OTRS_OWNER_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Cc ty chn ca ph trch th (v d: <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Cc ty chn trch nhim th (v d:<OTRS_RESPONSIBLE_UserFirstname>).',
        'Ticket selected for bulk action!' => 'Th  c chn cho lnh l',
        'Ticket unlock!' => 'Th m!',
        'Ticket-Area' => 'Khu vc th',
        'TicketFreeText' => 'Ni dung th',
        'TicketZoom' => 'Phng i th',
        'Tickets shown' => 'Cc th hin th',
        'Timeover' => 'Ht thi gian',
        'Times' => 'Ln',
        'Title of the stat.' => 'Tiu  thng k.',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Ly thuc tnh bi vit (v d: (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).',
        'Top of Page' => 'Хu trang',
        'Total hits' => 'Tng s lt bm',
        'U' => 'U',
        'Unable to parse Online Repository index document!' => 'Khng th phn tch ti liu ch mc Kho cha trc tuyn!',
        'Uniq' => 'Duy nht',
        'Unlock Tickets' => 'Cc th m',
        'Unsubscribe' => 'Khng xc nhn',
        'Use utf-8 it your database supports it!' => 'Hy dng utf-8 nu c s d liu ca bn c h tr!',
        'Useable options' => 'Cc ty chn c th s dng',
        'User Management' => 'Qun tr ng߶i dng',
        'User will be needed to handle tickets.' => 'Ng߶i dng s cn iu khin th.',
        'User-Name' => 'Tn ng nhp',
        'User-Number' => 'S ng߶i dng',
        'Users' => 'Ng߶i dng',
        'Users <-> Groups' => 'Ng߶i dng <-> Nhm',
        'Users <-> Groups Management' => 'Ng߶i dng <-> Qun tr nhm',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Lu ! Cc th ny s b g b khi c s d liu! Cc th ny s b mt!',
        'Web-Installer' => 'Ng߶i ci t web',
        'Welcome to OTRS' => 'Cho mng bn n vi OTRS',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'Яi vi thng k khng hp l, khng kh thi  sinh thng k.',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'Vi cc tr߶ng u vo v  chn bn c th cu hnh thng k theo yu cu. Vi cc thnh t ca mt thng k bn c th sa ty theo ng߶i qun tr thng k   cu hnh',
        'Workflow Groups' => 'Cc nhm Dng cng vic',
        'Yes means, send no agent and customer notifications on changes.' => 'C, ngha l, khng gi thng bo cho nhn vin v khch hng no v cc thay i.',
        'Yes, save it with name' => 'C, lu vi cng mt tn',
        'You got new message!' => 'Bn c tin nhn mi!',
        'You have to select two or more attributes from the select field!' => 'Bn phi chn 2 hay nhiu thuc tnh t tr߶ng  chn!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Bn cn a ch email trong tr߶ng Ti (v d: kunde@example.com)!',
        'You need min. one selected Ticket!' => 'Bn cn ti thiu 1 th c chn!',
        'You need to account time!' => 'Bn cn ti thi gian ti khon!',
        'You need to activate %s first to use it!' => '%s cn c kch hot ln u tin  s dng!',
        'You use the DELETE option! Take care, all deleted Tickets are lost!!!' => 'Bn s dng ty chn Xa! Hy cn thn, tt c cc th xa s b mt!',
        'Your email address is new' => 'иa ch email ca bn l mi',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Email ca bn vi s th "<OTRS_TICKET>" c chuyn ti "<OTRS_BOUNCE_TO>". Hy lin h vi a ch ny  c thm thng tin.',
        'Your own Ticket' => 'Th ca bn',
        'customer realname' => 'tn thc khch hng',
        'down' => 'xung',
        'false' => 'Li',
        'for agent firstname' => 'cho h (tn) ca nhn vin',
        'for agent lastname' => 'tn nhn vin',
        'for agent login' => 'cho nhn vin ng nhp',
        'for agent user id' => 'i vi m ng߶i dng nhn vin',
        'kill all sessions' => 'xa tt c cc phin',
        'kill session' => 'xa phin',
        'modified' => ' chnh sa',
        'new ticket' => 'th mi',
        'next step' => 'b߾c tip theo',
        'not rated' => 'cha xp hng',
        'not verified' => 'cha c xc nhn',
        'read' => 'c',
        'send' => 'gi',
        'sort downward' => 'sp xp theo h߾ng gim',
        'sort upward' => 'sp xp theo h߾ng tng',
        'tmp_lock' => 'kha_tmp',
        'to get the first 20 character of the subject' => ' ly 20 k t u tin ca tiu ',
        'to get the first 5 lines of the email' => ' ly 5 dng u tin ca email',
        'to get the from line of the email' => ' ly t dng email',
        'to get the realname of the sender (if given)' => ' ly tn thc ca ng߶i gi (nu c)',
        'unknown' => 'cha xc nh',
        'unread' => 'cha c',
        'up' => 'ln',
        'verified' => 'xc nhn',
        'x' => 'x',
        'your MySQL DB should have a root password! Default is empty!' => 'C s d liu MySQL ca bn nn c mt khu gc! Mc nh l  trng!',

    };
    # $$STOP$$
    return;
}

1;
