# --
# Kernel/Language/pt_BR.pm - provides pt_BR language translation
# Copyright (C) 2003 Gilberto Cezar de Almeida <gibalmeida at hotmail.com>
# Copyright (C) 2005 Alterado por Glaucia C. Messina (glauglauu@yahoo.com)
# Copyright (C) 2007-2010 Fabricio Luiz Machado <soprobr gmail.com>
# --
# $Id: pt_BR.pm,v 1.107 2010/12/08 10:37:22 mb Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::pt_BR;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.107 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2010-11-25 14:51:40

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%A %D %B %T %Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    # csv separator
    $Self->{Separator} = ';';

    $Self->{Translation} = {

        # Template: AAABase
        'Yes' => 'Sim',
        'No' => 'No',
        'yes' => 'sim',
        'no' => 'no',
        'Off' => 'Desligado',
        'off' => 'desligado',
        'On' => 'Ligado',
        'on' => 'ligado',
        'top' => 'incio',
        'end' => 'fim',
        'Done' => 'Feito',
        'Cancel' => 'Cancelar',
        'Reset' => 'Reiniciar',
        'last' => 'ltimo',
        'before' => 'antes',
        'day' => 'dia',
        'days' => 'dias',
        'day(s)' => 'dia(s)',
        'hour' => 'hora',
        'hours' => 'horas',
        'hour(s)' => 'hora(s)',
        'Hours' => '',
        'minute' => 'minuto',
        'minutes' => 'minutos',
        'minute(s)' => 'minuto(s)',
        'Minutes' => '',
        'month' => 'ms',
        'months' => 'meses',
        'month(s)' => 'ms(s)',
        'week' => 'semana',
        'week(s)' => 'semana(s)',
        'year' => 'ano',
        'years' => 'anos',
        'year(s)' => 'ano(s)',
        'second(s)' => 'segundo(s)',
        'seconds' => 'segundos',
        'second' => 'segundo',
        'wrote' => 'escreveu',
        'Message' => 'Mensagem',
        'Error' => 'Erro',
        'Bug Report' => 'Relatrio de Erros',
        'Attention' => 'Ateno',
        'Warning' => 'Aviso',
        'Module' => 'Mdulo',
        'Modulefile' => 'Arquivo de Mdulo',
        'Subfunction' => 'Subfuno',
        'Line' => 'Linha',
        'Setting' => 'Configurao',
        'Settings' => 'Configuraes',
        'Example' => 'Exemplo',
        'Examples' => 'Exemplos',
        'valid' => 'vlido',
        'invalid' => 'invlido',
        '* invalid' => '* invlido',
        'invalid-temporarily' => 'invlido-temporariamente',
        ' 2 minutes' => ' 2 minutos',
        ' 5 minutes' => ' 5 minutos',
        ' 7 minutes' => ' 7 minutos',
        '10 minutes' => '10 minutos',
        '15 minutes' => '15 minutos',
        'Mr.' => 'Sr.',
        'Mrs.' => 'Sra.',
        'Next' => 'Prximo',
        'Back' => 'Voltar',
        'Next...' => 'Prximo',
        '...Back' => '...Voltar',
        '-none-' => 'vazio',
        'none' => 'vazio',
        'none!' => 'vazio!',
        'none - answered' => 'vazio  - respondido',
        'please do not edit!' => 'Por favor, no edite!',
        'Need Action' => '',
        'AddLink' => 'Adicionar link',
        'Link' => 'Vincular',
        'Unlink' => 'Desvincular',
        'Linked' => 'Vinculado',
        'Link (Normal)' => 'Vincular (Normal)',
        'Link (Parent)' => 'Vincular (Pai)',
        'Link (Child)' => 'Vincular (Filho)',
        'Normal' => '',
        'Parent' => 'Pai',
        'Child' => 'Filho',
        'Hit' => 'Acesso',
        'Hits' => 'Acessos',
        'Text' => 'Texto',
        'Standard' => '',
        'Lite' => 'Simples',
        'User' => 'Usurio',
        'Username' => 'Login',
        'Language' => 'Idioma',
        'Languages' => 'Idiomas',
        'Password' => 'Senha',
        'Preferences' => 'Preferncias',
        'Salutation' => 'Tratamento (Sr./Sra)',
        'Salutations' => 'Tratamentos (Sr./Sra.)',
        'Signature' => 'Assinatura',
        'Signatures' => 'Assinaturas',
        'Customer' => 'Cliente',
        'CustomerID' => 'ID.do Cliente',
        'CustomerIDs' => 'IDs do Cliente',
        'customer' => 'cliente',
        'agent' => 'agente',
        'system' => 'sistema',
        'Customer Info' => 'Informao do Cliente',
        'Customer Information' => '',
        'Customer Company' => 'Empresa Cliente',
        'Customer Companies' => '',
        'Company' => 'Empresa',
        'go!' => 'ir!',
        'go' => 'ir',
        'All' => 'Todos',
        'all' => 'todos',
        'Sorry' => 'Desculpe',
        'update!' => 'atualizar!',
        'update' => 'atualizar',
        'Update' => 'Atualizar',
        'Updated!' => 'Atualizado!',
        'submit!' => 'Enviar!',
        'submit' => 'enviar',
        'Submit' => 'Enviar',
        'change!' => 'alterar!',
        'Change' => 'Alterar',
        'change' => 'alterar',
        'click here' => 'clique aqui',
        'Comment' => 'Comentrio',
        'Valid' => 'Vlido',
        'Invalid Option!' => 'Opo Invlida',
        'Invalid time!' => 'Hora Invlida',
        'Invalid date!' => 'Data Invlida',
        'Name' => 'Nome',
        'Group' => 'Grupo',
        'Description' => 'Descrio',
        'description' => 'descrio',
        'Theme' => 'Tema',
        'Created' => 'Criado',
        'Created by' => 'Criado por',
        'Changed' => 'Alterado',
        'Changed by' => 'Alterado por',
        'Search' => 'Buscar',
        'and' => 'e',
        'between' => 'entre',
        'Fulltext Search' => 'Busca por texto completo',
        'Data' => 'Dado',
        'Options' => 'Opes',
        'Title' => 'Ttulo',
        'Item' => '',
        'Delete' => 'Excluir',
        'Edit' => 'Editar',
        'View' => 'Ver',
        'Number' => 'Nmero',
        'System' => 'Sistema',
        'Contact' => 'Contato',
        'Contacts' => 'Contatos',
        'Export' => 'Exportar',
        'Up' => 'Acima',
        'Down' => 'Abaixo',
        'Add' => 'Adicionar',
        'Added!' => 'Adicionado!',
        'Category' => 'Categoria',
        'Viewer' => 'Visualizao',
        'Expand' => 'Expandir',
        'Small' => '',
        'Medium' => '',
        'Large' => '',
        'Date picker' => '',
        'New message' => 'Nova mensagem',
        'New message!' => 'Nova mensagem!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Por favor, responda este(s) chamado(s) para retornar  visualizao da fila!',
        'You have %s new message(s)!' => 'Voc tem %s nova(s) mensagem(s)!',
        'You have %s reminder ticket(s)!' => 'Voc tem %s chamado(s) remanescente(s)',
        'The recommended charset for your language is %s!' => 'O conjunto de caracteres recomendado para o seu idioma  %s!',
        'Change your password.' => '',
        'Please activate %s first!' => '',
        'No suggestions' => 'Sem sugestes',
        'Word' => 'Palavra',
        'Ignore' => 'Ignorar',
        'replace with' => 'substituir por',
        'There is no account with that login name.' => 'No existe conta com este nome de usurio',
        'Login failed! Your user name or password was entered incorrectly.' => '',
        'There is no acount with that user name.' => '',
        'Please contact your administrator' => '',
        'Logout' => 'Sair',
        'Logout successful. Thank you for using OTRS!' => 'Logout efetuado com sucesso. Obrigado por utilizar o OTRS!',
        'Invalid SessionID!' => 'ID de Sesso Invlida',
        'Feature not active!' => 'Funo no ativada!',
        'Agent updated!' => '',
        'Create Database' => '',
        'System Settings' => 'Configuraes Sistema',
        'Mail Configuration' => '',
        'Finished' => 'Finalizado',
        'Login is needed!' => 'Login  obrigatrio!',
        'Password is needed!' => 'Senha  obrigatria!',
        'License' => 'Licena',
        'Take this Customer' => 'Atenda este Cliente',
        'Take this User' => 'Atenda este Usurio',
        'possible' => 'possvel',
        'reject' => 'rejeitar',
        'reverse' => 'reverso',
        'Facility' => 'Facilidade',
        'Time Zone' => '',
        'Pending till' => 'Pendente at',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'No trabalhe com o UserID 1(Conta do Sistema)! Crie novos usurios!',
        'Dispatching by email To: field.' => 'Despachar pelo campo "Para:"',
        'Dispatching by selected Queue.' => 'Despachar pela fila selecionada.',
        'No entry found!' => 'No h entradas!',
        'Session has timed out. Please log in again.' => 'Tempo esgotado de sesso. Entre novamente.',
        'No Permission!' => 'Sem permisso!',
        'To: (%s) replaced with database email!' => 'PARA: (%s)  alterado!',
        'Cc: (%s) added database email!' => 'CC: (%s) adicionado! ',
        '(Click here to add)' => '(Clique aqui para adicionar)',
        'Preview' => 'Visualizar',
        'Package not correctly deployed! You should reinstall the Package again!' => 'O pacote no foi instalado coretamente! Voc deve reinstal-lo!',
        '%s is not writable!' => '%s  somente leitura!',
        'Cannot create %s!' => 'No foi possvel criar %s!',
        'Customer %s added' => '',
        'Role added!' => '',
        'Role updated!' => '',
        'Attachment added!' => '',
        'Attachment updated!' => '',
        'Response added!' => '',
        'Response updated!' => '',
        'Group updated!' => '',
        'Queue added!' => '',
        'Queue updated!' => '',
        'State added!' => '',
        'State updated!' => '',
        'Type added!' => '',
        'Type updated!' => '',
        'Customer updated!' => '',
        'Contract' => 'Contrato',
        'Online Customer: %s' => 'Clientes Online: %s',
        'Online Agent: %s' => 'Agentes Online: %s',
        'Calendar' => 'Calendrio',
        'File' => 'Arquivo',
        'Filename' => 'Nome Arquivo',
        'Type' => 'Tipo',
        'Size' => 'Tam',
        'Upload' => '',
        'Directory' => 'Diretrio',
        'Signed' => 'Assinado',
        'Sign' => 'Assinar',
        'Crypted' => 'Criptografado',
        'Crypt' => 'Criptografar',
        'PGP' => '',
        'PGP Key' => '',
        'PGP Keys' => '',
        'S/MIME' => '',
        'S/MIME Certificate' => '',
        'S/MIME Certificates' => '',
        'Office' => 'Escritrio',
        'Phone' => 'Telefone',
        'Fax' => '',
        'Mobile' => 'Celular',
        'Zip' => 'CEP',
        'City' => 'Cidade',
        'Street' => 'Rua',
        'Country' => 'Pas',
        'Location' => 'Locao',
        'installed' => 'instalado',
        'uninstalled' => 'desinstalado',
        'Security Note: You should activate %s because application is already running!' => '',
        'Unable to parse repository index document.' => '',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => '',
        'No packages, or no new packages, found in selected repository.' => '',
        'Edit the system configuration settings.' => '',
        'printed at' => 'impresso em',
        'Loading...' => '',
        'Dear Mr. %s,' => 'Caro Sr. %s',
        'Dear Mrs. %s,' => 'Caro Sra. %s',
        'Dear %s,' => 'Caro %s',
        'Hello %s,' => 'Ol %s',
        'This email address already exists. Please log in or reset your password.' => '',
        'New account created. Sent login information to %s. Please check your email.' => '',
        'Please press Back and try again.' => 'Por favor, pressione Voltar e tente novamente.',
        'Sent password reset instructions. Please check your email.' => '',
        'Sent new password to %s. Please check your email.' => '',
        'Upcoming Events' => 'Prximos Eventos',
        'Event' => 'Evento',
        'Events' => 'Eventos',
        'Invalid Token!' => 'Token Invlido!',
        'more' => 'mais',
        'For more info see:' => 'Para maiores informaes veja:',
        'Package verification failed!' => 'A verificao do pacote falhou!',
        'Collapse' => 'Recolher',
        'Shown' => '',
        'News' => 'Notcias',
        'Product News' => 'Notcias do Produto',
        'OTRS News' => '',
        '7 Day Stats' => '',
        'Bold' => 'Negrito',
        'Italic' => 'Itlico',
        'Underline' => 'Sublinhado',
        'Font Color' => 'Cor da Fonte',
        'Background Color' => 'Cor de Fundo',
        'Remove Formatting' => 'Remover Formatao',
        'Show/Hide Hidden Elements' => 'Mostrar/Esconder Elementos Ocultos',
        'Align Left' => 'Alinhar  Esquerda',
        'Align Center' => 'Alinhar ao Centro',
        'Align Right' => 'Alinhar  Direita',
        'Justify' => 'Justificar',
        'Header' => 'Cabealho',
        'Indent' => 'Indentar',
        'Outdent' => 'Desindentar',
        'Create an Unordered List' => 'Criar uma Lista No Ordenada',
        'Create an Ordered List' => 'Criar uma Lista Ordenada',
        'HTML Link' => 'Link HTML',
        'Insert Image' => 'Inserir Imagem',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => 'Desfazer',
        'Redo' => 'Refazer',

        # Template: AAAMonth
        'Jan' => '',
        'Feb' => 'Fev',
        'Mar' => '',
        'Apr' => 'Abr',
        'May' => 'Mai',
        'Jun' => '',
        'Jul' => '',
        'Aug' => 'Ago',
        'Sep' => 'Set',
        'Oct' => 'Out',
        'Nov' => '',
        'Dec' => 'Dez',
        'January' => 'Janeiro',
        'February' => 'Fevereiro',
        'March' => 'Maro',
        'April' => 'Abril',
        'May_long' => 'Maio',
        'June' => 'Junho',
        'July' => 'Julho',
        'August' => 'Agosto',
        'September' => 'Setembro',
        'October' => 'Outubro',
        'November' => 'Novembro',
        'December' => 'Dezembro',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Preferncias atualizadas com sucesso!',
        'User Profile' => '',
        'Email Settings' => '',
        'Other Settings' => '',
        'Change Password' => 'Trocar senha',
        'Current Password' => '',
        'New password' => 'Nova senha',
        'Verify password' => '',
        'Spelling Dictionary' => 'Dicionrio (Lngua)',
        'Default spelling dictionary' => '',
        'Max. shown Tickets a page in Overview.' => 'Max. Chamados em uma tela.',
        'The current password is not correct. Please try again!' => '',
        'Can\'t update password, your new passwords do not match. Please try again!' => '',
        'Can\'t update password, it contains invalid characters!' => '',
        'Can\'t update password, it must be at least %s characters long!' => '',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => '',
        'Can\'t update password, it must contain at least 1 digit!' => '',
        'Can\'t update password, it must contain at least 2 characters!' => '',
        'Can\'t update password, this password has already been used. Please choose a new one!' => '',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => '',
        'CSV Separator' => '',

        # Template: AAAStats
        'Stat' => 'Status',
        'Sum' => '',
        'Please fill out the required fields!' => 'Por favor, preencha os campos obrigatrios!',
        'Please select a file!' => 'Por favor, selecione um arquivo!',
        'Please select an object!' => 'Por favor, selecione um objeto!',
        'Please select a graph size!' => 'Por favor, selecione o tamanho do grfico!',
        'Please select one element for the X-axis!' => 'Por favor, selecione um elemento do eixo X!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Por favor, selecione somente um elemento ou desmarque o boto \'Fixo\' onde o campo selecionado est marcado!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Se voc utiliza um checkbox, deves selecionar alguns atributos no campo \'selecionar\'!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Por favor, insira um valor no campo selecionado ou desmarque a checkbox \'Fixo\'!',
        'The selected end time is before the start time!' => 'A data final  anterior  data inicial!',
        'You have to select one or more attributes from the select field!' => 'Voc deve selecionar ao menos um atributo no campo \'selecionar\'!',
        'The selected Date isn\'t valid!' => 'A data selecionada  invlida!',
        'Please select only one or two elements via the checkbox!' => 'Por favor, selecione apenas um ou dois elementos atravs da checkbox!',
        'If you use a time scale element you can only select one element!' => 'Se voc usa um elemento como parmetro de tempo, deves selecionar apenas um elemento!',
        'You have an error in your time selection!' => 'Voc tem um erro na hora selecionada!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'O intervalo de tempo para o aviso  muito pequeno, por favor, utilize um perodo maior!',
        'The selected start time is before the allowed start time!' => 'A data inicial selecionada  anterior  permitida!',
        'The selected end time is after the allowed end time!' => 'A data final selecionada  posterior  permitida!',
        'The selected time period is larger than the allowed time period!' => 'O perodo de tempo selecionado  maior do que o permitido!',
        'Common Specification' => 'Especificao Comum',
        'X-axis' => 'Eixo X',
        'Value Series' => 'Sequncia de Valores',
        'Restrictions' => 'Restries',
        'graph-lines' => 'grfico de linhas',
        'graph-bars' => 'grfico de barras',
        'graph-hbars' => 'grfico de barras\(2\)',
        'graph-points' => 'grfico de pontos',
        'graph-lines-points' => 'grfico de linhas e pontos',
        'graph-area' => 'grfico de rea',
        'graph-pie' => 'grfico de pizza',
        'extended' => 'extendido',
        'Agent/Owner' => 'Agente/Proprietrio',
        'Created by Agent/Owner' => 'Criado pelo Agente/Proprietrio',
        'Created Priority' => 'Prioridade de Criao',
        'Created State' => 'Status de Criao',
        'Create Time' => 'Horrio de Criao',
        'CustomerUserLogin' => 'Usurio do Cliente',
        'Close Time' => 'Horrio de Fechamento',
        'TicketAccumulation' => 'Acumulao de Chamado',
        'Attributes to be printed' => 'Atributos a serem impressos',
        'Sort sequence' => 'Sequncia de ordenao',
        'Order by' => 'Ordenar por',
        'Limit' => 'Limite',
        'Ticketlist' => 'ListaChamado',
        'ascending' => 'ascendente',
        'descending' => 'descendente',
        'First Lock' => 'Primeiro Bloqueio',
        'Evaluation by' => 'Avaliado por',
        'Total Time' => 'Tempo Total',
        'Ticket Average' => 'Mdia de Chamados',
        'Ticket Min Time' => 'Horrio Mnimo dos Chamados',
        'Ticket Max Time' => 'Horrio Mximo dos Chamados',
        'Number of Tickets' => 'Nmero de Chamados',
        'Article Average' => 'Mdia des Histricos',
        'Article Min Time' => 'Horrio Mnimo dos Artigos',
        'Article Max Time' => 'Horrio Mximo dos Artigos',
        'Number of Articles' => 'Nmero de Histricos',
        'Accounted time by Agent' => 'Tempo contabilizado por Agente',
        'Ticket/Article Accounted Time' => 'Tempo contabilizado por Chamado/Artigo',
        'TicketAccountedTime' => 'TempoContabilizadoChamado',
        'Ticket Create Time' => 'Horrio de Criao do Chamado',
        'Ticket Close Time' => 'Horrio de Fechamento do Chamado',

        # Template: AAATicket
        'Status View' => '',
        'Bulk' => '',
        'Lock' => 'Bloquear',
        'Unlock' => 'Desbloquear',
        'History' => 'Histrico',
        'Zoom' => 'Detalhes',
        'Age' => 'Idade',
        'Bounce' => 'Devolver',
        'Forward' => 'Encaminhar',
        'From' => 'De',
        'To' => 'Para',
        'Cc' => 'Cpia ',
        'Bcc' => 'Cpia Oculta',
        'Subject' => 'Assunto',
        'Move' => 'Mover',
        'Queue' => 'Fila',
        'Queues' => 'Filas',
        'Priority' => 'Prioridade',
        'Priorities' => '',
        'Priority Update' => 'Atualizar Prioridade',
        'SLA' => '',
        'Service Level Agreement' => '',
        'Service Level Agreements' => '',
        'Service' => 'Servio',
        'Services' => '',
        'State' => 'Status',
        'States' => '',
        'Status' => '',
        'Statuses' => '',
        'Ticket Type' => '',
        'Ticket Types' => '',
        'Compose' => 'Compor',
        'Pending' => 'Pendente',
        'Owner' => 'Proprietrio',
        'Owner Update' => 'Atualizao do Proprietrio',
        'Responsible' => 'Responsvel',
        'Responsible Update' => 'Atualizao do Responsvel',
        'Sender' => 'Remetente',
        'Article' => 'Artigo',
        'Ticket' => 'Chamado',
        'Createtime' => 'Hora de criao',
        'plain' => 'texto',
        'Email' => 'E-mail',
        'email' => 'mail',
        'Close' => 'Fechar',
        'Action' => 'Ao',
        'Attachment' => 'Anexo',
        'Attachments' => 'Anexos',
        'This message was written in a character set other than your own.' => 'Esta mensagem foi escrita utilizando um conjunto de caracteres diferente do seu.',
        'If it is not displayed correctly,' => 'Se ele no for exibido corretamente,',
        'This is a' => 'Este  um',
        'to open it in a new window.' => 'para abri-lo em uma nova janela.',
        'This is a HTML email. Click here to show it.' => 'Este e-mail est em formato HTML. Clique aqui para exibi-lo.',
        'Free Fields' => 'Campos Livres',
        'Merge' => 'Agrupar',
        'merged' => 'agrupado',
        'closed successful' => 'fechado com xito',
        'closed unsuccessful' => 'fechado sem xito',
        'Locked Tickets Total' => '',
        'Locked Tickets Reminder Reached' => '',
        'Locked Tickets New' => '',
        'Responsible Tickets Total' => '',
        'Responsible Tickets New' => '',
        'Responsible Tickets Reminder Reached' => '',
        'Watched Tickets Total' => '',
        'Watched Tickets New' => '',
        'Watched Tickets Reminder Reached' => '',
        'new' => 'novo',
        'open' => 'aberto',
        'Open' => 'Aberto',
        'closed' => 'fechado',
        'Closed' => 'Fechado',
        'removed' => 'removido',
        'pending reminder' => 'lembrete de pendente',
        'pending auto' => 'pendente auto',
        'pending auto close+' => 'pendente auto fechamento+',
        'pending auto close-' => 'pendente auto fechamento-',
        'email-external' => 'email-externo',
        'email-internal' => 'email-interno',
        'note-external' => 'nota-externa',
        'note-internal' => 'nota-interna',
        'note-report' => 'nota-relatrio',
        'phone' => 'fone',
        'sms' => '',
        'webrequest' => 'Solicitar via web',
        'lock' => 'bloquear',
        'unlock' => 'desbloquear',
        'very low' => 'muito baixo',
        'low' => 'baixo',
        'normal' => '',
        'high' => 'alto',
        'very high' => 'muito alto',
        '1 very low' => '1 muito baixo',
        '2 low' => '2 baixo',
        '3 normal' => '',
        '4 high' => '4 alto',
        '5 very high' => '5 muito alto',
        'Ticket "%s" created!' => 'Chamado "%s" criado!',
        'Ticket Number' => 'N Chamado',
        'Ticket Object' => 'Objeto Chamado',
        'No such Ticket Number "%s"! Can\'t link it!' => 'No existe o Chamado "%s"! No foi possvel "link-lo"',
        'Don\'t show closed Tickets' => 'No mostrar chamados fechados',
        'Show closed Tickets' => 'Mostrar chamados fechados',
        'New Article' => 'Novo Artigo',
        'Unread article(s) available' => '',
        'Remove from list of watched tickets' => '',
        'Add to list of watched tickets' => '',
        'Email-Ticket' => 'Chamado por E-Mail',
        'Create new Email Ticket' => 'Criar novo Chamado por E-mail',
        'Phone-Ticket' => 'Chamado por Fone',
        'Search Tickets' => 'Pesquisar Chamados',
        'Edit Customer Users' => 'Editar Usurios Clientes',
        'Edit Customer Company' => 'Editar Empresa Cliente',
        'Bulk Action' => 'Mltipla Ao',
        'Bulk Actions on Tickets' => 'Mltipla Ao nos Chamados',
        'Send Email and create a new Ticket' => 'Enviar mail e criar novo Chamado',
        'Create new Email Ticket and send this out (Outbound)' => 'Criar novo Chamado por E-Mail e envi-lo (Sainte)',
        'Create new Phone Ticket (Inbound)' => 'Criar novo Chamado por Fone (Entrante)',
        'Overview of all open Tickets' => 'Viso geral de todos Chamados abertos',
        'Locked Tickets' => 'Chamados Bloqueados',
        'My Locked Tickets' => '',
        'My Watched Tickets' => '',
        'My Responsible Tickets' => '',
        'Watched Tickets' => 'Chamados Monitorados',
        'Watched' => 'Monitorado',
        'Watch' => '',
        'Unwatch' => '',
        'Lock it to work on it!' => 'Bloquear para trabalhar com o Chamado!',
        'Unlock to give it back to the queue!' => 'Desbloqueie para envi-lo devolta  fila!',
        'Shows the ticket history!' => 'Mostrar histrico do Chamado',
        'Print this ticket!' => 'Imprimir este Chamado!',
        'Change the ticket priority!' => 'Alterar a prioridade do Chamado!',
        'Change the ticket free fields!' => 'Alterar os campos livres no Chamado!',
        'Link this ticket to an other objects!' => 'Vincular este Chamado com outros objetos!',
        'Change the ticket owner!' => 'Alterar proprietrio do Chamado!',
        'Change the ticket customer!' => 'Alterar o cliente do Chamado',
        'Add a note to this ticket!' => 'Adicionar uma anotao neste Chamado!',
        'Merge this ticket!' => 'Agrupar este chamado!',
        'Set this ticket to pending!' => 'Marcar este Chamado como Pendente!',
        'Close this ticket!' => 'Feche este chamado!',
        'Look into a ticket!' => 'Olhe contedo de um chamado!',
        'Delete this ticket!' => 'Apague este Chamado!',
        'Mark as Spam!' => 'Marque como Spam',
        'My Queues' => 'Minhas Filas',
        'Shown Tickets' => 'Mostrar Chamados',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'A sua mensagem com o chamado nmero "<OTRS_TICKET>" foi agrupado com o chamado nmero "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => 'Chamado %s: tempo de resposta expirou (%s) ',
        'Ticket %s: first response time will be over in %s!' => 'Chamado %s: tempo de resposta expirar em (%s) ',
        'Ticket %s: update time is over (%s)!' => 'Chamado %s: tempo de atualizao expirou (%s) ',
        'Ticket %s: update time will be over in %s!' => 'Chamado %s: tempo de atualizao expirar em (%s) ',
        'Ticket %s: solution time is over (%s)!' => 'Chamado %s: tempo de soluo expirou (%s) ',
        'Ticket %s: solution time will be over in %s!' => 'Chamado %s: tempo de soluo expirar em (%s) ',
        'There are more escalated tickets!' => 'No h mais chamados escalados',
        'Plain Format' => '',
        'Reply All' => '',
        'Direction' => '',
        'Agent (All with write permissions)' => '',
        'Agent (Owner)' => '',
        'Agent (Responsible)' => '',
        'New ticket notification' => 'Notificao de novo Chamado',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Envie-me uma notificao se houver um novo chamado em "Minhas Filas".',
        'Send new ticket notifications' => '',
        'Ticket follow up notification' => '',
        'Ticket lock timeout notification' => 'Notificao de bloqueio por tempo expirado',
        'Send me a notification if a ticket is unlocked by the system.' => 'Notifique-me se um Chamado for desbloqueado pelo sistema.',
        'Send ticket lock timeout notifications' => '',
        'Ticket move notification' => '',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Notifique-me se um Chamado for movido para "Minhas Filas"',
        'Send ticket move notifications' => '',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Suas filas favoritas. Voc tambm ser notificado sobre estas filas via e-mail se habilitado.',
        'Custom Queue' => 'Fila Personalizada',
        'QueueView refresh time' => 'Tempo de atualizao das Filas',
        'If enabled, the QueueView will automatically refresh after the specified time.' => '',
        'Refresh QueueView after' => '',
        'Screen after new ticket' => 'Tela aps novo chamado',
        'Show this screen after I created a new ticket' => '',
        'Closed Tickets' => 'Chamados Fechados',
        'Show closed tickets.' => 'Mostrar chamados fechados.',
        'Max. shown Tickets a page in QueueView.' => 'N mximo de chamados mostrados por pgina.',
        'Ticket Overview "Small" Limit' => '',
        'Ticket limit per page for Ticket Overview "Small"' => '',
        'Ticket Overview "Medium" Limit' => '',
        'Ticket limit per page for Ticket Overview "Medium"' => '',
        'Ticket Overview "Preview" Limit' => '',
        'Ticket limit per page for Ticket Overview "Preview"' => '',
        'Ticket watch notification' => '',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => '',
        'Send ticket watch notifications' => '',
        'Out Of Office Time' => '',
        'New Ticket' => 'Novo Chamado',
        'Create new Ticket' => 'Criar novo Chamado',
        'Customer called' => 'O Cliente Telefonou',
        'phone call' => 'Chamada Telefnica',
        'Phone Call Outbound' => '',
        'Reminder Reached' => 'Lembrete Expirado',
        'Reminder Tickets' => 'Chamados com Lembrete',
        'Escalated Tickets' => 'Chamados Escalados',
        'New Tickets' => 'Chamados Novos',
        'Open Tickets / Need to be answered' => 'Chamados Abertos / Precisam ser respondidos ',
        'All open tickets, these tickets have already been worked on, but need a response' => '',
        'All new tickets, these tickets have not been worked on yet' => '',
        'All escalated tickets' => '',
        'All tickets with a reminder set where the reminder date has been reached' => '',
        'History::Move' => 'Chamado foi movido para a Fila "%s" (%s) vinda da Fila "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'Novo Chamado  [%s] foi criado (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp for [%s]. %s',
        'History::SendAutoReject' => 'Rejeio automtica enviada para "%s".',
        'History::SendAutoReply' => 'Auto Resposta enviada para "%s".',
        'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
        'History::Forward' => 'Forwarded to "%s".',
        'History::Bounce' => 'Bounced to "%s".',
        'History::SendAnswer' => 'Email enviado para "%s".',
        'History::SendAgentNotification' => '"%s"-notificao enviada para "%s".',
        'History::SendCustomerNotification' => 'Notificao enviada para "%s".',
        'History::EmailAgent' => 'Email enviado para Cliente.',
        'History::EmailCustomer' => 'Email adicionado. %s',
        'History::PhoneCallAgent' => 'Agente telefonou para Cliente.',
        'History::PhoneCallCustomer' => 'Cliente telefonou para Service Desk SAP.',
        'History::AddNote' => 'Nota adicionada (%s)',
        'History::Lock' => 'Chamado Bloqueado.',
        'History::Unlock' => 'Chamado Desbloqueado.',
        'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Atualizado: %s',
        'History::PriorityUpdate' => 'Prioridade atualizada por "%s" (%s) to "%s" (%s).',
        'History::OwnerUpdate' => 'Novo proprietrio  "%s" (ID=%s).',
        'History::LoopProtection' => 'Proteo de Loop! Auto resposta enviada para "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Atualizado: %s',
        'History::StateUpdate' => 'Old: "%s" Novo: "%s"',
        'History::TicketFreeTextUpdate' => 'Atualizado: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Requisio do Cliente via web.',
        'History::TicketLinkAdd' => 'Adicionados links ao Chamado "%s".',
        'History::TicketLinkDelete' => 'Links do Chamado Excludos "%s".',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',
        'History::SystemRequest' => '',
        'History::ResponsibleUpdate' => '',

        # Template: AAAWeekDay
        'Sun' => 'Dom',
        'Mon' => 'Seg',
        'Tue' => 'Ter',
        'Wed' => 'Qua',
        'Thu' => 'Qui',
        'Fri' => 'Sex',
        'Sat' => 'Sab',

        # Template: AdminAttachment
        'Attachment Management' => 'Gerenciamento de Anexos',
        'Actions' => '',
        'Go to overview' => '',
        'Add attachment' => '',
        'List' => 'Listar',
        'No data found.' => '',
        'Download file' => '',
        'Delete this attachment' => '',
        'Add Attachment' => '',
        'Edit Attachment' => '',
        'This field is required.' => '',
        'or' => 'ou',

        # Template: AdminAutoResponse
        'Auto Response Management' => 'Gerenciamento de Autor Respostas',
        'Add auto response' => '',
        'Add Auto Response' => '',
        'Edit Auto Response' => '',
        'Response' => 'Resposta',
        'Auto response from' => '',
        'Reference' => '',
        'You can use the following tags' => '',
        'To get the first 20 character of the subject.' => 'Para buscar os primeiros 20 caracteres do assunto.',
        'To get the first 5 lines of the email.' => 'Para buscar as primeiras 5 linhas do e-mail.',
        'To get the realname of the sender (if given).' => 'Para buscar o nome real do remetente (se fornecido).',
        'To get the article attribute' => '',
        ' e. g.' => '',
        'Options of the current customer user data' => '',
        'Ticket owner options' => '',
        'Ticket responsible options' => '',
        'Options of the current user who requested this action' => '',
        'Options of the ticket data' => '',
        'Config options' => '',
        'Example response' => '',

        # Template: AdminCustomerCompany
        'Customer Company Management' => 'Gerenciamento de Empresa Cliente',
        'Wildcards are allowed.' => '',
        'Add customer company' => '',
        'Please enter a search term to look for customer companies.' => '',
        'Add Customer Company' => 'Adicionar Empresa Cliente',

        # Template: AdminCustomerUser
        'Customer Management' => '',
        'Add customer' => '',
        'Select' => 'Selecionar',
        'Hint' => '',
        'Customer will be needed to have a customer history and to login via customer panel.' => '',
        'Please enter a search term to look for customers.' => '',
        'Last Login' => '',
        'Add Customer' => '',
        'Edit Customer' => '',
        'This field is required and needs to be a valid email address.' => '',
        'This email address is not allowed due to the system configuration.' => '',
        'This email address failed MX check.' => '',
        'The syntax of this email address is incorrect.' => '',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => '',
        'Notice' => '',
        'This feature is disabled!' => 'Esta funcionalidade foi desabilitada!',
        'Just use this feature if you want to define group permissions for customers.' => '',
        'Enable it here!' => 'Habilite-o aqui!',
        'Search for customers (wildcards are allowed).' => '',
        'Edit Customer Default Groups' => '',
        'These groups are automatically assigned to all customers.' => '',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '',
        'Filter for Groups' => '',
        'Select the customer:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => '',
        'Search Result:' => '',
        'Customers' => '',
        'Groups' => 'Grupos',
        'No matches found.' => '',
        'Change Group Relations for Customer' => '',
        'Change Customer Relations for Group' => '',
        'Toggle %s Permission for all' => '',
        'Toggle %s permission for %s' => '',
        'Customer Default Groups:' => '',
        'No changes can be made to these groups.' => '',
        'ro' => 'somente leitura',
        'Read only access to the ticket in this group/queue.' => 'Acesso somente leitura de chamados neste grupo/fila',
        'rw' => 'leitura e escrita',
        'Full read and write access to the tickets in this group/queue.' => 'Acesso leitura e escrita de chamados neste grupo/fila',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => '',
        'Edit default services' => '',
        'Filter for Services' => '',
        'Allocate Services to Customer' => '',
        'Allocate Customers to Service' => '',
        'Toggle active state for all' => '',
        'Active' => 'Ativo',
        'Toggle active state for %s' => '',

        # Template: AdminEmail
        'Admin Notification' => 'Notificao Administrativa',
        'Send Administrative Message to Agents' => '',
        'Your message was sent to' => '',
        'Send message to users' => '',
        'Send message to group members' => '',
        'Group members need to have permission' => '',
        'Send message to role members' => '',
        'Also send to customers in groups' => '',
        'Body' => 'Corpo',
        'Send' => 'Enviar',

        # Template: AdminGenericAgent
        'Generic Agent' => '',
        'Add job' => '',
        'Last run' => 'ltima execuo',
        'Run Now!' => 'Executar Agora',
        'Delete this task' => '',
        'Run this task' => '',
        'Job Settings' => '',
        'Job name' => '',
        'Currently this generic agent job will not run automatically.' => 'No momento este agente genrico no ser executado automaticamente.',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Para habilitar a execuo automtica selecione pelo menos um valor em minutos, horas e dias!',
        'Schedule minutes' => '',
        'Schedule hours' => '',
        'Schedule days' => '',
        'Toggle this widget' => '',
        'Ticket Filter' => '',
        '(e. g. 10*5155 or 105658*)' => '(ex.: 10*5155 or 105658*)',
        '(e. g. 234321)' => '(ex.: 234321)',
        'Customer login' => '',
        '(e. g. U5150)' => '(ex.: U5150)',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => '',
        'Agent' => 'Agente',
        'Ticket lock' => '',
        'TicketFreeFields' => 'Campos livres do Chamado',
        'Create times' => '',
        'No create time settings.' => 'Ignorar horrios de criao',
        'Ticket created' => 'Chamado criado',
        'Ticket created between' => 'Chamado criado entre',
        'Close times' => '',
        'No close time settings.' => 'Ignorar horrios de fechamento',
        'Ticket closed' => 'Chamado fechado',
        'Ticket closed between' => 'Chamado fechado entre',
        'Pending times' => '',
        'No pending time settings.' => 'Ignorar horrios pendentes',
        'Ticket pending time reached' => 'Prazo de chamados pendentes expirado',
        'Ticket pending time reached between' => 'Prazo de chamados pendentes expirado entre',
        'Escalation times' => '',
        'No escalation time settings.' => 'Ignorar prazos de escalada',
        'Ticket escalation time reached' => 'Prazos de escaladas expirado',
        'Ticket escalation time reached between' => 'Prazos de escaladas expirado entre',
        'Escalation - first response time' => '',
        'Ticket first response time reached' => 'Prazo de primeira resposta expirado',
        'Ticket first response time reached between' => 'Prazo de primeira resposta expirado entre',
        'Escalation - update time' => '',
        'Ticket update time reached' => 'Prazo de atualizao expirado',
        'Ticket update time reached between' => 'Prazo de atualizao expirado entre',
        'Escalation - solution time' => '',
        'Ticket solution time reached' => 'Prazo de soluo expirado',
        'Ticket solution time reached between' => 'Prazo de soluo expirado entre',
        'Archive search option' => '',
        'Ticket Action' => '',
        'Set new service' => '',
        'Set new Service Level Agreement' => '',
        'Set new priority' => '',
        'Set new queue' => '',
        'Set new state' => '',
        'Set new agent' => '',
        'new owner' => '',
        'Set new ticket lock' => '',
        'New customer' => '',
        'New customer ID' => '',
        'New title' => '',
        'New type' => '',
        'New TicketFreeFields' => 'Novos campos livres do Chamado',
        'Archive selected tickets' => '',
        'Add Note' => 'Adicionar Anotao',
        'Time units' => 'Unidades de tempo',
        ' (work units)' => ' (unidades de trabalho)',
        'Ticket Commands' => '',
        'Send agent/customer notifications on changes' => 'Enviar notificaes de alteraes para agente/cliente',
        'CMD' => 'Comando',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Este comando ser executado. ARG[0] ser o nmero do chamado. ARG[1] o id do chamado.',
        'Delete tickets' => 'Excluir Chamados',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => '',
        'Execute Custom Module' => '',
        'Param %s key' => '',
        'Param %s value' => '',
        'Save Changes' => '',
        'Save' => 'Salvar',
        'Results' => 'Resultados',
        '%s Tickets affected! What do you want to do?' => '',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => '',
        'Edit job' => '',
        'Run job' => '',
        'Affected Tickets' => '',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '',
        'Group Management' => 'Gerenciamento de Grupos',
        'Add group' => '',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'O grupo admin  para uso na rea de administrao e o grupo stats  para uso na rea de estatsticas.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => '',
        'It\'s useful for ASP solutions. ' => '',
        'Add Group' => 'Adicionar Grupo',
        'Edit Group' => '',

        # Template: AdminLog
        'System Log' => 'Logs do Sistema',
        'Here you will find log information about your system.' => '',
        'Time' => 'Horrio',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Gerenciamento de Contas de E-Mail',
        'Add mail account' => '',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Todos os emails recebidos por uma conta sero despachados na fila selecionada!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Se a sua conta for confivel, os headers "X-OTRS" existentes na recepo (para prioridade, ...) sero utilizados! O filtro ser utilizado mesmo assim.',
        'Host' => 'Servidor',
        'Delete account' => '',
        'Fetch mail' => '',
        'Add Mail Account' => '',
        'Example: mail.example.com' => '',
        'Trusted' => 'Confivel',
        'Dispatching' => 'Despachando',
        'Edit Mail Account' => '',

        # Template: AdminNavigationBar
        'Admin' => '',
        'Agent Management' => '',
        'Queue Settings' => '',
        'Ticket Settings' => '',
        'System Administration' => '',

        # Template: AdminNotification
        'Notification Management' => 'Gerenciamento de Notificaes',
        'Filter for Language' => '',
        'Filter for Notification' => '',
        'Notifications are sent to an agent or a customer.' => 'Notificaes sero enviadas para um Agente ou Cliente.',
        'Notification' => 'Notificaes',
        'Edit Notification' => '',
        'e. g.' => '',
        'Options of the current customer data' => '',

        # Template: AdminNotificationEvent
        'Add notification' => '',
        'Delete this notification' => '',
        'Add Notification' => 'Adicionar Notificao',
        'Recipient groups' => '',
        'Recipient agents' => '',
        'Recipient roles' => '',
        'Recipient email addresses' => '',
        'Article type' => 'Tipo de artigo',
        'Only for ArticleCreate event' => '',
        'Subject match' => 'Casar Assunto',
        'Body match' => 'Casar Corpo',
        'Include attachments to notification' => '',
        'Notification article type' => '',
        'Only for notifications to specified email addresses' => '',
        'To get the first 20 character of the subject (of the latest agent article).' => 'Para buscar os primeiros 20 caracteres do assunto (do ltimo artigo do agente)',
        'To get the first 5 lines of the body (of the latest agent article).' => 'Para buscar as primeiras 5 linhas do corpo (do ltimo artigo do agente)',
        'To get the first 20 character of the subject (of the latest customer article).' => 'Para buscar os primeiros 20 caracteres do assunto (do ltimo artigo do cliente)',
        'To get the first 5 lines of the body (of the latest customer article).' => 'Para buscar as primeiras 5 linhas do corpo (do ltimo artigo do cliente)',

        # Template: AdminPGP
        'PGP Management' => 'Gerenciamento do PGP',
        'Use this feature if you want to work with PGP keys.' => '',
        'Add PGP key' => '',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Neste caso, voc pode editar diretamente o "keyring" configurado no "SysConfig".',
        'Introduction to PGP' => '',
        'Result' => 'Resultado',
        'Identifier' => 'Identificador',
        'Bit' => '',
        'Key' => 'Chave',
        'Fingerprint' => 'Impresso Digital',
        'Expires' => 'Expira',
        'Delete this key' => '',
        'Add PGP Key' => '',
        'PGP key' => '',

        # Template: AdminPackageManager
        'Package Manager' => 'Gerenciador de Pacotes',
        'Uninstall package' => '',
        'Version' => 'Verso',
        'Do you really want to uninstall this package?' => 'Voc quer realmente desinstalar este pacote?',
        'Reinstall package' => '',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => '',
        'Continue' => 'Continuar',
        'Install' => 'Instalar',
        'Install Package' => '',
        'Update repository information' => '',
        'Online Repository' => 'Repositrio On Line',
        'Vendor' => 'Fornecedor',
        'Module documentation' => 'Documentao do Mdulo',
        'Upgrade' => 'Atualizar Verso',
        'Local Repository' => 'Repositrio Local',
        'Uninstall' => 'Desinstalar',
        'Package not correctly deployed! You should reinstall the package again!' => '',
        'Reinstall' => 'Reinstalar',
        'Download package' => '',
        'Rebuild package' => '',
        'Metadata' => '',
        'Change Log' => '',
        'Date' => 'Data',
        'List of Files' => '',
        'Permission' => 'Permisses',
        'Download' => '',
        'Download file from package!' => 'Baixar arquivo do pacote!',
        'Required' => 'Obrigatrio',
        'PrimaryKey' => 'Chave Primria',
        'AutoIncrement' => 'Auto Incremental',
        'SQL' => '',
        'File differences for file %s' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Logs de Desempenho',
        'This feature is enabled!' => 'Esta funcionalidade foi habilitada!',
        'Just use this feature if you want to log each request.' => 'Use esta funcionalidade se voc quiser logar cada requisio.',
        'Activating this feature might affect your system performance!' => 'Ao ativar esta funcionalidade pode-se afetar o desempenho do seu sistema!',
        'Disable it here!' => 'Desabilite-o aqui!',
        'Logfile too large!' => 'Arquivo de log muito grande!',
        'The logfile is too large, you need to reset it' => '',
        'Overview' => 'Viso Geral',
        'Range' => 'Intervalo',
        'Interface' => 'Interface',
        'Requests' => 'Requisies',
        'Min Response' => 'Tempo mnimo de resposta',
        'Max Response' => 'Tempo mximo de resposta',
        'Average Response' => 'Mdia de tempo de resposta',
        'Period' => 'Perodo',
        'Min' => 'Mn.',
        'Max' => 'Mx.',
        'Average' => 'Mdia',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Gerenciamento de Filtros (PostMaster)',
        'Add filter' => '',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Se voc quiser casar somente o endereo de e-mail, use EMAILADDRESS:info@example.com em From, To or Cc.',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '',
        'Delete this filter' => '',
        'Add PostMaster Filter' => '',
        'Edit PostMaster Filter' => '',
        'Filter name' => '',
        'Stop after match' => 'Parar aps encontrar',
        'Filter Condition' => '',
        'Value' => 'Valor',
        'Set Email Headers' => '',

        # Template: AdminPriority
        'Priority Management' => 'Gerenciamento de Prioridade',
        'Add priority' => '',
        'Add Priority' => 'Adicionar Prioridade',
        'Edit Priority' => '',

        # Template: AdminQueue
        'Manage Queues' => '',
        'Add queue' => '',
        'Add Queue' => '',
        'Edit Queue' => '',
        'Sub-queue of' => '',
        'Unlock timeout' => 'Tempo de expirao de desbloqueio',
        '0 = no unlock' => '0 = sem desbloqueio',
        'Only business hours are counted.' => 'Somente horas teis so contadas.',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => '',
        'Notify by' => 'Notificar por',
        '0 = no escalation' => '0 = sem escalao',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => '',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => '',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => '',
        'Follow up Option' => 'Opo de continuao',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => '',
        'Ticket lock after a follow up' => 'Bloqueio do chamado aps as continuaes',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => '',
        'System address' => '',
        'Will be the sender address of this queue for email answers.' => 'Ser o endereo de email de respostas desta fila.',
        'Default sign key' => '',
        'The salutation for email answers.' => 'A saudao para as respostas de emails.',
        'The signature for email answers.' => 'A assinatura para as respostas de emails.',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => '',
        'Filter for Queues' => '',
        'Filter for Auto Responses' => '',
        'Auto Responses' => 'Auto respostas',
        'Change Auto Response Relations for Queue' => '',
        'settings' => 'configuraes',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => '',
        'Filter' => 'Filtro',
        'Filter for Responses' => '',
        'Responses' => 'Respostas',
        'Change Queue Relations for Response' => '',
        'Change Response Relations for Queue' => '',

        # Template: AdminResponse
        'Manage Responses' => '',
        'Add response' => '',
        'A response is default text to write faster answer (with default text) to customers.' => 'Uma resposta padro  um texto para responder mais rapidamente aos clientes.',
        'Don\'t forget to add a new response a queue!' => 'No se esquea de adicionar a nova resposta a uma fila!',
        'Delete this entry' => '',
        'Add Response' => '',
        'Edit Response' => '',
        'The current ticket state is' => 'O status do Chamado  ',
        'Your email address is' => '',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => '',
        'Filter for Attachments' => '',
        'Change Response Relations for Attachment' => '',
        'Change Attachment Relations for Response' => '',
        'Toggle active for all' => '',
        'Link %s to selected %s' => '',

        # Template: AdminRole
        'Role Management' => 'Gerenciamento de Papel',
        'Add role' => '',
        'Create a role and put groups in it. Then add the role to the users.' => 'Crie um papel e insira grupos nele. Aps, defina o papel aos usurios. ',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => '',
        'Add Role' => 'Adicionar Papel',
        'Edit Role' => '',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => '',
        'Filter for Roles' => '',
        'Roles' => 'Papis',
        'Select the role:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => '',
        'Change Role Relations for Group' => '',
        'Change Group Relations for Role' => '',
        'Toggle %s permission for all' => '',
        'move_into' => 'mover_para',
        'Permissions to move tickets into this group/queue.' => 'Permisses para movimento de Chamados neste grupo/fila.',
        'create' => 'criar',
        'Permissions to create tickets in this group/queue.' => 'Permisses para criar Chamados neste grupo/fila. ',
        'priority' => 'prioridade',
        'Permissions to change the ticket priority in this group/queue.' => 'Permisses para alterar o proprietrio neste grupo/fila.',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => '',
        'Filter for Agents' => '',
        'Agents' => '',
        'Manage Role-Agent Relations' => '',
        'Change Role Relations for Agent' => '',
        'Change Agent Relations for Role' => '',

        # Template: AdminSLA
        'SLA Management' => 'Gerenciamento de SLA',
        'Add SLA' => 'Adicionar SLA',
        'Edit SLA' => '',
        'Please write only numbers!' => '',

        # Template: AdminSMIME
        'S/MIME Management' => 'Gerenciamento S/MIME',
        'Add certificate' => '',
        'Add private key' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'Neste caso, voc pode editar diretamente a certificao e chaves privadas no sistema de arquivos.',
        'See also' => 'Veja tambm',
        'Hash/Fingerprint' => '',
        'Create/Expires' => '',
        'Delete this certificate' => '',
        'Add Certificate' => 'Adicionar Certificado',
        'Add Private Key' => 'Adicionar Chave Privada',
        'Secret' => 'Senha',

        # Template: AdminSalutation
        'Salutation Management' => 'Gerenciamento de Tratamento (Sr./Sra.)',
        'Add salutation' => '',
        'Add Salutation' => 'Adicionar Tratamento',
        'Edit Salutation' => '',
        'Example salutation' => '',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'Modo de Segurana ser (normalmente) ativado aps a instalao inicial.',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'Modo de Segurana deve estar desabilitado para reinstalar utilizando o instalador web.',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBox
        'SQL Box' => 'Comando SQL',
        'Here you can enter SQL to send it directly to the application database.' => '',
        'The syntax of your SQL query has a mistake. Please check it.' => '',
        'There is at least one parameter missing for the binding. Please check it.' => '',
        'Result format' => '',
        'Run Query' => '',

        # Template: AdminService
        'Service Management' => 'Gerenciamento de Servios',
        'Add service' => '',
        'Add Service' => 'Adicionar Servio',
        'Edit Service' => '',
        'Sub-service of' => '',

        # Template: AdminSession
        'Session Management' => 'Gerenciamento de Sesses',
        'All sessions' => '',
        'Agent sessions' => '',
        'Customer sessions' => '',
        'Unique agents' => '',
        'Unique customers' => '',
        'Kill all sessions' => 'Finalizar todas as sesses',
        'Session' => 'Sesso',
        'Kill' => '',
        'Kill this session' => '',
        'Detail View for SessionID' => '',

        # Template: AdminSignature
        'Signature Management' => 'Gerenciamento de Assinaturas',
        'Add signature' => '',
        'Add Signature' => 'Adicionar Assinatura',
        'Edit Signature' => '',
        'Example signature' => '',

        # Template: AdminState
        'State Management' => 'Gerenciamento de Status',
        'Add state' => '',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Tenha cuidado se voc tambm atualizou os status padro no Kernel/Config.pm!',
        'Add State' => 'Adicionar Status',
        'Edit State' => '',
        'State type' => '',

        # Template: AdminSysConfig
        'SysConfig' => 'Configurao do Sistema',
        'Navigate by searching in %s settings' => '',
        'Go to group %s' => '',
        'Group %s' => '',
        'Download all system config changes' => '',
        'Export settings' => '',
        'Load SysConfig settings from file' => '',
        'Import settings' => '',
        'Import Settings' => '',
        'Import' => 'Importar',
        'Please enter a search term to look for settings.' => '',
        'Subgroup' => 'Subgrupo',
        'Elements' => 'Elementos',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => '',
        'This config item is only available in a higher config level!' => '',
        'Reset this setting' => '',
        'Default value' => '',
        'Error: this file could not be found.' => '',
        'Error: this directory could not be found.' => '',
        'Error: an invalid value was entered.' => '',
        'Content' => 'Contedo',
        'Remove this entry' => '',
        'Add entry' => '',
        'Remove entry' => '',
        'Add new entry' => '',
        'Create new entry' => '',
        'New group' => '',
        'Group ro' => '',
        'Readonly group' => '',
        'New group ro' => '',
        'Loader' => '',
        'File to load for this frontend module' => '',
        'New Loader File' => '',
        'NavBarName' => 'Nome da Barra de Navegao',
        'NavBar' => 'Barra de Navegao',
        'LinkOption' => '',
        'Block' => 'Bloquear',
        'AccessKey' => 'Chave de Acesso',
        'Add NavBar entry' => '',
        'Year' => '',
        'Month' => '',
        'Day' => '',
        'Invalid year' => '',
        'Invalid month' => '',
        'Invalid day' => '',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'Gerenciamento dos Endereos de E-mail do Sistema',
        'Add system address' => '',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => '',
        'Email address' => '',
        'Display name' => '',
        'Add System Email Address' => '',
        'Edit System Email Address' => '',
        'The display name and email address will be shown on mail you send.' => '',

        # Template: AdminType
        'Type Management' => 'Gerenciamento de Tipos',
        'Add ticket type' => '',
        'Add Type' => 'Adicionar Tipo',
        'Edit Type' => '',

        # Template: AdminUser
        'Add agent' => '',
        'Agents will be needed to handle tickets.' => '',
        'Don\'t forget to add a new agent to groups and/or roles!' => '',
        'Please enter a search term to look for agents.' => '',
        'Last login' => '',
        'Login as' => 'Login como',
        'Switch to agent' => '',
        'Add Agent' => '',
        'Edit Agent' => '',
        'Firstname' => 'Nome',
        'Lastname' => 'Sobrenome',
        'Start' => 'Incio',
        'End' => 'Fim',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => '',
        'Change Group Relations for Agent' => '',
        'Change Agent Relations for Group' => '',
        'note' => '',
        'Permissions to add notes to tickets in this group/queue.' => '',
        'owner' => 'proprietrio',
        'Permissions to change the owner of tickets in this group/queue.' => '',

        # Template: AgentBook
        'Address Book' => 'Catlogo de Endereos',
        'Search for a customer' => '',
        'Add email address %s to the To field' => '',
        'Add email address %s to the Cc field' => '',
        'Add email address %s to the Bcc field' => '',
        'Apply' => '',

        # Template: AgentCustomerSearch
        'Search Customer' => 'Busca do cliente',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Painel',
        'Show or hide the content' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => 'em',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s est disponvel!',
        'Please update now.' => 'Favor atualizar agora.',
        'Release Note' => 'Notas da Verso',
        'Level' => 'Nvel',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Postado %s atrs.',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket was locked' => '',
        'Undo & close window' => '',

        # Template: AgentInfo
        'Info' => 'Informao',
        'To accept some news, a license or some changes.' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Vincular Objeto: %s ',
        'Close window' => '',
        'go to link delete screen' => '',
        'Select Target Object' => '',
        'Link Object' => 'Vincular Objeto',
        'with' => 'com',
        'Unlink Object: %s' => 'Desvincular Objeto: %s',
        'go to link add screen' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => '',

        # Template: AgentSpelling
        'Spell Checker' => 'Checar a Ortografia',
        'spelling error(s)' => 'erro(s) ortogrficos',
        'Apply these changes' => 'Aplicar estas modificaes',

        # Template: AgentStatsDelete
        'Delete stat' => '',
        'Stat#' => '',
        'Do you really want to delete this stat?' => '',

        # Template: AgentStatsEditRestrictions
        'Step %s' => '',
        'General Specifications' => '',
        'Select the element that will be used at the X-axis' => '',
        'Select the elements for the value series' => 'Selecione os elementos para cada conjunto de valores',
        'Select the restrictions to characterize the stat' => '',
        'Here you can make restrictions to your stat.' => 'Aqui voc pode criar as restries do seu status',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Se voc remover a seleo da caixa \'Fixado\', o Agente que gerar o status pode alterar os atributos do elemento correspondente.',
        'Fixed' => 'Fixado',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Por favor, selecione apenas um elemento ou desmarque o boto \'Fixado\'.',
        'Absolute Period' => '',
        'Between' => 'Entre',
        'Relative Period' => 'Perodo Relativo',
        'The last' => 'O ltimo',
        'Finish' => 'Finalizar',

        # Template: AgentStatsEditSpecification
        'Permissions' => 'Permisses',
        'You can select one or more groups to define access for different agents.' => '',
        'Some result formats are disabled because at least one needed package is not installed.' => '',
        'Please contact your administrator.' => '',
        'Graph size' => '',
        'If you use a graph as output format you have to select at least one graph size.' => 'Se voc utiliza um grfico como formato de sada, voc deve selecionar ao menos um tamanho de grfico.',
        'Sum rows' => 'Somar linhas',
        'Sum columns' => 'Somar colunas',
        'Use cache' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'A maioria das estatsticas podem ser mantidas em cache. Isto tornar sua visualizao mais rpida.',
        'If set to invalid end users can not generate the stat.' => '',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => '',
        'You have the possibility to select one or two elements.' => '',
        'Then you can select the attributes of elements.' => '',
        'Each attribute will be shown as single value series.' => '',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => 'Escala',
        'minimal' => 'mnimo',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Lembre que a escala para o conjunto de valores deve ser mair que o eixo X (ex.: Eixo X => Ms, Conjunto de Valores => Ano).',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '',
        'maximal period' => 'perodo mximo',
        'minimal scale' => 'perodo mnimo',

        # Template: AgentStatsImport
        'Import Stat' => '',
        'File is not a Stats config' => 'Este no  um arquivo de configurao',
        'No File selected' => 'Nenhum arquivo selecionado',

        # Template: AgentStatsOverview
        'Stats' => 'Estatsticas',
        'Object' => 'Objeto',

        # Template: AgentStatsPrint
        'Print' => 'Imprimir',
        'No Element selected.' => 'Nenhum elemento selecionado.',

        # Template: AgentStatsView
        'Export config' => '',
        'With the input and select fields you can influence the format and contents of the statistic.' => '',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => '',
        'Stat Details' => '',
        'Format' => 'Formato',
        'Graphsize' => 'Tamanho do Grfico',
        'Cache' => '',
        'Exchange Axis' => 'Trocar Eixo',
        'Configurable params of static stat' => 'Parmetros configurveis da estatstica esttica',
        'No element selected.' => 'Nenhum elemento selecionado.',
        'maximal period from' => 'perodo mximo de',
        'to' => 'para',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => '',
        'Change Owner of Ticket' => '',
        'Close Ticket' => '',
        'Add Note to Ticket' => '',
        'Set Pending' => 'Marcar Pendente',
        'Change Priority of Ticket' => '',
        'Change Responsible of Ticket' => '',
        'Cancel & close window' => '',
        'Service invalid.' => '',
        'New Owner' => 'Novo Proprietrio',
        'Please set a new owner!' => '',
        'Previous Owner' => 'Proprietrio Anterior',
        'Inform Agent' => 'Informar Agente',
        'Optional' => 'Opcional',
        'Inform involved Agents' => 'Informar os Agentes Envolvidos',
        'Spell check' => '',
        'Note type' => 'Tipo de Anotao',
        'Next state' => 'Novo Status',
        'Pending date' => 'Data da pendncia',
        'Date invalid!' => '',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => '',
        'Bounce to' => 'Devolver para',
        'You need a email address.' => '',
        'Need a valid email address or don\'t use a local email address.' => '',
        'Next ticket state' => 'Prximo status do chamado',
        'Inform sender' => 'Informe o remetente',
        'Send mail!' => 'Enviar email!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Executar Ao no Chamado',
        'Merge to' => 'Agrupar com',
        'Invalid ticket identifier!' => '',
        'Merge to oldest' => 'Agrupar com o mais antigo',
        'Link together' => 'Vincular',
        'Link to parent' => '',
        'Unlock tickets' => '',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Compr uma resposta para o chamado',
        'Need a valid email address.' => '',
        'Address book' => '',
        'Pending Date' => 'Data de Pendncia',
        'for pending* states' => 'em status pendente*',
        'Date Invalid!' => '',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Alterar o cliente do chamado',
        'Customer Data' => 'Dados do Cliente',
        'Customer user' => '',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => '',
        'From queue' => '',
        'Get all' => '',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => '',
        'Need a valid email address or don\'t use a local email address' => '',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'Histrico de',
        'History Content' => '',
        'Zoom view' => '',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Agrupar Chamado',
        'The Ticket was locked' => '',
        'You need to use a ticket number!' => 'Voc deve utilizar um nmero de chamado!',
        'A valid ticket number is required.' => '',

        # Template: AgentTicketMove
        'Move Ticket' => 'Mover Chamado',
        'New Queue' => 'Nova Fila',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => '',
        'No ticket data found.' => '',
        'First Response Time' => 'Tempo da Resposta Inicial',
        'Service Time' => 'Tempo do Servio',
        'Update Time' => 'Tempo de Atualizao',
        'Solution Time' => 'Tempo de Soluo',
        'Move ticket to a different queue' => '',
        'Change queue' => 'Alterar Fila',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => 'Alterar as oes de busca',
        'Max. shown Tickets a page' => '',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'Escalado em',
        'Locked' => 'Bloqueado',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => '',
        'From customer' => '',
        'To queue' => '',
        'Create' => 'Criar',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => 'Chamada telefnica',

        # Template: AgentTicketPlain
        'Email Text Plain View' => '',
        'Plain' => 'Texto',
        'Download this email' => '',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Informao do Chamado',
        'Accounted time' => 'Tempo contabilizado',
        'Linked-Object' => 'Objeto Vinculado',
        'by' => 'por',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'Modelo de Busca',
        'Create New' => '',
        'Create Template' => '',
        'Save changes in template' => '',
        'Add another attribute' => '',
        'Output' => 'Resultado',
        'Fulltext' => 'Texto Completo',
        'Remove' => '',
        'Customer User Login' => 'Login Usurio Cliente',
        'Time1' => '',
        'Time2' => '',
        'Time3' => '',
        'Time4' => '',
        'Time5' => '',
        'Time6' => '',
        'Created in Queue' => 'Criado na Fila',
        'Lock state' => '',
        'Watcher' => '',
        'Article Create Time (before/after)' => '',
        'Article Create Time (between)' => '',
        'Ticket Create Time (before/after)' => '',
        'Ticket Create Time (between)' => '',
        'Ticket Change Time (before/after)' => '',
        'Ticket Change Time (between)' => '',
        'Ticket Close Time (before/after)' => '',
        'Ticket Close Time (between)' => '',
        'Archive Search' => '',
        'Run Search' => '',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => '',
        'Save filter settings as default' => 'Salvar configuraes de filtro como padro',
        'Ticket Information' => '',
        'Linked Objects' => '',
        'Article(s)' => '',
        'Change Queue' => '',
        'Article Filter' => '',
        'Add Filter' => '',
        'Set' => 'Configurar',
        'Reset Filter' => '',
        'Show one article' => '',
        'Show all articles' => '',
        'Unread articles' => '',
        'No.' => '',
        'Unread Article!' => '',
        'Incoming message' => '',
        'Outgoing message' => '',
        'Internal message' => '',
        'Resize' => '',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => '',
        'Load blocked content.' => '',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => '',

        # Template: CustomerFooter
        'Powered by' => '',
        'One or more errors occurred!' => '',
        'Close this dialog' => '',
        'Could not open popup window. Please disable any popup blockers for this application.' => '',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => '',
        'User name' => '',
        'Your user name' => '',
        'Your password' => '',
        'Forgot password?' => '',
        'Log In' => '',
        'Not yet registered?' => '',
        'Sign up now' => '',
        'Request new password' => 'Solicitar uma nova senha',
        'Your User Name' => '',
        'A new password will be sent to your email address.' => '',
        'Create Account' => 'Criar Conta',
        'Please fill out this form to recieve login credentials.' => '',
        'How we should address you' => '',
        'Your First Name' => '',
        'Please supply a first name' => '',
        'Your Last Name' => '',
        'Please supply a last name' => '',
        'The User Name you wish to have' => '',
        'Please supply a' => '',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => '',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => '',

        # Template: CustomerTicketOverView
        'You have not created a ticket yet.' => '',
        'You as the customer have the ability to let us support staff people jump around as you wish because it\'s all about you.' => '',
        'We stop eating if you wish us to do.' => '',
        'Your way to communicate with us is this thing called \'ticket\'.' => '',
        'Please command us.' => '',
        'Create your first Ticket' => '',

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Profile' => 'Perfil',
        'e. g. 10*5155 or 105658*' => '',
        'Customer ID' => '',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => '',
        'Recipient' => 'Destinatrio',
        'Carbon Copy' => '',
        'Time restrictions' => '',
        'Only tickets created' => '',
        'Only tickets created between' => '',
        'Search-Profile as Template?' => '',
        'Save as Template?' => '',
        'Template Name' => '',
        'Output to' => '',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => 'de',
        'Page' => 'Pgina',
        'Search Results for' => '',

        # Template: CustomerTicketZoom
        'Loading' => '',
        'Reply' => '',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => '',
        'Previous' => '',
        'Sunday' => '',
        'Monday' => '',
        'Tuesday' => '',
        'Wednesday' => '',
        'Thursday' => '',
        'Friday' => '',
        'Saturday' => '',
        'Su' => '',
        'Mo' => '',
        'Tu' => '',
        'We' => '',
        'Th' => '',
        'Fr' => '',
        'Sa' => '',
        'Open date selection' => '',

        # Template: Error
        'Oops! An Error occurred.' => '',
        'Error Message' => '',
        'You can' => '',
        'Send a bugreport' => '',
        'go back to the previous page' => '',
        'Error Details' => '',

        # Template: Footer
        'Top of page' => '',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => '',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => '',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => '',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => '',
        'Database Settings' => '',
        'General Specifications and Mail Settings' => '',
        'Welcome to %s' => 'Bem vindo(a) ao %s',
        'Web site' => '',
        'Database check successful.' => '',
        'Mail check successful.' => '',
        'Error in the mail settings. Please correct and try again.' => '',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => '',
        'Outbound mail type' => '',
        'Select outbound mail type.' => '',
        'Outbound mail port' => '',
        'Select outbound mail port.' => '',
        'SMTP host' => '',
        'SMTP host.' => '',
        'SMTP authentication' => '',
        'Does your SMTP host need authentication?' => '',
        'SMTP auth user' => '',
        'Username for SMTP auth.' => '',
        'SMTP auth password' => '',
        'Password for SMTP auth.' => '',
        'Configure Inbound Mail' => '',
        'Inbound mail type' => '',
        'Select inbound mail type.' => '',
        'Inbound mail host' => '',
        'Inbound mail host.' => '',
        'Inbound mail user' => '',
        'User for inbound mail.' => '',
        'Inbound mail password' => '',
        'Password for inbound mail.' => '',
        'Result of mail configuration check' => '',
        'Check mail configuration' => '',
        'Skip this step' => '',

        # Template: InstallerDBResult
        'False' => '',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => '',
        'Currently only MySQL is supported in the web installer.' => '',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => '',
        'Database-User' => 'Usurio da Base',
        'New' => 'Novo',
        'A new database user with limited rights will be created for this OTRS system.' => '',
        'default \'hot\'' => 'padro \'hot\'',
        'DB--- host' => '',
        'Database' => 'Base de Dados',
        'Check database settings' => '',
        'Result of database check' => '',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Para poder utilizar o OTRS voc deve',
        'Restart your webserver' => 'Reiniciar o Webserver',
        'After doing so your OTRS is up and running.' => 'Aps isto, ento seu OTRS est funcionando.',
        'Start page' => 'Iniciar pgina',
        'Your OTRS Team' => 'Equipe Service Desk SAP',

        # Template: InstallerLicense
        'Accept license' => 'Aceitar licena',
        'Don\'t accept license' => 'No aceitar licena',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'ID do sistema',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => '',
        'System FQDN' => 'FQDN do sistema',
        'Fully qualified domain name of your system.' => '',
        'AdminEmail' => 'E-mail do Administrador',
        'Email address of the system administrator.' => '',
        'Organization' => 'Organizao',
        'Log' => '',
        'LogModule' => 'Mdulo LOG',
        'Log backend to use.' => '',
        'LogFile' => '',
        'Log file location is only needed for File-LogModule!' => '',
        'Webfrontend' => 'Interface Web',
        'Default language' => '',
        'Default language.' => '',
        'CheckMXRecord' => 'Verifique o MX',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => '',

        # Template: LinkObject
        'Object#' => '',
        'Add links' => '',
        'Delete links' => '',

        # Template: Login
        'JavaScript Not Available' => '',
        'Browser Warning' => '',
        'The browser you are using is too old.' => '',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => '',
        'Please see the documentation or ask your admin for further information.' => '',
        'Lost your password?' => 'Esqueceu sua senha?',
        'Request New Password' => '',
        'Back to login' => '',

        # Template: Motd
        'Message of the Day' => '',

        # Template: NoPermission
        'Insufficient Rights' => '',
        'Back to the previous page' => '',

        # Template: Notify

        # Template: Pagination
        'Show first page' => '',
        'Show previous pages' => '',
        'Show page %s' => '',
        'Show next pages' => '',
        'Show last page' => '',

        # Template: PictureUpload
        'Need FormID!' => '',
        'No file found!' => '',
        'The file is not an image that can be shown inline!' => '',

        # Template: PrintFooter
        'URL' => '',

        # Template: PrintHeader
        'printed by' => 'impresso por',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'Pgina de Teste do OTRS',
        'Welcome %s' => 'Bem-vindo %s',
        'Counter' => 'Contador',

        # Template: Warning
        'Go back to the previous page' => '',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => '',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => '',
        'Activates lost password feature for agents, in the agent interface.' => '',
        'Activates lost password feature for customers.' => '',
        'Activates support for customer groups.' => '',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => '',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => '',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => '',
        'Activates time accounting.' => '',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => '',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Agent Notifications' => '',
        'Agent interface article notification module to check PGP.' => '',
        'Agent interface article notification module to check S/MIME.' => '',
        'Agent interface module to access fulltext search via nav bar.' => '',
        'Agent interface module to access search profiles via nav bar.' => '',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => '',
        'Agents <-> Roles' => '',
        'Allows adding notes in the close ticket screen of the agent interface.' => '',
        'Allows adding notes in the ticket free text screen of the agent interface.' => '',
        'Allows adding notes in the ticket note screen of the agent interface.' => '',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => '',
        'Allows agents to exchange the axis of a stat if they generate one.' => '',
        'Allows agents to generate individual-related stats.' => '',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attribrutes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Attachments <-> Responses' => 'Anexos <-> Respostas',
        'Auto Responses <-> Queues' => '',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => '',
        'Change queue!' => '',
        'Change the ticket responsible!' => '',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => '',
        'Company Tickets' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => '',
        'Create and manage Service Level Agreements (SLAs).' => '',
        'Create and manage agents.' => '',
        'Create and manage attachments.' => '',
        'Create and manage companies.' => '',
        'Create and manage customers.' => '',
        'Create and manage event based notifications.' => '',
        'Create and manage groups.' => '',
        'Create and manage notifications that are sent to agents.' => '',
        'Create and manage queues.' => '',
        'Create and manage response templates.' => '',
        'Create and manage responses that are automatically sent.' => '',
        'Create and manage roles.' => '',
        'Create and manage salutations.' => '',
        'Create and manage services.' => '',
        'Create and manage signatures.' => '',
        'Create and manage ticket priorities.' => '',
        'Create and manage ticket states.' => '',
        'Create and manage ticket types.' => '',
        'Create new email ticket and send this out (outbound)' => '',
        'Create new phone ticket (inbound)' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => '',
        'Customers <-> Groups' => '',
        'Customers <-> Services' => '',
        'Data used to export the search result in CSV format.' => '',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => '',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => '',
        'Default ticket ID used by the system in the agent interface.' => '',
        'Default ticket ID used by the system in the customer interface.' => '',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => '',
        'Defines a default list of words, that are ignored by the spell checker.' => '',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => '',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => '',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 2 for articles to add a new article attribute.' => '',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 3 for articles to add a new article attribute.' => '',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => '',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free time key field number 1 for tickets.' => '',
        'Defines the free time key field number 2 for tickets.' => '',
        'Defines the free time key field number 3 for tickets.' => '',
        'Defines the free time key field number 4 for tickets.' => '',
        'Defines the free time key field number 5 for tickets.' => '',
        'Defines the free time key field number 6 for tickets.' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repositoriy, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => '',
        'Defines the name of the calendar number 2.' => '',
        'Defines the name of the calendar number 3.' => '',
        'Defines the name of the calendar number 4.' => '',
        'Defines the name of the calendar number 5.' => '',
        'Defines the name of the calendar number 6.' => '',
        'Defines the name of the calendar number 7.' => '',
        'Defines the name of the calendar number 8.' => '',
        'Defines the name of the calendar number 9.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => '',
        'Defines whether the free time field number 2 is optional or not.' => '',
        'Defines whether the free time field number 3 is optional or not.' => '',
        'Defines whether the free time field number 4 is optional or not.' => '',
        'Defines whether the free time field number 5 is optional or not.' => '',
        'Defines whether the free time field number 6 is optional or not.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'E-mail',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => '',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => '',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => '',
        'Execute SQL statements.' => '',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => '',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => '',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => '',
        'GenericAgent' => 'Agente Genrico',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove trailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => '',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => '',
        'Link agents to roles.' => '',
        'Link attachments to responses templates.' => '',
        'Link customers to groups.' => '',
        'Link customers to services.' => '',
        'Link queues to auto responses.' => '',
        'Link responses to queues.' => '',
        'Link roles to groups.' => '',
        'Link this ticket to other objects!' => '',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => '',
        'Manage POP3 or IMAP accounts to fetch email from.' => '',
        'Manage S/MIME certificates for email encryption.' => '',
        'Manage existing sessions.' => '',
        'Manage periodic tasks.' => '',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Max. displayed tickets' => '',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to genetare accounted time ticket statistics.' => '',
        'Module to genetare ticket solution and response time statistics.' => '',
        'Module to genetare ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => '',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New email ticket' => '',
        'New phone ticket' => '',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => '',
        'Number of displayed tickets' => '',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => '',
        'Overview of all open Tickets.' => '',
        'PGP Key Upload' => '',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'PostMaster Filters' => '',
        'PostMaster Mail Accounts' => '',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => '',
        'QueueView Refresh Time' => '',
        'Refresh interval' => '',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => '',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => 'Papis <-> Grupos',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => '',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Search Ticket' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Select your frontend Theme.' => 'Selecione o Tema.',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => 'Notifique-me se um cliente enviar um acompanhamento e for o proprietrio do Chamado ou se o Chamado estiver desbloqueado e estiver em Minhas Filas',
        'Send notifications to users.' => '',
        'Send ticket follow up notifications' => '',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => '',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of lines that are displayed in the preview of messages (e.g. for tickets in the QueueView).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to move a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Skin' => '',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => '',
        'Status view' => '',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => '',
        'Tickets' => 'Chamado',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => '',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => '',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => '',
        'View system log messages.' => '',
        'Wear this frontend skin' => '',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => '',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        '%s Tickets affected! Do you really want to use this job?' => '%s Chamados afetados! Voc quer realmente utilizar este trabalho?',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => 'Checar os registros do MX de endereos de e-mail utilizados na composio de uma resposta. No utilizar checagem de registros do MX se o seu servidor OTRS estiver sib um acesso discado $!',
        '(Email of the system admin)' => '(E-mail do administrador do sistema)',
        '(Full qualified domain name of your system)' => '(Nome completo do domnio de seu sistema)',
        '(Logfile just needed for File-LogModule!)' => '(Arquivo de registro para File-LogModule)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => 'A quantidade de objetos dinmicos depende da sua instalao',
        '(Note: Useful for big databases and low performance server)' => '(Nota: til para base de dados grandes e servidores de baixa performance)',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(A identidade do sistema. Cada nmero de chamado e cada id. da sesso http, inicia com este nmero)',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identificador Chamado. Algumas pessoas gostam de usar por exemplo \'Chamado#\, \'Chamado#\' ou \'MeuChamado#\')',
        '(Used default language)' => '(Idioma padro utilizado)',
        '(Used log backend)' => '(Utilizado LOG como base)',
        '(Used ticket number format)' => '(Formato de Chamado utilizado)',
        'A article should have a title!' => 'O Artigo dever ter um Ttulo!',
        'A message must be spell checked!' => 'A mensagem necessita ser verificada ortograficamente!',
        'A message should have a To: recipient!' => 'Uma mensagem deve possuir um Para: destinatrio!',
        'A message should have a body!' => 'A mensagem deve conter um texto!',
        'A message should have a subject!' => 'Uma mensagem deve conter um assunto!',
        'A required field is:' => 'O campo obrigatrio :',
        'A web calendar' => 'Calendrio',
        'A web file manager' => 'Gerenciador de Arquivos Web',
        'A web mail client' => 'Webmail Cliente',
        'Absolut Period' => 'Perodo Absoluto',
        'Add Customer User' => 'Adicionar Usurio Cliente',
        'Add System Address' => 'Adicionar Endereos do Sistema',
        'Add User' => 'Adicionar Usurio',
        'Add a new Agent.' => 'Adicionar novo Agente',
        'Add a new Customer Company.' => 'Adicionar uma nova Empresa Cliente',
        'Add a new Group.' => 'Adicionar um novo Grupo',
        'Add a new Notification.' => 'Adicionar uma nova Notificao',
        'Add a new Priority.' => 'Adicionar nova Prioridade',
        'Add a new Role.' => 'Adicionar um novo Papel',
        'Add a new SLA.' => 'Adicionar novo SLA',
        'Add a new Salutation.' => 'Adicionar novo Tratamento',
        'Add a new Service.' => 'Adicionar novo Servio',
        'Add a new Signature.' => 'Adicionar nova Assinatura',
        'Add a new State.' => 'Adicionar novo Status',
        'Add a new System Address.' => 'Adicionar novo Endereo do Sistema',
        'Add a new Type.' => 'Adicionar novo Tipo',
        'Add note to ticket' => 'Adicionar nota ao chamado',
        'Added User "%s"' => 'Usurio Adicionado "%s"',
        'Admin-Area' => 'Administrao',
        'Admin-Email' => 'E-mail Admin.',
        'Admin-Password' => 'Senha do Administrador',
        'Admin-User' => 'Usurio Administrador',
        'Advisory' => 'Aviso',
        'Agent Mailbox' => 'Mailbox Agente',
        'Agent Preferences' => 'Preferncias Agente',
        'Agent based' => 'Baseado em Agente',
        'Agent-Area' => 'Agente',
        'All Agent variables.' => 'Todas as variveis do Agente',
        'All Agents' => 'Todos os Agentes',
        'All Customer variables like defined in config option CustomerUser.' => 'Todas as variveis do cliente como foram definidas nas opes de configurao de "usurio"',
        'All customer tickets.' => 'Todos os chamados do cliente',
        'All email addresses get excluded on replaying on composing an email.' => 'Todos os endereos so excludos ao responder ou compor um e-mail.',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Todos os emails entrantes com este Email(To:) sero despachados na fila selecionada!',
        'All messages' => 'Todas as mensagens',
        'All new tickets!' => 'Todos os chamados novos!',
        'All tickets' => 'Todos os chamados',
        'All tickets where the reminder date has reached!' => 'Todos os chamados com lembrete expirado!',
        'All tickets which are escalated!' => 'Todos os chamados que foram escalados!',
        'Allocate CustomerUser to service' => 'Alocar Usurios Cliente para o servio',
        'Allocate services to CustomerUser' => 'Alocar servios para o Usurio Cliente',
        'Answer' => 'Resposta',
        'Artefact' => 'Artefato',
        'Article Create Times' => 'Horrio da Criao do Artigo',
        'Article Type' => 'Tipo do Artigo',
        'Article created' => 'Artigo criado',
        'Article created between' => 'Artigo criado entre',
        'Article filter settings' => 'Configuraes do filtro do Artigo',
        'ArticleID' => 'Id.do artigo',
        'Attach' => 'Anexo',
        'Attribute' => 'Atributo',
        'Auto Response From' => 'Auto Resposta De',
        'Auto Responses <-> Queue' => 'Auto respostas <-> Fila',
        'Bounce ticket' => 'Devolver chamado',
        'Can not create link with %s!' => 'No foi possvel vincular com %s!',
        'Can not delete link with %s!' => 'No foi possvel remover vnculo com %s!',
        'Can\'t update password, invalid characters!' => 'Senha no atualizada, caracteres invlidos!',
        'Can\'t update password, must be at least %s characters!' => 'Senha no atualizada, digite no mnimo %s caracteres!',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Senha no atualizada, digite no mnimo 2 caracteres minsculos e 2 maisculos',
        'Can\'t update password, needs at least 1 digit!' => 'Senha no atualizada, digite no mnimo 1 nmero',
        'Can\'t update password, needs at least 2 characters!' => 'Senha no atualizada, digite no mnimo 2 caracteres',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Senha no atualizada, por que esto diferentes! Tente novamente!',
        'Category Tree' => 'Categorias',
        'Change %s settings' => 'Alterar %s configuraes',
        'Change Times' => 'Horrio de Alterao',
        'Change free text of ticket' => 'Alterar os campos em branco no chamado',
        'Change owner of ticket' => 'Modificar o proprietrio do chamado',
        'Change priority of ticket' => 'Modificar a prioridade do chamado',
        'Change responsible of ticket' => 'Alterar o responsvel pelo chamado',
        'Change roles <-> groups settings' => 'Alterar configuraes de papis <-> grupos',
        'Change user <-> group settings' => 'Alterar usurio configuraes de usurios <-> grupos',
        'Child-Object' => 'Objeto Filho',
        'Clear From' => 'Limpar',
        'Clear To' => 'Limpar',
        'Click here to report a bug!' => 'Clique aqui para relatar um erro!',
        'Close Times' => 'Horrios de Fechamento',
        'Close ticket' => 'Fechar o chamado',
        'Close type' => 'Tipo de fechamento',
        'Close!' => 'Fechar!',
        'Collapse View' => 'Retrair Visualizao',
        'Comment (internal)' => 'Comentrio (interno)',
        'CompanyTickets' => 'Chamados da Empresa',
        'Compose Answer' => 'Compor Resposta',
        'Compose Email' => 'Compor Email',
        'Compose Follow up' => 'Compor Continuao',
        'Config Options' => 'Opes de Configurao',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Opes de Configurao (ex.: <OTRS_CONFIG_HttpType>).',
        'Config options (e. g. OTRS_CONFIG_HttpType)' => 'Opes de configurao (ex.: OTRS_CONFIG_HttpType)',
        'Contact customer' => 'Contatar cliente',
        'Create Times' => 'Horrios de Criao',
        'Create new Phone Ticket' => 'Criar novo Fone Chamado',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crie novos grupos para manipular as permisses de acesso para diferentes grupos de agentes (exemplos: departamento de compras, departamento de suporte, departamento de vendas, etc...).',
        'Customer Move Notify' => 'Cliente Notificar Alterao',
        'Customer Owner Notify' => 'Cliente Notificar Proprietrio',
        'Customer State Notify' => 'Notificar Status do Cliente',
        'Customer User' => 'Cliente',
        'Customer User Management' => 'Gerenciamento de Usurios Clientes',
        'Customer Users' => 'Clientes',
        'Customer Users <-> Groups' => 'Clientes <-> Grupos',
        'Customer Users <-> Groups Management' => 'Usurios Clientes <-> Gerenciamento de Grupos',
        'Customer Users <-> Services' => 'Clientes <-> Servios',
        'Customer Users <-> Services Management' => 'Usurios Clientes <-> Gerenciamento de Servios',
        'Customer history' => 'Histrico do cliente',
        'Customer history search' => 'Busca no Histrico do cliente',
        'Customer history search (e. g. "ID342425").' => 'Busca no Histrico do cliente (exemplo: "ID342425")',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'O usurio do cliente ser necessrio para que exista um histrico do cliente e para login na rea de clientes.',
        'CustomerUser' => 'Usurio Cliente',
        'DB connect host' => 'Servidor de BD',
        'Default' => 'Padro',
        'Default Charset' => 'Conjunto de Caracteres Padro',
        'Default Language' => 'Idioma Padro',
        'Detail' => 'Detalhe',
        'Discard all changes and return to the compose screen' => 'Descartar todas as modificaes e retornar para a tela de composio',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Para despachar ou filtrar os e-mails entrantes baseados em "X-Headers". Expresses regulares tambm podem ser utilizadas.',
        'Do you really want to delete this Object?' => 'Voc quer realmente remover este objeto?',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Voc quer realmente reinstalar este pacote?',
        'Don\'t forget to add a new user to groups and/or roles!' => 'No se esquea de adicionar o novo usurio em grupos e/ou papis!',
        'Don\'t forget to add a new user to groups!' => 'No esquea de adicionar um novo usurio nos grupos!',
        'Download Settings' => 'Baixar Configuraes',
        'Download all system config changes.' => 'Baixar todas as configuraes do sistema que foram alteradas.',
        'Dynamic-Object' => 'Objeto-Dinmico',
        'Edit Article' => 'Editar Artigo',
        'Edit default services.' => 'Editar servios padro',
        'Email based' => 'Baseado em E-Mail',
        'Escaladed Tickets' => 'Chamados Escalados',
        'Escalation' => 'Escalao',
        'Escalation - First Response Time' => 'Escalada - Prazo da Primeira Resposta',
        'Escalation - Solution Time' => 'Escalada - Prazo de Soluo',
        'Escalation - Update Time' => 'Escalada - Prazo de Atualizao',
        'Escalation Times' => 'Prazo de Escalada',
        'Escalation time' => 'Tempo de escalao',
        'Event is required!' => 'Evento  obrigatrio!',
        'Expand View' => 'Expandir Visualizao',
        'Explanation' => 'Explanao',
        'Export Config' => 'Exportar Configurao',
        'FileManager' => 'Adm Arquivo',
        'Filelist' => 'Lista de arquivos',
        'Filtername' => 'Nome do Filtro',
        'Follow up' => 'Continuao',
        'Follow up notification' => 'Notificao de acompanhamento',
        'For very complex stats it is possible to include a hardcoded file.' => 'Para estatsticas muito complexas  possvel incluir um cdigo fonte.',
        'Frontend' => 'Interface',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Busca por texto completo no Artigo (ex.: "Mar*in" or "Baue*")',
        'Go' => 'Executar',
        'Group Ro' => 'Grupo Somente Leitura',
        'Group based' => 'Baseado em Grupo',
        'Group selection' => 'Seleo de Grupo',
        'Have a lot of fun!' => 'Divirta-se!',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => ' possvel escolher um ou dois elementos. Ento voc pode selecionar os atributos dos elementos. Cada atributo ser mostrado como um conjunto nico de valores. Se voc no selecionar nenhum atributo todos os atributos do elemento sero utilizados para gerar a estatstica. Assim como um novo atributo  adicionado desde a ltima configurao.',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Aqui voc pode definir o eixo X. Voc pode selecionar um elemento atravs do \'radio button\'. Ento voc deve selecionar dois ou mais atributos do elemento. Se no efetuou nenhum seleo, todos os atributos do elemento sero utilizados se voc gerar uma estatstica. Assim como um novo atributo  adicionado desde a ltima configurao. ',
        'Here you can insert a description of the stat.' => 'Aqui voc pode inserir uma descrio da estatstica.',
        'Here you can select the dynamic object you want to use.' => 'Aqui voc pode selecionar o objeto dinmico que voc quer usar.',
        'Home' => 'Incio',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'Se o Modo de Segurana no estiver ativado, ative-o atravs do SysConfig, porque sua aplicao j est rodando.',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Se um novo cdigo estiver disponvel ele pode ser exibido e voc poder escolh-lo. ',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Se um chamado est fechado e um cliente envia uma continuao, este mesmo chamado ser bloqueado para o antigo proprietrio.',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Se um Chamado, no for respondido dentro do prazo, sero apresentados.',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Se um Agente bloquear um chamado e ele no enviar uma resposta dentro deste tempo, o Chamado ser desbloqueado automaticamente. Ento o Chamado ser visvel para todos Agentes.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Se nada estiver selecionado, ento no h nenhuma permisso neste grupo (os chamados no estaro disponveis para o usurio).',
        'If you need the sum of every column select yes.' => 'Se voc necessita da soma de todas as colunas seleciona SIM',
        'If you need the sum of every row select yes' => 'Se voc necessita da soma de todos as linhas selecione SIM',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Se utilizar expresses regulares, voc pode usar o valor encontrado no () como [***] em \'Set\'.',
        'Image' => 'Imagem',
        'Important' => 'Importante',
        'In this form you can select the basic specifications.' => 'Neste formulrio voc pode selecionar as especificaes bsicas.',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Neste caso, voc pode editar diretamente a "keyring" configurada no Kernel/Config.pm.',
        'Incident' => 'Incidente',
        'Information about the Stat' => 'Informaes sobre a Estatstica',
        'Insert of the common specifications' => 'Insero das especificaes comuns',
        'Is Job Valid' => 'O Trabalho  Vlido.',
        'Is Job Valid?' => 'O Trabalho  Vlido?',
        'It\'s useful for ASP solutions.' => 'Isto  til para solues ASP.',
        'It\'s useful for a lot of users and groups.' => 'Isto  muito til para muitos usurios e grupos.',
        'Job-List' => 'Lista de Trabalhos',
        'Keyword' => 'Palavra-Chave',
        'Keywords' => 'Palavras-Chave',
        'Last update' => 'ltima Atualizao',
        'Link to Parent' => 'Vincular com o Pai',
        'Linked as' => 'Vinculado como',
        'Load Settings' => 'Carregar Configuraes',
        'Locked tickets' => 'Chamados Bloqueados',
        'Logfile' => 'Arquivo de registro',
        'Logfile too large, you need to reset it!' => 'Arquivo de log muito grande, voc deve reinici-lo!',
        'Login failed! Your username or password was entered incorrectly.' => 'Login incorreto! Seu Login ou senha foram inseridos incorretamente.',
        'Lookup' => 'Buscar',
        'Mail Management' => 'Gerenciamento Mail',
        'Mailbox' => 'Caixa de Entrada',
        'Match' => 'Busca',
        'Message for new Owner' => 'Mensagem para um novo Proprietrio',
        'Message sent to' => 'Mensagem enviada para',
        'Misc' => 'Variedades',
        'Modified' => 'Modificado',
        'Modules' => 'Modulos',
        'Move notification' => 'Notificao de movimentao',
        'Multiple selection of the output format.' => 'Mltiplas escolhas de formato de sada.',
        'MyTickets' => 'Meus Chamados',
        'Name is required!' => 'Nome  obrigatrio!',
        'New Agent' => 'Novo Agente',
        'New Customer' => 'Novo Cliente',
        'New Group' => 'Novo Grupo',
        'New Group Ro' => 'Novo Grupo Somente Leitura',
        'New Priority' => 'Nova Prioridade',
        'New SLA' => 'Novo SLA',
        'New Service' => 'Novo Servio',
        'New State' => 'Novo Status',
        'New Ticket Lock' => 'Novo Chamado Bloqueado',
        'New Title' => 'Novo Ttulo',
        'New Type' => 'Novo Tipo',
        'New account created. Sent Login-Account to %s.' => 'Nova conta criada. Enviado Login para %s.',
        'New messages' => 'Novas Mensagens',
        'New password again' => 'Repita sua nova senha',
        'No * possible!' => 'No so possveis *!',
        'No Permission' => 'Sem Permisso',
        'No change time settings.' => 'Ignorar horrios de alterao.',
        'No means, send agent and customer notifications on changes.' => 'No siginifica \'envie notificaes ao Agente e ao cliente nas alteraes\'.',
        'No time settings.' => 'Sem configuraes de hora.',
        'Note' => 'Anotao',
        'Note Text' => 'Anotao',
        'Notification (Customer)' => 'Notificao (Cliente)',
        'Notification (Event)' => 'Notificao (Evento)',
        'Notifications' => 'Notificaes',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'O OTRS envia uma notificao por e-mail ao cliente, caso o chamado seja movido.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'O OTRS envia uma notificao por e-mail ao cliente, caso o dono do chamado seja alterado.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'O OTRS envia uma notificao por e-mail ao cliente, caso o status do chamado seja alterado.',
        'Object already linked as %s.' => 'Objeto j vinculado como %s.',
        'Only for ArticleCreate Event.' => 'Somente para Eventos de Criao de Artigo.',
        'Open Tickets' => 'Chamados Abertos',
        'Options ' => 'Opes',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Opes de informaes do cliente (ex.: &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Opes de informaes do usurio cliente (ex.: <OTRS_CUSTOMER_DATA_UserFirstname>).',
        'Options of the current customer user data (e. g. OTRS_CUSTOMER_DATA_USERFIRSTNAME)' => 'Opes de dados do usurio do cliente atual (ex.: OTRS_CUSTOMER_DATA_USERFIRSTNAME)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Opes do usurio atual que requisitou esta ao (ex.: <OTRS_CURRENT_UserFirstname>).',
        'Options of the current user who requested this action (e. g. OTRS_CURRENT_USERFIRSTNAME)' => 'Opes do usurio atual que requisitou esta ao (ex.: OTRS_CURRENT_USERFIRSTNAME)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Opes de informao do Chamado (ex.: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Options of the ticket data (e. g. OTRS_TICKET_Number, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State)' => 'Opes de dados do chamado (ex.: OTRS_TICKET_Number, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State;)',
        'Options of the ticket data (e. g. OTRS_TICKET_TicketNumber, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State)' => 'Opes de dados do chamado (ex.: OTRS_TICKET_TicketNumber, OTRS_TICKET_ID, OTRS_TICKET_Queue, OTRS_TICKET_State)',
        'Options of the ticket data (e. g. OTRS_TICKET_TicketNumber, OTRS_TICKET_TicketID, OTRS_TICKET_Queue, OTRS_TICKET_State)' => 'Opes de dados do Chamado (e. g. OTRS_TICKET_TicketNumber, OTRS_TICKET_TicketID, OTRS_TICKET_Queue, OTRS_TICKET_State)',
        'Order' => 'Ordem',
        'Other Options' => 'Outras Opes',
        'Out Of Office' => 'Fora do Escritrio',
        'POP3 Account Management' => 'Gerenciamento de Contas POP3',
        'Package' => 'Pacotes',
        'Param 1' => 'Parmetro 1',
        'Param 2' => 'Parmetro 2',
        'Param 3' => 'Parmetro 3',
        'Param 4' => 'Parmatro 4',
        'Param 5' => 'Parmetro 5',
        'Param 6' => 'Parmetro 6',
        'Parent-Object' => 'Objeto Pai',
        'Password is already in use! Please use an other password!' => 'A Senha est em uso! Tente outra senha!',
        'Password is already used! Please use an other password!' => 'A Senha j foi utilizada! Tente outra senha!',
        'Passwords doesn\'t match! Please try it again!' => 'Senha incorreta! Tente novamente!',
        'Pending Times' => 'Horrios Pendentes',
        'Pending messages' => 'Mensagens pendentes',
        'Pending type' => 'Tipo de pendncia',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Configuraes de permisso. Voc pode selecionar um ou mais grupos para que as estatsticas configuradas sejam exibidas para agentes diferentes.',
        'Permissions to change the ticket owner in this group/queue.' => 'Permisses para alterar o Chamado neste grupo/fila.  ',
        'PhoneView' => 'Chamada',
        'Please contact your admin' => 'Por favor, contate administrador do sistema!',
        'Prio' => 'Prioridade',
        'Problem' => 'Problema',
        'Queue <-> Auto Responses Management' => 'Fila <-> Gerenciamento de Auto Respostas',
        'Queue ID' => 'ID da Fila',
        'Queue Management' => 'Gerenciamento de Filas',
        'QueueView' => 'Visualizar Fila',
        'Realname' => 'Nome',
        'Rebuild' => 'Reconstruir',
        'Recipients' => 'Destinatrios',
        'Refresh' => 'Atualizar',
        'Reminder' => 'Lembretes',
        'Reminder messages' => 'Mensagens com lembretes',
        'Required Field' => 'Campo Requerido',
        'Response Management' => 'Gerenciamento de Respostas',
        'Responses <-> Attachments Management' => 'Respostas <-> Gerenciamento de Anexos',
        'Responses <-> Queue' => 'Respostas <-> Fila',
        'Responses <-> Queue Management' => 'Respostas <-> Gerenciamento de Filas',
        'Return to the compose screen' => 'Retornar para a tela de composio',
        'Role' => 'Papel',
        'Roles <-> Groups Management' => 'Papis <-> Gerenciamento de Grupos',
        'Roles <-> Users' => 'Papis <-> Usurios',
        'Roles <-> Users Management' => 'Papel <-> Gerenciamento de Usurios',
        'Save Job as?' => 'Salvar Trabalho como?',
        'Save Search-Profile as Template?' => 'Salvar o Perfil de Busca como Modelo?',
        'Schedule' => 'Agendamento',
        'Search Result' => 'Resultado da Busca',
        'Search for' => 'Pesquisar por',
        'Secure Mode need to be enabled!' => 'Modo de Segurana deve ser ativado!',
        'Select Box' => 'Caixa de Seleo',
        'Select Box Result' => 'Selecione a Caixa de Resultado',
        'Select Source (for add)' => 'Selecione Origem (para adio)',
        'Select the element, which will be used at the X-axis' => 'Selecione o elemento que ser usado no eixo X',
        'Select the restrictions to characterise the stat' => 'Selecione as restries para caracterizar o status',
        'Select the role:user relations.' => 'Selecione a relao entre o papel/usurio.',
        'Select the user:group permissions.' => 'Selecione as permisses de usurio:grupo.',
        'Select your QueueView refresh time.' => 'Selecione o tempo de atualizao das Filas',
        'Select your default spelling dictionary.' => 'Escolha o seu corretor ortogrfico padro.',
        'Select your frontend Charset.' => 'Selecione o Conjunto de Caracteres.',
        'Select your frontend QueueView.' => 'Selecione a Viso da Fila.',
        'Select your frontend language.' => 'Selecione o Idioma.',
        'Select your out of office time.' => 'Selecione seu perodo de \"Fora do Escritrio\"',
        'Select your screen after creating a new ticket.' => 'Selecione a tela seguinte aps a criao de um novo chamado.',
        'Selection needed' => ' necessrio a seleo',
        'Send Notification' => 'Enviar Notificao',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'Notifique-me se sobre um Chamado monitorado como se fosse seu proprietrio.',
        'Send no notifications' => 'No enviar notificaes',
        'Sent new password to: %s' => 'Enviada nova senha para: %s',
        'Sent password token to: %s' => 'Enviado token de senha para: %s',
        'Sessions' => 'Sesses',
        'Set customer user and customer id of a ticket' => 'Configurar usurio e id do cliente no chamado',
        'Show' => 'Visualizar',
        'Solution' => 'Soluo',
        'Sort by' => 'Ordenado pela',
        'Source' => 'Origem',
        'Spell Check' => 'Checar Ortografia',
        'Split' => 'Dividir',
        'State Type' => 'Tipo de Status',
        'Static-File' => 'Arquivo-Esttico',
        'Stats-Area' => 'Estatsticas',
        'Sub-Queue of' => 'Subfila de',
        'Sub-Service of' => 'Subservio de',
        'Subscribe' => 'Cadastrar',
        'Symptom' => 'Sintoma',
        'System History' => 'Histrico do Sistema',
        'System State Management' => 'Gerenciamento de Status do Sistema',
        'Systemaddress' => 'Endereo do Sistema',
        'The message being composed has been closed.  Exiting.' => 'A mensagem que est sendo redigida foi fechada. Saindo.',
        'This account exists.' => 'Esta conta existe.',
        'This values are read only.' => 'Estes valores so somente leitura.',
        'This values are required.' => 'Estes valores so obrigatrios.',
        'This window must be called from compose window' => 'Esta janela deve ser chamada da janela de redao',
        'Ticket Lock' => 'Chamado bloqueado',
        'Ticket Number Generator' => 'Gerador de Nmeros de Chamados',
        'Ticket Search' => 'Busca de Chamado',
        'Ticket Status View' => 'Visualizao do Status do Chamado',
        'Ticket Type is required!' => 'Tipo do Chamado  obrigatrio',
        'Ticket changed' => 'Chamado alterado',
        'Ticket changed between' => 'Chamado alterado entre',
        'Ticket escalation!' => 'Escalao de chamados!',
        'Ticket locked!' => 'Chamado bloqueado!',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opes de dono do chamado (ex.: &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Opes do proprietrio do Chamado (ex.: <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Opes do responsvel pelo Chamado (ex.: <OTRS_RESPONSIBLE_UserFirstname>).',
        'Ticket selected for bulk action!' => 'Chamado selecionado para execuo de ao!',
        'Ticket unlock!' => 'Chamado desbloqueado!',
        'Ticket-Area' => 'Chamados',
        'TicketFreeText' => 'Texto livre Chamado',
        'TicketID' => 'Id.do Chamado',
        'Tickets available' => 'Chamados disponveis',
        'Tickets shown' => 'Chamados mostrados',
        'Tickets which need to be answered!' => 'Chamados que precisam ser respondidos',
        'Times' => 'Hora',
        'Title of the stat.' => 'Ttulo da estatstica.',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'Para buscar o atributo do artigo (ex.: (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Para buscar o atributo do artigo (ex.: (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).',
        'Top of Page' => 'Topo da Pgina',
        'Total hits' => 'Total de acertos',
        'U' => 'C',
        'Uniq' => 'nico',
        'Unlock Tickets' => 'Desbloquear Chamados',
        'Unsubscribe' => 'Descadastrar',
        'Use utf-8 it your database supports it!' => 'A sua Base de dados suporta utf-8!',
        'Useable options' => 'Opes acessveis',
        'User Management' => 'Gerenciamento de Usurios',
        'User will be needed to handle tickets.' => 'Ser necessrio um usurio para manipular os chamados.',
        'Users' => 'Usurios',
        'Users <-> Groups' => 'Usurios <-> Grupos',
        'Users <-> Groups Management' => 'Usurios <-> Gerenciamento de Grupos',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Alerta! Este Chamado ser removido da base de dados! Este Chamado esr perdido permanentemente!',
        'Watch notification' => 'Notificao de Monitoramento',
        'Web-Installer' => 'Instalador Web',
        'WebWatcher' => 'Visitante',
        'Welcome to OTRS' => 'Bem-vindo ao OTRS',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'Com os campos de insero e seleo, voc pode configurar a estatstica de acordo com a sua necessidade. Os elementos da estatstica que voc pode editar dependem das permisses concedidas a voc pelo administrador do sistema.',
        'Yes means, send no agent and customer notifications on changes.' => 'Sim significa \'no envie notificaes ao Agente e ao cliente nas alteraes\'.',
        'Yes, save it with name' => 'Sim, salve-o com o nome',
        'You got new message!' => 'Voc recebeu uma nova mensagem',
        'You have to select two or more attributes from the select field!' => 'Voc deve selecionar dois ou mais atributos no campo \'selecionar\'!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Voc precisa de um endereo de email (exemplo: cliente@exemplo.com.br) no To:!',
        'You need min. one selected Ticket!' => 'Voc deve selecionar ao menos 1(um) chamado!',
        'You need to account time!' => 'Voc deve contabilizar o tempo!',
        'You need to activate %s first to use it!' => 'Voc deve ativar %s antes de us-lo!',
        'Your email address is new' => 'Seu e-mail  novo',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Seu email com o nmero de chamado "<OTRS_TICKET>" foi devolvido para "<OTRS_BOUNCE_TO>". Contate este endereo para mais informaes.',
        'Your own Ticket' => 'Seu prprio Chamado',
        'accept license' => 'aceitar licena',
        'customer realname' => 'Nome do cliente',
        'don\'t accept license' => 'no acentiar a licena',
        'down' => 'inversa',
        'false' => 'falso',
        'for agent firstname' => 'Nome do Agente',
        'for agent lastname' => 'Sobrenome do Agente',
        'for agent login' => 'Login do Agente',
        'for agent user id' => 'Id do Agente',
        'kill all sessions' => 'Finalizar todas as sesses',
        'kill session' => 'Finalizar sesso',
        'maximal period form' => 'formulrio de perodo mximo',
        'modified' => 'modificado',
        'new ticket' => 'Novo Chamado',
        'next step' => 'prximo passo',
        'send' => 'enviar',
        'sort downward' => 'ordem decrescente',
        'sort upward' => 'ordem crescente',
        'to get the first 20 character of the subject' => 'para obter os 20 primeiros caracteres do assunto',
        'to get the first 5 lines of the email' => 'para obter as 5 primeiras linhas do email',
        'to get the from line of the email' => 'para obter a linha "From" do email',
        'to get the realname of the sender (if given)' => 'para obter o nome do remetente (se possuir no email)',
        'up' => 'normal',

    };
    # $$STOP$$
    return;
}

1;
