# --
# Copyright (C) 2001-2018 OTRS AG, https://otrs.com/
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see https://www.gnu.org/licenses/gpl-3.0.txt.
# --

use strict;
use warnings;
use utf8;

use vars (qw($Self));

# get needed objects
my $ConfigObject = $Kernel::OM->Get('Kernel::Config');
my $HelperObject = $Kernel::OM->Get('Kernel::System::UnitTest::Helper');

# check used accesskeys in agent frontend
my %UsedAccessKeysAgent;

# frontend and toolbar modules
my %AgentModules = (
    %{ $ConfigObject->Get('Frontend::Module') },
    %{ $ConfigObject->Get('Frontend::ToolBarModule') }
);

ACCESSKEYSAGENT:
for my $AgentModule ( sort keys %AgentModules ) {

    # check navbar items
    if ( $AgentModules{$AgentModule}->{NavBar} && @{ $AgentModules{$AgentModule}->{NavBar} } ) {

        NAVBARITEMS:
        for my $NavBar ( sort @{ $AgentModules{$AgentModule}->{NavBar} } ) {

            my $NavBarKey = $NavBar->{AccessKey} || '';
            next NAVBARITEMS if !$NavBarKey;

            $Self->False(
                defined $UsedAccessKeysAgent{$NavBarKey},
                "[AGENT FRONTEND] Check if access key already exists for access key '$NavBarKey'",
            );

            $UsedAccessKeysAgent{$NavBarKey} = 1;
        }
    }

    my $AccessKey = $AgentModules{$AgentModule}->{AccessKey} || '';

    next ACCESSKEYSAGENT if !$AccessKey;

    $Self->False(
        defined $UsedAccessKeysAgent{$AccessKey},
        "[AGENT FRONTEND] Check if access key already exists for access key '$AccessKey'",
    );

    $UsedAccessKeysAgent{$AccessKey} = 1;
}

# check used accesskeys in customer frontend
my %UsedAccessKeysCustomer;

# frontend and toolbar modules
my %CustomerModules = %{ $ConfigObject->Get('CustomerFrontend::Module') };

ACCESSKEYSCUSTOMER:
for my $CustomerModule ( sort keys %CustomerModules ) {

    next ACCESSKEYSCUSTOMER if !$CustomerModules{$CustomerModule}->{NavBar};
    next ACCESSKEYSCUSTOMER if !@{ $CustomerModules{$CustomerModule}->{NavBar} };

    NAVBARITEMS:
    for my $NavBar ( sort @{ $CustomerModules{$CustomerModule}->{NavBar} } ) {

        my $NavBarKey = $NavBar->{AccessKey} || '';

        next NAVBARITEMS if !$NavBarKey;

        $Self->False(
            defined $UsedAccessKeysCustomer{$NavBarKey},
            "[CUSTOMER FRONTEND] Check if access key already exists for access key '$NavBarKey'",
        );

        $UsedAccessKeysCustomer{$NavBarKey} = 1;
    }
}

1;
