# --
# Copyright (C) 2001-2018 OTRS AG, https://otrs.com/
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see https://www.gnu.org/licenses/gpl-3.0.txt.
# --

use strict;
use warnings;
use utf8;

use vars (qw($Self));

# get selenium object
my $Selenium = $Kernel::OM->Get('Kernel::System::UnitTest::Selenium');

$Selenium->RunTest(
    sub {

        # get helper object
        my $Helper = $Kernel::OM->Get('Kernel::System::UnitTest::Helper');

        # create test user and login
        my $TestUserLogin = $Helper->TestUserCreate(
            Groups => ['admin'],
        ) || die "Did not get test user";

        $Selenium->Login(
            Type     => 'Agent',
            User     => $TestUserLogin,
            Password => $TestUserLogin,
        );

        # get script alias
        my $ScriptAlias = $Kernel::OM->Get('Kernel::Config')->Get('ScriptAlias');

        # navigate to AdminSupportDataCollector screen
        $Selenium->VerifiedGet("${ScriptAlias}index.pl?Action=AdminSupportDataCollector");

        # check Widget dropdown on AdminSupportDataCollector screen
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_0')]");    # Database
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_1')]");    # Operating System
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_2')]");    # OTRS
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_3')]");    # Webserver

        # check System Registration and Generate Support Bundle buttons
        $Selenium->find_element("//a[contains(\@href, \'Action=AdminRegistration' )]");
        $Selenium->find_element( "#GenerateSupportBundle", 'css' );

    }

);

1;
