# Kernel/Language/fr.pm - provides fr language translation
# Copyright (C) 2002 Bernard Choppy <choppy at imaginet.fr>
# Copyright (C) 2002 Nicolas Goralski <ngoralski at oceanet-technology.com>
# --
# $Id: fr.pm,v 1.21.2.1 2003/06/22 19:28:27 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::fr;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.21.2.1 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;
# --
sub Data {
    my $Self = shift;
    my %Param = @_;
    my %Hash = ();

    # $$START$$
    # Last translation Sun Apr 13 01:00:21 2003 by 

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D.%M.%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %T %Y';
    $Self->{DateInputFormat} = '%D.%M.%Y - %T';

    %Hash = (
    # Template: AAABase
      ' 2 minutes' => ' 2 minutes',
      ' 5 minutes' => ' 5 minutes',
      ' 7 minutes' => ' 7 minutes',
      '10 minutes' => '10 minutes',
      '15 minutes' => '15 minutes',
      'AddLink' => 'Ajouter un lien',
      'AdminArea' => 'Zone d\'administration',
      'agent' => '',
      'all' => 'tout',
      'All' => 'Tout',
      'Attention' => 'Attention',
      'Bug Report' => 'Rapport d\'anomalie',
      'Cancel' => 'Annuler',
      'change' => 'modifier',
      'Change' => 'Modifier',
      'change!' => 'modifier&nbsp;!',
      'click here' => 'Cliquer l',
      'Comment' => 'Commentaire',
      'Customer' => 'Client',
      'customer' => '',
      'Customer Info' => 'Information client',
      'day' => 'jour',
      'days' => 'jours',
      'description' => 'description',
      'Description' => 'Description',
      'Dispatching by email To: field.' => 'Rpartition par le champs \'\' de l\'email',
      'Dispatching by selected Queue.' => 'Rpartition par la file slectionne',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Cela ne fonctionne pas avec l\'ID utilisateur 1 (Compte Systme)! Veuillez crer un nouvel utilisateur!',
      'Done' => 'Fait',
      'end' => 'fin',
      'Error' => 'Erreur',
      'Example' => 'Exemple',
      'Examples' => 'Exemples',
      'Facility' => 'Facilit',
      'Feature not active!' => '',
      'go' => 'Go',
      'go!' => 'c\'est parti&nbsp;!',
      'Group' => 'Groupe',
      'Hit' => 'Hit',
      'Hits' => 'Hits',
      'hour' => 'heure',
      'hours' => 'heures',
      'Ignore' => 'Ignorer',
      'invalid' => 'invalide',
      'Invalid SessionID!' => 'ID de Session Invalide',
      'Language' => 'Langue',
      'Languages' => 'Langues',
      'Line' => 'Ligne',
      'Lite' => 'allge',
      'Login failed! Your username or password was entered incorrectly.' => 'La connection a chou ! Votre nom d\'utilisateur ou votre mot de passe a t saisie incorrectement',
      'Logout successful. Thank you for using OTRS!' => 'Dconnection russie. Merci d\'avoir utilis OTRS!',
      'Message' => 'Message',
      'minute' => 'minute',
      'minutes' => 'minutes',
      'Module' => 'Module',
      'Modulefile' => 'Fichier de module',
      'Name' => 'Nom',
      'New message' => 'Nouveau message',
      'New message!' => 'Nouveau message&nbsp;!',
      'No' => 'Non',
      'no' => 'aucune',
      'No entry found!' => '',
      'No suggestions' => 'Pas de suggestions',
      'none' => 'aucun',
      'none - answered' => 'aucun - rpondu',
      'none!' => 'aucun&nbsp;!',
      'Off' => 'teint',
      'off' => 'teint',
      'On' => 'Allum',
      'on' => 'allum',
      'Password' => 'Mot de Passe',
      'Pending till' => 'En attendant jusqu\'',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Il faut rpondre  ce(s) ticket(s) pour revenir  la vue normale de la file.',
      'Please contact your admin' => 'Veuillez contacter votre admnistrateur',
      'please do not edit!' => 'Ne pas modifier&nbsp;!',
      'possible' => 'possible',
      'QueueView' => 'Vue file',
      'reject' => 'rejet',
      'replace with' => 'remplacer par',
      'Reset' => 'Remise  zro',
      'Salutation' => 'Salutation',
      'Session has timed out. Please log in again.' => '',
      'Signature' => 'Signature',
      'Sorry' => 'Dsol',
      'Stats' => 'Statistiques',
      'Subfunction' => 'sous-fonction',
      'submit' => 'soumettre',
      'submit!' => 'soumettre&nbsp;!',
      'system' => '',
      'Take this User' => '',
      'Text' => 'Texte',
      'The recommended charset for your language is %s!' => 'Les jeux de charactres pour votre langue est %s!',
      'Theme' => 'Thme',
      'There is no account with that login name.' => 'Il n\'y a aucun compte avec ce login',
      'Timeover' => 'Temp coul',
      'top' => 'haut',
      'update' => 'Mise  jour',
      'update!' => 'actualiser&nbsp;!',
      'User' => 'Utilisateur',
      'Username' => 'Nom d\'utilisateur',
      'Valid' => 'Valide',
      'Warning' => 'Attention',
      'Welcome to OTRS' => 'Bienvenue  OTRS',
      'Word' => 'Mot',
      'wrote' => 'crit',
      'yes' => 'oui',
      'Yes' => 'Oui',
      'You got new message!' => 'Vous avez un nouveau message',
      'You have %s new message(s)!' => 'Vous avez %s nouveau(x) message(s)',
      'You have %s reminder ticket(s)!' => 'Vous avez %s rappel(s) de ticket(s)',

    # Template: AAAMonth
      'Apr' => 'Avr',
      'Aug' => 'Aou',
      'Dec' => 'Dc',
      'Feb' => 'Fv',
      'Jan' => 'Jan',
      'Jul' => 'Juil',
      'Jun' => 'Juin',
      'Mar' => 'Mar',
      'May' => 'Mai',
      'Nov' => 'Nov',
      'Oct' => 'Oct',
      'Sep' => 'Sep',

    # Template: AAAPreferences
      'Closed Tickets' => '',
      'Custom Queue' => 'File d\'attente personnelle',
      'Follow up notification' => 'Notification de suivi',
      'Frontend' => 'Interface',
      'Mail Management' => 'Gestion des Emails',
      'Move notification' => 'Notification de mouvement',
      'New ticket notification' => 'Notification de nouveau ticket',
      'Other Options' => 'Autres options',
      'Preferences updated successfully!' => 'Les prfrences ont bien t mises  jours',
      'QueueView refresh time' => 'Temps de rafrachissement de la vue des files',
      'Select your default spelling dictionary.' => '',
      'Select your frontend Charset.' => 'Choix du jeu de caractres de l\'interface',
      'Select your frontend language.' => 'Choix de la langue de l\'interface',
      'Select your frontend QueueView.' => 'Choisissez votre interface de vue des files',
      'Select your frontend Theme.' => 'Choix du thme de l\'interface',
      'Select your QueueView refresh time.' => 'Choix du dlai de rafrachissement de la vue des files',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Me prvenir si un client envoie un suivi (follow-up) et que je suis le propritaire du ticket.',
      'Send me a notification if a ticket is moved into a custom queue.' => 'Me prvenir si un ticket est dplac dans une file personnallis',
      'Send me a notification if a ticket is unlocked by the system.' => 'Me prvenir si un ticket est dvrouill par le systme',
      'Send me a notification if there is a new ticket in my custom queues.' => 'Me prvenir si un nouveau ticket apparat dans mes files personnelles.',
      'Show closed tickets.' => '',
      'Spelling Dictionary' => '',
      'Ticket lock timeout notification' => 'Prvenir du dpassement du dlai d\'un verrou ',

    # Template: AAATicket
      '1 very low' => '1 trs bas',
      '2 low' => '2 bas',
      '3 normal' => '3 normal',
      '4 high' => '4 important',
      '5 very high' => '5 trs important',
      'Action' => 'Action',
      'Age' => 'Vieillir',
      'Article' => 'Article',
      'Attachment' => 'Pice jointe',
      'Attachments' => 'Pices jointes',
      'Bcc' => 'Copie Invisible',
      'Bounce' => 'Renvoyer',
      'Cc' => 'Copie ',
      'Close' => 'Fermer',
      'closed successful' => 'clture russie',
      'closed unsuccessful' => 'clture manque',
      'Compose' => 'Composer',
      'Created' => 'Cr ',
      'Createtime' => 'Cration du ',
      'email' => 'courriel',
      'eMail' => 'courriel',
      'email-external' => 'message externe',
      'email-internal' => 'message interne',
      'Forward' => 'Transmettre',
      'From' => 'De ',
      'high' => 'Important',
      'History' => 'Historique',
      'If it is not displayed correctly,' => 'S\'il n\'est pas affich correctement',
      'lock' => '',
      'Lock' => 'Vrrouiller',
      'low' => 'confort de fonctionnement',
      'Move' => 'Dplacer',
      'new' => 'nouveau',
      'normal' => 'bloque une fonction',
      'note-external' => 'Note externe',
      'note-internal' => 'Note interne',
      'note-report' => 'Note rapport',
      'open' => 'ouvrir',
      'Owner' => 'Propritaire',
      'Pending' => 'En attente',
      'pending auto close+' => 'En attendant la fermeture automatique(+)',
      'pending auto close-' => 'En attendant la fermeture automatique(-)',
      'pending reminder' => 'En attendant le rappel',
      'phone' => 'tlphone',
      'plain' => 'tel quel',
      'Priority' => 'Priorit',
      'Queue' => 'File',
      'removed' => 'supprim',
      'Sender' => 'metteur',
      'sms' => 'sms',
      'State' => 'tat',
      'Subject' => 'Sujet',
      'This is a' => 'Ceci est un',
      'This is a HTML email. Click here to show it.' => 'Ceci est un message au format HTML&nbsp;; cliquer ici pour l\'afficher.',
      'This message was written in a character set other than your own.' => 'Ce message a t &eaute;crit dans un type de charact autre que le v&ociric;tre',
      'Ticket' => 'Ticket',
      'To' => ' ',
      'to open it in a new window.' => 'Pour l\'ouvrir dans une nouvelle fentre',
      'unlock' => 'dverrouiller',
      'Unlock' => 'Dverrouiller',
      'very high' => 'bloque un service entier',
      'very low' => 'confort intellectuel',
      'View' => 'Vue',
      'webrequest' => 'Requete par le web',
      'Zoom' => 'Dtails',

    # Template: AAAWeekDay
      'Fri' => 'Ven',
      'Mon' => 'Lun',
      'Sat' => 'Sam',
      'Sun' => 'Dim',
      'Thu' => 'Jeu',
      'Tue' => 'Mar',
      'Wed' => 'Mer',

    # Template: AdminAttachmentForm
      'Add attachment' => 'Ajouter une pice',
      'Attachment Management' => 'Gestion des attachements',
      'Change attachment settings' => 'Changer les param&ecirc;etres d\'attachement',

    # Template: AdminAutoResponseForm
      'Add auto response' => 'Ajouter une rponse automatique',
      'Auto Response From' => 'Rponse automatique de ',
      'Auto Response Management' => 'Gestion des rponses automatiques',
      'Change auto response settings' => 'Modifier les paramtres de rponses automatiques',
      'Charset' => 'Jeu de charactre',
      'Note' => 'Note',
      'Response' => 'Rponse',
      'to get the first 20 character of the subject' => 'pour avoir les 20 premiers charactres du sujet ',
      'to get the first 5 lines of the email' => 'pour avoir les 5 premires ligne du mail',
      'to get the from line of the email' => 'pour avoir les lignes \'From\' du mail',
      'to get the realname of the sender (if given)' => 'pour avoir le nom rel de l\'utilisateur (s\il est donn)',
      'to get the ticket id of the ticket' => '',
      'to get the ticket number of the ticket' => 'pour avoir le numro du ticket',
      'Type' => 'Type',
      'Useable options' => 'Options accessibles',

    # Template: AdminCharsetForm
      'Add charset' => 'Ajouter un jeu de caractres systme',
      'Change system charset setting' => 'Modification des paramtres du jeu de caractres systme',
      'System Charset Management' => 'Gestion du jeu de caractres systme',

    # Template: AdminCustomerUserForm
      'Add customer user' => 'Ajouter un utilisateur client',
      'Change customer user settings' => 'Changer les prfrences utilisateurs du client',
      'Customer User Management' => 'Gestion des clients utilisateurs',
      'Customer user will be needed to to login via customer panels.' => 'Les clients utilisateurs seront invit  se connecter par la page client.',

    # Template: AdminCustomerUserGeneric

    # Template: AdminCustomerUserPreferencesGeneric

    # Template: AdminEmail
      'Admin-Email' => 'Email de l\'administrateur',
      'Body' => 'Corps',
      'OTRS-Admin Info!' => 'Information de l\'administrateur OTRS',
      'Permission' => '',
      'Recipents' => 'Rcipients',
      'send' => '',

    # Template: AdminEmailSent
      'Message sent to' => 'Message envoy ',

    # Template: AdminGroupForm
      'Add group' => 'Ajouter un groupe',
      'Change group settings' => 'Changer les paramtres d\'un groupe',
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'De nouveaux groupes permettront de grer les droits d\'accs pour les diffrents groupes d\'un agent (exemple&nbsp;: achats, comptabilit, support, ventes...).',
      'Group Management' => 'Administration des groupes',
      'It\'s useful for ASP solutions.' => 'C\'est utile pour les fournisseurs d\'applications.',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'Le groupe admin permet d\'accder  la zone d\'administration et le groupe stats  la zone de statistiques.',

    # Template: AdminLog
      'System Log' => 'Logs du Systme',

    # Template: AdminNavigationBar
      'AdminEmail' => 'Email de l\'administrateur.',
      'AgentFrontend' => 'Interface de l\'agent',
      'Attachment <-> Response' => '',
      'Auto Response <-> Queue' => 'Rponse Automatique <-> Files',
      'Auto Responses' => 'Rponses automatiques',
      'Charsets' => 'Jeu de Charactre',
      'Customer User' => 'Client Utilisateur',
      'Email Addresses' => 'Adresses lectroniques',
      'Groups' => 'Groupes',
      'Logout' => 'Dconnexion',
      'Misc' => 'Divers',
      'POP3 Account' => 'Compte POP3',
      'Responses' => 'Rponses',
      'Responses <-> Queue' => 'Rponses <-> Files',
      'Select Box' => 'Requte SQL libre.',
      'Session Management' => 'Gestion des sessions',
      'Status' => '',
      'System' => 'Systme',
      'User <-> Groups' => 'Utilisateur <-> Groupes',

    # Template: AdminPOP3Form
      'Add POP3 Account' => 'Ajouter un compte POP3',
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Tout les mails entrants avec un compte seront rpartis dans la file slectionn',
      'Change POP3 Account setting' => 'Changer les param&ecirc;tres du compte POP3',
      'Dispatching' => 'Rpartition',
      'Host' => 'Hte',
      'If your account is trusted, the x-otrs header (for priority, ...) will be used!' => 'Si votre compte est vrifi, les en-t&ecirc;tes x-otrs (pour les priorits,...) seront utiliss',
      'Login' => 'Nom d\'utilisateur',
      'POP3 Account Management' => 'Gestion du compte POP3',
      'Trusted' => 'Vrifi',

    # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Response Management' => 'Gestion des files <-> rponses automatiques',

    # Template: AdminQueueAutoResponseTable

    # Template: AdminQueueForm
      '0 = no escalation' => '0 = pas d\'escalade',
      '0 = no unlock' => '0 = pas de vrouillage',
      'Add queue' => 'Ajouter une file',
      'Change queue settings' => 'Modifier les paramtres des files',
      'Customer Move Notify' => '',
      'Customer Owner Notify' => '',
      'Customer State Notify' => '',
      'Escalation time' => 'Dlai d\'escalade',
      'Follow up Option' => 'Option des suivis',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Si un ticket est clotur et que le client envoie une note, le ticket pour l\'ancien propritaire',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Si un ticket n\'est pas rpondu dans le temps impartit, alors juste ce ticket sera affich',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Si un agent vrouille un ticket et qu\'il/elle n\'envoie pas une rponse dans le temps impartit, le ticket sera dvrouill automatiquement.',
      'Key' => 'Clef',
      'OTRS sends an notification email to the customer if the ticket is moved.' => '',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => '',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => '',
      'Queue Management' => 'Gestion des files',
      'Sub-Queue of' => '',
      'Systemaddress' => 'Adresse du Systme',
      'The salutation for email answers.' => 'La formule de politesse pour les rponses par mail',
      'The signature for email answers.' => 'La signature pour les rponses par email',
      'Ticket lock after a follow up' => 'Ticket bloqu aprs un suivi',
      'Unlock timeout' => 'Temporisation du dverrouillage',
      'Will be the sender address of this queue for email answers.' => 'Sera l\'adresse d\'exppdition pour les rponses par courrier lectronique',

    # Template: AdminQueueResponsesChangeForm
      'Change %s settings' => 'Changer les param&ecirc;tres de %s',
      'Std. Responses <-> Queue Management' => 'Gestion des rponses standard <-> files',

    # Template: AdminQueueResponsesForm
      'Answer' => 'Rponse',
      'Change answer <-> queue settings' => 'Modifier les paramtres de rponses <-> files',

    # Template: AdminResponseAttachmentChangeForm
      'Std. Responses <-> Std. Attachment Management' => 'Rponses Std <-> Gestion des attachements Std',

    # Template: AdminResponseAttachmentForm
      'Change Response <-> Attachment settings' => 'Param&ecirc;tre des attachements',

    # Template: AdminResponseForm
      'A response is default text to write faster answer (with default text) to customers.' => 'Une rponse est un texte par dfaut destin  rdiger plus rapidement des rponses standard aux clients.',
      'Add response' => 'Ajouter une rponse',
      'Change response settings' => 'Modifier les paramtres des rponses',
      'Don\'t forget to add a new response a queue!' => 'Ne pas oublier d\'ajouter une file  une nouvelle rponse&nbsp;!',
      'Response Management' => 'Gestion des rponses',

    # Template: AdminSalutationForm
      'Add salutation' => 'Ajouter une salutation',
      'Change salutation settings' => 'Modification des paramtres de salutations',
      'customer realname' => 'nom rel du client',
      'for agent firstname' => 'pour le prnom de l\'agent',
      'for agent lastname' => 'pour le nom de l\'agent',
      'for agent login' => '',
      'for agent user id' => '',
      'Salutation Management' => 'Gestion des salutations',

    # Template: AdminSelectBoxForm
      'Max Rows' => 'Nombre de lignes maximales',

    # Template: AdminSelectBoxResult
      'Limit' => 'Limite',
      'Select Box Result' => 'Choisissez le rsultat',
      'SQL' => '',

    # Template: AdminSession
      'kill all sessions' => 'Terminer toutes les sessions',

    # Template: AdminSessionTable
      'kill session' => 'Terminer une session',
      'SessionID' => '',

    # Template: AdminSignatureForm
      'Add signature' => 'Ajouter une signature',
      'Change signature settings' => 'Modification des paramtres de signatures',
      'Signature Management' => 'Gestion des signatures',

    # Template: AdminStateForm
      'Add state' => 'Ajouter un tat',
      'Change system state setting' => 'Modification des paramtres d\'tats du systme',
      'State Type' => '',
      'System State Management' => 'Gestion des tats du systme',

    # Template: AdminSystemAddressForm
      'Add system address' => 'Ajouter une adresse lectronique du systme',
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Tous les courriels avec cette adresse en destinataire (&nbsp;:) seront placs dans la file choisie..',
      'Change system address setting' => 'Modification des paramtres des adresses courriel du systme',
      'Email' => 'Courrier lectronique',
      'Realname' => 'Vritable Nom',
      'System Email Addresses Management' => 'Gestion des adresses courriel du systme',

    # Template: AdminUserForm
      'Add user' => 'Ajouter un utilisateur',
      'Change user settings' => 'Modification des paramtres utilisateurs',
      'Don\'t forget to add a new user to groups!' => 'Ne pas oublier d\'ajouter un nouvel utilisateur aux groupes&nbsp;!',
      'Firstname' => 'Prnom',
      'Lastname' => 'Nom',
      'User Management' => 'Administration des utilisateurs',
      'User will be needed to handle tickets.' => 'Un utilisateur sera ncessaire pour grer les tickets.',

    # Template: AdminUserGroupChangeForm
      'Change  settings' => 'Changer les param&ecirc;tres',
      'User <-> Group Management' => 'Gestion utilisateurs <-> groupes',

    # Template: AdminUserGroupForm
      'Change user <-> group settings' => 'Modifier les paramtres utilisateurs <-> groupes',

    # Template: AdminUserPreferencesGeneric

    # Template: AgentBounce
      'A message should have a To: recipient!' => 'Un message doit avoir un destinataire (&nbsp;:)!',
      'Bounce ticket' => 'Renvoyer le ticket',
      'Bounce to' => 'Renvoyer ',
      'Inform sender' => 'Informer l\'emetteur',
      'Next ticket state' => 'Prochain tat du ticket',
      'Send mail!' => 'Envoyer le courriel&nbsp;!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Il faut une adresse courriel (ecemple&nbsp;: client@exemple.fr)&nbsp;!',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Votre email avec le ticket numro "<OTRS_TICKET> est renvoyer  "<OTRS_BOUNCE_TO>". Contactez cette adresse pour de plus amples renseignements',

    # Template: AgentClose
      ' (work units)' => ' Unit de travail',
      'A message should have a subject!' => 'Un message doit avoir un sujet&nbsp;!',
      'Close ticket' => 'Ticket clos',
      'Close type' => 'Type de cloture',
      'Close!' => 'Clture!',
      'Note Text' => 'Note',
      'Note type' => 'Type de note',
      'Options' => '',
      'Spell Check' => 'Vrification orthographique',
      'Time units' => 'Unit de temps',
      'You need to account time!' => '',

    # Template: AgentCompose
      'A message must be spell checked!' => '',
      'Attach' => 'Attach',
      'Compose answer for ticket' => 'Composer une rponse pour le ticket',
      'for pending* states' => 'pour les tats d\'attente',
      'Is the ticket answered' => 'Est-ce que le ticket est rpondu',
      'Pending Date' => 'En attendant la date',

    # Template: AgentCustomer
      'Back' => 'retour',
      'Change customer of ticket' => 'Changer le numro de client du ticket',
      'CustomerID' => 'Numro de client#',
      'Search Customer' => 'Recherche de client',
      'Set customer user and customer id of a ticket' => '',

    # Template: AgentCustomerHistory
      'Customer history' => 'Historique du client',

    # Template: AgentCustomerHistoryTable

    # Template: AgentCustomerMessage
      'Follow up' => 'Note',
      'Next state' => '',

    # Template: AgentCustomerView
      'Customer Data' => 'Donnes client',

    # Template: AgentForward
      'Article type' => 'Type d\'article',
      'Date' => '',
      'End forwarded message' => 'Fin du message retransmit',
      'Forward article of ticket' => 'Transmettre l\'article du ticket',
      'Forwarded message from' => 'Message renvoy par',
      'Reply-To' => 'Rpondre ',

    # Template: AgentFreeText
      'Change free text of ticket' => '',
      'Value' => '',

    # Template: AgentHistoryForm
      'History of' => 'Historique de',

    # Template: AgentMailboxNavBar
      'All messages' => 'Tout les messages',
      'down' => 'bas',
      'Mailbox' => 'Bo&icirc;te aux lettres',
      'New' => 'Nouveau',
      'New messages' => 'Nouveaux messages',
      'Open' => 'Ouvrir',
      'Open messages' => 'Ouvrir des messages',
      'Order' => 'Ordre',
      'Pending messages' => 'Message en attente',
      'Reminder' => 'Rappel',
      'Reminder messages' => 'Message de rappel',
      'Sort by' => 'Trier par',
      'Tickets' => '',
      'up' => 'haut',

    # Template: AgentMailboxTicket

    # Template: AgentMove
      'Move Ticket' => '',
      'New Queue' => '',
      'New user' => 'Nouvel utilisateur',

    # Template: AgentNavigationBar
      'Locked tickets' => 'Tickets verrouills',
      'new message' => 'Nouveau message',
      'PhoneView' => 'Vue tlphone',
      'Preferences' => 'Prfrences',
      'Utilities' => 'Utilitaires',

    # Template: AgentNote
      'Add note to ticket' => 'Ajouter une note au ticket',
      'Note!' => '',

    # Template: AgentOwner
      'Change owner of ticket' => 'Changer le propritaire du ticket',
      'Message for new Owner' => 'Message pour le nouveau Propritaire',

    # Template: AgentPending
      'Pending date' => 'Date d\'attente',
      'Pending type' => 'Type d\'attente',
      'Pending!' => '',
      'Set Pending' => 'Dfinir l\'attente',

    # Template: AgentPhone
      'Customer called' => 'Client appel',
      'Phone call' => 'Appel tlphonique',
      'Phone call at %s' => 'Appel tlphonique  %s',

    # Template: AgentPhoneNew
      'Clear From' => '',
      'create' => '',
      'new ticket' => 'nouveau ticket',

    # Template: AgentPlain
      'ArticleID' => '',
      'Plain' => 'Tel quel',
      'TicketID' => '',

    # Template: AgentPreferencesCustomQueue
      'Select your custom queues' => 'Choix des files personnelles',

    # Template: AgentPreferencesForm

    # Template: AgentPreferencesGeneric

    # Template: AgentPreferencesPassword
      'Change Password' => 'Modification du mot de passe',
      'New password' => 'Nouveau mot de passe',
      'New password again' => 'Nouveau mot de passe (confirmation)',

    # Template: AgentPriority
      'Change priority of ticket' => 'Modification de la priorit du ticket',
      'New state' => 'Nouvel tat',

    # Template: AgentSpelling
      'Apply these changes' => 'Appliquer ces changements',
      'Discard all changes and return to the compose screen' => 'Annuler tout les changements et retourner  l\'cran de saisie',
      'Return to the compose screen' => 'Retourner  l\'cran de saisie',
      'Spell Checker' => 'Vrificateur orthographique',
      'spelling error(s)' => 'erreurs d\'orthographe',
      'The message being composed has been closed.  Exiting.' => 'Le message en cours de composition a t cltur. Sortie.',
      'This window must be called from compose window' => 'Cette fene&ecirc;tre doit &ecirc;tre appel de la fen&ecirc;tre de composition',

    # Template: AgentStatusView
      'D' => '',
      'of' => 'de',
      'Site' => '',
      'sort downward' => 'Tri dcroissant',
      'sort upward' => 'Tri croissant',
      'Ticket Status' => 'Status du Ticket',
      'U' => '',

    # Template: AgentStatusViewTable

    # Template: AgentStatusViewTableNotAnswerd

    # Template: AgentTicketLocked
      'Ticket locked!' => 'Ticket verrouill&nbsp;!',
      'Ticket unlock!' => '',

    # Template: AgentTicketPrint
      'by' => 'par',

    # Template: AgentTicketPrintHeader
      'Accounted time' => 'Temp pass',
      'Escalation in' => 'Escalade dans',
      'printed by' => 'Imprim par :',

    # Template: AgentUtilSearch
      'Article free text' => 'Texte dans l\'article',
      'Fulltext search (e. g. "Mar*in" or "Baue*" or "martin+hallo")' => 'Recherche intgral de texte (ex: "Mar*in" ou "Constru*" ou "martin+bonjour")',
      'search' => 'Recherche',
      'search (e. g. 10*5155 or 105658*)' => 'Recherche (ex: 10*5155 ou 105658*)',
      'Ticket free text' => 'Texte du ticket',
      'Ticket Search' => '',

    # Template: AgentUtilSearchByCustomerID
      'Customer history search' => 'recherche dans l\'historique client',
      'Customer history search (e. g. "ID342425").' => 'recherche dans l\'historique client (ex: "ID342425")',
      'No * possible!' => 'Pas de * possible',

    # Template: AgentUtilSearchNavBar
      'Results' => 'Rsultat',
      'Total hits' => 'Total des hits',

    # Template: AgentUtilSearchResult

    # Template: AgentUtilTicketStatus
      'All closed tickets' => '',
      'All open tickets' => 'Tous les tickets ouverts',
      'closed tickets' => '',
      'open tickets' => 'tickets ouverts',
      'or' => '',
      'Provides an overview of all' => 'Propose un aperu de tous',
      'So you see what is going on in your system.' => 'Donc vous voyez ce qui se passe sur votre syst&egrave;me',

    # Template: AgentZoomAgentIsCustomer
      'Compose Follow up' => '',
      'Your own Ticket' => '',

    # Template: AgentZoomAnswer
      'Compose Answer' => 'Composer une rponse',
      'Contact customer' => 'Contacter le client',
      'phone call' => 'Appel tlphonique',

    # Template: AgentZoomArticle
      'Split' => '',

    # Template: AgentZoomBody
      'Change queue' => 'Changer de file',

    # Template: AgentZoomHead
      'Free Fields' => '',
      'Print' => 'Imprimer',

    # Template: AgentZoomStatus

    # Template: CustomerCreateAccount
      'Create Account' => 'Crer un compte',

    # Template: CustomerError
      'Traceback' => '',

    # Template: CustomerFooter
      'Powered by' => '',

    # Template: CustomerHeader
      'Contact' => '',
      'Home' => 'Accueil',
      'Online-Support' => 'Support en ligne',
      'Products' => 'Produits',
      'Support' => '',

    # Template: CustomerLogin

    # Template: CustomerLostPassword
      'Lost your password?' => 'Mot de passe perdu ?',
      'Request new password' => 'Demande de nouveau mot de passe',

    # Template: CustomerMessage

    # Template: CustomerMessageNew

    # Template: CustomerNavigationBar
      'Create new Ticket' => 'Crtion d\'un nouveau Ticket',
      'My Tickets' => 'Mes tickets',
      'New Ticket' => 'Nouveau Ticket',
      'Ticket-Overview' => 'Aperu des Tickets',
      'Welcome %s' => 'Bienvenue %s',

    # Template: CustomerPreferencesForm

    # Template: CustomerPreferencesGeneric

    # Template: CustomerPreferencesPassword

    # Template: CustomerStatusView

    # Template: CustomerStatusViewTable

    # Template: CustomerTicketZoom

    # Template: CustomerWarning

    # Template: Error
      'Click here to report a bug!' => 'Cliquer ici pour signaler une anomalie',

    # Template: Footer
      'Top of Page' => '',

    # Template: Header

    # Template: InstallerBody
      'Create Database' => '',
      'Drop Database' => '',
      'Finished' => '',
      'System Settings' => '',
      'Web-Installer' => '',

    # Template: InstallerFinish
      'Admin-User' => '',
      'After doing so your OTRS is up and running.' => '',
      'Have a lot of fun!' => '',
      'Restart your webserver' => '',
      'Start page' => '',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => '',
      'Your OTRS Team' => '',

    # Template: InstallerLicense
      'accept license' => '',
      'don\'t accept license' => '',
      'License' => '',

    # Template: InstallerStart
      'Create new database' => '',
      'DB Admin Password' => '',
      'DB Admin User' => '',
      'DB Host' => '',
      'DB Type' => '',
      'default \'hot\'' => '',
      'Delete old database' => '',
      'next step' => 'tape suivante',
      'OTRS DB connect host' => '',
      'OTRS DB Name' => '',
      'OTRS DB Password' => '',
      'OTRS DB User' => '',
      'your MySQL DB should have a root password! Default is empty!' => '',

    # Template: InstallerSystem
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '',
      '(Email of the system admin)' => 'Email de l\'administrateur syst',
      '(Full qualified domain name of your system)' => 'Nom de domaine complet de votre machine',
      '(Logfile just needed for File-LogModule!)' => 'fichier de log ncessaire pour le Module File-Log',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(L\'identit du systme. Chaque numro de ticket et chaque id de session http d avec ce nombre)',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identificateur des tickets. Certaines personnes veulent le configurer avec par ex: \'Ticket#\', \'Appel#\' ou \'MonTicket#\')',
      '(Used default language)' => 'Langage par dfaut utilis',
      '(Used log backend)' => 'Backend de log utilis',
      '(Used ticket number format)' => 'format numrique utilis pour les tickets',
      'CheckMXRecord' => '',
      'Default Charset' => 'Charset par dfaut',
      'Default Language' => 'Langage par dfaut ',
      'Logfile' => 'fichier de log',
      'LogModule' => 'Module de log',
      'Organization' => 'Socit',
      'System FQDN' => 'Nom de Domaine Compltement Renseign du systme',
      'SystemID' => 'ID Systme',
      'Ticket Hook' => '',
      'Ticket Number Generator' => 'Gnrateur de numro pour les tickets',
      'Webfrontend' => 'Frontal web',

    # Template: Login

    # Template: LostPassword

    # Template: NoPermission
      'No Permission' => 'Pas d\'autorisation',

    # Template: Notify
      'Info' => '',

    # Template: PrintFooter
      'URL' => '',

    # Template: PrintHeader

    # Template: QueueView
      'All tickets' => 'tous les tickets',
      'Queues' => 'Files',
      'Tickets available' => 'Tickets disponibles',
      'Tickets shown' => 'Tickets affichs',

    # Template: SystemStats
      'Graphs' => 'Graphiques',

    # Template: Test
      'OTRS Test Page' => 'Page de test d\'OTRS',

    # Template: TicketEscalation
      'Ticket escalation!' => 'Escalade du ticket',

    # Template: TicketView

    # Template: TicketViewLite
      'Add Note' => 'Ajouter une note',

    # Template: Warning

    # Misc
      '(Click here to add a group)' => '(cliquer ici pour ajouter un groupe)',
      '(Click here to add a queue)' => '(cliquer ici pour ajouter une file)',
      '(Click here to add a response)' => '(cliquer ici pour ajouter une rponse)',
      '(Click here to add a salutation)' => '(cliquer ici pour ajouter une salutation)',
      '(Click here to add a signature)' => '(cliquer ici pour ajouter une signature)',
      '(Click here to add a system email address)' => '(cliquer ici pour ajouter une adresse courriel du systme)',
      '(Click here to add a user)' => '(cliquer ici pour ajouter un utilisateur)',
      '(Click here to add an auto response)' => '(cliquer ici pour ajouter une rponse automatique)',
      '(Click here to add charset)' => '(cliquer ici pour ajouter un jeu de caractres systme',
      '(Click here to add language)' => '(cliquer ici pour ajouter une langue)',
      '(Click here to add state)' => '(cliquer ici pour ajouter un tat)',
      'A message should have a From: recipient!' => 'Un message devrait avoir un champ From:',
      'Add language' => 'Ajouter une langue',
      'Backend' => '',
      'BackendMessage' => 'Message du Backend',
      'Change system language setting' => 'Modification des parmtres de langue du systme',
      'Create' => 'Crer',
      'FAQ' => '',
      'Feature not activ!' => 'Fonction non activ',
      'Fulltext search' => 'Recherche ingrale de texte',
      'Handle' => '',
      'New ticket via call.' => 'Nouveau ticket par tlphone',
      'Search in' => 'Recherche dans',
      'Set customer id of a ticket' => 'Dfinir le numro de client d\'un ticket',
      'Show all' => 'Tout montrer',
      'Status defs' => 'Dfinitions des Status',
      'System Language Management' => 'Gestion des langues du systme',
      'Ticket limit:' => 'limitation des Ticket',
      'Time till escalation' => 'Dure avant escalade',
      'Update auto response' => 'Actualiser une rponse automatique',
      'Update charset' => 'Actualiser un jeu de caractres systme',
      'Update group' => 'Actualiser un groupe',
      'Update language' => 'Actualiser une langue',
      'Update queue' => 'Actualiser une file',
      'Update response' => 'Actualiser une rponse',
      'Update salutation' => 'Actualiser une salutation',
      'Update signature' => 'Actualiser une signature',
      'Update state' => 'Actualiser un tat',
      'Update system address' => 'Actualiser les adresses courriel du systme',
      'Update user' => 'Actualiser un utilisateur',
      'Users' => 'Utilisateurs',
      'With State' => 'Avec l\'tat',
      'You have to be in the admin group!' => 'Il est ncessaire d\'tre dans le groupe d\'administration&nbsp;!',
      'You have to be in the stats group!' => 'Il est ncessaire d\'tre dans le groupe des statistiques&nbsp;!',
      'You need a email address (e. g. customer@example.com) in From:!' => 'Vous devez avoir une adresse email dans le From:! (ex: client@example.com) ',
      'auto responses set' => 'Rponse automatique positionne',
      'store' => 'stocker',
      'tickets' => 'Tickets',
    );

    # $$STOP$$

    $Self->{Translation} = \%Hash;

}
# --
1;
