# --
# Kernel/Language/cz.pm - provides cz language translation
# Copyright (C) 2003 Lukas Vicanek alias networ <lulka at centrum dot cz>
# Copyright (C) 2004 BENETA.cz, s.r.o. <info at beneta dot cz>
#	Translators: Marta Macalkova
#		     Vadim Buzek 
#		     Petr Ocasek
# --
# $Id: cz.pm,v 1.8 2004/02/15 21:49:35 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::cz;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.8 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;
    my %Hash = ();

    # $$START$$
    # Last translation Sun Feb 15 22:38:28 2004 by 

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D/%M/%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %Y %T';
    $Self->{DateInputFormat} = '%D/%M/%Y';
    $Self->{DateInputFormatLong} = '%D/%M/%Y - %T';

    %Hash = (
    # Template: AAABase
      ' 2 minutes' => ' 2 minuty',
      ' 5 minutes' => ' 5 minut',
      ' 7 minutes' => ' 7 minut',
      '(Click here to add)' => '(Pro pidn kliknte zde)',
      '10 minutes' => '10 minut',
      '15 minutes' => '15 minut',
      'AddLink' => 'Pidat Odkaz',
      'Admin-Area' => 'Administran zna',
      'agent' => 'agent',
      'Agent-Area' => 'Zna agent',
      'all' => 've',
      'All' => 'Ve',
      'Attention' => 'Upozornn',
      'before' => 'ped',
      'Bug Report' => 'Upozornn na chybu',
      'Cancel' => 'Stornovat',
      'change' => 'zmnit',
      'Change' => 'Zmnit',
      'change!' => 'zmnit!',
      'click here' => 'kliknte zde',
      'Comment' => 'Koment',
      'Customer' => 'Klient',
      'customer' => 'klient',
      'Customer Info' => 'Informace o klientovi',
      'day' => 'den',
      'day(s)' => 'den(dn)',
      'days' => 'dn(dny)',
      'description' => 'popis',
      'Description' => 'Popis',
      'Dispatching by email To: field.' => 'Piadit podle e-mailu - pole KOMU:.',
      'Dispatching by selected Queue.' => 'Piadit do vybran fronty.',
      'Don\'t show closed Tickets' => 'Nezobrazovat uzaven tikety',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Z bezpenostnch dvod nepracujte se superuivatelskm tem - vytvote si novho uivatele!',
      'Done' => 'Hotovo',
      'end' => 'konec',
      'Error' => 'Chyba',
      'Example' => 'Pklad',
      'Examples' => 'Pklady',
      'Facility' => 'Funkce',
      'FAQ-Area' => 'FAQ zna',
      'Feature not active!' => 'Funkce je neaktivn!',
      'go' => 'jdi',
      'go!' => 'jdi!',
      'Group' => 'Skupina',
      'Hit' => 'Pstup',
      'Hits' => 'Prstup',
      'hour' => 'hodina',
      'hours' => 'hodin',
      'Ignore' => 'Ignorovat',
      'invalid' => 'neplatn',
      'Invalid SessionID!' => 'Neplatn ID relace!',
      'Language' => 'Jazyk',
      'Languages' => 'Jazyky',
      'last' => 'posledn',
      'Line' => 'Linka',
      'Lite' => 'Omezen',
      'Login failed! Your username or password was entered incorrectly.' => 'Pihlen nespn! Vae uivatelsk jmno i heslo bylo zadno nesprvn.',
      'Logout successful. Thank you for using OTRS!' => 'Odhlen bylo spsn. Dkujeme Vm za pouvn OTRS!',
      'Message' => 'Zprva',
      'minute' => 'minuta',
      'minutes' => 'minut',
      'Module' => 'Modul',
      'Modulefile' => 'Modulov soubor',
      'month(s)' => 'msc(e)',
      'Name' => 'Jmno',
      'New Article' => 'Nov poloka',
      'New message' => 'Nov zprva',
      'New message!' => 'Nov zprva!',
      'No' => 'Ne',
      'no' => 'ne',
      'No entry found!' => 'Nebyl nalezen dn zznam!',
      'No suggestions' => 'dn nvrhy',
      'none' => 'dn',
      'none - answered' => 'dn - odpovzeno',
      'none!' => 'dn!',
      'Normal' => 'Normln',
      'Off' => 'Vypnuto',
      'off' => 'vypnuto',
      'On' => 'Zapnuto',
      'on' => 'zapnuto',
      'Password' => 'Heslo',
      'Pending till' => 'ekn na vyzen do',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Prosm, odpovzte na tento (tyto) tiket(y) pro nvrat do normlnho nhledu fronty!',
      'Please contact your admin' => 'Kontaktujte, prosm, Vaeho administrtora',
      'please do not edit!' => 'prosme neupravujte!',
      'Please go away!' => 'Prosme odejdte!',
      'possible' => 'mon',
      'Preview' => 'Zobrazit',
      'QueueView' => 'Nhled fronty',
      'reject' => 'zamtnout',
      'replace with' => 'nahradit',
      'Reset' => 'Reset',
      'Salutation' => 'Osloven',
      'Session has timed out. Please log in again.' => 'Relace vyprela. Prosm, pihlate se znovu.',
      'Show closed Tickets' => 'Zobrazit zaven tikety',
      'Signature' => 'Podpis',
      'Sorry' => 'Omluva',
      'Stats' => 'Statistiky',
      'Subfunction' => 'Podfunkce',
      'submit' => 'odeslat',
      'submit!' => 'Odeslat!',
      'system' => 'systm',
      'Take this User' => 'Pouj tohoto uivatele',
      'Text' => 'Text',
      'The recommended charset for your language is %s!' => 'Doporuen znakov sada pro V jazyk je %s!',
      'Theme' => 'Design',
      'There is no account with that login name.' => 'dn et s tmto pihlaovacm jmnem neexistuje.',
      'Timeover' => 'as vyprel',
      'To: (%s) replaced with database email!' => 'To: (%s) nahrazeno emailem z databze!',
      'top' => 'nahoru',
      'update' => 'aktualizovat',
      'Update' => 'Aktualizovat',
      'update!' => 'aktualizovat!',
      'User' => 'Uivatel',
      'Username' => 'Jmno uivatele',
      'Valid' => 'Platnost',
      'Warning' => 'Varovn',
      'week(s)' => 'tden(tdny)',
      'Welcome to OTRS' => 'Vtejte v OTRS',
      'Word' => 'Slovo',
      'wrote' => 'napsal',
      'year(s)' => 'rok(y)',
      'yes' => 'ano',
      'Yes' => 'Ano',
      'You got new message!' => 'Mte novou zprvu!',
      'You have %s new message(s)!' => 'Mte %s novou zprvu (novch zprv)!',
      'You have %s reminder ticket(s)!' => 'Mte %s upomnkov(ch) ticket()',

    # Template: AAAMonth
      'Apr' => 'Dub',
      'Aug' => 'Srp',
      'Dec' => 'Pro',
      'Feb' => 'no',
      'Jan' => 'Led',
      'Jul' => 'er',
      'Jun' => 'vc',
      'Mar' => 'Be',
      'May' => 'Kv',
      'Nov' => 'Lis',
      'Oct' => 'j',
      'Sep' => 'Z',

    # Template: AAAPreferences
      'Closed Tickets' => 'Uzaven Tikety',
      'CreateTicket' => 'Vytvoeno Tiketu',
      'Custom Queue' => 'Vlastn fronta',
      'Follow up notification' => 'Nsledujc oznmen',
      'Frontend' => 'Rozhran',
      'Mail Management' => 'Sprva e-mail',
      'Max. shown Tickets a page in Overview.' => 'Max. zobrazench tiket v pehledu na strnku',
      'Max. shown Tickets a page in QueueView.' => 'Max. zobrazench tiket v nhledu fronty na strnku',
      'Move notification' => 'Pesunout oznmen',
      'New ticket notification' => 'Nov oznmen tiketu',
      'Other Options' => 'Jin monosti',
      'PhoneView' => 'Nov tiket / hovor',
      'Preferences updated successfully!' => 'Nastaven spn aktualizovno!',
      'QueueView refresh time' => 'Doba obnoven nhledu fronty',
      'Screen after new ticket' => '',
      'Select your default spelling dictionary.' => 'Vyberte si V vchoz pravopisn slovnk',
      'Select your frontend Charset.' => 'Vyberte si znakovou sadu Vaeho rozhran.',
      'Select your frontend language.' => 'Vyberte si jazyk Vaeho rozhran.',
      'Select your frontend QueueView.' => 'Vyberte si nhled fronty Vaeho rozhran.',
      'Select your frontend Theme.' => 'Vyberte si design Vaeho rozhran.',
      'Select your QueueView refresh time.' => 'Vyberte si dobu obnoven nhledu fronty.',
      'Select your screen after creating a new ticket.' => '',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Poli mi oznmen, pokud klient pole nsledujc a jsem vlastnk tohoto tiketu.',
      'Send me a notification if a ticket is moved into a custom queue.' => 'Poli mi oznmen, pokud je tiket pesunut do Vlastn fronty.',
      'Send me a notification if a ticket is unlocked by the system.' => 'Poli mi oznmen, pokud je tiket odemknut systmem.',
      'Send me a notification if there is a new ticket in my custom queues.' => 'Poli mi oznmen, pokud je nov tiket v mch vlastnch frontch.',
      'Show closed tickets.' => 'Ukzat uzaven tikety.',
      'Spelling Dictionary' => 'Slovnk kontroly pravopisu',
      'Ticket lock timeout notification' => 'Oznmen o vypren asu uzamen tiketu',
      'TicketZoom' => 'Zobrazen tiketu',

    # Template: AAATicket
      '1 very low' => '1 velmi nzk',
      '2 low' => '2 nzk',
      '3 normal' => '3 normln',
      '4 high' => '4 vysok',
      '5 very high' => '5 velmi vysok',
      'Action' => 'Akce',
      'Age' => 'St',
      'Article' => 'Poloka',
      'Attachment' => 'Ploha',
      'Attachments' => 'Plohy',
      'Bcc' => 'Slep kopie',
      'Bounce' => 'Odeslat zpt',
      'Cc' => 'Kopie',
      'Close' => 'Zavt',
      'closed successful' => 'uzaveno - vyeeno',
      'closed unsuccessful' => 'uzaveno - nevyeeno',
      'Compose' => 'Sestavit',
      'Created' => 'Vytvoeno',
      'Createtime' => 'Doba vytvoen',
      'email' => 'email',
      'eMail' => 'eMail',
      'email-external' => 'extern email',
      'email-internal' => 'intern email',
      'Forward' => 'Pedat',
      'From' => 'Od',
      'high' => 'vysok',
      'History' => 'Historie',
      'If it is not displayed correctly,' => 'Pokud nen zobrazeno sprvn,',
      'lock' => 'zameno',
      'Lock' => 'Zmek',
      'low' => 'nzk',
      'Move' => 'Pesunout',
      'new' => 'nov',
      'normal' => 'normaln',
      'note-external' => 'poznmka-extern',
      'note-internal' => 'poznmka-intern',
      'note-report' => 'poznmka-report',
      'open' => 'otevt',
      'Owner' => 'Vlastnk',
      'Pending' => 'ek na vyzen',
      'pending auto close+' => 'ek na vyzen - automaticky zavt+',
      'pending auto close-' => 'ek na vyzen - automaticky zavt-',
      'pending reminder' => 'upomnka pi ekn na vyzen',
      'phone' => 'telefon',
      'plain' => 'jednoduch',
      'Priority' => 'Priorita',
      'Queue' => 'Fronta',
      'removed' => 'odstrann',
      'Sender' => 'Odeslatel',
      'sms' => 'sms',
      'State' => 'Stav',
      'Subject' => 'Pedmt',
      'This is a' => 'Toto je',
      'This is a HTML email. Click here to show it.' => 'Toto je HTML email. Pro zobrazen kliknte zde.',
      'This message was written in a character set other than your own.' => 'Tato zprva byla napsna v jin znakov sad ne Vae.',
      'Ticket' => 'Tiket',
      'Ticket "%s" created!' => 'Tiket "%s" vytvoen!',
      'To' => 'Komu',
      'to open it in a new window.' => 'pro oteven v novm okn.',
      'unlock' => 'nezamen',
      'Unlock' => 'Zmek',
      'very high' => 'velmi vysok',
      'very low' => 'velmi nzk',
      'View' => 'Nhled',
      'webrequest' => 'poadavek pes web',
      'Zoom' => 'Zobrazit',

    # Template: AAAWeekDay
      'Fri' => 'P',
      'Mon' => 'Po',
      'Sat' => 'So',
      'Sun' => 'Ne',
      'Thu' => 't',
      'Tue' => 't',
      'Wed' => 'St',

    # Template: AdminAttachmentForm
      'Add' => 'Pidat',
      'Attachment Management' => 'Sprva ploh',

    # Template: AdminAutoResponseForm
      'Add auto response' => 'Pidat automatickou odpov',
      'Auto Response From' => 'Automatick odpov Od',
      'Auto Response Management' => 'Sprva automatickch odpovd',
      'Change auto response settings' => 'Zmnit nastaven automatickch odpovd',
      'Note' => 'Poznmka',
      'Response' => 'Odpov',
      'to get the first 20 character of the subject' => 'pro zskni prvnch 20 znak z pedmtu',
      'to get the first 5 lines of the email' => 'pro zskn prvnch 5 dk z emailu',
      'to get the from line of the email' => 'pro zskan dku Od z emailu',
      'to get the realname of the sender (if given)' => 'pro zskan skutenho jmna odeslatele (pokud je zadno)',
      'to get the ticket id of the ticket' => 'pro zskn ID tiketu z tiketu',
      'to get the ticket number of the ticket' => 'pro zskn sla tiketu z tiketu',
      'Type' => 'Typ',
      'Useable options' => 'Dostupn monosti',

    # Template: AdminCustomerUserForm
      'Customer User Management' => 'Sprva Klient',
      'Customer user will be needed to to login via customer panels.' => 'Klient se mus pihlasit pes panely klient.',
      'Select source:' => '',
      'Source' => '',

    # Template: AdminCustomerUserGeneric

    # Template: AdminCustomerUserGroupChangeForm
      'Change %s settings' => 'Zmnit nastaven %s',
      'Customer User <-> Group Management' => 'Klient <-> Sprva skupiny',
      'Full read and write access to the tickets in this group/queue.' => 'Pln pstup pro ten a psan do tiket v tto skupin/front.',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Pokud nebylo nic vybrno, nejsou v tto skupin dn prva (tikety nebudou pro uivatele dostupn).',
      'Permission' => 'Prva',
      'Read only access to the ticket in this group/queue.' => 'Pstup pouze pro ten tiketu v tto skupin/ad.',
      'ro' => 'jen ten',
      'rw' => 'ten/psan',
      'Select the user:group permissions.' => 'Vybrat uivatele:prva skupiny',

    # Template: AdminCustomerUserGroupForm
      'Change user <-> group settings' => 'Zmnit uivatele <-> nastaven skupiny',

    # Template: AdminCustomerUserPreferencesGeneric

    # Template: AdminEmail
      'Admin-Email' => 'Email administrtora',
      'Body' => 'Tlo',
      'OTRS-Admin Info!' => 'Informace o OTRS-Administrtorovi!',
      'Recipents' => 'Adresti',
      'send' => 'poslat',

    # Template: AdminEmailSent
      'Message sent to' => 'Zprva odeslna',

    # Template: AdminGroupForm
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Vytvoit nov skupiny pro piazen prv pstup ruznm skupinm agent (nap. oddlen nkupu, oddlen podpory, oddlen prodeje...).',
      'Group Management' => 'Sprva skupiny',
      'It\'s useful for ASP solutions.' => 'To je vhodn pro een ASP',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'Skupina administrtora m pstup do administran a statistick zny.',

    # Template: AdminLog
      'System Log' => 'Log systmu',

    # Template: AdminNavigationBar
      'AdminEmail' => 'Email Administrtora',
      'Attachment <-> Response' => 'Ploha <-> Odpov',
      'Auto Response <-> Queue' => 'Automatick odpov <-> Fronta',
      'Auto Responses' => 'Automatick odpovdi',
      'Customer User' => 'Klient - Uivatel',
      'Customer User <-> Groups' => 'Klient  - Uivatel <-> Skupiny',
      'Email Addresses' => 'Emailov adresy',
      'Groups' => 'Skupiny',
      'Logout' => 'Odhlsit',
      'Misc' => 'Rzn',
      'Notifications' => 'Oznmen',
      'PostMaster Filter' => 'PostMaster filtr',
      'PostMaster POP3 Account' => 'PostMaster POP3 et',
      'Responses' => 'Odpovdi',
      'Responses <-> Queue' => 'Odpovdi <-> Fronta',
      'Select Box' => 'Poadavek na SQL databzi',
      'Session Management' => 'Sprva relace',
      'Status' => 'Stav',
      'System' => 'Systm',
      'User <-> Groups' => 'Uivatel <-> Skupiny',

    # Template: AdminNotificationForm
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
      'Notification Management' => 'Sprva oznmen',
      'Notifications are sent to an agent or a customer.' => 'Oznmen jsou odeslna agentovi i klientovi',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => '',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => '',

    # Template: AdminPOP3Form
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Vechny pchoz emaily z danho tu budou zaazeny do vybran fronty!',
      'Dispatching' => 'Zaazen',
      'Host' => 'Hostitel',
      'If your account is trusted, the x-otrs header (for priority, ...) will be used!' => 'Pokud je V et oven, x-OTRS hlaviky (pro dleitost, ...) budou pouvny!',
      'Login' => '',
      'POP3 Account Management' => 'Sprva POP3 t',
      'Trusted' => 'Oveno',

    # Template: AdminPostMasterFilterForm
      'Match' => 'Obsahuje',
      'PostMasterFilter Management' => 'Sprva PostMaster filtru',
      'Set' => 'Nastavit',

    # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Response Management' => 'Fronta <-> Sprva automatickch opovd',

    # Template: AdminQueueAutoResponseTable

    # Template: AdminQueueForm
      '0 = no escalation' => '0 = dn stupovn',
      '0 = no unlock' => '0 = dn odemknut',
      'Customer Move Notify' => 'Oznmen Klientovi o zmn fronty',
      'Customer Owner Notify' => 'Oznmen Klientovi o zmn vlastnka',
      'Customer State Notify' => 'Oznmen Klientovi o zmn stavu',
      'Escalation time' => 'Doba stupovn',
      'Follow up Option' => 'Nsledujc volba',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Pokud je tiket uzaven a klient odele nsledujc, tiket bude pro starho vlastnka uzamknut.',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Nebude-li tiket odpovzen v danm ase, bude zobrazen pouze tento Tiket.',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Pokud agent uzamkne tiket a neodele v tto dob odpov, tiket bude automaticky odemknut. Tak se stane tiket viditeln pro vechny ostatn agenty.',
      'Key' => 'Kl',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS pole klientovi emailem oznmen, pokud bude tiket pesunut.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS pole klientovi emailem oznmen, pokud se zmn vlastnk tiketu.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS pole klientovi emailem oznmen, pokud se zmn stav tiketu.',
      'Queue Management' => 'Sprva front',
      'Sub-Queue of' => 'Podfronta ',
      'Systemaddress' => 'Systmov adresa',
      'The salutation for email answers.' => 'Osloven pro emailov odpovdi.',
      'The signature for email answers.' => 'Podpis pro emailov odpovdi.',
      'Ticket lock after a follow up' => 'Zamknout tiket po nsledujcm',
      'Unlock timeout' => 'as do odemknut',
      'Will be the sender address of this queue for email answers.' => 'Bude adresou odeslatele z tto fronty pro emailov odpovdi.',

    # Template: AdminQueueResponsesChangeForm
      'Std. Responses <-> Queue Management' => 'Standartn odpovdi <-> Sprva front',

    # Template: AdminQueueResponsesForm
      'Answer' => 'Odpov',
      'Change answer <-> queue settings' => 'Zmnit odpov <-> nastaven fronty',

    # Template: AdminResponseAttachmentChangeForm
      'Std. Responses <-> Std. Attachment Management' => 'Standartn odpovdi <-> Standartn sprva ploh',

    # Template: AdminResponseAttachmentForm
      'Change Response <-> Attachment settings' => 'Zmnit odpov <-> Nastaven ploh',

    # Template: AdminResponseForm
      'A response is default text to write faster answer (with default text) to customers.' => 'Odpov je obsahuje vchoz text slouc k rychlej reakci (spolu s vchozm textem) klientm.',
      'Don\'t forget to add a new response a queue!' => 'Nezapomete pidat novou reakci odpove do fronty!',
      'Next state' => 'Nasledujc stav',
      'Response Management' => 'Sprva odpovd',
      'The current ticket state is' => 'Aktuln stav tiketu je',

    # Template: AdminSalutationForm
      'customer realname' => 'skuten jmno klienta',
      'for agent firstname' => 'pro kestn jmno agenta',
      'for agent lastname' => 'pro pjmen agenta',
      'for agent login' => 'pro pihlen agenta',
      'for agent user id' => 'pro uivatelsk ID agenta',
      'Salutation Management' => 'Sprva osloven',

    # Template: AdminSelectBoxForm
      'Max Rows' => 'Max. poet dk',

    # Template: AdminSelectBoxResult
      'Limit' => 'Limit',
      'Select Box Result' => 'Vsledek SQL dotazu',
      'SQL' => 'SQL',

    # Template: AdminSession
      'Agent' => 'Agent',
      'kill all sessions' => 'Zruit vechny relace',
      'Overview' => 'Pehled',
      'Sessions' => 'Relace',
      'Uniq' => 'Poet',

    # Template: AdminSessionTable
      'kill session' => 'zruit relaci',
      'SessionID' => 'ID relace',

    # Template: AdminSignatureForm
      'Signature Management' => 'Sprva podpis',

    # Template: AdminStateForm
      'See also' => 'Viz. tak',
      'State Type' => 'Typ stavu',
      'System State Management' => 'Sprva stavu systmu',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Ujistte se, e jste aktualizovali tak vchoz hodnoty ve Vaem Kernel/Config.pm!',

    # Template: AdminSystemAddressForm
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Vechny pchoz emaily obsahujc tohoto adresta (v poli KOMU) budou zaazeny to vybran fronty!',
      'Email' => 'Email',
      'Realname' => 'Skuten jmno',
      'System Email Addresses Management' => 'Sprva emailovch adres systmu',

    # Template: AdminUserForm
      'Don\'t forget to add a new user to groups!' => 'Nezapomete pidat novho uivatele do skupin!',
      'Firstname' => 'Kestn jmno',
      'Lastname' => 'Pjmen',
      'User Management' => 'Sprva uivatel',
      'User will be needed to handle tickets.' => 'Uivatel bude potebovat prva pro ovldn tiket.',

    # Template: AdminUserGroupChangeForm
      'create' => 'vytvoit',
      'move_into' => 'pesunout do',
      'owner' => 'vlastnk',
      'Permissions to change the ticket owner in this group/queue.' => 'Prva zmnit vlastnk tiketu v tto skupin/front',
      'Permissions to change the ticket priority in this group/queue.' => 'Prva zmnit prioritu tiketu v tto skupin/front',
      'Permissions to create tickets in this group/queue.' => 'Prva vytvoit tikety v tto skupin/front',
      'Permissions to move tickets into this group/queue.' => 'Prva pesunout tikety do tto skupiny/fronty',
      'priority' => 'priorita',
      'User <-> Group Management' => 'Sprva uivatel <-> skupin',

    # Template: AdminUserGroupForm

    # Template: AdminUserPreferencesGeneric

    # Template: AgentBook
      'Address Book' => 'Adres',
      'Discard all changes and return to the compose screen' => 'Zruit vechny zmny a vrtit se zpt do okna vytven',
      'Return to the compose screen' => 'Vrtit se zpt do okna vytven',
      'Search' => 'Vyhledat',
      'The message being composed has been closed.  Exiting.' => 'Vytven zprva byla uzavena. Opoutm.',
      'This window must be called from compose window' => 'Toto okno mus bt vyvolno z okna vytven',

    # Template: AgentBounce
      'A message should have a To: recipient!' => 'Zprva by mla obsahovat Komu: pjemce!',
      'Bounce ticket' => 'Odeslat tiket zpt',
      'Bounce to' => 'Odeslat zpt',
      'Inform sender' => 'Informovat odeslatele',
      'Next ticket state' => 'Nsledujc stav tiketu',
      'Send mail!' => 'Poslat mail!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Muste mt  uvedenu emailovou adresu (nap. klient@priklad.cz) v poli Komu:!',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'V email s slem ticketu "<OTRS_TICKET>" je odesln zpt na "<OTRS_BOUNCE_TO>". Kontaktujte tuto adresu pro dal infromace.',

    # Template: AgentClose
      ' (work units)' => '(jednotky prce)',
      'A message should have a body!' => 'Zprva by mla mt tlo!',
      'A message should have a subject!' => 'Zprva by mla mt pedmt!',
      'Close ticket' => 'Zavt tiket',
      'Close type' => 'Zavt typ',
      'Close!' => 'Zavt!',
      'Note Text' => 'Text poznmky',
      'Note type' => 'Typ poznmky',
      'Options' => 'Monosti',
      'Spell Check' => 'Kontrola pravopisu',
      'Time units' => 'Jednotky asu',
      'You need to account time!' => 'Potebujete tovat dobu!',

    # Template: AgentCompose
      'A message must be spell checked!' => 'Zprva mus bt pravopisn zkontrolovan!',
      'Attach' => 'Pipojit',
      'Compose answer for ticket' => 'Sestavit odpov pro tiket',
      'for pending* states' => 'pro stavy ekn na vyzen*',
      'Is the ticket answered' => 'Je tiket zodpovzen',
      'Pending Date' => 'Doba ekn na vyzen',

    # Template: AgentCustomer
      'Back' => 'Zpt',
      'Change customer of ticket' => 'Zmnit klienta tiketu',
      'CustomerID' => 'ID klienta',
      'Search Customer' => 'Vyhledat klienta',
      'Set customer user and customer id of a ticket' => 'Nastavit klienta a nastavit ID klienta tiketu',

    # Template: AgentCustomerHistory
      'All customer tickets.' => 'Vechny tikety klienta',
      'Customer history' => 'Historie klienta',

    # Template: AgentCustomerMessage
      'Follow up' => 'Nsledujc',

    # Template: AgentCustomerView
      'Customer Data' => 'Data klienta',

    # Template: AgentEmailNew
      'All Agents' => 'Vichni agenti',
      'Clear From' => 'Vymazat pole Od',
      'Compose Email' => '',
      'Lock Ticket' => 'Zamknout tiket',
      'new ticket' => 'nov tiket',

    # Template: AgentForward
      'Article type' => 'Typ poloky',
      'Date' => 'Datum',
      'End forwarded message' => 'Konec pedan zprvy',
      'Forward article of ticket' => 'Pedat poloku tiketu',
      'Forwarded message from' => 'Pedat zprvu od',
      'Reply-To' => 'Odpovdt-Komu',

    # Template: AgentFreeText
      'Change free text of ticket' => 'Zmnit pln text tiketu',
      'Value' => 'Hodnota',

    # Template: AgentHistoryForm
      'History of' => 'Historie',

    # Template: AgentMailboxNavBar
      'All messages' => 'Vechny zprvy',
      'down' => 'dol',
      'Mailbox' => 'Potovn schrnka',
      'New' => 'Nov',
      'New messages' => 'Nov zprvy',
      'Open' => 'Otevt',
      'Open messages' => 'Otevt zprvy',
      'Order' => 'Seadit',
      'Pending messages' => 'Zprvy ekajc na vyzen',
      'Reminder' => 'Upomnka',
      'Reminder messages' => 'Upomnkov zprvy',
      'Sort by' => 'Setdit dle',
      'Tickets' => 'Tikety',
      'up' => 'nahoru',

    # Template: AgentMailboxTicket
      '"}' => '"}',
      '"}","14' => '"}","14',

    # Template: AgentMove
      'Move Ticket' => 'Pesunout tiket',
      'New Owner' => 'Nov vlastnk',
      'New Queue' => 'Nov fronta',
      'Previous Owner' => 'Pedchoz vlastnk',
      'Queue ID' => 'ID fronty',

    # Template: AgentNavigationBar
      'Locked tickets' => 'Uzamen tikety',
      'new message' => 'Potovn schrnka',
      'Preferences' => 'Nastaven',
      'Utilities' => 'Pomcky',

    # Template: AgentNote
      'Add note to ticket' => 'Pidat poznmku k tiketu',
      'Note!' => 'Poznmka!',

    # Template: AgentOwner
      'Change owner of ticket' => 'Zmnit vlastnka tiketu',
      'Message for new Owner' => 'Zprva pro novho vlastnka',

    # Template: AgentPending
      'Pending date' => 'Datum ekn na vyzen',
      'Pending type' => 'Typ ekn na vyzen',
      'Pending!' => 'ek na vyzen!',
      'Set Pending' => 'Nastavit - ek na vyzen',

    # Template: AgentPhone
      'Customer called' => 'Klient volal',
      'Phone call' => 'Telefon hovor',
      'Phone call at %s' => 'Telefon hovor v %s',

    # Template: AgentPhoneNew

    # Template: AgentPlain
      'ArticleID' => 'ID poloky',
      'Plain' => 'Jednoduch',
      'TicketID' => 'ID tiketu',

    # Template: AgentPreferencesCustomQueue
      'Select your custom queues' => 'Vyberte si Vae vlastn fronty',

    # Template: AgentPreferencesForm

    # Template: AgentPreferencesGeneric

    # Template: AgentPreferencesPassword
      'Change Password' => 'Zmnit heslo',
      'New password' => 'Nov heslo',
      'New password again' => 'Nov heslo (znovu )',

    # Template: AgentPriority
      'Change priority of ticket' => 'Zmnit dleitost tiketu',

    # Template: AgentSpelling
      'Apply these changes' => 'Aplikovat tyto zmny',
      'Spell Checker' => 'Funkce na kontrolu pravopisu',
      'spelling error(s)' => 'chyba(y) v pravopisu',

    # Template: AgentStatusView
      'D' => 'A-Z',
      'of' => 'z',
      'Site' => 'Umstn',
      'sort downward' => 'setdit dol',
      'sort upward' => 'setdit nahoru',
      'Ticket Status' => 'Stav tiketu',
      'U' => 'Z-A',

    # Template: AgentStatusViewTable

    # Template: AgentStatusViewTableNotAnswerd

    # Template: AgentTicketLink
      'Link' => 'Odkaz',
      'Link to' => 'Odkaz na',

    # Template: AgentTicketLocked
      'Ticket locked!' => 'Tiket zamknut!',
      'Ticket unlock!' => 'Tiket odemknut!',

    # Template: AgentTicketPrint
      'by' => 'pes',

    # Template: AgentTicketPrintHeader
      'Accounted time' => 'tovan doba',
      'Escalation in' => 'Stupovn v',

    # Template: AgentUtilSearch
      '(e. g. 10*5155 or 105658*)' => '(nap. 10*5155 or 105658*)',
      '(e. g. 234321)' => '(nap. 234321)',
      '(e. g. U5150)' => '(nap. U5150)',
      'and' => 'a',
      'Customer User Login' => 'Pihlen klienta',
      'Delete' => 'Smazat',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Fulltextov vyhledvn v poloce (nap. "Mar*in" or "Baue*")',
      'No time settings.' => 'dn nastaven doby',
      'Profile' => 'Profil',
      'Result Form' => 'Forma vsledku',
      'Save Search-Profile as Template?' => 'Uloit profil vyhledvn jako ablonu?',
      'Search-Template' => 'Forma vyhledvn',
      'Select' => 'Vybrat',
      'Ticket created' => 'Tiket vytvoen',
      'Ticket created between' => 'Tiket vytvoen mezi',
      'Ticket Search' => 'Hledn tiketu',
      'TicketFreeText' => 'Voln text tiketu',
      'Times' => 'Doba',
      'Yes, save it with name' => 'Ano, uloit pod nzvem',

    # Template: AgentUtilSearchByCustomerID
      'Customer history search' => 'Vyhledvn historie klienta',
      'Customer history search (e. g. "ID342425").' => 'Vyhledvn historie klienta (nap. "ID342425")',
      'No * possible!' => 'dn * mon!',

    # Template: AgentUtilSearchNavBar
      'Change search options' => 'Zmnit monosti vyhledvn',
      'Results' => 'Vsledky',
      'Search Result' => 'Vsledky vyhledvn',
      'Total hits' => 'Celkov poet zznam',

    # Template: AgentUtilSearchResult
      '"}","15' => '"}","15',

    # Template: AgentUtilSearchResultPrint

    # Template: AgentUtilSearchResultPrintTable
      '"}","30' => '"}","30',

    # Template: AgentUtilSearchResultShort

    # Template: AgentUtilSearchResultShortTable

    # Template: AgentUtilSearchResultShortTableNotAnswered

    # Template: AgentUtilTicketStatus
      'All closed tickets' => 'Vechny uzaven tikety',
      'All open tickets' => 'Vechny oteven tikety',
      'closed tickets' => 'uzaven tikety',
      'open tickets' => 'oteven tikety',
      'or' => 'nebo',
      'Provides an overview of all' => 'Poskytnou pehled vech',
      'So you see what is going on in your system.' => 'Tady vidte, co se odehrv ve Vaem systmu.',

    # Template: AgentZoomAgentIsCustomer
      'Compose Follow up' => 'Sestavit nsledujc',
      'Your own Ticket' => 'V vlastn tiket',

    # Template: AgentZoomAnswer
      'Compose Answer' => 'Odpovdt',
      'Contact customer' => 'Kontaktovat klienta',
      'phone call' => 'telefon hovor',

    # Template: AgentZoomArticle
      'Split' => 'Rozdlit',

    # Template: AgentZoomBody
      'Change queue' => 'Zmnit frontu',

    # Template: AgentZoomHead
      'Free Fields' => 'Voln pole',
      'Print' => 'Tisknout',

    # Template: AgentZoomStatus
      '"}","18' => '"}","18',

    # Template: CustomerCreateAccount
      'Create Account' => 'Vytvoit et',

    # Template: CustomerError
      'Traceback' => 'Jt zpt',

    # Template: CustomerFAQArticleHistory
      'Edit' => 'Editovat',
      'FAQ History' => 'Historie FAQ',

    # Template: CustomerFAQArticlePrint
      'Category' => 'Kategorie',
      'Keywords' => 'Klov slova',
      'Last update' => 'Posledn aktualizace',
      'Problem' => 'Problm',
      'Solution' => 'een',
      'Symptom' => 'Pznak',

    # Template: CustomerFAQArticleSystemHistory
      'FAQ System History' => 'Historie FAQ systmu',

    # Template: CustomerFAQArticleView
      'FAQ Article' => 'FAQ lnek',
      'Modified' => 'Zmnno',

    # Template: CustomerFAQOverview
      'FAQ Overview' => 'Pehled FAQ',

    # Template: CustomerFAQSearch
      'FAQ Search' => 'Vyhledat FAQ',
      'Fulltext' => 'Fulltext',
      'Keyword' => 'Klov slovo',

    # Template: CustomerFAQSearchResult
      'FAQ Search Result' => 'Vsledky vyhledvn FAQ',

    # Template: CustomerFooter
      'Powered by' => 'Vytvoeno',

    # Template: CustomerHeader
      'Contact' => 'Konktakt',
      'Home' => 'Dom',
      'Online-Support' => 'Online Podpora',
      'Products' => 'Produkty',
      'Support' => 'Podpora',

    # Template: CustomerLogin

    # Template: CustomerLostPassword
      'Lost your password?' => 'Ztratil/a jste heslo?',
      'Request new password' => 'Podat o nov heslo',

    # Template: CustomerMessage

    # Template: CustomerMessageNew

    # Template: CustomerNavigationBar
      'Create new Ticket' => 'Vytvoit nov tiket',
      'FAQ' => 'FAQ',
      'New Ticket' => 'Nov tiket',
      'Ticket-Overview' => 'Pehled tiket',
      'Welcome %s' => 'Vtejte %s',

    # Template: CustomerPreferencesForm

    # Template: CustomerPreferencesGeneric

    # Template: CustomerPreferencesPassword

    # Template: CustomerStatusView
      'My Tickets' => 'Moje tikety',

    # Template: CustomerStatusViewTable

    # Template: CustomerTicketZoom

    # Template: CustomerWarning

    # Template: Error
      'Click here to report a bug!' => 'Kliknte zde pro nahlen chyby!',

    # Template: FAQArticleDelete
      'FAQ Delete' => 'Mazn FAQ',
      'You really want to delete this article?' => 'Chcete opravdu smazat tento lnek?',

    # Template: FAQArticleForm
      'Comment (internal)' => 'Koment (intern)',
      'Filename' => 'Nzev souboru',
      'Short Description' => 'Krtk popis',

    # Template: FAQArticleHistory

    # Template: FAQArticlePrint

    # Template: FAQArticleSystemHistory

    # Template: FAQArticleView

    # Template: FAQCategoryForm
      'FAQ Category' => 'Kategorie FAQ',

    # Template: FAQLanguageForm
      'FAQ Language' => 'Jazyk FAQ',

    # Template: FAQNavigationBar

    # Template: FAQOverview

    # Template: FAQSearch

    # Template: FAQSearchResult

    # Template: FAQStateForm
      'FAQ State' => 'Stav FAQ',

    # Template: Footer
      'Top of Page' => 'Hlava strnky',

    # Template: Header

    # Template: InstallerBody
      'Create Database' => 'Vytvoit Databazi',
      'Drop Database' => 'Odstranit databazi',
      'Finished' => 'Dokoneno',
      'System Settings' => 'Nastaven systmu',
      'Web-Installer' => 'Web-instaltor',

    # Template: InstallerFinish
      'Admin-User' => 'Administrtor',
      'After doing so your OTRS is up and running.' => 'Po dokonen nsledujcch operac je V OTRS sputn a pob',
      'Have a lot of fun!' => 'Pejeme hodn spch s OTRS!',
      'Restart your webserver' => 'Restartujte V webserver',
      'Start page' => 'vodn strnka',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Abyste mohli pouvat OTRS, muste zadat nsledujc dek do Vaeho pkazovho dku (Terminal/Shell) jako root.',
      'Your OTRS Team' => 'V OTRS tm',

    # Template: InstallerLicense
      'accept license' => 'souhlasm s licenc',
      'don\'t accept license' => 'nesouhlasm s licenc',
      'License' => 'Licence',

    # Template: InstallerStart
      'Create new database' => 'Vytvoit novou databzi',
      'DB Admin Password' => 'Heslo administrtora databze',
      'DB Admin User' => 'Administrtor databze',
      'DB Host' => 'Hostitel (server) databze',
      'DB Type' => 'Typ databze',
      'default \'hot\'' => 'vchoz \'hot\'',
      'Delete old database' => 'Smazat starou databzi',
      'next step' => 'dal krok',
      'OTRS DB connect host' => 'Hostitel OTRS databze (server)',
      'OTRS DB Name' => 'Nzev OTRS databze',
      'OTRS DB Password' => 'Heslo OTRS databze',
      'OTRS DB User' => 'Uivatel OTRS databze',
      'your MySQL DB should have a root password! Default is empty!' => 'Vae MySQL databze by mla mt root heslo! Vchoz je przdn!',

    # Template: InstallerSystem
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kontroluj MX zznamy pouitch emailovch adres pi sestavovn odpovdi. Nepouvejte pokud OTRS server pipojen pomoc vyten linky!)',
      '(Email of the system admin)' => '(Email administrtora systmu)',
      '(Full qualified domain name of your system)' => '(Platn nzev domny pro v systm (FQDN))',
      '(Logfile just needed for File-LogModule!)' => '(Pro logovn do souboru je nutn zadat nzev souboru logu!)',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Identita systmu. Kad slo tiketu a ID kad HTTP relace zan tmto slem)',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identifiktor tiket. Nekte lid chtj nastavit nap. \'Tiket#\',  \'Hovor#\' nebo \'MujTiket#\')',
      '(Used default language)' => '(Pouit vchoz jazyk)',
      '(Used log backend)' => '(Pouit vstup do logu)',
      '(Used ticket number format)' => '(Pouit formt sel tiket)',
      'CheckMXRecord' => 'Kontrolovat MX zznam',
      'Default Charset' => 'Vchoz znakov sada',
      'Default Language' => 'Vchoz jazyk',
      'Logfile' => 'Log soubor',
      'LogModule' => 'Log Modul',
      'Organization' => 'Organizace',
      'System FQDN' => 'Systm FQDN',
      'SystemID' => 'Systmov ID',
      'Ticket Hook' => 'Oznaen tiketu',
      'Ticket Number Generator' => 'Genertor sel tiket',
      'Use utf-8 it your database supports it!' => 'Pouijte utf-8 pokud to Vae databze podporuje',
      'Webfrontend' => 'Webove rozhran',

    # Template: Login

    # Template: LostPassword

    # Template: NoPermission
      'No Permission' => 'dn prva',

    # Template: Notify
      'Info' => 'Info',

    # Template: PrintFooter
      'URL' => 'URL',

    # Template: PrintHeader
      'printed by' => 'tisknuto',

    # Template: QueueView
      'All tickets' => 'Vechny tikety',
      'Page' => 'Strana',
      'Queues' => 'ady',
      'Tickets available' => 'Tiket k dispozici',
      'Tickets shown' => 'Zobrazen tikety',

    # Template: SystemStats
      'Graphs' => 'Grafy',

    # Template: Test
      'OTRS Test Page' => 'Testovac OTRS strnka',

    # Template: TicketEscalation
      'Ticket escalation!' => 'Eskalace tiket',

    # Template: TicketView

    # Template: TicketViewLite
      'Add Note' => 'Pidat poznmku',

    # Template: Warning

    # Misc
      'A message should have a From: recipient!' => 'Zprva by mla obsahovat pole Od: pjemce!',
      'AgentFrontend' => 'Rozhran agent',
      'Article free text' => 'pln text poloky',
      'Change setting' => 'Zmn nastaven',
      'Charset' => 'Znakov sada',
      'Charsets' => 'Znakov sady',
      'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Monosti konfigurace (nap. <OTRS_CONFIG_HttpType>)',
      'Create' => 'Vytvoit',
      'Customer info' => 'Informace o klientovi',
      'CustomerUser' => 'Klient',
      'Fulltext search' => 'Fulltextov vyhledvn',
      'Fulltext search (e. g. "Mar*in" or "Baue*" or "martin+hallo")' => 'Fulltextov vyhledvn (nap. "Mar*in" or "Baue*" or "martin+ahoj")',
      'Handle' => 'Ovldn',
      'In Queue' => 'Ve front',
      'New state' => 'Nov stav',
      'New ticket via call.' => 'Nov tiket pijat telefonem.',
      'New user' => 'Nov uivatel',
      'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_USERFIRSTNAME>)' => 'Volby dat aktulnho klienta (nap. <OTRS_CUSTOMER_DATA_USERFIRSTNAME>)',
      'Options of the current user who requested this action (e. g. <OTRS_CURRENT_USERFIRSTNAME>)' => 'Volby aktulnho klienta, kter poadoval tuto akci (nap. <OTRS_CURRENT_USERFIRSTNAME>)',
      'POP3 Account' => 'POP3 ty',
      'Screen after new phone ticket' => 'Zobrazit po novm telefonnm tiketu',
      'Search in' => 'Hledat v',
      'Select your screen after creating a new ticket via PhoneView.' => 'Vyberte si Vae zobrazen po vytvoen novho tiketu pes telefonn nhled.',
      'Set customer id of a ticket' => 'Nastaven ID klienta na tiketu',
      'Show all' => 'Zobrazit ve',
      'System Charset Management' => 'Sprva znakovch sad v systmu',
      'System Language Management' => 'Sprva jazyk v systmu',
      'Ticket free text' => 'Voln text tiketu',
      'Ticket owner options (e. g. <OTRS_OWNER_USERFIRSTNAME>)' => 'Volby vlastnka tiketu (nap. <OTRS_OWNER_USERFIRSTNAME>)',
      'View Queue' => 'Zobraz frontu',
      'With Priority' => 'S dleitost',
      'With State' => 'Se stavem',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further inforamtions.' => 'V email s slem tiketu "<OTRS_TICKET>" byl odesln zpt "<OTRS_BOUNCE_TO>". Kontaktujte tuto adresu pro dal informace.',
      'auto responses set' => 'sada automatickch odpovd',
      'closed' => 'uzaveno',
      'invalid-temporarily' => 'doasn neplatn',
      'search' => 'hledat',
      'search (e. g. 10*5155 or 105658*)' => 'hledat (nap: 10*5155 nebo 105658*)',
      'store' => 'uloit',
      'tickets' => 'tikety',
      'valid' => 'platn',
    );

    # $$STOP$$
    $Self->{Translation} = \%Hash;
}
# --
1;

